/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationContainerLoweringPass;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\"#$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryCtorLowering;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "constructorProcessorLowering", "Lorg/jetbrains/kotlin/backend/common/DeclarationContainerLoweringPass;", "getConstructorProcessorLowering", "()Lorg/jetbrains/kotlin/backend/common/DeclarationContainerLoweringPass;", "constructorRedirectorLowering", "getConstructorRedirectorLowering", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "oldCtorToNewMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryCtorLowering$ConstructorPair;", "createCreateConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "ctorImpl", "name", "", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "createInitConstructor", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lowerClass", "", "irClass", "updateConstructorDeclarations", "", "CallsiteRedirectionTransformer", "ConstructorPair", "ThisUsageReplaceTransformer", "backend.js"})
public final class SecondaryCtorLowering {
    private final Map<IrConstructorSymbol, ConstructorPair> oldCtorToNewMap;
    @NotNull
    private final DeclarationContainerLoweringPass constructorProcessorLowering;
    @NotNull
    private final DeclarationContainerLoweringPass constructorRedirectorLowering;
    @NotNull
    private final JsIrBackendContext context;

    @NotNull
    public final DeclarationContainerLoweringPass getConstructorProcessorLowering() {
        return this.constructorProcessorLowering;
    }

    @NotNull
    public final DeclarationContainerLoweringPass getConstructorRedirectorLowering() {
        return this.constructorRedirectorLowering;
    }

    private final void updateConstructorDeclarations(IrClass irClass) {
        TransformKt.transformDeclarationsFlat(irClass, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)new Function1<IrDeclaration, List<? extends IrDeclaration>>(this){
            final /* synthetic */ SecondaryCtorLowering this$0;

            @Nullable
            public final List<IrDeclaration> invoke(@NotNull IrDeclaration it) {
                List<IrSimpleFunction> list2;
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (it instanceof IrConstructor) {
                    ConstructorPair constructorPair = (ConstructorPair)SecondaryCtorLowering.access$getOldCtorToNewMap$p(this.this$0).get(((IrConstructor)it).getSymbol());
                    if (constructorPair != null) {
                        ConstructorPair constructorPair2;
                        ConstructorPair $newInit_newCreate = constructorPair2 = constructorPair;
                        IrSimpleFunctionSymbol newInit = $newInit_newCreate.component1();
                        IrSimpleFunctionSymbol newCreate = $newInit_newCreate.component2();
                        list2 = CollectionsKt.listOf((IrSimpleFunction)newInit.getOwner(), (IrSimpleFunction)newCreate.getOwner());
                    } else {
                        list2 = null;
                    }
                } else {
                    list2 = null;
                }
                return list2;
            }
            {
                this.this$0 = secondaryCtorLowering;
                super(1);
            }
        });
    }

    private final List<IrSimpleFunction> lowerClass(IrClass irClass) {
        String string = irClass.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "irClass.name.asString()");
        String className2 = string;
        List oldConstructors = new ArrayList();
        List newConstructors = new ArrayList();
        for (IrDeclaration declaration : irClass.getDeclarations()) {
            if (!(declaration instanceof IrConstructor) || ((IrConstructor)declaration).isPrimary()) continue;
            String constructorName = className2 + "_init";
            IrSimpleFunction newInitConstructor = this.createInitConstructor((IrConstructor)declaration, irClass, constructorName, IrUtilsKt.getDefaultType(irClass));
            IrSimpleFunction newCreateConstructor = this.createCreateConstructor((IrConstructor)declaration, newInitConstructor, constructorName, IrUtilsKt.getDefaultType(irClass));
            Object object = this.oldCtorToNewMap;
            IrFunctionSymbol irFunctionSymbol = ((IrConstructor)declaration).getSymbol();
            ConstructorPair constructorPair = new ConstructorPair((IrSimpleFunctionSymbol)newInitConstructor.getSymbol(), (IrSimpleFunctionSymbol)newCreateConstructor.getSymbol());
            object.put((IrConstructorSymbol)irFunctionSymbol, (ConstructorPair)constructorPair);
            object = oldConstructors;
            object.add(declaration);
            object = newConstructors;
            object.add(newInitConstructor);
            object = newConstructors;
            object.add(newCreateConstructor);
        }
        return newConstructors;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createInitConstructor(IrConstructor declaration, IrClass klass2, String name, IrType type2) {
        Object object;
        Object object2;
        void $receiver$iv$iv;
        IrValueParameter irValueParameter;
        IrSimpleFunction irSimpleFunction;
        IrValueParameter thisParam = JsIrBuilder.INSTANCE.buildValueParameter("$this", declaration.getValueParameters().size(), type2);
        IrValueParameter irValueParameter2 = klass2.getThisReceiver();
        if (irValueParameter2 == null) {
            Intrinsics.throwNpe();
        }
        IrValueParameter oldThisReceiver = irValueParameter2;
        String functionName = name + "_$Init$";
        IrSimpleFunction it = irSimpleFunction = JsIrBuilder.buildFunction$default(JsIrBuilder.INSTANCE, functionName, type2, declaration.getParent(), declaration.getVisibility(), Modality.FINAL, declaration.isInline(), declaration.isExternal(), false, false, null, 896, null);
        IrValueParameter $receiver = irValueParameter = thisParam;
        $receiver.setParent(it);
        IrReturnImpl retStmt = JsIrBuilder.INSTANCE.buildReturn(it.getSymbol(), JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)thisParam.getSymbol()), this.context.getIrBuiltIns().getNothingType());
        IrBody irBody = declaration.getBody();
        if (irBody == null) {
            Intrinsics.throwNpe();
        }
        IrElement $receiver$iv = irBody;
        DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
        IrElementVisitorVoidKt.acceptVoid($receiver$iv, symbolRemapper$iv);
        Object typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
        IrElement irElement = PatchDeclarationParentsKt.patchDeclarationParents($receiver$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv, (TypeRemapper)typeRemapper$iv, null, 4, null), null), it);
        if (irElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBody");
        }
        IrBody irBody2 = (IrBody)irElement;
        if (irBody2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrStatementContainer");
        }
        List<IrStatement> statements = ((IrStatementContainer)((Object)irBody2)).getStatements();
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTypeParametersFrom$default(it, declaration, null, 2, null);
        Iterable $receiver$iv2 = declaration.getValueParameters();
        typeRemapper$iv = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p;
            IrValueParameter irValueParameter3 = (IrValueParameter)item$iv$iv;
            object2 = destination$iv$iv;
            object = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)p, it, 0, 0, 0, null, null, null, null, 254, null);
            object2.add(object);
        }
        List newValueParameters = (List)destination$iv$iv;
        $receiver$iv2 = it.getValueParameters();
        Object object3 = CollectionsKt.plus((Collection)newValueParameters, thisParam);
        CollectionsKt.addAll($receiver$iv2, object3);
        List<IrValueParameter> oldValueParameters = CollectionsKt.plus((Collection)declaration.getValueParameters(), oldThisReceiver);
        object3 = JsIrBuilder.INSTANCE.buildBlockBody(CollectionsKt.plus((Collection)statements, retStmt));
        object2 = it;
        Object $receiver2 = object3;
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)$receiver2, new ThisUsageReplaceTransformer(it.getSymbol(), MapsKt.toMap(CollectionsKt.zip((Iterable)oldValueParameters, (Iterable)it.getValueParameters()))));
        object = object3;
        object2.setBody((IrBody)object);
        return irSimpleFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createCreateConstructor(IrConstructor declaration, IrSimpleFunction ctorImpl, String name, IrType type2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        IrSimpleFunction irSimpleFunction;
        String functionName = name + "_$Create$";
        IrSimpleFunction it = irSimpleFunction = JsIrBuilder.buildFunction$default(JsIrBuilder.INSTANCE, functionName, type2, declaration.getParent(), declaration.getVisibility(), Modality.FINAL, declaration.isInline(), declaration.isExternal(), false, false, null, 896, null);
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTypeParametersFrom$default(it, declaration, null, 2, null);
        Collection collection = it.getValueParameters();
        Iterable iterable = $receiver$iv = (Iterable)declaration.getValueParameters();
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            IrValueParameter irValueParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)p, it, 0, 0, 0, null, null, null, null, 254, null);
            collection2.add(irValueParameter2);
        }
        $receiver$iv = (List)destination$iv$iv;
        CollectionsKt.addAll(collection, $receiver$iv);
        IrSimpleFunction createFunctionIntrinsic = this.context.getIntrinsics().getJsObjectCreate();
        IrCall irCreateCall = JsIrBuilder.INSTANCE.buildCall(createFunctionIntrinsic.getSymbol(), type2, CollectionsKt.listOf(type2));
        Object call2 = destination$iv$iv = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, ctorImpl.getSymbol(), type2, null, 4, null);
        int item$iv$iv = 0;
        int n = it.getValueParameters().size();
        while (item$iv$iv < n) {
            void i;
            call2.putValueArgument((int)i, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)it.getValueParameters().get((int)i).getSymbol()));
            ++i;
        }
        call2.putValueArgument(declaration.getValueParameters().size(), irCreateCall);
        Object irDelegateCall = destination$iv$iv;
        IrReturnImpl irReturn = JsIrBuilder.INSTANCE.buildReturn(it.getSymbol(), (IrExpression)irDelegateCall, this.context.getIrBuiltIns().getNothingType());
        it.setBody(JsIrBuilder.INSTANCE.buildBlockBody(CollectionsKt.listOf(irReturn)));
        return irSimpleFunction;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public SecondaryCtorLowering(@NotNull JsIrBackendContext context) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        SecondaryCtorLowering secondaryCtorLowering = this;
        secondaryCtorLowering.oldCtorToNewMap = map2 = (Map)new LinkedHashMap();
        this.constructorProcessorLowering = new DeclarationContainerLoweringPass(this){
            final /* synthetic */ SecondaryCtorLowering this$0;

            /*
             * WARNING - void declaration
             */
            public void lower(@NotNull IrDeclarationContainer irDeclarationContainer) {
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull(irDeclarationContainer, "irDeclarationContainer");
                Iterable $receiver$iv = irDeclarationContainer.getDeclarations();
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof IrClass)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (E element$iv : $receiver$iv) {
                    IrClass it = (IrClass)element$iv;
                    if (it.isInline()) continue;
                    SecondaryCtorLowering.access$lowerClass(this.this$0, it);
                }
            }
            {
                this.this$0 = $outer;
            }

            public void lower(@NotNull IrFile irFile) {
                Intrinsics.checkParameterIsNotNull(irFile, "irFile");
                DeclarationContainerLoweringPass.DefaultImpls.lower(this, irFile);
            }
        };
        this.constructorRedirectorLowering = new DeclarationContainerLoweringPass(this){
            final /* synthetic */ SecondaryCtorLowering this$0;

            public void lower(@NotNull IrDeclarationContainer irDeclarationContainer) {
                Intrinsics.checkParameterIsNotNull(irDeclarationContainer, "irDeclarationContainer");
                if (irDeclarationContainer instanceof IrClass && !((IrClass)irDeclarationContainer).isInline()) {
                    SecondaryCtorLowering.access$updateConstructorDeclarations(this.this$0, (IrClass)irDeclarationContainer);
                }
                for (IrDeclaration it : irDeclarationContainer.getDeclarations()) {
                    it.accept(this.this$0.new CallsiteRedirectionTransformer(), null);
                }
            }
            {
                this.this$0 = $outer;
            }

            public void lower(@NotNull IrFile irFile) {
                Intrinsics.checkParameterIsNotNull(irFile, "irFile");
                DeclarationContainerLoweringPass.DefaultImpls.lower(this, irFile);
            }
        };
    }

    public static final /* synthetic */ List access$lowerClass(SecondaryCtorLowering $this, IrClass irClass) {
        return $this.lowerClass(irClass);
    }

    public static final /* synthetic */ void access$updateConstructorDeclarations(SecondaryCtorLowering $this, IrClass irClass) {
        $this.updateConstructorDeclarations(irClass);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryCtorLowering$ConstructorPair;", "", "delegate", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "stub", "(Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;)V", "getDelegate", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getStub", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "backend.js"})
    public static final class ConstructorPair {
        @NotNull
        private final IrSimpleFunctionSymbol delegate;
        @NotNull
        private final IrSimpleFunctionSymbol stub;

        @NotNull
        public final IrSimpleFunctionSymbol getDelegate() {
            return this.delegate;
        }

        @NotNull
        public final IrSimpleFunctionSymbol getStub() {
            return this.stub;
        }

        public ConstructorPair(@NotNull IrSimpleFunctionSymbol delegate, @NotNull IrSimpleFunctionSymbol stub) {
            Intrinsics.checkParameterIsNotNull(delegate, "delegate");
            Intrinsics.checkParameterIsNotNull(stub, "stub");
            this.delegate = delegate;
            this.stub = stub;
        }

        @NotNull
        public final IrSimpleFunctionSymbol component1() {
            return this.delegate;
        }

        @NotNull
        public final IrSimpleFunctionSymbol component2() {
            return this.stub;
        }

        @NotNull
        public final ConstructorPair copy(@NotNull IrSimpleFunctionSymbol delegate, @NotNull IrSimpleFunctionSymbol stub) {
            Intrinsics.checkParameterIsNotNull(delegate, "delegate");
            Intrinsics.checkParameterIsNotNull(stub, "stub");
            return new ConstructorPair(delegate, stub);
        }

        @NotNull
        public static /* synthetic */ ConstructorPair copy$default(ConstructorPair constructorPair, IrSimpleFunctionSymbol irSimpleFunctionSymbol, IrSimpleFunctionSymbol irSimpleFunctionSymbol2, int n, Object object) {
            if ((n & 1) != 0) {
                irSimpleFunctionSymbol = constructorPair.delegate;
            }
            if ((n & 2) != 0) {
                irSimpleFunctionSymbol2 = constructorPair.stub;
            }
            return constructorPair.copy(irSimpleFunctionSymbol, irSimpleFunctionSymbol2);
        }

        @NotNull
        public String toString() {
            return "ConstructorPair(delegate=" + this.delegate + ", stub=" + this.stub + ")";
        }

        public int hashCode() {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.delegate;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = this.stub;
            return (irSimpleFunctionSymbol != null ? irSimpleFunctionSymbol.hashCode() : 0) * 31 + (irSimpleFunctionSymbol2 != null ? irSimpleFunctionSymbol2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ConstructorPair)) break block3;
                    ConstructorPair constructorPair = (ConstructorPair)object;
                    if (!Intrinsics.areEqual(this.delegate, constructorPair.delegate) || !Intrinsics.areEqual(this.stub, constructorPair.stub)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryCtorLowering$ThisUsageReplaceTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "function", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "symbolMapping", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "(Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;Ljava/util/Map;)V", "getFunction", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "newThisSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "getNewThisSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "getSymbolMapping", "()Ljava/util/Map;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "backend.js"})
    private static final class ThisUsageReplaceTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final IrValueParameterSymbol newThisSymbol;
        @NotNull
        private final IrFunctionSymbol function;
        @NotNull
        private final Map<IrValueParameter, IrValueParameter> symbolMapping;

        @NotNull
        public final IrValueParameterSymbol getNewThisSymbol() {
            return this.newThisSymbol;
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return new IrReturnImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), this.function, (IrExpression)new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), ((IrValueParameter)this.newThisSymbol.getOwner()).getType(), this.newThisSymbol, null, 16, null));
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
            IrGetValue irGetValue;
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            Map<IrValueParameter, IrValueParameter> map2 = this.symbolMapping;
            IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
            Map<IrValueParameter, IrValueParameter> map3 = map2;
            if (map3.containsKey(irValueDeclaration)) {
                IrValueParameter irValueParameter;
                map2 = this.symbolMapping;
                irValueDeclaration = expression2.getSymbol().getOwner();
                IrType irType = expression2.getType();
                int n = expression2.getEndOffset();
                int n2 = expression2.getStartOffset();
                IrValueParameter irValueParameter2 = irValueParameter = map2.get(irValueDeclaration);
                if (irValueParameter2 == null) {
                    Intrinsics.throwNpe();
                }
                IrStatementOrigin irStatementOrigin = expression2.getOrigin();
                Object s = irValueParameter2.getSymbol();
                IrType irType2 = irType;
                int n3 = n;
                int n4 = n2;
                irGetValue = new IrGetValueImpl(n4, n3, irType2, (IrValueSymbol)s, irStatementOrigin);
            } else {
                irGetValue = expression2;
            }
            return irGetValue;
        }

        @NotNull
        public final IrFunctionSymbol getFunction() {
            return this.function;
        }

        @NotNull
        public final Map<IrValueParameter, IrValueParameter> getSymbolMapping() {
            return this.symbolMapping;
        }

        public ThisUsageReplaceTransformer(@NotNull IrFunctionSymbol function2, @NotNull Map<IrValueParameter, ? extends IrValueParameter> symbolMapping) {
            Intrinsics.checkParameterIsNotNull(function2, "function");
            Intrinsics.checkParameterIsNotNull(symbolMapping, "symbolMapping");
            this.function = function2;
            this.symbolMapping = symbolMapping;
            this.newThisSymbol = (IrValueParameterSymbol)((IrValueParameter)CollectionsKt.last((Iterable)this.symbolMapping.values())).getSymbol();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryCtorLowering$CallsiteRedirectionTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryCtorLowering;)V", "redirectCall", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "newTarget", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "visitCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "backend.js"})
    public final class CallsiteRedirectionTransformer
    implements IrElementTransformer<IrFunction> {
        @Override
        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, declaration);
        }

        @Override
        @NotNull
        public IrElement visitCall(@NotNull IrCall expression2, @Nullable IrFunction data2) {
            ConstructorPair ctor;
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementTransformer.DefaultImpls.visitCall(this, expression2, data2);
            IrFunction target = expression2.getSymbol().getOwner();
            if (target instanceof IrConstructor && !((IrConstructor)target).isPrimary() && (ctor = (ConstructorPair)SecondaryCtorLowering.this.oldCtorToNewMap.get(((IrConstructor)target).getSymbol())) != null) {
                return this.redirectCall(expression2, ctor.getStub());
            }
            return expression2;
        }

        @Override
        @NotNull
        public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable IrFunction data2) {
            IrGetValueImpl irGetValueImpl;
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
            IrConstructorSymbol target = expression2.getSymbol();
            if (((IrConstructor)target.getOwner()).isPrimary()) {
                return expression2;
            }
            IrFunction irFunction = data2;
            if (irFunction == null) {
                Intrinsics.throwNpe();
            }
            boolean fromPrimary = irFunction instanceof IrConstructor;
            ConstructorPair constructorPair = (ConstructorPair)SecondaryCtorLowering.this.oldCtorToNewMap.get(target);
            if (constructorPair == null) {
                return expression2;
            }
            ConstructorPair ctor = constructorPair;
            IrCallImpl newCall = this.redirectCall(expression2, ctor.getDelegate());
            if (fromPrimary) {
                IrDeclarationParent irDeclarationParent = ((IrConstructor)expression2.getSymbol().getOwner()).getParent();
                if (irDeclarationParent == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                }
                IrClass thisKlass = (IrClass)irDeclarationParent;
                IrValueParameter irValueParameter = thisKlass.getThisReceiver();
                if (irValueParameter == null) {
                    Intrinsics.throwNpe();
                }
                IrValueParameterSymbol thisSymbol = (IrValueParameterSymbol)irValueParameter.getSymbol();
                irGetValueImpl = new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), thisSymbol, null, 16, null);
            } else {
                irGetValueImpl = new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), (IrValueSymbol)CollectionsKt.last(data2.getValueParameters()).getSymbol(), null, 16, null);
            }
            IrGetValueImpl readThis = irGetValueImpl;
            newCall.putValueArgument(expression2.getValueArgumentsCount(), readThis);
            return newCall;
        }

        /*
         * WARNING - void declaration
         */
        private final IrCallImpl redirectCall(IrFunctionAccessExpression call2, IrSimpleFunctionSymbol newTarget) {
            IrCallImpl irCallImpl;
            IrCallImpl $receiver = irCallImpl = new IrCallImpl(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), newTarget);
            int n = 0;
            int n2 = call2.getValueArgumentsCount();
            while (n < n2) {
                void i;
                $receiver.putValueArgument((int)i, call2.getValueArgument((int)i));
                ++i;
            }
            return irCallImpl;
        }

        @Override
        @NotNull
        public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrBody visitBlockBody(@NotNull IrBlockBody body, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            return IrElementTransformer.DefaultImpls.visitBlockBody(this, body, data2);
        }

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            return IrElementTransformer.DefaultImpls.visitBody(this, body, data2);
        }

        @Override
        @NotNull
        public IrBranch visitBranch(@NotNull IrBranch branch, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(branch, "branch");
            return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data2);
        }

        @Override
        @NotNull
        public IrExpression visitBreak(@NotNull IrBreak jump, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data2);
        }

        @Override
        @NotNull
        public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data2);
        }

        @Override
        @NotNull
        public IrElement visitCallableReference(@NotNull IrCallableReference expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrCatch visitCatch(@NotNull IrCatch aCatch, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(aCatch, "aCatch");
            return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data2);
        }

        @Override
        @NotNull
        public IrStatement visitClass(@NotNull IrClass declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitClass(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrExpression visitClassReference(@NotNull IrClassReference expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitComposite(@NotNull IrComposite expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data2);
        }

        @Override
        @NotNull
        public <T> IrExpression visitConst(@NotNull IrConst<T> expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitConstructor(@NotNull IrConstructor declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitContinue(@NotNull IrContinue jump, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data2);
        }

        @Override
        @NotNull
        public IrStatement visitDeclaration(@NotNull IrDeclaration declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(loop2, "loop");
            return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
        }

        @Override
        @NotNull
        public IrElement visitElement(@NotNull IrElement element, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            return IrElementTransformer.DefaultImpls.visitElement(this, element, data2);
        }

        @Override
        @NotNull
        public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(branch, "branch");
            return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data2);
        }

        @Override
        @NotNull
        public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitExpression(@NotNull IrExpression expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrBody visitExpressionBody(@NotNull IrExpressionBody body, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body, data2);
        }

        @Override
        @NotNull
        public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitField(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrFile visitFile(@NotNull IrFile declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitGetClass(@NotNull IrGetClass expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitLoop(@NotNull IrLoop loop2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(loop2, "loop");
            return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data2);
        }

        @Override
        @NotNull
        public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrStatement visitProperty(@NotNull IrProperty declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSetField(@NotNull IrSetField expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSetVariable(@NotNull IrSetVariable expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitSetVariable(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(spread, "spread");
            return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data2);
        }

        @Override
        @NotNull
        public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body, data2);
        }

        @Override
        @NotNull
        public IrExpression visitThrow(@NotNull IrThrow expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitTry(@NotNull IrTry aTry, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(aTry, "aTry");
            return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data2);
        }

        @Override
        @NotNull
        public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrExpression visitVararg(@NotNull IrVararg expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data2);
        }

        @Override
        @NotNull
        public IrExpression visitWhen(@NotNull IrWhen expression2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable IrFunction data2) {
            Intrinsics.checkParameterIsNotNull(loop2, "loop");
            return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data2);
        }
    }
}

