/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import gnu.trove.THashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.AbstractBundle;
import org.jetbrains.kotlin.com.intellij.CommonBundle;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.ide.plugins.HelpSetPath;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.ide.plugins.OptimizedPluginBean;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginDependency;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginHelpSet;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.ide.plugins.ProductDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.components.ComponentConfig;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import org.jetbrains.kotlin.com.intellij.openapi.util.InvalidDataException;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.NullableLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.xmlb.JDOMXIncluder;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializer;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.JDOMException;

public class IdeaPluginDescriptorImpl
implements IdeaPluginDescriptor {
    public static final IdeaPluginDescriptorImpl[] EMPTY_ARRAY = new IdeaPluginDescriptorImpl[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.plugins.PluginDescriptor");
    private final File myPath;
    private final boolean myBundled;
    private final NullableLazyValue<String> myDescription;
    private String myName;
    private PluginId myId;
    @Nullable
    private String myProductCode;
    @Nullable
    private Date myReleaseDate;
    private int myReleaseVersion;
    private String myResourceBundleBaseName;
    private String myChangeNotes;
    private String myVersion;
    private String myVendor;
    private String myVendorEmail;
    private String myVendorUrl;
    private String myVendorLogoPath;
    private String myCategory;
    private String myUrl;
    private PluginId[] myDependencies;
    private PluginId[] myOptionalDependencies;
    private Map<PluginId, List<String>> myOptionalConfigs;
    private Map<PluginId, List<IdeaPluginDescriptorImpl>> myOptionalDescriptors;
    @Nullable
    private List<Element> myActionElements;
    private ComponentConfig[] myAppComponents;
    private ComponentConfig[] myProjectComponents;
    private ComponentConfig[] myModuleComponents;
    private ClassLoader myLoader;
    private HelpSetPath[] myHelpSets;
    @Nullable
    private MultiMap<String, Element> myExtensions;
    @Nullable
    private MultiMap<String, Element> myExtensionsPoints;
    private String myDescriptionChildText;
    private boolean myUseIdeaClassLoader;
    private boolean myUseCoreClassLoader;
    private boolean myAllowBundledUpdate;
    private boolean myEnabled;
    private String mySinceBuild;
    private String myUntilBuild;
    private List<String> myModules;
    public static final Pattern EXPLICIT_BIG_NUMBER_PATTERN = Pattern.compile("(.*)\\.(9{4,}+|10{4,}+)");

    public IdeaPluginDescriptorImpl(@NotNull File pluginPath, boolean bundled) {
        if (pluginPath == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(0);
        }
        this.myDescription = new NullableLazyValue<String>(){

            @Override
            protected String compute() {
                return IdeaPluginDescriptorImpl.this.computeDescription();
            }
        };
        this.myDependencies = PluginId.EMPTY_ARRAY;
        this.myOptionalDependencies = PluginId.EMPTY_ARRAY;
        this.myEnabled = true;
        this.myPath = pluginPath;
        this.myBundled = bundled;
    }

    private static String createDescriptionKey(PluginId id) {
        return "plugin." + id + ".description";
    }

    private static ComponentConfig[] mergeComponents(ComponentConfig[] first2, ComponentConfig[] second) {
        if (first2 == null) {
            return second;
        }
        if (second == null) {
            return first2;
        }
        return ArrayUtil.mergeArrays(first2, second);
    }

    @Override
    public File getPath() {
        return this.myPath;
    }

    public void readExternal(@NotNull Element element, @NotNull URL url, @NotNull JDOMXIncluder.PathResolver pathResolver) throws InvalidDataException {
        Application application;
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(1);
        }
        if (url == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(2);
        }
        if (pathResolver == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(3);
        }
        this.readExternal(element, url, (application = ApplicationManager.getApplication()) != null && application.isUnitTestMode(), pathResolver);
    }

    public void readExternal(@NotNull Element element, @NotNull URL url, boolean ignoreMissingInclude, @NotNull JDOMXIncluder.PathResolver pathResolver) throws InvalidDataException {
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(4);
        }
        if (url == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(5);
        }
        if (pathResolver == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(6);
        }
        if (JDOMUtil.isEmpty(element)) {
            return;
        }
        JDOMXIncluder.resolveNonXIncludeElement(element, url.toExternalForm(), ignoreMissingInclude, pathResolver);
        this.readExternal(JDOMUtil.internElement(element));
    }

    public void readExternal(@NotNull URL url) throws InvalidDataException, FileNotFoundException {
        if (url == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(7);
        }
        try {
            this.readExternal(JDOMUtil.load(url), url, JDOMXIncluder.DEFAULT_PATH_RESOLVER);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException | JDOMException e) {
            throw new InvalidDataException(e);
        }
    }

    protected void readExternal(@NotNull Element element) {
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(8);
        }
        OptimizedPluginBean pluginBean = XmlSerializer.deserialize(element, OptimizedPluginBean.class);
        this.myUrl = pluginBean.url;
        String idString = StringUtil.nullize(pluginBean.id, true);
        String nameString = StringUtil.nullize(pluginBean.name, true);
        this.myId = idString != null ? PluginId.getId(idString) : (nameString != null ? PluginId.getId(nameString) : null);
        this.myName = ObjectUtils.chooseNotNull(nameString, idString);
        ProductDescriptor pd = pluginBean.productDescriptor;
        this.myProductCode = pd != null ? pd.code : null;
        this.myReleaseDate = IdeaPluginDescriptorImpl.parseReleaseDate(pluginBean);
        this.myReleaseVersion = pd != null ? pd.releaseVersion : 0;
        String internalVersionString = pluginBean.formatVersion;
        if (internalVersionString != null) {
            try {
                Integer.parseInt(internalVersionString);
            }
            catch (NumberFormatException e) {
                LOG.error(new PluginException("Invalid value in plugin.xml format version: '" + internalVersionString + "'", e, this.myId));
            }
        }
        this.myUseIdeaClassLoader = pluginBean.useIdeaClassLoader;
        this.myAllowBundledUpdate = pluginBean.allowBundledUpdate;
        if (pluginBean.ideaVersion != null) {
            this.mySinceBuild = pluginBean.ideaVersion.sinceBuild;
            this.myUntilBuild = IdeaPluginDescriptorImpl.convertExplicitBigNumberInUntilBuildToStar(pluginBean.ideaVersion.untilBuild);
        }
        this.myResourceBundleBaseName = pluginBean.resourceBundle;
        this.myDescriptionChildText = pluginBean.description;
        this.myChangeNotes = pluginBean.changeNotes;
        this.myVersion = pluginBean.pluginVersion;
        if (this.myVersion == null) {
            this.myVersion = PluginManagerCore.getBuildNumber().asStringWithoutProductCode();
        }
        this.myCategory = pluginBean.category;
        if (pluginBean.vendor != null) {
            this.myVendor = pluginBean.vendor.name;
            this.myVendorEmail = pluginBean.vendor.email;
            this.myVendorUrl = pluginBean.vendor.url;
            this.myVendorLogoPath = pluginBean.vendor.logo;
        }
        LinkedHashSet<PluginId> dependentPlugins = new LinkedHashSet<PluginId>();
        LinkedHashSet<PluginId> optionalDependentPlugins = new LinkedHashSet<PluginId>();
        if (pluginBean.dependencies != null) {
            this.myOptionalConfigs = new THashMap<PluginId, List<String>>();
            for (PluginDependency dependency : pluginBean.dependencies) {
                String text2 = dependency.pluginId;
                if (StringUtil.isEmptyOrSpaces(text2)) continue;
                PluginId id = PluginId.getId(text2);
                dependentPlugins.add(id);
                if (!dependency.optional) continue;
                optionalDependentPlugins.add(id);
                if (StringUtil.isEmptyOrSpaces(dependency.configFile)) continue;
                this.myOptionalConfigs.computeIfAbsent(id, it -> new SmartList()).add(dependency.configFile);
            }
        }
        this.myDependencies = dependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : dependentPlugins.toArray(PluginId.EMPTY_ARRAY);
        PluginId[] pluginIdArray = this.myOptionalDependencies = optionalDependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : optionalDependentPlugins.toArray(PluginId.EMPTY_ARRAY);
        if (pluginBean.helpSets == null || pluginBean.helpSets.length == 0) {
            this.myHelpSets = HelpSetPath.EMPTY;
        } else {
            this.myHelpSets = new HelpSetPath[pluginBean.helpSets.length];
            for (PluginHelpSet pluginHelpSet : pluginBean.helpSets) {
                this.myHelpSets[i] = new HelpSetPath(pluginHelpSet.file, pluginHelpSet.path);
            }
        }
        this.myAppComponents = pluginBean.applicationComponents;
        this.myProjectComponents = pluginBean.projectComponents;
        this.myModuleComponents = pluginBean.moduleComponents;
        if (this.myAppComponents == null) {
            this.myAppComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if (this.myProjectComponents == null) {
            this.myProjectComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if (this.myModuleComponents == null) {
            this.myModuleComponents = ComponentConfig.EMPTY_ARRAY;
        }
        block14: for (Content content : element.getContent()) {
            if (!(content instanceof Element)) continue;
            Element child = (Element)content;
            switch (child.getName()) {
                case "extensions": {
                    if (this.myExtensions == null) {
                        this.myExtensions = MultiMap.createSmart();
                    }
                    String ns = child.getAttributeValue("defaultExtensionNs");
                    for (Element extension : child.getChildren()) {
                        this.myExtensions.putValue(ExtensionsAreaImpl.extractEPName(extension, ns), extension);
                    }
                    continue block14;
                }
                case "extensionPoints": {
                    if (this.myExtensionsPoints == null) {
                        this.myExtensionsPoints = MultiMap.createSmart();
                    }
                    for (Element extensionPoint : child.getChildren()) {
                        this.myExtensionsPoints.putValue(StringUtilRt.notNullize(extensionPoint.getAttributeValue("area")), extensionPoint);
                    }
                    continue block14;
                }
                case "actions": {
                    if (this.myActionElements == null) {
                        this.myActionElements = new ArrayList<Element>(child.getChildren());
                        break;
                    }
                    this.myActionElements.addAll(child.getChildren());
                }
            }
        }
        if (pluginBean.modules != null && !pluginBean.modules.isEmpty()) {
            this.myModules = pluginBean.modules;
        }
    }

    @Nullable
    private static Date parseReleaseDate(@NotNull OptimizedPluginBean bean) {
        ProductDescriptor pd;
        String dateStr;
        if (bean == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(9);
        }
        String string = dateStr = (pd = bean.productDescriptor) != null ? pd.releaseDate : null;
        if (dateStr != null) {
            try {
                return new SimpleDateFormat("yyyyMMdd", Locale.US).parse(dateStr);
            }
            catch (ParseException e) {
                LOG.info("Error parse release date from plugin descriptor for plugin " + bean.name + " {" + bean.id + "}: " + e.getMessage());
            }
        }
        return null;
    }

    public static String convertExplicitBigNumberInUntilBuildToStar(@Nullable String build2) {
        if (build2 == null) {
            return null;
        }
        Matcher matcher = EXPLICIT_BIG_NUMBER_PATTERN.matcher(build2);
        if (matcher.matches()) {
            return matcher.group(1) + ".*";
        }
        return build2;
    }

    public void registerExtensionPoints(@NotNull ExtensionsArea area) {
        if (area == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(10);
        }
        if (this.myExtensionsPoints != null) {
            for (Element element : this.myExtensionsPoints.get(StringUtil.notNullize(area.getAreaClass()))) {
                area.registerExtensionPoint(this, element);
            }
        }
    }

    public void registerExtensions(@NotNull ExtensionsArea area, @NotNull ExtensionPoint<?> extensionPoint) {
        if (area == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(13);
        }
        if (extensionPoint == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(14);
        }
        if (this.myExtensions == null) {
            return;
        }
        Collection<Element> elements = this.myExtensions.get(extensionPoint.getName());
        if (elements.isEmpty()) {
            return;
        }
        for (Element element : elements) {
            area.registerExtension(extensionPoint, this, element);
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public PluginId[] getDependentPluginIds() {
        if (this.myDependencies == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(15);
        }
        return this.myDependencies;
    }

    @Override
    @NotNull
    public PluginId[] getOptionalDependentPluginIds() {
        if (this.myOptionalDependencies == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(16);
        }
        return this.myOptionalDependencies;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public String getCategory() {
        return this.myCategory;
    }

    @NotNull
    public List<File> getClassPath() {
        if (this.myPath.isDirectory()) {
            File[] files2;
            ArrayList<File> result2 = new ArrayList<File>();
            File classesDir = new File(this.myPath, "classes");
            if (classesDir.exists()) {
                result2.add(classesDir);
            }
            if ((files2 = new File(this.myPath, "lib").listFiles()) != null && files2.length > 0) {
                for (File f : files2) {
                    if (f.isFile()) {
                        String name = f.getName();
                        if (!StringUtil.endsWithIgnoreCase(name, ".jar") && !StringUtil.endsWithIgnoreCase(name, ".zip")) continue;
                        result2.add(f);
                        continue;
                    }
                    result2.add(f);
                }
            }
            ArrayList<File> arrayList = result2;
            if (arrayList == null) {
                IdeaPluginDescriptorImpl.$$$reportNull$$$0(17);
            }
            return arrayList;
        }
        List<File> list2 = Collections.singletonList(this.myPath);
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(18);
        }
        return list2;
    }

    public String toString() {
        return "PluginDescriptor[name='" + this.myName + "', classpath='" + this.myPath + "']";
    }

    public void setLoader(ClassLoader loader) {
        this.myLoader = loader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeaPluginDescriptorImpl)) {
            return false;
        }
        IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)o;
        return this.myName == null ? pluginDescriptor.myName == null : this.myName.equals(pluginDescriptor.myName);
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    @Override
    public PluginId getPluginId() {
        return this.myId;
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        return this.myLoader != null ? this.myLoader : this.getClass().getClassLoader();
    }

    @Override
    public boolean getUseIdeaClassLoader() {
        return this.myUseIdeaClassLoader;
    }

    boolean isUseCoreClassLoader() {
        return this.myUseCoreClassLoader;
    }

    void setUseCoreClassLoader(boolean useCoreClassLoader) {
        this.myUseCoreClassLoader = useCoreClassLoader;
    }

    private String computeDescription() {
        ResourceBundle bundle = null;
        if (this.myResourceBundleBaseName != null) {
            try {
                bundle = AbstractBundle.getResourceBundle(this.myResourceBundleBaseName, this.getPluginClassLoader());
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot find plugin " + this.myId + " resource-bundle: " + this.myResourceBundleBaseName);
            }
        }
        if (bundle == null) {
            return this.myDescriptionChildText;
        }
        return CommonBundle.messageOrDefault(bundle, IdeaPluginDescriptorImpl.createDescriptionKey(this.myId), this.myDescriptionChildText == null ? "" : this.myDescriptionChildText, new Object[0]);
    }

    void insertDependency(@NotNull IdeaPluginDescriptor d) {
        if (d == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(23);
        }
        PluginId[] deps = new PluginId[this.getDependentPluginIds().length + 1];
        deps[0] = d.getPluginId();
        System.arraycopy(this.myDependencies, 0, deps, 1, deps.length - 1);
        this.myDependencies = deps;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    public String getSinceBuild() {
        return this.mySinceBuild;
    }

    @Override
    public String getUntilBuild() {
        return this.myUntilBuild;
    }

    Map<PluginId, List<String>> getOptionalConfigs() {
        return this.myOptionalConfigs;
    }

    Map<PluginId, List<IdeaPluginDescriptorImpl>> getOptionalDescriptors() {
        return this.myOptionalDescriptors;
    }

    void setOptionalDescriptors(@NotNull Map<PluginId, List<IdeaPluginDescriptorImpl>> optionalDescriptors) {
        if (optionalDescriptors == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(24);
        }
        this.myOptionalDescriptors = optionalDescriptors;
    }

    void mergeOptionalConfig(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(25);
        }
        if (this.myExtensions == null) {
            this.myExtensions = descriptor2.myExtensions;
        } else if (descriptor2.myExtensions != null) {
            this.myExtensions.putAllValues(descriptor2.myExtensions);
        }
        if (this.myExtensionsPoints == null) {
            this.myExtensionsPoints = descriptor2.myExtensionsPoints;
        } else if (descriptor2.myExtensionsPoints != null) {
            this.myExtensionsPoints.putAllValues(descriptor2.myExtensionsPoints);
        }
        if (this.myActionElements == null) {
            this.myActionElements = descriptor2.myActionElements;
        } else if (descriptor2.myActionElements != null) {
            this.myActionElements.addAll(descriptor2.myActionElements);
        }
        this.myAppComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myAppComponents, descriptor2.myAppComponents);
        this.myProjectComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myProjectComponents, descriptor2.myProjectComponents);
        this.myModuleComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myModuleComponents, descriptor2.myModuleComponents);
    }

    @Override
    public boolean isBundled() {
        return this.myBundled;
    }

    @Nullable
    public List<String> getModules() {
        return this.myModules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginPath";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionalDescriptors";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentPluginIds";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalDependentPluginIds";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppComponents";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectComponents";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleComponents";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseReleaseDate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoints";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "insertDependency";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setOptionalDescriptors";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

