/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.TypedNode;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.internal.Utils;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import java.util.List;

public final class ArrayCreationExpr
extends Expression
implements TypedNode {
    private Type type;
    private int arrayCount;
    private ArrayInitializerExpr initializer;
    private List<Expression> dimensions;
    private List<List<AnnotationExpr>> arraysAnnotations;

    public ArrayCreationExpr() {
    }

    public ArrayCreationExpr(Type type2, int arrayCount, ArrayInitializerExpr initializer2) {
        this.setType(type2);
        this.setArrayCount(arrayCount);
        this.setInitializer(initializer2);
        this.setDimensions(null);
    }

    @Deprecated
    public ArrayCreationExpr(int beginLine, int beginColumn, int endLine, int endColumn, Type type2, int arrayCount, ArrayInitializerExpr initializer2) {
        this(new Range(Position.pos(beginLine, beginColumn), Position.pos(endLine, endColumn)), type2, arrayCount, initializer2);
    }

    public ArrayCreationExpr(Range range, Type type2, int arrayCount, ArrayInitializerExpr initializer2) {
        super(range);
        this.setType(type2);
        this.setArrayCount(arrayCount);
        this.setInitializer(initializer2);
        this.setDimensions(null);
    }

    public ArrayCreationExpr(Type type2, List<Expression> dimensions, int arrayCount) {
        this.setType(type2);
        this.setArrayCount(arrayCount);
        this.setDimensions(dimensions);
        this.setInitializer(null);
    }

    @Deprecated
    public ArrayCreationExpr(int beginLine, int beginColumn, int endLine, int endColumn, Type type2, List<Expression> dimensions, int arrayCount) {
        this(new Range(Position.pos(beginLine, beginColumn), Position.pos(endLine, endColumn)), type2, dimensions, arrayCount);
    }

    public ArrayCreationExpr(Range range, Type type2, List<Expression> dimensions, int arrayCount) {
        super(range);
        this.setType(type2);
        this.setArrayCount(arrayCount);
        this.setDimensions(dimensions);
        this.setInitializer(null);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v2, A arg) {
        return v2.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v2, A arg) {
        v2.visit(this, arg);
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public List<Expression> getDimensions() {
        this.dimensions = Utils.ensureNotNull(this.dimensions);
        return this.dimensions;
    }

    public ArrayInitializerExpr getInitializer() {
        return this.initializer;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
    }

    public void setDimensions(List<Expression> dimensions) {
        this.dimensions = dimensions;
        this.setAsParentNodeOf(this.dimensions);
    }

    public void setInitializer(ArrayInitializerExpr initializer2) {
        this.initializer = initializer2;
        this.setAsParentNodeOf(this.initializer);
    }

    @Override
    public void setType(Type type2) {
        this.type = type2;
        this.setAsParentNodeOf(this.type);
    }

    public List<List<AnnotationExpr>> getArraysAnnotations() {
        this.arraysAnnotations = Utils.ensureNotNull(this.arraysAnnotations);
        return this.arraysAnnotations;
    }

    public void setArraysAnnotations(List<List<AnnotationExpr>> arraysAnnotations) {
        this.arraysAnnotations = arraysAnnotations;
    }
}

