/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.DumpVisitor;
import com.github.javaparser.ast.visitor.EqualsVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import java.util.LinkedList;
import java.util.List;

public abstract class Node
implements Cloneable {
    private Range range;
    private Node parentNode;
    private List<Node> childrenNodes = new LinkedList<Node>();
    private List<Comment> orphanComments = new LinkedList<Comment>();
    private Object data;
    private Comment comment;
    public static final int ABSOLUTE_BEGIN_LINE = -1;
    public static final int ABSOLUTE_END_LINE = -2;

    public Node() {
        this(Range.UNKNOWN);
    }

    @Deprecated
    public Node(int beginLine, int beginColumn, int endLine, int endColumn) {
        this(new Range(Position.pos(beginLine, beginColumn), Position.pos(endLine, endColumn)));
    }

    public Node(Range range) {
        this.range = range;
    }

    public abstract <R, A> R accept(GenericVisitor<R, A> var1, A var2);

    public abstract <A> void accept(VoidVisitor<A> var1, A var2);

    @Deprecated
    public final int getBeginColumn() {
        return this.range.begin.column;
    }

    @Deprecated
    public final int getBeginLine() {
        return this.range.begin.line;
    }

    public final Comment getComment() {
        return this.comment;
    }

    public final Object getData() {
        return this.data;
    }

    @Deprecated
    public final int getEndColumn() {
        return this.range.end.column;
    }

    @Deprecated
    public final int getEndLine() {
        return this.range.end.line;
    }

    @Deprecated
    public final void setBeginColumn(int beginColumn) {
        this.range = this.range.withBeginColumn(beginColumn);
    }

    @Deprecated
    public final void setBeginLine(int beginLine) {
        this.range = this.range.withBeginLine(beginLine);
    }

    public Position getBegin() {
        return this.range.begin;
    }

    public Position getEnd() {
        return this.range.end;
    }

    public void setBegin(Position begin) {
        this.range = this.range.withBegin(begin);
    }

    public void setEnd(Position end) {
        this.range = this.range.withEnd(end);
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public final void setComment(Comment comment) {
        if (comment != null && this instanceof Comment) {
            throw new RuntimeException("A comment can not be commented");
        }
        if (this.comment != null) {
            this.comment.setCommentedNode(null);
        }
        this.comment = comment;
        if (comment != null) {
            this.comment.setCommentedNode(this);
        }
    }

    public final void setData(Object data2) {
        this.data = data2;
    }

    @Deprecated
    public final void setEndColumn(int endColumn) {
        this.range = this.range.withEndColumn(endColumn);
    }

    @Deprecated
    public final void setEndLine(int endLine) {
        this.range = this.range.withEndLine(endLine);
    }

    public final String toString() {
        DumpVisitor visitor2 = new DumpVisitor();
        this.accept(visitor2, null);
        return visitor2.getSource();
    }

    public final String toStringWithoutComments() {
        DumpVisitor visitor2 = new DumpVisitor(false);
        this.accept(visitor2, null);
        return visitor2.getSource();
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Node)) {
            return false;
        }
        return EqualsVisitor.equals(this, (Node)obj);
    }

    public Node clone() {
        return this.accept(new CloneVisitor(), null);
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public List<Node> getChildrenNodes() {
        return this.childrenNodes;
    }

    public boolean contains(Node other) {
        return this.range.contains(other.range);
    }

    public void addOrphanComment(Comment comment) {
        this.orphanComments.add(comment);
        comment.setParentNode(this);
    }

    public List<Comment> getOrphanComments() {
        return this.orphanComments;
    }

    public List<Comment> getAllContainedComments() {
        LinkedList<Comment> comments = new LinkedList<Comment>();
        comments.addAll(this.getOrphanComments());
        for (Node child : this.getChildrenNodes()) {
            if (child.getComment() != null) {
                comments.add(child.getComment());
            }
            comments.addAll(child.getAllContainedComments());
        }
        return comments;
    }

    public void setParentNode(Node parentNode) {
        if (this.parentNode != null) {
            this.parentNode.childrenNodes.remove(this);
        }
        this.parentNode = parentNode;
        if (this.parentNode != null) {
            this.parentNode.childrenNodes.add(this);
        }
    }

    protected void setAsParentNodeOf(List<? extends Node> childNodes) {
        if (childNodes != null) {
            for (Node node : childNodes) {
                node.setParentNode(this);
            }
        }
    }

    protected void setAsParentNodeOf(Node childNode) {
        if (childNode != null) {
            childNode.setParentNode(this);
        }
    }

    @Deprecated
    public boolean isPositionedAfter(int line, int column) {
        return this.range.isAfter(Position.pos(line, column));
    }

    public boolean isPositionedAfter(Position position) {
        return this.range.isAfter(position);
    }

    @Deprecated
    public boolean isPositionedBefore(int line, int column) {
        return this.range.isBefore(Position.pos(line, column));
    }

    public boolean isPositionedBefore(Position position) {
        return this.range.isBefore(position);
    }

    public boolean hasComment() {
        return this.comment != null;
    }
}

