/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.List;
import soot.Body;
import soot.Local;
import soot.Value;
import soot.ValueBox;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public class LocalsValidator
implements BodyValidator {
    public static LocalsValidator INSTANCE;

    public static LocalsValidator v() {
        if (INSTANCE == null) {
            INSTANCE = new LocalsValidator();
        }
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        for (ValueBox vb : body.getUseBoxes()) {
            this.validateLocal(body, vb, exception);
        }
        for (ValueBox vb : body.getDefBoxes()) {
            this.validateLocal(body, vb, exception);
        }
    }

    private void validateLocal(Body body, ValueBox vb, List<ValidationException> exception) {
        Value value = vb.getValue();
        if (value instanceof Local && !body.getLocals().contains(value)) {
            exception.add(new ValidationException(value, "Local not in chain : " + value + " in " + body.getMethod()));
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

