/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.G;
import soot.Local;
import soot.Timers;
import soot.Unit;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class SimpleLocalUses
implements LocalUses {
    final Body body;
    Map<Unit, List<UnitValueBoxPair>> unitToUses;

    public SimpleLocalUses(UnitGraph graph, LocalDefs localDefs) {
        this(graph.getBody(), localDefs);
    }

    public SimpleLocalUses(Body body, LocalDefs localDefs) {
        this.body = body;
        if (Options.v().time()) {
            Timers.v().usesTimer.start();
        }
        if (Options.v().time()) {
            Timers.v().usePhase1Timer.start();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "]     Constructing SimpleLocalUses...");
        }
        this.unitToUses = new HashMap<Unit, List<UnitValueBoxPair>>(body.getUnits().size() * 2 + 1, 0.7f);
        for (Unit s : body.getUnits()) {
            this.unitToUses.put(s, new ArrayList());
        }
        if (Options.v().time()) {
            Timers.v().usePhase1Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().usePhase2Timer.start();
        }
        for (Unit s : body.getUnits()) {
            for (ValueBox useBox : s.getUseBoxes()) {
                Local l;
                List<Unit> possibleDefs;
                if (!(useBox.getValue() instanceof Local) || (possibleDefs = localDefs.getDefsOfAt(l = (Local)useBox.getValue(), s)) == null) continue;
                for (Unit def : possibleDefs) {
                    List<UnitValueBoxPair> useList = this.unitToUses.get(def);
                    useList.add(new UnitValueBoxPair(s, useBox));
                }
            }
        }
        if (Options.v().time()) {
            Timers.v().usePhase2Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().usePhase3Timer.start();
        }
        for (Unit s : body.getUnits()) {
            this.unitToUses.put(s, Collections.unmodifiableList(this.unitToUses.get(s)));
        }
        if (Options.v().time()) {
            Timers.v().usePhase3Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().usesTimer.end();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "]     finished SimpleLocalUses...");
        }
    }

    @Override
    public List<UnitValueBoxPair> getUsesOf(Unit s) {
        return this.unitToUses.get(s);
    }

    public Set<Local> getUsedVariables() {
        HashSet<Local> res = new HashSet<Local>();
        for (List<UnitValueBoxPair> vals : this.unitToUses.values()) {
            for (UnitValueBoxPair val : vals) {
                res.add((Local)val.valueBox.getValue());
            }
        }
        return res;
    }

    public Set<Local> getUnusedVariables() {
        Set<Local> usedVariables = this.getUsedVariables();
        HashSet<Local> res = new HashSet<Local>(usedVariables.size());
        for (Local l : this.body.getLocals()) {
            if (usedVariables.contains(l)) continue;
            res.add(l);
        }
        return res;
    }
}

