/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import soot.Timers;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.FlowAnalysis;

public abstract class ForwardFlowAnalysis<N, A>
extends FlowAnalysis<N, A> {
    public ForwardFlowAnalysis(DirectedGraph<N> graph) {
        super(graph);
    }

    @Override
    protected boolean isForward() {
        return true;
    }

    @Override
    protected void doAnalysis() {
        boolean interactiveMode = Options.v().interactive_mode();
        List orderedUnits = this.constructOrderer().newList(this.graph, false);
        int n = orderedUnits.size();
        BitSet head = new BitSet();
        BitSet work = new BitSet(n);
        work.set(0, n);
        IdentityHashMap index = new IdentityHashMap(n * 2 + 1);
        int i = 0;
        for (Object s : orderedUnits) {
            index.put(s, i++);
            this.unitToBeforeFlow.put(s, this.newInitialFlow());
            this.unitToAfterFlow.put(s, this.newInitialFlow());
        }
        for (Object s : this.graph.getHeads()) {
            head.set((Integer)index.get(s));
            this.unitToBeforeFlow.put(s, this.entryInitialFlow());
        }
        int numComputations = 0;
        Object previousFlow = this.newInitialFlow();
        int i2 = work.nextSetBit(0);
        while (i2 >= 0) {
            boolean hasChanged;
            work.clear(i2);
            Object s = orderedUnits.get(i2);
            Object beforeFlow = this.unitToBeforeFlow.get(s);
            Iterator it = this.graph.getPredsOf(s).iterator();
            if (it.hasNext()) {
                this.copy(this.unitToAfterFlow.get(it.next()), beforeFlow);
                while (it.hasNext()) {
                    this.mergeInto(s, beforeFlow, this.unitToAfterFlow.get(it.next()));
                }
                if (head.get(i2)) {
                    this.mergeInto(s, beforeFlow, this.entryInitialFlow());
                }
            }
            Object afterFlow = this.unitToAfterFlow.get(s);
            this.copy(afterFlow, previousFlow);
            if (interactiveMode) {
                this.beforeFlowThrough(s, beforeFlow, true);
                this.flowThrough(beforeFlow, s, afterFlow);
                this.afterFlowThrough(s, afterFlow, false);
            } else {
                this.flowThrough(beforeFlow, s, afterFlow);
            }
            boolean bl = hasChanged = !previousFlow.equals(afterFlow);
            if (hasChanged) {
                for (Object v : this.graph.getSuccsOf(s)) {
                    int j = (Integer)index.get(v);
                    work.set(j);
                    i2 = Math.min(i2, j - 1);
                }
            }
            ++numComputations;
            i2 = work.nextSetBit(i2 + 1);
        }
        Timers.v().totalFlowNodes += n;
        Timers.v().totalFlowComputations += numComputations;
    }
}

