/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import soot.toolkits.scalar.AbstractBoundedFlowSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.FlowUniverse;
import soot.toolkits.scalar.ObjectIntMapper;

public class ArrayPackedSet<T>
extends AbstractBoundedFlowSet<T> {
    ObjectIntMapper<T> map;
    int[] bits;

    public ArrayPackedSet(FlowUniverse<T> universe) {
        this(new ObjectIntMapper<T>(universe));
    }

    ArrayPackedSet(ObjectIntMapper<T> map) {
        this(map, new int[map.size() / 32 + (map.size() % 32 != 0 ? 1 : 0)]);
    }

    ArrayPackedSet(ObjectIntMapper<T> map, int[] bits) {
        this.map = map;
        this.bits = (int[])bits.clone();
    }

    private boolean sameType(Object flowSet) {
        return flowSet instanceof ArrayPackedSet && ((ArrayPackedSet)flowSet).map == this.map;
    }

    @Override
    public ArrayPackedSet<T> clone() {
        return new ArrayPackedSet<T>(this.map, this.bits);
    }

    @Override
    public FlowSet<T> emptySet() {
        return new ArrayPackedSet<T>(this.map);
    }

    @Override
    public int size() {
        int count = 0;
        for (int word : this.bits) {
            for (int j = 0; j < 32; ++j) {
                if ((word & 1 << j) == 0) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        for (int element : this.bits) {
            if (element == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = 0;
        }
    }

    public List<T> toList(int low, int high) {
        int j;
        ArrayList<T> elements = new ArrayList<T>();
        int startWord = low / 32;
        int startBit = low % 32;
        int endWord = high / 32;
        int endBit = high % 32;
        if (low > high) {
            return elements;
        }
        int word = this.bits[startWord];
        int offset = startWord * 32;
        int lastBit = startWord != endWord ? 32 : endBit + 1;
        for (j = startBit; j < lastBit; ++j) {
            if ((word & 1 << j) == 0) continue;
            elements.add(this.map.getObject(offset + j));
        }
        if (startWord != endWord && startWord + 1 != endWord) {
            for (int i = startWord + 1; i < endWord; ++i) {
                int word2 = this.bits[i];
                int offset2 = i * 32;
                for (j = 0; j < 32; ++j) {
                    if ((word2 & 1 << j) == 0) continue;
                    elements.add(this.map.getObject(offset2 + j));
                }
            }
        }
        if (startWord != endWord) {
            word = this.bits[endWord];
            offset = endWord * 32;
            lastBit = endBit + 1;
            for (j = 0; j < lastBit; ++j) {
                if ((word & 1 << j) == 0) continue;
                elements.add(this.map.getObject(offset + j));
            }
        }
        return elements;
    }

    @Override
    public List<T> toList() {
        ArrayList<T> elements = new ArrayList<T>();
        for (int i = 0; i < this.bits.length; ++i) {
            int word = this.bits[i];
            int offset = i * 32;
            for (int j = 0; j < 32; ++j) {
                if ((word & 1 << j) == 0) continue;
                elements.add(this.map.getObject(offset + j));
            }
        }
        return elements;
    }

    @Override
    public void add(T obj) {
        int bitNum = this.map.getInt(obj);
        int n = bitNum / 32;
        this.bits[n] = this.bits[n] | 1 << bitNum % 32;
    }

    @Override
    public void complement(FlowSet<T> destFlow) {
        if (this.sameType(destFlow)) {
            int lastValidBitCount;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            for (int i = 0; i < this.bits.length; ++i) {
                dest.bits[i] = ~this.bits[i];
            }
            if (this.bits.length >= 1 && (lastValidBitCount = this.map.size() % 32) != 0) {
                int n = this.bits.length - 1;
                dest.bits[n] = dest.bits[n] & ~(-1 << lastValidBitCount);
            }
        } else {
            super.complement(destFlow);
        }
    }

    @Override
    public void remove(T obj) {
        int bitNum = this.map.getInt(obj);
        int n = bitNum / 32;
        this.bits[n] = this.bits[n] & ~(1 << bitNum % 32);
    }

    @Override
    public void union(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArrayPackedSet other = (ArrayPackedSet)otherFlow;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            if (!(other instanceof ArrayPackedSet) || this.bits.length != other.bits.length) {
                throw new RuntimeException("Incompatible other set for union");
            }
            for (int i = 0; i < this.bits.length; ++i) {
                dest.bits[i] = this.bits[i] | other.bits[i];
            }
        } else {
            super.union(otherFlow, destFlow);
        }
    }

    @Override
    public void difference(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            if (!(otherFlow instanceof ArrayPackedSet)) {
                throw new RuntimeException("Incompatible other set for union");
            }
            ArrayPackedSet other = (ArrayPackedSet)otherFlow;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            if (this.bits.length != other.bits.length) {
                throw new RuntimeException("Incompatible other set for union");
            }
            for (int i = 0; i < this.bits.length; ++i) {
                dest.bits[i] = this.bits[i] & ~other.bits[i];
            }
        } else {
            super.difference(otherFlow, destFlow);
        }
    }

    @Override
    public void intersection(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            if (!(otherFlow instanceof ArrayPackedSet)) {
                throw new RuntimeException("Incompatible other set for union");
            }
            ArrayPackedSet other = (ArrayPackedSet)otherFlow;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            if (this.bits.length != other.bits.length) {
                throw new RuntimeException("Incompatible other set for union");
            }
            for (int i = 0; i < this.bits.length; ++i) {
                dest.bits[i] = this.bits[i] & other.bits[i];
            }
        } else {
            super.intersection(otherFlow, destFlow);
        }
    }

    @Override
    public boolean contains(T obj) {
        if (!this.map.contains(obj)) {
            return false;
        }
        int bitNum = this.map.getInt(obj);
        return (this.bits[bitNum / 32] & 1 << bitNum % 32) != 0;
    }

    @Override
    public boolean equals(Object otherFlow) {
        if (this.sameType(otherFlow)) {
            return Arrays.equals(this.bits, ((ArrayPackedSet)otherFlow).bits);
        }
        return super.equals(otherFlow);
    }

    @Override
    public void copy(FlowSet<T> destFlow) {
        if (this.sameType(destFlow)) {
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            for (int i = 0; i < this.bits.length; ++i) {
                dest.bits[i] = this.bits[i];
            }
        } else {
            super.copy(destFlow);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int wordIndex = 0;
            int bitIndex = -1;

            @Override
            public boolean hasNext() {
                for (int i = this.wordIndex; i < ArrayPackedSet.this.bits.length; ++i) {
                    int j;
                    int word = ArrayPackedSet.this.bits[i];
                    int n = j = i == this.wordIndex ? this.bitIndex + 1 : 0;
                    while (j < 32) {
                        if ((word & 1 << j) != 0) {
                            return true;
                        }
                        ++j;
                    }
                }
                return false;
            }

            @Override
            public T next() {
                for (int i = this.wordIndex; i < ArrayPackedSet.this.bits.length; ++i) {
                    int j;
                    int word = ArrayPackedSet.this.bits[i];
                    int offset = i * 32;
                    int n = j = i == this.wordIndex ? this.bitIndex + 1 : 0;
                    while (j < 32) {
                        if ((word & 1 << j) != 0) {
                            this.wordIndex = i;
                            this.bitIndex = j;
                            return ArrayPackedSet.this.map.getObject(offset + j);
                        }
                        ++j;
                    }
                }
                return null;
            }

            @Override
            public void remove() {
                int n = this.wordIndex;
                ArrayPackedSet.this.bits[n] = ArrayPackedSet.this.bits[n] & ~(1 << this.bitIndex);
            }
        };
    }
}

