/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import soot.ArrayType;
import soot.IntType;
import soot.IntegerType;
import soot.NullType;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Type;
import soot.jimple.toolkits.typing.fast.BottomType;
import soot.jimple.toolkits.typing.fast.IHierarchy;
import soot.jimple.toolkits.typing.fast.TypeResolver;

public class BytecodeHierarchy
implements IHierarchy {
    private static Collection<AncestryTreeNode> buildAncestryTree(RefType root) {
        LinkedList<AncestryTreeNode> leafs = new LinkedList<AncestryTreeNode>();
        leafs.add(new AncestryTreeNode(null, root));
        LinkedList<AncestryTreeNode> r = new LinkedList<AncestryTreeNode>();
        while (!leafs.isEmpty()) {
            AncestryTreeNode node = (AncestryTreeNode)leafs.remove();
            if (TypeResolver.typesEqual(node.type, RefType.v("java.lang.Object"))) {
                r.add(node);
                continue;
            }
            SootClass sc = node.type.getSootClass();
            Iterator<SootClass> i = sc.getInterfaces().iterator();
            while (i.hasNext()) {
                leafs.add(new AncestryTreeNode(node, i.next().getType()));
            }
            if (sc.isInterface() && sc.getInterfaceCount() != 0 || sc.isPhantom()) continue;
            leafs.add(new AncestryTreeNode(node, sc.getSuperclass().getType()));
        }
        return r;
    }

    private static RefType leastCommonNode(AncestryTreeNode a, AncestryTreeNode b) {
        RefType r = null;
        while (a != null && b != null && TypeResolver.typesEqual(a.type, b.type)) {
            r = a.type;
            a = a.next;
            b = b.next;
        }
        return r;
    }

    @Override
    public Collection<Type> lcas(Type a, Type b) {
        return BytecodeHierarchy.lcas_(a, b);
    }

    public static Collection<Type> lcas_(Type a, Type b) {
        if (TypeResolver.typesEqual(a, b)) {
            return Collections.singletonList(a);
        }
        if (a instanceof BottomType) {
            return Collections.singletonList(b);
        }
        if (b instanceof BottomType) {
            return Collections.singletonList(a);
        }
        if (a instanceof IntegerType && b instanceof IntegerType) {
            return Collections.singletonList(IntType.v());
        }
        if (a instanceof PrimType || b instanceof PrimType) {
            return Collections.emptyList();
        }
        if (a instanceof NullType) {
            return Collections.singletonList(b);
        }
        if (b instanceof NullType) {
            return Collections.singletonList(a);
        }
        if (a instanceof ArrayType && b instanceof ArrayType) {
            Type eta = ((ArrayType)a).getElementType();
            Type etb = ((ArrayType)b).getElementType();
            Collection<Object> ts = eta instanceof PrimType || etb instanceof PrimType ? Collections.emptyList() : BytecodeHierarchy.lcas_(eta, etb);
            LinkedList<Type> r = new LinkedList<Type>();
            if (ts.isEmpty()) {
                r.add(RefType.v("java.lang.Object"));
                r.add(RefType.v("java.io.Serializable"));
                r.add(RefType.v("java.lang.Cloneable"));
            } else {
                for (Type type : ts) {
                    r.add(type.makeArrayType());
                }
            }
            return r;
        }
        if (a instanceof ArrayType || b instanceof ArrayType) {
            Type rt = a instanceof ArrayType ? b : a;
            LinkedList<Type> r = new LinkedList<Type>();
            if (!TypeResolver.typesEqual(RefType.v("java.lang.Object"), rt)) {
                if (BytecodeHierarchy.ancestor_(RefType.v("java.io.Serializable"), rt)) {
                    r.add(RefType.v("java.io.Serializable"));
                }
                if (BytecodeHierarchy.ancestor_(RefType.v("java.lang.Cloneable"), rt)) {
                    r.add(RefType.v("java.lang.Cloneable"));
                }
            }
            if (r.isEmpty()) {
                r.add(RefType.v("java.lang.Object"));
            }
            return r;
        }
        Collection<AncestryTreeNode> treea = BytecodeHierarchy.buildAncestryTree((RefType)a);
        Collection<AncestryTreeNode> treeb = BytecodeHierarchy.buildAncestryTree((RefType)b);
        LinkedList<Type> r = new LinkedList<Type>();
        for (AncestryTreeNode nodea : treea) {
            for (AncestryTreeNode nodeb : treeb) {
                RefType t = BytecodeHierarchy.leastCommonNode(nodea, nodeb);
                boolean least = true;
                ListIterator i = r.listIterator();
                while (i.hasNext()) {
                    Type t_ = (Type)i.next();
                    if (BytecodeHierarchy.ancestor_(t, t_)) {
                        least = false;
                        break;
                    }
                    if (!BytecodeHierarchy.ancestor_(t_, t)) continue;
                    i.remove();
                }
                if (!least) continue;
                r.add(t);
            }
        }
        if (r.isEmpty()) {
            r.add(RefType.v("java.lang.Object"));
        }
        return r;
    }

    @Override
    public boolean ancestor(Type ancestor, Type child) {
        return BytecodeHierarchy.ancestor_(ancestor, child);
    }

    public static boolean ancestor_(Type ancestor, Type child) {
        if (TypeResolver.typesEqual(ancestor, child)) {
            return true;
        }
        if (child instanceof BottomType) {
            return true;
        }
        if (ancestor instanceof BottomType) {
            return false;
        }
        if (ancestor instanceof IntegerType && child instanceof IntegerType) {
            return true;
        }
        if (ancestor instanceof PrimType || child instanceof PrimType) {
            return false;
        }
        if (child instanceof NullType) {
            return true;
        }
        if (ancestor instanceof NullType) {
            return false;
        }
        return Scene.v().getOrMakeFastHierarchy().canStoreType(child, ancestor);
    }

    private static Deque<RefType> superclassPath(RefType t) {
        LinkedList<RefType> r = new LinkedList<RefType>();
        r.addFirst(t);
        SootClass sc = t.getSootClass();
        while (sc.hasSuperclass()) {
            sc = sc.getSuperclass();
            r.addFirst(sc.getType());
        }
        return r;
    }

    public static RefType lcsc(RefType a, RefType b) {
        if (a == b) {
            return a;
        }
        Deque<RefType> pathA = BytecodeHierarchy.superclassPath(a);
        Deque<RefType> pathB = BytecodeHierarchy.superclassPath(b);
        RefType r = null;
        while (!pathA.isEmpty() && !pathB.isEmpty() && TypeResolver.typesEqual(pathA.getFirst(), pathB.getFirst())) {
            r = pathA.removeFirst();
            pathB.removeFirst();
        }
        return r;
    }

    private static class AncestryTreeNode {
        public final AncestryTreeNode next;
        public final RefType type;

        public AncestryTreeNode(AncestryTreeNode next, RefType type) {
            this.next = next;
            this.type = type;
        }
    }
}

