/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import soot.G;
import soot.Local;
import soot.Pack;
import soot.PackManager;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Transformer;
import soot.jbco.IJbcoTransform;
import soot.jbco.bafTransformations.AddJSRs;
import soot.jbco.bafTransformations.BAFCounter;
import soot.jbco.bafTransformations.BAFPrintout;
import soot.jbco.bafTransformations.BafLineNumberer;
import soot.jbco.bafTransformations.ConstructorConfuser;
import soot.jbco.bafTransformations.FindDuplicateSequences;
import soot.jbco.bafTransformations.FixUndefinedLocals;
import soot.jbco.bafTransformations.IfNullToTryCatch;
import soot.jbco.bafTransformations.IndirectIfJumpsToCaughtGotos;
import soot.jbco.bafTransformations.Jimple2BafLocalBuilder;
import soot.jbco.bafTransformations.LocalsToBitField;
import soot.jbco.bafTransformations.MoveLoadsAboveIfs;
import soot.jbco.bafTransformations.RemoveRedundantPushStores;
import soot.jbco.bafTransformations.TryCatchCombiner;
import soot.jbco.bafTransformations.UpdateConstantsToFields;
import soot.jbco.bafTransformations.WrapSwitchesInTrys;
import soot.jbco.jimpleTransformations.AddSwitches;
import soot.jbco.jimpleTransformations.ArithmeticTransformer;
import soot.jbco.jimpleTransformations.BuildIntermediateAppClasses;
import soot.jbco.jimpleTransformations.ClassRenamer;
import soot.jbco.jimpleTransformations.CollectConstants;
import soot.jbco.jimpleTransformations.CollectJimpleLocals;
import soot.jbco.jimpleTransformations.FieldRenamer;
import soot.jbco.jimpleTransformations.GotoInstrumenter;
import soot.jbco.jimpleTransformations.LibraryMethodWrappersBuilder;
import soot.jbco.jimpleTransformations.MethodRenamer;
import soot.tagkit.LineNumberTagAggregator;

public class Main {
    public static boolean jbcoDebug = false;
    public static boolean jbcoSummary = true;
    public static boolean jbcoVerbose = false;
    public static boolean metrics = false;
    public static Map<String, Integer> transformsToWeights = new HashMap<String, Integer>();
    public static Map<String, Map<Object, Integer>> transformsToMethodsToWeights = new HashMap<String, Map<Object, Integer>>();
    public static Map method2Locals2REALTypes = new HashMap();
    public static Map<SootMethod, Map<Local, Local>> methods2Baf2JLocals = new HashMap<SootMethod, Map<Local, Local>>();
    public static Map<SootMethod, List<Local>> methods2JLocals = new HashMap<SootMethod, List<Local>>();
    public static List<SootClass> IntermediateAppClasses = new ArrayList<SootClass>();
    static List<Transformer> jbcotransforms = new ArrayList<Transformer>();
    static String[][] optionStrings = new String[][]{{"Rename Classes", "Rename Methods", "Rename Fields", "Build API Buffer Methods", "Build Library Buffer Classes", "Goto Instruction Augmentation", "Add Dead Switche Statements", "Convert Arith. Expr. To Bitshifting Ops", "Convert Branches to JSR Instructions", "Disobey Constructor Conventions", "Reuse Duplicate Sequences", "Replace If(Non)Nulls with Try-Catch", "Indirect If Instructions", "Pack Locals into Bitfields", "Reorder Loads Above Ifs", "Combine Try and Catch Blocks", "Embed Constants in Fields", "Partially Trap Switches"}, {"wjtp.jbco_cr", "wjtp.jbco_mr", "wjtp.jbco_fr", "wjtp.jbco_blbc", "wjtp.jbco_bapibm", "jtp.jbco_gia", "jtp.jbco_adss", "jtp.jbco_cae2bo", "bb.jbco_cb2ji", "bb.jbco_dcc", "bb.jbco_rds", "bb.jbco_riitcb", "bb.jbco_iii", "bb.jbco_plvb", "bb.jbco_rlaii", "bb.jbco_ctbcb", "bb.jbco_ecvf", "bb.jbco_ptss"}};

    public static void main(String[] argv) {
        int rcount = 0;
        Vector<String> transformsToAdd = new Vector<String>();
        boolean[] remove = new boolean[argv.length];
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.equals("-jbco:help")) {
                System.out.println("The Java Bytecode Obfuscator (JBCO)\n\nGeneral Options:");
                System.out.println("\t-jbco:help     -  print this help message.");
                System.out.println("\t-jbco:verbose  -  print extra information during obfuscation.");
                System.out.println("\t-jbco:silent   -  turn off all output, including summary information.");
                System.out.println("\t-jbco:metrics  -  calculate total vertices and edges;\n\t                  calculate avg. and highest graph degrees.");
                System.out.println("\t-jbco:debug    -  turn on extra debugging like\n\t                  stack height and type verifier.\n\nTransformations ( -t:[W:]<name>[:pattern] )\n\tW              -  specify obfuscation weight (0-9)\n\t<name>         -  name of obfuscation (from list below)\n\tpattern        -  limit to method names matched by pattern\n\t                  prepend * to pattern if a regex\n");
                for (int j = 0; j < optionStrings[0].length; ++j) {
                    String line = "\t" + optionStrings[1][j];
                    int size = 20 - line.length();
                    while (size-- > 0) {
                        line = line + " ";
                    }
                    line = line + "-  " + optionStrings[0][j];
                    System.out.println(line);
                }
                System.exit(0);
                continue;
            }
            if (arg.equals("-jbco:metrics")) {
                metrics = true;
                remove[i] = true;
                ++rcount;
                continue;
            }
            if (arg.startsWith("-jbco:name:")) {
                remove[i] = true;
                ++rcount;
                continue;
            }
            if (arg.startsWith("-t:")) {
                arg = arg.substring(3);
                int tweight = 9;
                char cweight = arg.charAt(0);
                if (cweight >= '0' && cweight <= '9') {
                    try {
                        tweight = Integer.parseInt(arg.substring(0, 1));
                    }
                    catch (NumberFormatException nfe) {
                        G.v().out.println("Improperly formated transformation weight: " + argv[i]);
                        System.exit(1);
                    }
                    arg = arg.substring(arg.indexOf(58) + 1);
                }
                transformsToAdd.add(arg);
                transformsToWeights.put(arg, new Integer(tweight));
                if (arg.equals("wjtp.jbco_fr")) {
                    FieldRenamer.rename_fields = true;
                }
                remove[i] = true;
                ++rcount;
                continue;
            }
            if (arg.equals("-jbco:verbose")) {
                jbcoVerbose = true;
                remove[i] = true;
                ++rcount;
                continue;
            }
            if (arg.equals("-jbco:silent")) {
                jbcoSummary = false;
                jbcoVerbose = false;
                remove[i] = true;
                ++rcount;
                continue;
            }
            if (arg.equals("-jbco:debug")) {
                jbcoDebug = true;
                remove[i] = true;
                ++rcount;
                continue;
            }
            if (arg.startsWith("-i") && arg.length() > 4 && arg.charAt(3) == ':' && arg.charAt(2) == 't') {
                Map<Object, Integer> htmp;
                int index;
                Object o = null;
                arg = arg.substring(4);
                int tweight = 0;
                char cweight = arg.charAt(0);
                if (cweight >= '0' && cweight <= '9') {
                    try {
                        tweight = Integer.parseInt(arg.substring(0, 1));
                    }
                    catch (NumberFormatException nfe) {
                        G.v().out.println("Improperly formatted transformation weight: " + argv[i]);
                        System.exit(1);
                    }
                    if (arg.indexOf(58) < 0) {
                        G.v().out.println("Illegally Formatted Option: " + argv[i]);
                        System.exit(1);
                    }
                    arg = arg.substring(arg.indexOf(58) + 1);
                }
                if ((index = arg.indexOf(58)) < 0) {
                    G.v().out.println("Illegally Formatted Option: " + argv[i]);
                    System.exit(1);
                }
                String trans = arg.substring(0, index);
                if ((arg = arg.substring(index + 1, arg.length())).startsWith("*")) {
                    arg = arg.substring(1);
                    try {
                        o = Pattern.compile(arg);
                    }
                    catch (PatternSyntaxException pse) {
                        G.v().out.println("Illegal Regular Expression Pattern: " + arg);
                        System.exit(1);
                    }
                } else {
                    o = arg;
                }
                if ((htmp = transformsToMethodsToWeights.get(trans)) == null) {
                    htmp = new HashMap<Object, Integer>();
                    transformsToMethodsToWeights.put(trans, htmp);
                }
                htmp.put(o, new Integer(tweight));
                remove[i] = true;
                ++rcount;
                continue;
            }
            remove[i] = false;
        }
        if (rcount > 0) {
            int index = 0;
            String[] tmp = (String[])argv.clone();
            argv = new String[argv.length - rcount];
            for (int i = 0; i < tmp.length; ++i) {
                if (remove[i]) continue;
                argv[index++] = tmp[i];
            }
        }
        transformsToAdd.remove("wjtp.jbco_cc");
        transformsToAdd.remove("jtp.jbco_jl");
        transformsToAdd.remove("bb.jbco_j2bl");
        transformsToAdd.remove("bb.jbco_ful");
        if (!metrics) {
            int i;
            if (transformsToAdd.size() == 0) {
                G.v().out.println("No Jbco tasks to complete.  Shutting Down...");
                System.exit(0);
            }
            Pack wjtp = PackManager.v().getPack("wjtp");
            Pack jtp = PackManager.v().getPack("jtp");
            Pack bb = PackManager.v().getPack("bb");
            if (transformsToAdd.contains("jtp.jbco_adss")) {
                wjtp.add(new Transform("wjtp.jbco_fr", Main.newTransform((Transformer)((Object)Main.getTransform("wjtp.jbco_fr")))));
                if (transformsToAdd.remove("wjtp.jbco_fr")) {
                    FieldRenamer.rename_fields = true;
                }
            }
            if (transformsToAdd.contains("bb.jbco_ecvf")) {
                wjtp.add(new Transform("wjtp.jbco_cc", Main.newTransform((Transformer)((Object)Main.getTransform("wjtp.jbco_cc")))));
            }
            String jl = null;
            for (i = 0; i < transformsToAdd.size(); ++i) {
                if (!((String)transformsToAdd.get(i)).startsWith("bb")) continue;
                jl = "jtp.jbco_jl";
                jtp.add(new Transform(jl, Main.newTransform((Transformer)((Object)Main.getTransform(jl)))));
                bb.insertBefore(new Transform("bb.jbco_j2bl", Main.newTransform((Transformer)((Object)Main.getTransform("bb.jbco_j2bl")))), "bb.lso");
                bb.insertBefore(new Transform("bb.jbco_ful", Main.newTransform((Transformer)((Object)Main.getTransform("bb.jbco_ful")))), "bb.lso");
                bb.add(new Transform("bb.jbco_rrps", Main.newTransform((Transformer)((Object)Main.getTransform("bb.jbco_rrps")))));
                break;
            }
            for (i = 0; i < transformsToAdd.size(); ++i) {
                String insertBefore;
                Pack p;
                String tname = (String)transformsToAdd.get(i);
                IJbcoTransform t = Main.getTransform(tname);
                Pack pack = tname.startsWith("wjtp") ? wjtp : (p = tname.startsWith("jtp") ? jtp : bb);
                String string = p == jtp ? jl : (insertBefore = p == bb ? "bb.jbco_ful" : null);
                if (insertBefore != null) {
                    p.insertBefore(new Transform(tname, Main.newTransform((Transformer)((Object)t))), insertBefore);
                    continue;
                }
                p.add(new Transform(tname, Main.newTransform((Transformer)((Object)t))));
            }
            Iterator<Transform> phases = wjtp.iterator();
            while (phases.hasNext()) {
                if (phases.next().getPhaseName().indexOf("jbco") <= 0) continue;
                argv = Main.checkWhole(argv, true);
                break;
            }
            if (jbcoSummary) {
                for (int i2 = 0; i2 < 3; ++i2) {
                    Iterator<Transform> phases2 = i2 == 0 ? wjtp.iterator() : (i2 == 1 ? jtp.iterator() : bb.iterator());
                    G.v().out.println(i2 == 0 ? "Whole Program Jimple Transformations:" : (i2 == 1 ? "Jimple Method Body Transformations:" : "Baf Method Body Transformations:"));
                    while (phases2.hasNext()) {
                        Transform o = phases2.next();
                        Transformer t = o.getTransformer();
                        if (t instanceof IJbcoTransform) {
                            G.v().out.println("\t" + ((IJbcoTransform)((Object)t)).getName() + "  JBCO");
                            continue;
                        }
                        G.v().out.println("\t" + o.getPhaseName() + "  default");
                    }
                }
                G.v().out.println();
            }
            bb.add(new Transform("bb.jbco_bln", new BafLineNumberer()));
            bb.add(new Transform("bb.jbco_lta", LineNumberTagAggregator.v()));
        } else {
            argv = Main.checkWhole(argv, false);
        }
        soot.Main.main(argv);
        if (jbcoSummary) {
            G.v().out.println("\n***** JBCO SUMMARY *****\n");
            for (Transformer o : jbcotransforms) {
                if (!(o instanceof IJbcoTransform)) continue;
                ((IJbcoTransform)((Object)o)).outputSummary();
            }
            G.v().out.println("\n***** END SUMMARY *****\n");
        }
    }

    private static String[] checkWhole(String[] argv, boolean add) {
        for (int i = 0; i < argv.length; ++i) {
            if (!argv[i].equals("-w")) continue;
            if (add) {
                return argv;
            }
            String[] tmp = new String[argv.length - 1];
            if (i == 0) {
                System.arraycopy(argv, 1, tmp, 0, tmp.length);
            } else {
                System.arraycopy(argv, 0, tmp, 0, i);
                if (i < argv.length - 1) {
                    System.arraycopy(argv, i + 1, tmp, i, tmp.length - i);
                }
            }
            return tmp;
        }
        if (add) {
            String[] tmp = new String[argv.length + 1];
            tmp[0] = "-w";
            System.arraycopy(argv, 0, tmp, 1, argv.length);
            return tmp;
        }
        return argv;
    }

    private static Transformer newTransform(Transformer t) {
        jbcotransforms.add(t);
        return t;
    }

    private static IJbcoTransform getTransform(String name) {
        if (name.startsWith("bb.jbco_rrps")) {
            return new RemoveRedundantPushStores();
        }
        if (name.startsWith("bb.printout")) {
            return new BAFPrintout(name, true);
        }
        if (name.equals("bb.jbco_j2bl")) {
            return new Jimple2BafLocalBuilder();
        }
        if (name.equals("jtp.jbco_gia")) {
            return new GotoInstrumenter();
        }
        if (name.equals("jtp.jbco_cae2bo")) {
            return new ArithmeticTransformer();
        }
        if (name.equals("wjtp.jbco_cc")) {
            return new CollectConstants();
        }
        if (name.equals("bb.jbco_ecvf")) {
            return new UpdateConstantsToFields();
        }
        if (name.equals("bb.jbco_rds")) {
            return new FindDuplicateSequences();
        }
        if (name.equals("bb.jbco_plvb")) {
            return new LocalsToBitField();
        }
        if (name.equals("bb.jbco_rlaii")) {
            return new MoveLoadsAboveIfs();
        }
        if (name.equals("bb.jbco_ptss")) {
            return new WrapSwitchesInTrys();
        }
        if (name.equals("bb.jbco_iii")) {
            return new IndirectIfJumpsToCaughtGotos();
        }
        if (name.equals("bb.jbco_ctbcb")) {
            return new TryCatchCombiner();
        }
        if (name.equals("bb.jbco_cb2ji")) {
            return new AddJSRs();
        }
        if (name.equals("bb.jbco_riitcb")) {
            return new IfNullToTryCatch();
        }
        if (name.equals("wjtp.jbco_blbc")) {
            return new LibraryMethodWrappersBuilder();
        }
        if (name.equals("wjtp.jbco_bapibm")) {
            return new BuildIntermediateAppClasses();
        }
        if (name.equals("wjtp.jbco_cr")) {
            return new ClassRenamer();
        }
        if (name.equals("bb.jbco_ful")) {
            return new FixUndefinedLocals();
        }
        if (name.equals("wjtp.jbco_fr")) {
            return new FieldRenamer();
        }
        if (name.equals("wjtp.jbco_mr")) {
            return new MethodRenamer();
        }
        if (name.equals("jtp.jbco_adss")) {
            return new AddSwitches();
        }
        if (name.equals("jtp.jbco_jl")) {
            return new CollectJimpleLocals();
        }
        if (name.equals("bb.jbco_dcc")) {
            return new ConstructorConfuser();
        }
        if (name.equals("bb.jbco_counter")) {
            return new BAFCounter();
        }
        return null;
    }

    private static int getWeight(String phasename) {
        int weight = 9;
        Integer intg = transformsToWeights.get(phasename);
        if (intg != null) {
            weight = intg;
        }
        return weight;
    }

    public static int getWeight(String phasename, String method) {
        Map<Object, Integer> htmp = transformsToMethodsToWeights.get(phasename);
        int result = 10;
        if (htmp != null) {
            Iterator<Object> keys = htmp.keySet().iterator();
            while (keys.hasNext()) {
                Integer intg = null;
                Object o = keys.next();
                if (o instanceof Pattern) {
                    if (((Pattern)o).matcher(method).matches()) {
                        intg = htmp.get(o);
                    }
                } else if (o instanceof String && method.equals(o)) {
                    intg = htmp.get(o);
                }
                if (intg == null || intg >= result) continue;
                result = intg;
            }
        }
        if (result > 9 || result < 0) {
            result = Main.getWeight(phasename);
        }
        if (jbcoVerbose) {
            G.v().out.println("[" + phasename + "] Processing " + method + " with weight: " + result);
        }
        return result;
    }
}

