/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.internal.AST;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.UnitPrinter;
import soot.dava.internal.AST.ASTCondition;
import soot.dava.internal.AST.ASTControlFlowNode;
import soot.dava.internal.SET.SETNodeLabel;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.toolkits.base.AST.analysis.Analysis;
import soot.jimple.Stmt;

public class ASTForLoopNode
extends ASTControlFlowNode {
    private List<Object> init;
    private List<Object> update;
    private List<Object> body;

    public ASTForLoopNode(SETNodeLabel label, List<Object> init, ASTCondition condition, List<Object> update, List<Object> body) {
        super(label, condition);
        this.body = body;
        this.init = init;
        this.update = update;
        this.subBodies.add(body);
    }

    public List<Object> getInit() {
        return this.init;
    }

    public List<Object> getUpdate() {
        return this.update;
    }

    public void replaceBody(List<Object> body) {
        this.body = body;
        this.subBodies = new ArrayList();
        this.subBodies.add(body);
    }

    @Override
    public Object clone() {
        return new ASTForLoopNode(this.get_Label(), this.init, this.get_Condition(), this.update, this.body);
    }

    @Override
    public void toString(UnitPrinter up) {
        Stmt u;
        AugmentedStmt as;
        this.label_toString(up);
        up.literal("for");
        up.literal(" ");
        up.literal("(");
        Iterator<Object> it = this.init.iterator();
        while (it.hasNext()) {
            as = (AugmentedStmt)it.next();
            u = as.get_Stmt();
            u.toString(up);
            if (!it.hasNext()) continue;
            up.literal(" , ");
        }
        up.literal("; ");
        this.condition.toString(up);
        up.literal("; ");
        it = this.update.iterator();
        while (it.hasNext()) {
            as = (AugmentedStmt)it.next();
            u = as.get_Stmt();
            u.toString(up);
            if (!it.hasNext()) continue;
            up.literal(" , ");
        }
        up.literal(")");
        up.newline();
        up.literal("{");
        up.newline();
        up.incIndent();
        this.body_toString(up, this.body);
        up.decIndent();
        up.literal("}");
        up.newline();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.label_toString());
        b.append("for (");
        Iterator<Object> it = this.init.iterator();
        while (it.hasNext()) {
            b.append(((AugmentedStmt)it.next()).get_Stmt().toString());
            if (!it.hasNext()) continue;
            b.append(" , ");
        }
        b.append("; ");
        b.append(this.get_Condition().toString());
        b.append("; ");
        it = this.update.iterator();
        while (it.hasNext()) {
            b.append(((AugmentedStmt)it.next()).get_Stmt().toString());
            if (!it.hasNext()) continue;
            b.append(" , ");
        }
        b.append(")");
        b.append("\n");
        b.append("{");
        b.append("\n");
        b.append(this.body_toString(this.body));
        b.append("}");
        b.append("\n");
        return b.toString();
    }

    @Override
    public void apply(Analysis a) {
        a.caseASTForLoopNode(this);
    }
}

