# Contributing to pyobis
## Why contribute to the Open Source?
Contributing to the Open Source is a good way to learn, practice and build experience in every skill you want in life (both soft and hard), if not the best way.
+ You get the chance to improve the software you rely on, or *the world relies on*.
+ It helps you improve existing skills, in an exponential manner.
+ You not only get to meet people who are really interested in similar things but are also really cool.
+ You get the chance to find mentors and even teach others.
+ You get the feeling of being in a community that's interesting and as good as anything. It feels empowered when you make changes (even smaller ones).
+ You don't always have to code, you can suggest some great ideas or fix a typo in the documentation.

Above all this, its never the best time to contribute to Open Source because every second is the best! Get your boots ready, and we'll love to see your inputs. We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## pyobis, and its aim
While you are reading this, you must have been aware of what pyobis is - it's the Python client for [OBIS](https://obis.org/). With every commit, pull and push we aim to make this package even more easier for researchers and practitioners to use. We want to help them make their research work easier by serving as the high level module over the OBIS API and enable easy visualization and analysis of marine data.

## We Develop with GitHub
We use GitHub to host code, to track issues and feature requests, as well as accept pull requests.

## We Use [GitHub Flow](https://guides.github.com/introduction/flow/index.html), So All Code Changes Happen Through Pull Requests
Pull requests are the best way to propose changes to the codebase (we use [GitHub Flow](https://guides.github.com/introduction/flow/index.html)). We actively welcome your pull requests:

1. Fork the repo and create your branch from `master`.
2. Follow Installation instructions in the [README](https://github.com/iobis/pyobis/blob/master/README.rst)
3. If you've added code that should be tested, add tests.
4. If you've changed APIs, update the documentation.
5. Issue that pull request!
    + Make sure your pull requests are in-detail and includes:
        - a good title and a summary describing the changes you made with your set of edits
        - notes for reviewers, if in case you wish to add some additional points for the reviewers to make a note of
        - whenever possible, break pull requests into smaller ones.
        - make sure the pull request should do only one thing - single objective for a single PR.

## Any contributions you make will be under this [Software License](https://github.com/iobis/pyobis/blob/master/LICENSE)
In short, when you submit code changes, your submissions will be understood to be under the same [License](https://github.com/iobis/pyobis/blob/master/LICENSE) that covers the project. Feel free to contact the maintainers if that's a concern.

## Report bugs using GitHub's [issues](https://github.com/iobis/pyobis/issues)
We use GitHub issues to track public bugs. Report a bug by [opening a new issue](); it's that easy!

## Write bug reports with detail, background, and sample code
**Great Bug Reports** tend to have:
- A quick summary and/or background
- Steps to reproduce
  - Be specific!
  - Give sample code if you can, so that *anyone* with the base python setup can reproduce.
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

## Additional Suggestions
+ **Code Style**
  + We strongly encourage you to follow the code style of the existing codebase. You can follow the [PEP8](https://pep8.org/) style for writing new patches of code.
+ **Writing a good commit message**
  + Writing a good commit message always helps in making code reviews faster and a lot easier for the reviewers to get hold of the changes.
+ **More Questions?**
  + If you have still got any questions that this document couldn't answer then you are free to create a new issue.

## License
By contributing, you agree that your contributions will be licensed under [this License](https://github.com/iobis/pyobis/blob/master/LICENSE).

## Further Reading
There are really great resources out there to help you become a successful contributor.
  + [How to Contribute to Open Source Guide](https://opensource.guide/how-to-contribute/)
  + [Zen of Scientific Software Maintenance](https://jrleeman.github.io/ScientificSoftwareMaintenance/)

## References
This document was adapted from the open-source contribution guidelines for [Facebook's Draft](https://github.com/facebook/draft-js/blob/a9316a723f9e918afde44dea68b5f9f39b7d9b00/CONTRIBUTING.md) with some changes inspired from [MetPy's guide](https://github.com/Unidata/MetPy/blob/main/CONTRIBUTING.md).
