# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BlueprintArgs', 'Blueprint']

@pulumi.input_type
class BlueprintArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[str],
                 properties: pulumi.Input[Sequence[pulumi.Input['BlueprintPropertyArgs']]],
                 title: pulumi.Input[str],
                 calculation_properties: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintCalculationPropertyArgs']]]] = None,
                 changelog_destination: Optional[pulumi.Input['BlueprintChangelogDestinationArgs']] = None,
                 data_source: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 mirror_properties: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintMirrorPropertyArgs']]]] = None,
                 relations: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintRelationArgs']]]] = None):
        """
        The set of arguments for constructing a Blueprint resource.
        :param pulumi.Input[str] identifier: The identifier of the blueprint
        :param pulumi.Input[Sequence[pulumi.Input['BlueprintPropertyArgs']]] properties: The metadata of the entity
        :param pulumi.Input[str] title: The display name of the blueprint
        :param pulumi.Input[Sequence[pulumi.Input['BlueprintCalculationPropertyArgs']]] calculation_properties: A set of properties that are calculated upon Entitys regular properties.
        :param pulumi.Input['BlueprintChangelogDestinationArgs'] changelog_destination: Blueprints changelog destination, Supports WEBHOOK and KAFKA
        :param pulumi.Input[str] data_source: The data source for entities of this blueprint
        :param pulumi.Input[str] description: The description of the blueprint
        :param pulumi.Input[str] icon: The icon of the blueprint
        :param pulumi.Input[Sequence[pulumi.Input['BlueprintMirrorPropertyArgs']]] mirror_properties: When two Blueprints are connected via a Relation, a new set of properties becomes available to Entities in the source
               Blueprint.
        :param pulumi.Input[Sequence[pulumi.Input['BlueprintRelationArgs']]] relations: The blueprints that are connected to this blueprint
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "title", title)
        if calculation_properties is not None:
            pulumi.set(__self__, "calculation_properties", calculation_properties)
        if changelog_destination is not None:
            pulumi.set(__self__, "changelog_destination", changelog_destination)
        if data_source is not None:
            warnings.warn("""Data source is ignored""", DeprecationWarning)
            pulumi.log.warn("""data_source is deprecated: Data source is ignored""")
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if icon is not None:
            pulumi.set(__self__, "icon", icon)
        if mirror_properties is not None:
            pulumi.set(__self__, "mirror_properties", mirror_properties)
        if relations is not None:
            pulumi.set(__self__, "relations", relations)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        The identifier of the blueprint
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Input[Sequence[pulumi.Input['BlueprintPropertyArgs']]]:
        """
        The metadata of the entity
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input[Sequence[pulumi.Input['BlueprintPropertyArgs']]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        The display name of the blueprint
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="calculationProperties")
    def calculation_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintCalculationPropertyArgs']]]]:
        """
        A set of properties that are calculated upon Entitys regular properties.
        """
        return pulumi.get(self, "calculation_properties")

    @calculation_properties.setter
    def calculation_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintCalculationPropertyArgs']]]]):
        pulumi.set(self, "calculation_properties", value)

    @property
    @pulumi.getter(name="changelogDestination")
    def changelog_destination(self) -> Optional[pulumi.Input['BlueprintChangelogDestinationArgs']]:
        """
        Blueprints changelog destination, Supports WEBHOOK and KAFKA
        """
        return pulumi.get(self, "changelog_destination")

    @changelog_destination.setter
    def changelog_destination(self, value: Optional[pulumi.Input['BlueprintChangelogDestinationArgs']]):
        pulumi.set(self, "changelog_destination", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[str]]:
        """
        The data source for entities of this blueprint
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the blueprint
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input[str]]:
        """
        The icon of the blueprint
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon", value)

    @property
    @pulumi.getter(name="mirrorProperties")
    def mirror_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintMirrorPropertyArgs']]]]:
        """
        When two Blueprints are connected via a Relation, a new set of properties becomes available to Entities in the source
        Blueprint.
        """
        return pulumi.get(self, "mirror_properties")

    @mirror_properties.setter
    def mirror_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintMirrorPropertyArgs']]]]):
        pulumi.set(self, "mirror_properties", value)

    @property
    @pulumi.getter
    def relations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintRelationArgs']]]]:
        """
        The blueprints that are connected to this blueprint
        """
        return pulumi.get(self, "relations")

    @relations.setter
    def relations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintRelationArgs']]]]):
        pulumi.set(self, "relations", value)


@pulumi.input_type
class _BlueprintState:
    def __init__(__self__, *,
                 calculation_properties: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintCalculationPropertyArgs']]]] = None,
                 changelog_destination: Optional[pulumi.Input['BlueprintChangelogDestinationArgs']] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 data_source: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 mirror_properties: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintMirrorPropertyArgs']]]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintPropertyArgs']]]] = None,
                 relations: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintRelationArgs']]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 updated_by: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Blueprint resources.
        :param pulumi.Input[Sequence[pulumi.Input['BlueprintCalculationPropertyArgs']]] calculation_properties: A set of properties that are calculated upon Entitys regular properties.
        :param pulumi.Input['BlueprintChangelogDestinationArgs'] changelog_destination: Blueprints changelog destination, Supports WEBHOOK and KAFKA
        :param pulumi.Input[str] data_source: The data source for entities of this blueprint
        :param pulumi.Input[str] description: The description of the blueprint
        :param pulumi.Input[str] icon: The icon of the blueprint
        :param pulumi.Input[str] identifier: The identifier of the blueprint
        :param pulumi.Input[Sequence[pulumi.Input['BlueprintMirrorPropertyArgs']]] mirror_properties: When two Blueprints are connected via a Relation, a new set of properties becomes available to Entities in the source
               Blueprint.
        :param pulumi.Input[Sequence[pulumi.Input['BlueprintPropertyArgs']]] properties: The metadata of the entity
        :param pulumi.Input[Sequence[pulumi.Input['BlueprintRelationArgs']]] relations: The blueprints that are connected to this blueprint
        :param pulumi.Input[str] title: The display name of the blueprint
        """
        if calculation_properties is not None:
            pulumi.set(__self__, "calculation_properties", calculation_properties)
        if changelog_destination is not None:
            pulumi.set(__self__, "changelog_destination", changelog_destination)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if data_source is not None:
            warnings.warn("""Data source is ignored""", DeprecationWarning)
            pulumi.log.warn("""data_source is deprecated: Data source is ignored""")
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if icon is not None:
            pulumi.set(__self__, "icon", icon)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if mirror_properties is not None:
            pulumi.set(__self__, "mirror_properties", mirror_properties)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if relations is not None:
            pulumi.set(__self__, "relations", relations)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)

    @property
    @pulumi.getter(name="calculationProperties")
    def calculation_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintCalculationPropertyArgs']]]]:
        """
        A set of properties that are calculated upon Entitys regular properties.
        """
        return pulumi.get(self, "calculation_properties")

    @calculation_properties.setter
    def calculation_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintCalculationPropertyArgs']]]]):
        pulumi.set(self, "calculation_properties", value)

    @property
    @pulumi.getter(name="changelogDestination")
    def changelog_destination(self) -> Optional[pulumi.Input['BlueprintChangelogDestinationArgs']]:
        """
        Blueprints changelog destination, Supports WEBHOOK and KAFKA
        """
        return pulumi.get(self, "changelog_destination")

    @changelog_destination.setter
    def changelog_destination(self, value: Optional[pulumi.Input['BlueprintChangelogDestinationArgs']]):
        pulumi.set(self, "changelog_destination", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[str]]:
        """
        The data source for entities of this blueprint
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the blueprint
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input[str]]:
        """
        The icon of the blueprint
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the blueprint
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="mirrorProperties")
    def mirror_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintMirrorPropertyArgs']]]]:
        """
        When two Blueprints are connected via a Relation, a new set of properties becomes available to Entities in the source
        Blueprint.
        """
        return pulumi.get(self, "mirror_properties")

    @mirror_properties.setter
    def mirror_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintMirrorPropertyArgs']]]]):
        pulumi.set(self, "mirror_properties", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintPropertyArgs']]]]:
        """
        The metadata of the entity
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintPropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def relations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintRelationArgs']]]]:
        """
        The blueprints that are connected to this blueprint
        """
        return pulumi.get(self, "relations")

    @relations.setter
    def relations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BlueprintRelationArgs']]]]):
        pulumi.set(self, "relations", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the blueprint
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_by", value)


class Blueprint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 calculation_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintCalculationPropertyArgs']]]]] = None,
                 changelog_destination: Optional[pulumi.Input[pulumi.InputType['BlueprintChangelogDestinationArgs']]] = None,
                 data_source: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 mirror_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintMirrorPropertyArgs']]]]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintPropertyArgs']]]]] = None,
                 relations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintRelationArgs']]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a Blueprint resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintCalculationPropertyArgs']]]] calculation_properties: A set of properties that are calculated upon Entitys regular properties.
        :param pulumi.Input[pulumi.InputType['BlueprintChangelogDestinationArgs']] changelog_destination: Blueprints changelog destination, Supports WEBHOOK and KAFKA
        :param pulumi.Input[str] data_source: The data source for entities of this blueprint
        :param pulumi.Input[str] description: The description of the blueprint
        :param pulumi.Input[str] icon: The icon of the blueprint
        :param pulumi.Input[str] identifier: The identifier of the blueprint
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintMirrorPropertyArgs']]]] mirror_properties: When two Blueprints are connected via a Relation, a new set of properties becomes available to Entities in the source
               Blueprint.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintPropertyArgs']]]] properties: The metadata of the entity
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintRelationArgs']]]] relations: The blueprints that are connected to this blueprint
        :param pulumi.Input[str] title: The display name of the blueprint
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BlueprintArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Blueprint resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param BlueprintArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BlueprintArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 calculation_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintCalculationPropertyArgs']]]]] = None,
                 changelog_destination: Optional[pulumi.Input[pulumi.InputType['BlueprintChangelogDestinationArgs']]] = None,
                 data_source: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 mirror_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintMirrorPropertyArgs']]]]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintPropertyArgs']]]]] = None,
                 relations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintRelationArgs']]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BlueprintArgs.__new__(BlueprintArgs)

            __props__.__dict__["calculation_properties"] = calculation_properties
            __props__.__dict__["changelog_destination"] = changelog_destination
            if data_source is not None and not opts.urn:
                warnings.warn("""Data source is ignored""", DeprecationWarning)
                pulumi.log.warn("""data_source is deprecated: Data source is ignored""")
            __props__.__dict__["data_source"] = data_source
            __props__.__dict__["description"] = description
            __props__.__dict__["icon"] = icon
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["mirror_properties"] = mirror_properties
            if properties is None and not opts.urn:
                raise TypeError("Missing required property 'properties'")
            __props__.__dict__["properties"] = properties
            __props__.__dict__["relations"] = relations
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["updated_by"] = None
        super(Blueprint, __self__).__init__(
            'port:index/blueprint:Blueprint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            calculation_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintCalculationPropertyArgs']]]]] = None,
            changelog_destination: Optional[pulumi.Input[pulumi.InputType['BlueprintChangelogDestinationArgs']]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            data_source: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            icon: Optional[pulumi.Input[str]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            mirror_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintMirrorPropertyArgs']]]]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintPropertyArgs']]]]] = None,
            relations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintRelationArgs']]]]] = None,
            title: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            updated_by: Optional[pulumi.Input[str]] = None) -> 'Blueprint':
        """
        Get an existing Blueprint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintCalculationPropertyArgs']]]] calculation_properties: A set of properties that are calculated upon Entitys regular properties.
        :param pulumi.Input[pulumi.InputType['BlueprintChangelogDestinationArgs']] changelog_destination: Blueprints changelog destination, Supports WEBHOOK and KAFKA
        :param pulumi.Input[str] data_source: The data source for entities of this blueprint
        :param pulumi.Input[str] description: The description of the blueprint
        :param pulumi.Input[str] icon: The icon of the blueprint
        :param pulumi.Input[str] identifier: The identifier of the blueprint
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintMirrorPropertyArgs']]]] mirror_properties: When two Blueprints are connected via a Relation, a new set of properties becomes available to Entities in the source
               Blueprint.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintPropertyArgs']]]] properties: The metadata of the entity
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BlueprintRelationArgs']]]] relations: The blueprints that are connected to this blueprint
        :param pulumi.Input[str] title: The display name of the blueprint
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BlueprintState.__new__(_BlueprintState)

        __props__.__dict__["calculation_properties"] = calculation_properties
        __props__.__dict__["changelog_destination"] = changelog_destination
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["data_source"] = data_source
        __props__.__dict__["description"] = description
        __props__.__dict__["icon"] = icon
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["mirror_properties"] = mirror_properties
        __props__.__dict__["properties"] = properties
        __props__.__dict__["relations"] = relations
        __props__.__dict__["title"] = title
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["updated_by"] = updated_by
        return Blueprint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="calculationProperties")
    def calculation_properties(self) -> pulumi.Output[Optional[Sequence['outputs.BlueprintCalculationProperty']]]:
        """
        A set of properties that are calculated upon Entitys regular properties.
        """
        return pulumi.get(self, "calculation_properties")

    @property
    @pulumi.getter(name="changelogDestination")
    def changelog_destination(self) -> pulumi.Output[Optional['outputs.BlueprintChangelogDestination']]:
        """
        Blueprints changelog destination, Supports WEBHOOK and KAFKA
        """
        return pulumi.get(self, "changelog_destination")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Output[Optional[str]]:
        """
        The data source for entities of this blueprint
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the blueprint
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def icon(self) -> pulumi.Output[Optional[str]]:
        """
        The icon of the blueprint
        """
        return pulumi.get(self, "icon")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        The identifier of the blueprint
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="mirrorProperties")
    def mirror_properties(self) -> pulumi.Output[Optional[Sequence['outputs.BlueprintMirrorProperty']]]:
        """
        When two Blueprints are connected via a Relation, a new set of properties becomes available to Entities in the source
        Blueprint.
        """
        return pulumi.get(self, "mirror_properties")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.BlueprintProperty']]:
        """
        The metadata of the entity
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def relations(self) -> pulumi.Output[Optional[Sequence['outputs.BlueprintRelation']]]:
        """
        The blueprints that are connected to this blueprint
        """
        return pulumi.get(self, "relations")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        The display name of the blueprint
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[str]:
        return pulumi.get(self, "updated_by")

