# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ActionArgs', 'Action']

@pulumi.input_type
class ActionArgs:
    def __init__(__self__, *,
                 blueprint_identifier: pulumi.Input[str],
                 identifier: pulumi.Input[str],
                 invocation_method: pulumi.Input['ActionInvocationMethodArgs'],
                 title: pulumi.Input[str],
                 trigger: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 user_properties: Optional[pulumi.Input[Sequence[pulumi.Input['ActionUserPropertyArgs']]]] = None):
        """
        The set of arguments for constructing a Action resource.
        :param pulumi.Input[str] blueprint_identifier: The identifier of the blueprint
        :param pulumi.Input[str] identifier: The identifier of the action
        :param pulumi.Input['ActionInvocationMethodArgs'] invocation_method: The methods the action is dispatched in. Supports WEBHOOK, KAFKA and GITHUB
        :param pulumi.Input[str] title: The display name of the action
        :param pulumi.Input[str] trigger: The type of the action, one of CREATE, DAY-2, DELETE
        :param pulumi.Input[str] description: The description of the action
        :param pulumi.Input[str] icon: The icon of the action
        :param pulumi.Input[Sequence[pulumi.Input['ActionUserPropertyArgs']]] user_properties: The input properties of the action
        """
        pulumi.set(__self__, "blueprint_identifier", blueprint_identifier)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "invocation_method", invocation_method)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "trigger", trigger)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if icon is not None:
            pulumi.set(__self__, "icon", icon)
        if user_properties is not None:
            pulumi.set(__self__, "user_properties", user_properties)

    @property
    @pulumi.getter(name="blueprintIdentifier")
    def blueprint_identifier(self) -> pulumi.Input[str]:
        """
        The identifier of the blueprint
        """
        return pulumi.get(self, "blueprint_identifier")

    @blueprint_identifier.setter
    def blueprint_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "blueprint_identifier", value)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        The identifier of the action
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="invocationMethod")
    def invocation_method(self) -> pulumi.Input['ActionInvocationMethodArgs']:
        """
        The methods the action is dispatched in. Supports WEBHOOK, KAFKA and GITHUB
        """
        return pulumi.get(self, "invocation_method")

    @invocation_method.setter
    def invocation_method(self, value: pulumi.Input['ActionInvocationMethodArgs']):
        pulumi.set(self, "invocation_method", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        The display name of the action
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Input[str]:
        """
        The type of the action, one of CREATE, DAY-2, DELETE
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: pulumi.Input[str]):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the action
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input[str]]:
        """
        The icon of the action
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon", value)

    @property
    @pulumi.getter(name="userProperties")
    def user_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionUserPropertyArgs']]]]:
        """
        The input properties of the action
        """
        return pulumi.get(self, "user_properties")

    @user_properties.setter
    def user_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionUserPropertyArgs']]]]):
        pulumi.set(self, "user_properties", value)


@pulumi.input_type
class _ActionState:
    def __init__(__self__, *,
                 blueprint_identifier: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 invocation_method: Optional[pulumi.Input['ActionInvocationMethodArgs']] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 trigger: Optional[pulumi.Input[str]] = None,
                 user_properties: Optional[pulumi.Input[Sequence[pulumi.Input['ActionUserPropertyArgs']]]] = None):
        """
        Input properties used for looking up and filtering Action resources.
        :param pulumi.Input[str] blueprint_identifier: The identifier of the blueprint
        :param pulumi.Input[str] description: The description of the action
        :param pulumi.Input[str] icon: The icon of the action
        :param pulumi.Input[str] identifier: The identifier of the action
        :param pulumi.Input['ActionInvocationMethodArgs'] invocation_method: The methods the action is dispatched in. Supports WEBHOOK, KAFKA and GITHUB
        :param pulumi.Input[str] title: The display name of the action
        :param pulumi.Input[str] trigger: The type of the action, one of CREATE, DAY-2, DELETE
        :param pulumi.Input[Sequence[pulumi.Input['ActionUserPropertyArgs']]] user_properties: The input properties of the action
        """
        if blueprint_identifier is not None:
            pulumi.set(__self__, "blueprint_identifier", blueprint_identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if icon is not None:
            pulumi.set(__self__, "icon", icon)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if invocation_method is not None:
            pulumi.set(__self__, "invocation_method", invocation_method)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)
        if user_properties is not None:
            pulumi.set(__self__, "user_properties", user_properties)

    @property
    @pulumi.getter(name="blueprintIdentifier")
    def blueprint_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the blueprint
        """
        return pulumi.get(self, "blueprint_identifier")

    @blueprint_identifier.setter
    def blueprint_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blueprint_identifier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the action
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input[str]]:
        """
        The icon of the action
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the action
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="invocationMethod")
    def invocation_method(self) -> Optional[pulumi.Input['ActionInvocationMethodArgs']]:
        """
        The methods the action is dispatched in. Supports WEBHOOK, KAFKA and GITHUB
        """
        return pulumi.get(self, "invocation_method")

    @invocation_method.setter
    def invocation_method(self, value: Optional[pulumi.Input['ActionInvocationMethodArgs']]):
        pulumi.set(self, "invocation_method", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the action
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the action, one of CREATE, DAY-2, DELETE
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter(name="userProperties")
    def user_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionUserPropertyArgs']]]]:
        """
        The input properties of the action
        """
        return pulumi.get(self, "user_properties")

    @user_properties.setter
    def user_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionUserPropertyArgs']]]]):
        pulumi.set(self, "user_properties", value)


class Action(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blueprint_identifier: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 invocation_method: Optional[pulumi.Input[pulumi.InputType['ActionInvocationMethodArgs']]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 trigger: Optional[pulumi.Input[str]] = None,
                 user_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ActionUserPropertyArgs']]]]] = None,
                 __props__=None):
        """
        Create a Action resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] blueprint_identifier: The identifier of the blueprint
        :param pulumi.Input[str] description: The description of the action
        :param pulumi.Input[str] icon: The icon of the action
        :param pulumi.Input[str] identifier: The identifier of the action
        :param pulumi.Input[pulumi.InputType['ActionInvocationMethodArgs']] invocation_method: The methods the action is dispatched in. Supports WEBHOOK, KAFKA and GITHUB
        :param pulumi.Input[str] title: The display name of the action
        :param pulumi.Input[str] trigger: The type of the action, one of CREATE, DAY-2, DELETE
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ActionUserPropertyArgs']]]] user_properties: The input properties of the action
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Action resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blueprint_identifier: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 invocation_method: Optional[pulumi.Input[pulumi.InputType['ActionInvocationMethodArgs']]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 trigger: Optional[pulumi.Input[str]] = None,
                 user_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ActionUserPropertyArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActionArgs.__new__(ActionArgs)

            if blueprint_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'blueprint_identifier'")
            __props__.__dict__["blueprint_identifier"] = blueprint_identifier
            __props__.__dict__["description"] = description
            __props__.__dict__["icon"] = icon
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            if invocation_method is None and not opts.urn:
                raise TypeError("Missing required property 'invocation_method'")
            __props__.__dict__["invocation_method"] = invocation_method
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            if trigger is None and not opts.urn:
                raise TypeError("Missing required property 'trigger'")
            __props__.__dict__["trigger"] = trigger
            __props__.__dict__["user_properties"] = user_properties
        super(Action, __self__).__init__(
            'port:index/action:Action',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            blueprint_identifier: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            icon: Optional[pulumi.Input[str]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            invocation_method: Optional[pulumi.Input[pulumi.InputType['ActionInvocationMethodArgs']]] = None,
            title: Optional[pulumi.Input[str]] = None,
            trigger: Optional[pulumi.Input[str]] = None,
            user_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ActionUserPropertyArgs']]]]] = None) -> 'Action':
        """
        Get an existing Action resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] blueprint_identifier: The identifier of the blueprint
        :param pulumi.Input[str] description: The description of the action
        :param pulumi.Input[str] icon: The icon of the action
        :param pulumi.Input[str] identifier: The identifier of the action
        :param pulumi.Input[pulumi.InputType['ActionInvocationMethodArgs']] invocation_method: The methods the action is dispatched in. Supports WEBHOOK, KAFKA and GITHUB
        :param pulumi.Input[str] title: The display name of the action
        :param pulumi.Input[str] trigger: The type of the action, one of CREATE, DAY-2, DELETE
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ActionUserPropertyArgs']]]] user_properties: The input properties of the action
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActionState.__new__(_ActionState)

        __props__.__dict__["blueprint_identifier"] = blueprint_identifier
        __props__.__dict__["description"] = description
        __props__.__dict__["icon"] = icon
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["invocation_method"] = invocation_method
        __props__.__dict__["title"] = title
        __props__.__dict__["trigger"] = trigger
        __props__.__dict__["user_properties"] = user_properties
        return Action(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="blueprintIdentifier")
    def blueprint_identifier(self) -> pulumi.Output[str]:
        """
        The identifier of the blueprint
        """
        return pulumi.get(self, "blueprint_identifier")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the action
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def icon(self) -> pulumi.Output[Optional[str]]:
        """
        The icon of the action
        """
        return pulumi.get(self, "icon")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        The identifier of the action
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="invocationMethod")
    def invocation_method(self) -> pulumi.Output['outputs.ActionInvocationMethod']:
        """
        The methods the action is dispatched in. Supports WEBHOOK, KAFKA and GITHUB
        """
        return pulumi.get(self, "invocation_method")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        The display name of the action
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Output[str]:
        """
        The type of the action, one of CREATE, DAY-2, DELETE
        """
        return pulumi.get(self, "trigger")

    @property
    @pulumi.getter(name="userProperties")
    def user_properties(self) -> pulumi.Output[Optional[Sequence['outputs.ActionUserProperty']]]:
        """
        The input properties of the action
        """
        return pulumi.get(self, "user_properties")

