# Generated by Django 4.1.7 on 2023-02-27 22:28

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="Entity",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "created_time",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="When this entity and associated object were created.",
                    ),
                ),
                (
                    "updated_time",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="When this entity (but not *necessarily* its associated object) was last modified.",
                    ),
                ),
                (
                    "archived_time",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="When this entity and its associated object were last archived.",
                        null=True,
                    ),
                ),
                (
                    "xattrs",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="Arbitrary JSON attributes, e.g. tags.",
                        verbose_name="extended attributes",
                    ),
                ),
                (
                    "restricted",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text="When False, access to this object may be granted simply by sharing a Domain. When True, there must also be a matching Policy.",
                        verbose_name="Access restricted",
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.RESTRICT,
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "entities",
            },
        ),
        migrations.CreateModel(
            name="Domain",
            fields=[
                (
                    "entity",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="+",
                        serialize=False,
                        to="onto.entity",
                    ),
                ),
                (
                    "archived",
                    models.BooleanField(
                        db_index=True,
                        default=False,
                        editable=False,
                        help_text="True indicates the object has been archived and won't appear in most queries.",
                    ),
                ),
                ("name", models.SlugField(max_length=255, unique=True)),
                (
                    "authorizes",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        default=False,
                        help_text="When True, membership to this Domain is considered for authorization. When False, membership will never affect authorization.",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Membership",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "xattrs",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="Arbitrary JSON attributes, e.g. tags, to attach to this object.",
                        verbose_name="extended attributes",
                    ),
                ),
                (
                    "entity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="memberships",
                        to="onto.entity",
                    ),
                ),
                (
                    "domain",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="memberships",
                        to="onto.domain",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="entity",
            name="domains",
            field=models.ManyToManyField(
                blank=True,
                help_text="Domains, or entity groups, that this object is a member of.",
                related_name="entities",
                through="onto.Membership",
                to="onto.domain",
            ),
        ),
        migrations.AddConstraint(
            model_name="membership",
            constraint=models.UniqueConstraint(
                fields=("entity", "domain"), name="onto_membership_unique"
            ),
        ),
    ]
