import pytest
import numpy as np
from ..ctdt import ctdt
import pkg_resources

PATH = pkg_resources.resource_filename(__name__, 'test_data/')

def test_ctdt():
    "Test CTD transition"
    
    # load data
    X_list = open(PATH+'multiple.txt').read().splitlines()
    X_err = 'AGT2HT9'
    
    # get ctdt
    ctdt_list, desc = ctdt(X_list)
    
    # test ctdt
    np.testing.assert_almost_equal(ctdt_list, 
    np.array([[0.        , 0.        , 0.16666667, 0.33333333, 0.  ,
         0.        , 0.16666667, 0.16666667, 0.        , 0.        ,
         0.33333333, 0.        , 0.16666667, 0.16666667, 0.        ,
         0.33333333, 0.        , 0.16666667, 0.16666667, 0.        ,
         0.16666667, 0.        , 0.16666667, 0.16666667, 0.        ,
         0.16666667, 0.16666667, 0.        , 0.16666667, 0.16666667,
         0.33333333, 0.        , 0.        , 0.33333333, 0.        ,
         0.        , 0.16666667, 0.16666667, 0.16666667],
        [0.125     , 0.75      , 0.125     , 0.25      , 0.125     ,
         0.125     , 0.375     , 0.375     , 0.        , 0.125     ,
         0.375     , 0.        , 0.375     , 0.375     , 0.        ,
         0.125     , 0.375     , 0.        , 0.125     , 0.75      ,
         0.125     , 0.125     , 0.        , 0.        , 0.        ,
         0.375     , 0.125     , 0.625     , 0.        , 0.        ,
         0.        , 0.        , 0.5       , 0.125     , 0.        ,
         0.125     , 0.375     , 0.375     , 0.125     ],
        [0.42857143, 0.        , 0.        , 0.28571429, 0.28571429,
         0.        , 0.28571429, 0.28571429, 0.        , 0.        ,
         0.28571429, 0.28571429, 0.14285714, 0.28571429, 0.        ,
         0.28571429, 0.28571429, 0.        , 0.28571429, 0.        ,
         0.        , 0.28571429, 0.14285714, 0.        , 0.        ,
         0.28571429, 0.28571429, 0.28571429, 0.14285714, 0.        ,
         0.14285714, 0.        , 0.14285714, 0.        , 0.14285714,
         0.28571429, 0.57142857, 0.        , 0.]])
    , decimal=3)

    # test ValueError
    with pytest.raises(ValueError):
        ctdt_error, desc = ctdt(X_err)