import pytest
import numpy as np
from ..ctdc import ctdc
import pkg_resources

PATH = pkg_resources.resource_filename(__name__, 'test_data/')

def test_ctdc():
    "Test CTD composition"
    
    # load data
    X_list = open(PATH+'multiple.txt').read().splitlines()
    X_err = 'AGT2HT9'
    
    # get ctdc
    ctdc_list, desc = ctdc(X_list)
    
    # test ctdc
    np.testing.assert_almost_equal(ctdc_list, 
    np.array([[0.        , 0.57142857, 0.42857143, 0.28571429, 0.71428571,
        0.        , 0.42857143, 0.28571429, 0.28571429, 0.28571429,
        0.        , 0.71428571, 0.14285714, 0.42857143, 0.42857143,
        0.28571429, 0.42857143, 0.28571429, 0.42857143, 0.14285714,
        0.42857143, 0.28571429, 0.28571429, 0.42857143, 0.42857143,
        0.28571429, 0.28571429, 0.28571429, 0.28571429, 0.42857143,
        0.28571429, 0.71428571, 0.        , 0.85714286, 0.14285714,
        0.        , 0.57142857, 0.28571429, 0.14285714],
       [0.44444444, 0.11111111, 0.44444444, 0.66666667, 0.22222222,
        0.11111111, 0.44444444, 0.22222222, 0.33333333, 0.22222222,
        0.44444444, 0.33333333, 0.44444444, 0.22222222, 0.33333333,
        0.22222222, 0.44444444, 0.33333333, 0.44444444, 0.11111111,
        0.44444444, 0.66666667, 0.33333333, 0.        , 0.33333333,
        0.44444444, 0.22222222, 0.33333333, 0.66666667, 0.        ,
        0.        , 0.77777778, 0.22222222, 0.33333333, 0.11111111,
        0.55555556, 0.55555556, 0.22222222, 0.22222222],
       [0.375     , 0.625     , 0.        , 0.5       , 0.375     ,
        0.125     , 0.5       , 0.375     , 0.125     , 0.375     ,
        0.125     , 0.5       , 0.375     , 0.5       , 0.125     ,
        0.5       , 0.375     , 0.125     , 0.875     , 0.125     ,
        0.        , 0.75      , 0.125     , 0.125     , 0.125     ,
        0.375     , 0.5       , 0.625     , 0.25      , 0.125     ,
        0.125     , 0.625     , 0.25      , 0.5       , 0.125     ,
        0.375     , 0.5       , 0.5       , 0.]])
    , decimal=3)

    # test ValueError
    with pytest.raises(ValueError):
        ctdc_error, desc = ctdc(X_err)