# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError

from .. import models


class SearchOperations(object):
    """SearchOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def post(
            self, body, tenant, index, query_parameters={}, custom_headers=None, raw=False, **operation_config):
        """Bing Commerce Custom Search Query.

        POST requests accept complex search request options.

        :param body:
        :type body:
         ~microsoft.bing.commerce.search.models.CommerceSearchPostRequest
        :param tenant:
        :type tenant: str
        :param index:
        :type index: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CommerceSearchResponse or ClientRawResponse if raw=true
        :rtype: ~microsoft.bing.commerce.search.models.CommerceSearchResponse
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.post.metadata['url']
        path_format_arguments = {
            'tenant': self._serialize.url("tenant", tenant, 'str'),
            'index': self._serialize.url("index", index, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'CommerceSearchPostRequest')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CommerceSearchResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    post.metadata = {'url': '/{tenant}/indexes/{index}'}

    def get(
            self, q, tenant, index, mkt=None, setlang=None, select=None, orderby=None, top=None, skip=None, discoverfacets=False, alteration=True, debug=False, searchinstanceid="Default", query_parameters={}, custom_headers=None, raw=False, **operation_config):
        """Bing Commerce Basic Search Query.

        GET requests can search an index using only URL parameters. Only
        limited request options are available. GET requests will always do
        simple item search and support only a default facet discovery
        aggregation.

        :param q: The query to match against all eligible fields.
        :type q: str
        :param tenant:
        :type tenant: str
        :param index:
        :type index: str
        :param mkt: The market where the results come from. Typically, `mkt`
         is the country where the user is making the request from.
        :type mkt: str
        :param setlang: The language to use for user interface strings. You
         may specify the language using either a 2-letter or 4-letter code.
         Using 4-letter codes is preferred.
        :type setlang: str
        :param select: A comma-separated list of fields to return. unspecified
         or empty to select only _itemId, or `*` to select all fields.
        :type select: str
        :param orderby: A comma-separated list of OData order syntax
         expressions.
        :type orderby: str
        :param top: The maximum count of items to return for pagination.
         Default is 24.
        :type top: int
        :param skip: The offset to the first item to return for pagination.
         Default is 0.
        :type skip: int
        :param discoverfacets: Default value is false. When true, requests a
         facet discovery aggregation.
        :type discoverfacets: bool
        :param alteration: A boolean flag to enable or disable query
         alteration. Default is true.
        :type alteration: bool
        :param debug:
        :type debug: bool
        :param searchinstanceid: A saved search instance configuration to
         apply to current request.
        :type searchinstanceid: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CommerceSearchResponse or ClientRawResponse if raw=true
        :rtype: ~microsoft.bing.commerce.search.models.CommerceSearchResponse
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get.metadata['url']
        path_format_arguments = {
            'tenant': self._serialize.url("tenant", tenant, 'str'),
            'index': self._serialize.url("index", index, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        if mkt is not None:
            query_parameters['mkt'] = self._serialize.query("mkt", mkt, 'str')
        if setlang is not None:
            query_parameters['setlang'] = self._serialize.query("setlang", setlang, 'str')
        query_parameters['q'] = self._serialize.query("q", q, 'str')
        if select is not None:
            query_parameters['select'] = self._serialize.query("select", select, 'str')
        if orderby is not None:
            query_parameters['orderby'] = self._serialize.query("orderby", orderby, 'str')
        if top is not None:
            query_parameters['top'] = self._serialize.query("top", top, 'int')
        if skip is not None:
            query_parameters['skip'] = self._serialize.query("skip", skip, 'int')
        if discoverfacets is not None:
            query_parameters['discoverfacets'] = self._serialize.query("discoverfacets", discoverfacets, 'bool')
        if alteration is not None:
            query_parameters['alteration'] = self._serialize.query("alteration", alteration, 'bool')
        if debug is not None:
            query_parameters['debug'] = self._serialize.query("debug", debug, 'bool')
        if searchinstanceid is not None:
            query_parameters['searchinstanceid'] = self._serialize.query("searchinstanceid", searchinstanceid, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CommerceSearchResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get.metadata = {'url': '/{tenant}/indexes/{index}'}
