# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .equivalence_condition_base import EquivalenceConditionBase


class StringCondition(EquivalenceConditionBase):
    """Defines an equivalence condition for a string field. It can appear in a
    filter, a boost, or a filter aggregation.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :param field: The name of the field.
    :type field: str
    :param operator: Possible values include: 'Eq', 'Ne'
    :type operator: str or
     ~microsoft.bing.commerce.search.models.EquivalenceOperator
    :param value: The value to compare the field against.
    :type value: str
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'field': {'key': 'field', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'EquivalenceOperator'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StringCondition, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self._type = 'StringCondition'
