# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .field_condition_base_py3 import FieldConditionBase


class SetConditionBase(FieldConditionBase):
    """Defines the abstract base type for conditions that matches with a set of
    values.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StringSetCondition

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :param field: The name of the field.
    :type field: str
    :param operator: Possible values include: 'In', 'NotIn'
    :type operator: str or ~microsoft.bing.commerce.search.models.SetOperator
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'field': {'key': 'field', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'SetOperator'},
    }

    _subtype_map = {
        '_type': {'StringSetCondition': 'StringSetCondition'}
    }

    def __init__(self, *, field: str=None, operator=None, **kwargs) -> None:
        super(SetConditionBase, self).__init__(field=field, **kwargs)
        self.operator = operator
        self._type = 'SetConditionBase'
