# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResponseTask(Model):
    """ResponseTask.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ResponseQueryContext, ResponseItemsBase,
    ResponseAggregation, ResponseCustomization, CommerceSearchResponse

    All required parameters must be populated in order to send to Azure.

    :param errors: A list of errors that happened to the task, if any.
    :type errors: list[~microsoft.bing.commerce.search.models.ResponseError]
    :param debug:
    :type debug:
     list[~microsoft.bing.commerce.search.models.ResponseDebugInfo]
    :param _type: Required. Constant filled by server.
    :type _type: str
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[ResponseError]'},
        'debug': {'key': 'debug', 'type': '[ResponseDebugInfo]'},
        '_type': {'key': '_type', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Response.QueryContext': 'ResponseQueryContext', 'Response.ItemsBase': 'ResponseItemsBase', 'Aggregation': 'ResponseAggregation', 'Response.Customization': 'ResponseCustomization', 'SearchResponse': 'CommerceSearchResponse'}
    }

    def __init__(self, *, errors=None, debug=None, **kwargs) -> None:
        super(ResponseTask, self).__init__(**kwargs)
        self.errors = errors
        self.debug = debug
        self._type = None
