# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResponseRefinementBase(Model):
    """The abstract base type for a refinement on a facet.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ResponseNumberRefinement, ResponseStringRefinement,
    ResponseBoolRefinement, ResponseRangeRefinement

    All required parameters must be populated in order to send to Azure.

    :param estimated_count: An estimate of the number of items in this
     refinement.
    :type estimated_count: long
    :param _type: Required. Constant filled by server.
    :type _type: str
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        'estimated_count': {'key': 'estimatedCount', 'type': 'long'},
        '_type': {'key': '_type', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'NumberRefinement': 'ResponseNumberRefinement', 'StringRefinement': 'ResponseStringRefinement', 'BoolRefinement': 'ResponseBoolRefinement', 'RangeRefinement': 'ResponseRangeRefinement'}
    }

    def __init__(self, **kwargs):
        super(ResponseRefinementBase, self).__init__(**kwargs)
        self.estimated_count = kwargs.get('estimated_count', None)
        self._type = None
