# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .response_refinement_base_py3 import ResponseRefinementBase


class ResponseRangeRefinement(ResponseRefinementBase):
    """Defines a range facet refinement on a numeric field.

    All required parameters must be populated in order to send to Azure.

    :param estimated_count: An estimate of the number of items in this
     refinement.
    :type estimated_count: long
    :param _type: Required. Constant filled by server.
    :type _type: str
    :param ge: The inclusive lower bound of the range. Values in the
     refinement are greater than or equal to this lower bound.
    :type ge: float
    :param lt: The exclusive upper bound of the range. Values in the
     refinement are strictly less than this upper bound
    :type lt: float
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        'estimated_count': {'key': 'estimatedCount', 'type': 'long'},
        '_type': {'key': '_type', 'type': 'str'},
        'ge': {'key': 'ge', 'type': 'float'},
        'lt': {'key': 'lt', 'type': 'float'},
    }

    def __init__(self, *, estimated_count: int=None, ge: float=None, lt: float=None, **kwargs) -> None:
        super(ResponseRangeRefinement, self).__init__(estimated_count=estimated_count, **kwargs)
        self.ge = ge
        self.lt = lt
        self._type = 'RangeRefinement'
