# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .response_task import ResponseTask


class ResponseItemsBase(ResponseTask):
    """Defines the abstract base type for item results.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ResponseItems

    All required parameters must be populated in order to send to Azure.

    :param errors: A list of errors that happened to the task, if any.
    :type errors: list[~microsoft.bing.commerce.search.models.ResponseError]
    :param debug:
    :type debug:
     list[~microsoft.bing.commerce.search.models.ResponseDebugInfo]
    :param _type: Required. Constant filled by server.
    :type _type: str
    :param total_estimated_matches: An estimated count of the items in the
     full result set.
    :type total_estimated_matches: long
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[ResponseError]'},
        'debug': {'key': 'debug', 'type': '[ResponseDebugInfo]'},
        '_type': {'key': '_type', 'type': 'str'},
        'total_estimated_matches': {'key': 'totalEstimatedMatches', 'type': 'long'},
    }

    _subtype_map = {
        '_type': {'Items': 'ResponseItems'}
    }

    def __init__(self, **kwargs):
        super(ResponseItemsBase, self).__init__(**kwargs)
        self.total_estimated_matches = kwargs.get('total_estimated_matches', None)
        self._type = 'Response.ItemsBase'
