# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .response_task_py3 import ResponseTask


class ResponseCustomization(ResponseTask):
    """Defines the customizations applied to the search operation.

    All required parameters must be populated in order to send to Azure.

    :param errors: A list of errors that happened to the task, if any.
    :type errors: list[~microsoft.bing.commerce.search.models.ResponseError]
    :param debug:
    :type debug:
     list[~microsoft.bing.commerce.search.models.ResponseDebugInfo]
    :param _type: Required. Constant filled by server.
    :type _type: str
    :param query_alteration: A boolean to determine if query alteration have
     been applied to the search operation.
    :type query_alteration: bool
    :param synonyms: The synonyms used to apply the search query.
    :type synonyms: list[~microsoft.bing.commerce.search.models.Synonym]
    :param rules:
    :type rules: list[str]
    :param filter: The filters applied to the search result.
    :type filter: ~microsoft.bing.commerce.search.models.ConditionBase
    :param boosts: The boost expressions applied to the search result.
    :type boosts: list[~microsoft.bing.commerce.search.models.BoostExpression]
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[ResponseError]'},
        'debug': {'key': 'debug', 'type': '[ResponseDebugInfo]'},
        '_type': {'key': '_type', 'type': 'str'},
        'query_alteration': {'key': 'queryAlteration', 'type': 'bool'},
        'synonyms': {'key': 'synonyms', 'type': '[Synonym]'},
        'rules': {'key': 'rules', 'type': '[str]'},
        'filter': {'key': 'filter', 'type': 'ConditionBase'},
        'boosts': {'key': 'boosts', 'type': '[BoostExpression]'},
    }

    def __init__(self, *, errors=None, debug=None, query_alteration: bool=None, synonyms=None, rules=None, filter=None, boosts=None, **kwargs) -> None:
        super(ResponseCustomization, self).__init__(errors=errors, debug=debug, **kwargs)
        self.query_alteration = query_alteration
        self.synonyms = synonyms
        self.rules = rules
        self.filter = filter
        self.boosts = boosts
        self._type = 'Response.Customization'
