# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .request_facet_base_py3 import RequestFacetBase


class RequestRangeFacet(RequestFacetBase):
    """Defines a facet with refinements that have numerical ranges.

    All required parameters must be populated in order to send to Azure.

    :param name: A label that you specify for your aggregations, which the API
     passes through and returns with the response.
    :type name: str
    :param aggregations: A list of child aggregations.
    :type aggregations:
     list[~microsoft.bing.commerce.search.models.RequestAggregationBase]
    :param _type: Required. Constant filled by server.
    :type _type: str
    :param field: The field name.
    :type field: str
    :param order_by: A comma-separated list of OData order syntax expressions.
     Default is `_count desc`
    :type order_by: str
    :param interval: Defines the size of the interval that can be used to
     refine a search which utilizes numerical range faceting.
    :type interval: int
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'aggregations': {'key': 'aggregations', 'type': '[RequestAggregationBase]'},
        '_type': {'key': '_type', 'type': 'str'},
        'field': {'key': 'field', 'type': 'str'},
        'order_by': {'key': 'orderBy', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'int'},
    }

    def __init__(self, *, name: str=None, aggregations=None, field: str=None, order_by: str=None, interval: int=None, **kwargs) -> None:
        super(RequestRangeFacet, self).__init__(name=name, aggregations=aggregations, field=field, order_by=order_by, **kwargs)
        self.interval = interval
        self._type = 'RangeFacet'
