# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RequestQuery(Model):
    """Represents the query that determines the result set. Note that query must
    have a matchAll, value, or filter field. The matchAll and value fields
    cannot both be present. You may create a query with only a filter to
    **browse** (for example: a category).

    :param match_all: A query that matches against all searchable fields.
    :type match_all: str
    :param value: An instance of queryclausebase specifying search conditions.
     Its mutually exclusive with matchall.
    :type value: ~microsoft.bing.commerce.search.models.RequestQueryClauseBase
    :param filter: A filter to apply on the matching result set, or on all
     items if no match is specified.
    :type filter: ~microsoft.bing.commerce.search.models.ConditionBase
    :param boosts: The set of boosts to apply to the result set.
    :type boosts: list[~microsoft.bing.commerce.search.models.BoostExpression]
    :param alteration: A boolean flag to enable or disable query alteration.
     Default value: True .
    :type alteration: bool
    :param synonyms: A set of alternate terms (or phrases) that can be applied
     to request query. The applied synonyms are used for both text-matching and
     result-ranking stages of search.
    :type synonyms: list[~microsoft.bing.commerce.search.models.Synonym]
    """

    _attribute_map = {
        'match_all': {'key': 'matchAll', 'type': 'str'},
        'value': {'key': 'value', 'type': 'RequestQueryClauseBase'},
        'filter': {'key': 'filter', 'type': 'ConditionBase'},
        'boosts': {'key': 'boosts', 'type': '[BoostExpression]'},
        'alteration': {'key': 'alteration', 'type': 'bool'},
        'synonyms': {'key': 'synonyms', 'type': '[Synonym]'},
    }

    def __init__(self, **kwargs):
        super(RequestQuery, self).__init__(**kwargs)
        self.match_all = kwargs.get('match_all', None)
        self.value = kwargs.get('value', None)
        self.filter = kwargs.get('filter', None)
        self.boosts = kwargs.get('boosts', None)
        self.alteration = kwargs.get('alteration', True)
        self.synonyms = kwargs.get('synonyms', None)
