# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .request_query_clause_base import RequestQueryClauseBase


class RequestLocationMatch(RequestQueryClauseBase):
    """Defines user location to match. If an explicit location is specified in a
    match query, this is ignored.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :param center: The geo-location that you wish for the search to be applied
     around.
    :type center: ~microsoft.bing.commerce.search.models.GeoPoint
    :param radius: The accuracy of the search on that location in meters.
    :type radius: float
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'center': {'key': 'center', 'type': 'GeoPoint'},
        'radius': {'key': 'radius', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(RequestLocationMatch, self).__init__(**kwargs)
        self.center = kwargs.get('center', None)
        self.radius = kwargs.get('radius', None)
        self._type = 'LocationMatch'
