# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RequestItems(Model):
    """Defines how to return items from the result set.

    :param select: A list of fields that should appear for each item of the
     response.
    :type select: list[str]
    :param order_by: A comma-separated list of OData order syntax expressions.
    :type order_by: str
    :param top: The number of results to return. It can be used for
     pagination.
    :type top: int
    :param skip: The number of results to skip in the result set. Supports
     pagination.
    :type skip: int
    :param dedupe: A boolean to specify whether you want the result set to
     exclude duplicates. Default is `false`. Default value: False .
    :type dedupe: bool
    """

    _attribute_map = {
        'select': {'key': 'select', 'type': '[str]'},
        'order_by': {'key': 'orderBy', 'type': 'str'},
        'top': {'key': 'top', 'type': 'int'},
        'skip': {'key': 'skip', 'type': 'int'},
        'dedupe': {'key': 'dedupe', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(RequestItems, self).__init__(**kwargs)
        self.select = kwargs.get('select', None)
        self.order_by = kwargs.get('order_by', None)
        self.top = kwargs.get('top', None)
        self.skip = kwargs.get('skip', None)
        self.dedupe = kwargs.get('dedupe', False)
