# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .field_condition_base import FieldConditionBase


class NumericCondition(FieldConditionBase):
    """Defines an equivalence condition for a numeric field. It can appear in a
    filter, a boost, or a filter aggregation.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :param field: The name of the field.
    :type field: str
    :param value: The value to compare the field against.
    :type value: float
    :param operator: The comparison operator. Default is `gt`. Possible values
     include: 'Eq', 'Ne', 'Gt', 'Lt', 'Ge', 'Le'
    :type operator: str or
     ~microsoft.bing.commerce.search.models.ComparisonOperator
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'field': {'key': 'field', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
        'operator': {'key': 'operator', 'type': 'ComparisonOperator'},
    }

    def __init__(self, **kwargs):
        super(NumericCondition, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.operator = kwargs.get('operator', None)
        self._type = 'NumericCondition'
