# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .geo_boundary_base_py3 import GeoBoundaryBase


class GeoDistance(GeoBoundaryBase):
    """Defines a geographical boundary that matches location within a certain
    euclidean distance from a point.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :param center: The geo-location for the center point to match around.
    :type center: ~microsoft.bing.commerce.search.models.GeoPoint
    :param radius: The accpeptable euclidean distance to the center.
    :type radius: float
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'center': {'key': 'center', 'type': 'GeoPoint'},
        'radius': {'key': 'radius', 'type': 'float'},
    }

    def __init__(self, *, center=None, radius: float=None, **kwargs) -> None:
        super(GeoDistance, self).__init__(**kwargs)
        self.center = center
        self.radius = radius
        self._type = 'GeoDistance'
