# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .response_task import ResponseTask


class CommerceSearchResponse(ResponseTask):
    """The response to a Bing Commerce Search Query.

    All required parameters must be populated in order to send to Azure.

    :param errors: A list of errors that happened to the task, if any.
    :type errors: list[~microsoft.bing.commerce.search.models.ResponseError]
    :param debug:
    :type debug:
     list[~microsoft.bing.commerce.search.models.ResponseDebugInfo]
    :param _type: Required. Constant filled by server.
    :type _type: str
    :param impression_id: A random GUID to uniquely track the search response.
    :type impression_id: str
    :param query_context: The query alteration result.
    :type query_context:
     ~microsoft.bing.commerce.search.models.ResponseQueryContext
    :param items: The item results
    :type items: ~microsoft.bing.commerce.search.models.ResponseItemsBase
    :param aggregations: The aggregations result.
    :type aggregations:
     list[~microsoft.bing.commerce.search.models.ResponseAggregation]
    :param redirect_url: The redirect url for this the current query from the
     request search instance.
    :type redirect_url: str
    :param customization: The user defined customizations applied the search
     query.
    :type customization:
     ~microsoft.bing.commerce.search.models.ResponseCustomization
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[ResponseError]'},
        'debug': {'key': 'debug', 'type': '[ResponseDebugInfo]'},
        '_type': {'key': '_type', 'type': 'str'},
        'impression_id': {'key': 'impressionId', 'type': 'str'},
        'query_context': {'key': 'queryContext', 'type': 'ResponseQueryContext'},
        'items': {'key': 'items', 'type': 'ResponseItemsBase'},
        'aggregations': {'key': 'aggregations', 'type': '[ResponseAggregation]'},
        'redirect_url': {'key': 'redirectUrl', 'type': 'str'},
        'customization': {'key': 'customization', 'type': 'ResponseCustomization'},
    }

    def __init__(self, **kwargs):
        super(CommerceSearchResponse, self).__init__(**kwargs)
        self.impression_id = kwargs.get('impression_id', None)
        self.query_context = kwargs.get('query_context', None)
        self.items = kwargs.get('items', None)
        self.aggregations = kwargs.get('aggregations', None)
        self.redirect_url = kwargs.get('redirect_url', None)
        self.customization = kwargs.get('customization', None)
        self._type = 'SearchResponse'
