# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .field_condition_base import FieldConditionBase


class CategoryCondition(FieldConditionBase):
    """Defines an inclusion condition for a category field. It can appear in a
    filter, a boost, or a filter aggregation.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :param field: The name of the field.
    :type field: str
    :param value: The category to match items against. The format for
     specifying hierarchical categories is a pipe-delimited string, such as
     `Meanswear|shirts|Dress Shirts`.
    :type value: str
    :param operator: The category operator to apply. Default is `In`. Possible
     values include: 'In', 'NotIn'
    :type operator: str or
     ~microsoft.bing.commerce.search.models.CategoryOperator
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'field': {'key': 'field', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'CategoryOperator'},
    }

    def __init__(self, **kwargs):
        super(CategoryCondition, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.operator = kwargs.get('operator', None)
        self._type = 'CategoryCondition'
