# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.exceptions import HttpOperationError
from .operations.search_operations import SearchOperations
from . import models


class BingCommerceSearchConfiguration(Configuration):
    """Configuration for BingCommerceSearch
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if not base_url:
            base_url = 'https://commerce.bing.com/api/search/v1'

        super(BingCommerceSearchConfiguration, self).__init__(base_url)

        self.add_user_agent('bingcommercesearch/{}'.format(VERSION))

        self.credentials = credentials


class BingCommerceSearch(SDKClient):
    """BingCommerceSearch

    :ivar config: Configuration for client.
    :vartype config: BingCommerceSearchConfiguration

    :ivar search: Search operations
    :vartype search: microsoft.bing.commerce.search.operations.SearchOperations

    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, base_url=None):

        self.config = BingCommerceSearchConfiguration(credentials, base_url)
        super(BingCommerceSearch, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '1'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.search = SearchOperations(
            self._client, self.config, self._serialize, self._deserialize)
