/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmlsc;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.xml.XmlFactories;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ScxmlStateDiagramStandard {
    private final StateDiagram diagram;
    private final Document document;

    public ScxmlStateDiagramStandard(StateDiagram diagram) throws ParserConfigurationException {
        this.diagram = diagram;
        DocumentBuilder builder = XmlFactories.newDocumentBuilder();
        this.document = builder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        Element scxml = this.document.createElement("scxml");
        scxml.setAttribute("xmlns", "http://www.w3.org/2005/07/scxml");
        scxml.setAttribute("version", "1.0");
        String initial = this.getInitial();
        if (initial != null) {
            scxml.setAttribute("initial", initial);
        }
        this.document.appendChild(scxml);
        for (IEntity iEntity : diagram.getLeafsvalues()) {
            scxml.appendChild(this.createState(iEntity));
        }
    }

    private String getInitial() {
        for (IEntity iEntity : this.diagram.getLeafsvalues()) {
            if (iEntity.getLeafType() != LeafType.CIRCLE_START) continue;
            return this.getId(iEntity);
        }
        return null;
    }

    private Element createState(IEntity entity) {
        Element state = this.document.createElement("state");
        state.setAttribute("id", this.getId(entity));
        for (Link link : this.diagram.getLinks()) {
            if (link.getEntity1() != entity) continue;
            this.addLink(state, link);
        }
        return state;
    }

    private void addLink(Element state, Link link) {
        Element transition = this.document.createElement("transition");
        Display label = link.getLabel();
        if (!Display.isNull(label)) {
            String event = label.get(0).toString();
            transition.setAttribute("event", event);
        }
        transition.setAttribute("target", this.getId(link.getEntity2()));
        state.appendChild(transition);
    }

    private String getId(IEntity entity) {
        String result = entity.getDisplay().get(0).toString();
        result = result.replaceAll("\\*", "");
        return result;
    }

    public void transformerXml(OutputStream os) throws TransformerException, ParserConfigurationException {
        DOMSource source = new DOMSource(this.document);
        StreamResult resultat = new StreamResult(os);
        Transformer transformer = XmlFactories.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.transform(source, resultat);
    }
}

