/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UFontContext;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class DriverTextSvg
implements UDriver<UText, SvgGraphics> {
    private final StringBounder stringBounder;
    private final ClipContainer clipContainer;

    public DriverTextSvg(StringBounder stringBounder, ClipContainer clipContainer) {
        this.stringBounder = stringBounder;
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UText shape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        UClip clip = this.clipContainer.getClip();
        if (clip != null && !clip.isInside(x, y)) {
            return;
        }
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        if (HColorUtils.isTransparent(fontConfiguration.getColor())) {
            return;
        }
        UFont font = fontConfiguration.getFont();
        String fontWeight = null;
        if (fontConfiguration.containsStyle(FontStyle.BOLD) || font.isBold()) {
            fontWeight = "bold";
        }
        String fontStyle = null;
        if (fontConfiguration.containsStyle(FontStyle.ITALIC) || font.isItalic()) {
            fontStyle = "italic";
        }
        String textDecoration = null;
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            textDecoration = "underline";
        } else if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            textDecoration = "line-through";
        } else if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            textDecoration = "wavy underline";
        }
        String text = shape.getText();
        if (text.startsWith(" ")) {
            double space = this.stringBounder.calculateDimension(font, " ").getWidth();
            while (text.startsWith(" ")) {
                x += space;
                text = text.substring(1);
            }
        }
        text = StringUtils.trin(text);
        Dimension2D dim = this.stringBounder.calculateDimension(font, text);
        String backColor = null;
        double width = dim.getWidth();
        double height = dim.getHeight();
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR)) {
            HColor back = fontConfiguration.getExtendedColor();
            if (back instanceof HColorGradient) {
                HColorGradient gr = (HColorGradient)back;
                String id = svg.createSvgGradient(mapper.toRGB(gr.getColor1()), mapper.toRGB(gr.getColor2()), gr.getPolicy());
                svg.setFillColor("url(#" + id + ")");
                svg.setStrokeColor(null);
                double deltaPatch = 2.0;
                svg.svgRectangle(x, y - height + 2.0, width, height, 0.0, 0.0, 0.0, null, null);
            } else {
                backColor = mapper.toRGB(back);
            }
        }
        svg.setFillColor(mapper.toSvg(fontConfiguration.getColor()));
        svg.text(text, x, y, font.getFamily(UFontContext.SVG), font.getSize(), fontWeight, fontStyle, textDecoration, width, fontConfiguration.getAttributes(), backColor);
    }
}

