/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.Hexagon;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnectionHorizontalThenVerticalDown;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnectionLeftThenDownThenRight;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnectionVerticalDown;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnectionVerticalDownThenHorizontal;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileDiamondInside;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileIfSimple;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.ConditionEndStyle;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class GtileIfHexagon
extends GtileIfSimple {
    private final List<Branch> branches;
    private final Gtile shape1;
    private final Gtile shape2;
    private final UTranslate positionShape1;
    private final UTranslate positionShape2;

    @Override
    public String toString() {
        return "GtileIfHexagon " + this.gtiles;
    }

    public GtileIfHexagon(Swimlane swimlane, List<Gtile> gtiles, List<Branch> branches) {
        super(gtiles);
        FontConfiguration fcTest;
        HColor backColor;
        HColor borderColor;
        ConditionStyle conditionStyle = this.skinParam().getConditionStyle();
        ConditionEndStyle conditionEndStyle = this.skinParam().getConditionEndStyle();
        this.branches = branches;
        Branch branch0 = branches.get(0);
        if (UseStyle.useBetaStyle()) {
            Style styleArrow = this.getDefaultStyleDefinitionArrow().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
            Style styleDiamond = this.getDefaultStyleDefinitionDiamond().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
            borderColor = styleDiamond.value(PName.LineColor).asColor(this.skinParam().getThemeStyle(), this.skinParam().getIHtmlColorSet());
            backColor = branch0.getColor() == null ? styleDiamond.value(PName.BackGroundColor).asColor(this.skinParam().getThemeStyle(), this.skinParam().getIHtmlColorSet()) : branch0.getColor();
            fcTest = styleDiamond.getFontConfiguration(this.skinParam().getThemeStyle(), this.skinParam().getIHtmlColorSet());
        } else {
            FontParam testParam = conditionStyle == ConditionStyle.INSIDE_HEXAGON ? FontParam.ACTIVITY_DIAMOND : FontParam.ARROW;
            borderColor = this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBorder);
            backColor = branch0.getColor() == null ? this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBackground) : branch0.getColor();
            fcTest = new FontConfiguration(this.skinParam(), testParam, null).changeColor(this.fontColor(FontParam.ACTIVITY_DIAMOND));
        }
        Sheet sheet = Parser.build(fcTest, this.skinParam().getDefaultTextAlignment(HorizontalAlignment.LEFT), this.skinParam(), CreoleMode.FULL).createSheet(branch0.getLabelTest());
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, this.skinParam().getPadding());
        SheetBlock2 tbTest = new SheetBlock2(sheetBlock1, Hexagon.asStencil(sheetBlock1), new UStroke());
        this.shape1 = new GtileDiamondInside(this.getStringBounder(), tbTest, this.skinParam(), backColor, borderColor, swimlane);
        this.shape2 = new GtileDiamondInside(this.getStringBounder(), TextBlockUtils.EMPTY_TEXT_BLOCK, this.skinParam(), backColor, borderColor, swimlane);
        double height1 = this.shape1.calculateDimension(this.stringBounder).getHeight() + this.getSuppHeightMargin();
        ListIterator<UTranslate> it = this.positions.listIterator();
        while (it.hasNext()) {
            UTranslate tmp = (UTranslate)it.next();
            it.set(tmp.compose(UTranslate.dy(height1)));
        }
        if (branches.size() == 1) {
            UTranslate tmp = (UTranslate)this.positions.get(0);
            this.positions.set(0, tmp.compose(UTranslate.dx(this.missingSpace())));
        }
        this.positionShape1 = this.getCoord("NORTH_HOOK").compose(this.shape1.getCoord("NORTH_HOOK").reverse());
        this.positionShape2 = this.getCoord("SOUTH_HOOK").compose(this.shape2.getCoord("SOUTH_HOOK").reverse());
    }

    private double missingSpace() {
        if (this.branches.size() != 1) {
            throw new IllegalStateException();
        }
        return 25.0;
    }

    private double getSuppHeightMargin() {
        if (this.branches.size() == 1) {
            return 30.0;
        }
        return 10.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double height2 = this.shape2.calculateDimension(stringBounder).getHeight() + this.getSuppHeightMargin();
        Dimension2D nude = super.calculateDimension(stringBounder);
        if (this.branches.size() > 1) {
            return Dimension2DDouble.delta(nude, 0.0, height2);
        }
        return Dimension2DDouble.delta(nude, this.missingSpace(), height2);
    }

    @Override
    public UTranslate getCoord(String name) {
        UTranslate result = super.getCoord(name);
        return result;
    }

    private HColor fontColor(FontParam param) {
        return this.skinParam().getFontHtmlColor(null, param);
    }

    public final StyleSignature getDefaultStyleDefinitionActivity() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public final StyleSignature getDefaultStyleDefinitionDiamond() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public final StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    public void drawU(UGraphic ug) {
        super.drawU(ug);
        this.shape1.drawU(ug.apply(this.positionShape1));
        this.shape2.drawU(ug.apply(this.positionShape2));
    }

    @Override
    public Collection<GConnection> getInnerConnections() {
        if (this.branches.size() == 1) {
            GConnectionVerticalDown arrow1 = new GConnectionVerticalDown(this.positionShape1, this.shape1.getGPoint("SOUTH_HOOK"), (UTranslate)this.positions.get(0), ((Gtile)this.gtiles.get(0)).getGPoint("NORTH_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            GConnectionVerticalDown arrow2 = new GConnectionVerticalDown((UTranslate)this.positions.get(0), ((Gtile)this.gtiles.get(0)).getGPoint("SOUTH_HOOK"), this.positionShape2, this.shape2.getGPoint("NORTH_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            Dimension2D totalDim = this.calculateDimension(this.stringBounder);
            GConnectionLeftThenDownThenRight arrow3 = new GConnectionLeftThenDownThenRight(this.positionShape1, this.shape1.getGPoint("EAST_HOOK"), this.positionShape2, this.shape2.getGPoint("EAST_HOOK"), totalDim.getWidth(), TextBlockUtils.EMPTY_TEXT_BLOCK);
            return Arrays.asList(arrow1, arrow2, arrow3);
        }
        if (this.branches.size() == 2) {
            GConnectionHorizontalThenVerticalDown arrow1 = new GConnectionHorizontalThenVerticalDown(this.positionShape1, this.shape1.getGPoint("WEST_HOOK"), (UTranslate)this.positions.get(0), ((Gtile)this.gtiles.get(0)).getGPoint("NORTH_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            GConnectionHorizontalThenVerticalDown arrow2 = new GConnectionHorizontalThenVerticalDown(this.positionShape1, this.shape1.getGPoint("EAST_HOOK"), (UTranslate)this.positions.get(1), ((Gtile)this.gtiles.get(1)).getGPoint("NORTH_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            GConnectionVerticalDownThenHorizontal arrow3 = new GConnectionVerticalDownThenHorizontal((UTranslate)this.positions.get(0), ((Gtile)this.gtiles.get(0)).getGPoint("SOUTH_HOOK"), this.positionShape2, this.shape2.getGPoint("WEST_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            GConnectionVerticalDownThenHorizontal arrow4 = new GConnectionVerticalDownThenHorizontal((UTranslate)this.positions.get(1), ((Gtile)this.gtiles.get(1)).getGPoint("SOUTH_HOOK"), this.positionShape2, this.shape2.getGPoint("EAST_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            return Arrays.asList(arrow1, arrow2, arrow3, arrow4);
        }
        return super.getInnerConnections();
    }
}

