/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.gtile.GAbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.gtile.GPoint;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GConnectionLeftThenDownThenRight
extends GAbstractConnection
implements GConnectionTranslatable {
    private final TextBlock textBlock;
    private final UTranslate pos1;
    private final UTranslate pos2;
    private final double xright;

    public GConnectionLeftThenDownThenRight(UTranslate pos1, GPoint gpoint1, UTranslate pos2, GPoint gpoint2, double xright, TextBlock textBlock) {
        super(gpoint1, gpoint2);
        this.textBlock = textBlock;
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.xright = xright;
    }

    @Override
    public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.draw(this.getSimpleSnake());
    }

    private Rainbow getInLinkRenderingColor() {
        Rainbow color = Rainbow.build(this.gpoint1.getGtile().skinParam());
        return color;
    }

    private Snake getSimpleSnake() {
        Snake snake = Snake.create(this.getInLinkRenderingColor(), Arrows.asToLeft()).emphasizeDirection(Direction.DOWN).withLabel(this.textBlock, HorizontalAlignment.LEFT);
        Point2D p1 = this.pos1.getTranslated(this.gpoint1.getPoint2D());
        Point2D p2 = this.pos2.getTranslated(this.gpoint2.getPoint2D());
        double maxX = this.xright;
        snake.addPoint(p1);
        snake.addPoint(new Point2D.Double(maxX, p1.getY()));
        snake.addPoint(new Point2D.Double(maxX, p2.getY()));
        snake.addPoint(p2);
        return snake;
    }
}

