/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.GPoint;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public abstract class AbstractGtile
extends AbstractTextBlock
implements Gtile {
    protected final StringBounder stringBounder;
    private final ISkinParam skinParam;
    private final Swimlane singleSwimlane;
    private final Rose rose = new Rose();

    public AbstractGtile(StringBounder stringBounder, ISkinParam skinParam, Swimlane singleSwimlane) {
        this.stringBounder = stringBounder;
        this.skinParam = skinParam;
        this.singleSwimlane = singleSwimlane;
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public AbstractGtile(StringBounder stringBounder, ISkinParam skinParam) {
        this(stringBounder, skinParam, null);
    }

    @Override
    public final ISkinParam skinParam() {
        if (this.skinParam == null) {
            throw new IllegalStateException();
        }
        return this.skinParam;
    }

    public final HColorSet getIHtmlColorSet() {
        return this.skinParam.getIHtmlColorSet();
    }

    @Override
    public UTranslate getCoord(String name) {
        Dimension2D dim = this.calculateDimension(this.stringBounder);
        if (name.equals("NORTH_HOOK")) {
            return new UTranslate(dim.getWidth() / 2.0, 0.0);
        }
        if (name.equals("SOUTH_HOOK")) {
            return new UTranslate(dim.getWidth() / 2.0, dim.getHeight());
        }
        if (name.equals("WEST_HOOK")) {
            return new UTranslate(0.0, dim.getHeight() / 2.0);
        }
        if (name.equals("EAST_HOOK")) {
            return new UTranslate(dim.getWidth(), dim.getHeight() / 2.0);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public GPoint getGPoint(String name) {
        if (name.equals("NORTH_HOOK") || name.equals("SOUTH_HOOK") || name.equals("WEST_HOOK") || name.equals("EAST_HOOK")) {
            return new GPoint(this, name);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.singleSwimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.singleSwimlane);
    }

    @Override
    public Swimlane getSwimlane(String point) {
        return this.singleSwimlane;
    }

    @Override
    public Collection<GConnection> getInnerConnections() {
        return Collections.emptyList();
    }

    public final UStroke getThickness() {
        UStroke thickness = this.skinParam.getThickness(LineParam.activityBorder, null);
        if (thickness == null) {
            thickness = new UStroke(1.5);
        }
        return thickness;
    }

    protected final Rose getRose() {
        return this.rose;
    }
}

