# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['hypotest_python3_sdk']

package_data = \
{'': ['*']}

install_requires = \
['PyJWT>=2.3.0,<3.0.0', 'pip-licenses>=3.5.3,<4.0.0', 'requests>=2.27.1,<3.0.0']

setup_kwargs = {
    'name': 'hypotest-python3-sdk',
    'version': '1.0.9',
    'description': '',
    'long_description': '# HypoTest Python3 SDK\n\n[![PyPI version](https://badge.fury.io/py/optimizely-sdk.svg)](https://pypi.org/project/hypotest-python3-sdk)\n[![Apache 2.0](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](http://www.apache.org/licenses/LICENSE-2.0)\n\nThis repository houses the official Python3 SDK for use with HypoTest Hypergrowth Experimentation Platform\n\n## Getting Started\n\n### Installing the SDK\n\nThe SDK is available through [PyPi](https://pypi.python.org/pypi?hypotest-python3-sdk&:action=display).\n\nTo install:\n\n    pip install hypotest-python3-sdk\n\n## Quick Usage\n\n```python\nimport hypotest\n\n# you can configure the SDK\'s token by setting the environment variable "HT_TOKEN"\n# or by code:\nhypotest.config(token=\'JKV1QiLC29tIiwiZXhwIjox\')\n\n# reporting an event, just input the event_name and user or visitor associated with the event\nhypotest.kpi_event(event_name=\'area/user_clicked_on_XXX\', user_id=\'u123\')\n\n# add a calibration experiment, it\'s that easy:)\nhypotest.experiment(experiment_name=\'area/feature/experiment_name\', user_id=\'u123\')\n\n\n# add your first running experiment with 2 variants\nif hypotest.experiment(experiment_name=\'area/feature/experiment_name\', user_id=\'u123\').is_control:\n    # your current code\n    pass\nelse:\n    # the new code\n    pass\n\n# link between visitor and user for experiment that start before the user login and end after,\n# so we can tell the full entity story, from visitor in the landing page until a user using the core product\nhypotest.match_user_visitor(user_id=\'u123\', visitor_id=\'123\')\n```\n\n## SDK overview and principles\nthe SDK has a 2 way communication with Hypo\'s servers:\n* the sdk pulls every "pull_interval" seconds experiments settings\n* the sdk reports events back to Hypo\'s servers  \n\nthe SDK was design with safety in mind:\n* the experiment function will return "control" for every error!, such as:  \nHypo\'s servers are down  \nwrong parameters were used  \nexperiment or event don\'t exist\n* the experiment function calculate variant locally, so no need to be afraid of delaying response time\n* the SDK sends all events in a background thread\n\n## Functions description and examples:\n\n### config\n```python\ndef config(token: str = None, pull_interval: int = None, pull_jitter: int = None,\n           log_level: str = None, flush_events: bool = None, connect_to_server: bool = None)\n```\nyou can configure the sdK in 2 ways:  \n1. setting environment variables:  \n   HT_TOKEN | HT_PULL_INTERVAL | HT_PULL_JITTER | HT_LOG_LEVEL | HT_FLUSH_EVENTS | HT_CONNECT_TO_SERVER\n2. by calling this function with the below parameters  \n[all are optional]\n* **token**: the access token given by HypoTest for the SDK to be able to communicate with Hypo\'s servers \n* **pull_interval**: a background thread will pull the latest settings from the server each "poll_interval" seconds  \n* **pull_jitter**: jitter number of seconds between each pull  \n* **log_level**: the SDK log to stdout, possible options \'CRITICAL\' | \'FATAL\' | \'ERROR\' | \'WARN\' | \'WARNING\' | \'INFO\' | \'DEBUG\'| \'NOTSET\'\n* **flush_events**: True|False if the SDK flushes the remaining events in the queue before the process ends  \n* **connect_to_server**:  if False, the SDK doesn\'t connect to Hypo\'s servers. it uses dummy configuration and doesn\'t send events   \n\nexample:\n```python\ndef config(token=\'kfds9werjkvjd\', pull_interval=5, pull_jitter=1,\n           log_level=\'DEBUG\', flush_events=False, connect_to_server=False)\n```\n\n### experiment\n```python\ndef experiment(experiment_name: str, user_id: str = None, visitor_id: str = None,\n               tags: Dict[str, Union[str, int, float, bool, None]] = None, override: str = None, report_event=True)\n```\nthis function is to warp your current and new code as an experiment,  \nthe function returns the chosen variant, and report the event back to Hypo\'s servers  \nthe function calculate for each user/visitor per test a variant locally,  \nthe function is deterministic, each user/visitor combined with an experiment will allways get the same variant\n* **experiment_name**: the experiment key name as created in the platform   \n* **user_id** | **visitor_id**: user_id or visitor_id string associated with the experiment,  \nif the experiment starts before the user login/signup, use visitor_id (potential_id/anonymous_id),  \nelse use user_id\n\n**optional**\n* **tags**: a key value dictionary for "tagging" the user/visitor such as country, is_free, user_age, device_type, os, etc    \n* **override**: override the variant chosen, a string with one of the variants in the experiment  \n* **report_event**: if False, the function doesn\'t report an experiment exposure event to the servers\n\nexamples:\n```python \nif experiment(experiment_name=\'signup/alternative-landingpage/difference-copywriting\', visitor_id="v123",\n               tags={"country": "usa", "is_free": False, "user_age": 4, "device_type": mobile},\n               override="b", report_event=False).is_control:\n    # your current code here\nelse:\n    # the new code here\n```\n```python\n# only for calibration experiment\nexperiment(experiment_name=\'signup/alternative-landingpage/difference-copywriting\', visitor_id="v123",\n               tags={"country": "usa", "is_free": False, "user_age": 4, "device_type": mobile},\n               override="b", report_event=False)\n```\n\n### kpi_event\n```python\ndef kpi_event(event_name: str, user_id=None, visitor_id=None, value=1.0,\n              tags: Dict[str, Union[str, int, float, bool, None]] = None)\n```\nto report a kpi event back to Hypo\'s servers\n* **event_name**: the kpi event name key name as created in the platform  \n* **user_id** | **visitor_id**: user_id or visitor_id string associated with the event,  \nif the event occurs before the user login/signup, use visitor_id (potential_id/anonymous_id),  \nelse use user_id   \n\n**optional**  \n* **value**: the value of the event, default to 1.0, used for events sush as reporting selected pricing package, etc  \n* **tags**:  a key value dictionary for "tagging" the event such as chosen plan, login method, etc  \n\nexample:\n```python\nkpi_event(event_name="pricing/pricing-page/new-option", user_id="u456", value=39.9)\n```\n\n### match_user_visitor\n```python\ndef match_user_visitor(user_id: str, visitor_id: str, context: str = None,\n                       tags: Dict[str, Union[str, int, float, bool, None]] = None)\n```\nthe purpose of this function is to be able to connect users and visitors.\n* **user_id**: user_id string  \n* **visitor_id**: user_id string  \n\n**optional**  \n* **context**: placeholder  \n* **tags**:   a key value dictionary for "tagging" the event  \n\nexample:\n```python\nmatch_user_visitor(user_id="u456", visitor_id="v123", context="signup")\n```',
    'author': 'lior brafman',
    'author_email': 'liorb87@gmail.com',
    'maintainer': 'Lior Brafman',
    'maintainer_email': 'liorb87@gmail.com',
    'url': 'https://github.com/HypoTest-io/hypotest-python3-sdk',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.4,<4.0',
}


setup(**setup_kwargs)
