window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"phml": {"fullname": "phml", "modulename": "phml", "type": "module", "doc": "<p><img src=\"assets/badges/version.svg\" alt=\"version\" /> <a href=\"https://github.com/Tired-Fox/phml/blob/main/LICENSE\"><img src=\"https://img.shields.io/badge/License-MIT-9cf\" alt=\"License\" /></a> <a href=\"https://github.com/tired-fox/phml\" title=\"Go to GitHub repo\"><img src=\"https://img.shields.io/static/v1?label=tired-fox&amp;message=phml&amp;color=9cf&amp;logo=github\" alt=\"tired-fox - phml\" /></a>\n<a href=\"https://github.com/tired-fox/phml\"><img src=\"https://img.shields.io/github/stars/tired-fox/phml?style=social\" alt=\"stars - phml\" /></a>\n<a href=\"https://github.com/tired-fox/phml\"><img src=\"https://img.shields.io/github/forks/tired-fox/phml?style=social\" alt=\"forks - phml\" /></a></p>\n\n<h1 id=\"python-hypertext-markup-language-phml\">Python Hypertext Markup Language (phml)</h1>\n\n<p><a href=\"https://github.com/Tired-Fox/phml/actions/workflows/deploy_docs.yml\"><img src=\"https://github.com/Tired-Fox/phml/actions/workflows/deploy_docs.yml/badge.svg\" alt=\"Deploy Docs\" /></a> <a href=\"https://github.com/tired-fox/phml/releases/\"><img src=\"https://img.shields.io/github/release/tired-fox/phml?include_prereleases=&amp;sort=semver&amp;color=brightgreen\" alt=\"GitHub release\" /></a> \n<a href=\"https://github.com/tired-fox/phml/issues\"><img src=\"https://img.shields.io/github/issues/tired-fox/phml\" alt=\"issues - phml\" /></a> <img src=\"assets/badges/quality.svg\" alt=\"quality\" /> <img src=\"assets/badges/testing.svg\" alt=\"testing\" /> <img src=\"assets/badges/test_cov.svg\" alt=\"test coverage\" /></p>\n\n<p><strong>TOC</strong></p>\n\n<ul>\n<li><a href=\"#python-hypertext-markup-language-phml\">Python Hypertext Markup Language (phml)</a>\n<ul>\n<li><a href=\"#overview\">Overview</a></li>\n<li><a href=\"#how-to-use\">How to use</a></li>\n</ul></li>\n</ul>\n\n<div align=\"center\">\n\n[![view - Documentation](https://img.shields.io/badge/view-Documentation-blue?style=for-the-badge)](https://tired-fox.github.io/phml/phml.html \"Go to project documentation\")\n\n</div>\n\n<h2 id=\"overview\">Overview</h2>\n\n<p>The idea behind the creation of Python in Hypertext Markup Language (phml), is to allow for web page generation with direct access to python. This language takes inspiration directly from frameworks like Vue.js, Astro.js, Solid.js, and SvelteKit. There is conditional rendering, components, python elements, inline/embedded python blocks, and slot, named slots, and much more. Now let's dive into more the language.</p>\n\n<p>Let's start with the new <code>python</code> element. Python is a whitespace language. As such, phml\nhas the challenge of maintaining the indentation in an appropriate way as to preserve the intended whitespace. The key focus is the indended whitespace. While this can be tricky the first line with content serves as a reference. The amount of indentation for the first line is removed from each line and the remaining whitespace is left alone. For example if there is a python block that looks like this.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n  message = &quot;hello world&quot;\n  if &quot;hello&quot; in message:\n    print(message)\n<span class=\"p\">&lt;/</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>The resulting python code would look like this.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">message</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;hello world&quot;</span>\n<span class=\"k\">if</span> <span class=\"s2\">&quot;hello&quot;</span> <span class=\"ow\">in</span> <span class=\"n\">message</span><span class=\"p\">:</span>\n  <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">message</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>So now we can write python code, now what? You can define functions and variables\nhow you normally would and they are now available to the scope of the entire file. Consider the following example; You can define function called <code>URL</code> in the <code>python</code> element and it can be accessed in any other part of the file. So the code would look like this:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\ndef URL(link: str) -&gt; str:\n    links = {\n        &quot;youtube&quot;: &quot;https://youtube.com&quot;\n    }\n    if link in links:\n        return links[link]\n    else:\n        return &quot;&quot;\n<span class=\"p\">&lt;/</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n\n...\n\n<span class=\"p\">&lt;</span><span class=\"nt\">a</span> <span class=\"na\">href</span><span class=\"o\">=</span><span class=\"s\">&quot;{URL(&#39;youtube&#39;)}&quot;</span><span class=\"p\">&gt;</span>Youtube<span class=\"p\">&lt;/</span><span class=\"nt\">a</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>phml combines all <code>python</code> elements and treats them as one python file. This is of the likes of the <code>script</code> or <code>style</code> tags. With the fact that you can write any code in the python element and used it anywhere else in the file you of the full power of the python programming language at your desposal.</p>\n\n<p>Next up is inline python blocks. These are represented with <code>{{}}</code> in text elements. Any text in-between the brackets will be processed as python. This is mostly useful when you want to inject a value from python. Assume that there is a variable defined in the <code>python</code> element called <code>message</code>\nand it contains <code>Hello World!</code>. Now this variable can be used like this, <code>&lt;p&gt;{{ message }}&lt;/p&gt;</code>,\nwhich renders to, <code>&lt;p&gt;Hello World!&lt;/p&gt;</code>.</p>\n\n<blockquote>\n  <p>Note:  Inline python blocks are only rendered in a Text element or inside an html attribute.</p>\n</blockquote>\n\n<p>Conditional rendering with <code>@if</code>, <code>@elif</code>, and <code>@else</code> is an extremely helpful tool in phml.\n<code>@if</code> can be used alone and the python inside it's value must be truthy for the element to be rendered. <code>@elif</code> requires an element with a <code>@if</code> or <code>@elif</code> attribute immediately before it, and it's condition is rendered the same as <code>@if</code> but only rendered if a <code>@if</code> or <code>@elif</code> first fails. <code>@else</code> requires there to be either a <code>@if</code> or a <code>@else</code> immediately before it. It only renders if the previous element's condition fails. If <code>@elif</code> or <code>@else</code> is on an element, but the previous element isn't a <code>@if</code> or <code>@elif</code> then an exception will occur. Most importantly, the first element in a chain of conditions must be a <code>@if</code>.</p>\n\n<p>Other than conditions, there is also a built in for loop element. The format looks something like <code>&lt;For :each=\"item in collection&gt;\"</code> and it duplicates it's children at the node position of the <code>For</code> element. The <code>For</code> element requires there to be an <code>each</code> attribute for it to be rendered. You can consider the value of this element as pythons equivelent to <code>for item in collection:</code> as this is what the <code>each</code> attribute expands out to. The attributes defined in the <code>each</code> element, <code>item</code> from the previous example, is exposed to the children of the for loop. The attributes from the iteration are scoped recursively through the children. All conditionals work for the the <code>For</code> element. An added feature is when a <code>For</code> iteration has an error or iterates zero times, the <code>@elif</code> or <code>@else</code> following the <code>For</code> is used instead. This means that a <code>For</code> failing or generating zero is like a failed <code>@if</code> and can be treated as such. Below is an example of how a <code>For</code> element could be used.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">ul</span>\n  <span class=\"err\">&lt;</span><span class=\"na\">For</span> <span class=\"na\">:each</span><span class=\"o\">=</span><span class=\"s\">&quot;i in range(3)&quot;</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>{i}<span class=\"p\">&lt;/</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n  <span class=\"p\">&lt;/</span><span class=\"nt\">For</span><span class=\"p\">&gt;</span>\n  <span class=\"p\">&lt;</span><span class=\"nt\">li</span> <span class=\"err\">@</span><span class=\"na\">else</span><span class=\"p\">&gt;</span>No items in range<span class=\"p\">&lt;/</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;/</span><span class=\"nt\">ul</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>The compiled html will be:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">ul</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>1<span class=\"p\">&lt;/</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>2<span class=\"p\">&lt;/</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>3<span class=\"p\">&lt;/</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;/</span><span class=\"nt\">ul</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>Python attributes are shortcuts for using inline python blocks in html attributes. Normally, in phml, you would inject python logic into an attribute similar to this <code>src=\"{url('youtube')}\"</code>. If you would like to make the whole attribute value a python expression you may prefix any attribute with a <code>:</code>. This keeps the attribute name the same after the prefix, but tells the parser that the entire value should be processed as python. So the previous example with <code>URL</code> can also be expressed as <code>&lt;a :href=\"URL('youtube')&gt;Youtube&lt;/a&gt;\"</code>.</p>\n\n<p>PHML includes a powerful component system. The components are partial phml files and are added to the core compiler. After adding the component whenever an element with the same name as the component is found, it is replaced. Components have scoped <code>python</code> elements, while all <code>style</code> and <code>script</code> elements are global to the file they are injected into. Components require that there is only one element, that isn't a <code>python</code>, <code>script</code>, or <code>style</code> tag, to be present. A sample component can look something like the example below. </p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cm\">&lt;!-- Component.phml --&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">div</span><span class=\"p\">&gt;</span>\n # content goes here\n<span class=\"p\">&lt;/</span><span class=\"nt\">div</span><span class=\"p\">&gt;</span>\n\n<span class=\"p\">&lt;</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n# python code goes here\n<span class=\"p\">&lt;/</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">style</span><span class=\"p\">&gt;</span><span class=\"w\"></span>\n<span class=\"c\">/* styles go here */</span><span class=\"w\"></span>\n<span class=\"p\">&lt;/</span><span class=\"nt\">style</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">script</span><span class=\"p\">&gt;</span><span class=\"w\"></span>\n<span class=\"c1\">// js goes here</span><span class=\"w\"></span>\n<span class=\"p\">&lt;/</span><span class=\"nt\">script</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>Components can be added to the compiler by using <code>PHML.add('path/to/component.phml')</code>. You can define a components name when adding it to the compiler like this <code>PHML.add(('Component', 'path/to/component.phml'))</code>, or you can just let the compiler figure it out for you. Each directory in the path given along with the file name are combine to create the components name. So if you pass a component path that is <code>path/to/component.phml</code> it will create a components name of <code>Path.To.Component</code> which is then used as <code>&lt;Path.To.Component /&gt;</code>. The compiler will try to parse and understand the component name and make it Pascal case. So if you have a file name of <code>CoMP_onEnt.phml</code> it will result in <code>CoMPOnEnt</code>. It uses <code>_</code> as a seperator between words along with capital letters. It will also recognize an all caps word bordering a new word with a capital letter.</p>\n\n<p>Great now you have components. But what if you have a few components that are siblings and you don't want them to be nested in a parent element. PHML provides a <code>&lt;&gt;</code> element which is a placeholder element. All children are treated as they are at the root of the component.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cm\">&lt;!-- file.phml --&gt;</span>\n...\n<span class=\"p\">&lt;</span><span class=\"nt\">body</span><span class=\"p\">&gt;</span>\n  <span class=\"p\">&lt;</span><span class=\"nt\">Component</span> <span class=\"p\">/&gt;</span>\n<span class=\"p\">&lt;/</span><span class=\"nt\">body</span><span class=\"p\">&gt;</span>\n...\n<span class=\"cm\">&lt;!-- Component.phml --&gt;</span>\n<span class=\"err\">&lt;</span>&gt;\n  <span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>Hello<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n  <span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>World<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n<span class=\"err\">&lt;</span>&gt;\n</code></pre>\n</div>\n\n<p>will result in the following rendered html</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cm\">&lt;!-- file.html --&gt;</span>\n...\n<span class=\"p\">&lt;</span><span class=\"nt\">body</span><span class=\"p\">&gt;</span>\n  <span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>Hello<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n  <span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>World<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;/</span><span class=\"nt\">body</span><span class=\"p\">&gt;</span>\n...\n</code></pre>\n</div>\n\n<p>Now how do you pass information to component to use in rendering? That is where the <code>Props</code> variable comes in. The <code>Props</code> variable is a dictionary defined in the components <code>python</code> element. This defines what attributes on the component are props along with their default values.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cm\">&lt;!-- component.phml --&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\nProps = {\n  message: &quot;&quot;\n}\n<span class=\"p\">&lt;/</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>{{ message }}<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n\n<span class=\"cm\">&lt;!-- file.phml --&gt;</span>\n...\n<span class=\"p\">&lt;</span><span class=\"nt\">Component</span> <span class=\"na\">message</span><span class=\"o\">=</span><span class=\"s\">&quot;Hello World!&quot;</span> <span class=\"p\">/&gt;</span>\n...\n</code></pre>\n</div>\n\n<p>Both normal attribute values and python attributes can be used for props. The above example really only works for self closing components. What if you want to pass children to the component? That is where slots come in.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\nProps = {\n  message: &quot;&quot;\n}\n<span class=\"p\">&lt;/</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n\n<span class=\"p\">&lt;</span><span class=\"nt\">div</span> <span class=\"na\">class</span><span class=\"o\">=</span><span class=\"s\">&quot;callout&quot;</span><span class=\"p\">&gt;</span>\n  <span class=\"p\">&lt;</span><span class=\"nt\">p</span> <span class=\"err\">@</span><span class=\"na\">if</span><span class=\"o\">=</span><span class=\"s\">&quot;message is not None&quot;</span><span class=\"p\">&gt;</span>{{ message }}<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n  <span class=\"p\">&lt;</span><span class=\"nt\">Slot</span> <span class=\"p\">/&gt;</span>\n<span class=\"p\">&lt;/</span><span class=\"nt\">div</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>The <code>Slot</code> element must be capitalized. When a <code>Slot</code> element is present any children inside of a component are inserted in place of it. If no children exist then the slot is just removed. What about having multiple slots and having certain components go to certain slot. PHML covers this with the <code>slot</code> and <code>name</code> attribute. The slot attribute holds the name of the slot that the child element should be placed in. The name attribute goes on the <code>Slot</code> element itself giving it it's name. There may only be one <code>Slot</code> of every name including the default <code>Slot</code> with no name attribute. An example of this will look something like this.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cm\">&lt;!-- component.phml --&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">div</span><span class=\"p\">&gt;</span>\n  <span class=\"p\">&lt;</span><span class=\"nt\">Slot</span> <span class=\"na\">name</span><span class=\"o\">=</span><span class=\"s\">&quot;top&quot;</span> <span class=\"p\">/&gt;</span>\n  <span class=\"p\">&lt;</span><span class=\"nt\">Slot</span> <span class=\"p\">/&gt;</span>\n  <span class=\"p\">&lt;</span><span class=\"nt\">Slot</span> <span class=\"na\">name</span><span class=\"o\">=</span><span class=\"s\">&quot;bottom&quot;</span> <span class=\"p\">/&gt;</span>\n<span class=\"p\">&lt;/</span><span class=\"nt\">div</span><span class=\"p\">&gt;</span>\n\n<span class=\"cm\">&lt;!-- file.phml --&gt;</span>\n...\n<span class=\"p\">&lt;</span><span class=\"nt\">Component</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span> <span class=\"na\">slot</span><span class=\"o\">=</span><span class=\"s\">&quot;bottom&quot;</span><span class=\"p\">&gt;</span>Bottom<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span> <span class=\"na\">slot</span><span class=\"o\">=</span><span class=\"s\">&quot;top&quot;</span><span class=\"p\">&gt;</span>Top<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\nMiddle\n<span class=\"p\">&lt;/</span><span class=\"nt\">Component</span><span class=\"p\">&gt;</span>\n...\n\n<span class=\"cm\">&lt;!-- file.html --&gt;</span>\n...\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span> <span class=\"na\">slot</span><span class=\"o\">=</span><span class=\"s\">&quot;top&quot;</span><span class=\"p\">&gt;</span>Top<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\nMiddle\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span> <span class=\"na\">slot</span><span class=\"o\">=</span><span class=\"s\">&quot;bottom&quot;</span><span class=\"p\">&gt;</span>Bottom<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n...\n</code></pre>\n</div>\n\n<p>PHML also has very basic markdown support. You may use the <code>Markdown</code> element to render markdown in place of the element itself. The element has 3 main uses: using the <code>src</code>/<code>:src</code> attribute to pass a string, the <code>file</code>/<code>:file</code> attribute to load the markdown from a file, and finally to just write markdown text inside as children to the element. The text as children is adjusted to have a normalized indent similar to the <code>python</code> element. If all of these methods are used, they are combined. The are combined in the order of <code>src</code>, then <code>file</code>, then the children.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cm\">&lt;!-- file.phml --&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">Markdown</span>\n  <span class=\"na\">src</span><span class=\"o\">=</span><span class=\"s\">&quot;# Sample markdown&quot;</span>\n  <span class=\"na\">file</span><span class=\"o\">=</span><span class=\"s\">&quot;../markdown/file.md&quot;</span>\n<span class=\"p\">&gt;</span>\n  This is samle markdown text.\n<span class=\"p\">&lt;/</span><span class=\"nt\">Markdown</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<blockquote>\n  <p>:warning: This language is in early development stages. Everything is currently subject to change. All forms of feedback are encouraged.</p>\n</blockquote>\n\n<p>For more information check out the <a href=\"https://tired-fox.github.io/phml/phml.html\">API Docs</a></p>\n\n<h2 id=\"how-to-use\">How to use</h2>\n\n<p>The current version is able to parse phml using an html parser. This creates a phml ast which then can be converted back to phml or to json.</p>\n\n<p><strong>Use</strong></p>\n\n<p>PHML provides file type variables for better ease of use. The types include <code>HTML</code>, <code>PHML</code>, <code>JSON</code>, and <code>XML</code>. They can be used with the import <code>from phml import Formats</code>. Then all you need to do is use <code>Formats.HTML</code> or any other format. If you want to compile to <code>html</code> then there is no need to use the <code>Formats</code> import.</p>\n\n<p>First import the core parser and compiler, <code>from phml import PHML</code>. Then you can do the following:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">phml</span> <span class=\"o\">=</span> <span class=\"n\">PHML</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">load</span><span class=\"p\">(</span><span class=\"s2\">&quot;path/to/file.phml&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">render</span><span class=\"p\">())</span>\n</code></pre>\n</div>\n\n<p>There is method chaining so most if not all methods can be chained. The obvious exception being any method that returns a value.</p>\n\n<p>By default <code>PHML.render()</code> will return the <code>html</code> string. If you want to get a <code>json</code> string you may pass <code>Formats.JSON</code>. <code>PHML.render(file_type=Formats.JSON)</code>.</p>\n\n<p>If you want to write to a file you can call <code>PHML.write(\"path/to/output/file.phml\")</code>. Same with <code>render</code> it defaults to html. You can change this the same way as <code>render</code>. <code>PHML.write(\"path/to/otuput/file.json\", file_type=Formats.JSON)</code>.</p>\n\n<p>For both <code>render</code> and <code>write</code> you will first need to call <code>PHML.load(\"path/to/source/file.phml\")</code>. This parses the source file and stores the ast in the parser. <code>render</code> and <code>write</code> then use that ast to create the desired output. Optionally if you already have a phml or html string or a properly formatted dict you can call <code>core.parse(data)</code> which will parse that information similar to <code>load</code>.</p>\n\n<p>Every time <code>PHML.parse</code> or <code>PHML.load</code> is called it will overwrite the stored ast variable.</p>\n\n<p>There are many more features such as globally exposed variables, components, slots, exposing python files to be used in phml files, etc...</p>\n"}, "phml.builder": {"fullname": "phml.builder", "modulename": "phml.builder", "type": "module", "doc": "<p>phml.utilities.builder</p>\n\n<p>This module serves as a utility to make building elements and ast's easier.</p>\n"}, "phml.builder.p": {"fullname": "phml.builder.p", "modulename": "phml.builder", "qualname": "p", "type": "function", "doc": "<p>Generic factory for creating phml nodes.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">selector</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core": {"fullname": "phml.core", "modulename": "phml.core", "type": "module", "doc": "<p></p>\n"}, "phml.core.compiler": {"fullname": "phml.core.compiler", "modulename": "phml.core.compiler", "type": "module", "doc": "<p>phml.core.compile</p>\n\n<p>The heavy lifting module that compiles phml ast's to different string/file\nformats.</p>\n"}, "phml.core.compiler.Compiler": {"fullname": "phml.core.compiler.Compiler", "modulename": "phml.core.compiler", "qualname": "Compiler", "type": "class", "doc": "<p>Used to compile phml into other formats. HTML, PHML,\nJSON, Markdown, etc...</p>\n"}, "phml.core.compiler.Compiler.__init__": {"fullname": "phml.core.compiler.Compiler.__init__", "modulename": "phml.core.compiler", "qualname": "Compiler.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">_ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">enable</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;html&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;markdown&#39;</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.compiler.Compiler.ast": {"fullname": "phml.core.compiler.Compiler.ast", "modulename": "phml.core.compiler", "qualname": "Compiler.ast", "type": "variable", "doc": "<p>phml ast used by the compiler to generate a new format.</p>\n", "annotation": ": phml.core.nodes.AST.AST"}, "phml.core.compiler.Compiler.add": {"fullname": "phml.core.compiler.Compiler.add", "modulename": "phml.core.compiler", "qualname": "Compiler.add", "type": "function", "doc": "<p>Add a component to the compilers component list.</p>\n\n<p>Components passed in can be of a few types. It can also be a\ndictionary of str being the name of the element to be replaced. The\nname can be snake case, camel case, or pascal cased. The value can\neither be the parsed result of the component from\nphml.utilities.parse_component() or the parsed ast of the component.\nLastely, the component can be a tuple. The first value is the name of\nthe element to be replaced; with the second value being either the\nparsed result of the component or the component's ast.</p>\n\n<h6 id=\"note\">Note</h6>\n\n<blockquote>\n  <p>Any duplicate components will be replaced.</p>\n</blockquote>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>components:</strong>  Any number values indicating</li>\n<li>name of the component and the the component. The name is used</li>\n<li>to replace a element with the tag==name.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.compiler.Compiler.remove": {"fullname": "phml.core.compiler.Compiler.remove", "modulename": "phml.core.compiler", "qualname": "Compiler.remove", "type": "function", "doc": "<p>Takes either component names or components and removes them\nfrom the dictionary.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>components (str | NODE):</strong>  Any str name of components or</li>\n<li>node value to remove from the components list in the compiler.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.compiler.Compiler.compile": {"fullname": "phml.core.compiler.Compiler.compile", "modulename": "phml.core.compiler", "qualname": "Compiler.compile", "type": "function", "doc": "<p>Execute compilation to a different format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">_ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\tto_format: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">safe_vars</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.compiler.Compiler.render": {"fullname": "phml.core.compiler.Compiler.render", "modulename": "phml.core.compiler", "qualname": "Compiler.render", "type": "function", "doc": "<p>Execute compilation to a different format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">_ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\tto_format: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">safe_vars</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.core": {"fullname": "phml.core.core", "modulename": "phml.core.core", "type": "module", "doc": "<p></p>\n"}, "phml.core.core.PHML": {"fullname": "phml.core.core.PHML", "modulename": "phml.core.core", "qualname": "PHML", "type": "class", "doc": "<p>A helper class that bundles the functionality\nof the parser and compiler together. Allows for loading source files,\nparsing strings and dicts, rendering to a different format, and finally\nwriting the results of a render to a file.</p>\n"}, "phml.core.core.PHML.__init__": {"fullname": "phml.core.core.PHML.__init__", "modulename": "phml.core.core", "qualname": "PHML.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">enable</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;html&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;markdown&#39;</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">{</span><span class=\"s1\">&#39;html&#39;</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">,</span> <span class=\"s1\">&#39;markdown&#39;</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">,</span> <span class=\"s1\">&#39;for&#39;</span><span class=\"p\">:</span> <span class=\"kc\">True</span><span class=\"p\">}</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">contexts</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span>)</span>"}, "phml.core.core.PHML.ast": {"fullname": "phml.core.core.PHML.ast", "modulename": "phml.core.core", "qualname": "PHML.ast", "type": "variable", "doc": "<p>The parsed ast value.</p>\n", "annotation": ": phml.core.nodes.AST.AST"}, "phml.core.core.PHML.components": {"fullname": "phml.core.core.PHML.components", "modulename": "phml.core.core", "qualname": "PHML.components", "type": "variable", "doc": "<p>The components currently stored in the compiler.</p>\n", "annotation": ": dict"}, "phml.core.core.PHML.expose": {"fullname": "phml.core.core.PHML.expose", "modulename": "phml.core.core", "qualname": "PHML.expose", "type": "function", "doc": "<p>Add additional data to the compilers global values. These values are exposed for every\ncall to render or write.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.redact": {"fullname": "phml.core.core.PHML.redact", "modulename": "phml.core.core", "qualname": "PHML.redact", "type": "function", "doc": "<p>Remove a value from the compilers globally exposed values.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.expand": {"fullname": "phml.core.core.PHML.expand", "modulename": "phml.core.core", "qualname": "PHML.expand", "type": "function", "doc": "<p>Add relative paths to a directory, that you want added to the python path\nfor every time render or write is called.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.restrict": {"fullname": "phml.core.core.PHML.restrict", "modulename": "phml.core.core", "qualname": "PHML.restrict", "type": "function", "doc": "<p>Remove relative paths to a directory, that are in the compilers globally added scopes.\nThis prevents them from being added to the python path.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.add": {"fullname": "phml.core.core.PHML.add", "modulename": "phml.core.core", "qualname": "PHML.add", "type": "function", "doc": "<p>Add a component to the compiler's component list.</p>\n\n<p>Components passed in can be of a few types. The first type it can be is a\npathlib.Path type. This will allow for automatic parsing of the file at the\npath and then the filename and parsed ast are passed to the compiler. It can\nalso be a dictionary of str being the name of the element to be replaced.\nThe name can be snake case, camel case, or pascal cased. The value can either\nbe the parsed result of the component from phml.utilities.parse_component() or the\nparsed ast of the component. Lastely, the component can be a tuple. The first\nvalue is the name of the element to be replaced; with the second value being\neither the parsed result of the component or the component's ast.</p>\n\n<h6 id=\"note\">Note</h6>\n\n<blockquote>\n  <p>Any duplicate components will be replaced.</p>\n</blockquote>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>components:</strong>  Any number values indicating</li>\n<li>name of the component and the the component. The name is used</li>\n<li>to replace a element with the tag==name.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">strip</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.remove": {"fullname": "phml.core.core.PHML.remove", "modulename": "phml.core.core", "qualname": "PHML.remove", "type": "function", "doc": "<p>Remove an element from the list of element replacements.</p>\n\n<p>Takes any number of strings or node objects. If a string is passed\nit is used as the key that will be removed. If a node object is passed\nit will attempt to find a matching node and remove it.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.load": {"fullname": "phml.core.core.PHML.load", "modulename": "phml.core.core", "qualname": "PHML.load", "type": "function", "doc": "<p>Load a source files data and parse it to phml.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>file_path (str | Path):</strong>  The file path to the source file.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">file_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">from_format</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">formats</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"o\">.</span><span class=\"n\">Format</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.parse": {"fullname": "phml.core.core.PHML.parse", "modulename": "phml.core.core", "qualname": "PHML.parse", "type": "function", "doc": "<p>Parse a str or dict object into phml.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>data (str | dict):</strong>  Object to parse to phml</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\tfrom_format: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.phml_format.PHMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.compile": {"fullname": "phml.core.core.PHML.compile", "modulename": "phml.core.core", "qualname": "PHML.compile", "type": "function", "doc": "<p>Compile the parsed ast into it's fully processed form.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>file_type (str):</strong>  The format to render to. Currently support html, phml, and json.</li>\n<li><strong>indent (Optional[int], optional):</strong>  The number of spaces per indent. By default it will</li>\n<li>use the standard for the given format. HTML has 4 spaces, phml has 4 spaces, and json</li>\n<li>has 2 spaces.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>AST: The processed ast. Ast is in the final format of the passed in file_type</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\tfile_type: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.core.PHML.render": {"fullname": "phml.core.core.PHML.render", "modulename": "phml.core.core", "qualname": "PHML.render", "type": "function", "doc": "<p>Render the parsed ast to a different format. Defaults to rendering to html.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>file_type (str):</strong>  The format to render to. Currently support html, phml, and json.</li>\n<li><strong>indent (Optional[int], optional):</strong>  The number of spaces per indent. By default it will</li>\n<li>use the standard for the given format. HTML has 4 spaces, phml has 4 spaces, and json</li>\n<li>has 2 spaces.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: The rendered content in the appropriate format.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\tfile_type: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.core.PHML.write": {"fullname": "phml.core.core.PHML.write", "modulename": "phml.core.core", "qualname": "PHML.write", "type": "function", "doc": "<p>Renders the parsed ast to a different format, then writes\nit to a given file. Defaults to rendering and writing out as html.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>file (str | Path | TextIOWrapper):</strong>  The path to the file to be written to, or the opened</li>\n<li>file to write to.</li>\n<li><strong>file_type (str):</strong>  The format to render the ast as.</li>\n<li><strong>indent (Optional[int], optional):</strong>  The number of spaces per indent. By default it will</li>\n<li>use the standard for the given format. HTML has 4 spaces, phml has 4 spaces, and json</li>\n<li>has 2 spaces.</li>\n<li><strong>scopes (list[str], None):</strong>  The relative paths from the cwd to the directory that will</li>\n<li>be inserted into the python path.</li>\n<li><strong>replace_suffix (bool):</strong>  Override to use the preferred file suffix no matter what.</li>\n<li>Defaults to False, as the preferred suffix will only be used if no suffix is provided.</li>\n<li><strong>kwargs:</strong>  Any additional data to pass to the compiler that will be exposed to the</li>\n<li>phml files.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">TextIOWrapper</span>,</span><span class=\"param\">\tfile_type: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">replace_suffix</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.Compiler": {"fullname": "phml.core.core.Compiler", "modulename": "phml.core.core", "qualname": "Compiler", "type": "class", "doc": "<p>Used to compile phml into other formats. HTML, PHML,\nJSON, Markdown, etc...</p>\n"}, "phml.core.core.Compiler.__init__": {"fullname": "phml.core.core.Compiler.__init__", "modulename": "phml.core.core", "qualname": "Compiler.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">_ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">enable</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;html&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;markdown&#39;</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.core.Compiler.ast": {"fullname": "phml.core.core.Compiler.ast", "modulename": "phml.core.core", "qualname": "Compiler.ast", "type": "variable", "doc": "<p>phml ast used by the compiler to generate a new format.</p>\n", "annotation": ": phml.core.nodes.AST.AST"}, "phml.core.core.Compiler.add": {"fullname": "phml.core.core.Compiler.add", "modulename": "phml.core.core", "qualname": "Compiler.add", "type": "function", "doc": "<p>Add a component to the compilers component list.</p>\n\n<p>Components passed in can be of a few types. It can also be a\ndictionary of str being the name of the element to be replaced. The\nname can be snake case, camel case, or pascal cased. The value can\neither be the parsed result of the component from\nphml.utilities.parse_component() or the parsed ast of the component.\nLastely, the component can be a tuple. The first value is the name of\nthe element to be replaced; with the second value being either the\nparsed result of the component or the component's ast.</p>\n\n<h6 id=\"note\">Note</h6>\n\n<blockquote>\n  <p>Any duplicate components will be replaced.</p>\n</blockquote>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>components:</strong>  Any number values indicating</li>\n<li>name of the component and the the component. The name is used</li>\n<li>to replace a element with the tag==name.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.Compiler.remove": {"fullname": "phml.core.core.Compiler.remove", "modulename": "phml.core.core", "qualname": "Compiler.remove", "type": "function", "doc": "<p>Takes either component names or components and removes them\nfrom the dictionary.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>components (str | NODE):</strong>  Any str name of components or</li>\n<li>node value to remove from the components list in the compiler.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.Compiler.compile": {"fullname": "phml.core.core.Compiler.compile", "modulename": "phml.core.core", "qualname": "Compiler.compile", "type": "function", "doc": "<p>Execute compilation to a different format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">_ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\tto_format: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">safe_vars</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.core.Compiler.render": {"fullname": "phml.core.core.Compiler.render", "modulename": "phml.core.core", "qualname": "Compiler.render", "type": "function", "doc": "<p>Execute compilation to a different format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">_ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\tto_format: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">safe_vars</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.defaults": {"fullname": "phml.core.defaults", "modulename": "phml.core.defaults", "type": "module", "doc": "<p></p>\n"}, "phml.core.defaults.config": {"fullname": "phml.core.defaults.config", "modulename": "phml.core.defaults.config", "type": "module", "doc": "<p></p>\n"}, "phml.core.formats": {"fullname": "phml.core.formats", "modulename": "phml.core.formats", "type": "module", "doc": "<p>phml.core.formats</p>\n\n<p>A collection of Formats which represent supported file formats. Each format can\nparse data, either string or dict, into a phml.core.nodes.AST along with compiling\na phml.core.nodes.ast into it's corresponding file formats string representation.</p>\n"}, "phml.core.formats.Formats": {"fullname": "phml.core.formats.Formats", "modulename": "phml.core.formats", "qualname": "Formats", "type": "class", "doc": "<p>Collection of all built-in file formats.</p>\n"}, "phml.core.formats.Formats.__init__": {"fullname": "phml.core.formats.Formats.__init__", "modulename": "phml.core.formats", "qualname": "Formats.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\tPHML: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.phml_format.PHMLFormat&#x27;&gt;,</span><span class=\"param\">\tHTML: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\tJSON: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.json_format.JSONFormat&#x27;&gt;,</span><span class=\"param\">\tXML: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.xml_format.XMLFormat&#x27;&gt;</span>)</span>"}, "phml.core.formats.Formats.PHML": {"fullname": "phml.core.formats.Formats.PHML", "modulename": "phml.core.formats", "qualname": "Formats.PHML", "type": "class", "doc": "<p>Logic for parsing and compiling html files.</p>\n", "bases": "phml.core.formats.format.Format"}, "phml.core.formats.Formats.HTML": {"fullname": "phml.core.formats.Formats.HTML", "modulename": "phml.core.formats", "qualname": "Formats.HTML", "type": "class", "doc": "<p>Logic for parsing and compiling html files.</p>\n", "bases": "phml.core.formats.format.Format"}, "phml.core.formats.Formats.JSON": {"fullname": "phml.core.formats.Formats.JSON", "modulename": "phml.core.formats", "qualname": "Formats.JSON", "type": "class", "doc": "<p>Logic for parsing and compiling html files.</p>\n", "bases": "phml.core.formats.format.Format"}, "phml.core.formats.Formats.XML": {"fullname": "phml.core.formats.Formats.XML", "modulename": "phml.core.formats", "qualname": "Formats.XML", "type": "class", "doc": "<p>Logic for parsing and compiling html files.</p>\n", "bases": "phml.core.formats.format.Format"}, "phml.core.formats.compile": {"fullname": "phml.core.formats.compile", "modulename": "phml.core.formats.compile", "type": "module", "doc": "<p></p>\n"}, "phml.core.formats.compile.compile": {"fullname": "phml.core.formats.compile.compile", "modulename": "phml.core.formats.compile.compile", "type": "module", "doc": "<p>Helper methods for processing dynamic python attributes and blocks.</p>\n"}, "phml.core.formats.compile.compile.process_reserved_attrs": {"fullname": "phml.core.formats.compile.compile.process_reserved_attrs", "modulename": "phml.core.formats.compile.compile", "qualname": "process_reserved_attrs", "type": "function", "doc": "<p>Based on the props name, process/translate the props value.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">prop</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.process_props": {"fullname": "phml.core.formats.compile.compile.process_props", "modulename": "phml.core.formats.compile.compile", "qualname": "process_props", "type": "function", "doc": "<p>Process props inline python and reserved value translations.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">child</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"n\">local_vars</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.apply_conditions": {"fullname": "phml.core.formats.compile.compile.apply_conditions", "modulename": "phml.core.formats.compile.compile", "qualname": "apply_conditions", "type": "function", "doc": "<p>Applys all <code>py-if</code>, <code>py-elif</code>, and <code>py-else</code> to the node\nrecursively.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (Root | Element):</strong>  The node to recursively apply <code>py-</code> attributes\ntoo.</li>\n<li><strong>virtual_python (VirtualPython):</strong>  All of the data from the python\nelements.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;enabled&#39;</span><span class=\"p\">],</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;html&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;markdown&#39;</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.process_reserved_elements": {"fullname": "phml.core.formats.compile.compile.process_reserved_elements", "modulename": "phml.core.formats.compile.compile", "qualname": "process_reserved_elements", "type": "function", "doc": "<p>Process all reserved elements and replace them with the results.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"n\">enabled</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;html&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;markdown&#39;</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.apply_python": {"fullname": "phml.core.formats.compile.compile.apply_python", "modulename": "phml.core.formats.compile.compile", "qualname": "apply_python", "type": "function", "doc": "<p>Recursively travers the node and search for python blocks. When found\nprocess them and apply the results.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>current (Root | Element):</strong>  The node to traverse</li>\n<li><strong>virtual_python (VirtualPython):</strong>  The python elements data</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">current</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.py_condition": {"fullname": "phml.core.formats.compile.compile.py_condition", "modulename": "phml.core.formats.compile.compile", "qualname": "py_condition", "type": "function", "doc": "<p>Return all python condition attributes on an element.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.process_conditions": {"fullname": "phml.core.formats.compile.compile.process_conditions", "modulename": "phml.core.formats.compile.compile", "qualname": "process_conditions", "type": "function", "doc": "<p>Process all python condition attributes in the phml tree.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>tree (Root | Element):</strong>  The tree to process conditions on.</li>\n<li><strong>virtual_python (VirtualPython):</strong>  The collection of information from the\npython blocks.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.execute_conditions": {"fullname": "phml.core.formats.compile.compile.execute_conditions", "modulename": "phml.core.formats.compile.compile", "qualname": "execute_conditions", "type": "function", "doc": "<p>Execute all the conditions. If the condition is a <code>for</code> then generate\nmore nodes. All other conditions determine if the node stays or is removed.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>cond (list[tuple]):</strong>  The list of conditions to apply. Holds tuples of\n(condition, node).</li>\n<li><strong>children (list):</strong>  List of current nodes children.</li>\n<li><strong>virtual_python (VirtualPython):</strong>  The collection of information from the\npython blocks.</li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>Exception:</strong>  An unkown conditional attribute is being parsed.</li>\n<li><strong>Exception:</strong>  Condition requirements are not met.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list: The newly generated/modified list of children.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">cond</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.build_locals": {"fullname": "phml.core.formats.compile.compile.build_locals", "modulename": "phml.core.formats.compile.compile", "qualname": "build_locals", "type": "function", "doc": "<p>Build a dictionary of local variables from a nodes inherited locals and\nthe passed kwargs.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">child</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.run_phml_if": {"fullname": "phml.core.formats.compile.compile.run_phml_if", "modulename": "phml.core.formats.compile.compile", "qualname": "run_phml_if", "type": "function", "doc": "<p>Run the logic for manipulating the children on a <code>if</code> condition.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">child</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.run_phml_elif": {"fullname": "phml.core.formats.compile.compile.run_phml_elif", "modulename": "phml.core.formats.compile.compile", "qualname": "run_phml_elif", "type": "function", "doc": "<p>Run the logic for manipulating the children on a <code>elif</code> condition.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">child</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">variables</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.run_phml_else": {"fullname": "phml.core.formats.compile.compile.run_phml_else", "modulename": "phml.core.formats.compile.compile", "qualname": "run_phml_else", "type": "function", "doc": "<p>Run the logic for manipulating the children on a <code>else</code> condition.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">child</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">variables</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.ASTRenderer": {"fullname": "phml.core.formats.compile.compile.ASTRenderer", "modulename": "phml.core.formats.compile.compile", "qualname": "ASTRenderer", "type": "class", "doc": "<p>Compiles an ast to a hypertext markup language. Compiles to a tag based\nstring.</p>\n"}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"fullname": "phml.core.formats.compile.compile.ASTRenderer.__init__", "modulename": "phml.core.formats.compile.compile", "qualname": "ASTRenderer.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">_offset</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">4</span></span>)</span>"}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"fullname": "phml.core.formats.compile.compile.ASTRenderer.compile", "modulename": "phml.core.formats.compile.compile", "qualname": "ASTRenderer.compile", "type": "function", "doc": "<p>Compile an ast to html.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>ast (AST):</strong>  The phml ast to compile.</li>\n<li><strong>offset (int | None):</strong>  The amount to offset for each nested element</li>\n<li><strong>include_doctype (bool):</strong>  Whether to validate for doctype and auto\ninsert if it is missing.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">_offset</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">include_doctype</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.component": {"fullname": "phml.core.formats.compile.component", "modulename": "phml.core.formats.compile.component", "type": "module", "doc": "<p></p>\n"}, "phml.core.formats.compile.component.substitute_component": {"fullname": "phml.core.formats.compile.component.substitute_component", "modulename": "phml.core.formats.compile.component", "qualname": "substitute_component", "type": "function", "doc": "<p>Replace the first occurance of a component.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (Root | Element | AST):</strong>  The starting point.</li>\n<li><strong>virtual_python (VirtualPython):</strong>  The python state to use while evaluating prop values</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">component</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.component.replace_components": {"fullname": "phml.core.formats.compile.component.replace_components", "modulename": "phml.core.formats.compile.component", "qualname": "replace_components", "type": "function", "doc": "<p>Iterate through components and replace all of each component in the nodes children.\nNon-recursive.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (Root | Element | AST):</strong>  The starting point.</li>\n<li><strong>virtual_python (VirtualPython):</strong>  Temp</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.component.combine_component_elements": {"fullname": "phml.core.formats.compile.component.combine_component_elements", "modulename": "phml.core.formats.compile.component", "qualname": "combine_component_elements", "type": "function", "doc": "<p>Combine text from elements like python, script, and style.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Element: With tag of element list but with combined text content</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">elements</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">tag</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.reserved": {"fullname": "phml.core.formats.compile.reserved", "modulename": "phml.core.formats.compile.reserved", "type": "module", "doc": "<p></p>\n"}, "phml.core.formats.format": {"fullname": "phml.core.formats.format", "modulename": "phml.core.formats.format", "type": "module", "doc": "<p></p>\n"}, "phml.core.formats.format.Format": {"fullname": "phml.core.formats.format.Format", "modulename": "phml.core.formats.format", "qualname": "Format", "type": "class", "doc": "<p>Base class for built-in file formats. Each sub class contains a <code>parse</code> and\n<code>compile</code> method. The parse method should take a string or dict and return</p>\n"}, "phml.core.formats.format.Format.__init__": {"fullname": "phml.core.formats.format.Format.__init__", "modulename": "phml.core.formats.format", "qualname": "Format.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.format.Format.extension": {"fullname": "phml.core.formats.format.Format.extension", "modulename": "phml.core.formats.format", "qualname": "Format.extension", "type": "variable", "doc": "<p>The extension or extensions for the file format. When writing to a file and\nextensions is a list then the first extensions in the list is used for the file\nextension.</p>\n", "annotation": ": str | list[str]", "default_value": " = &#x27;txt&#x27;"}, "phml.core.formats.format.Format.suffix": {"fullname": "phml.core.formats.format.Format.suffix", "modulename": "phml.core.formats.format", "qualname": "Format.suffix", "type": "function", "doc": "<p>The prefered extension/suffix for the file format.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.format.Format.is_format": {"fullname": "phml.core.formats.format.Format.is_format", "modulename": "phml.core.formats.format", "qualname": "Format.is_format", "type": "function", "doc": "<p>Determine if an extension is of the current format.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">_extension</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.format.Format.parse": {"fullname": "phml.core.formats.format.Format.parse", "modulename": "phml.core.formats.format", "qualname": "Format.parse", "type": "function", "doc": "<p>Parse the given data into a phml.core.nodes.AST.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"bp\">Ellipsis</span>, </span><span class=\"param\"><span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.format.Format.compile": {"fullname": "phml.core.formats.format.Format.compile", "modulename": "phml.core.formats.format", "qualname": "Format.compile", "type": "function", "doc": "<p>Compile and process the given ast and return the resulting ast.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;enabled&#39;</span><span class=\"p\">],</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;html&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;markdown&#39;</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.format.Format.render": {"fullname": "phml.core.formats.format.Format.render", "modulename": "phml.core.formats.format", "qualname": "Format.render", "type": "function", "doc": "<p>Compile the given phml.core.nodes.AST into string of a given format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;enabled&#39;</span><span class=\"p\">],</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;html&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;markdown&#39;</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.html_format": {"fullname": "phml.core.formats.html_format", "modulename": "phml.core.formats.html_format", "type": "module", "doc": "<p></p>\n"}, "phml.core.formats.html_format.parse_markup": {"fullname": "phml.core.formats.html_format.parse_markup", "modulename": "phml.core.formats.html_format", "qualname": "parse_markup", "type": "function", "doc": "<p>Parse a string as a markup document.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">class_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.html_format.HTMLFormat": {"fullname": "phml.core.formats.html_format.HTMLFormat", "modulename": "phml.core.formats.html_format", "qualname": "HTMLFormat", "type": "class", "doc": "<p>Logic for parsing and compiling html files.</p>\n", "bases": "phml.core.formats.format.Format"}, "phml.core.formats.html_format.HTMLFormat.__init__": {"fullname": "phml.core.formats.html_format.HTMLFormat.__init__", "modulename": "phml.core.formats.html_format", "qualname": "HTMLFormat.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.html_format.HTMLFormat.extension": {"fullname": "phml.core.formats.html_format.HTMLFormat.extension", "modulename": "phml.core.formats.html_format", "qualname": "HTMLFormat.extension", "type": "variable", "doc": "<p>The extension or extensions for the file format. When writing to a file and\nextensions is a list then the first extensions in the list is used for the file\nextension.</p>\n", "annotation": ": list[str]", "default_value": " = [&#x27;html&#x27;, &#x27;htm&#x27;]"}, "phml.core.formats.html_format.HTMLFormat.parse": {"fullname": "phml.core.formats.html_format.HTMLFormat.parse", "modulename": "phml.core.formats.html_format", "qualname": "HTMLFormat.parse", "type": "function", "doc": "<p>Parse the given data into a phml.core.nodes.AST.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.html_format.HTMLFormat.compile": {"fullname": "phml.core.formats.html_format.HTMLFormat.compile", "modulename": "phml.core.formats.html_format", "qualname": "HTMLFormat.compile", "type": "function", "doc": "<p>Compile and process the given ast and return the resulting ast.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;enabled&#39;</span><span class=\"p\">],</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;html&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;markdown&#39;</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.html_format.HTMLFormat.render": {"fullname": "phml.core.formats.html_format.HTMLFormat.render", "modulename": "phml.core.formats.html_format", "qualname": "HTMLFormat.render", "type": "function", "doc": "<p>Compile the given phml.core.nodes.AST into string of a given format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;enabled&#39;</span><span class=\"p\">],</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;html&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;markdown&#39;</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">4</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.json_format": {"fullname": "phml.core.formats.json_format", "modulename": "phml.core.formats.json_format", "type": "module", "doc": "<p></p>\n"}, "phml.core.formats.json_format.construct_tree": {"fullname": "phml.core.formats.json_format.construct_tree", "modulename": "phml.core.formats.json_format", "qualname": "construct_tree", "type": "function", "doc": "<p>Recursivly construct ast from json.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">obj</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.json_format.JSONFormat": {"fullname": "phml.core.formats.json_format.JSONFormat", "modulename": "phml.core.formats.json_format", "qualname": "JSONFormat", "type": "class", "doc": "<p>Logic for parsing and compiling html files.</p>\n", "bases": "phml.core.formats.format.Format"}, "phml.core.formats.json_format.JSONFormat.__init__": {"fullname": "phml.core.formats.json_format.JSONFormat.__init__", "modulename": "phml.core.formats.json_format", "qualname": "JSONFormat.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.json_format.JSONFormat.extension": {"fullname": "phml.core.formats.json_format.JSONFormat.extension", "modulename": "phml.core.formats.json_format", "qualname": "JSONFormat.extension", "type": "variable", "doc": "<p>The extension or extensions for the file format. When writing to a file and\nextensions is a list then the first extensions in the list is used for the file\nextension.</p>\n", "annotation": ": str", "default_value": " = &#x27;json&#x27;"}, "phml.core.formats.json_format.JSONFormat.parse": {"fullname": "phml.core.formats.json_format.JSONFormat.parse", "modulename": "phml.core.formats.json_format", "qualname": "JSONFormat.parse", "type": "function", "doc": "<p>Parse the given data into a phml.core.nodes.AST.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.json_format.JSONFormat.render": {"fullname": "phml.core.formats.json_format.JSONFormat.render", "modulename": "phml.core.formats.json_format", "qualname": "JSONFormat.render", "type": "function", "doc": "<p>Compile the given phml.core.nodes.AST into string of a given format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.parse": {"fullname": "phml.core.formats.parse", "modulename": "phml.core.formats.parse", "type": "module", "doc": "<p>Pythonic Hypertext Markup Language (phml) parser.</p>\n"}, "phml.core.formats.parse.parse_hypertest_markup": {"fullname": "phml.core.formats.parse.parse_hypertest_markup", "modulename": "phml.core.formats.parse", "qualname": "parse_hypertest_markup", "type": "function", "doc": "<p>Parse a string as a hypertest markup document.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">class_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.parse.strip_blank_lines": {"fullname": "phml.core.formats.parse.strip_blank_lines", "modulename": "phml.core.formats.parse", "qualname": "strip_blank_lines", "type": "function", "doc": "<p>Strip the blank lines at the start and end of a list.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_lines</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.parse.strip": {"fullname": "phml.core.formats.parse.strip", "modulename": "phml.core.formats.parse", "qualname": "strip", "type": "function", "doc": "<p>This function takes a possibly mutliline string and strips leading and trailing\nblank lines. Given the current position it will also calculate the line and column\ntaht the data ends at.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">cur_tags</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.parse.RE": {"fullname": "phml.core.formats.parse.RE", "modulename": "phml.core.formats.parse", "qualname": "RE", "type": "class", "doc": "<p></p>\n"}, "phml.core.formats.parse.RE.__init__": {"fullname": "phml.core.formats.parse.RE.__init__", "modulename": "phml.core.formats.parse", "qualname": "RE.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.parse.RE.tag_start": {"fullname": "phml.core.formats.parse.RE.tag_start", "modulename": "phml.core.formats.parse", "qualname": "RE.tag_start", "type": "variable", "doc": "<p>Matches the start of a tag <code>&lt;!name|&lt;/name|&lt;name</code></p>\n", "default_value": " = re.compile(&#x27;(?P&lt;comment&gt;&lt;!--)|&lt;(?!!--)(?P&lt;opening&gt;!|\\\\/)?(?P&lt;name&gt;([\\\\w:\\\\.]+\\\\-?)+)|&lt;(?P&lt;opening2&gt;/)?(?=\\\\s+&gt;|&gt;)&#x27;)"}, "phml.core.formats.parse.RE.tag_end": {"fullname": "phml.core.formats.parse.RE.tag_end", "modulename": "phml.core.formats.parse", "qualname": "RE.tag_end", "type": "variable", "doc": "<p>Matches the end of a tag <code>/&gt;|&gt;</code>.</p>\n", "default_value": " = re.compile(&#x27;(?P&lt;closing&gt;/?)&gt;&#x27;)"}, "phml.core.formats.parse.RE.comment": {"fullname": "phml.core.formats.parse.RE.comment", "modulename": "phml.core.formats.parse", "qualname": "RE.comment", "type": "variable", "doc": "<p>Matches all html style comments <code>&lt;!--Comment--&gt;</code>.</p>\n", "default_value": " = re.compile(&#x27;&lt;!--((?:.|\\\\s)*)--&gt;&#x27;)"}, "phml.core.formats.parse.RE.attribute": {"fullname": "phml.core.formats.parse.RE.attribute", "modulename": "phml.core.formats.parse", "qualname": "RE.attribute", "type": "variable", "doc": "<p>Matches a tags attributes <code>attr|attr=value|attr='value'|attr=\"value\"</code>.</p>\n", "default_value": " = re.compile(&#x27;(?P&lt;name&gt;[\\\\w:\\\\-@]+)(?:=(?P&lt;value&gt;\\\\{(?P&lt;curly&gt;[^\\\\}]*)\\\\/\\\\}|\\\\&quot;(?P&lt;double&gt;[^\\\\&quot;]*)\\\\&quot;|\\&#x27;(?P&lt;single&gt;[^\\&#x27;]*)\\&#x27;|(?P&lt;open&gt;[^&gt;\\&#x27;\\\\&quot;]+)))?&#x27;)"}, "phml.core.formats.parse.HypertextMarkupParser": {"fullname": "phml.core.formats.parse.HypertextMarkupParser", "modulename": "phml.core.formats.parse", "qualname": "HypertextMarkupParser", "type": "class", "doc": "<p>Parse html/xml like source code strings.</p>\n"}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"fullname": "phml.core.formats.parse.HypertextMarkupParser.__init__", "modulename": "phml.core.formats.parse", "qualname": "HypertextMarkupParser.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"fullname": "phml.core.formats.parse.HypertextMarkupParser.tag_stack", "modulename": "phml.core.formats.parse", "qualname": "HypertextMarkupParser.tag_stack", "type": "variable", "doc": "<p>Current stack of tags in order of when they are opened.</p>\n", "default_value": " = []"}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"fullname": "phml.core.formats.parse.HypertextMarkupParser.is_self_closing", "modulename": "phml.core.formats.parse", "qualname": "HypertextMarkupParser.is_self_closing", "type": "function", "doc": "<p>Check if the tag is self closing. Only check if auto_closing is toggled on.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">auto_closing</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"fullname": "phml.core.formats.parse.HypertextMarkupParser.parse", "modulename": "phml.core.formats.parse", "qualname": "HypertextMarkupParser.parse", "type": "function", "doc": "<p>Parse a given html or phml string into it's corresponding phml ast.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>source (str):</strong>  The html or phml source to parse.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>AST: A phml AST representing the parsed code source.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">source</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.phml_format": {"fullname": "phml.core.formats.phml_format", "modulename": "phml.core.formats.phml_format", "type": "module", "doc": "<p></p>\n"}, "phml.core.formats.phml_format.parse_markup": {"fullname": "phml.core.formats.phml_format.parse_markup", "modulename": "phml.core.formats.phml_format", "qualname": "parse_markup", "type": "function", "doc": "<p>Parse a string as a markup document.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">class_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.phml_format.PHMLFormat": {"fullname": "phml.core.formats.phml_format.PHMLFormat", "modulename": "phml.core.formats.phml_format", "qualname": "PHMLFormat", "type": "class", "doc": "<p>Logic for parsing and compiling html files.</p>\n", "bases": "phml.core.formats.format.Format"}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"fullname": "phml.core.formats.phml_format.PHMLFormat.__init__", "modulename": "phml.core.formats.phml_format", "qualname": "PHMLFormat.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.phml_format.PHMLFormat.extension": {"fullname": "phml.core.formats.phml_format.PHMLFormat.extension", "modulename": "phml.core.formats.phml_format", "qualname": "PHMLFormat.extension", "type": "variable", "doc": "<p>The extension or extensions for the file format. When writing to a file and\nextensions is a list then the first extensions in the list is used for the file\nextension.</p>\n", "annotation": ": str", "default_value": " = &#x27;phml&#x27;"}, "phml.core.formats.phml_format.PHMLFormat.parse": {"fullname": "phml.core.formats.phml_format.PHMLFormat.parse", "modulename": "phml.core.formats.phml_format", "qualname": "PHMLFormat.parse", "type": "function", "doc": "<p>Parse the given data into a phml.core.nodes.AST.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.phml_format.PHMLFormat.compile": {"fullname": "phml.core.formats.phml_format.PHMLFormat.compile", "modulename": "phml.core.formats.phml_format", "qualname": "PHMLFormat.compile", "type": "function", "doc": "<p>Compile and process the given ast and return the resulting ast.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.phml_format.PHMLFormat.render": {"fullname": "phml.core.formats.phml_format.PHMLFormat.render", "modulename": "phml.core.formats.phml_format", "qualname": "PHMLFormat.render", "type": "function", "doc": "<p>Compile the given phml.core.nodes.AST into string of a given format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">4</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.xml_format": {"fullname": "phml.core.formats.xml_format", "modulename": "phml.core.formats.xml_format", "type": "module", "doc": "<p></p>\n"}, "phml.core.formats.xml_format.XMLFormat": {"fullname": "phml.core.formats.xml_format.XMLFormat", "modulename": "phml.core.formats.xml_format", "qualname": "XMLFormat", "type": "class", "doc": "<p>Logic for parsing and compiling html files.</p>\n", "bases": "phml.core.formats.format.Format"}, "phml.core.formats.xml_format.XMLFormat.__init__": {"fullname": "phml.core.formats.xml_format.XMLFormat.__init__", "modulename": "phml.core.formats.xml_format", "qualname": "XMLFormat.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.xml_format.XMLFormat.extension": {"fullname": "phml.core.formats.xml_format.XMLFormat.extension", "modulename": "phml.core.formats.xml_format", "qualname": "XMLFormat.extension", "type": "variable", "doc": "<p>The extension or extensions for the file format. When writing to a file and\nextensions is a list then the first extensions in the list is used for the file\nextension.</p>\n", "annotation": ": str", "default_value": " = &#x27;xml&#x27;"}, "phml.core.formats.xml_format.XMLFormat.parse": {"fullname": "phml.core.formats.xml_format.XMLFormat.parse", "modulename": "phml.core.formats.xml_format", "qualname": "XMLFormat.parse", "type": "function", "doc": "<p>Parse the given data into a phml.core.nodes.AST.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.xml_format.XMLFormat.compile": {"fullname": "phml.core.formats.xml_format.XMLFormat.compile", "modulename": "phml.core.formats.xml_format", "qualname": "XMLFormat.compile", "type": "function", "doc": "<p>Compile and process the given ast and return the resulting ast.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.xml_format.XMLFormat.render": {"fullname": "phml.core.formats.xml_format.XMLFormat.render", "modulename": "phml.core.formats.xml_format", "qualname": "XMLFormat.render", "type": "function", "doc": "<p>Compile the given phml.core.nodes.AST into string of a given format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes": {"fullname": "phml.core.nodes", "modulename": "phml.core.nodes", "type": "module", "doc": "<p>phml.nodes</p>\n\n<p>All things related to phml node data objects.</p>\n"}, "phml.core.nodes.AST": {"fullname": "phml.core.nodes.AST", "modulename": "phml.core.nodes.AST", "type": "module", "doc": "<p>Basic node that holds a root node and has basic utilties.</p>\n\n<p>You can check the size of the tree, iterate over the tree, and directly access\nthe children of the root node.</p>\n"}, "phml.core.nodes.AST.AST": {"fullname": "phml.core.nodes.AST.AST", "modulename": "phml.core.nodes.AST", "qualname": "AST", "type": "class", "doc": "<p>PHML ast.</p>\n\n<p>Contains utility functions that can manipulate the ast.</p>\n"}, "phml.core.nodes.AST.AST.__init__": {"fullname": "phml.core.nodes.AST.AST.__init__", "modulename": "phml.core.nodes.AST", "qualname": "AST.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">tree</span></span>)</span>"}, "phml.core.nodes.AST.AST.size": {"fullname": "phml.core.nodes.AST.AST.size", "modulename": "phml.core.nodes.AST", "qualname": "AST.size", "type": "variable", "doc": "<p>Get the number of nodes in the ast tree.</p>\n", "annotation": ": int"}, "phml.core.nodes.AST.AST.children": {"fullname": "phml.core.nodes.AST.AST.children", "modulename": "phml.core.nodes.AST", "qualname": "AST.children", "type": "variable", "doc": "<p>Get access to the ast roots children.\nIs none if there is no root.</p>\n", "annotation": ": list"}, "phml.core.nodes.nodes": {"fullname": "phml.core.nodes.nodes", "modulename": "phml.core.nodes.nodes", "type": "module", "doc": "<p></p>\n"}, "phml.core.nodes.nodes.Element": {"fullname": "phml.core.nodes.nodes.Element", "modulename": "phml.core.nodes.nodes", "qualname": "Element", "type": "class", "doc": "<p>Element (Parent) represents an Element ([DOM]).</p>\n\n<p>A tagName field must be present. It represents the element's local name ([DOM]).</p>\n\n<p>The properties field represents information associated with the element.\nThe value of the properties field implements the Properties interface.</p>\n\n<p>If the tagName field is 'template', a content field can be present. The value\nof the content field implements the Root interface.</p>\n\n<p>If the tagName field is 'template', the element must be a leaf.</p>\n\n<p>If the tagName field is 'noscript', its children should be represented as if\nscripting is disabled ([HTML]).</p>\n\n<p>For example, the following HTML:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">a</span> <span class=\"na\">href</span><span class=\"o\">=</span><span class=\"s\">&quot;https://alpha.com&quot;</span> <span class=\"na\">class</span><span class=\"o\">=</span><span class=\"s\">&quot;bravo&quot;</span> <span class=\"na\">download</span><span class=\"p\">&gt;&lt;/</span><span class=\"nt\">a</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>Yields:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">{</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">type</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;element&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">tagName</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;a&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">properties</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">{</span><span class=\"w\"></span>\n<span class=\"w\">        </span><span class=\"nx\">href</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;https://alpha.com&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">        </span><span class=\"nx\">className</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">[</span><span class=\"s1\">&#39;bravo&#39;</span><span class=\"p\">],</span><span class=\"w\"></span>\n<span class=\"w\">        </span><span class=\"nx\">download</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"kc\">true</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"p\">},</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">children</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">[]</span><span class=\"w\"></span>\n<span class=\"p\">}</span><span class=\"w\"></span>\n</code></pre>\n</div>\n", "bases": "Parent"}, "phml.core.nodes.nodes.Element.__init__": {"fullname": "phml.core.nodes.nodes.Element.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Element.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tag</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;element&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">properties</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">startend</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "phml.core.nodes.nodes.Element.get": {"fullname": "phml.core.nodes.nodes.Element.get", "modulename": "phml.core.nodes.nodes", "qualname": "Element.get", "type": "function", "doc": "<p>Get a specific attribute from an element. If no default return value\nis provided then none is returned if no value is found.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">attr</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">_default</span><span class=\"p\">:</span> <span class=\"n\">Any</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Element.start_tag": {"fullname": "phml.core.nodes.nodes.Element.start_tag", "modulename": "phml.core.nodes.nodes", "qualname": "Element.start_tag", "type": "function", "doc": "<p>Builds the open/start tag for the element.</p>\n\n<h6 id=\"note\">Note</h6>\n\n<blockquote>\n  <p>It will return <code>/&gt;</code> if the tag is self closing.</p>\n</blockquote>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: Built element start tag.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">4</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Element.end_tag": {"fullname": "phml.core.nodes.nodes.Element.end_tag", "modulename": "phml.core.nodes.nodes", "qualname": "Element.end_tag", "type": "function", "doc": "<p>Build the elements end tag.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: Built element end tag.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Root": {"fullname": "phml.core.nodes.nodes.Root", "modulename": "phml.core.nodes.nodes", "qualname": "Root", "type": "class", "doc": "<p>Root (Parent) represents a document.</p>\n\n<p>Root can be used as the root of a tree, or as a value\nof the content field on a 'template' Element, never as a child.</p>\n", "bases": "Parent"}, "phml.core.nodes.nodes.Root.__init__": {"fullname": "phml.core.nodes.nodes.Root.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Root.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.Node": {"fullname": "phml.core.nodes.nodes.Node", "modulename": "phml.core.nodes.nodes", "qualname": "Node", "type": "class", "doc": "<p>All node values can be expressed in JSON as: string, number,\nobject, array, true, false, or null. This means that the syntax tree should\nbe able to be converted to and from JSON and produce the same tree.\nFor example, in JavaScript, a tree can be passed through JSON.parse(JSON.phml(tree))\nand result in the same tree.</p>\n"}, "phml.core.nodes.nodes.Node.__init__": {"fullname": "phml.core.nodes.nodes.Node.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Node.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.Node.position": {"fullname": "phml.core.nodes.nodes.Node.position", "modulename": "phml.core.nodes.nodes", "qualname": "Node.position", "type": "variable", "doc": "<p>The location of a node in a source document.\nThe value of the position field implements the Position interface.\nThe position field must not be present if a node is generated.</p>\n", "annotation": ": phml.core.nodes.nodes.Position"}, "phml.core.nodes.nodes.Node.type": {"fullname": "phml.core.nodes.nodes.Node.type", "modulename": "phml.core.nodes.nodes", "qualname": "Node.type", "type": "variable", "doc": "<p>Non-empty string representing the variant of a node.\nThis field can be used to determine the type a node implements.</p>\n", "annotation": ": str"}, "phml.core.nodes.nodes.DocType": {"fullname": "phml.core.nodes.nodes.DocType", "modulename": "phml.core.nodes.nodes", "qualname": "DocType", "type": "class", "doc": "<p>Doctype (Node) represents a DocumentType ([DOM]).</p>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cp\">&lt;!doctype html&gt;</span>\n</code></pre>\n</div>\n\n<p>Yields:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">{</span><span class=\"nx\">type</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;doctype&#39;</span><span class=\"p\">}</span><span class=\"w\"></span>\n</code></pre>\n</div>\n", "bases": "Node"}, "phml.core.nodes.nodes.DocType.__init__": {"fullname": "phml.core.nodes.nodes.DocType.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "DocType.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">lang</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.DocType.stringify": {"fullname": "phml.core.nodes.nodes.DocType.stringify", "modulename": "phml.core.nodes.nodes", "qualname": "DocType.stringify", "type": "function", "doc": "<p>Build indented html string of html doctype element.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: Built html of doctype element</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Parent": {"fullname": "phml.core.nodes.nodes.Parent", "modulename": "phml.core.nodes.nodes", "qualname": "Parent", "type": "class", "doc": "<p>Parent (UnistParent) represents a node in hast containing other nodes (said to be children).</p>\n\n<p>Its content is limited to only other hast content.</p>\n", "bases": "Node"}, "phml.core.nodes.nodes.Parent.__init__": {"fullname": "phml.core.nodes.nodes.Parent.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Parent.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.Parent.append": {"fullname": "phml.core.nodes.nodes.Parent.append", "modulename": "phml.core.nodes.nodes", "qualname": "Parent.append", "type": "function", "doc": "<p>Add a node to the nested children of the current parent node.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Parent.extend": {"fullname": "phml.core.nodes.nodes.Parent.extend", "modulename": "phml.core.nodes.nodes", "qualname": "Parent.extend", "type": "function", "doc": "<p>Add a node to the nested children of the current parent node.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">nodes</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Parent.insert": {"fullname": "phml.core.nodes.nodes.Parent.insert", "modulename": "phml.core.nodes.nodes", "qualname": "Parent.insert", "type": "function", "doc": "<p>Insert a node into a specific position in the current parent node's children.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">index</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Parent.remove": {"fullname": "phml.core.nodes.nodes.Parent.remove", "modulename": "phml.core.nodes.nodes", "qualname": "Parent.remove", "type": "function", "doc": "<p>Remove a specific node from the current parent node's children.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.PI": {"fullname": "phml.core.nodes.nodes.PI", "modulename": "phml.core.nodes.nodes", "qualname": "PI", "type": "class", "doc": "<p>A processing instruction node. Mainly used for XML.</p>\n", "bases": "Node"}, "phml.core.nodes.nodes.PI.__init__": {"fullname": "phml.core.nodes.nodes.PI.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "PI.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tag</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">properties</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.PI.stringify": {"fullname": "phml.core.nodes.nodes.PI.stringify", "modulename": "phml.core.nodes.nodes", "qualname": "PI.stringify", "type": "function", "doc": "<p>Construct the string representation of the processing instruction node.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Comment": {"fullname": "phml.core.nodes.nodes.Comment", "modulename": "phml.core.nodes.nodes", "qualname": "Comment", "type": "class", "doc": "<p>Comment (Literal) represents a Comment ([DOM]).</p>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cm\">&lt;!--Charlie--&gt;</span>\n</code></pre>\n</div>\n", "bases": "Literal"}, "phml.core.nodes.nodes.Comment.stringify": {"fullname": "phml.core.nodes.nodes.Comment.stringify", "modulename": "phml.core.nodes.nodes", "qualname": "Comment.stringify", "type": "function", "doc": "<p>Build indented html string of html comment.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: Built html of comment</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Literal": {"fullname": "phml.core.nodes.nodes.Literal", "modulename": "phml.core.nodes.nodes", "qualname": "Literal", "type": "class", "doc": "<p>Literal (UnistLiteral) represents a node in hast containing a value.</p>\n", "bases": "Node"}, "phml.core.nodes.nodes.Literal.__init__": {"fullname": "phml.core.nodes.nodes.Literal.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Literal.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.Literal.position": {"fullname": "phml.core.nodes.nodes.Literal.position", "modulename": "phml.core.nodes.nodes", "qualname": "Literal.position", "type": "variable", "doc": "<p>The location of a node in a source document.\nThe value of the position field implements the Position interface.\nThe position field must not be present if a node is generated.</p>\n", "annotation": ": phml.core.nodes.nodes.Position"}, "phml.core.nodes.nodes.Literal.value": {"fullname": "phml.core.nodes.nodes.Literal.value", "modulename": "phml.core.nodes.nodes", "qualname": "Literal.value", "type": "variable", "doc": "<p>The Literal nodes value. All literal values must be strings</p>\n", "annotation": ": str"}, "phml.core.nodes.nodes.Literal.normalized": {"fullname": "phml.core.nodes.nodes.Literal.normalized", "modulename": "phml.core.nodes.nodes", "qualname": "Literal.normalized", "type": "function", "doc": "<p>Get the normalized indented value with leading and trailing blank lines stripped.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Literal.stringify": {"fullname": "phml.core.nodes.nodes.Literal.stringify", "modulename": "phml.core.nodes.nodes", "qualname": "Literal.stringify", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Literal.get_ancestry": {"fullname": "phml.core.nodes.nodes.Literal.get_ancestry", "modulename": "phml.core.nodes.nodes", "qualname": "Literal.get_ancestry", "type": "function", "doc": "<p>Get the ancestry of the literal node.</p>\n\n<p>Used to validate whether there is a <code>pre</code> element in the ancestry.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Point": {"fullname": "phml.core.nodes.nodes.Point", "modulename": "phml.core.nodes.nodes", "qualname": "Point", "type": "class", "doc": "<p>Represents one place in a source file.</p>\n\n<p>The line field (1-indexed integer) represents a line in a source file. The column field\n(1-indexed integer) represents a column in a source file. The offset field (0-indexed integer)\nrepresents a character in a source file.</p>\n"}, "phml.core.nodes.nodes.Point.__init__": {"fullname": "phml.core.nodes.nodes.Point.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Point.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">line</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">offset</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.Position": {"fullname": "phml.core.nodes.nodes.Position", "modulename": "phml.core.nodes.nodes", "qualname": "Position", "type": "class", "doc": "<p>Position represents the location of a node in a source file.</p>\n\n<p>The <code>start</code> field of <code>Position</code> represents the place of the first character\nof the parsed source region. The <code>end</code> field of Position represents the place\nof the first character after the parsed source region, whether it exists or not.\nThe value of the <code>start</code> and <code>end</code> fields implement the <code>Point</code> interface.</p>\n\n<p>The <code>indent</code> field of <code>Position</code> represents the start column at each index\n(plus start line) in the source region, for elements that span multiple lines.</p>\n\n<p>If the syntactic unit represented by a node is not present in the source file at\nthe time of parsing, the node is said to be <code>generated</code> and it must not have positional\ninformation.</p>\n"}, "phml.core.nodes.nodes.Position.__init__": {"fullname": "phml.core.nodes.nodes.Position.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Position.__init__", "type": "function", "doc": "<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (Point):</strong>  Starting point of the position.</li>\n<li><strong>end (Point):</strong>  End point of the position.</li>\n<li><strong>indent (int | None):</strong>  The indent amount for the start of the position.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Point</span>,</span><span class=\"param\">\t<span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Point</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.Position.as_dict": {"fullname": "phml.core.nodes.nodes.Position.as_dict", "modulename": "phml.core.nodes.nodes", "qualname": "Position.as_dict", "type": "function", "doc": "<p>Convert the position object to a dict.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Text": {"fullname": "phml.core.nodes.nodes.Text", "modulename": "phml.core.nodes.nodes", "qualname": "Text", "type": "class", "doc": "<p>Text (Literal) represents a Text ([DOM]).</p>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">span</span><span class=\"p\">&gt;</span>Foxtrot<span class=\"p\">&lt;/</span><span class=\"nt\">span</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>Yields:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">{</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">type</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;element&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">tagName</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;span&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">properties</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">{},</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">children</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">[{</span><span class=\"nx\">type</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;text&#39;</span><span class=\"p\">,</span><span class=\"w\"> </span><span class=\"nx\">value</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;Foxtrot&#39;</span><span class=\"p\">}]</span><span class=\"w\"></span>\n<span class=\"p\">}</span><span class=\"w\"></span>\n</code></pre>\n</div>\n", "bases": "Literal"}, "phml.core.nodes.nodes.Text.num_lines": {"fullname": "phml.core.nodes.nodes.Text.num_lines", "modulename": "phml.core.nodes.nodes", "qualname": "Text.num_lines", "type": "variable", "doc": "<p>Determine the number of lines the text has.</p>\n", "annotation": ": int"}, "phml.core.nodes.types": {"fullname": "phml.core.nodes.types", "modulename": "phml.core.nodes.types", "type": "module", "doc": "<p>Here is a collection of type annotations</p>\n"}, "phml.core.nodes.types.Properties": {"fullname": "phml.core.nodes.types.Properties", "modulename": "phml.core.nodes.types", "qualname": "Properties", "type": "variable", "doc": "<p>Properties represents information associated with an element.</p>\n\n<p>Every field must be a PropertyName and every value a PropertyValue.</p>\n", "default_value": " = dict[str, typing.Any]"}, "phml.core.parser": {"fullname": "phml.core.parser", "modulename": "phml.core.parser", "type": "module", "doc": "<p>phml.core.parser</p>\n\n<p>The core parsing module for phml. Handles parsing html and phmls strings\nalong with json.</p>\n\n<p>Exposes phml.core.parser.Parser which handles all parsing functionality.</p>\n"}, "phml.core.parser.Parser": {"fullname": "phml.core.parser.Parser", "modulename": "phml.core.parser", "qualname": "Parser", "type": "class", "doc": "<p>Primary logic to handle everything with a phml file.</p>\n\n<p>This class can parse files as phml files and create an ast.\nThe ast and the nodes themselfs can translate themselves to;\nhtml, phml, and json. The ast can recursively return itself as\nan html string. However, only this class can process the python\nblocks inside of the phml file.</p>\n\n<p>Call Parser.convert() and pass any kwargs you wish to be exposed to\nthe process that processes the python. You may also use Parser.util to\npass extensions to convert and manipulate the html along with the python\nprocessing.</p>\n"}, "phml.core.parser.Parser.__init__": {"fullname": "phml.core.parser.Parser.__init__", "modulename": "phml.core.parser", "qualname": "Parser.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.parser.Parser.ast": {"fullname": "phml.core.parser.Parser.ast", "modulename": "phml.core.parser", "qualname": "Parser.ast", "type": "variable", "doc": "<p>The recursive node tree of the phml ast.</p>\n", "annotation": ": phml.core.nodes.AST.AST"}, "phml.core.parser.Parser.load": {"fullname": "phml.core.parser.Parser.load", "modulename": "phml.core.parser", "qualname": "Parser.load", "type": "function", "doc": "<p>Parse a given phml file to AST following hast and unist.</p>\n\n<p>When finished the PHML.ast variable will be populated with the\nresulting ast.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>path (str | Path):</strong>  The path to the file that should be parsed.</li>\n<li><strong>from_format (Format):</strong>  phml.core.formats.Format class that will parse the given source.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">from_format</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">formats</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"o\">.</span><span class=\"n\">Format</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.parser.Parser.parse": {"fullname": "phml.core.parser.Parser.parse", "modulename": "phml.core.parser", "qualname": "Parser.parse", "type": "function", "doc": "<p>Parse data from a phml/html string or from a dict to a phml ast.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>data (str | dict):</strong>  Data to parse in to a ast</li>\n<li><strong>data_type (str):</strong>  Can be <code>HTML</code>, <code>PHML</code>, <code>MARKDOWN</code>, or <code>JSON</code> which</li>\n<li>tells parser how to parse the data. Otherwise it will assume</li>\n<li>str data to be html/phml and dict as <code>json</code>.</li>\n<li><strong>from_format (Format):</strong>  phml.core.formats.Format class that will parse the given source.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\tfrom_format: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.phml_format.PHMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.virtual_python": {"fullname": "phml.core.virtual_python", "modulename": "phml.core.virtual_python", "type": "module", "doc": "<p>Virtual Python</p>\n\n<p>This module serves to solve the problem of processing python\nin scopes and to evaluate python expressions.</p>\n\n<p>These expressions and scopes are python \"blocks\" that are injected\ninto html which then creates my language phml.</p>\n\n<p>Here are examples of the python blocks:</p>\n\n<ol>\n<li>Python element. This is treated as python files similarly to how\n<code>&lt;script&gt;</code> elements are treated as javascript files.</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n    from datetime import datetime\n\n    current_time = datetime.now().strftime(&#39;%H:%M:%S&#39;)\n<span class=\"p\">&lt;/</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<ol>\n<li>Inline python block. Mainly used for retreiving values\nor creating conditions. The local variables in the blocks are given\nfrom the python elements and from kwargs passed to the parser</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>{current_time}<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<ol>\n<li>Multiline python blocks. Same as inline python blocks just that they\ntake up multiple lines. You can write more logic in these blocks, but\nthere local variables are not retained. By default phml will return the last\nlocal variable similar to how Jupyter or the python in cli works.</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    Hello, everyone my name is {firstname}. I\n    am a {work_position}.\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>Here is a list of people and what they like<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    {\n        result = []\n        for i, person, like in enumerate(zip(people, likes)):\n            result.append(f&quot;{i}. {person} likes {like}&quot;)\n        result = &quot;\\n&quot;.join(result)\n    }\n<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n"}, "phml.core.virtual_python.VirtualPython": {"fullname": "phml.core.virtual_python.VirtualPython", "modulename": "phml.core.virtual_python", "qualname": "VirtualPython", "type": "class", "doc": "<p>Represents a python string. Extracts the imports along\nwith the locals.</p>\n"}, "phml.core.virtual_python.VirtualPython.__init__": {"fullname": "phml.core.virtual_python.VirtualPython.__init__", "modulename": "phml.core.virtual_python", "qualname": "VirtualPython.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">content</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">imports</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">context</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">file_name</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.virtual_python.VirtualPython.get_python_context": {"fullname": "phml.core.virtual_python.VirtualPython.get_python_context", "modulename": "phml.core.virtual_python", "qualname": "VirtualPython.get_python_context", "type": "function", "doc": "<p>Get the locals built from the python source code string.\nSplits the def's and classes into their own chunks and passes in\nall other local context to allow for outer scope to be seen in inner scope.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">source</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">context</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.core.virtual_python.get_python_result": {"fullname": "phml.core.virtual_python.get_python_result", "modulename": "phml.core.virtual_python", "qualname": "get_python_result", "type": "function", "doc": "<p>Execute the given python expression, while using\nthe kwargs as the global variables.</p>\n\n<p>This will collect the result of the expression and return it.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expr</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "phml.core.virtual_python.process_python_blocks": {"fullname": "phml.core.virtual_python.process_python_blocks", "modulename": "phml.core.virtual_python", "qualname": "process_python_blocks", "type": "function", "doc": "<p>Process a lines python blocks. Use the VirtualPython locals,\nand kwargs as local variables for each python block. Import\nVirtualPython imports in this methods scope.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>value (str):</strong>  The line to process.</li>\n<li><strong>virtual_python (VirtualPython):</strong>  Parsed locals and imports from all python blocks.</li>\n<li><strong>**kwargs (Any):</strong>  The extra data to pass to the exec function.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: The processed line as str.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">python_value</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.virtual_python.Import": {"fullname": "phml.core.virtual_python.Import", "modulename": "phml.core.virtual_python", "qualname": "Import", "type": "class", "doc": "<p>Helper object that stringifies the python ast Import.\nThis is mainly to locally import things dynamically.</p>\n", "bases": "phml.core.virtual_python.import_objects.PythonImport"}, "phml.core.virtual_python.Import.__init__": {"fullname": "phml.core.virtual_python.Import.__init__", "modulename": "phml.core.virtual_python", "qualname": "Import.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">modules</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span>)</span>"}, "phml.core.virtual_python.Import.from_node": {"fullname": "phml.core.virtual_python.Import.from_node", "modulename": "phml.core.virtual_python", "qualname": "Import.from_node", "type": "function", "doc": "<p>Generates a new import object from a python ast Import.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>imp (ast.Import):</strong>  Python ast object</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Import: A new import object.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">imp</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">import_objects</span><span class=\"o\">.</span><span class=\"n\">Import</span>:</span></span>", "funcdef": "def"}, "phml.core.virtual_python.ImportFrom": {"fullname": "phml.core.virtual_python.ImportFrom", "modulename": "phml.core.virtual_python", "qualname": "ImportFrom", "type": "class", "doc": "<p>Helper object that stringifies the python ast ImportFrom.\nThis is mainly to locally import things dynamically.</p>\n", "bases": "phml.core.virtual_python.import_objects.PythonImport"}, "phml.core.virtual_python.ImportFrom.__init__": {"fullname": "phml.core.virtual_python.ImportFrom.__init__", "modulename": "phml.core.virtual_python", "qualname": "ImportFrom.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">module</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span>)</span>"}, "phml.core.virtual_python.ImportFrom.from_node": {"fullname": "phml.core.virtual_python.ImportFrom.from_node", "modulename": "phml.core.virtual_python", "qualname": "ImportFrom.from_node", "type": "function", "doc": "<p>Generates a new import object from a python ast Import.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>imp (ast.Import):</strong>  Python ast object</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Import: A new import object.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">imp</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">import_objects</span><span class=\"o\">.</span><span class=\"n\">Import</span>:</span></span>", "funcdef": "def"}, "phml.types": {"fullname": "phml.types", "modulename": "phml.types", "type": "module", "doc": "<p></p>\n"}, "phml.utilities": {"fullname": "phml.utilities", "modulename": "phml.utilities", "type": "module", "doc": "<p>phml.utilities</p>\n\n<p>This is a collection of utility functions that allow for manipulation, traversal,\nand discovery inside a phml.ast.AST.</p>\n"}, "phml.utilities.locate": {"fullname": "phml.utilities.locate", "modulename": "phml.utilities.locate", "type": "module", "doc": "<p>utilities.find</p>\n\n<p>Collection of utilities centered around finding nodes in an ast.</p>\n"}, "phml.utilities.locate.find": {"fullname": "phml.utilities.locate.find", "modulename": "phml.utilities.locate.find", "type": "module", "doc": "<p>phml.utilities.locate.find</p>\n\n<p>Collection of utility methods to find one or many of a specific node.</p>\n"}, "phml.utilities.locate.find.ancestor": {"fullname": "phml.utilities.locate.find.ancestor", "modulename": "phml.utilities.locate.find", "qualname": "ancestor", "type": "function", "doc": "<p>Get the common ancestor between two nodes.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>*nodes (NODE):</strong>  A list of any number of nodes</li>\n<li>to find the common ancestor form. Worst case it will</li>\n<li>return the root.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Optional[NODE]: The node that is the common\n  ancestor or None if not found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">nodes</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find": {"fullname": "phml.utilities.locate.find.find", "modulename": "phml.utilities.locate.find", "qualname": "find", "type": "function", "doc": "<p>Walk the nodes children and return the desired node.</p>\n\n<p>Returns the first node that matches the condition.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (Root | Element):</strong>  Starting node.</li>\n<li><strong>condition (Test):</strong>  Condition to check against each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Optional[NODE]: Returns the found node or None if not found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find_all": {"fullname": "phml.utilities.locate.find.find_all", "modulename": "phml.utilities.locate.find", "qualname": "find_all", "type": "function", "doc": "<p>Find all nodes that match the condition.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (Root | Element):</strong>  Starting node.</li>\n<li><strong>condition (Test):</strong>  Condition to apply to each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list[NODE]: List of found nodes. Empty if no nodes are found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find_after": {"fullname": "phml.utilities.locate.find.find_after", "modulename": "phml.utilities.locate.find", "qualname": "find_after", "type": "function", "doc": "<p>Get the first sibling node following the provided node that matches\nthe condition.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (NODE):</strong>  Node to get sibling from.</li>\n<li><strong>condition (Test):</strong>  Condition to check against each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Optional[NODE]: Returns the first sibling or None if there\n  are no siblings.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find_all_after": {"fullname": "phml.utilities.locate.find.find_all_after", "modulename": "phml.utilities.locate.find", "qualname": "find_all_after", "type": "function", "doc": "<p>Get all sibling nodes that match the condition.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (NODE):</strong>  Node to get siblings from.</li>\n<li><strong>condition (Test):</strong>  Condition to check against each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list[NODE]: Returns the all siblings that match the\n  condition or an empty list if none were found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find_all_before": {"fullname": "phml.utilities.locate.find.find_all_before", "modulename": "phml.utilities.locate.find", "qualname": "find_all_before", "type": "function", "doc": "<p>Find all nodes that come before the given node.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (NODE):</strong>  The node to find all previous siblings from.</li>\n<li><strong>condition (Optional[Test]):</strong>  The condition to apply to each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list[NODE]: A list of nodes that come before the given node.\n  Empty list if no nodes were found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find_before": {"fullname": "phml.utilities.locate.find.find_before", "modulename": "phml.utilities.locate.find", "qualname": "find_before", "type": "function", "doc": "<p>Find the first sibling node before the given node. If a condition is applied\nthen it will be the first sibling node that passes that condition.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (NODE):</strong>  The node to find the previous sibling from.</li>\n<li><strong>condition (Optional[Test]):</strong>  The test that is applied to each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Optional[NODE]: The first node before the given node\n  or None if no prior siblings.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find_all_between": {"fullname": "phml.utilities.locate.find.find_all_between", "modulename": "phml.utilities.locate.find", "qualname": "find_all_between", "type": "function", "doc": "<p>Find all sibling nodes in parent that meet the provided condition from start index\nto end index.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>parent (Root | Element):</strong>  The parent element to get nodes from.</li>\n<li><strong>start (int, optional):</strong>  The starting index, inclusive. Defaults to 0.</li>\n<li><strong>end (int, optional):</strong>  The ending index, exclusive. Defaults to 0.</li>\n<li><strong>condition (Test, optional):</strong>  Condition to apply to each node. Defaults to None.</li>\n<li><strong>_range (slice, optional):</strong>  Slice to apply to the parent nodes children instead of start and</li>\n<li>end indecies. Defaults to None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list[NODE]: List of all matching nodes or an empty list if none were found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">_range</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">slice</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.index": {"fullname": "phml.utilities.locate.index", "modulename": "phml.utilities.locate.index", "type": "module", "doc": "<p></p>\n"}, "phml.utilities.locate.index.Index": {"fullname": "phml.utilities.locate.index.Index", "modulename": "phml.utilities.locate.index", "qualname": "Index", "type": "class", "doc": "<p>Uses the given key or key generator and creates a mutable dict of key value pairs\nthat can be easily indexed.</p>\n\n<p>Nodes that don't match the condition or don't have a valid key are not indexed.</p>\n"}, "phml.utilities.locate.index.Index.__init__": {"fullname": "phml.utilities.locate.index.Index.__init__", "modulename": "phml.utilities.locate.index", "qualname": "Index.__init__", "type": "function", "doc": "<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong><code>key</code> (str | Callable):</strong>  Str represents the property to use as an index. Callable</li>\n<li>represents a function to call on each element to generate a key. The returned key</li>\n<li>must be able to be converted to a string. If none then element is skipped.</li>\n<li><strong><code>start</code> (AST | Root | Element):</strong>  The root or node to start at while indexing</li>\n<li><strong><code>test</code> (Test):</strong>  The test to apply to each node. Only valid/passing nodes</li>\n<li>will be indexed</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.utilities.locate.index.Index.indexed_tree": {"fullname": "phml.utilities.locate.index.Index.indexed_tree", "modulename": "phml.utilities.locate.index", "qualname": "Index.indexed_tree", "type": "variable", "doc": "<p>The indexed collection of elements</p>\n", "annotation": ": dict[str, list[phml.core.nodes.nodes.Element]]"}, "phml.utilities.locate.index.Index.items": {"fullname": "phml.utilities.locate.index.Index.items", "modulename": "phml.utilities.locate.index", "qualname": "Index.items", "type": "function", "doc": "<p>Get the key value pairs of all indexes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.index.Index.values": {"fullname": "phml.utilities.locate.index.Index.values", "modulename": "phml.utilities.locate.index", "qualname": "Index.values", "type": "function", "doc": "<p>Get all the values in the collection.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.index.Index.keys": {"fullname": "phml.utilities.locate.index.Index.keys", "modulename": "phml.utilities.locate.index", "qualname": "Index.keys", "type": "function", "doc": "<p>Get all the keys in the collection.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.index.Index.add": {"fullname": "phml.utilities.locate.index.Index.add", "modulename": "phml.utilities.locate.index", "qualname": "Index.add", "type": "function", "doc": "<p>Adds element to indexed collection if not already there.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.locate.index.Index.remove": {"fullname": "phml.utilities.locate.index.Index.remove", "modulename": "phml.utilities.locate.index", "qualname": "Index.remove", "type": "function", "doc": "<p>Removes element from indexed collection if there.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.locate.index.Index.get": {"fullname": "phml.utilities.locate.index.Index.get", "modulename": "phml.utilities.locate.index", "qualname": "Index.get", "type": "function", "doc": "<p>Get a specific index from the indexed tree.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_key</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.index.Index.key_by_tag": {"fullname": "phml.utilities.locate.index.Index.key_by_tag", "modulename": "phml.utilities.locate.index", "qualname": "Index.key_by_tag", "type": "function", "doc": "<p>Builds the key from an elements tag. If the node is not an element\nthen the node's type is returned.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.select": {"fullname": "phml.utilities.locate.select", "modulename": "phml.utilities.locate.select", "type": "module", "doc": "<p>utilities.select</p>\n\n<p>A collection of utilities around querying for specific\ntypes of data.</p>\n"}, "phml.utilities.locate.select.query": {"fullname": "phml.utilities.locate.select.query", "modulename": "phml.utilities.locate.select", "qualname": "query", "type": "function", "doc": "<p>Same as javascripts querySelector. <code>#</code> indicates an id and <code>.</code>\nindicates a class. If they are used alone they match anything.\nAny tag can be used by itself or with <code>#</code> and/or <code>.</code>. You may use\nany number of class specifiers, but may only use one id specifier per\ntag name. Complex specifiers are accepted are allowed meaning you can\nhave space seperated specifiers indicating nesting or a parent child\nrelationship.</p>\n\n<p>Examles:</p>\n\n<ul>\n<li><code>.some-example</code> matches the first element with the class <code>some-example</code></li>\n<li><code>#some-example</code> matches the first element with the id <code>some-example</code></li>\n<li><code>li</code> matches the first <code>li</code> element</li>\n<li><code>li.red</code> matches the first <code>li</code> with the class <code>red</code></li>\n<li><code>li#red</code> matches the first <code>li</code> with the id <code>red</code></li>\n<li><code>input[type=\"checkbox\"]</code> matches the first <code>input</code> with the attribute <code>type=\"checkbox\"</code></li>\n<li><code>div.form-control input[type=\"checkbox\"]</code> matches the first <code>input</code> with the\nattribute <code>type=\"checked\"</code> that has a parent <code>div</code> with the class <code>form-control</code>.</li>\n</ul>\n\n<h6 id=\"return\">Return</h6>\n\n<blockquote>\n  <p>Element | None: The first element matching the specifier or None if no element was\n  found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">specifier</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.select.query_all": {"fullname": "phml.utilities.locate.select.query_all", "modulename": "phml.utilities.locate.select", "qualname": "query_all", "type": "function", "doc": "<p>Same as javascripts querySelectorAll. <code>#</code> indicates an id and <code>.</code>\nindicates a class. If they are used alone they match anything.\nAny tag can be used by itself or with <code>#</code> and/or <code>.</code>. You may use\nany number of class specifiers, but may only use one id specifier per\ntag name. Complex specifiers are accepted are allowed meaning you can\nhave space seperated specifiers indicating nesting or a parent child\nrelationship.</p>\n\n<p>Examles:</p>\n\n<ul>\n<li><code>.some-example</code> matches the first element with the class <code>some-example</code></li>\n<li><code>#some-example</code> matches the first element with the id <code>some-example</code></li>\n<li><code>li</code> matches the first <code>li</code> element</li>\n<li><code>li.red</code> matches the first <code>li</code> with the class <code>red</code></li>\n<li><code>li#red</code> matches the first <code>li</code> with the id <code>red</code></li>\n<li><code>input[type=\"checkbox\"]</code> matches the first <code>input</code> with the attribute <code>type=\"checkbox\"</code></li>\n<li><code>div.form-control input[type=\"checkbox\"]</code> matches the first <code>input</code> with the\nattribute <code>type=\"checked\"</code> that has a parent <code>div</code> with the class <code>form-control</code>.</li>\n</ul>\n\n<h6 id=\"return\">Return</h6>\n\n<blockquote>\n  <p>list[Element] | None: The all elements matching the specifier or and empty list if no\n  elements were found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">specifier</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.select.matches": {"fullname": "phml.utilities.locate.select.matches", "modulename": "phml.utilities.locate.select", "qualname": "matches", "type": "function", "doc": "<p>Works the same as the Javascript matches. <code>#</code> indicates an id and <code>.</code>\nindicates a class. If they are used alone they match anything.\nAny tag can be used by itself or with <code>#</code> and/or <code>.</code>. You may use\nany number of class specifiers, but may only use one id specifier per\ntag name. Complex specifiers are not supported. Everything in the specifier\nmust relate to one element/tag.</p>\n\n<p>Examles:</p>\n\n<ul>\n<li><code>.some-example</code> matches the first element with the class <code>some-example</code></li>\n<li><code>#some-example</code> matches the first element with the id <code>some-example</code></li>\n<li><code>li</code> matches the first <code>li</code> element</li>\n<li><code>li.red</code> matches the first <code>li</code> with the class <code>red</code></li>\n<li><code>li#red</code> matches the first <code>li</code> with the id <code>red</code></li>\n<li><code>input[type=\"checkbox\"]</code> matches the first <code>input</code> with the attribute <code>type=\"checkbox\"</code></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>, </span><span class=\"param\"><span class=\"n\">specifier</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.select.parse_specifiers": {"fullname": "phml.utilities.locate.select.parse_specifiers", "modulename": "phml.utilities.locate.select", "qualname": "parse_specifiers", "type": "function", "doc": "<p>Rules:</p>\n\n<ul>\n<li><code>*</code> = any element</li>\n<li><code>&gt;</code> = Everything with certain parent child relationship</li>\n<li><code>+</code> = first sibling</li>\n<li><code>~</code> = All after</li>\n<li><code>.</code> = class</li>\n<li><code>#</code> = id</li>\n<li><code>[attribute]</code> = all elements with attribute</li>\n<li><code>[attribute=value]</code> = all elements with attribute=value</li>\n<li><code>[attribute~=value]</code> = all elements with attribute containing value</li>\n<li><code>[attribute|=value]</code> = all elements with attribute=value or attribute starting with value-</li>\n<li><code>node[attribute^=value]</code> = all elements with attribute starting with value</li>\n<li><code>node[attribute$=value]</code> = all elements with attribute ending with value</li>\n<li><code>node[attribute*=value]</code> = all elements with attribute containing value</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">specifier</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc": {"fullname": "phml.utilities.misc", "modulename": "phml.utilities.misc", "type": "module", "doc": "<p>phml.utilities.misc</p>\n\n<p>Helpful utilities for different tasks that doesn't have a place in the other categories.</p>\n"}, "phml.utilities.misc.depth": {"fullname": "phml.utilities.misc.depth", "modulename": "phml.utilities.misc", "qualname": "depth", "type": "function", "doc": "<p>Get the depth in the tree for a given node.</p>\n\n<p>-1 means that you passed in the tree itself and you are at the\nast's root.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.size": {"fullname": "phml.utilities.misc.size", "modulename": "phml.utilities.misc", "qualname": "size", "type": "function", "doc": "<p>Get the number of nodes recursively.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.offset": {"fullname": "phml.utilities.misc.offset", "modulename": "phml.utilities.misc", "qualname": "offset", "type": "function", "doc": "<p>Get the leading offset of the first line of the string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">content</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes": {"fullname": "phml.utilities.misc.classes", "modulename": "phml.utilities.misc.classes", "type": "module", "doc": "<p>utilities.misc</p>\n\n<p>A collection of utilities that don't fit in with finding, selecting, testing,\ntransforming, traveling, or validating nodes.</p>\n"}, "phml.utilities.misc.classes.classnames": {"fullname": "phml.utilities.misc.classes.classnames", "modulename": "phml.utilities.misc.classes", "qualname": "classnames", "type": "function", "doc": "<p>Concat a bunch of class names. Can take a str as a class,\nint which is cast to a str to be a class, a dict of conditional classes,\nand a list of all the previous conditions including itself.</p>\n\n<h6 id=\"examples\">Examples</h6>\n\n<blockquote>\n  <p>Assume that the current class on node is <code>bold</code></p>\n</blockquote>\n\n<ul>\n<li><code>classnames(node, 'flex')</code> yields <code>'bold flex'</code></li>\n<li><code>classnames(node, 13)</code> yields <code>'bold 13'</code></li>\n<li><code>classnames(node, {'shadow': True, 'border': 0})</code> yields <code>'bold shadow'</code></li>\n<li><code>classnames('a', 13, {'b': True}, ['c', {'d': False}])</code> yields <code>'a b c'</code></li>\n</ul>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (Element | None):</strong>  Node to apply the classes too. If no node is given</li>\n<li>then the function returns a string.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: The concat string of classes after processing.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">conditionals</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes.ClassList": {"fullname": "phml.utilities.misc.classes.ClassList", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList", "type": "class", "doc": "<p>Utility class to manipulate the class list on a node.</p>\n\n<p>Based on the hast-util-class-list:\n<a href=\"https://github.com/brechtcs/hast-util-class-list\">https://github.com/brechtcs/hast-util-class-list</a></p>\n"}, "phml.utilities.misc.classes.ClassList.__init__": {"fullname": "phml.utilities.misc.classes.ClassList.__init__", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span>)</span>"}, "phml.utilities.misc.classes.ClassList.contains": {"fullname": "phml.utilities.misc.classes.ClassList.contains", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.contains", "type": "function", "doc": "<p>Check if <code>class</code> contains a certain class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">klass</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes.ClassList.toggle": {"fullname": "phml.utilities.misc.classes.ClassList.toggle", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.toggle", "type": "function", "doc": "<p>Toggle a class in <code>class</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">klasses</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes.ClassList.add": {"fullname": "phml.utilities.misc.classes.ClassList.add", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.add", "type": "function", "doc": "<p>Add one or more classes to <code>class</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">klasses</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes.ClassList.replace": {"fullname": "phml.utilities.misc.classes.ClassList.replace", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.replace", "type": "function", "doc": "<p>Replace a certain class in <code>class</code> with\nanother class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">old_class</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">new_class</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes.ClassList.remove": {"fullname": "phml.utilities.misc.classes.ClassList.remove", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.remove", "type": "function", "doc": "<p>Remove one or more classes from <code>class</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">klasses</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes.ClassList.class_list": {"fullname": "phml.utilities.misc.classes.ClassList.class_list", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.class_list", "type": "function", "doc": "<p>Return the formatted string of classes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.component": {"fullname": "phml.utilities.misc.component", "modulename": "phml.utilities.misc.component", "type": "module", "doc": "<p></p>\n"}, "phml.utilities.misc.component.tokanize_name": {"fullname": "phml.utilities.misc.component.tokanize_name", "modulename": "phml.utilities.misc.component", "qualname": "tokanize_name", "type": "function", "doc": "<p>Generates name tokens <code>some name tokanized</code> from a filename.\nAssumes filenames is one of:</p>\n\n<ul>\n<li>snakecase - some_file_name</li>\n<li>camel case - someFileName</li>\n<li>pascal case - SomeFileName</li>\n</ul>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>name (str):</strong>  File name without extension</li>\n<li><strong>normalize (bool):</strong>  Make all tokens fully lowercase. Defaults to True</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list[str]: List of word tokens.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">normalize</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.component.tag_from_file": {"fullname": "phml.utilities.misc.component.tag_from_file", "modulename": "phml.utilities.misc.component", "qualname": "tag_from_file", "type": "function", "doc": "<p>Generates a tag name some-tag-name from a filename.\nAssumes filenames of:</p>\n\n<ul>\n<li>snakecase - some_file_name</li>\n<li>camel case - someFileName</li>\n<li>pascal case - SomeFileName</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.component.filename_from_path": {"fullname": "phml.utilities.misc.component.filename_from_path", "modulename": "phml.utilities.misc.component", "qualname": "filename_from_path", "type": "function", "doc": "<p>Get the filename without the suffix from a pathlib.Path.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.component.parse_component": {"fullname": "phml.utilities.misc.component.parse_component", "modulename": "phml.utilities.misc.component", "qualname": "parse_component", "type": "function", "doc": "<p>Helper function to parse the components elements.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.component.valid_component_dict": {"fullname": "phml.utilities.misc.component.valid_component_dict", "modulename": "phml.utilities.misc.component", "qualname": "valid_component_dict", "type": "function", "doc": "<p>Check if a component dict is valid.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cmpt</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.component.cmpt_name_from_path": {"fullname": "phml.utilities.misc.component.cmpt_name_from_path", "modulename": "phml.utilities.misc.component", "qualname": "cmpt_name_from_path", "type": "function", "doc": "<p>Construct a component name given a path. This will include parent directories.\nit will also strip the root directory as this is most commonly not wanted.</p>\n\n<h6 id=\"examples\">Examples</h6>\n\n<blockquote>\n  <p><code>components/blog/header.phml</code></p>\n  \n  <p>yields</p>\n  \n  <p><code>blog-header</code></p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">strip</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.heading": {"fullname": "phml.utilities.misc.heading", "modulename": "phml.utilities.misc.heading", "type": "module", "doc": "<p>Utility functions that do something with heading tags.</p>\n"}, "phml.utilities.misc.heading.heading_rank": {"fullname": "phml.utilities.misc.heading.heading_rank", "modulename": "phml.utilities.misc.heading", "qualname": "heading_rank", "type": "function", "doc": "<p>Get the rank of the heading element.</p>\n\n<h6 id=\"example\">Example</h6>\n\n<blockquote>\n  <p><code>h2</code> yields <code>2</code></p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.inspect": {"fullname": "phml.utilities.misc.inspect", "modulename": "phml.utilities.misc.inspect", "type": "module", "doc": "<p>phml.utilities.misc.inspect</p>\n\n<p>Logic to inspect any phml node. Outputs a tree representation\nof the node as a string.</p>\n"}, "phml.utilities.misc.inspect.inspect": {"fullname": "phml.utilities.misc.inspect.inspect", "modulename": "phml.utilities.misc.inspect", "qualname": "inspect", "type": "function", "doc": "<p>Recursively inspect the passed node or ast.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.misc.inspect.normalize_indent": {"fullname": "phml.utilities.misc.inspect.normalize_indent", "modulename": "phml.utilities.misc.inspect", "qualname": "normalize_indent", "type": "function", "doc": "<p>Remove extra prefix whitespace while preserving relative indenting.</p>\n\n<p>Example:\n    <div class=\"pdoc-code codehilite\">\n    <pre><span></span><code><span class=\"k\">if</span> <span class=\"kc\">True</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Hello World&quot;</span><span class=\"p\">)</span>\n    </code></pre>\n    </div></p>\n\n<p>becomes</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">if</span> <span class=\"kc\">True</span><span class=\"p\">:</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Hello World&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.transform": {"fullname": "phml.utilities.transform", "modulename": "phml.utilities.transform", "type": "module", "doc": "<p>utilities.transform</p>\n\n<p>A collection of utilities focused around transforming an\nast or a specific nodes.</p>\n"}, "phml.utilities.transform.normalize_indent": {"fullname": "phml.utilities.transform.normalize_indent", "modulename": "phml.utilities.transform", "qualname": "normalize_indent", "type": "function", "doc": "<p>Normalize the indent between all lines.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>content (str):</strong>  The content to normalize the indent for</li>\n<li><strong>indent (bool):</strong>  The amount of offset to add to each line after normalization.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: The normalized string</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">content</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.transform.extract": {"fullname": "phml.utilities.transform.extract", "modulename": "phml.utilities.transform.extract", "type": "module", "doc": "<p></p>\n"}, "phml.utilities.transform.extract.to_string": {"fullname": "phml.utilities.transform.extract.to_string", "modulename": "phml.utilities.transform.extract", "qualname": "to_string", "type": "function", "doc": "<p>Get the raw text content of the element. Works similar to\nthe DOMs Node#textContent getter.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (Root | Element | Text):</strong>  Node to get the text content from</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: Raw inner text without formatting.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.transform.sanitize": {"fullname": "phml.utilities.transform.sanitize", "modulename": "phml.utilities.transform.sanitize", "type": "module", "doc": "<p>phml.utilities.transform.sanatize</p>\n\n<p>Logic for sanatizing a phml ast.</p>\n"}, "phml.utilities.transform.sanitize.sanatize": {"fullname": "phml.utilities.transform.sanitize.sanatize", "modulename": "phml.utilities.transform.sanitize", "qualname": "sanatize", "type": "function", "doc": "<p>Sanatize elements and attributes in the phml tree. Should be used when using\ndata from an unkown source. It should be used with an AST that has already been\ncompiled to html to no unkown values are unchecked.</p>\n\n<p>By default the sanatization schema uses the github schema and follows the hast\nsanatize utility.</p>\n\n<ul>\n<li><a href=\"https://github.com/syntax-tree/hast-util-sanitize/blob/main/lib/schema.js\">github schema</a></li>\n<li><a href=\"https://github.com/syntax-tree/hast-util-sanitize\">hast sanatize</a></li>\n</ul>\n\n<h6 id=\"note\">Note</h6>\n\n<blockquote>\n  <p>This utility will edit the tree in place.</p>\n</blockquote>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>tree (AST | Root | Element):</strong>  The root of the tree that will be sanatized.</li>\n<li><strong>schema (Optional[Schema], optional):</strong>  User defined schema. Defaults to github schema.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">schema</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">utilities</span><span class=\"o\">.</span><span class=\"n\">transform</span><span class=\"o\">.</span><span class=\"n\">sanitize</span><span class=\"o\">.</span><span class=\"n\">schema</span><span class=\"o\">.</span><span class=\"n\">Schema</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"n\">Schema</span><span class=\"p\">(</span><span class=\"n\">strip</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"s1\">&#39;script&#39;</span><span class=\"p\">],</span> <span class=\"n\">ancestors</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;tbody&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;tfoot&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;thead&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;td&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;th&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;tr&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">]},</span> <span class=\"n\">protocols</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;href&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;http&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;mailto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;xmpp&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;irc&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ircs&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;http&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;src&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;http&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;longDesc&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;http&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https&#39;</span><span class=\"p\">]},</span> <span class=\"n\">tag_names</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"s1\">&#39;h1&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h2&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h3&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h4&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h5&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h6&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;br&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;b&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;i&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;strong&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;em&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;a&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;pre&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;code&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;img&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;div&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ins&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;del&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;sup&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;sub&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;p&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ol&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ul&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;table&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;thead&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tbody&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tfoot&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;blockquote&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dl&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dd&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;kbd&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;q&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;samp&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;var&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;hr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ruby&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rp&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;li&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;td&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;th&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;s&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;strike&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;summary&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;details&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;caption&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;figure&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;figcaption&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;abbr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;bdo&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dfn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;mark&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;small&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;span&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;time&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;wbr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;input&#39;</span><span class=\"p\">],</span> <span class=\"n\">attributes</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;a&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;href&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;img&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;src&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;longDesc&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;input&#39;</span><span class=\"p\">:</span> <span class=\"p\">[[</span><span class=\"s1\">&#39;type&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;checkbox&#39;</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"s1\">&#39;disabled&#39;</span><span class=\"p\">,</span> <span class=\"kc\">True</span><span class=\"p\">]],</span> <span class=\"s1\">&#39;li&#39;</span><span class=\"p\">:</span> <span class=\"p\">[[</span><span class=\"s1\">&#39;class&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;task-list-item&#39;</span><span class=\"p\">]],</span> <span class=\"s1\">&#39;div&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;itemScope&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;itemType&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;blockquote&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;del&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;ins&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;q&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;*&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;abbr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;accept&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;acceptCharset&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;accessKey&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;action&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;align&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;alt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ariaDescribedBy&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ariaHidden&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ariaLabel&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ariaLabelledBy&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;axis&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;border&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cellPadding&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cellSpacing&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;char&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;charOff&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;charSet&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;checked&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;clear&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cols&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;colSpan&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;compact&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;coords&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dateTime&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dir&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;disabled&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;encType&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;htmlFor&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;frame&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;headers&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;height&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;hrefLang&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;hSpace&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;isMap&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;id&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;lang&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;maxLength&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;media&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;method&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;multiple&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;noHref&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;noShade&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;noWrap&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;open&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;prompt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;readOnly&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rel&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rev&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rows&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rowSpan&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rules&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;scope&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;selected&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;shape&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;size&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;span&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;start&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;summary&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tabIndex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;target&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;title&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;type&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;useMap&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;vAlign&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;value&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;vSpace&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;width&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;itemProp&#39;</span><span class=\"p\">]},</span> <span class=\"n\">required</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;input&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;type&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;checkbox&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;disabled&#39;</span><span class=\"p\">:</span> <span class=\"kc\">True</span><span class=\"p\">}})</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.transform.sanitize.Schema": {"fullname": "phml.utilities.transform.sanitize.Schema", "modulename": "phml.utilities.transform.sanitize", "qualname": "Schema", "type": "class", "doc": "<p>Dataclass of information on how to sanatize a phml tree.</p>\n\n<p><code>strip (list[str])</code>: The elements to strip from the tree.\n<code>protocols (dict[str, list])</code>: Collection of element name and allowed protocal value list\n<code>tag_names (list[str])</code>: List of allowed tag names.\n<code>attributes (dict[str, list[str | list[str]]])</code>: Collection of element name and allowed property\nnames.\n<code>required (dict[str, str | list[str]])</code>: Collection of element names and their required\nproperties and required property values.</p>\n"}, "phml.utilities.transform.sanitize.Schema.__init__": {"fullname": "phml.utilities.transform.sanitize.Schema.__init__", "modulename": "phml.utilities.transform.sanitize", "qualname": "Schema.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">strip</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">ancestors</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">protocols</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">tag_names</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">attributes</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">required</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span></span>)</span>"}, "phml.utilities.transform.transform": {"fullname": "phml.utilities.transform.transform", "modulename": "phml.utilities.transform.transform", "type": "module", "doc": "<p>phml.utilities.transform.transform</p>\n\n<p>Utility methods that revolve around transforming or manipulating the ast.</p>\n"}, "phml.utilities.transform.transform.filter_nodes": {"fullname": "phml.utilities.transform.transform.filter_nodes", "modulename": "phml.utilities.transform.transform", "qualname": "filter_nodes", "type": "function", "doc": "<p>Take a given tree and filter the nodes with the condition.\nOnly nodes passing the condition stay. If the parent node fails,\nall children are moved up in scope. Depth first</p>\n\n<p>Same as remove_nodes but keeps the nodes that match.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>tree (Root | Element):</strong>  The tree node to filter.</li>\n<li><strong>condition (Test):</strong>  The condition to apply to each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Root | Element: The given tree after being filtered.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.transform.transform.remove_nodes": {"fullname": "phml.utilities.transform.transform.remove_nodes", "modulename": "phml.utilities.transform.transform", "qualname": "remove_nodes", "type": "function", "doc": "<p>Take a given tree and remove the nodes that match the condition.\nIf a parent node is removed so is all the children.</p>\n\n<p>Same as filter_nodes except removes nodes that match.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>tree (Root | Element):</strong>  The parent node to start recursively removing from.</li>\n<li><strong>condition (Test):</strong>  The condition to apply to each node.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.transform.transform.map_nodes": {"fullname": "phml.utilities.transform.transform.map_nodes", "modulename": "phml.utilities.transform.transform", "qualname": "map_nodes", "type": "function", "doc": "<p>Takes a tree and a callable that returns a node and maps each node.</p>\n\n<p>Signature for the transform function should be as follows:</p>\n\n<ol>\n<li>Takes a single argument that is the node.</li>\n<li>Returns any type of node that is assigned to the original node.</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">def</span> <span class=\"nf\">to_links</span><span class=\"p\">(</span><span class=\"n\">node</span><span class=\"p\">):</span>\n    <span class=\"k\">return</span> <span class=\"n\">Element</span><span class=\"p\">(</span><span class=\"s2\">&quot;a&quot;</span><span class=\"p\">,</span> <span class=\"p\">{},</span> <span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"p\">,</span> <span class=\"n\">children</span><span class=\"o\">=</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">children</span><span class=\"p\">)</span>\n        <span class=\"k\">if</span> <span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">type</span> <span class=\"o\">==</span> <span class=\"s2\">&quot;element&quot;</span>\n        <span class=\"k\">else</span> <span class=\"n\">node</span>\n</code></pre>\n</div>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>tree (Root | Element):</strong>  Tree to transform.</li>\n<li><strong>transform (Callable):</strong>  The Callable that returns a node that is assigned</li>\n<li>to each node.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">transform</span><span class=\"p\">:</span> <span class=\"n\">Callable</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.transform.transform.find_and_replace": {"fullname": "phml.utilities.transform.transform.find_and_replace", "modulename": "phml.utilities.transform.transform", "qualname": "find_and_replace", "type": "function", "doc": "<p>Takes a ast, root, or any node and replaces text in <code>text</code>\nnodes with matching replacements.</p>\n\n<p>First value in each replacement tuple is the regex to match and\nthe second value is what to replace it with. This can either be\na string or a callable that returns a string or a new node. If\na new node is returned then the text element will be split.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">replacements</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Callable</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utilities.transform.transform.shift_heading": {"fullname": "phml.utilities.transform.transform.shift_heading", "modulename": "phml.utilities.transform.transform", "qualname": "shift_heading", "type": "function", "doc": "<p>Shift the heading by the amount specified.</p>\n\n<p>value is clamped between 1 and 6.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>, </span><span class=\"param\"><span class=\"n\">amount</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.transform.transform.replace_node": {"fullname": "phml.utilities.transform.transform.replace_node", "modulename": "phml.utilities.transform.transform", "qualname": "replace_node", "type": "function", "doc": "<p>Search for a specific node in the tree and replace it with either\na node or list of nodes. If replacement is None the found node is just removed.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (Root | Element):</strong>  The starting point.</li>\n<li><strong>condition (test):</strong>  Test condition to find the correct node.</li>\n<li><strong>replacement (NODE | list[NODE] | None):</strong>  What to replace the node with.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">replacement</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">all_nodes</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.transform.transform.modify_children": {"fullname": "phml.utilities.transform.transform.modify_children", "modulename": "phml.utilities.transform.transform", "qualname": "modify_children", "type": "function", "doc": "<p>Function wrapper that when called and passed an\nAST, Root, or Element will apply the wrapped function\nto each child. This means that whatever is returned\nfrom the wrapped function will be assigned to the child.</p>\n\n<p>The wrapped function will be passed the child node,\nthe index in the parents children, and the parent node</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">func</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.travel": {"fullname": "phml.utilities.travel", "modulename": "phml.utilities.travel", "type": "module", "doc": "<p></p>\n"}, "phml.utilities.travel.travel": {"fullname": "phml.utilities.travel.travel", "modulename": "phml.utilities.travel.travel", "type": "module", "doc": "<p>utilities.travel</p>\n\n<p>Collection of utilities that hep with traversing an ast or node tree.</p>\n"}, "phml.utilities.travel.travel.path": {"fullname": "phml.utilities.travel.travel.path", "modulename": "phml.utilities.travel.travel", "qualname": "path", "type": "function", "doc": "<p>Get a list of nodes where each one is a child of\nthe other leading to the node passed in. This gives a\npath to the node.</p>\n\n<p>Does not include given node.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (NODE):</strong>  Node to find ancestors of.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list[NODE]: List of nodes leading to the given node\n  starting from the root.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.travel.travel.path_names": {"fullname": "phml.utilities.travel.travel.path_names", "modulename": "phml.utilities.travel.travel", "qualname": "path_names", "type": "function", "doc": "<p>Get a list of nodes where each one is a child of\nthe other leading to the node passed in. This gives a\npath to the node.</p>\n\n<p>Does not include given node.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (NODE):</strong>  Node to find ancestors of.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list[str]: List of nodes leading to the given node\n  starting from the root.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.travel.travel.walk": {"fullname": "phml.utilities.travel.travel.walk", "modulename": "phml.utilities.travel.travel", "qualname": "walk", "type": "function", "doc": "<p>Recursively traverse the node and it's chidlren as an iterator.\nLeft to right depth first.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span>:</span></span>", "funcdef": "def"}, "phml.utilities.travel.travel.visit_children": {"fullname": "phml.utilities.travel.travel.visit_children", "modulename": "phml.utilities.travel.travel", "qualname": "visit_children", "type": "function", "doc": "<p>Traverse the children of a Root or Element as an iterator.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span>:</span></span>", "funcdef": "def"}, "phml.utilities.travel.travel.visit_all_after": {"fullname": "phml.utilities.travel.travel.visit_all_after", "modulename": "phml.utilities.travel.travel", "qualname": "visit_all_after", "type": "function", "doc": "<p>Recursively traverse the tree starting at given node.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate": {"fullname": "phml.utilities.validate", "modulename": "phml.utilities.validate", "type": "module", "doc": "<p>utilities.validate</p>\n\n<p>A collection of utilities centered around validating nodes, types,\nvalues on nodes, and any other condition you want to apply to a node\nor ast.</p>\n"}, "phml.utilities.validate.check": {"fullname": "phml.utilities.validate.check", "modulename": "phml.utilities.validate.check", "type": "module", "doc": "<p>phml.utilities.validate.test</p>\n\n<p>Logic that allows nodes to be tested against a series of conditions.</p>\n"}, "phml.utilities.validate.check.check": {"fullname": "phml.utilities.validate.check.check", "modulename": "phml.utilities.validate.check", "qualname": "check", "type": "function", "doc": "<p>Test if a node passes the given test(s).</p>\n\n<h6 id=\"test-types\">Test Types</h6>\n\n<blockquote>\n  <ul>\n  <li><code>None</code>: Just checks that the node is a valid node.</li>\n  <li><code>str</code>: Checks that the test value is == the <code>node.type</code>.</li>\n  <li><code>dict</code>: Checks all items are valid attributes on the node.\n  and that the values are strictly equal.</li>\n  <li><code>Callable</code>: Passes the given function the node and it's index, if provided,\n  and checks if the callable returned true.</li>\n  <li><code>list[Test]</code>: Apply all the rules above for each Test in the list.</li>\n  </ul>\n</blockquote>\n\n<p>If the <code>parent</code> arg is passed so should the <code>index</code> arg.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (NODE):</strong>  Node to test. Can be any phml node.</li>\n<li><strong>test (Test):</strong>  Test to apply to the node. See previous section</li>\n<li>for more info.</li>\n<li><strong>index (Optional[int], optional):</strong>  Index in the parent where the</li>\n<li>node exists. Defaults to None.</li>\n<li><strong>parent (Optional[Root | Element], optional):</strong>  The nodes parent. Defaults to None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>True if all tests pass.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span>,</span><span class=\"param\">\t<span class=\"n\">_test</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">index</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate": {"fullname": "phml.utilities.validate.validate", "modulename": "phml.utilities.validate.validate", "type": "module", "doc": "<p></p>\n"}, "phml.utilities.validate.validate.validate": {"fullname": "phml.utilities.validate.validate.validate", "modulename": "phml.utilities.validate.validate", "qualname": "validate", "type": "function", "doc": "<p>Validate a node based on attributes and type.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.parent": {"fullname": "phml.utilities.validate.validate.parent", "modulename": "phml.utilities.validate.validate", "qualname": "parent", "type": "function", "doc": "<p>Validate a parent node based on attributes and type.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.literal": {"fullname": "phml.utilities.validate.validate.literal", "modulename": "phml.utilities.validate.validate", "qualname": "literal", "type": "function", "doc": "<p>Validate a literal node based on attributes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.generated": {"fullname": "phml.utilities.validate.validate.generated", "modulename": "phml.utilities.validate.validate", "qualname": "generated", "type": "function", "doc": "<p>Checks if a node has been generated. A node is concidered\ngenerated if it does not have a position.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (NODE):</strong>  Node to check for position with.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>bool: Whether a node has a position or not.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.has_property": {"fullname": "phml.utilities.validate.validate.has_property", "modulename": "phml.utilities.validate.validate", "qualname": "has_property", "type": "function", "doc": "<p>Check to see if an element has a certain property in properties.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span>, </span><span class=\"param\"><span class=\"n\">attribute</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_heading": {"fullname": "phml.utilities.validate.validate.is_heading", "modulename": "phml.utilities.validate.validate", "qualname": "is_heading", "type": "function", "doc": "<p>Check if an element is a heading.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_css_link": {"fullname": "phml.utilities.validate.validate.is_css_link", "modulename": "phml.utilities.validate.validate", "qualname": "is_css_link", "type": "function", "doc": "<p>Check if an element is a <code>link</code> to a css file.</p>\n\n<p>Returns <code>true</code> if <code>node</code> is a <code>&lt;link&gt;</code> element with a <code>rel</code> list that\ncontains <code>'stylesheet'</code> and has no <code>type</code>, an empty <code>type</code>, or <code>'text/css'</code>\nas its <code>type</code></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_css_style": {"fullname": "phml.utilities.validate.validate.is_css_style", "modulename": "phml.utilities.validate.validate", "qualname": "is_css_style", "type": "function", "doc": "<p>Check if an element is a css <code>style</code> element.</p>\n\n<p>Returns <code>true</code> if <code>node</code> is a <code>&lt;style&gt;</code> element that\nhas no <code>type</code>, an empty <code>type</code>, or <code>'text/css'</code> as its <code>type</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_javascript": {"fullname": "phml.utilities.validate.validate.is_javascript", "modulename": "phml.utilities.validate.validate", "qualname": "is_javascript", "type": "function", "doc": "<p>Check if an element is a javascript <code>script</code> element.</p>\n\n<p>Returns <code>true</code> if <code>node</code> is a <code>&lt;script&gt;</code> element that has a valid JavaScript <code>type</code>, has no\n<code>type</code> and a valid JavaScript <code>language</code>, or has neither.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_element": {"fullname": "phml.utilities.validate.validate.is_element", "modulename": "phml.utilities.validate.validate", "qualname": "is_element", "type": "function", "doc": "<p>Checks if the given node is a certain element.</p>\n\n<p>When providing a str it will check that the elements tag matches.\nIf a list is provided it checks that one of the conditions in the list\npasses.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">conditions</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_embedded": {"fullname": "phml.utilities.validate.validate.is_embedded", "modulename": "phml.utilities.validate.validate", "qualname": "is_embedded", "type": "function", "doc": "<p>Check to see if an element is an embedded element.</p>\n\n<p>Embedded Elements:</p>\n\n<ul>\n<li>audio</li>\n<li>canvas</li>\n<li>embed</li>\n<li>iframe</li>\n<li>img</li>\n<li>MathML math</li>\n<li>object</li>\n<li>picture</li>\n<li>SVG svg</li>\n<li>video</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>True if emedded</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_interactive": {"fullname": "phml.utilities.validate.validate.is_interactive", "modulename": "phml.utilities.validate.validate", "qualname": "is_interactive", "type": "function", "doc": "<p>Check if the element is intended for user interaction.</p>\n\n<p>Conditions:</p>\n\n<ul>\n<li>a (if the href attribute is present)</li>\n<li>audio (if the controls attribute is present)</li>\n<li>button, details, embed, iframe, img (if the usemap attribute is present)</li>\n<li>input (if the type attribute is not in the Hidden state)</li>\n<li>label, select, text, area, video (if the controls attribute is present)</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>True if element is interactive</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_phrasing": {"fullname": "phml.utilities.validate.validate.is_phrasing", "modulename": "phml.utilities.validate.validate", "qualname": "is_phrasing", "type": "function", "doc": "<p>Check if a node is phrasing text according to\n<a href=\"https://html.spec.whatwg.org/#phrasing-content-2\">https://html.spec.whatwg.org/#phrasing-content-2</a>.</p>\n\n<p>Phrasing content is the text of the document, as well as elements that mark up that text at the\nintra-paragraph level. Runs of phrasing content form paragraphs.</p>\n\n<ul>\n<li>area (if it is a descendant of a map element)</li>\n<li>link (if it is allowed in the body)</li>\n<li>meta (if the itemprop attribute is present)</li>\n<li>map, mark, math, audio, b, bdi, bdo, br, button, canvas, cite, code, data, datalist, del, dfn,\nem, embed, i, iframe, img, input, ins, kbd, label, a, abbr, meter, noscript, object, output,\npicture, progress, q, ruby, s, samp, script, select, slot, small, span, strong, sub, sup, svg,\ntemplate, textarea, time, u, var, video, wbr, text (true)</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>True if the element is phrasing text</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_event_handler": {"fullname": "phml.utilities.validate.validate.is_event_handler", "modulename": "phml.utilities.validate.validate", "qualname": "is_event_handler", "type": "function", "doc": "<p>Takes a attribute name and returns true if\nit starts with <code>on</code> and its length is <code>5</code> or more.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">attribute</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.blank": {"fullname": "phml.utilities.validate.validate.blank", "modulename": "phml.utilities.validate.validate", "qualname": "blank", "type": "function", "doc": "<p>Takes any value type and returns whether it is blank/None.\nFor strings if the value is stripped and is equal to '' then it is blank.\nOtherwise if len &gt; 0 and is not None then not blank.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>value (Any):</strong>  The value to check if it is blank.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>bool: True if value is blank</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}}, "docInfo": {"phml": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3556}, "phml.builder": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 22}, "phml.builder.p": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 269, "bases": 0, "doc": 9}, "phml.core": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.compiler": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 21}, "phml.core.compiler.Compiler": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.core.compiler.Compiler.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 360, "bases": 0, "doc": 3}, "phml.core.compiler.Compiler.ast": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 14}, "phml.core.compiler.Compiler.add": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 547, "bases": 0, "doc": 167}, "phml.core.compiler.Compiler.remove": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 233, "bases": 0, "doc": 51}, "phml.core.compiler.Compiler.compile": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 185, "bases": 0, "doc": 9}, "phml.core.compiler.Compiler.render": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 189, "bases": 0, "doc": 9}, "phml.core.core": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.core.PHML": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 41}, "phml.core.core.PHML.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 769, "bases": 0, "doc": 3}, "phml.core.core.PHML.ast": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "phml.core.core.PHML.components": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "phml.core.core.PHML.expose": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 22}, "phml.core.core.PHML.redact": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 12}, "phml.core.core.PHML.expand": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 25}, "phml.core.core.PHML.restrict": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 27}, "phml.core.core.PHML.add": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 309, "bases": 0, "doc": 203}, "phml.core.core.PHML.remove": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 233, "bases": 0, "doc": 55}, "phml.core.core.PHML.load": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 99, "bases": 0, "doc": 38}, "phml.core.core.PHML.parse": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 69, "bases": 0, "doc": 32}, "phml.core.core.PHML.compile": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 116, "bases": 0, "doc": 108}, "phml.core.core.PHML.render": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 120, "bases": 0, "doc": 104}, "phml.core.core.PHML.write": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 170, "bases": 0, "doc": 212}, "phml.core.core.Compiler": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.core.core.Compiler.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 360, "bases": 0, "doc": 3}, "phml.core.core.Compiler.ast": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 14}, "phml.core.core.Compiler.add": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 547, "bases": 0, "doc": 167}, "phml.core.core.Compiler.remove": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 233, "bases": 0, "doc": 51}, "phml.core.core.Compiler.compile": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 185, "bases": 0, "doc": 9}, "phml.core.core.Compiler.render": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 189, "bases": 0, "doc": 9}, "phml.core.defaults": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.defaults.config": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 48}, "phml.core.formats.Formats": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "phml.core.formats.Formats.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 85, "bases": 0, "doc": 3}, "phml.core.formats.Formats.PHML": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 10}, "phml.core.formats.Formats.HTML": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 10}, "phml.core.formats.Formats.JSON": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 10}, "phml.core.formats.Formats.XML": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 10}, "phml.core.formats.compile": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.compile.compile": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "phml.core.formats.compile.compile.process_reserved_attrs": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 46, "bases": 0, "doc": 12}, "phml.core.formats.compile.compile.process_props": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 85, "bases": 0, "doc": 11}, "phml.core.formats.compile.compile.apply_conditions": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 210, "bases": 0, "doc": 67}, "phml.core.formats.compile.compile.process_reserved_elements": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 150, "bases": 0, "doc": 13}, "phml.core.formats.compile.compile.apply_python": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 130, "bases": 0, "doc": 52}, "phml.core.formats.compile.compile.py_condition": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 11}, "phml.core.formats.compile.compile.process_conditions": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 104, "bases": 0, "doc": 52}, "phml.core.formats.compile.compile.execute_conditions": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 78, "bases": 0, "doc": 134}, "phml.core.formats.compile.compile.build_locals": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 18}, "phml.core.formats.compile.compile.run_phml_if": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 67, "bases": 0, "doc": 16}, "phml.core.formats.compile.compile.run_phml_elif": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 78, "bases": 0, "doc": 16}, "phml.core.formats.compile.compile.run_phml_else": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 16}, "phml.core.formats.compile.compile.ASTRenderer": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 17}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 65, "bases": 0, "doc": 3}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 103, "bases": 0, "doc": 66}, "phml.core.formats.compile.component": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.compile.component.substitute_component": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 153, "bases": 0, "doc": 49}, "phml.core.formats.compile.component.replace_components": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 153, "bases": 0, "doc": 49}, "phml.core.formats.compile.component.combine_component_elements": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 32}, "phml.core.formats.compile.reserved": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.format": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.format.Format": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 33}, "phml.core.formats.format.Format.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.format.Format.extension": {"qualname": 2, "fullname": 6, "annotation": 4, "default_value": 5, "signature": 0, "bases": 0, "doc": 34}, "phml.core.formats.format.Format.suffix": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 10}, "phml.core.formats.format.Format.is_format": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 12}, "phml.core.formats.format.Format.parse": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 13}, "phml.core.formats.format.Format.compile": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 395, "bases": 0, "doc": 14}, "phml.core.formats.format.Format.render": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 393, "bases": 0, "doc": 16}, "phml.core.formats.html_format": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.html_format.parse_markup": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 10}, "phml.core.formats.html_format.HTMLFormat": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 10}, "phml.core.formats.html_format.HTMLFormat.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.html_format.HTMLFormat.extension": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 9, "signature": 0, "bases": 0, "doc": 34}, "phml.core.formats.html_format.HTMLFormat.parse": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 13}, "phml.core.formats.html_format.HTMLFormat.compile": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 395, "bases": 0, "doc": 14}, "phml.core.formats.html_format.HTMLFormat.render": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 393, "bases": 0, "doc": 16}, "phml.core.formats.json_format": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.json_format.construct_tree": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 8}, "phml.core.formats.json_format.JSONFormat": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 10}, "phml.core.formats.json_format.JSONFormat.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.json_format.JSONFormat.extension": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 34}, "phml.core.formats.json_format.JSONFormat.parse": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 13}, "phml.core.formats.json_format.JSONFormat.render": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 324, "bases": 0, "doc": 16}, "phml.core.formats.parse": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "phml.core.formats.parse.parse_hypertest_markup": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 11}, "phml.core.formats.parse.strip_blank_lines": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 15}, "phml.core.formats.parse.strip": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 54, "bases": 0, "doc": 34}, "phml.core.formats.parse.RE": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.parse.RE.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.parse.RE.tag_start": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 42, "signature": 0, "bases": 0, "doc": 17}, "phml.core.formats.parse.RE.tag_end": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 12, "signature": 0, "bases": 0, "doc": 16}, "phml.core.formats.parse.RE.comment": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 12, "signature": 0, "bases": 0, "doc": 16}, "phml.core.formats.parse.RE.attribute": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 58, "signature": 0, "bases": 0, "doc": 15}, "phml.core.formats.parse.HypertextMarkupParser": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 2, "signature": 0, "bases": 0, "doc": 14}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 18}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 57}, "phml.core.formats.phml_format": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.phml_format.parse_markup": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 10}, "phml.core.formats.phml_format.PHMLFormat": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 10}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.phml_format.PHMLFormat.extension": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 34}, "phml.core.formats.phml_format.PHMLFormat.parse": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 13}, "phml.core.formats.phml_format.PHMLFormat.compile": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 326, "bases": 0, "doc": 14}, "phml.core.formats.phml_format.PHMLFormat.render": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 324, "bases": 0, "doc": 16}, "phml.core.formats.xml_format": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.xml_format.XMLFormat": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 10}, "phml.core.formats.xml_format.XMLFormat.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.xml_format.XMLFormat.extension": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 34}, "phml.core.formats.xml_format.XMLFormat.parse": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 13}, "phml.core.formats.xml_format.XMLFormat.compile": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 326, "bases": 0, "doc": 14}, "phml.core.formats.xml_format.XMLFormat.render": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 324, "bases": 0, "doc": 16}, "phml.core.nodes": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.core.nodes.AST": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 38}, "phml.core.nodes.AST.AST": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 16}, "phml.core.nodes.AST.AST.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 3}, "phml.core.nodes.AST.AST.size": {"qualname": 2, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "phml.core.nodes.AST.AST.children": {"qualname": 2, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 17}, "phml.core.nodes.nodes": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Element": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 341}, "phml.core.nodes.nodes.Element.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 162, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Element.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 65, "bases": 0, "doc": 26}, "phml.core.nodes.nodes.Element.start_tag": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 37, "bases": 0, "doc": 49}, "phml.core.nodes.nodes.Element.end_tag": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 23}, "phml.core.nodes.nodes.Root": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 37}, "phml.core.nodes.nodes.Root.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 72, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Node": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 62}, "phml.core.nodes.nodes.Node.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Node.position": {"qualname": 2, "fullname": 6, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 34}, "phml.core.nodes.nodes.Node.type": {"qualname": 2, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 24}, "phml.core.nodes.nodes.DocType": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 65}, "phml.core.nodes.nodes.DocType.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 148, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.DocType.stringify": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 26}, "phml.core.nodes.nodes.Parent": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 29}, "phml.core.nodes.nodes.Parent.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 72, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Parent.append": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 225, "bases": 0, "doc": 15}, "phml.core.nodes.nodes.Parent.extend": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 231, "bases": 0, "doc": 15}, "phml.core.nodes.nodes.Parent.insert": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 236, "bases": 0, "doc": 17}, "phml.core.nodes.nodes.Parent.remove": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 225, "bases": 0, "doc": 14}, "phml.core.nodes.nodes.PI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 11}, "phml.core.nodes.nodes.PI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.PI.stringify": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 28, "bases": 0, "doc": 12}, "phml.core.nodes.nodes.Comment": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 31}, "phml.core.nodes.nodes.Comment.stringify": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 24}, "phml.core.nodes.nodes.Literal": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 13}, "phml.core.nodes.nodes.Literal.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 145, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Literal.position": {"qualname": 2, "fullname": 6, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 34}, "phml.core.nodes.nodes.Literal.value": {"qualname": 2, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "phml.core.nodes.nodes.Literal.normalized": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 15}, "phml.core.nodes.nodes.Literal.stringify": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Literal.get_ancestry": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 27}, "phml.core.nodes.nodes.Point": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 52}, "phml.core.nodes.nodes.Point.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Position": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 151}, "phml.core.nodes.nodes.Position.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 90, "bases": 0, "doc": 52}, "phml.core.nodes.nodes.Position.as_dict": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 10}, "phml.core.nodes.nodes.Text": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 177}, "phml.core.nodes.nodes.Text.num_lines": {"qualname": 3, "fullname": 7, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "phml.core.nodes.types": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "phml.core.nodes.types.Properties": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 4, "signature": 0, "bases": 0, "doc": 24}, "phml.core.parser": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 36}, "phml.core.parser.Parser": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 107}, "phml.core.parser.Parser.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.parser.Parser.ast": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "phml.core.parser.Parser.load": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 76}, "phml.core.parser.Parser.parse": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 69, "bases": 0, "doc": 111}, "phml.core.virtual_python": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 380}, "phml.core.virtual_python.VirtualPython": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 14}, "phml.core.virtual_python.VirtualPython.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 107, "bases": 0, "doc": 3}, "phml.core.virtual_python.VirtualPython.get_python_context": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 51, "bases": 0, "doc": 41}, "phml.core.virtual_python.get_python_result": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 30}, "phml.core.virtual_python.process_python_blocks": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 97}, "phml.core.virtual_python.Import": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 7, "doc": 19}, "phml.core.virtual_python.Import.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 3}, "phml.core.virtual_python.Import.from_node": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 46}, "phml.core.virtual_python.ImportFrom": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 7, "doc": 19}, "phml.core.virtual_python.ImportFrom.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 3}, "phml.core.virtual_python.ImportFrom.from_node": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 46}, "phml.types": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utilities": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 26}, "phml.utilities.locate": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 17}, "phml.utilities.locate.find": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 22}, "phml.utilities.locate.find.ancestor": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 438, "bases": 0, "doc": 72}, "phml.utilities.locate.find.find": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 573, "bases": 0, "doc": 76}, "phml.utilities.locate.find.find_all": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 567, "bases": 0, "doc": 64}, "phml.utilities.locate.find.find_after": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 710, "bases": 0, "doc": 72}, "phml.utilities.locate.find.find_all_after": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 522, "bases": 0, "doc": 72}, "phml.utilities.locate.find.find_all_before": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 522, "bases": 0, "doc": 78}, "phml.utilities.locate.find.find_before": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 710, "bases": 0, "doc": 92}, "phml.utilities.locate.find.find_all_between": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 647, "bases": 0, "doc": 147}, "phml.utilities.locate.index": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utilities.locate.index.Index": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 44}, "phml.utilities.locate.index.Index.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 366, "bases": 0, "doc": 109}, "phml.utilities.locate.index.Index.indexed_tree": {"qualname": 3, "fullname": 7, "annotation": 7, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "phml.utilities.locate.index.Index.items": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 11}, "phml.utilities.locate.index.Index.values": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 10}, "phml.utilities.locate.index.Index.keys": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 10}, "phml.utilities.locate.index.Index.add": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 12}, "phml.utilities.locate.index.Index.remove": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 10}, "phml.utilities.locate.index.Index.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 11}, "phml.utilities.locate.index.Index.key_by_tag": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 24}, "phml.utilities.locate.select": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 18}, "phml.utilities.locate.select.query": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 123, "bases": 0, "doc": 259}, "phml.utilities.locate.select.query_all": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 129, "bases": 0, "doc": 261}, "phml.utilities.locate.select.matches": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 191}, "phml.utilities.locate.select.parse_specifiers": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 141}, "phml.utilities.misc": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 23}, "phml.utilities.misc.depth": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 34}, "phml.utilities.misc.size": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 65, "bases": 0, "doc": 9}, "phml.utilities.misc.offset": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 14}, "phml.utilities.misc.classes": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 25}, "phml.utilities.misc.classes.classnames": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 96, "bases": 0, "doc": 197}, "phml.utilities.misc.classes.ClassList": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 29}, "phml.utilities.misc.classes.ClassList.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 3}, "phml.utilities.misc.classes.ClassList.contains": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 12}, "phml.utilities.misc.classes.ClassList.toggle": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 10}, "phml.utilities.misc.classes.ClassList.add": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 12}, "phml.utilities.misc.classes.ClassList.replace": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 14}, "phml.utilities.misc.classes.ClassList.remove": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 12}, "phml.utilities.misc.classes.ClassList.class_list": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 9}, "phml.utilities.misc.component": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utilities.misc.component.tokanize_name": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 86}, "phml.utilities.misc.component.tag_from_file": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 35}, "phml.utilities.misc.component.filename_from_path": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 13}, "phml.utilities.misc.component.parse_component": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 10}, "phml.utilities.misc.component.valid_component_dict": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 10}, "phml.utilities.misc.component.cmpt_name_from_path": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 51}, "phml.utilities.misc.heading": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "phml.utilities.misc.heading.heading_rank": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 26}, "phml.utilities.misc.inspect": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 25}, "phml.utilities.misc.inspect.inspect": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 263, "bases": 0, "doc": 10}, "phml.utilities.misc.inspect.normalize_indent": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 87}, "phml.utilities.transform": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 20}, "phml.utilities.transform.normalize_indent": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 62}, "phml.utilities.transform.extract": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utilities.transform.extract.to_string": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 248, "bases": 0, "doc": 59}, "phml.utilities.transform.sanitize": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.utilities.transform.sanitize.sanatize": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 2118, "bases": 0, "doc": 137}, "phml.utilities.transform.sanitize.Schema": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 90}, "phml.utilities.transform.sanitize.Schema.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 245, "bases": 0, "doc": 3}, "phml.utilities.transform.transform": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 19}, "phml.utilities.transform.transform.filter_nodes": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 356, "bases": 0, "doc": 102}, "phml.utilities.transform.transform.remove_nodes": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 356, "bases": 0, "doc": 78}, "phml.utilities.transform.transform.map_nodes": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 100, "bases": 0, "doc": 203}, "phml.utilities.transform.transform.find_and_replace": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 111, "bases": 0, "doc": 75}, "phml.utilities.transform.transform.shift_heading": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 46, "bases": 0, "doc": 20}, "phml.utilities.transform.transform.replace_node": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 786, "bases": 0, "doc": 85}, "phml.utilities.transform.transform.modify_children": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 60}, "phml.utilities.travel": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utilities.travel.travel": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 19}, "phml.utilities.travel.travel.path": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 430, "bases": 0, "doc": 81}, "phml.utilities.travel.travel.path_names": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 228, "bases": 0, "doc": 81}, "phml.utilities.travel.travel.walk": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 66, "bases": 0, "doc": 19}, "phml.utilities.travel.travel.visit_children": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 66, "bases": 0, "doc": 14}, "phml.utilities.travel.travel.visit_all_after": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 222, "bases": 0, "doc": 11}, "phml.utilities.validate": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 32}, "phml.utilities.validate.check": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 21}, "phml.utilities.validate.check.check": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 590, "bases": 0, "doc": 237}, "phml.utilities.validate.validate": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utilities.validate.validate.validate": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 222, "bases": 0, "doc": 11}, "phml.utilities.validate.validate.parent": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 65, "bases": 0, "doc": 12}, "phml.utilities.validate.validate.literal": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 65, "bases": 0, "doc": 10}, "phml.utilities.validate.validate.generated": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 222, "bases": 0, "doc": 62}, "phml.utilities.validate.validate.has_property": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 15}, "phml.utilities.validate.validate.is_heading": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 10}, "phml.utilities.validate.validate.is_css_link": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 71}, "phml.utilities.validate.validate.is_css_style": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 57}, "phml.utilities.validate.validate.is_javascript": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 58}, "phml.utilities.validate.validate.is_element": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 43}, "phml.utilities.validate.validate.is_embedded": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 65}, "phml.utilities.validate.validate.is_interactive": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 95}, "phml.utilities.validate.validate.is_phrasing": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 163}, "phml.utilities.validate.validate.is_event_handler": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 26}, "phml.utilities.validate.validate.blank": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 78}}, "length": 282, "save": true}, "index": {"qualname": {"root": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 29, "p": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.PHML.components": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.Formats.PHML": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 19, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}}, "df": 6}}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}}, "df": 13, "r": {"docs": {"phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}}, "df": 7}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 4}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 5}}}}, "p": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}, "y": {"docs": {"phml.utilities.validate.validate.has_property": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {"phml.core.formats.compile.compile.py_condition": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 4}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}}, "df": 5}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Point": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {"phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}}, "df": 3}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}}, "df": 8, "r": {"docs": {"phml.core.compiler.Compiler": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.Compiler": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.ast": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}}, "df": 14}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}}, "df": 4, "s": {"docs": {"phml.core.core.PHML.components": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}}, "df": 2}}}}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.combine_component_elements": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}}, "df": 3}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.py_condition": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 3}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.json_format.construct_tree": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.ClassList.contains": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 8}}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}}, "df": 3}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 29}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Parent.insert": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.inspect.inspect": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}}, "df": 10, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 1}}}}}}}}}}, "f": {"docs": {"phml.core.formats.compile.compile.run_phml_if": {"tf": 1}}, "df": 1}, "s": {"docs": {"phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 11}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}}, "df": 3, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 3}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.index.Index.items": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.nodes.Position.as_dict": {"tf": 1}}, "df": 1, "t": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.Compiler.ast": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}}, "df": 8, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}}, "df": 3}}}}}}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}}, "df": 5}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Parent.append": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.find.ancestor": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {"phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 6}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 3}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 6, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}}, "df": 7}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 8}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.redact": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.restrict": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.get_python_result": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 4}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 3}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.misc.heading.heading_rank": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.expose": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.expand": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}}, "df": 5}}}}, "d": {"docs": {"phml.core.nodes.nodes.Parent.extend": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.get": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 6, "s": {"docs": {"phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {"phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.load": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}}, "df": 2}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.build_locals": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 2}}, "k": {"docs": {"phml.utilities.validate.validate.is_css_link": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}}, "df": 8}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.travel.travel.walk": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}}, "df": 8, "s": {"docs": {"phml.core.formats.Formats": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.formats.Formats.PHML": {"tf": 1}, "phml.core.formats.Formats.HTML": {"tf": 1}, "phml.core.formats.Formats.JSON": {"tf": 1}, "phml.core.formats.Formats.XML": {"tf": 1}}, "df": 6}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 5}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 8}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.filename_from_path": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.Formats.HTML": {"tf": 1}}, "df": 1, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}}, "df": 6}}}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}}, "df": 3}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.has_property": {"tf": 1}}, "df": 1}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.Formats.JSON": {"tf": 1}}, "df": 1, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}}, "df": 5}}}}}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_javascript": {"tf": 1}}, "df": 1}}}}}}}}}}, "x": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.Formats.XML": {"tf": 1}}, "df": 1, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 6}}}}}}}}}, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.build_locals": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {"phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}}, "df": 1}}}}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.core.formats.format.Format.suffix": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}}, "df": 2}, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}}, "df": 4}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}}, "df": 2}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.is_css_style": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}}, "df": 2}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}}, "df": 3}}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.select.matches": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {"phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.transform.modify_children": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 7}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Node.type": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Text": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 2}}}, "o": {"docs": {"phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}}, "df": 1}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Element.get": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}}, "df": 5}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 7, "s": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 2, "d": {"docs": {"phml.core.nodes.nodes.Literal.normalized": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}}, "df": 3}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.misc.depth": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Literal.value": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.locate.index.Index.values": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.misc.component.valid_component_dict": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.validate": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 3}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 2}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.locate.index.Index.keys": {"tf": 1}}, "df": 1}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.offset": {"tf": 1}}, "df": 1}}}}}}}}, "fullname": {"root": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 29, "p": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}, "phml.builder": {"tf": 1}, "phml.builder.p": {"tf": 1}, "phml.core": {"tf": 1}, "phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core": {"tf": 1}, "phml.core.core.PHML": {"tf": 1.4142135623730951}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.ast": {"tf": 1.4142135623730951}, "phml.core.core.PHML.components": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expose": {"tf": 1.4142135623730951}, "phml.core.core.PHML.redact": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expand": {"tf": 1.4142135623730951}, "phml.core.core.PHML.restrict": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.load": {"tf": 1.4142135623730951}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.core.Compiler": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.ast": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.defaults": {"tf": 1}, "phml.core.defaults.config": {"tf": 1}, "phml.core.formats": {"tf": 1}, "phml.core.formats.Formats": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.formats.Formats.PHML": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.HTML": {"tf": 1}, "phml.core.formats.Formats.JSON": {"tf": 1}, "phml.core.formats.Formats.XML": {"tf": 1}, "phml.core.formats.compile": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.compile.reserved": {"tf": 1}, "phml.core.formats.format": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format": {"tf": 1}, "phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.parse.RE": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.parse_markup": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.get": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Point": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.core.nodes.types": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.core.parser": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.types": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.locate": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.component": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.extract": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 282, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}}, "df": 6}}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1.4142135623730951}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.parse.RE": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}}, "df": 26, "r": {"docs": {"phml.core.parser": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.__init__": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.ast": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.load": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 1.4142135623730951}}, "df": 6}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}}, "df": 7}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 4}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 5}}}}, "p": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}, "y": {"docs": {"phml.utilities.validate.validate.has_property": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {"phml.core.formats.compile.compile.py_condition": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.4142135623730951}, "phml.core.virtual_python.get_python_result": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 13}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}}, "df": 5}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Point": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {"phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}}, "df": 3}}, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.build_locals": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.builder": {"tf": 1}, "phml.builder.p": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {"phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core": {"tf": 1}, "phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core": {"tf": 1.4142135623730951}, "phml.core.core.PHML": {"tf": 1.4142135623730951}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.ast": {"tf": 1.4142135623730951}, "phml.core.core.PHML.components": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expose": {"tf": 1.4142135623730951}, "phml.core.core.PHML.redact": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expand": {"tf": 1.4142135623730951}, "phml.core.core.PHML.restrict": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.load": {"tf": 1.4142135623730951}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.core.Compiler": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.ast": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.render": {"tf": 1.4142135623730951}, "phml.core.defaults": {"tf": 1}, "phml.core.defaults.config": {"tf": 1}, "phml.core.formats": {"tf": 1}, "phml.core.formats.Formats": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.formats.Formats.PHML": {"tf": 1}, "phml.core.formats.Formats.HTML": {"tf": 1}, "phml.core.formats.Formats.JSON": {"tf": 1}, "phml.core.formats.Formats.XML": {"tf": 1}, "phml.core.formats.compile": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.compile.reserved": {"tf": 1}, "phml.core.formats.format": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format": {"tf": 1}, "phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.parse.RE": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.get": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Point": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.core.nodes.types": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.core.parser": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 183}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.formats.compile": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_python": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.py_condition": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.build_locals": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.7320508075688772}, "phml.core.formats.compile.component": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.compile.reserved": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}}, "df": 29, "r": {"docs": {"phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.ast": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.render": {"tf": 1.4142135623730951}, "phml.core.core.Compiler": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.ast": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}}, "df": 15}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.component": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1.4142135623730951}, "phml.utilities.misc.component": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 11, "s": {"docs": {"phml.core.core.PHML.components": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}}, "df": 2}}}}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.combine_component_elements": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}}, "df": 3}}}}}, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.defaults.config": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.py_condition": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 3}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.json_format.construct_tree": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.ClassList.contains": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 10}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 8}}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}}, "df": 3}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}}, "df": 2}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 29}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Parent.insert": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1}}, "df": 3}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.utilities.locate.index": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.items": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.values": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.keys": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.add": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.remove": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.get": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1.4142135623730951}}, "df": 11, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 1}}}}}}}}}}, "f": {"docs": {"phml.core.formats.compile.compile.run_phml_if": {"tf": 1}}, "df": 1}, "s": {"docs": {"phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 11}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}}, "df": 3, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 3}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.index.Index.items": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.nodes.Position.as_dict": {"tf": 1}}, "df": 1, "t": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.Compiler.ast": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.size": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.children": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.ast": {"tf": 1}}, "df": 9, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}}, "df": 3}}}}}}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}}, "df": 5}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Parent.append": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.find.ancestor": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {"phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 6}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 3}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 6, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}}, "df": 7}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 8}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.redact": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.restrict": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.reserved": {"tf": 1}}, "df": 3}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.get_python_result": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 4}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 3}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.misc.heading.heading_rank": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.expose": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.expand": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}}, "df": 5}}}}, "d": {"docs": {"phml.core.nodes.nodes.Parent.extend": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.extract": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.get": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 6, "s": {"docs": {"phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {"phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.load": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}}, "df": 2}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.build_locals": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 26}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 2}}, "k": {"docs": {"phml.utilities.validate.validate.is_css_link": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}}, "df": 8}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.travel.travel.walk": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.defaults": {"tf": 1}, "phml.core.defaults.config": {"tf": 1}}, "df": 2}}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.misc.depth": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}}, "df": 3}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}}, "df": 2}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.format": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.__init__": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.extension": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.suffix": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.is_format": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.parse": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.render": {"tf": 1.4142135623730951}, "phml.core.formats.html_format": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format": {"tf": 1}, "phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 39, "s": {"docs": {"phml.core.formats": {"tf": 1}, "phml.core.formats.Formats": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.__init__": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.PHML": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.HTML": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.JSON": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.XML": {"tf": 1.4142135623730951}, "phml.core.formats.compile": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.compile.reserved": {"tf": 1}, "phml.core.formats.format": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format": {"tf": 1}, "phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.parse.RE": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 83}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 5}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 10}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.filename_from_path": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.Formats.HTML": {"tf": 1}, "phml.core.formats.html_format": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}}, "df": 9, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}}, "df": 6}}}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}}, "df": 4}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.has_property": {"tf": 1}}, "df": 1}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.Formats.JSON": {"tf": 1}, "phml.core.formats.json_format": {"tf": 1}, "phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}}, "df": 8, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}}, "df": 5}}}}}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_javascript": {"tf": 1}}, "df": 1}}}}}}}}}}, "x": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.Formats.XML": {"tf": 1}, "phml.core.formats.xml_format": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 8, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 6}}}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}}, "df": 1}}}}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.core.formats.format.Format.suffix": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}}, "df": 2}, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}}, "df": 4}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}}, "df": 2}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.is_css_style": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.select": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 5}}}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}}, "df": 2}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 4}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}}, "df": 3}}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.select.matches": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {"phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {"phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.component": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1}}, "df": 26}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.transform.modify_children": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.extract": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.shift_heading": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.modify_children": {"tf": 1.4142135623730951}}, "df": 16}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.travel": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.walk": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.visit_children": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1.4142135623730951}}, "df": 7}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 7}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Node.type": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.nodes.types": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.types": {"tf": 1}}, "df": 3}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Text": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 2}}}, "o": {"docs": {"phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 7, "s": {"docs": {"phml.core.nodes": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.get": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.type": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.append": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.PI": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Comment": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.value": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Point": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Text": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1.4142135623730951}, "phml.core.nodes.types": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 51}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 2, "d": {"docs": {"phml.core.nodes.nodes.Literal.normalized": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Element.get": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}}, "df": 5}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 1}}}}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Literal.value": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.locate.index.Index.values": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.misc.component.valid_component_dict": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.validate": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.parent": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.literal": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.generated": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.has_property": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_heading": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_css_link": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_css_style": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_javascript": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_embedded": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_interactive": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.blank": {"tf": 1.4142135623730951}}, "df": 19}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 12, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 3}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities": {"tf": 1}, "phml.utilities.locate": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.component": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.extract": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 95}}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.locate.index.Index.keys": {"tf": 1}}, "df": 1}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.offset": {"tf": 1}}, "df": 1}}}}}}}}, "annotation": {"root": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.PHML.components": {"tf": 1}, "phml.core.core.Compiler.ast": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 18, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.Compiler.ast": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}}, "df": 6}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}}, "df": 2}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.Compiler.ast": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 7}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.Compiler.ast": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.position": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1.4142135623730951}}, "df": 7}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1.4142135623730951}, "phml.core.core.PHML.ast": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.ast": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.ast": {"tf": 1.4142135623730951}}, "df": 4}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.components": {"tf": 1}}, "df": 1, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}}, "df": 6}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.AST.AST.children": {"tf": 1}}, "df": 1, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}}, "df": 2}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}}}}}}}, "default_value": {"root": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.parse.RE.tag_start": {"tf": 3.872983346207417}, "phml.core.formats.parse.RE.tag_end": {"tf": 1.7320508075688772}, "phml.core.formats.parse.RE.comment": {"tf": 2.23606797749979}, "phml.core.formats.parse.RE.attribute": {"tf": 4.47213595499958}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.nodes.types.Properties": {"tf": 1}}, "df": 11, "x": {"2": {"7": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 2}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.parse.RE.tag_start": {"tf": 1.4142135623730951}, "phml.core.formats.parse.RE.tag_end": {"tf": 1.4142135623730951}, "phml.core.formats.parse.RE.comment": {"tf": 1.4142135623730951}, "phml.core.formats.parse.RE.attribute": {"tf": 2.449489742783178}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1.4142135623730951}}, "df": 9}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1}}, "df": 1}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}}, "df": 1, "l": {"docs": {"phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}}, "df": 1}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 4}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 4}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.RE.tag_end": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 2}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 2.449489742783178}}, "df": 3, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 2.6457513110645907}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 2.449489742783178}}, "df": 4}}, "g": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 2.449489742783178}, "phml.core.formats.parse.RE.tag_end": {"tf": 1.4142135623730951}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 2.6457513110645907}}, "df": 4}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"2": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}}, "df": 1}, "docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 2}}}}, "w": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 2}, "s": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 2}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}}}, "signature": {"root": {"0": {"docs": {"phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 8}, "2": {"docs": {"phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}}, "df": 3}, "3": {"9": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 2}, "phml.core.core.PHML.__init__": {"tf": 3.1622776601683795}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.__init__": {"tf": 2}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 2.449489742783178}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 2}, "phml.core.formats.format.Format.compile": {"tf": 2.449489742783178}, "phml.core.formats.format.Format.render": {"tf": 2.449489742783178}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 2.449489742783178}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 2.449489742783178}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 19.493588689617926}}, "df": 14}, "docs": {}, "df": 0}, "4": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}}, "df": 4}, "docs": {"phml.builder.p": {"tf": 14.832396974191326}, "phml.core.compiler.Compiler.__init__": {"tf": 17.05872210923198}, "phml.core.compiler.Compiler.add": {"tf": 21.095023109728988}, "phml.core.compiler.Compiler.remove": {"tf": 13.784048752090222}, "phml.core.compiler.Compiler.compile": {"tf": 11.74734012447073}, "phml.core.compiler.Compiler.render": {"tf": 11.916375287812984}, "phml.core.core.PHML.__init__": {"tf": 24.95996794869737}, "phml.core.core.PHML.expose": {"tf": 4.47213595499958}, "phml.core.core.PHML.redact": {"tf": 4.242640687119285}, "phml.core.core.PHML.expand": {"tf": 4.47213595499958}, "phml.core.core.PHML.restrict": {"tf": 4.47213595499958}, "phml.core.core.PHML.add": {"tf": 15.874507866387544}, "phml.core.core.PHML.remove": {"tf": 13.784048752090222}, "phml.core.core.PHML.load": {"tf": 8.94427190999916}, "phml.core.core.PHML.parse": {"tf": 6.557438524302}, "phml.core.core.PHML.compile": {"tf": 9.055385138137417}, "phml.core.core.PHML.render": {"tf": 9.273618495495704}, "phml.core.core.PHML.write": {"tf": 11.269427669584644}, "phml.core.core.Compiler.__init__": {"tf": 17.05872210923198}, "phml.core.core.Compiler.add": {"tf": 21.095023109728988}, "phml.core.core.Compiler.remove": {"tf": 13.784048752090222}, "phml.core.core.Compiler.compile": {"tf": 11.74734012447073}, "phml.core.core.Compiler.render": {"tf": 11.916375287812984}, "phml.core.formats.Formats.__init__": {"tf": 4.123105625617661}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 6.164414002968976}, "phml.core.formats.compile.compile.process_props": {"tf": 8.18535277187245}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 12.884098726725126}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 10.908712114635714}, "phml.core.formats.compile.compile.apply_python": {"tf": 10.246950765959598}, "phml.core.formats.compile.compile.py_condition": {"tf": 5.656854249492381}, "phml.core.formats.compile.compile.process_conditions": {"tf": 9.16515138991168}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 7.937253933193772}, "phml.core.formats.compile.compile.build_locals": {"tf": 4.242640687119285}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 7.483314773547883}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 8.06225774829855}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 7.615773105863909}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 7.3484692283495345}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 9.219544457292887}, "phml.core.formats.compile.component.substitute_component": {"tf": 11.135528725660043}, "phml.core.formats.compile.component.replace_components": {"tf": 11.135528725660043}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 7.937253933193772}, "phml.core.formats.format.Format.__init__": {"tf": 2}, "phml.core.formats.format.Format.suffix": {"tf": 3.4641016151377544}, "phml.core.formats.format.Format.is_format": {"tf": 4.58257569495584}, "phml.core.formats.format.Format.parse": {"tf": 5.830951894845301}, "phml.core.formats.format.Format.compile": {"tf": 17.804493814764857}, "phml.core.formats.format.Format.render": {"tf": 17.776388834631177}, "phml.core.formats.html_format.parse_markup": {"tf": 7.54983443527075}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 2}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 5.830951894845301}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 17.804493814764857}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 17.776388834631177}, "phml.core.formats.json_format.construct_tree": {"tf": 3.7416573867739413}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 2}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 5}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 16.24807680927192}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 7.54983443527075}, "phml.core.formats.parse.strip_blank_lines": {"tf": 5.0990195135927845}, "phml.core.formats.parse.strip": {"tf": 6.6332495807108}, "phml.core.formats.parse.RE.__init__": {"tf": 2}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 2}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 5.291502622129181}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 7.0710678118654755}, "phml.core.formats.phml_format.parse_markup": {"tf": 7.54983443527075}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 2}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 5.830951894845301}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 16.278820596099706}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 16.24807680927192}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 2}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 4.47213595499958}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 16.278820596099706}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 16.24807680927192}, "phml.core.nodes.AST.AST.__init__": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Element.__init__": {"tf": 11.532562594670797}, "phml.core.nodes.nodes.Element.get": {"tf": 7.3484692283495345}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 5.5677643628300215}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 3.4641016151377544}, "phml.core.nodes.nodes.Root.__init__": {"tf": 7.745966692414834}, "phml.core.nodes.nodes.Node.__init__": {"tf": 6.244997998398398}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 11.045361017187261}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 5.0990195135927845}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 7.745966692414834}, "phml.core.nodes.nodes.Parent.append": {"tf": 13.527749258468683}, "phml.core.nodes.nodes.Parent.extend": {"tf": 13.711309200802088}, "phml.core.nodes.nodes.Parent.insert": {"tf": 13.856406460551018}, "phml.core.nodes.nodes.Parent.remove": {"tf": 13.527749258468683}, "phml.core.nodes.nodes.PI.__init__": {"tf": 7.615773105863909}, "phml.core.nodes.nodes.PI.stringify": {"tf": 4.898979485566356}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 5.0990195135927845}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 10.908712114635714}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 5.0990195135927845}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 5.0990195135927845}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 4.123105625617661}, "phml.core.nodes.nodes.Point.__init__": {"tf": 6.244997998398398}, "phml.core.nodes.nodes.Position.__init__": {"tf": 8.602325267042627}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 3.4641016151377544}, "phml.core.parser.Parser.__init__": {"tf": 2}, "phml.core.parser.Parser.load": {"tf": 8.94427190999916}, "phml.core.parser.Parser.parse": {"tf": 6.557438524302}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 9.486832980505138}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 6.48074069840786}, "phml.core.virtual_python.get_python_result": {"tf": 4.69041575982343}, "phml.core.virtual_python.process_python_blocks": {"tf": 7}, "phml.core.virtual_python.Import.__init__": {"tf": 4.123105625617661}, "phml.core.virtual_python.Import.from_node": {"tf": 5.656854249492381}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 5}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 5.656854249492381}, "phml.utilities.locate.find.ancestor": {"tf": 18.841443681416774}, "phml.utilities.locate.find.find": {"tf": 21.563858652847824}, "phml.utilities.locate.find.find_all": {"tf": 21.447610589527216}, "phml.utilities.locate.find.find_after": {"tf": 24}, "phml.utilities.locate.find.find_all_after": {"tf": 20.591260281974}, "phml.utilities.locate.find.find_all_before": {"tf": 20.591260281974}, "phml.utilities.locate.find.find_before": {"tf": 24}, "phml.utilities.locate.find.find_all_between": {"tf": 22.956480566497994}, "phml.utilities.locate.index.Index.__init__": {"tf": 17.26267650163207}, "phml.utilities.locate.index.Index.items": {"tf": 4.69041575982343}, "phml.utilities.locate.index.Index.values": {"tf": 4.123105625617661}, "phml.utilities.locate.index.Index.keys": {"tf": 4.123105625617661}, "phml.utilities.locate.index.Index.add": {"tf": 5.830951894845301}, "phml.utilities.locate.index.Index.remove": {"tf": 5.830951894845301}, "phml.utilities.locate.index.Index.get": {"tf": 6.708203932499369}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 6}, "phml.utilities.locate.select.query": {"tf": 10}, "phml.utilities.locate.select.query_all": {"tf": 10.246950765959598}, "phml.utilities.locate.select.matches": {"tf": 6.324555320336759}, "phml.utilities.locate.select.parse_specifiers": {"tf": 4}, "phml.utilities.misc.depth": {"tf": 3.4641016151377544}, "phml.utilities.misc.size": {"tf": 7.280109889280518}, "phml.utilities.misc.offset": {"tf": 5.0990195135927845}, "phml.utilities.misc.classes.classnames": {"tf": 8.94427190999916}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 5.291502622129181}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 4.242640687119285}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 4.47213595499958}, "phml.utilities.misc.classes.ClassList.add": {"tf": 4.47213595499958}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 5.0990195135927845}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 4.47213595499958}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 3.4641016151377544}, "phml.utilities.misc.component.tokanize_name": {"tf": 5.916079783099616}, "phml.utilities.misc.component.tag_from_file": {"tf": 5}, "phml.utilities.misc.component.filename_from_path": {"tf": 4.47213595499958}, "phml.utilities.misc.component.parse_component": {"tf": 7.615773105863909}, "phml.utilities.misc.component.valid_component_dict": {"tf": 4}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 6.4031242374328485}, "phml.utilities.misc.heading.heading_rank": {"tf": 5.656854249492381}, "phml.utilities.misc.inspect.inspect": {"tf": 14.628738838327793}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 4}, "phml.utilities.transform.normalize_indent": {"tf": 5.477225575051661}, "phml.utilities.transform.extract.to_string": {"tf": 14.177446878757825}, "phml.utilities.transform.sanitize.sanatize": {"tf": 38.897300677553446}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 14.106735979665885}, "phml.utilities.transform.transform.filter_nodes": {"tf": 17.029386365926403}, "phml.utilities.transform.transform.remove_nodes": {"tf": 17.029386365926403}, "phml.utilities.transform.transform.map_nodes": {"tf": 9.055385138137417}, "phml.utilities.transform.transform.find_and_replace": {"tf": 9.539392014169456}, "phml.utilities.transform.transform.shift_heading": {"tf": 6.164414002968976}, "phml.utilities.transform.transform.replace_node": {"tf": 25.238858928247925}, "phml.utilities.transform.transform.modify_children": {"tf": 3.1622776601683795}, "phml.utilities.travel.travel.path": {"tf": 18.65475810617763}, "phml.utilities.travel.travel.path_names": {"tf": 13.601470508735444}, "phml.utilities.travel.travel.walk": {"tf": 7.3484692283495345}, "phml.utilities.travel.travel.visit_children": {"tf": 7.3484692283495345}, "phml.utilities.travel.travel.visit_all_after": {"tf": 13.416407864998739}, "phml.utilities.validate.check.check": {"tf": 21.908902300206645}, "phml.utilities.validate.validate.validate": {"tf": 13.416407864998739}, "phml.utilities.validate.validate.parent": {"tf": 7.280109889280518}, "phml.utilities.validate.validate.literal": {"tf": 7.280109889280518}, "phml.utilities.validate.validate.generated": {"tf": 13.416407864998739}, "phml.utilities.validate.validate.has_property": {"tf": 4.47213595499958}, "phml.utilities.validate.validate.is_heading": {"tf": 3.4641016151377544}, "phml.utilities.validate.validate.is_css_link": {"tf": 3.4641016151377544}, "phml.utilities.validate.validate.is_css_style": {"tf": 3.4641016151377544}, "phml.utilities.validate.validate.is_javascript": {"tf": 3.4641016151377544}, "phml.utilities.validate.validate.is_element": {"tf": 5.196152422706632}, "phml.utilities.validate.validate.is_embedded": {"tf": 5.656854249492381}, "phml.utilities.validate.validate.is_interactive": {"tf": 5.656854249492381}, "phml.utilities.validate.validate.is_phrasing": {"tf": 5.656854249492381}, "phml.utilities.validate.validate.is_event_handler": {"tf": 4}, "phml.utilities.validate.validate.blank": {"tf": 4}}, "df": 179, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.nodes.nodes.Element.get": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 51}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.builder.p": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.add": {"tf": 2}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.__init__": {"tf": 3}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.7320508075688772}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.add": {"tf": 2}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.render": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.parse_markup": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1.4142135623730951}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1.4142135623730951}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1.4142135623730951}, "phml.core.formats.parse.strip": {"tf": 1.7320508075688772}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element.get": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1.4142135623730951}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.4142135623730951}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.classnames": {"tf": 1.7320508075688772}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tag_from_file": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1.7320508075688772}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}, "phml.utilities.transform.normalize_indent": {"tf": 1.4142135623730951}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 3.1622776601683795}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 115, "i": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.core.PHML.add": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 4}, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 11}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 14, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Element.__init__": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}}, "df": 8}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 2}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}}, "df": 4}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "b": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 4}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "c": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.compile": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.render": {"tf": 2}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.compile": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.render": {"tf": 2}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 2}, "phml.utilities.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 38}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}}, "df": 3}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {"phml.core.formats.json_format.construct_tree": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "d": {"docs": {"phml.utilities.misc.classes.ClassList.replace": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 2}, "phml.core.compiler.Compiler.compile": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.render": {"tf": 2}, "phml.core.core.PHML.__init__": {"tf": 2}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.__init__": {"tf": 2}, "phml.core.core.Compiler.compile": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.render": {"tf": 2}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.get": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 2}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}}, "df": 43, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}}, "df": 16}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path_names": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.validate": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 70, "s": {"docs": {"phml.builder.p": {"tf": 4}, "phml.core.compiler.Compiler.__init__": {"tf": 4.123105625617661}, "phml.core.compiler.Compiler.add": {"tf": 5.830951894845301}, "phml.core.compiler.Compiler.remove": {"tf": 4}, "phml.core.compiler.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 5.830951894845301}, "phml.core.core.PHML.add": {"tf": 4.123105625617661}, "phml.core.core.PHML.remove": {"tf": 4}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 4.123105625617661}, "phml.core.core.Compiler.add": {"tf": 5.830951894845301}, "phml.core.core.Compiler.remove": {"tf": 4}, "phml.core.core.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 2.23606797749979}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 2}, "phml.core.formats.compile.compile.apply_python": {"tf": 2.23606797749979}, "phml.core.formats.compile.compile.py_condition": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_conditions": {"tf": 2}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 2.23606797749979}, "phml.core.formats.compile.component.replace_components": {"tf": 2.23606797749979}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 2}, "phml.core.formats.format.Format.compile": {"tf": 4.242640687119285}, "phml.core.formats.format.Format.render": {"tf": 4.123105625617661}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 4.242640687119285}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 4.123105625617661}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 4.123105625617661}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 4.242640687119285}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 4.123105625617661}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 4.242640687119285}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 4.123105625617661}, "phml.core.nodes.nodes.Element.__init__": {"tf": 2}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 2.449489742783178}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.append": {"tf": 4}, "phml.core.nodes.nodes.Parent.extend": {"tf": 4.123105625617661}, "phml.core.nodes.nodes.Parent.insert": {"tf": 4}, "phml.core.nodes.nodes.Parent.remove": {"tf": 4}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 2.449489742783178}, "phml.core.nodes.nodes.Position.__init__": {"tf": 2}, "phml.utilities.locate.find.ancestor": {"tf": 5.744562646538029}, "phml.utilities.locate.find.find": {"tf": 6.082762530298219}, "phml.utilities.locate.find.find_all": {"tf": 6.082762530298219}, "phml.utilities.locate.find.find_after": {"tf": 6.928203230275509}, "phml.utilities.locate.find.find_all_after": {"tf": 5.830951894845301}, "phml.utilities.locate.find.find_all_before": {"tf": 5.830951894845301}, "phml.utilities.locate.find.find_before": {"tf": 6.928203230275509}, "phml.utilities.locate.find.find_all_between": {"tf": 6.082762530298219}, "phml.utilities.locate.index.Index.__init__": {"tf": 4.58257569495584}, "phml.utilities.locate.index.Index.add": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.remove": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.get": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query": {"tf": 2.6457513110645907}, "phml.utilities.locate.select.query_all": {"tf": 2.6457513110645907}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utilities.misc.size": {"tf": 2}, "phml.utilities.misc.classes.classnames": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.parse_component": {"tf": 1.7320508075688772}, "phml.utilities.misc.heading.heading_rank": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect.inspect": {"tf": 4.123105625617661}, "phml.utilities.transform.extract.to_string": {"tf": 4.123105625617661}, "phml.utilities.transform.sanitize.sanatize": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.filter_nodes": {"tf": 4.58257569495584}, "phml.utilities.transform.transform.remove_nodes": {"tf": 4.58257569495584}, "phml.utilities.transform.transform.map_nodes": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.find_and_replace": {"tf": 2}, "phml.utilities.transform.transform.shift_heading": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 7.280109889280518}, "phml.utilities.travel.travel.path": {"tf": 5.656854249492381}, "phml.utilities.travel.travel.path_names": {"tf": 4}, "phml.utilities.travel.travel.walk": {"tf": 2}, "phml.utilities.travel.travel.visit_children": {"tf": 2}, "phml.utilities.travel.travel.visit_all_after": {"tf": 4}, "phml.utilities.validate.check.check": {"tf": 6}, "phml.utilities.validate.validate.validate": {"tf": 4}, "phml.utilities.validate.validate.parent": {"tf": 2}, "phml.utilities.validate.validate.literal": {"tf": 2}, "phml.utilities.validate.validate.generated": {"tf": 4}, "phml.utilities.validate.validate.is_embedded": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_interactive": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1.4142135623730951}}, "df": 97}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 7, "s": {"docs": {"phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 3}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"phml.utilities.misc.classes.ClassList.replace": {"tf": 1}}, "df": 1}}}, "a": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.add": {"tf": 2}, "phml.core.compiler.Compiler.compile": {"tf": 2.23606797749979}, "phml.core.compiler.Compiler.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.__init__": {"tf": 2}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.__init__": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.add": {"tf": 2}, "phml.core.core.Compiler.compile": {"tf": 2.23606797749979}, "phml.core.core.Compiler.render": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_python": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.7320508075688772}, "phml.core.formats.compile.component.substitute_component": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.replace_components": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 2.23606797749979}, "phml.core.formats.format.Format.render": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.parse_markup": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 2.23606797749979}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.parse_markup": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 2.23606797749979}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 2.23606797749979}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.parse_component": {"tf": 1.7320508075688772}, "phml.utilities.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utilities.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.4142135623730951}}, "df": 42}}, "n": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.get": {"tf": 1.4142135623730951}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 11}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 12}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.nodes.nodes.Element.get": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}}}}}, "b": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "l": {"docs": {"phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 2}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1.4142135623730951}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 2.6457513110645907}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 63}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1.7320508075688772}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.render": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 45}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Point.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 2}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 2.449489742783178}}, "df": 11}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 2}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 2}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 2}, "phml.core.formats.format.Format.render": {"tf": 2}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 2}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 2}, "phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 2}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 57}}, "v": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}}, "df": 1}}}}}}, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 44}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 12}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Element.get": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "f": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "i": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 33}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 18}}, "x": {"docs": {"phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}}, "df": 1}}}}, "o": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}, "m": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 2, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.Import.from_node": {"tf": 1.4142135623730951}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}, "r": {"docs": {}, "df": 0, "c": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 3}}}}}}}, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.builder.p": {"tf": 2.8284271247461903}, "phml.core.compiler.Compiler.__init__": {"tf": 3}, "phml.core.compiler.Compiler.add": {"tf": 4.242640687119285}, "phml.core.compiler.Compiler.remove": {"tf": 2.8284271247461903}, "phml.core.compiler.Compiler.compile": {"tf": 2}, "phml.core.compiler.Compiler.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.__init__": {"tf": 4.242640687119285}, "phml.core.core.PHML.add": {"tf": 3}, "phml.core.core.PHML.remove": {"tf": 2.8284271247461903}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.7320508075688772}, "phml.core.core.PHML.compile": {"tf": 1.7320508075688772}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.__init__": {"tf": 3}, "phml.core.core.Compiler.add": {"tf": 4.242640687119285}, "phml.core.core.Compiler.remove": {"tf": 2.8284271247461903}, "phml.core.core.Compiler.compile": {"tf": 2}, "phml.core.core.Compiler.render": {"tf": 1.7320508075688772}, "phml.core.formats.Formats.__init__": {"tf": 3.1622776601683795}, "phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 2}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.apply_python": {"tf": 2}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 2}, "phml.core.formats.compile.component.replace_components": {"tf": 2}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 3.1622776601683795}, "phml.core.formats.format.Format.render": {"tf": 3}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 3.1622776601683795}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 3}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 3}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 3.1622776601683795}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 3}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 3.1622776601683795}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 3}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Parent.extend": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Parent.insert": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Parent.remove": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1.7320508075688772}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 4}, "phml.utilities.locate.find.find": {"tf": 4.358898943540674}, "phml.utilities.locate.find.find_all": {"tf": 4.358898943540674}, "phml.utilities.locate.find.find_after": {"tf": 4.898979485566356}, "phml.utilities.locate.find.find_all_after": {"tf": 4.123105625617661}, "phml.utilities.locate.find.find_all_before": {"tf": 4.123105625617661}, "phml.utilities.locate.find.find_before": {"tf": 4.898979485566356}, "phml.utilities.locate.find.find_all_between": {"tf": 4.358898943540674}, "phml.utilities.locate.index.Index.__init__": {"tf": 3.3166247903554}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 2}, "phml.utilities.locate.select.query_all": {"tf": 2}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1.4142135623730951}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 3}, "phml.utilities.transform.extract.to_string": {"tf": 3}, "phml.utilities.transform.sanitize.sanatize": {"tf": 2}, "phml.utilities.transform.transform.filter_nodes": {"tf": 3.3166247903554}, "phml.utilities.transform.transform.remove_nodes": {"tf": 3.3166247903554}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 5.0990195135927845}, "phml.utilities.travel.travel.path": {"tf": 4}, "phml.utilities.travel.travel.path_names": {"tf": 2.8284271247461903}, "phml.utilities.travel.travel.walk": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.visit_children": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.visit_all_after": {"tf": 2.8284271247461903}, "phml.utilities.validate.check.check": {"tf": 4.242640687119285}, "phml.utilities.validate.validate.validate": {"tf": 2.8284271247461903}, "phml.utilities.validate.validate.parent": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.literal": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.generated": {"tf": 2.8284271247461903}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 108, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 3}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 47}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.core.core.PHML.__init__": {"tf": 2}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 8, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"phml.core.core.PHML.__init__": {"tf": 2}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 8}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}}, "df": 2}}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_python": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.substitute_component": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.replace_components": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.7320508075688772}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 11}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Root.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.4142135623730951}}, "df": 6}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Position.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.builder.p": {"tf": 2.8284271247461903}, "phml.core.compiler.Compiler.__init__": {"tf": 3}, "phml.core.compiler.Compiler.add": {"tf": 4.242640687119285}, "phml.core.compiler.Compiler.remove": {"tf": 2.8284271247461903}, "phml.core.compiler.Compiler.compile": {"tf": 2}, "phml.core.compiler.Compiler.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.__init__": {"tf": 4.242640687119285}, "phml.core.core.PHML.add": {"tf": 3}, "phml.core.core.PHML.remove": {"tf": 2.8284271247461903}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.7320508075688772}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.__init__": {"tf": 3}, "phml.core.core.Compiler.add": {"tf": 4.242640687119285}, "phml.core.core.Compiler.remove": {"tf": 2.8284271247461903}, "phml.core.core.Compiler.compile": {"tf": 2}, "phml.core.core.Compiler.render": {"tf": 1.7320508075688772}, "phml.core.formats.Formats.__init__": {"tf": 2.8284271247461903}, "phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 2}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.apply_python": {"tf": 2}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 2}, "phml.core.formats.compile.component.replace_components": {"tf": 2}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 3.1622776601683795}, "phml.core.formats.format.Format.render": {"tf": 3}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 3.1622776601683795}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 3}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 3}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 3.1622776601683795}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 3}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 3.1622776601683795}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 3}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Parent.extend": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Parent.insert": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Parent.remove": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 4}, "phml.utilities.locate.find.find": {"tf": 4.358898943540674}, "phml.utilities.locate.find.find_all": {"tf": 4.358898943540674}, "phml.utilities.locate.find.find_after": {"tf": 4.898979485566356}, "phml.utilities.locate.find.find_all_after": {"tf": 4.123105625617661}, "phml.utilities.locate.find.find_all_before": {"tf": 4.123105625617661}, "phml.utilities.locate.find.find_before": {"tf": 4.898979485566356}, "phml.utilities.locate.find.find_all_between": {"tf": 4.358898943540674}, "phml.utilities.locate.index.Index.__init__": {"tf": 3.3166247903554}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 2}, "phml.utilities.locate.select.query_all": {"tf": 2}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1.4142135623730951}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 3}, "phml.utilities.transform.extract.to_string": {"tf": 3}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.filter_nodes": {"tf": 3.3166247903554}, "phml.utilities.transform.transform.remove_nodes": {"tf": 3.3166247903554}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 5.0990195135927845}, "phml.utilities.travel.travel.path": {"tf": 4}, "phml.utilities.travel.travel.path_names": {"tf": 2.8284271247461903}, "phml.utilities.travel.travel.walk": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.visit_children": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.visit_all_after": {"tf": 2.8284271247461903}, "phml.utilities.validate.check.check": {"tf": 4.242640687119285}, "phml.utilities.validate.validate.validate": {"tf": 2.8284271247461903}, "phml.utilities.validate.validate.parent": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.literal": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.generated": {"tf": 2.8284271247461903}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 108}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 44}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 27}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.core.core.PHML.__init__": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 3}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}}, "df": 5}}}, "d": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 14, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Point.__init__": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 2}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 15}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 11}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}}, "df": 19}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 5, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}}, "df": 6}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "x": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.compile.apply_python": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 14}}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.component.valid_component_dict": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 2.449489742783178}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 2}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 62}}, "w": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 1}}}}}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "v": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 2}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 80, "s": {"docs": {"phml.core.formats.compile.component.combine_component_elements": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.format.Format.parse": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}}, "df": 3, "d": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}}, "df": 6}}}}}, "d": {"docs": {"phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 2}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.format.Format.is_format": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.virtual_python.get_python_result": {"tf": 1}}, "df": 1}}}, "m": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 45, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.render": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.get": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}}, "df": 13}}}, "e": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}}, "df": 4}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 9}}}}, "o": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}}, "df": 4}, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 26}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 8}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 2}}}}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 5, "s": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}}, "df": 1}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 2.6457513110645907}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}, "h": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "h": {"1": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "2": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "3": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "4": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "5": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "6": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}}, "df": 17, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}}, "df": 8}}}}}}}}, "t": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 2}}, "df": 1, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 2}}, "df": 1}}}}, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "f": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}}, "df": 9}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "x": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.virtual_python.Import.__init__": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}, "b": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.__init__": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1.4142135623730951}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.get": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 61}}, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML.__init__": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 2}, "phml.core.compiler.Compiler.render": {"tf": 2}, "phml.core.core.PHML.load": {"tf": 1.7320508075688772}, "phml.core.core.PHML.parse": {"tf": 2}, "phml.core.core.PHML.compile": {"tf": 1.7320508075688772}, "phml.core.core.PHML.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.compile": {"tf": 2}, "phml.core.core.Compiler.render": {"tf": 2}, "phml.core.formats.Formats.__init__": {"tf": 3.4641016151377544}, "phml.core.parser.Parser.load": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.parse": {"tf": 2}}, "df": 12, "s": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.render": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.__init__": {"tf": 2.8284271247461903}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1.4142135623730951}}, "df": 12}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 8}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.Schema.__init__": {"tf": 2.449489742783178}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 7, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 1}}}}}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 4}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"phml.utilities.transform.transform.modify_children": {"tf": 1}}, "df": 1}}}}, "x": {"2": {"7": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.render": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.__init__": {"tf": 2.8284271247461903}, "phml.core.parser.Parser.parse": {"tf": 1.4142135623730951}}, "df": 10}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.Formats.__init__": {"tf": 1.4142135623730951}}, "df": 1, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.Formats.__init__": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 2}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 2.449489742783178}}, "df": 11}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}}, "df": 5}, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 5}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_python": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.substitute_component": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.replace_components": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 11, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 9}}}}}}}}}}}}, "p": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 9}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 30}}}}}, "e": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.core.PHML.redact": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}}, "df": 3}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.ClassList.contains": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}}, "df": 3}}}}}}, "b": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.Formats.__init__": {"tf": 1.4142135623730951}}, "df": 1, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.Formats.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}}, "df": 17}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "q": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "w": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.Formats.PHML": {"tf": 1}, "phml.core.formats.Formats.HTML": {"tf": 1}, "phml.core.formats.Formats.JSON": {"tf": 1}, "phml.core.formats.Formats.XML": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 10}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}}, "df": 2}}}}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.Formats.PHML": {"tf": 1}, "phml.core.formats.Formats.HTML": {"tf": 1}, "phml.core.formats.Formats.JSON": {"tf": 1}, "phml.core.formats.Formats.XML": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 10}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.Formats.PHML": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.HTML": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.JSON": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.XML": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1.4142135623730951}, "phml.core.formats.json_format.JSONFormat": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1.4142135623730951}}, "df": 8, "s": {"docs": {"phml.core.formats.Formats.PHML": {"tf": 1}, "phml.core.formats.Formats.HTML": {"tf": 1}, "phml.core.formats.Formats.JSON": {"tf": 1}, "phml.core.formats.Formats.XML": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}}, "df": 8}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.Literal": {"tf": 1}}, "df": 4}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1}}, "df": 2}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}}}, "doc": {"root": {"0": {"docs": {"phml.core.nodes.nodes.Point": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 4}, "1": {"3": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1.7320508075688772}}, "df": 1}, "docs": {"phml": {"tf": 1}, "phml.core.nodes.nodes.Point": {"tf": 1.4142135623730951}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 4}, "2": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 6}, "3": {"9": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.DocType": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Text": {"tf": 2.8284271247461903}, "phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 5}, "docs": {"phml": {"tf": 1.7320508075688772}}, "df": 1}, "4": {"docs": {"phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}}, "df": 3}, "5": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}, "6": {"docs": {"phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 1}, "docs": {"phml": {"tf": 37.14835124201342}, "phml.builder": {"tf": 2.23606797749979}, "phml.builder.p": {"tf": 1.7320508075688772}, "phml.core": {"tf": 1.7320508075688772}, "phml.core.compiler": {"tf": 2.23606797749979}, "phml.core.compiler.Compiler": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.__init__": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.ast": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.add": {"tf": 5.477225575051661}, "phml.core.compiler.Compiler.remove": {"tf": 4.242640687119285}, "phml.core.compiler.Compiler.compile": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.render": {"tf": 1.7320508075688772}, "phml.core.core": {"tf": 1.7320508075688772}, "phml.core.core.PHML": {"tf": 1.7320508075688772}, "phml.core.core.PHML.__init__": {"tf": 1.7320508075688772}, "phml.core.core.PHML.ast": {"tf": 1.7320508075688772}, "phml.core.core.PHML.components": {"tf": 1.7320508075688772}, "phml.core.core.PHML.expose": {"tf": 1.7320508075688772}, "phml.core.core.PHML.redact": {"tf": 1.7320508075688772}, "phml.core.core.PHML.expand": {"tf": 1.7320508075688772}, "phml.core.core.PHML.restrict": {"tf": 1.7320508075688772}, "phml.core.core.PHML.add": {"tf": 5.477225575051661}, "phml.core.core.PHML.remove": {"tf": 2.449489742783178}, "phml.core.core.PHML.load": {"tf": 4}, "phml.core.core.PHML.parse": {"tf": 3.872983346207417}, "phml.core.core.PHML.compile": {"tf": 5.744562646538029}, "phml.core.core.PHML.render": {"tf": 5.830951894845301}, "phml.core.core.PHML.write": {"tf": 7.681145747868608}, "phml.core.core.Compiler": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.__init__": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.ast": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.add": {"tf": 5.477225575051661}, "phml.core.core.Compiler.remove": {"tf": 4.242640687119285}, "phml.core.core.Compiler.compile": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.render": {"tf": 1.7320508075688772}, "phml.core.defaults": {"tf": 1.7320508075688772}, "phml.core.defaults.config": {"tf": 1.7320508075688772}, "phml.core.formats": {"tf": 2.23606797749979}, "phml.core.formats.Formats": {"tf": 1.7320508075688772}, "phml.core.formats.Formats.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.Formats.PHML": {"tf": 1.7320508075688772}, "phml.core.formats.Formats.HTML": {"tf": 1.7320508075688772}, "phml.core.formats.Formats.JSON": {"tf": 1.7320508075688772}, "phml.core.formats.Formats.XML": {"tf": 1.7320508075688772}, "phml.core.formats.compile": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_props": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 5.5677643628300215}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.apply_python": {"tf": 4.47213595499958}, "phml.core.formats.compile.compile.py_condition": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_conditions": {"tf": 4.69041575982343}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 7.3484692283495345}, "phml.core.formats.compile.compile.build_locals": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 2.23606797749979}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 2.23606797749979}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 2.23606797749979}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 5.196152422706632}, "phml.core.formats.compile.component": {"tf": 1.7320508075688772}, "phml.core.formats.compile.component.substitute_component": {"tf": 4.69041575982343}, "phml.core.formats.compile.component.replace_components": {"tf": 4.69041575982343}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 3.3166247903554}, "phml.core.formats.compile.reserved": {"tf": 1.7320508075688772}, "phml.core.formats.format": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format": {"tf": 2.449489742783178}, "phml.core.formats.format.Format.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.extension": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.suffix": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.is_format": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.parse": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.compile": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.render": {"tf": 1.7320508075688772}, "phml.core.formats.html_format": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.parse_markup": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.json_format": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.construct_tree": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.parse": {"tf": 1.7320508075688772}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1.7320508075688772}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1.7320508075688772}, "phml.core.formats.parse.strip": {"tf": 1.7320508075688772}, "phml.core.formats.parse.RE": {"tf": 1.7320508075688772}, "phml.core.formats.parse.RE.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.parse.RE.tag_start": {"tf": 2.23606797749979}, "phml.core.formats.parse.RE.tag_end": {"tf": 2.8284271247461903}, "phml.core.formats.parse.RE.comment": {"tf": 2.8284271247461903}, "phml.core.formats.parse.RE.attribute": {"tf": 2.449489742783178}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1.7320508075688772}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1.7320508075688772}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1.7320508075688772}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 4.898979485566356}, "phml.core.formats.phml_format": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.parse_markup": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.nodes": {"tf": 2.23606797749979}, "phml.core.nodes.AST": {"tf": 2.449489742783178}, "phml.core.nodes.AST.AST": {"tf": 2.449489742783178}, "phml.core.nodes.AST.AST.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.AST.AST.size": {"tf": 1.7320508075688772}, "phml.core.nodes.AST.AST.children": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element": {"tf": 14.422205101855956}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element.get": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 5}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 3.4641016151377544}, "phml.core.nodes.nodes.Root": {"tf": 2.449489742783178}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node.position": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node.type": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.DocType": {"tf": 7}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 3.3166247903554}, "phml.core.nodes.nodes.Parent": {"tf": 2.449489742783178}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.append": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.PI": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Comment": {"tf": 4.58257569495584}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 3.3166247903554}, "phml.core.nodes.nodes.Literal": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Literal.position": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Literal.value": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Point": {"tf": 2.449489742783178}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position": {"tf": 5.477225575051661}, "phml.core.nodes.nodes.Position.__init__": {"tf": 5}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Text": {"tf": 12}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1.7320508075688772}, "phml.core.nodes.types": {"tf": 1.4142135623730951}, "phml.core.nodes.types.Properties": {"tf": 2.449489742783178}, "phml.core.parser": {"tf": 2.8284271247461903}, "phml.core.parser.Parser": {"tf": 3}, "phml.core.parser.Parser.__init__": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.ast": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.load": {"tf": 5}, "phml.core.parser.Parser.parse": {"tf": 6.4031242374328485}, "phml.core.virtual_python": {"tf": 12.12435565298214}, "phml.core.virtual_python.VirtualPython": {"tf": 1.7320508075688772}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1.7320508075688772}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.7320508075688772}, "phml.core.virtual_python.get_python_result": {"tf": 2.449489742783178}, "phml.core.virtual_python.process_python_blocks": {"tf": 6}, "phml.core.virtual_python.Import": {"tf": 1.7320508075688772}, "phml.core.virtual_python.Import.__init__": {"tf": 1.7320508075688772}, "phml.core.virtual_python.Import.from_node": {"tf": 4.795831523312719}, "phml.core.virtual_python.ImportFrom": {"tf": 1.7320508075688772}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1.7320508075688772}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 4.795831523312719}, "phml.types": {"tf": 1.7320508075688772}, "phml.utilities": {"tf": 2.23606797749979}, "phml.utilities.locate": {"tf": 2.23606797749979}, "phml.utilities.locate.find": {"tf": 2.23606797749979}, "phml.utilities.locate.find.ancestor": {"tf": 5.291502622129181}, "phml.utilities.locate.find.find": {"tf": 5.830951894845301}, "phml.utilities.locate.find.find_all": {"tf": 5.5677643628300215}, "phml.utilities.locate.find.find_after": {"tf": 5.477225575051661}, "phml.utilities.locate.find.find_all_after": {"tf": 5.477225575051661}, "phml.utilities.locate.find.find_all_before": {"tf": 5.477225575051661}, "phml.utilities.locate.find.find_before": {"tf": 5.477225575051661}, "phml.utilities.locate.find.find_all_between": {"tf": 7.211102550927978}, "phml.utilities.locate.index": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index": {"tf": 2.449489742783178}, "phml.utilities.locate.index.Index.__init__": {"tf": 6.082762530298219}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.items": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.values": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.keys": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.add": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.remove": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.get": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1.7320508075688772}, "phml.utilities.locate.select": {"tf": 2.23606797749979}, "phml.utilities.locate.select.query": {"tf": 9.643650760992955}, "phml.utilities.locate.select.query_all": {"tf": 9.643650760992955}, "phml.utilities.locate.select.matches": {"tf": 8.246211251235321}, "phml.utilities.locate.select.parse_specifiers": {"tf": 8.18535277187245}, "phml.utilities.misc": {"tf": 2.23606797749979}, "phml.utilities.misc.depth": {"tf": 2.6457513110645907}, "phml.utilities.misc.size": {"tf": 1.7320508075688772}, "phml.utilities.misc.offset": {"tf": 1.7320508075688772}, "phml.utilities.misc.classes": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.classnames": {"tf": 9.219544457292887}, "phml.utilities.misc.classes.ClassList": {"tf": 2.6457513110645907}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1.7320508075688772}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.ClassList.add": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1.7320508075688772}, "phml.utilities.misc.component": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.tokanize_name": {"tf": 6.244997998398398}, "phml.utilities.misc.component.tag_from_file": {"tf": 3.4641016151377544}, "phml.utilities.misc.component.filename_from_path": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.parse_component": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 4.358898943540674}, "phml.utilities.misc.heading": {"tf": 1.7320508075688772}, "phml.utilities.misc.heading.heading_rank": {"tf": 3.872983346207417}, "phml.utilities.misc.inspect": {"tf": 2.23606797749979}, "phml.utilities.misc.inspect.inspect": {"tf": 1.7320508075688772}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 7.937253933193772}, "phml.utilities.transform": {"tf": 2.23606797749979}, "phml.utilities.transform.normalize_indent": {"tf": 5.291502622129181}, "phml.utilities.transform.extract": {"tf": 1.7320508075688772}, "phml.utilities.transform.extract.to_string": {"tf": 5}, "phml.utilities.transform.sanitize": {"tf": 2.23606797749979}, "phml.utilities.transform.sanitize.sanatize": {"tf": 6.855654600401044}, "phml.utilities.transform.sanitize.Schema": {"tf": 4.795831523312719}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.filter_nodes": {"tf": 5.830951894845301}, "phml.utilities.transform.transform.remove_nodes": {"tf": 5}, "phml.utilities.transform.transform.map_nodes": {"tf": 10.816653826391969}, "phml.utilities.transform.transform.find_and_replace": {"tf": 2.8284271247461903}, "phml.utilities.transform.transform.shift_heading": {"tf": 2.449489742783178}, "phml.utilities.transform.transform.replace_node": {"tf": 5.477225575051661}, "phml.utilities.transform.transform.modify_children": {"tf": 2.23606797749979}, "phml.utilities.travel": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel": {"tf": 2.23606797749979}, "phml.utilities.travel.travel.path": {"tf": 5.196152422706632}, "phml.utilities.travel.travel.path_names": {"tf": 5.196152422706632}, "phml.utilities.travel.travel.walk": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.visit_children": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1.7320508075688772}, "phml.utilities.validate": {"tf": 2.23606797749979}, "phml.utilities.validate.check": {"tf": 2.23606797749979}, "phml.utilities.validate.check.check": {"tf": 9.539392014169456}, "phml.utilities.validate.validate": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.validate": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.parent": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.literal": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.generated": {"tf": 4.898979485566356}, "phml.utilities.validate.validate.has_property": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_heading": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_css_link": {"tf": 5.5677643628300215}, "phml.utilities.validate.validate.is_css_style": {"tf": 5.0990195135927845}, "phml.utilities.validate.validate.is_javascript": {"tf": 4.69041575982343}, "phml.utilities.validate.validate.is_element": {"tf": 2.449489742783178}, "phml.utilities.validate.validate.is_embedded": {"tf": 6.082762530298219}, "phml.utilities.validate.validate.is_interactive": {"tf": 5.656854249492381}, "phml.utilities.validate.validate.is_phrasing": {"tf": 5.656854249492381}, "phml.utilities.validate.validate.is_event_handler": {"tf": 2.6457513110645907}, "phml.utilities.validate.validate.blank": {"tf": 4.795831523312719}}, "df": 282, "p": {"docs": {"phml": {"tf": 4.898979485566356}, "phml.core.virtual_python": {"tf": 2.8284271247461903}}, "df": 2, "y": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 2}}, "df": 1, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 6.6332495807108}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_python": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.substitute_component": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.7320508075688772}, "phml.core.virtual_python": {"tf": 3.7416573867739413}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 2}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1.4142135623730951}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1.4142135623730951}}, "df": 24, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.core.formats.parse": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 6.928203230275509}, "phml.builder": {"tf": 1}, "phml.builder.p": {"tf": 1}, "phml.core.compiler": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.core.Compiler": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.ast": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.formats": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 2}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.parser": {"tf": 1.7320508075688772}, "phml.core.parser.Parser": {"tf": 2}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.parse": {"tf": 1.7320508075688772}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.utilities": {"tf": 1.4142135623730951}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 51, "s": {"docs": {"phml.core.parser": {"tf": 1}}, "df": 1}, "/": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.parser.Parser.parse": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 2}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}}, "df": 10, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 3}, "s": {"docs": {"phml.core.parser.Parser": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.compile.compile": {"tf": 1}, "phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 6}}}, "/": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}, "d": {"docs": {"phml.core.core.PHML.write": {"tf": 1}, "phml.core.nodes.nodes.Element.get": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 6}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}}, "df": 1, "s": {"docs": {"phml": {"tf": 2.449489742783178}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_props": {"tf": 1}}, "df": 3}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 2}, "phml.core.nodes.nodes.Text": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}}, "df": 5}}}, "y": {"docs": {"phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.has_property": {"tf": 1}}, "df": 3, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}}}}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Node": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.Schema": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.transform.sanitize.Schema": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {"phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.inspect.normalize_indent": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 2}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 7}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 2}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 5}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.core.PHML.restrict": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.write": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.format.Format.suffix": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}}, "df": 2}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.parser.Parser": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.find.find_before": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.formats": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 2}, "phml.utilities.misc.component.parse_component": {"tf": 1}}, "df": 23, "r": {"docs": {"phml": {"tf": 2}, "phml.core.core.PHML": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.parser": {"tf": 1.7320508075688772}, "phml.core.parser.Parser": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}}, "df": 7}, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}, "d": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 2}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 12}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.formats.Formats.PHML": {"tf": 1}, "phml.core.formats.Formats.HTML": {"tf": 1}, "phml.core.formats.Formats.JSON": {"tf": 1}, "phml.core.formats.Formats.XML": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.parser": {"tf": 1.7320508075688772}}, "df": 12}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 2}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 2}, "phml.utilities.validate.validate.parent": {"tf": 1}}, "df": 19, "s": {"docs": {"phml.utilities.transform.transform.modify_children": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml": {"tf": 2}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.load": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.load": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 11, "/": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "s": {"docs": {"phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}}, "df": 3}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"phml.core.core.PHML.add": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 5, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 14}, "s": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 4}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 6}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}}, "df": 1, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position": {"tf": 2}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1.7320508075688772}}, "df": 10, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 2}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 5}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.parser.Parser.load": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Point": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1.4142135623730951}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 5, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}}, "df": 6, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2}}}}}}}, "h": {"2": {"docs": {"phml.utilities.misc.heading.heading_rank": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}}, "df": 3}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.parser.Parser": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1}}, "df": 3}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"phml.utilities.misc.classes.ClassList": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}}}}}, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 3.7416573867739413}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.core.Compiler": {"tf": 1}, "phml.core.formats.Formats.PHML": {"tf": 1}, "phml.core.formats.Formats.HTML": {"tf": 1}, "phml.core.formats.Formats.JSON": {"tf": 1}, "phml.core.formats.Formats.XML": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1.7320508075688772}, "phml.core.parser": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 26, "/": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.parser.Parser.parse": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 2}, "phml.core.core.PHML.compile": {"tf": 1.7320508075688772}, "phml.core.core.PHML.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1.7320508075688772}, "phml.core.nodes.AST": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1.7320508075688772}}, "df": 14, "t": {"docs": {"phml.core.nodes.nodes.Parent": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 5}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.449489742783178}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 7}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.parser.Parser": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.parser": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {"phml": {"tf": 3}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}}, "df": 3}}, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}, "phml.utilities.misc": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}}, "df": 5}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2}, "phml.core.nodes.types": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 3}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.compiler": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}}, "df": 4}}}}}, "p": {"docs": {"phml.utilities.travel.travel": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 3}}}, ":": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1.4142135623730951}}, "df": 1, "u": {"docs": {}, "df": 0, "p": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}}, "df": 6}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 3}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.core.Compiler": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 4, "/": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 4}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.builder": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}}, "df": 3}}, "y": {"docs": {"phml": {"tf": 2}, "phml.core.parser.Parser": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 5}, "n": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}}, "df": 4}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}}, "df": 3}}}}}}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 9, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.core.PHML.remove": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 2.6457513110645907}, "phml.utilities.locate.select.query_all": {"tf": 2.6457513110645907}, "phml.utilities.locate.select.matches": {"tf": 2.6457513110645907}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 10}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}, "h": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}}, "df": 9}}, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}}, "df": 3}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.index.Index": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 7}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.builder": {"tf": 1}, "phml.core.compiler": {"tf": 1}, "phml.core.parser": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}}, "df": 4}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 3.7416573867739413}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}}, "df": 4}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}}, "df": 5}}}}, "a": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {"phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}}, "df": 3}}}, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}, "y": {"docs": {"phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.8284271247461903}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}}, "df": 5}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}}, "df": 3}}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {"phml": {"tf": 3.1622776601683795}, "phml.utilities.locate.select.query": {"tf": 2.23606797749979}, "phml.utilities.locate.select.query_all": {"tf": 2.23606797749979}, "phml.utilities.locate.select.matches": {"tf": 2.23606797749979}}, "df": 4, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 3.3166247903554}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.7320508075688772}}, "df": 4, "s": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.nodes.nodes.Point": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 7, "s": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 8}}, "k": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_css_link": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 2, "[": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.compiler": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 2.23606797749979}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1.4142135623730951}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1.4142135623730951}}, "df": 31, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 2.23606797749979}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 4}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}}, "df": 6}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.select.query_all": {"tf": 1}}, "df": 1}}}}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Parent": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}}, "df": 6}}}}}, "#": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.7320508075688772}}, "df": 1, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}}, "df": 1, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1.4142135623730951}}, "df": 5}}}}, "f": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}, "n": {"docs": {"phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {"phml": {"tf": 2}}, "df": 1, "s": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}, "p": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml": {"tf": 1}, "phml.core.formats.Formats.PHML": {"tf": 1}, "phml.core.formats.Formats.HTML": {"tf": 1}, "phml.core.formats.Formats.JSON": {"tf": 1}, "phml.core.formats.Formats.XML": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}}, "df": 17}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.core.core.PHML.load": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.core.PHML": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.7320508075688772}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 5, "s": {"docs": {"phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}}, "df": 4}, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 3}}}, "e": {"docs": {"phml.utilities.locate.find": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {"phml": {"tf": 9.643650760992955}, "phml.core.formats.parse.RE.tag_start": {"tf": 1.7320508075688772}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 3.3166247903554}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}}, "df": 11}}, "t": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}}, "df": 4, "o": {"docs": {"phml": {"tf": 7.483314773547883}, "phml.builder": {"tf": 1}, "phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 2}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expose": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expand": {"tf": 1.4142135623730951}, "phml.core.core.PHML.restrict": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 2.23606797749979}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1.4142135623730951}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 2.23606797749979}, "phml.core.core.PHML.write": {"tf": 3.872983346207417}, "phml.core.core.Compiler": {"tf": 1}, "phml.core.core.Compiler.ast": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 2}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 2}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes": {"tf": 1}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.parser.Parser": {"tf": 2.449489742783178}, "phml.core.parser.Parser.load": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 2.23606797749979}, "phml.core.virtual_python": {"tf": 2.23606797749979}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.7320508075688772}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 3.1622776601683795}, "phml.utilities.locate.index.Index.__init__": {"tf": 2.8284271247461903}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1.7320508075688772}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1.7320508075688772}, "phml.utilities.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.map_nodes": {"tf": 2}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.modify_children": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path": {"tf": 2}, "phml.utilities.travel.travel.path_names": {"tf": 2}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.validate": {"tf": 1.4142135623730951}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 2.23606797749979}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1.4142135623730951}}, "df": 97, "c": {"docs": {"phml": {"tf": 1}}, "df": 1}, "o": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 2, "l": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "p": {"docs": {"phml": {"tf": 2.23606797749979}}, "df": 1}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}}, "df": 1, "d": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}}, "df": 1}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1.7320508075688772}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 11.090536506409418}, "phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 4.69041575982343}, "phml.core.compiler.Compiler.remove": {"tf": 1.7320508075688772}, "phml.core.core.PHML": {"tf": 1.7320508075688772}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.PHML.components": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 5.196152422706632}, "phml.core.core.PHML.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.load": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 2.8284271247461903}, "phml.core.core.PHML.render": {"tf": 2.6457513110645907}, "phml.core.core.PHML.write": {"tf": 4.123105625617661}, "phml.core.core.Compiler.ast": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 4.69041575982343}, "phml.core.core.Compiler.remove": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 2}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 2}, "phml.core.formats.compile.compile.process_conditions": {"tf": 2}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 2.6457513110645907}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.substitute_component": {"tf": 1.7320508075688772}, "phml.core.formats.compile.component.replace_components": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 2.23606797749979}, "phml.core.formats.format.Format.suffix": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 2.23606797749979}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 2.23606797749979}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1.4142135623730951}, "phml.core.formats.parse.strip": {"tf": 1.7320508075688772}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 2.23606797749979}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 2.23606797749979}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.AST": {"tf": 2.23606797749979}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 3.7416573867739413}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node.position": {"tf": 2.23606797749979}, "phml.core.nodes.nodes.Node.type": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.append": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.position": {"tf": 2.23606797749979}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Point": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position": {"tf": 4.358898943540674}, "phml.core.nodes.nodes.Position.__init__": {"tf": 2.23606797749979}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1.4142135623730951}, "phml.core.parser": {"tf": 1}, "phml.core.parser.Parser": {"tf": 3}, "phml.core.parser.Parser.ast": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.load": {"tf": 2.23606797749979}, "phml.core.parser.Parser.parse": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 2.8284271247461903}, "phml.core.virtual_python.VirtualPython": {"tf": 1.4142135623730951}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.7320508075688772}, "phml.core.virtual_python.get_python_result": {"tf": 2.23606797749979}, "phml.core.virtual_python.process_python_blocks": {"tf": 2.23606797749979}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 2.23606797749979}, "phml.utilities.locate.find.find": {"tf": 2.23606797749979}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 2}, "phml.utilities.locate.find.find_all_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_before": {"tf": 2}, "phml.utilities.locate.find.find_before": {"tf": 2.8284271247461903}, "phml.utilities.locate.find.find_all_between": {"tf": 2.23606797749979}, "phml.utilities.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 2}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.keys": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1.7320508075688772}, "phml.utilities.locate.select.query": {"tf": 4}, "phml.utilities.locate.select.query_all": {"tf": 4}, "phml.utilities.locate.select.matches": {"tf": 3.7416573867739413}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 2}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1.7320508075688772}, "phml.utilities.misc.classes.classnames": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.ClassList": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 2.23606797749979}, "phml.utilities.transform.extract.to_string": {"tf": 2}, "phml.utilities.transform.sanitize.sanatize": {"tf": 2.6457513110645907}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 2.8284271247461903}, "phml.utilities.transform.transform.remove_nodes": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.map_nodes": {"tf": 2}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.shift_heading": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.modify_children": {"tf": 2.8284271247461903}, "phml.utilities.travel.travel.path": {"tf": 2.23606797749979}, "phml.utilities.travel.travel.path_names": {"tf": 2.23606797749979}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 4.123105625617661}, "phml.utilities.validate.validate.is_element": {"tf": 2}, "phml.utilities.validate.validate.is_interactive": {"tf": 2.6457513110645907}, "phml.utilities.validate.validate.is_phrasing": {"tf": 2.449489742783178}, "phml.utilities.validate.validate.blank": {"tf": 1.4142135623730951}}, "df": 153, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 3.3166247903554}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}}, "df": 7}}, "y": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 6}, "m": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}}, "df": 6, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.parser.Parser": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.parser.Parser": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 3}}, "n": {"docs": {"phml": {"tf": 3.1622776601683795}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes.nodes.Element.get": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1.4142135623730951}}, "df": 17}, "i": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 4.898979485566356}, "phml.builder": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 20}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 3.872983346207417}, "phml.core.compiler": {"tf": 1}, "phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.nodes.AST": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1.4142135623730951}}, "df": 49}, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"phml": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}}, "df": 3}}}}}}, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.format.Format": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}}, "df": 5, "s": {"docs": {"phml": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 9}}}, "g": {"docs": {"phml": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tag_from_file": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 18, "s": {"docs": {"phml": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}}, "df": 4}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 2.23606797749979}, "phml.core.nodes.nodes.Text": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 2}}}}, "e": {"docs": {"phml.core.formats.compile.compile.process_conditions": {"tf": 1.7320508075688772}, "phml.core.nodes.AST": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 2.23606797749979}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 2}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 2}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 17}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 14}}, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"phml.core.parser.Parser": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.7320508075688772}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}}, "df": 3}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.apply_python": {"tf": 1}}, "df": 1, "e": {"docs": {"phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 4}, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.travel.travel": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {"phml.utilities.travel.travel": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.classes": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}}, "df": 2}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 2.449489742783178}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Text": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 2}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 2.23606797749979}}, "df": 8, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}}}}}}}, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 2}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.formats.compile.component.replace_components": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 3}}, "df": 12, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.classes": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.validate.check": {"tf": 1}}, "df": 1}}, "s": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 5, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1.4142135623730951}, "phml.core.nodes.types": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_css_style": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_javascript": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 24, "s": {"docs": {"phml": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 7}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 4, "s": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {"phml.utilities.locate.find.ancestor": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.nodes.AST": {"tf": 1}}, "df": 1, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {"phml": {"tf": 5.196152422706632}, "phml.core.compiler.Compiler.add": {"tf": 2.8284271247461903}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 3}, "phml.core.core.PHML.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 2.8284271247461903}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats": {"tf": 1}, "phml.core.formats.Formats": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 2.23606797749979}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 3}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.core.nodes.types": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.7320508075688772}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.locate": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 2}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 2}, "phml.utilities.travel.travel.path_names": {"tf": 2}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1.7320508075688772}}, "df": 89, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Point": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 4}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.core.Compiler": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1.4142135623730951}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate": {"tf": 1}}, "df": 10, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 2}}}}}}}}, "n": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 19, "e": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Point": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 12, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 2.449489742783178}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 10}}}, "r": {"docs": {"phml": {"tf": 4.123105625617661}, "phml.core.compiler.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.7320508075688772}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.core.formats": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.7320508075688772}, "phml.utilities.locate.select.query_all": {"tf": 1.7320508075688772}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 55, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}}}}}, "g": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "#": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1}}, "df": 2, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.utilities.misc.inspect": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1.7320508075688772}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 10, "s": {"docs": {"phml.core.core.PHML.remove": {"tf": 1}, "phml.core.nodes": {"tf": 1}}, "df": 2}}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 2}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}}, "df": 6, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "[": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 4}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}}, "df": 4}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}}, "df": 2}}, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Element.start_tag": {"tf": 1}}, "df": 1}}}}}}}}}, "w": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 1}}}, "u": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 3}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 11, "d": {"docs": {"phml": {"tf": 3.1622776601683795}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler": {"tf": 1}, "phml.core.core.Compiler.ast": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 24}, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 3}, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 2}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 2}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 3}}}}, "r": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 2.449489742783178}}, "df": 1}}, "p": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 4}, "l": {"docs": {"phml": {"tf": 2}}, "df": 1}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}, "k": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.parser.Parser.load": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Parent": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.nodes.nodes.Literal": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.parser.Parser": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1.4142135623730951}}, "df": 2, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.builder": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.locate": {"tf": 1.4142135623730951}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1.4142135623730951}, "phml.utilities.misc": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.transform": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1.4142135623730951}, "phml.utilities.validate": {"tf": 1.4142135623730951}, "phml.utilities.validate.check": {"tf": 1}}, "df": 17}}}, "y": {"docs": {"phml.builder": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform": {"tf": 1}}, "df": 8}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.AST": {"tf": 1}}, "df": 1}}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 8, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.7320508075688772}}, "df": 7}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}}, "df": 3, "s": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 5}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Node.type": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.449489742783178}, "phml.core.compiler.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.get": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 3.605551275463989}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 2.23606797749979}}, "df": 31, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1.4142135623730951}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 15}, "|": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_javascript": {"tf": 1.4142135623730951}}, "df": 4, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}}, "df": 7}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.validate": {"tf": 1}}, "df": 2}}}}}, "/": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.locate.index.Index.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 1, "o": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.utilities.misc.heading": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 7, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.DocType": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "n": {"docs": {"phml": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes": {"tf": 1}}, "df": 3}, "m": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1}}, "df": 4, "s": {"docs": {"phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 1}}, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 3, "n": {"docs": {"phml.utilities.misc": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 5}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 1}}}}}}}}}, "v": {"docs": {"phml": {"tf": 2.449489742783178}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}}, "df": 3, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.formats": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 10, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}}, "df": 7}}}}}}, "s": {"docs": {"phml.core.core.PHML": {"tf": 1}}, "df": 1}, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.Schema": {"tf": 1.7320508075688772}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.core.Compiler.compile": {"tf": 1}, "phml.core.core.Compiler.render": {"tf": 1}, "phml.utilities.misc": {"tf": 1}}, "df": 9}}}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.7320508075688772}}, "df": 1, "d": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 2}, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.nodes.nodes.Element.get": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 7, "s": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 2}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}}, "df": 7}}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 4}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}}, "df": 3}}}, "l": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}}, "df": 3, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.nodes": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 2.449489742783178}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 20, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.Schema": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.virtual_python": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.core.formats.compile.compile": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}}}}, "f": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml": {"tf": 2.6457513110645907}, "phml.builder": {"tf": 1}, "phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.formats": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 18, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 8}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "o": {"docs": {"phml": {"tf": 2.449489742783178}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 3, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.select.query": {"tf": 2}, "phml.utilities.locate.select.query_all": {"tf": 2}, "phml.utilities.locate.select.matches": {"tf": 2}, "phml.utilities.misc.component.tokanize_name": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tag_from_file": {"tf": 1.4142135623730951}}, "df": 5, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.utilities.misc.heading": {"tf": 1}}, "df": 2}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tag_from_file": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1.4142135623730951}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Point": {"tf": 2}, "phml.core.nodes.nodes.Position": {"tf": 2.23606797749979}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 13}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}, "g": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 4.358898943540674}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2, "s": {"docs": {"phml": {"tf": 2}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 2}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 16, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 11}}}, "s": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}}, "df": 3}}}}}, "y": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 2}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}}, "df": 1}}}, "r": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1.7320508075688772}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.classnames": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1.4142135623730951}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 27, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 2}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}}, "df": 31, "/": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.parser": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 6}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}, "p": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}}, "df": 1}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"phml": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_css_link": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}, "d": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.components": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml": {"tf": 1.7320508075688772}}, "df": 1}}, "p": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}}, "df": 2}}}}}}}, "b": {"docs": {"phml.core.formats.format.Format": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.core.core.PHML.write": {"tf": 2}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.builder": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.check": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"phml": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}}, "df": 3}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.select": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.classes": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 4}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}}, "df": 3, "n": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 4, "d": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}, "s": {"docs": {"phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 3}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 2.449489742783178}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.core.nodes.nodes.Node": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}}, "df": 8}, "p": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 2}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}}, "df": 3, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.sanitize": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 3, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1}}}}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 5, "s": {"docs": {"phml": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}}, "df": 5}}}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.AST": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "c": {"docs": {"phml": {"tf": 2.23606797749979}}, "df": 1}}, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"phml.core.nodes.nodes.Node": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}}, "df": 3, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.core.core.PHML.compile": {"tf": 2}, "phml.core.core.PHML.render": {"tf": 2}, "phml.core.core.PHML.write": {"tf": 2}}, "df": 3}}}, "n": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3}}, "e": {"docs": {}, "df": 0, "c": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.core.nodes.nodes.Element.get": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1}, "phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 8}, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"phml.utilities.locate.select.query": {"tf": 1.7320508075688772}, "phml.utilities.locate.select.query_all": {"tf": 1.7320508075688772}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 3}}, "d": {"docs": {"phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 1}}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.index.Index.__init__": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3, "o": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}}}, "d": {"docs": {"phml.utilities.locate.select.query": {"tf": 2}, "phml.utilities.locate.select.query_all": {"tf": 2}, "phml.utilities.locate.select.matches": {"tf": 2}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "a": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "n": {"docs": {"phml": {"tf": 6.164414002968976}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.components": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.Compiler.add": {"tf": 1}, "phml.core.core.Compiler.remove": {"tf": 1}, "phml.core.formats.Formats": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Point": {"tf": 2}, "phml.core.nodes.nodes.Position": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 2.23606797749979}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.locate": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 56, "s": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.inspect": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect.inspect": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2}, "phml.core.parser.Parser": {"tf": 1}, "phml.utilities": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 3, "/": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "t": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 4, "o": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.core