# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List, Any


class AddVpcHoneyPotRequest(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        vpc_switch_id: str = None,
    ):
        self.vpc_id = vpc_id
        self.vpc_switch_id = vpc_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_switch_id is not None:
            result['VpcSwitchId'] = self.vpc_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcSwitchId') is not None:
            self.vpc_switch_id = m.get('VpcSwitchId')
        return self


class AddVpcHoneyPotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddVpcHoneyPotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddVpcHoneyPotResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddVpcHoneyPotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckQuaraFileIdRequest(TeaModel):
    def __init__(
        self,
        uuid: str = None,
        quara_file_ids: List[str] = None,
    ):
        self.uuid = uuid
        self.quara_file_ids = quara_file_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.quara_file_ids is not None:
            result['QuaraFileIds'] = self.quara_file_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('QuaraFileIds') is not None:
            self.quara_file_ids = m.get('QuaraFileIds')
        return self


class CheckQuaraFileIdResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckQuaraFileIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckQuaraFileIdResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckQuaraFileIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckSecurityEventIdRequest(TeaModel):
    def __init__(
        self,
        uuid: str = None,
        security_event_ids: List[str] = None,
    ):
        self.uuid = uuid
        self.security_event_ids = security_event_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        return self


class CheckSecurityEventIdResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckSecurityEventIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckSecurityEventIdResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckSecurityEventIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAntiBruteForceRuleRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        name: str = None,
        span: int = None,
        fail_count: int = None,
        forbidden_time: int = None,
        default_rule: bool = None,
        uuid_list: List[str] = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.name = name
        self.span = span
        self.fail_count = fail_count
        self.forbidden_time = forbidden_time
        self.default_rule = default_rule
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.name is not None:
            result['Name'] = self.name
        if self.span is not None:
            result['Span'] = self.span
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
    ):
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateAntiBruteForceRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        create_anti_brute_force_rule: CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule = None,
    ):
        self.request_id = request_id
        self.create_anti_brute_force_rule = create_anti_brute_force_rule

    def validate(self):
        if self.create_anti_brute_force_rule:
            self.create_anti_brute_force_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.create_anti_brute_force_rule is not None:
            result['CreateAntiBruteForceRule'] = self.create_anti_brute_force_rule.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CreateAntiBruteForceRule') is not None:
            temp_model = CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule()
            self.create_anti_brute_force_rule = temp_model.from_map(m['CreateAntiBruteForceRule'])
        return self


class CreateAntiBruteForceRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateAntiBruteForceRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateAntiBruteForceRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAssetRequest(TeaModel):
    def __init__(
        self,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        os: str = None,
        status: str = None,
        os_name: str = None,
    ):
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.os = os
        self.status = status
        self.os_name = os_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.os is not None:
            result['Os'] = self.os
        if self.status is not None:
            result['Status'] = self.status
        if self.os_name is not None:
            result['OsName'] = self.os_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        return self


class CreateAssetResponseBody(TeaModel):
    def __init__(
        self,
        uuid: str = None,
        request_id: str = None,
    ):
        self.uuid = uuid
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAssetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateAssetResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateAssetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        name: str = None,
        policy: Dict[str, Any] = None,
        policy_version: str = None,
        policy_region_id: str = None,
        uuid_list: List[str] = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.name = name
        self.policy = policy
        self.policy_version = policy_version
        self.policy_region_id = policy_region_id
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateBackupPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        name: str = None,
        policy_shrink: str = None,
        policy_version: str = None,
        policy_region_id: str = None,
        uuid_list: List[str] = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.name = name
        self.policy_shrink = policy_shrink
        self.policy_version = policy_version
        self.policy_region_id = policy_region_id
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_shrink is not None:
            result['Policy'] = self.policy_shrink
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy_shrink = m.get('Policy')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateAssetGroupRequest(TeaModel):
    def __init__(
        self,
        uuids: str = None,
        group_name: str = None,
        group_id: int = None,
    ):
        self.uuids = uuids
        self.group_name = group_name
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class CreateOrUpdateAssetGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        request_id: str = None,
    ):
        self.group_id = group_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateAssetGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOrUpdateAssetGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateAssetGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRestoreJobRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        uuid: str = None,
        snapshot_id: str = None,
        snapshot_hash: str = None,
        target: str = None,
        source_type: str = None,
        vault_id: str = None,
        snapshot_version: str = None,
        includes: str = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.uuid = uuid
        self.snapshot_id = snapshot_id
        self.snapshot_hash = snapshot_hash
        self.target = target
        self.source_type = source_type
        self.vault_id = vault_id
        self.snapshot_version = snapshot_version
        self.includes = includes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.snapshot_hash is not None:
            result['SnapshotHash'] = self.snapshot_hash
        if self.target is not None:
            result['Target'] = self.target
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.vault_id is not None:
            result['VaultId'] = self.vault_id
        if self.snapshot_version is not None:
            result['SnapshotVersion'] = self.snapshot_version
        if self.includes is not None:
            result['Includes'] = self.includes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('SnapshotHash') is not None:
            self.snapshot_hash = m.get('SnapshotHash')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('VaultId') is not None:
            self.vault_id = m.get('VaultId')
        if m.get('SnapshotVersion') is not None:
            self.snapshot_version = m.get('SnapshotVersion')
        if m.get('Includes') is not None:
            self.includes = m.get('Includes')
        return self


class CreateRestoreJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRestoreJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRestoreJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRestoreJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSasOrderRequest(TeaModel):
    def __init__(
        self,
        period: int = None,
        period_unit: str = None,
        auto_renew_period: int = None,
        auto_pay: bool = None,
        auto_use_coupon: bool = None,
        spec: str = None,
        instance_count: str = None,
        sas_sls_storage: str = None,
        sas_anti_ransomware: str = None,
        sas_webguard_boolean: str = None,
        sas_sc: str = None,
        sas_product_service: str = None,
        sas_webguard_order_num: str = None,
        vcore: str = None,
        container_image_scan: str = None,
    ):
        self.period = period
        self.period_unit = period_unit
        self.auto_renew_period = auto_renew_period
        self.auto_pay = auto_pay
        self.auto_use_coupon = auto_use_coupon
        self.spec = spec
        self.instance_count = instance_count
        self.sas_sls_storage = sas_sls_storage
        self.sas_anti_ransomware = sas_anti_ransomware
        self.sas_webguard_boolean = sas_webguard_boolean
        self.sas_sc = sas_sc
        self.sas_product_service = sas_product_service
        self.sas_webguard_order_num = sas_webguard_order_num
        self.vcore = vcore
        self.container_image_scan = container_image_scan

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_use_coupon is not None:
            result['AutoUseCoupon'] = self.auto_use_coupon
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.sas_sls_storage is not None:
            result['SasSlsStorage'] = self.sas_sls_storage
        if self.sas_anti_ransomware is not None:
            result['SasAntiRansomware'] = self.sas_anti_ransomware
        if self.sas_webguard_boolean is not None:
            result['SasWebguardBoolean'] = self.sas_webguard_boolean
        if self.sas_sc is not None:
            result['SasSc'] = self.sas_sc
        if self.sas_product_service is not None:
            result['SasProductService'] = self.sas_product_service
        if self.sas_webguard_order_num is not None:
            result['SasWebguardOrderNum'] = self.sas_webguard_order_num
        if self.vcore is not None:
            result['Vcore'] = self.vcore
        if self.container_image_scan is not None:
            result['ContainerImageScan'] = self.container_image_scan
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoUseCoupon') is not None:
            self.auto_use_coupon = m.get('AutoUseCoupon')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('SasSlsStorage') is not None:
            self.sas_sls_storage = m.get('SasSlsStorage')
        if m.get('SasAntiRansomware') is not None:
            self.sas_anti_ransomware = m.get('SasAntiRansomware')
        if m.get('SasWebguardBoolean') is not None:
            self.sas_webguard_boolean = m.get('SasWebguardBoolean')
        if m.get('SasSc') is not None:
            self.sas_sc = m.get('SasSc')
        if m.get('SasProductService') is not None:
            self.sas_product_service = m.get('SasProductService')
        if m.get('SasWebguardOrderNum') is not None:
            self.sas_webguard_order_num = m.get('SasWebguardOrderNum')
        if m.get('Vcore') is not None:
            self.vcore = m.get('Vcore')
        if m.get('ContainerImageScan') is not None:
            self.container_image_scan = m.get('ContainerImageScan')
        return self


class CreateSasOrderResponseBody(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        request_id: str = None,
    ):
        self.order_id = order_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSasOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSasOrderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSasOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateServiceLinkedRoleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateServiceLinkedRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateServiceLinkedRoleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateServiceLinkedRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSimilarSecurityEventsQueryTaskRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        security_event_id: int = None,
        similar_event_scenario_code: str = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.security_event_id = security_event_id
        self.similar_event_scenario_code = similar_event_scenario_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.similar_event_scenario_code is not None:
            result['SimilarEventScenarioCode'] = self.similar_event_scenario_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('SimilarEventScenarioCode') is not None:
            self.similar_event_scenario_code = m.get('SimilarEventScenarioCode')
        return self


class CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse(TeaModel):
    def __init__(
        self,
        status: str = None,
        task_id: int = None,
    ):
        self.status = status
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateSimilarSecurityEventsQueryTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        create_similar_security_events_query_task_response: CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse = None,
    ):
        self.request_id = request_id
        self.create_similar_security_events_query_task_response = create_similar_security_events_query_task_response

    def validate(self):
        if self.create_similar_security_events_query_task_response:
            self.create_similar_security_events_query_task_response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.create_similar_security_events_query_task_response is not None:
            result['CreateSimilarSecurityEventsQueryTaskResponse'] = self.create_similar_security_events_query_task_response.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CreateSimilarSecurityEventsQueryTaskResponse') is not None:
            temp_model = CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse()
            self.create_similar_security_events_query_task_response = temp_model.from_map(m['CreateSimilarSecurityEventsQueryTaskResponse'])
        return self


class CreateSimilarSecurityEventsQueryTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSimilarSecurityEventsQueryTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSimilarSecurityEventsQueryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAssetRequest(TeaModel):
    def __init__(
        self,
        uuid: str = None,
    ):
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DeleteAssetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAssetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteAssetResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteAssetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        id: int = None,
        policy_version: str = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.id = id
        self.policy_version = policy_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.id is not None:
            result['Id'] = self.id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        return self


class DeleteBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupPolicyMachineRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        uuid: str = None,
        policy_id: int = None,
        policy_version: str = None,
        uuid_list: List[str] = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.uuid = uuid
        self.policy_id = policy_id
        self.policy_version = policy_version
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DeleteBackupPolicyMachineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupPolicyMachineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteBackupPolicyMachineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBackupPolicyMachineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGroupRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        group_id: int = None,
    ):
        self.source_ip = source_ip
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class DeleteGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLoginBaseConfigRequest(TeaModel):
    def __init__(
        self,
        type: str = None,
        config: str = None,
        target: str = None,
    ):
        self.type = type
        self.config = config
        self.target = target

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.config is not None:
            result['Config'] = self.config
        if self.target is not None:
            result['Target'] = self.target
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        return self


class DeleteLoginBaseConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLoginBaseConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLoginBaseConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLoginBaseConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStrategyRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        id: str = None,
        lang: str = None,
    ):
        self.source_ip = source_ip
        self.id = id
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.id is not None:
            result['Id'] = self.id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DeleteStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteStrategyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTagWithUuidRequest(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        uuid_list: str = None,
    ):
        self.tag_name = tag_name
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DeleteTagWithUuidResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTagWithUuidResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteTagWithUuidResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTagWithUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpcHoneyPotRequest(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
    ):
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DeleteVpcHoneyPotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpcHoneyPotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteVpcHoneyPotResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteVpcHoneyPotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccesskeyLeakListRequest(TeaModel):
    def __init__(
        self,
        status: str = None,
        query: str = None,
        start_ts: int = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.status = status
        self.query = query
        self.start_ts = start_ts
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.query is not None:
            result['Query'] = self.query
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList(TeaModel):
    def __init__(
        self,
        deal_time: str = None,
        status: str = None,
        type: str = None,
        user_type: str = None,
        accesskey_id: str = None,
        ali_user_name: str = None,
        deal_type: str = None,
        url: str = None,
        gmt_modified: int = None,
        asset: str = None,
        id: int = None,
    ):
        self.deal_time = deal_time
        self.status = status
        self.type = type
        self.user_type = user_type
        self.accesskey_id = accesskey_id
        self.ali_user_name = ali_user_name
        self.deal_type = deal_type
        self.url = url
        self.gmt_modified = gmt_modified
        self.asset = asset
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deal_time is not None:
            result['DealTime'] = self.deal_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.user_type is not None:
            result['UserType'] = self.user_type
        if self.accesskey_id is not None:
            result['AccesskeyId'] = self.accesskey_id
        if self.ali_user_name is not None:
            result['AliUserName'] = self.ali_user_name
        if self.deal_type is not None:
            result['DealType'] = self.deal_type
        if self.url is not None:
            result['Url'] = self.url
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.asset is not None:
            result['Asset'] = self.asset
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DealTime') is not None:
            self.deal_time = m.get('DealTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        if m.get('AccesskeyId') is not None:
            self.accesskey_id = m.get('AccesskeyId')
        if m.get('AliUserName') is not None:
            self.ali_user_name = m.get('AliUserName')
        if m.get('DealType') is not None:
            self.deal_type = m.get('DealType')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Asset') is not None:
            self.asset = m.get('Asset')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeAccesskeyLeakListResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        request_id: str = None,
        gmt_last: int = None,
        ak_leak_count: int = None,
        page_size: int = None,
        total_count: int = None,
        access_key_leak_list: List[DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList] = None,
    ):
        self.current_page = current_page
        self.request_id = request_id
        self.gmt_last = gmt_last
        self.ak_leak_count = ak_leak_count
        self.page_size = page_size
        self.total_count = total_count
        self.access_key_leak_list = access_key_leak_list

    def validate(self):
        if self.access_key_leak_list:
            for k in self.access_key_leak_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.ak_leak_count is not None:
            result['AkLeakCount'] = self.ak_leak_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['AccessKeyLeakList'] = []
        if self.access_key_leak_list is not None:
            for k in self.access_key_leak_list:
                result['AccessKeyLeakList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('AkLeakCount') is not None:
            self.ak_leak_count = m.get('AkLeakCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.access_key_leak_list = []
        if m.get('AccessKeyLeakList') is not None:
            for k in m.get('AccessKeyLeakList'):
                temp_model = DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList()
                self.access_key_leak_list.append(temp_model.from_map(k))
        return self


class DescribeAccesskeyLeakListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAccesskeyLeakListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAccesskeyLeakListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAffectedMaliciousFileImagesRequest(TeaModel):
    def __init__(
        self,
        malicious_md_5: str = None,
        current_page: int = None,
        page_size: str = None,
        lang: str = None,
        repo_region_id: str = None,
        repo_instance_id: str = None,
        repo_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        image_tag: str = None,
        image_digest: str = None,
        image_layer: str = None,
    ):
        self.malicious_md_5 = malicious_md_5
        self.current_page = current_page
        self.page_size = page_size
        self.lang = lang
        self.repo_region_id = repo_region_id
        self.repo_instance_id = repo_instance_id
        self.repo_id = repo_id
        self.repo_name = repo_name
        self.repo_namespace = repo_namespace
        self.image_tag = image_tag
        self.image_digest = image_digest
        self.image_layer = image_layer

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        return self


class DescribeAffectedMaliciousFileImagesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse(TeaModel):
    def __init__(
        self,
        status: int = None,
        digest: str = None,
        latest_verify_timestamp: int = None,
        repo_instance_id: str = None,
        namespace: str = None,
        tag: str = None,
        repo_region_id: str = None,
        image_uuid: str = None,
        first_scan_timestamp: int = None,
        malicious_md_5: str = None,
        file_path: str = None,
        repo_id: str = None,
        layer: str = None,
        latest_scan_timestamp: int = None,
        repo_name: str = None,
        level: str = None,
    ):
        self.status = status
        self.digest = digest
        self.latest_verify_timestamp = latest_verify_timestamp
        self.repo_instance_id = repo_instance_id
        self.namespace = namespace
        self.tag = tag
        self.repo_region_id = repo_region_id
        self.image_uuid = image_uuid
        self.first_scan_timestamp = first_scan_timestamp
        self.malicious_md_5 = malicious_md_5
        self.file_path = file_path
        self.repo_id = repo_id
        self.layer = layer
        self.latest_scan_timestamp = latest_scan_timestamp
        self.repo_name = repo_name
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.digest is not None:
            result['Digest'] = self.digest
        if self.latest_verify_timestamp is not None:
            result['LatestVerifyTimestamp'] = self.latest_verify_timestamp
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.first_scan_timestamp is not None:
            result['FirstScanTimestamp'] = self.first_scan_timestamp
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.latest_scan_timestamp is not None:
            result['LatestScanTimestamp'] = self.latest_scan_timestamp
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        if m.get('LatestVerifyTimestamp') is not None:
            self.latest_verify_timestamp = m.get('LatestVerifyTimestamp')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('FirstScanTimestamp') is not None:
            self.first_scan_timestamp = m.get('FirstScanTimestamp')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('LatestScanTimestamp') is not None:
            self.latest_scan_timestamp = m.get('LatestScanTimestamp')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeAffectedMaliciousFileImagesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeAffectedMaliciousFileImagesResponseBodyPageInfo = None,
        affected_malicious_file_images_response: List[DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.affected_malicious_file_images_response = affected_malicious_file_images_response

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.affected_malicious_file_images_response:
            for k in self.affected_malicious_file_images_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['AffectedMaliciousFileImagesResponse'] = []
        if self.affected_malicious_file_images_response is not None:
            for k in self.affected_malicious_file_images_response:
                result['AffectedMaliciousFileImagesResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeAffectedMaliciousFileImagesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.affected_malicious_file_images_response = []
        if m.get('AffectedMaliciousFileImagesResponse') is not None:
            for k in m.get('AffectedMaliciousFileImagesResponse'):
                temp_model = DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse()
                self.affected_malicious_file_images_response.append(temp_model.from_map(k))
        return self


class DescribeAffectedMaliciousFileImagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAffectedMaliciousFileImagesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAffectedMaliciousFileImagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventDetailRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        alarm_unique_info: str = None,
        from_: str = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.alarm_unique_info = alarm_unique_info
        self.from_ = from_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.from_ is not None:
            result['From'] = self.from_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        return self


class DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue(TeaModel):
    def __init__(
        self,
        type: str = None,
        value: str = None,
        name: str = None,
    ):
        self.type = type
        self.value = value
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeAlarmEventDetailResponseBodyDataCauseDetails(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: List[DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue] = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        if self.value:
            for k in self.value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        result['Value'] = []
        if self.value is not None:
            for k in self.value:
                result['Value'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        self.value = []
        if m.get('Value') is not None:
            for k in m.get('Value'):
                temp_model = DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue()
                self.value.append(temp_model.from_map(k))
        return self


class DescribeAlarmEventDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        type: str = None,
        internet_ip: str = None,
        k_8s_cluster_name: str = None,
        container_image_id: str = None,
        alarm_event_desc: str = None,
        alarm_unique_info: str = None,
        can_cancel_fault: bool = None,
        app_name: str = None,
        can_be_deal_on_line: bool = None,
        container_image_name: str = None,
        k_8s_cluster_id: str = None,
        contain_hw_mode: bool = None,
        instance_name: str = None,
        k_8s_node_id: str = None,
        solution: str = None,
        data_source: str = None,
        intranet_ip: str = None,
        alarm_event_alias_name: str = None,
        end_time: int = None,
        uuid: str = None,
        start_time: int = None,
        container_id: str = None,
        k_8s_pod_name: str = None,
        k_8s_namespace: str = None,
        k_8s_node_name: str = None,
        level: str = None,
        cause_details: List[DescribeAlarmEventDetailResponseBodyDataCauseDetails] = None,
    ):
        self.type = type
        self.internet_ip = internet_ip
        self.k_8s_cluster_name = k_8s_cluster_name
        self.container_image_id = container_image_id
        self.alarm_event_desc = alarm_event_desc
        self.alarm_unique_info = alarm_unique_info
        self.can_cancel_fault = can_cancel_fault
        self.app_name = app_name
        self.can_be_deal_on_line = can_be_deal_on_line
        self.container_image_name = container_image_name
        self.k_8s_cluster_id = k_8s_cluster_id
        self.contain_hw_mode = contain_hw_mode
        self.instance_name = instance_name
        self.k_8s_node_id = k_8s_node_id
        self.solution = solution
        self.data_source = data_source
        self.intranet_ip = intranet_ip
        self.alarm_event_alias_name = alarm_event_alias_name
        self.end_time = end_time
        self.uuid = uuid
        self.start_time = start_time
        self.container_id = container_id
        self.k_8s_pod_name = k_8s_pod_name
        self.k_8s_namespace = k_8s_namespace
        self.k_8s_node_name = k_8s_node_name
        self.level = level
        self.cause_details = cause_details

    def validate(self):
        if self.cause_details:
            for k in self.cause_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.k_8s_cluster_name is not None:
            result['K8sClusterName'] = self.k_8s_cluster_name
        if self.container_image_id is not None:
            result['ContainerImageId'] = self.container_image_id
        if self.alarm_event_desc is not None:
            result['AlarmEventDesc'] = self.alarm_event_desc
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.container_image_name is not None:
            result['ContainerImageName'] = self.container_image_name
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.contain_hw_mode is not None:
            result['ContainHwMode'] = self.contain_hw_mode
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.k_8s_node_id is not None:
            result['K8sNodeId'] = self.k_8s_node_id
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.alarm_event_alias_name is not None:
            result['AlarmEventAliasName'] = self.alarm_event_alias_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.k_8s_pod_name is not None:
            result['K8sPodName'] = self.k_8s_pod_name
        if self.k_8s_namespace is not None:
            result['K8sNamespace'] = self.k_8s_namespace
        if self.k_8s_node_name is not None:
            result['K8sNodeName'] = self.k_8s_node_name
        if self.level is not None:
            result['Level'] = self.level
        result['CauseDetails'] = []
        if self.cause_details is not None:
            for k in self.cause_details:
                result['CauseDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('K8sClusterName') is not None:
            self.k_8s_cluster_name = m.get('K8sClusterName')
        if m.get('ContainerImageId') is not None:
            self.container_image_id = m.get('ContainerImageId')
        if m.get('AlarmEventDesc') is not None:
            self.alarm_event_desc = m.get('AlarmEventDesc')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('ContainerImageName') is not None:
            self.container_image_name = m.get('ContainerImageName')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('ContainHwMode') is not None:
            self.contain_hw_mode = m.get('ContainHwMode')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('K8sNodeId') is not None:
            self.k_8s_node_id = m.get('K8sNodeId')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('AlarmEventAliasName') is not None:
            self.alarm_event_alias_name = m.get('AlarmEventAliasName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('K8sPodName') is not None:
            self.k_8s_pod_name = m.get('K8sPodName')
        if m.get('K8sNamespace') is not None:
            self.k_8s_namespace = m.get('K8sNamespace')
        if m.get('K8sNodeName') is not None:
            self.k_8s_node_name = m.get('K8sNodeName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        self.cause_details = []
        if m.get('CauseDetails') is not None:
            for k in m.get('CauseDetails'):
                temp_model = DescribeAlarmEventDetailResponseBodyDataCauseDetails()
                self.cause_details.append(temp_model.from_map(k))
        return self


class DescribeAlarmEventDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: DescribeAlarmEventDetailResponseBodyData = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = DescribeAlarmEventDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DescribeAlarmEventDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAlarmEventDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventListRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        dealed: str = None,
        from_: str = None,
        levels: str = None,
        remark: str = None,
        group_id: str = None,
        alarm_event_name: str = None,
        alarm_event_type: str = None,
        current_page: int = None,
        page_size: str = None,
        cluster_id: str = None,
        container_field_name: str = None,
        container_field_value: str = None,
        target_type: str = None,
        operate_error_code_list: List[str] = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.dealed = dealed
        self.from_ = from_
        self.levels = levels
        self.remark = remark
        self.group_id = group_id
        self.alarm_event_name = alarm_event_name
        self.alarm_event_type = alarm_event_type
        self.current_page = current_page
        self.page_size = page_size
        self.cluster_id = cluster_id
        self.container_field_name = container_field_name
        self.container_field_value = container_field_value
        self.target_type = target_type
        self.operate_error_code_list = operate_error_code_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.from_ is not None:
            result['From'] = self.from_
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.alarm_event_name is not None:
            result['AlarmEventName'] = self.alarm_event_name
        if self.alarm_event_type is not None:
            result['AlarmEventType'] = self.alarm_event_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_field_name is not None:
            result['ContainerFieldName'] = self.container_field_name
        if self.container_field_value is not None:
            result['ContainerFieldValue'] = self.container_field_value
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.operate_error_code_list is not None:
            result['OperateErrorCodeList'] = self.operate_error_code_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('AlarmEventName') is not None:
            self.alarm_event_name = m.get('AlarmEventName')
        if m.get('AlarmEventType') is not None:
            self.alarm_event_type = m.get('AlarmEventType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerFieldName') is not None:
            self.container_field_name = m.get('ContainerFieldName')
        if m.get('ContainerFieldValue') is not None:
            self.container_field_value = m.get('ContainerFieldValue')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('OperateErrorCodeList') is not None:
            self.operate_error_code_list = m.get('OperateErrorCodeList')
        return self


class DescribeAlarmEventListResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeAlarmEventListResponseBodySuspEvents(TeaModel):
    def __init__(
        self,
        dealed: bool = None,
        stages: str = None,
        internet_ip: str = None,
        suspicious_event_count: int = None,
        k_8s_cluster_name: str = None,
        container_image_id: str = None,
        gmt_modified: int = None,
        alarm_event_name_original: str = None,
        alarm_unique_info: str = None,
        can_cancel_fault: bool = None,
        app_name: str = None,
        security_event_ids: str = None,
        k_8s_cluster_id: str = None,
        container_image_name: str = None,
        can_be_deal_on_line: bool = None,
        description: str = None,
        contain_hw_mode: bool = None,
        k_8s_node_id: str = None,
        instance_name: str = None,
        sale_version: str = None,
        operate_error_code: str = None,
        solution: str = None,
        has_trace_info: bool = None,
        data_source: str = None,
        operate_time: int = None,
        instance_id: str = None,
        intranet_ip: str = None,
        end_time: int = None,
        uuid: str = None,
        start_time: int = None,
        k_8s_pod_name: str = None,
        container_id: str = None,
        alarm_event_type: str = None,
        k_8s_namespace: str = None,
        k_8s_node_name: str = None,
        alarm_event_name: str = None,
        level: str = None,
    ):
        self.dealed = dealed
        self.stages = stages
        self.internet_ip = internet_ip
        self.suspicious_event_count = suspicious_event_count
        self.k_8s_cluster_name = k_8s_cluster_name
        self.container_image_id = container_image_id
        self.gmt_modified = gmt_modified
        self.alarm_event_name_original = alarm_event_name_original
        self.alarm_unique_info = alarm_unique_info
        self.can_cancel_fault = can_cancel_fault
        self.app_name = app_name
        self.security_event_ids = security_event_ids
        self.k_8s_cluster_id = k_8s_cluster_id
        self.container_image_name = container_image_name
        self.can_be_deal_on_line = can_be_deal_on_line
        self.description = description
        self.contain_hw_mode = contain_hw_mode
        self.k_8s_node_id = k_8s_node_id
        self.instance_name = instance_name
        self.sale_version = sale_version
        self.operate_error_code = operate_error_code
        self.solution = solution
        self.has_trace_info = has_trace_info
        self.data_source = data_source
        self.operate_time = operate_time
        self.instance_id = instance_id
        self.intranet_ip = intranet_ip
        self.end_time = end_time
        self.uuid = uuid
        self.start_time = start_time
        self.k_8s_pod_name = k_8s_pod_name
        self.container_id = container_id
        self.alarm_event_type = alarm_event_type
        self.k_8s_namespace = k_8s_namespace
        self.k_8s_node_name = k_8s_node_name
        self.alarm_event_name = alarm_event_name
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.stages is not None:
            result['Stages'] = self.stages
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.suspicious_event_count is not None:
            result['SuspiciousEventCount'] = self.suspicious_event_count
        if self.k_8s_cluster_name is not None:
            result['K8sClusterName'] = self.k_8s_cluster_name
        if self.container_image_id is not None:
            result['ContainerImageId'] = self.container_image_id
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.alarm_event_name_original is not None:
            result['AlarmEventNameOriginal'] = self.alarm_event_name_original
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.container_image_name is not None:
            result['ContainerImageName'] = self.container_image_name
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.description is not None:
            result['Description'] = self.description
        if self.contain_hw_mode is not None:
            result['ContainHwMode'] = self.contain_hw_mode
        if self.k_8s_node_id is not None:
            result['K8sNodeId'] = self.k_8s_node_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.sale_version is not None:
            result['SaleVersion'] = self.sale_version
        if self.operate_error_code is not None:
            result['OperateErrorCode'] = self.operate_error_code
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.has_trace_info is not None:
            result['HasTraceInfo'] = self.has_trace_info
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.operate_time is not None:
            result['OperateTime'] = self.operate_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.k_8s_pod_name is not None:
            result['K8sPodName'] = self.k_8s_pod_name
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.alarm_event_type is not None:
            result['AlarmEventType'] = self.alarm_event_type
        if self.k_8s_namespace is not None:
            result['K8sNamespace'] = self.k_8s_namespace
        if self.k_8s_node_name is not None:
            result['K8sNodeName'] = self.k_8s_node_name
        if self.alarm_event_name is not None:
            result['AlarmEventName'] = self.alarm_event_name
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('Stages') is not None:
            self.stages = m.get('Stages')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('SuspiciousEventCount') is not None:
            self.suspicious_event_count = m.get('SuspiciousEventCount')
        if m.get('K8sClusterName') is not None:
            self.k_8s_cluster_name = m.get('K8sClusterName')
        if m.get('ContainerImageId') is not None:
            self.container_image_id = m.get('ContainerImageId')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('AlarmEventNameOriginal') is not None:
            self.alarm_event_name_original = m.get('AlarmEventNameOriginal')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('ContainerImageName') is not None:
            self.container_image_name = m.get('ContainerImageName')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ContainHwMode') is not None:
            self.contain_hw_mode = m.get('ContainHwMode')
        if m.get('K8sNodeId') is not None:
            self.k_8s_node_id = m.get('K8sNodeId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('SaleVersion') is not None:
            self.sale_version = m.get('SaleVersion')
        if m.get('OperateErrorCode') is not None:
            self.operate_error_code = m.get('OperateErrorCode')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('HasTraceInfo') is not None:
            self.has_trace_info = m.get('HasTraceInfo')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('OperateTime') is not None:
            self.operate_time = m.get('OperateTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('K8sPodName') is not None:
            self.k_8s_pod_name = m.get('K8sPodName')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('AlarmEventType') is not None:
            self.alarm_event_type = m.get('AlarmEventType')
        if m.get('K8sNamespace') is not None:
            self.k_8s_namespace = m.get('K8sNamespace')
        if m.get('K8sNodeName') is not None:
            self.k_8s_node_name = m.get('K8sNodeName')
        if m.get('AlarmEventName') is not None:
            self.alarm_event_name = m.get('AlarmEventName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeAlarmEventListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeAlarmEventListResponseBodyPageInfo = None,
        susp_events: List[DescribeAlarmEventListResponseBodySuspEvents] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.susp_events = susp_events

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.susp_events:
            for k in self.susp_events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['SuspEvents'] = []
        if self.susp_events is not None:
            for k in self.susp_events:
                result['SuspEvents'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeAlarmEventListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.susp_events = []
        if m.get('SuspEvents') is not None:
            for k in m.get('SuspEvents'):
                temp_model = DescribeAlarmEventListResponseBodySuspEvents()
                self.susp_events.append(temp_model.from_map(k))
        return self


class DescribeAlarmEventListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAlarmEventListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventStackInfoRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        uuid: str = None,
        event_name: str = None,
        unique_info: str = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.uuid = uuid
        self.event_name = event_name
        self.unique_info = unique_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.unique_info is not None:
            result['UniqueInfo'] = self.unique_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('UniqueInfo') is not None:
            self.unique_info = m.get('UniqueInfo')
        return self


class DescribeAlarmEventStackInfoResponseBody(TeaModel):
    def __init__(
        self,
        stack_info: str = None,
        request_id: str = None,
    ):
        self.stack_info = stack_info
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stack_info is not None:
            result['StackInfo'] = self.stack_info
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StackInfo') is not None:
            self.stack_info = m.get('StackInfo')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAlarmEventStackInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAlarmEventStackInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventStackInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllEntityResponseBodyEntityList(TeaModel):
    def __init__(
        self,
        uuid: str = None,
        group_id: int = None,
        internet_ip: str = None,
        instance_name: str = None,
        ip: str = None,
        os: str = None,
        intranet_ip: str = None,
    ):
        self.uuid = uuid
        self.group_id = group_id
        self.internet_ip = internet_ip
        self.instance_name = instance_name
        self.ip = ip
        self.os = os
        self.intranet_ip = intranet_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.os is not None:
            result['Os'] = self.os
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        return self


class DescribeAllEntityResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        entity_list: List[DescribeAllEntityResponseBodyEntityList] = None,
    ):
        self.request_id = request_id
        self.entity_list = entity_list

    def validate(self):
        if self.entity_list:
            for k in self.entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['EntityList'] = []
        if self.entity_list is not None:
            for k in self.entity_list:
                result['EntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.entity_list = []
        if m.get('EntityList') is not None:
            for k in m.get('EntityList'):
                temp_model = DescribeAllEntityResponseBodyEntityList()
                self.entity_list.append(temp_model.from_map(k))
        return self


class DescribeAllEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAllEntityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAllEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllGroupsRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeAllGroupsResponseBodyGroups(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        group_id: int = None,
        group_flag: int = None,
    ):
        self.group_name = group_name
        self.group_id = group_id
        self.group_flag = group_flag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_flag is not None:
            result['GroupFlag'] = self.group_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupFlag') is not None:
            self.group_flag = m.get('GroupFlag')
        return self


class DescribeAllGroupsResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        request_id: str = None,
        groups: List[DescribeAllGroupsResponseBodyGroups] = None,
    ):
        self.count = count
        self.request_id = request_id
        self.groups = groups

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = DescribeAllGroupsResponseBodyGroups()
                self.groups.append(temp_model.from_map(k))
        return self


class DescribeAllGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAllGroupsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAllGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllRegionsStatisticsRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        from_: str = None,
        group_id: int = None,
        remark: str = None,
        type: str = None,
        uuid: str = None,
        status: int = None,
        status_list: str = None,
        start_time: str = None,
        end_time: str = None,
        web_group_id: int = None,
        rule_type: int = None,
        action_1: int = None,
        flow: int = None,
        sale_id: str = None,
        dealed: str = None,
        tag: str = None,
        current_page: int = None,
        page_size: int = None,
        secure_token: str = None,
        all_region: bool = None,
    ):
        self.source_ip = source_ip
        self.from_ = from_
        self.group_id = group_id
        self.remark = remark
        self.type = type
        self.uuid = uuid
        self.status = status
        self.status_list = status_list
        self.start_time = start_time
        self.end_time = end_time
        self.web_group_id = web_group_id
        self.rule_type = rule_type
        self.action_1 = action_1
        self.flow = flow
        self.sale_id = sale_id
        self.dealed = dealed
        self.tag = tag
        self.current_page = current_page
        self.page_size = page_size
        self.secure_token = secure_token
        self.all_region = all_region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.from_ is not None:
            result['From'] = self.from_
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.status is not None:
            result['Status'] = self.status
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.web_group_id is not None:
            result['WebGroupId'] = self.web_group_id
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.action_1 is not None:
            result['Action1'] = self.action_1
        if self.flow is not None:
            result['Flow'] = self.flow
        if self.sale_id is not None:
            result['SaleId'] = self.sale_id
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.secure_token is not None:
            result['SecureToken'] = self.secure_token
        if self.all_region is not None:
            result['AllRegion'] = self.all_region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('WebGroupId') is not None:
            self.web_group_id = m.get('WebGroupId')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('Action1') is not None:
            self.action_1 = m.get('Action1')
        if m.get('Flow') is not None:
            self.flow = m.get('Flow')
        if m.get('SaleId') is not None:
            self.sale_id = m.get('SaleId')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SecureToken') is not None:
            self.secure_token = m.get('SecureToken')
        if m.get('AllRegion') is not None:
            self.all_region = m.get('AllRegion')
        return self


class DescribeAllRegionsStatisticsResponseBodyData(TeaModel):
    def __init__(
        self,
        account: int = None,
        vul: int = None,
        health: int = None,
        trojan: int = None,
        new_suspicious: int = None,
        suspicious: int = None,
    ):
        self.account = account
        self.vul = vul
        self.health = health
        self.trojan = trojan
        self.new_suspicious = new_suspicious
        self.suspicious = suspicious

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['Account'] = self.account
        if self.vul is not None:
            result['Vul'] = self.vul
        if self.health is not None:
            result['Health'] = self.health
        if self.trojan is not None:
            result['Trojan'] = self.trojan
        if self.new_suspicious is not None:
            result['NewSuspicious'] = self.new_suspicious
        if self.suspicious is not None:
            result['Suspicious'] = self.suspicious
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Account') is not None:
            self.account = m.get('Account')
        if m.get('Vul') is not None:
            self.vul = m.get('Vul')
        if m.get('Health') is not None:
            self.health = m.get('Health')
        if m.get('Trojan') is not None:
            self.trojan = m.get('Trojan')
        if m.get('NewSuspicious') is not None:
            self.new_suspicious = m.get('NewSuspicious')
        if m.get('Suspicious') is not None:
            self.suspicious = m.get('Suspicious')
        return self


class DescribeAllRegionsStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: DescribeAllRegionsStatisticsResponseBodyData = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = DescribeAllRegionsStatisticsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DescribeAllRegionsStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAllRegionsStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAllRegionsStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAntiBruteForceRulesRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeAntiBruteForceRulesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeAntiBruteForceRulesResponseBodyRules(TeaModel):
    def __init__(
        self,
        machine_count: int = None,
        enable_smart_rule: bool = None,
        fail_count: int = None,
        forbidden_time: int = None,
        span: int = None,
        default_rule: bool = None,
        name: str = None,
        id: int = None,
        uuid_list: List[str] = None,
    ):
        self.machine_count = machine_count
        self.enable_smart_rule = enable_smart_rule
        self.fail_count = fail_count
        self.forbidden_time = forbidden_time
        self.span = span
        self.default_rule = default_rule
        self.name = name
        self.id = id
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_count is not None:
            result['MachineCount'] = self.machine_count
        if self.enable_smart_rule is not None:
            result['EnableSmartRule'] = self.enable_smart_rule
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.span is not None:
            result['Span'] = self.span
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MachineCount') is not None:
            self.machine_count = m.get('MachineCount')
        if m.get('EnableSmartRule') is not None:
            self.enable_smart_rule = m.get('EnableSmartRule')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeAntiBruteForceRulesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeAntiBruteForceRulesResponseBodyPageInfo = None,
        rules: List[DescribeAntiBruteForceRulesResponseBodyRules] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.rules = rules

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeAntiBruteForceRulesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeAntiBruteForceRulesResponseBodyRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeAntiBruteForceRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAntiBruteForceRulesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAntiBruteForceRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetDetailByUuidRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        uuid: str = None,
        lang: str = None,
    ):
        self.source_ip = source_ip
        self.uuid = uuid
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeAssetDetailByUuidResponseBodyAssetDetail(TeaModel):
    def __init__(
        self,
        cpu_info: str = None,
        internet_ip: str = None,
        os_detail: str = None,
        create_time: int = None,
        kernel: str = None,
        bind: bool = None,
        os_name: str = None,
        tag: str = None,
        client_status: str = None,
        mem: int = None,
        vpc_instance_id: str = None,
        auth_version: int = None,
        instance_name: str = None,
        region: str = None,
        group_trace: str = None,
        ip: str = None,
        host_name: str = None,
        os: str = None,
        auth_modify_time: int = None,
        instance_id: str = None,
        intranet_ip: str = None,
        asset_type: str = None,
        region_id: str = None,
        sys_info: str = None,
        uuid: str = None,
        cpu: int = None,
        region_name: str = None,
        ip_list: List[str] = None,
        mac_list: List[str] = None,
        disk_info_list: List[str] = None,
    ):
        self.cpu_info = cpu_info
        self.internet_ip = internet_ip
        self.os_detail = os_detail
        self.create_time = create_time
        self.kernel = kernel
        self.bind = bind
        self.os_name = os_name
        self.tag = tag
        self.client_status = client_status
        self.mem = mem
        self.vpc_instance_id = vpc_instance_id
        self.auth_version = auth_version
        self.instance_name = instance_name
        self.region = region
        self.group_trace = group_trace
        self.ip = ip
        self.host_name = host_name
        self.os = os
        self.auth_modify_time = auth_modify_time
        self.instance_id = instance_id
        self.intranet_ip = intranet_ip
        self.asset_type = asset_type
        self.region_id = region_id
        self.sys_info = sys_info
        self.uuid = uuid
        self.cpu = cpu
        self.region_name = region_name
        self.ip_list = ip_list
        self.mac_list = mac_list
        self.disk_info_list = disk_info_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_info is not None:
            result['CpuInfo'] = self.cpu_info
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.os_detail is not None:
            result['OsDetail'] = self.os_detail
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.kernel is not None:
            result['Kernel'] = self.kernel
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.mem is not None:
            result['Mem'] = self.mem
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        if self.auth_version is not None:
            result['AuthVersion'] = self.auth_version
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region is not None:
            result['Region'] = self.region
        if self.group_trace is not None:
            result['GroupTrace'] = self.group_trace
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.os is not None:
            result['Os'] = self.os
        if self.auth_modify_time is not None:
            result['AuthModifyTime'] = self.auth_modify_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.sys_info is not None:
            result['SysInfo'] = self.sys_info
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.ip_list is not None:
            result['IpList'] = self.ip_list
        if self.mac_list is not None:
            result['MacList'] = self.mac_list
        if self.disk_info_list is not None:
            result['DiskInfoList'] = self.disk_info_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CpuInfo') is not None:
            self.cpu_info = m.get('CpuInfo')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('OsDetail') is not None:
            self.os_detail = m.get('OsDetail')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Kernel') is not None:
            self.kernel = m.get('Kernel')
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('Mem') is not None:
            self.mem = m.get('Mem')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        if m.get('AuthVersion') is not None:
            self.auth_version = m.get('AuthVersion')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('GroupTrace') is not None:
            self.group_trace = m.get('GroupTrace')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('AuthModifyTime') is not None:
            self.auth_modify_time = m.get('AuthModifyTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SysInfo') is not None:
            self.sys_info = m.get('SysInfo')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('IpList') is not None:
            self.ip_list = m.get('IpList')
        if m.get('MacList') is not None:
            self.mac_list = m.get('MacList')
        if m.get('DiskInfoList') is not None:
            self.disk_info_list = m.get('DiskInfoList')
        return self


class DescribeAssetDetailByUuidResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        asset_detail: DescribeAssetDetailByUuidResponseBodyAssetDetail = None,
    ):
        self.request_id = request_id
        self.asset_detail = asset_detail

    def validate(self):
        if self.asset_detail:
            self.asset_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.asset_detail is not None:
            result['AssetDetail'] = self.asset_detail.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AssetDetail') is not None:
            temp_model = DescribeAssetDetailByUuidResponseBodyAssetDetail()
            self.asset_detail = temp_model.from_map(m['AssetDetail'])
        return self


class DescribeAssetDetailByUuidResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAssetDetailByUuidResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAssetDetailByUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetDetailByUuidsRequest(TeaModel):
    def __init__(
        self,
        uuids: str = None,
    ):
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeAssetDetailByUuidsResponseBodyAssetList(TeaModel):
    def __init__(
        self,
        internet_ip: str = None,
        os_name: str = None,
        ip: str = None,
        os: str = None,
        instance_id: str = None,
        client_status: str = None,
        vpc_instance_id: str = None,
        intranet_ip: str = None,
        asset_type: str = None,
        region_id: str = None,
        uuid: str = None,
        flag: int = None,
        region_name: str = None,
        instance_name: str = None,
        region: str = None,
    ):
        self.internet_ip = internet_ip
        self.os_name = os_name
        self.ip = ip
        self.os = os
        self.instance_id = instance_id
        self.client_status = client_status
        self.vpc_instance_id = vpc_instance_id
        self.intranet_ip = intranet_ip
        self.asset_type = asset_type
        self.region_id = region_id
        self.uuid = uuid
        self.flag = flag
        self.region_name = region_name
        self.instance_name = instance_name
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.os is not None:
            result['Os'] = self.os
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DescribeAssetDetailByUuidsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        asset_list: List[DescribeAssetDetailByUuidsResponseBodyAssetList] = None,
    ):
        self.request_id = request_id
        self.asset_list = asset_list

    def validate(self):
        if self.asset_list:
            for k in self.asset_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['AssetList'] = []
        if self.asset_list is not None:
            for k in self.asset_list:
                result['AssetList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.asset_list = []
        if m.get('AssetList') is not None:
            for k in m.get('AssetList'):
                temp_model = DescribeAssetDetailByUuidsResponseBodyAssetList()
                self.asset_list.append(temp_model.from_map(k))
        return self


class DescribeAssetDetailByUuidsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAssetDetailByUuidsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAssetDetailByUuidsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoDelConfigResponseBody(TeaModel):
    def __init__(
        self,
        days: int = None,
        request_id: str = None,
    ):
        self.days = days
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.days is not None:
            result['Days'] = self.days
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Days') is not None:
            self.days = m.get('Days')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAutoDelConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAutoDelConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAutoDelConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupClientsRequest(TeaModel):
    def __init__(
        self,
        support_region_id: str = None,
    ):
        self.support_region_id = support_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.support_region_id is not None:
            result['SupportRegionId'] = self.support_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SupportRegionId') is not None:
            self.support_region_id = m.get('SupportRegionId')
        return self


class DescribeBackupClientsResponseBodyClients(TeaModel):
    def __init__(
        self,
        uuid: str = None,
        instance_id: str = None,
        client_status: str = None,
        client_id: str = None,
    ):
        self.uuid = uuid
        self.instance_id = instance_id
        self.client_status = client_status
        self.client_id = client_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        return self


class DescribeBackupClientsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        clients: List[DescribeBackupClientsResponseBodyClients] = None,
    ):
        self.request_id = request_id
        self.clients = clients

    def validate(self):
        if self.clients:
            for k in self.clients:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Clients'] = []
        if self.clients is not None:
            for k in self.clients:
                result['Clients'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.clients = []
        if m.get('Clients') is not None:
            for k in m.get('Clients'):
                temp_model = DescribeBackupClientsResponseBodyClients()
                self.clients.append(temp_model.from_map(k))
        return self


class DescribeBackupClientsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupClientsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupClientsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupDirsRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        policy_id: int = None,
        uuid: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.policy_id = policy_id
        self.uuid = uuid
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeBackupDirsResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeBackupDirsResponseBodyBackupDirs(TeaModel):
    def __init__(
        self,
        source: str = None,
        backup_job_id: int = None,
    ):
        self.source = source
        self.backup_job_id = backup_job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source is not None:
            result['Source'] = self.source
        if self.backup_job_id is not None:
            result['BackupJobId'] = self.backup_job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('BackupJobId') is not None:
            self.backup_job_id = m.get('BackupJobId')
        return self


class DescribeBackupDirsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeBackupDirsResponseBodyPageInfo = None,
        backup_dirs: List[DescribeBackupDirsResponseBodyBackupDirs] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.backup_dirs = backup_dirs

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.backup_dirs:
            for k in self.backup_dirs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['BackupDirs'] = []
        if self.backup_dirs is not None:
            for k in self.backup_dirs:
                result['BackupDirs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeBackupDirsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.backup_dirs = []
        if m.get('BackupDirs') is not None:
            for k in m.get('BackupDirs'):
                temp_model = DescribeBackupDirsResponseBodyBackupDirs()
                self.backup_dirs.append(temp_model.from_map(k))
        return self


class DescribeBackupDirsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupDirsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupDirsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupFilesRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        uuid: str = None,
        path: str = None,
        snapshot_hash: str = None,
        current_page: str = None,
        page_size: str = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.uuid = uuid
        self.path = path
        self.snapshot_hash = snapshot_hash
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.path is not None:
            result['Path'] = self.path
        if self.snapshot_hash is not None:
            result['SnapshotHash'] = self.snapshot_hash
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('SnapshotHash') is not None:
            self.snapshot_hash = m.get('SnapshotHash')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeBackupFilesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeBackupFilesResponseBodyBackupFiles(TeaModel):
    def __init__(
        self,
        type: str = None,
        name: str = None,
        subtree: str = None,
        size: int = None,
    ):
        self.type = type
        self.name = name
        self.subtree = subtree
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.name is not None:
            result['Name'] = self.name
        if self.subtree is not None:
            result['Subtree'] = self.subtree
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Subtree') is not None:
            self.subtree = m.get('Subtree')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class DescribeBackupFilesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeBackupFilesResponseBodyPageInfo = None,
        backup_files: List[DescribeBackupFilesResponseBodyBackupFiles] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.backup_files = backup_files

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.backup_files:
            for k in self.backup_files:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['BackupFiles'] = []
        if self.backup_files is not None:
            for k in self.backup_files:
                result['BackupFiles'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeBackupFilesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.backup_files = []
        if m.get('BackupFiles') is not None:
            for k in m.get('BackupFiles'):
                temp_model = DescribeBackupFilesResponseBodyBackupFiles()
                self.backup_files.append(temp_model.from_map(k))
        return self


class DescribeBackupFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupFilesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupMachineStatusRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        policy_id: int = None,
        uuid: str = None,
        policy_version: str = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.policy_id = policy_id
        self.uuid = uuid
        self.policy_version = policy_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        return self


class DescribeBackupMachineStatusResponseBodyBackupMachineStatusErrorList(TeaModel):
    def __init__(
        self,
        key: str = None,
        error_file: str = None,
        request_id: str = None,
        error_file_url: str = None,
        error_code: str = None,
        error_status: str = None,
        path: str = None,
        error_msg: str = None,
        error_type: str = None,
        error_time: int = None,
    ):
        self.key = key
        self.error_file = error_file
        self.request_id = request_id
        self.error_file_url = error_file_url
        self.error_code = error_code
        self.error_status = error_status
        self.path = path
        self.error_msg = error_msg
        self.error_type = error_type
        self.error_time = error_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.error_file is not None:
            result['ErrorFile'] = self.error_file
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_file_url is not None:
            result['ErrorFileUrl'] = self.error_file_url
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_status is not None:
            result['ErrorStatus'] = self.error_status
        if self.path is not None:
            result['Path'] = self.path
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.error_type is not None:
            result['ErrorType'] = self.error_type
        if self.error_time is not None:
            result['ErrorTime'] = self.error_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ErrorFile') is not None:
            self.error_file = m.get('ErrorFile')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorFileUrl') is not None:
            self.error_file_url = m.get('ErrorFileUrl')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorStatus') is not None:
            self.error_status = m.get('ErrorStatus')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('ErrorType') is not None:
            self.error_type = m.get('ErrorType')
        if m.get('ErrorTime') is not None:
            self.error_time = m.get('ErrorTime')
        return self


class DescribeBackupMachineStatusResponseBodyBackupMachineStatus(TeaModel):
    def __init__(
        self,
        status: str = None,
        vault_id: str = None,
        jobs: str = None,
        instance_id: str = None,
        client_status: str = None,
        client_id: str = None,
        region_id: str = None,
        uuid: str = None,
        request_id: str = None,
        error_code: str = None,
        saved_backup_count: int = None,
        client_version: str = None,
        error_list: List[DescribeBackupMachineStatusResponseBodyBackupMachineStatusErrorList] = None,
    ):
        self.status = status
        self.vault_id = vault_id
        self.jobs = jobs
        self.instance_id = instance_id
        self.client_status = client_status
        self.client_id = client_id
        self.region_id = region_id
        self.uuid = uuid
        self.request_id = request_id
        self.error_code = error_code
        self.saved_backup_count = saved_backup_count
        self.client_version = client_version
        self.error_list = error_list

    def validate(self):
        if self.error_list:
            for k in self.error_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.vault_id is not None:
            result['VaultId'] = self.vault_id
        if self.jobs is not None:
            result['Jobs'] = self.jobs
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.saved_backup_count is not None:
            result['SavedBackupCount'] = self.saved_backup_count
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        result['ErrorList'] = []
        if self.error_list is not None:
            for k in self.error_list:
                result['ErrorList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VaultId') is not None:
            self.vault_id = m.get('VaultId')
        if m.get('Jobs') is not None:
            self.jobs = m.get('Jobs')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('SavedBackupCount') is not None:
            self.saved_backup_count = m.get('SavedBackupCount')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        self.error_list = []
        if m.get('ErrorList') is not None:
            for k in m.get('ErrorList'):
                temp_model = DescribeBackupMachineStatusResponseBodyBackupMachineStatusErrorList()
                self.error_list.append(temp_model.from_map(k))
        return self


class DescribeBackupMachineStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        backup_machine_status: DescribeBackupMachineStatusResponseBodyBackupMachineStatus = None,
    ):
        self.request_id = request_id
        self.backup_machine_status = backup_machine_status

    def validate(self):
        if self.backup_machine_status:
            self.backup_machine_status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.backup_machine_status is not None:
            result['BackupMachineStatus'] = self.backup_machine_status.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('BackupMachineStatus') is not None:
            temp_model = DescribeBackupMachineStatusResponseBodyBackupMachineStatus()
            self.backup_machine_status = temp_model.from_map(m['BackupMachineStatus'])
        return self


class DescribeBackupMachineStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupMachineStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupMachineStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupPoliciesRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        name: str = None,
        machine_remark: str = None,
        status: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.name = name
        self.machine_remark = machine_remark
        self.status = status
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.name is not None:
            result['Name'] = self.name
        if self.machine_remark is not None:
            result['MachineRemark'] = self.machine_remark
        if self.status is not None:
            result['Status'] = self.status
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('MachineRemark') is not None:
            self.machine_remark = m.get('MachineRemark')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeBackupPoliciesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeBackupPoliciesResponseBodyPolicies(TeaModel):
    def __init__(
        self,
        client_error_count: int = None,
        status: str = None,
        policy_version: str = None,
        policy: str = None,
        service_error_count: int = None,
        policy_region_id: str = None,
        client_status: str = None,
        name: str = None,
        health_client_count: int = None,
        id: int = None,
        client_error_uuid_list: List[str] = None,
        remarked_uuid_list: List[str] = None,
        uuid_list: List[str] = None,
        service_error_uuid_list: List[str] = None,
        health_client_uuid_list: List[str] = None,
    ):
        self.client_error_count = client_error_count
        self.status = status
        self.policy_version = policy_version
        self.policy = policy
        self.service_error_count = service_error_count
        self.policy_region_id = policy_region_id
        self.client_status = client_status
        self.name = name
        self.health_client_count = health_client_count
        self.id = id
        self.client_error_uuid_list = client_error_uuid_list
        self.remarked_uuid_list = remarked_uuid_list
        self.uuid_list = uuid_list
        self.service_error_uuid_list = service_error_uuid_list
        self.health_client_uuid_list = health_client_uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_error_count is not None:
            result['ClientErrorCount'] = self.client_error_count
        if self.status is not None:
            result['Status'] = self.status
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.service_error_count is not None:
            result['ServiceErrorCount'] = self.service_error_count
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.name is not None:
            result['Name'] = self.name
        if self.health_client_count is not None:
            result['HealthClientCount'] = self.health_client_count
        if self.id is not None:
            result['Id'] = self.id
        if self.client_error_uuid_list is not None:
            result['ClientErrorUuidList'] = self.client_error_uuid_list
        if self.remarked_uuid_list is not None:
            result['RemarkedUuidList'] = self.remarked_uuid_list
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        if self.service_error_uuid_list is not None:
            result['ServiceErrorUuidList'] = self.service_error_uuid_list
        if self.health_client_uuid_list is not None:
            result['HealthClientUuidList'] = self.health_client_uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientErrorCount') is not None:
            self.client_error_count = m.get('ClientErrorCount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('ServiceErrorCount') is not None:
            self.service_error_count = m.get('ServiceErrorCount')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('HealthClientCount') is not None:
            self.health_client_count = m.get('HealthClientCount')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ClientErrorUuidList') is not None:
            self.client_error_uuid_list = m.get('ClientErrorUuidList')
        if m.get('RemarkedUuidList') is not None:
            self.remarked_uuid_list = m.get('RemarkedUuidList')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        if m.get('ServiceErrorUuidList') is not None:
            self.service_error_uuid_list = m.get('ServiceErrorUuidList')
        if m.get('HealthClientUuidList') is not None:
            self.health_client_uuid_list = m.get('HealthClientUuidList')
        return self


class DescribeBackupPoliciesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeBackupPoliciesResponseBodyPageInfo = None,
        policies: List[DescribeBackupPoliciesResponseBodyPolicies] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.policies = policies

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.policies:
            for k in self.policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Policies'] = []
        if self.policies is not None:
            for k in self.policies:
                result['Policies'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeBackupPoliciesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.policies = []
        if m.get('Policies') is not None:
            for k in m.get('Policies'):
                temp_model = DescribeBackupPoliciesResponseBodyPolicies()
                self.policies.append(temp_model.from_map(k))
        return self


class DescribeBackupPoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupPoliciesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        id: int = None,
        policy_version: str = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.id = id
        self.policy_version = policy_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.id is not None:
            result['Id'] = self.id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        return self


class DescribeBackupPolicyResponseBodyBackupPolicyDetail(TeaModel):
    def __init__(
        self,
        status: str = None,
        policy_version: str = None,
        policy: str = None,
        client_status: str = None,
        name: str = None,
        id: int = None,
        region_id: str = None,
        uuid_list: List[str] = None,
    ):
        self.status = status
        self.policy_version = policy_version
        self.policy = policy
        self.client_status = client_status
        self.name = name
        self.id = id
        self.region_id = region_id
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        backup_policy_detail: DescribeBackupPolicyResponseBodyBackupPolicyDetail = None,
    ):
        self.request_id = request_id
        self.backup_policy_detail = backup_policy_detail

    def validate(self):
        if self.backup_policy_detail:
            self.backup_policy_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.backup_policy_detail is not None:
            result['BackupPolicyDetail'] = self.backup_policy_detail.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('BackupPolicyDetail') is not None:
            temp_model = DescribeBackupPolicyResponseBodyBackupPolicyDetail()
            self.backup_policy_detail = temp_model.from_map(m['BackupPolicyDetail'])
        return self


class DescribeBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupRestoreCountRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeBackupRestoreCountResponseBodyBackupRestoreCount(TeaModel):
    def __init__(
        self,
        total: int = None,
        recovering: int = None,
    ):
        self.total = total
        self.recovering = recovering

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.recovering is not None:
            result['Recovering'] = self.recovering
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Recovering') is not None:
            self.recovering = m.get('Recovering')
        return self


class DescribeBackupRestoreCountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        backup_restore_count: DescribeBackupRestoreCountResponseBodyBackupRestoreCount = None,
    ):
        self.request_id = request_id
        self.backup_restore_count = backup_restore_count

    def validate(self):
        if self.backup_restore_count:
            self.backup_restore_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.backup_restore_count is not None:
            result['BackupRestoreCount'] = self.backup_restore_count.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('BackupRestoreCount') is not None:
            temp_model = DescribeBackupRestoreCountResponseBodyBackupRestoreCount()
            self.backup_restore_count = temp_model.from_map(m['BackupRestoreCount'])
        return self


class DescribeBackupRestoreCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupRestoreCountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupRestoreCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBruteForceSummaryRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeBruteForceSummaryResponseBodyBruteForceSummary(TeaModel):
    def __init__(
        self,
        all_strategy_count: int = None,
        effective_count: int = None,
    ):
        self.all_strategy_count = all_strategy_count
        self.effective_count = effective_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_strategy_count is not None:
            result['AllStrategyCount'] = self.all_strategy_count
        if self.effective_count is not None:
            result['EffectiveCount'] = self.effective_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllStrategyCount') is not None:
            self.all_strategy_count = m.get('AllStrategyCount')
        if m.get('EffectiveCount') is not None:
            self.effective_count = m.get('EffectiveCount')
        return self


class DescribeBruteForceSummaryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        brute_force_summary: DescribeBruteForceSummaryResponseBodyBruteForceSummary = None,
    ):
        self.request_id = request_id
        self.brute_force_summary = brute_force_summary

    def validate(self):
        if self.brute_force_summary:
            self.brute_force_summary.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.brute_force_summary is not None:
            result['BruteForceSummary'] = self.brute_force_summary.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('BruteForceSummary') is not None:
            temp_model = DescribeBruteForceSummaryResponseBodyBruteForceSummary()
            self.brute_force_summary = temp_model.from_map(m['BruteForceSummary'])
        return self


class DescribeBruteForceSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBruteForceSummaryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBruteForceSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckEcsWarningsRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
    ):
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeCheckEcsWarningsResponseBody(TeaModel):
    def __init__(
        self,
        sas_version: str = None,
        can_try: str = None,
        weak_password_count: str = None,
        request_id: str = None,
    ):
        self.sas_version = sas_version
        self.can_try = can_try
        self.weak_password_count = weak_password_count
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sas_version is not None:
            result['SasVersion'] = self.sas_version
        if self.can_try is not None:
            result['CanTry'] = self.can_try
        if self.weak_password_count is not None:
            result['WeakPasswordCount'] = self.weak_password_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SasVersion') is not None:
            self.sas_version = m.get('SasVersion')
        if m.get('CanTry') is not None:
            self.can_try = m.get('CanTry')
        if m.get('WeakPasswordCount') is not None:
            self.weak_password_count = m.get('WeakPasswordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCheckEcsWarningsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCheckEcsWarningsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCheckEcsWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningDetailRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        check_warning_id: int = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.check_warning_id = check_warning_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.check_warning_id is not None:
            result['CheckWarningId'] = self.check_warning_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('CheckWarningId') is not None:
            self.check_warning_id = m.get('CheckWarningId')
        return self


class DescribeCheckWarningDetailResponseBody(TeaModel):
    def __init__(
        self,
        advice: str = None,
        type: str = None,
        request_id: str = None,
        description: str = None,
        item: str = None,
        check_id: int = None,
        level: str = None,
        prompt: str = None,
    ):
        self.advice = advice
        self.type = type
        self.request_id = request_id
        self.description = description
        self.item = item
        self.check_id = check_id
        self.level = level
        self.prompt = prompt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.type is not None:
            result['Type'] = self.type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.description is not None:
            result['Description'] = self.description
        if self.item is not None:
            result['Item'] = self.item
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.level is not None:
            result['Level'] = self.level
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        return self


class DescribeCheckWarningDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCheckWarningDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningsRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        uuid: str = None,
        risk_id: int = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.uuid = uuid
        self.risk_id = risk_id
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeCheckWarningsResponseBodyCheckWarnings(TeaModel):
    def __init__(
        self,
        status: int = None,
        check_warning_id: int = None,
        type: str = None,
        uuid: str = None,
        item: str = None,
        check_id: int = None,
        level: str = None,
    ):
        self.status = status
        self.check_warning_id = check_warning_id
        self.type = type
        self.uuid = uuid
        self.item = item
        self.check_id = check_id
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.check_warning_id is not None:
            result['CheckWarningId'] = self.check_warning_id
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.item is not None:
            result['Item'] = self.item
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CheckWarningId') is not None:
            self.check_warning_id = m.get('CheckWarningId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeCheckWarningsResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        count: int = None,
        check_warnings: List[DescribeCheckWarningsResponseBodyCheckWarnings] = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.count = count
        self.check_warnings = check_warnings

    def validate(self):
        if self.check_warnings:
            for k in self.check_warnings:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        result['CheckWarnings'] = []
        if self.check_warnings is not None:
            for k in self.check_warnings:
                result['CheckWarnings'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.check_warnings = []
        if m.get('CheckWarnings') is not None:
            for k in m.get('CheckWarnings'):
                temp_model = DescribeCheckWarningsResponseBodyCheckWarnings()
                self.check_warnings.append(temp_model.from_map(k))
        return self


class DescribeCheckWarningsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCheckWarningsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningSummaryRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        type_name: str = None,
        status: str = None,
        risk_status: int = None,
        risk_name: str = None,
        strategy_id: int = None,
        uuids: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.type_name = type_name
        self.status = status
        self.risk_status = risk_status
        self.risk_name = risk_name
        self.strategy_id = strategy_id
        self.uuids = uuids
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        if self.status is not None:
            result['Status'] = self.status
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeCheckWarningSummaryResponseBodyWarningSummarys(TeaModel):
    def __init__(
        self,
        low_warning_count: int = None,
        check_count: int = None,
        medium_warning_count: int = None,
        last_found_time: str = None,
        risk_id: int = None,
        sub_type_alias: str = None,
        warning_machine_count: int = None,
        high_warning_count: int = None,
        type_alias: str = None,
        risk_name: str = None,
        level: str = None,
    ):
        self.low_warning_count = low_warning_count
        self.check_count = check_count
        self.medium_warning_count = medium_warning_count
        self.last_found_time = last_found_time
        self.risk_id = risk_id
        self.sub_type_alias = sub_type_alias
        self.warning_machine_count = warning_machine_count
        self.high_warning_count = high_warning_count
        self.type_alias = type_alias
        self.risk_name = risk_name
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.low_warning_count is not None:
            result['LowWarningCount'] = self.low_warning_count
        if self.check_count is not None:
            result['CheckCount'] = self.check_count
        if self.medium_warning_count is not None:
            result['MediumWarningCount'] = self.medium_warning_count
        if self.last_found_time is not None:
            result['LastFoundTime'] = self.last_found_time
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.sub_type_alias is not None:
            result['SubTypeAlias'] = self.sub_type_alias
        if self.warning_machine_count is not None:
            result['WarningMachineCount'] = self.warning_machine_count
        if self.high_warning_count is not None:
            result['HighWarningCount'] = self.high_warning_count
        if self.type_alias is not None:
            result['TypeAlias'] = self.type_alias
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LowWarningCount') is not None:
            self.low_warning_count = m.get('LowWarningCount')
        if m.get('CheckCount') is not None:
            self.check_count = m.get('CheckCount')
        if m.get('MediumWarningCount') is not None:
            self.medium_warning_count = m.get('MediumWarningCount')
        if m.get('LastFoundTime') is not None:
            self.last_found_time = m.get('LastFoundTime')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('SubTypeAlias') is not None:
            self.sub_type_alias = m.get('SubTypeAlias')
        if m.get('WarningMachineCount') is not None:
            self.warning_machine_count = m.get('WarningMachineCount')
        if m.get('HighWarningCount') is not None:
            self.high_warning_count = m.get('HighWarningCount')
        if m.get('TypeAlias') is not None:
            self.type_alias = m.get('TypeAlias')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeCheckWarningSummaryResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        count: int = None,
        warning_summarys: List[DescribeCheckWarningSummaryResponseBodyWarningSummarys] = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.count = count
        self.warning_summarys = warning_summarys

    def validate(self):
        if self.warning_summarys:
            for k in self.warning_summarys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        result['WarningSummarys'] = []
        if self.warning_summarys is not None:
            for k in self.warning_summarys:
                result['WarningSummarys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.warning_summarys = []
        if m.get('WarningSummarys') is not None:
            for k in m.get('WarningSummarys'):
                temp_model = DescribeCheckWarningSummaryResponseBodyWarningSummarys()
                self.warning_summarys.append(temp_model.from_map(k))
        return self


class DescribeCheckWarningSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCheckWarningSummaryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudCenterInstancesRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        criteria: str = None,
        machine_types: str = None,
        logical_exp: str = None,
        no_page: bool = None,
        page_size: int = None,
        current_page: int = None,
        importance: int = None,
    ):
        self.region_id = region_id
        self.criteria = criteria
        self.machine_types = machine_types
        self.logical_exp = logical_exp
        self.no_page = no_page
        self.page_size = page_size
        self.current_page = current_page
        self.importance = importance

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.no_page is not None:
            result['NoPage'] = self.no_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.importance is not None:
            result['Importance'] = self.importance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('NoPage') is not None:
            self.no_page = m.get('NoPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Importance') is not None:
            self.importance = m.get('Importance')
        return self


class DescribeCloudCenterInstancesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeCloudCenterInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        status: str = None,
        internet_ip: str = None,
        bind: bool = None,
        os_name: str = None,
        tag: str = None,
        client_status: str = None,
        vpc_instance_id: str = None,
        flag: int = None,
        auth_version: int = None,
        region: str = None,
        instance_name: str = None,
        pod_count: int = None,
        vul_count: int = None,
        hc_status: str = None,
        created_time: int = None,
        cluster_id: str = None,
        risk_status: str = None,
        cores: int = None,
        vul_status: str = None,
        alarm_status: str = None,
        importance: int = None,
        health_check_count: int = None,
        ip: str = None,
        os: str = None,
        auth_modify_time: int = None,
        exposed_count: int = None,
        safe_event_count: int = None,
        instance_id: str = None,
        asset_type: str = None,
        intranet_ip: str = None,
        vendor: int = None,
        region_id: str = None,
        uuid: str = None,
        auto_snapshots_level: int = None,
        group_id: str = None,
        region_name: str = None,
        vendor_name: str = None,
        cluster_name: str = None,
        exposed_status: int = None,
        risk_count: str = None,
        client_version: str = None,
    ):
        self.status = status
        self.internet_ip = internet_ip
        self.bind = bind
        self.os_name = os_name
        self.tag = tag
        self.client_status = client_status
        self.vpc_instance_id = vpc_instance_id
        self.flag = flag
        self.auth_version = auth_version
        self.region = region
        self.instance_name = instance_name
        self.pod_count = pod_count
        self.vul_count = vul_count
        self.hc_status = hc_status
        self.created_time = created_time
        self.cluster_id = cluster_id
        self.risk_status = risk_status
        self.cores = cores
        self.vul_status = vul_status
        self.alarm_status = alarm_status
        self.importance = importance
        self.health_check_count = health_check_count
        self.ip = ip
        self.os = os
        self.auth_modify_time = auth_modify_time
        self.exposed_count = exposed_count
        self.safe_event_count = safe_event_count
        self.instance_id = instance_id
        self.asset_type = asset_type
        self.intranet_ip = intranet_ip
        self.vendor = vendor
        self.region_id = region_id
        self.uuid = uuid
        self.auto_snapshots_level = auto_snapshots_level
        self.group_id = group_id
        self.region_name = region_name
        self.vendor_name = vendor_name
        self.cluster_name = cluster_name
        self.exposed_status = exposed_status
        self.risk_count = risk_count
        self.client_version = client_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.auth_version is not None:
            result['AuthVersion'] = self.auth_version
        if self.region is not None:
            result['Region'] = self.region
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.pod_count is not None:
            result['PodCount'] = self.pod_count
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        if self.hc_status is not None:
            result['HcStatus'] = self.hc_status
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.vul_status is not None:
            result['VulStatus'] = self.vul_status
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.importance is not None:
            result['Importance'] = self.importance
        if self.health_check_count is not None:
            result['HealthCheckCount'] = self.health_check_count
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.os is not None:
            result['Os'] = self.os
        if self.auth_modify_time is not None:
            result['AuthModifyTime'] = self.auth_modify_time
        if self.exposed_count is not None:
            result['ExposedCount'] = self.exposed_count
        if self.safe_event_count is not None:
            result['SafeEventCount'] = self.safe_event_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.auto_snapshots_level is not None:
            result['AutoSnapshotsLevel'] = self.auto_snapshots_level
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.vendor_name is not None:
            result['VendorName'] = self.vendor_name
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.exposed_status is not None:
            result['ExposedStatus'] = self.exposed_status
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('AuthVersion') is not None:
            self.auth_version = m.get('AuthVersion')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('PodCount') is not None:
            self.pod_count = m.get('PodCount')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        if m.get('HcStatus') is not None:
            self.hc_status = m.get('HcStatus')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('VulStatus') is not None:
            self.vul_status = m.get('VulStatus')
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('Importance') is not None:
            self.importance = m.get('Importance')
        if m.get('HealthCheckCount') is not None:
            self.health_check_count = m.get('HealthCheckCount')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('AuthModifyTime') is not None:
            self.auth_modify_time = m.get('AuthModifyTime')
        if m.get('ExposedCount') is not None:
            self.exposed_count = m.get('ExposedCount')
        if m.get('SafeEventCount') is not None:
            self.safe_event_count = m.get('SafeEventCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('AutoSnapshotsLevel') is not None:
            self.auto_snapshots_level = m.get('AutoSnapshotsLevel')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('VendorName') is not None:
            self.vendor_name = m.get('VendorName')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ExposedStatus') is not None:
            self.exposed_status = m.get('ExposedStatus')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        return self


class DescribeCloudCenterInstancesResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        page_info: DescribeCloudCenterInstancesResponseBodyPageInfo = None,
        instances: List[DescribeCloudCenterInstancesResponseBodyInstances] = None,
    ):
        self.success = success
        self.request_id = request_id
        self.page_info = page_info
        self.instances = instances

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeCloudCenterInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeCloudCenterInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        return self


class DescribeCloudCenterInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCloudCenterInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCloudCenterInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudProductFieldStatisticsResponseBodyGroupedFields(TeaModel):
    def __init__(
        self,
        category_count: str = None,
        instance_count: int = None,
        risk_instance_count: int = None,
    ):
        self.category_count = category_count
        self.instance_count = instance_count
        self.risk_instance_count = risk_instance_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_count is not None:
            result['CategoryCount'] = self.category_count
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryCount') is not None:
            self.category_count = m.get('CategoryCount')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        return self


class DescribeCloudProductFieldStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        grouped_fields: DescribeCloudProductFieldStatisticsResponseBodyGroupedFields = None,
    ):
        self.request_id = request_id
        self.grouped_fields = grouped_fields

    def validate(self):
        if self.grouped_fields:
            self.grouped_fields.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.grouped_fields is not None:
            result['GroupedFields'] = self.grouped_fields.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('GroupedFields') is not None:
            temp_model = DescribeCloudProductFieldStatisticsResponseBodyGroupedFields()
            self.grouped_fields = temp_model.from_map(m['GroupedFields'])
        return self


class DescribeCloudProductFieldStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCloudProductFieldStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCloudProductFieldStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeConcernNecessityRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeConcernNecessityResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        concern_necessity: List[str] = None,
    ):
        self.request_id = request_id
        self.concern_necessity = concern_necessity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.concern_necessity is not None:
            result['ConcernNecessity'] = self.concern_necessity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ConcernNecessity') is not None:
            self.concern_necessity = m.get('ConcernNecessity')
        return self


class DescribeConcernNecessityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeConcernNecessityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeConcernNecessityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContainerStatisticsRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
    ):
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeContainerStatisticsResponseBodyData(TeaModel):
    def __init__(
        self,
        total_node: int = None,
        remind_alarm_count: int = None,
        total_alarm_count: int = None,
        suspicious_alarm_count: int = None,
        serious_alarm_count: int = None,
        has_risk_node: int = None,
    ):
        self.total_node = total_node
        self.remind_alarm_count = remind_alarm_count
        self.total_alarm_count = total_alarm_count
        self.suspicious_alarm_count = suspicious_alarm_count
        self.serious_alarm_count = serious_alarm_count
        self.has_risk_node = has_risk_node

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_node is not None:
            result['TotalNode'] = self.total_node
        if self.remind_alarm_count is not None:
            result['RemindAlarmCount'] = self.remind_alarm_count
        if self.total_alarm_count is not None:
            result['TotalAlarmCount'] = self.total_alarm_count
        if self.suspicious_alarm_count is not None:
            result['SuspiciousAlarmCount'] = self.suspicious_alarm_count
        if self.serious_alarm_count is not None:
            result['SeriousAlarmCount'] = self.serious_alarm_count
        if self.has_risk_node is not None:
            result['hasRiskNode'] = self.has_risk_node
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalNode') is not None:
            self.total_node = m.get('TotalNode')
        if m.get('RemindAlarmCount') is not None:
            self.remind_alarm_count = m.get('RemindAlarmCount')
        if m.get('TotalAlarmCount') is not None:
            self.total_alarm_count = m.get('TotalAlarmCount')
        if m.get('SuspiciousAlarmCount') is not None:
            self.suspicious_alarm_count = m.get('SuspiciousAlarmCount')
        if m.get('SeriousAlarmCount') is not None:
            self.serious_alarm_count = m.get('SeriousAlarmCount')
        if m.get('hasRiskNode') is not None:
            self.has_risk_node = m.get('hasRiskNode')
        return self


class DescribeContainerStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: DescribeContainerStatisticsResponseBodyData = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = DescribeContainerStatisticsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DescribeContainerStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeContainerStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeContainerStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCriteriaRequest(TeaModel):
    def __init__(
        self,
        machine_types: str = None,
        value: str = None,
    ):
        self.machine_types = machine_types
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(
        self,
        type: str = None,
        name: str = None,
        values: str = None,
    ):
        self.type = type
        self.name = name
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.name is not None:
            result['Name'] = self.name
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeCriteriaResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        criteria_list: List[DescribeCriteriaResponseBodyCriteriaList] = None,
    ):
        self.request_id = request_id
        self.criteria_list = criteria_list

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        return self


class DescribeCriteriaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCriteriaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDialogMessagesRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
    ):
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDialogMessagesResponseBodyDialogList(TeaModel):
    def __init__(
        self,
        dialog_key: str = None,
        params: str = None,
        id: int = None,
    ):
        self.dialog_key = dialog_key
        self.params = params
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dialog_key is not None:
            result['DialogKey'] = self.dialog_key
        if self.params is not None:
            result['Params'] = self.params
        if self.id is not None:
            result['ID'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DialogKey') is not None:
            self.dialog_key = m.get('DialogKey')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('ID') is not None:
            self.id = m.get('ID')
        return self


class DescribeDialogMessagesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        dialog_list: List[DescribeDialogMessagesResponseBodyDialogList] = None,
    ):
        self.total_count = total_count
        self.request_id = request_id
        self.dialog_list = dialog_list

    def validate(self):
        if self.dialog_list:
            for k in self.dialog_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['DialogList'] = []
        if self.dialog_list is not None:
            for k in self.dialog_list:
                result['DialogList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.dialog_list = []
        if m.get('DialogList') is not None:
            for k in m.get('DialogList'):
                temp_model = DescribeDialogMessagesResponseBodyDialogList()
                self.dialog_list.append(temp_model.from_map(k))
        return self


class DescribeDialogMessagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDialogMessagesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDialogMessagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDingTalkRequest(TeaModel):
    def __init__(
        self,
        rule_action_name: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.rule_action_name = rule_action_name
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_action_name is not None:
            result['RuleActionName'] = self.rule_action_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleActionName') is not None:
            self.rule_action_name = m.get('RuleActionName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeDingTalkResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDingTalkResponseBodyActionList(TeaModel):
    def __init__(
        self,
        status: int = None,
        config_list: str = None,
        gmt_create: int = None,
        action_name: str = None,
        url: str = None,
        ali_uid: int = None,
        ding_talk_lang: str = None,
        interval_time: int = None,
        gmt_modified: int = None,
        group_id_list: str = None,
        id: int = None,
    ):
        self.status = status
        self.config_list = config_list
        self.gmt_create = gmt_create
        self.action_name = action_name
        self.url = url
        self.ali_uid = ali_uid
        self.ding_talk_lang = ding_talk_lang
        self.interval_time = interval_time
        self.gmt_modified = gmt_modified
        self.group_id_list = group_id_list
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.config_list is not None:
            result['ConfigList'] = self.config_list
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.action_name is not None:
            result['ActionName'] = self.action_name
        if self.url is not None:
            result['Url'] = self.url
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.ding_talk_lang is not None:
            result['DingTalkLang'] = self.ding_talk_lang
        if self.interval_time is not None:
            result['IntervalTime'] = self.interval_time
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ConfigList') is not None:
            self.config_list = m.get('ConfigList')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('ActionName') is not None:
            self.action_name = m.get('ActionName')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('DingTalkLang') is not None:
            self.ding_talk_lang = m.get('DingTalkLang')
        if m.get('IntervalTime') is not None:
            self.interval_time = m.get('IntervalTime')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeDingTalkResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeDingTalkResponseBodyPageInfo = None,
        action_list: List[DescribeDingTalkResponseBodyActionList] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.action_list = action_list

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.action_list:
            for k in self.action_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['ActionList'] = []
        if self.action_list is not None:
            for k in self.action_list:
                result['ActionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeDingTalkResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.action_list = []
        if m.get('ActionList') is not None:
            for k in m.get('ActionList'):
                temp_model = DescribeDingTalkResponseBodyActionList()
                self.action_list.append(temp_model.from_map(k))
        return self


class DescribeDingTalkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDingTalkResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDingTalkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainCountRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
    ):
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainCountResponseBody(TeaModel):
    def __init__(
        self,
        root_domains_count: int = None,
        request_id: str = None,
        sub_domains_count: int = None,
        total_domains_count: int = None,
    ):
        self.root_domains_count = root_domains_count
        self.request_id = request_id
        self.sub_domains_count = sub_domains_count
        self.total_domains_count = total_domains_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.root_domains_count is not None:
            result['RootDomainsCount'] = self.root_domains_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sub_domains_count is not None:
            result['SubDomainsCount'] = self.sub_domains_count
        if self.total_domains_count is not None:
            result['TotalDomainsCount'] = self.total_domains_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RootDomainsCount') is not None:
            self.root_domains_count = m.get('RootDomainsCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SubDomainsCount') is not None:
            self.sub_domains_count = m.get('SubDomainsCount')
        if m.get('TotalDomainsCount') is not None:
            self.total_domains_count = m.get('TotalDomainsCount')
        return self


class DescribeDomainCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDomainCountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDomainCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainDetailRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        domain_name: str = None,
    ):
        self.source_ip = source_ip
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeDomainDetailResponseBodyDomainDetailItems(TeaModel):
    def __init__(
        self,
        uuid: str = None,
        internet_ip: str = None,
        instance_name: str = None,
        instance_id: str = None,
        intranet_ip: str = None,
        asset_type: str = None,
    ):
        self.uuid = uuid
        self.internet_ip = internet_ip
        self.instance_name = instance_name
        self.instance_id = instance_id
        self.intranet_ip = intranet_ip
        self.asset_type = asset_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        return self


class DescribeDomainDetailResponseBody(TeaModel):
    def __init__(
        self,
        domain: str = None,
        request_id: str = None,
        vul_count: int = None,
        alarm_count: int = None,
        root_domain: str = None,
        domain_detail_items: List[DescribeDomainDetailResponseBodyDomainDetailItems] = None,
    ):
        self.domain = domain
        self.request_id = request_id
        self.vul_count = vul_count
        self.alarm_count = alarm_count
        self.root_domain = root_domain
        self.domain_detail_items = domain_detail_items

    def validate(self):
        if self.domain_detail_items:
            for k in self.domain_detail_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        if self.alarm_count is not None:
            result['AlarmCount'] = self.alarm_count
        if self.root_domain is not None:
            result['RootDomain'] = self.root_domain
        result['DomainDetailItems'] = []
        if self.domain_detail_items is not None:
            for k in self.domain_detail_items:
                result['DomainDetailItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        if m.get('AlarmCount') is not None:
            self.alarm_count = m.get('AlarmCount')
        if m.get('RootDomain') is not None:
            self.root_domain = m.get('RootDomain')
        self.domain_detail_items = []
        if m.get('DomainDetailItems') is not None:
            for k in m.get('DomainDetailItems'):
                temp_model = DescribeDomainDetailResponseBodyDomainDetailItems()
                self.domain_detail_items.append(temp_model.from_map(k))
        return self


class DescribeDomainDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDomainDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDomainDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainListRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        fuzzy_domain: str = None,
        domain_type: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.source_ip = source_ip
        self.fuzzy_domain = fuzzy_domain
        self.domain_type = domain_type
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.fuzzy_domain is not None:
            result['FuzzyDomain'] = self.fuzzy_domain
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('FuzzyDomain') is not None:
            self.fuzzy_domain = m.get('FuzzyDomain')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeDomainListResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeDomainListResponseBodyDomainListResponseList(TeaModel):
    def __init__(
        self,
        ip_list: str = None,
        domain: str = None,
    ):
        self.ip_list = ip_list
        self.domain = domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_list is not None:
            result['IpList'] = self.ip_list
        if self.domain is not None:
            result['Domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpList') is not None:
            self.ip_list = m.get('IpList')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        return self


class DescribeDomainListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeDomainListResponseBodyPageInfo = None,
        domain_list_response_list: List[DescribeDomainListResponseBodyDomainListResponseList] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.domain_list_response_list = domain_list_response_list

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.domain_list_response_list:
            for k in self.domain_list_response_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['DomainListResponseList'] = []
        if self.domain_list_response_list is not None:
            for k in self.domain_list_response_list:
                result['DomainListResponseList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeDomainListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.domain_list_response_list = []
        if m.get('DomainListResponseList') is not None:
            for k in m.get('DomainListResponseList'):
                temp_model = DescribeDomainListResponseBodyDomainListResponseList()
                self.domain_list_response_list.append(temp_model.from_map(k))
        return self


class DescribeDomainListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDomainListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDomainListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEmgVulItemRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        risk_status: str = None,
        scan_type: str = None,
        vul_name: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.lang = lang
        self.risk_status = risk_status
        self.scan_type = scan_type
        self.vul_name = vul_name
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.scan_type is not None:
            result['ScanType'] = self.scan_type
        if self.vul_name is not None:
            result['VulName'] = self.vul_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('ScanType') is not None:
            self.scan_type = m.get('ScanType')
        if m.get('VulName') is not None:
            self.vul_name = m.get('VulName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeEmgVulItemResponseBodyGroupedVulItems(TeaModel):
    def __init__(
        self,
        status: int = None,
        type: str = None,
        gmt_last_check: int = None,
        progress: int = None,
        gmt_publish: int = None,
        pending_count: int = None,
        alias_name: str = None,
        name: str = None,
    ):
        self.status = status
        self.type = type
        self.gmt_last_check = gmt_last_check
        self.progress = progress
        self.gmt_publish = gmt_publish
        self.pending_count = pending_count
        self.alias_name = alias_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_last_check is not None:
            result['GmtLastCheck'] = self.gmt_last_check
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.gmt_publish is not None:
            result['GmtPublish'] = self.gmt_publish
        if self.pending_count is not None:
            result['PendingCount'] = self.pending_count
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtLastCheck') is not None:
            self.gmt_last_check = m.get('GmtLastCheck')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('GmtPublish') is not None:
            self.gmt_publish = m.get('GmtPublish')
        if m.get('PendingCount') is not None:
            self.pending_count = m.get('PendingCount')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeEmgVulItemResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        request_id: str = None,
        page_size: int = None,
        total_count: int = None,
        grouped_vul_items: List[DescribeEmgVulItemResponseBodyGroupedVulItems] = None,
    ):
        self.current_page = current_page
        self.request_id = request_id
        self.page_size = page_size
        self.total_count = total_count
        self.grouped_vul_items = grouped_vul_items

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeEmgVulItemResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        return self


class DescribeEmgVulItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeEmgVulItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeEmgVulItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExcludeSystemPathRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeExcludeSystemPathResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeExcludeSystemPathResponseBodyExcludePaths(TeaModel):
    def __init__(
        self,
        path: str = None,
        os: str = None,
        id: int = None,
    ):
        self.path = path
        self.os = os
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.os is not None:
            result['Os'] = self.os
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeExcludeSystemPathResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeExcludeSystemPathResponseBodyPageInfo = None,
        exclude_paths: List[DescribeExcludeSystemPathResponseBodyExcludePaths] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.exclude_paths = exclude_paths

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.exclude_paths:
            for k in self.exclude_paths:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['ExcludePaths'] = []
        if self.exclude_paths is not None:
            for k in self.exclude_paths:
                result['ExcludePaths'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeExcludeSystemPathResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.exclude_paths = []
        if m.get('ExcludePaths') is not None:
            for k in m.get('ExcludePaths'):
                temp_model = DescribeExcludeSystemPathResponseBodyExcludePaths()
                self.exclude_paths.append(temp_model.from_map(k))
        return self


class DescribeExcludeSystemPathResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExcludeSystemPathResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExcludeSystemPathResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExportInfoRequest(TeaModel):
    def __init__(
        self,
        export_id: int = None,
    ):
        self.export_id = export_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_id is not None:
            result['ExportId'] = self.export_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExportId') is not None:
            self.export_id = m.get('ExportId')
        return self


class DescribeExportInfoResponseBody(TeaModel):
    def __init__(
        self,
        link: str = None,
        progress: int = None,
        request_id: str = None,
        current_count: int = None,
        message: str = None,
        file_name: str = None,
        total_count: int = None,
        export_status: str = None,
        id: int = None,
    ):
        self.link = link
        self.progress = progress
        self.request_id = request_id
        self.current_count = current_count
        self.message = message
        self.file_name = file_name
        self.total_count = total_count
        self.export_status = export_status
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.link is not None:
            result['Link'] = self.link
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.message is not None:
            result['Message'] = self.message
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.export_status is not None:
            result['ExportStatus'] = self.export_status
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ExportStatus') is not None:
            self.export_status = m.get('ExportStatus')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeExportInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExportInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExportInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceCriteriaRequest(TeaModel):
    def __init__(
        self,
        value: str = None,
    ):
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeExposedInstanceCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(
        self,
        type: str = None,
        name: str = None,
        values: str = None,
    ):
        self.type = type
        self.name = name
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.name is not None:
            result['Name'] = self.name
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeExposedInstanceCriteriaResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        criteria_list: List[DescribeExposedInstanceCriteriaResponseBodyCriteriaList] = None,
    ):
        self.request_id = request_id
        self.criteria_list = criteria_list

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeExposedInstanceCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        return self


class DescribeExposedInstanceCriteriaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExposedInstanceCriteriaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceDetailRequest(TeaModel):
    def __init__(
        self,
        uuid: str = None,
    ):
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList(TeaModel):
    def __init__(
        self,
        type: str = None,
        necessity: str = None,
        uuid: str = None,
        alias_name: str = None,
        name: str = None,
    ):
        self.type = type
        self.necessity = necessity
        self.uuid = uuid
        self.alias_name = alias_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList(TeaModel):
    def __init__(
        self,
        type: str = None,
        necessity: str = None,
        uuid: str = None,
        alias_name: str = None,
        name: str = None,
    ):
        self.type = type
        self.necessity = necessity
        self.uuid = uuid
        self.alias_name = alias_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChains(TeaModel):
    def __init__(
        self,
        exposure_ip: str = None,
        group_no: str = None,
        internet_ip: str = None,
        instance_id: str = None,
        exposure_type: str = None,
        intranet_ip: str = None,
        exposure_type_id: str = None,
        region_id: str = None,
        uuid: str = None,
        exposure_port: str = None,
        instance_name: str = None,
        exposure_component: str = None,
        real_vul_list: List[DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList] = None,
        all_vul_list: List[DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList] = None,
    ):
        self.exposure_ip = exposure_ip
        self.group_no = group_no
        self.internet_ip = internet_ip
        self.instance_id = instance_id
        self.exposure_type = exposure_type
        self.intranet_ip = intranet_ip
        self.exposure_type_id = exposure_type_id
        self.region_id = region_id
        self.uuid = uuid
        self.exposure_port = exposure_port
        self.instance_name = instance_name
        self.exposure_component = exposure_component
        self.real_vul_list = real_vul_list
        self.all_vul_list = all_vul_list

    def validate(self):
        if self.real_vul_list:
            for k in self.real_vul_list:
                if k:
                    k.validate()
        if self.all_vul_list:
            for k in self.all_vul_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.group_no is not None:
            result['GroupNo'] = self.group_no
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        result['RealVulList'] = []
        if self.real_vul_list is not None:
            for k in self.real_vul_list:
                result['RealVulList'].append(k.to_map() if k else None)
        result['AllVulList'] = []
        if self.all_vul_list is not None:
            for k in self.all_vul_list:
                result['AllVulList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('GroupNo') is not None:
            self.group_no = m.get('GroupNo')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        self.real_vul_list = []
        if m.get('RealVulList') is not None:
            for k in m.get('RealVulList'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList()
                self.real_vul_list.append(temp_model.from_map(k))
        self.all_vul_list = []
        if m.get('AllVulList') is not None:
            for k in m.get('AllVulList'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList()
                self.all_vul_list.append(temp_model.from_map(k))
        return self


class DescribeExposedInstanceDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        exposed_chains: List[DescribeExposedInstanceDetailResponseBodyExposedChains] = None,
    ):
        self.request_id = request_id
        self.exposed_chains = exposed_chains

    def validate(self):
        if self.exposed_chains:
            for k in self.exposed_chains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ExposedChains'] = []
        if self.exposed_chains is not None:
            for k in self.exposed_chains:
                result['ExposedChains'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.exposed_chains = []
        if m.get('ExposedChains') is not None:
            for k in m.get('ExposedChains'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChains()
                self.exposed_chains.append(temp_model.from_map(k))
        return self


class DescribeExposedInstanceDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExposedInstanceDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceListRequest(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        current_page: int = None,
        group_id: int = None,
        vul_status: bool = None,
        health_status: bool = None,
        exposure_component: str = None,
        exposure_port: str = None,
        exposure_ip: str = None,
        instance_id: str = None,
        instance_name: str = None,
    ):
        self.page_size = page_size
        self.current_page = current_page
        self.group_id = group_id
        self.vul_status = vul_status
        self.health_status = health_status
        self.exposure_component = exposure_component
        self.exposure_port = exposure_port
        self.exposure_ip = exposure_ip
        self.instance_id = instance_id
        self.instance_name = instance_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.vul_status is not None:
            result['VulStatus'] = self.vul_status
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('VulStatus') is not None:
            self.vul_status = m.get('VulStatus')
        if m.get('HealthStatus') is not None:
            self.health_status = m.get('HealthStatus')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        return self


class DescribeExposedInstanceListResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeExposedInstanceListResponseBodyExposedInstances(TeaModel):
    def __init__(
        self,
        exposure_ip: str = None,
        total_vul_count: int = None,
        internet_ip: str = None,
        nntf_vul_count: int = None,
        instance_id: str = None,
        exposure_type: str = None,
        intranet_ip: str = None,
        region_id: str = None,
        exposure_type_id: str = None,
        asap_vul_count: int = None,
        exposure_port: str = None,
        uuid: str = None,
        group_name: str = None,
        group_id: int = None,
        exploit_health_count: int = None,
        instance_name: str = None,
        exposure_component: str = None,
        later_vul_count: int = None,
    ):
        self.exposure_ip = exposure_ip
        self.total_vul_count = total_vul_count
        self.internet_ip = internet_ip
        self.nntf_vul_count = nntf_vul_count
        self.instance_id = instance_id
        self.exposure_type = exposure_type
        self.intranet_ip = intranet_ip
        self.region_id = region_id
        self.exposure_type_id = exposure_type_id
        self.asap_vul_count = asap_vul_count
        self.exposure_port = exposure_port
        self.uuid = uuid
        self.group_name = group_name
        self.group_id = group_id
        self.exploit_health_count = exploit_health_count
        self.instance_name = instance_name
        self.exposure_component = exposure_component
        self.later_vul_count = later_vul_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.total_vul_count is not None:
            result['TotalVulCount'] = self.total_vul_count
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.nntf_vul_count is not None:
            result['NntfVulCount'] = self.nntf_vul_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.asap_vul_count is not None:
            result['AsapVulCount'] = self.asap_vul_count
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.exploit_health_count is not None:
            result['ExploitHealthCount'] = self.exploit_health_count
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.later_vul_count is not None:
            result['LaterVulCount'] = self.later_vul_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('TotalVulCount') is not None:
            self.total_vul_count = m.get('TotalVulCount')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('NntfVulCount') is not None:
            self.nntf_vul_count = m.get('NntfVulCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('AsapVulCount') is not None:
            self.asap_vul_count = m.get('AsapVulCount')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ExploitHealthCount') is not None:
            self.exploit_health_count = m.get('ExploitHealthCount')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('LaterVulCount') is not None:
            self.later_vul_count = m.get('LaterVulCount')
        return self


class DescribeExposedInstanceListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeExposedInstanceListResponseBodyPageInfo = None,
        exposed_instances: List[DescribeExposedInstanceListResponseBodyExposedInstances] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.exposed_instances = exposed_instances

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.exposed_instances:
            for k in self.exposed_instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['ExposedInstances'] = []
        if self.exposed_instances is not None:
            for k in self.exposed_instances:
                result['ExposedInstances'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeExposedInstanceListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.exposed_instances = []
        if m.get('ExposedInstances') is not None:
            for k in m.get('ExposedInstances'):
                temp_model = DescribeExposedInstanceListResponseBodyExposedInstances()
                self.exposed_instances.append(temp_model.from_map(k))
        return self


class DescribeExposedInstanceListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExposedInstanceListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        exposed_later_vul_count: int = None,
        exposed_component_count: int = None,
        exposed_port_count: int = None,
        exposed_instance_count: int = None,
        exposed_week_password_machine_count: int = None,
        exposed_nntf_vul_count: int = None,
        gateway_asset_count: int = None,
        exposed_ip_count: int = None,
        exposed_asap_vul_count: int = None,
    ):
        self.request_id = request_id
        self.exposed_later_vul_count = exposed_later_vul_count
        self.exposed_component_count = exposed_component_count
        self.exposed_port_count = exposed_port_count
        self.exposed_instance_count = exposed_instance_count
        self.exposed_week_password_machine_count = exposed_week_password_machine_count
        self.exposed_nntf_vul_count = exposed_nntf_vul_count
        self.gateway_asset_count = gateway_asset_count
        self.exposed_ip_count = exposed_ip_count
        self.exposed_asap_vul_count = exposed_asap_vul_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.exposed_later_vul_count is not None:
            result['ExposedLaterVulCount'] = self.exposed_later_vul_count
        if self.exposed_component_count is not None:
            result['ExposedComponentCount'] = self.exposed_component_count
        if self.exposed_port_count is not None:
            result['ExposedPortCount'] = self.exposed_port_count
        if self.exposed_instance_count is not None:
            result['ExposedInstanceCount'] = self.exposed_instance_count
        if self.exposed_week_password_machine_count is not None:
            result['ExposedWeekPasswordMachineCount'] = self.exposed_week_password_machine_count
        if self.exposed_nntf_vul_count is not None:
            result['ExposedNntfVulCount'] = self.exposed_nntf_vul_count
        if self.gateway_asset_count is not None:
            result['GatewayAssetCount'] = self.gateway_asset_count
        if self.exposed_ip_count is not None:
            result['ExposedIpCount'] = self.exposed_ip_count
        if self.exposed_asap_vul_count is not None:
            result['ExposedAsapVulCount'] = self.exposed_asap_vul_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ExposedLaterVulCount') is not None:
            self.exposed_later_vul_count = m.get('ExposedLaterVulCount')
        if m.get('ExposedComponentCount') is not None:
            self.exposed_component_count = m.get('ExposedComponentCount')
        if m.get('ExposedPortCount') is not None:
            self.exposed_port_count = m.get('ExposedPortCount')
        if m.get('ExposedInstanceCount') is not None:
            self.exposed_instance_count = m.get('ExposedInstanceCount')
        if m.get('ExposedWeekPasswordMachineCount') is not None:
            self.exposed_week_password_machine_count = m.get('ExposedWeekPasswordMachineCount')
        if m.get('ExposedNntfVulCount') is not None:
            self.exposed_nntf_vul_count = m.get('ExposedNntfVulCount')
        if m.get('GatewayAssetCount') is not None:
            self.gateway_asset_count = m.get('GatewayAssetCount')
        if m.get('ExposedIpCount') is not None:
            self.exposed_ip_count = m.get('ExposedIpCount')
        if m.get('ExposedAsapVulCount') is not None:
            self.exposed_asap_vul_count = m.get('ExposedAsapVulCount')
        return self


class DescribeExposedStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExposedStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedStatisticsDetailRequest(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        current_page: int = None,
        statistics_type: str = None,
        statistics_type_instance_value: str = None,
        statistics_type_gateway_type: str = None,
    ):
        self.page_size = page_size
        self.current_page = current_page
        self.statistics_type = statistics_type
        self.statistics_type_instance_value = statistics_type_instance_value
        self.statistics_type_gateway_type = statistics_type_gateway_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.statistics_type is not None:
            result['StatisticsType'] = self.statistics_type
        if self.statistics_type_instance_value is not None:
            result['StatisticsTypeInstanceValue'] = self.statistics_type_instance_value
        if self.statistics_type_gateway_type is not None:
            result['StatisticsTypeGatewayType'] = self.statistics_type_gateway_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('StatisticsType') is not None:
            self.statistics_type = m.get('StatisticsType')
        if m.get('StatisticsTypeInstanceValue') is not None:
            self.statistics_type_instance_value = m.get('StatisticsTypeInstanceValue')
        if m.get('StatisticsTypeGatewayType') is not None:
            self.statistics_type_gateway_type = m.get('StatisticsTypeGatewayType')
        return self


class DescribeExposedStatisticsDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeExposedStatisticsDetailResponseBodyStatisticsDetails(TeaModel):
    def __init__(
        self,
        exposure_ip: str = None,
        exposure_port: str = None,
        exposure_type_instance_name: str = None,
        exposed_count: int = None,
        exposure_type: str = None,
        region_id: str = None,
        exposure_component: str = None,
        exposure_type_id: str = None,
    ):
        self.exposure_ip = exposure_ip
        self.exposure_port = exposure_port
        self.exposure_type_instance_name = exposure_type_instance_name
        self.exposed_count = exposed_count
        self.exposure_type = exposure_type
        self.region_id = region_id
        self.exposure_component = exposure_component
        self.exposure_type_id = exposure_type_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_type_instance_name is not None:
            result['ExposureTypeInstanceName'] = self.exposure_type_instance_name
        if self.exposed_count is not None:
            result['ExposedCount'] = self.exposed_count
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureTypeInstanceName') is not None:
            self.exposure_type_instance_name = m.get('ExposureTypeInstanceName')
        if m.get('ExposedCount') is not None:
            self.exposed_count = m.get('ExposedCount')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        return self


class DescribeExposedStatisticsDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeExposedStatisticsDetailResponseBodyPageInfo = None,
        statistics_details: List[DescribeExposedStatisticsDetailResponseBodyStatisticsDetails] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.statistics_details = statistics_details

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.statistics_details:
            for k in self.statistics_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['StatisticsDetails'] = []
        if self.statistics_details is not None:
            for k in self.statistics_details:
                result['StatisticsDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeExposedStatisticsDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.statistics_details = []
        if m.get('StatisticsDetails') is not None:
            for k in m.get('StatisticsDetails'):
                temp_model = DescribeExposedStatisticsDetailResponseBodyStatisticsDetails()
                self.statistics_details.append(temp_model.from_map(k))
        return self


class DescribeExposedStatisticsDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExposedStatisticsDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedStatisticsDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFieldStatisticsRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        machine_types: str = None,
    ):
        self.region_id = region_id
        self.machine_types = machine_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        return self


class DescribeFieldStatisticsResponseBodyGroupedFields(TeaModel):
    def __init__(
        self,
        offline_instance_count: int = None,
        region_count: int = None,
        new_instance_count: int = None,
        exposed_instance_count: int = None,
        group_count: int = None,
        tencent_instance_count: int = None,
        general_asset_count: int = None,
        instance_sync_task_count: int = None,
        unprotected_instance_count: int = None,
        important_asset_count: int = None,
        test_asset_count: int = None,
        vpc_count: int = None,
        instance_count: int = None,
        idc_instance_count: int = None,
        not_running_status_count: int = None,
        ali_yun_instance_count: int = None,
        risk_instance_count: int = None,
    ):
        self.offline_instance_count = offline_instance_count
        self.region_count = region_count
        self.new_instance_count = new_instance_count
        self.exposed_instance_count = exposed_instance_count
        self.group_count = group_count
        self.tencent_instance_count = tencent_instance_count
        self.general_asset_count = general_asset_count
        self.instance_sync_task_count = instance_sync_task_count
        self.unprotected_instance_count = unprotected_instance_count
        self.important_asset_count = important_asset_count
        self.test_asset_count = test_asset_count
        self.vpc_count = vpc_count
        self.instance_count = instance_count
        self.idc_instance_count = idc_instance_count
        self.not_running_status_count = not_running_status_count
        self.ali_yun_instance_count = ali_yun_instance_count
        self.risk_instance_count = risk_instance_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.offline_instance_count is not None:
            result['OfflineInstanceCount'] = self.offline_instance_count
        if self.region_count is not None:
            result['RegionCount'] = self.region_count
        if self.new_instance_count is not None:
            result['NewInstanceCount'] = self.new_instance_count
        if self.exposed_instance_count is not None:
            result['ExposedInstanceCount'] = self.exposed_instance_count
        if self.group_count is not None:
            result['GroupCount'] = self.group_count
        if self.tencent_instance_count is not None:
            result['TencentInstanceCount'] = self.tencent_instance_count
        if self.general_asset_count is not None:
            result['GeneralAssetCount'] = self.general_asset_count
        if self.instance_sync_task_count is not None:
            result['InstanceSyncTaskCount'] = self.instance_sync_task_count
        if self.unprotected_instance_count is not None:
            result['UnprotectedInstanceCount'] = self.unprotected_instance_count
        if self.important_asset_count is not None:
            result['ImportantAssetCount'] = self.important_asset_count
        if self.test_asset_count is not None:
            result['TestAssetCount'] = self.test_asset_count
        if self.vpc_count is not None:
            result['VpcCount'] = self.vpc_count
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.idc_instance_count is not None:
            result['IdcInstanceCount'] = self.idc_instance_count
        if self.not_running_status_count is not None:
            result['NotRunningStatusCount'] = self.not_running_status_count
        if self.ali_yun_instance_count is not None:
            result['AliYunInstanceCount'] = self.ali_yun_instance_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OfflineInstanceCount') is not None:
            self.offline_instance_count = m.get('OfflineInstanceCount')
        if m.get('RegionCount') is not None:
            self.region_count = m.get('RegionCount')
        if m.get('NewInstanceCount') is not None:
            self.new_instance_count = m.get('NewInstanceCount')
        if m.get('ExposedInstanceCount') is not None:
            self.exposed_instance_count = m.get('ExposedInstanceCount')
        if m.get('GroupCount') is not None:
            self.group_count = m.get('GroupCount')
        if m.get('TencentInstanceCount') is not None:
            self.tencent_instance_count = m.get('TencentInstanceCount')
        if m.get('GeneralAssetCount') is not None:
            self.general_asset_count = m.get('GeneralAssetCount')
        if m.get('InstanceSyncTaskCount') is not None:
            self.instance_sync_task_count = m.get('InstanceSyncTaskCount')
        if m.get('UnprotectedInstanceCount') is not None:
            self.unprotected_instance_count = m.get('UnprotectedInstanceCount')
        if m.get('ImportantAssetCount') is not None:
            self.important_asset_count = m.get('ImportantAssetCount')
        if m.get('TestAssetCount') is not None:
            self.test_asset_count = m.get('TestAssetCount')
        if m.get('VpcCount') is not None:
            self.vpc_count = m.get('VpcCount')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('IdcInstanceCount') is not None:
            self.idc_instance_count = m.get('IdcInstanceCount')
        if m.get('NotRunningStatusCount') is not None:
            self.not_running_status_count = m.get('NotRunningStatusCount')
        if m.get('AliYunInstanceCount') is not None:
            self.ali_yun_instance_count = m.get('AliYunInstanceCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        return self


class DescribeFieldStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        grouped_fields: DescribeFieldStatisticsResponseBodyGroupedFields = None,
    ):
        self.request_id = request_id
        self.grouped_fields = grouped_fields

    def validate(self):
        if self.grouped_fields:
            self.grouped_fields.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.grouped_fields is not None:
            result['GroupedFields'] = self.grouped_fields.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('GroupedFields') is not None:
            temp_model = DescribeFieldStatisticsResponseBodyGroupedFields()
            self.grouped_fields = temp_model.from_map(m['GroupedFields'])
        return self


class DescribeFieldStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFieldStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFieldStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFrontVulPatchListRequest(TeaModel):
    def __init__(
        self,
        info: str = None,
        operate_type: str = None,
        type: str = None,
    ):
        self.info = info
        self.operate_type = operate_type
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info is not None:
            result['Info'] = self.info
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeFrontVulPatchListResponseBodyFrontPatchListPatchList(TeaModel):
    def __init__(
        self,
        name: str = None,
        alias_name: str = None,
    ):
        self.name = name
        self.alias_name = alias_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        return self


class DescribeFrontVulPatchListResponseBodyFrontPatchList(TeaModel):
    def __init__(
        self,
        uuid: str = None,
        patch_list: List[DescribeFrontVulPatchListResponseBodyFrontPatchListPatchList] = None,
    ):
        self.uuid = uuid
        self.patch_list = patch_list

    def validate(self):
        if self.patch_list:
            for k in self.patch_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        result['PatchList'] = []
        if self.patch_list is not None:
            for k in self.patch_list:
                result['PatchList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        self.patch_list = []
        if m.get('PatchList') is not None:
            for k in m.get('PatchList'):
                temp_model = DescribeFrontVulPatchListResponseBodyFrontPatchListPatchList()
                self.patch_list.append(temp_model.from_map(k))
        return self


class DescribeFrontVulPatchListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        front_patch_list: List[DescribeFrontVulPatchListResponseBodyFrontPatchList] = None,
    ):
        self.request_id = request_id
        self.front_patch_list = front_patch_list

    def validate(self):
        if self.front_patch_list:
            for k in self.front_patch_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['FrontPatchList'] = []
        if self.front_patch_list is not None:
            for k in self.front_patch_list:
                result['FrontPatchList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.front_patch_list = []
        if m.get('FrontPatchList') is not None:
            for k in m.get('FrontPatchList'):
                temp_model = DescribeFrontVulPatchListResponseBodyFrontPatchList()
                self.front_patch_list.append(temp_model.from_map(k))
        return self


class DescribeFrontVulPatchListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFrontVulPatchListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFrontVulPatchListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGraph4InvestigationOnlineRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        namespace: str = None,
        vertex_id: str = None,
        anomaly_uuid: str = None,
        anomaly_id: str = None,
        path_length: int = None,
        direction: str = None,
    ):
        self.lang = lang
        self.namespace = namespace
        self.vertex_id = vertex_id
        self.anomaly_uuid = anomaly_uuid
        self.anomaly_id = anomaly_id
        self.path_length = path_length
        self.direction = direction

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.vertex_id is not None:
            result['VertexId'] = self.vertex_id
        if self.anomaly_uuid is not None:
            result['AnomalyUuid'] = self.anomaly_uuid
        if self.anomaly_id is not None:
            result['AnomalyId'] = self.anomaly_id
        if self.path_length is not None:
            result['PathLength'] = self.path_length
        if self.direction is not None:
            result['Direction'] = self.direction
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('VertexId') is not None:
            self.vertex_id = m.get('VertexId')
        if m.get('AnomalyUuid') is not None:
            self.anomaly_uuid = m.get('AnomalyUuid')
        if m.get('AnomalyId') is not None:
            self.anomaly_id = m.get('AnomalyId')
        if m.get('PathLength') is not None:
            self.path_length = m.get('PathLength')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        return self


class DescribeGraph4InvestigationOnlineResponseBodyDataVertexListNeighborList(TeaModel):
    def __init__(
        self,
        type: str = None,
        has_more: bool = None,
        count: int = None,
    ):
        self.type = type
        self.has_more = has_more
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.has_more is not None:
            result['HasMore'] = self.has_more
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('HasMore') is not None:
            self.has_more = m.get('HasMore')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeGraph4InvestigationOnlineResponseBodyDataVertexList(TeaModel):
    def __init__(
        self,
        type: str = None,
        uuid: str = None,
        time: str = None,
        aliuid: str = None,
        position: str = None,
        position_id: str = None,
        name: str = None,
        id: str = None,
        properties: str = None,
        neighbor_list: List[DescribeGraph4InvestigationOnlineResponseBodyDataVertexListNeighborList] = None,
    ):
        self.type = type
        self.uuid = uuid
        self.time = time
        self.aliuid = aliuid
        self.position = position
        self.position_id = position_id
        self.name = name
        self.id = id
        self.properties = properties
        self.neighbor_list = neighbor_list

    def validate(self):
        if self.neighbor_list:
            for k in self.neighbor_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.time is not None:
            result['Time'] = self.time
        if self.aliuid is not None:
            result['Aliuid'] = self.aliuid
        if self.position is not None:
            result['Position'] = self.position
        if self.position_id is not None:
            result['PositionId'] = self.position_id
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.properties is not None:
            result['Properties'] = self.properties
        result['NeighborList'] = []
        if self.neighbor_list is not None:
            for k in self.neighbor_list:
                result['NeighborList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Aliuid') is not None:
            self.aliuid = m.get('Aliuid')
        if m.get('Position') is not None:
            self.position = m.get('Position')
        if m.get('PositionId') is not None:
            self.position_id = m.get('PositionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Properties') is not None:
            self.properties = m.get('Properties')
        self.neighbor_list = []
        if m.get('NeighborList') is not None:
            for k in m.get('NeighborList'):
                temp_model = DescribeGraph4InvestigationOnlineResponseBodyDataVertexListNeighborList()
                self.neighbor_list.append(temp_model.from_map(k))
        return self


class DescribeGraph4InvestigationOnlineResponseBodyDataEdgeList(TeaModel):
    def __init__(
        self,
        type: str = None,
        time: str = None,
        end_id: str = None,
        start_type: str = None,
        end_type: str = None,
        name: str = None,
        start_id: str = None,
        id: int = None,
    ):
        self.type = type
        self.time = time
        self.end_id = end_id
        self.start_type = start_type
        self.end_type = end_type
        self.name = name
        self.start_id = start_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.time is not None:
            result['Time'] = self.time
        if self.end_id is not None:
            result['EndId'] = self.end_id
        if self.start_type is not None:
            result['StartType'] = self.start_type
        if self.end_type is not None:
            result['EndType'] = self.end_type
        if self.name is not None:
            result['Name'] = self.name
        if self.start_id is not None:
            result['StartId'] = self.start_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('EndId') is not None:
            self.end_id = m.get('EndId')
        if m.get('StartType') is not None:
            self.start_type = m.get('StartType')
        if m.get('EndType') is not None:
            self.end_type = m.get('EndType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('StartId') is not None:
            self.start_id = m.get('StartId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeGraph4InvestigationOnlineResponseBodyDataEntityTypeList(TeaModel):
    def __init__(
        self,
        display_color: str = None,
        display_order: str = None,
        name: str = None,
        display_icon: str = None,
        id: str = None,
    ):
        self.display_color = display_color
        self.display_order = display_order
        self.name = name
        self.display_icon = display_icon
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_color is not None:
            result['DisplayColor'] = self.display_color
        if self.display_order is not None:
            result['DisplayOrder'] = self.display_order
        if self.name is not None:
            result['Name'] = self.name
        if self.display_icon is not None:
            result['DisplayIcon'] = self.display_icon
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayColor') is not None:
            self.display_color = m.get('DisplayColor')
        if m.get('DisplayOrder') is not None:
            self.display_order = m.get('DisplayOrder')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DisplayIcon') is not None:
            self.display_icon = m.get('DisplayIcon')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeGraph4InvestigationOnlineResponseBodyDataRelationTypeList(TeaModel):
    def __init__(
        self,
        show_type: str = None,
        name: str = None,
        id: str = None,
        directed: int = None,
    ):
        self.show_type = show_type
        self.name = name
        self.id = id
        self.directed = directed

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.show_type is not None:
            result['ShowType'] = self.show_type
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.directed is not None:
            result['Directed'] = self.directed
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ShowType') is not None:
            self.show_type = m.get('ShowType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Directed') is not None:
            self.directed = m.get('Directed')
        return self


class DescribeGraph4InvestigationOnlineResponseBodyData(TeaModel):
    def __init__(
        self,
        vertex_list: List[DescribeGraph4InvestigationOnlineResponseBodyDataVertexList] = None,
        edge_list: List[DescribeGraph4InvestigationOnlineResponseBodyDataEdgeList] = None,
        entity_type_list: List[DescribeGraph4InvestigationOnlineResponseBodyDataEntityTypeList] = None,
        relation_type_list: List[DescribeGraph4InvestigationOnlineResponseBodyDataRelationTypeList] = None,
    ):
        self.vertex_list = vertex_list
        self.edge_list = edge_list
        self.entity_type_list = entity_type_list
        self.relation_type_list = relation_type_list

    def validate(self):
        if self.vertex_list:
            for k in self.vertex_list:
                if k:
                    k.validate()
        if self.edge_list:
            for k in self.edge_list:
                if k:
                    k.validate()
        if self.entity_type_list:
            for k in self.entity_type_list:
                if k:
                    k.validate()
        if self.relation_type_list:
            for k in self.relation_type_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VertexList'] = []
        if self.vertex_list is not None:
            for k in self.vertex_list:
                result['VertexList'].append(k.to_map() if k else None)
        result['EdgeList'] = []
        if self.edge_list is not None:
            for k in self.edge_list:
                result['EdgeList'].append(k.to_map() if k else None)
        result['EntityTypeList'] = []
        if self.entity_type_list is not None:
            for k in self.entity_type_list:
                result['EntityTypeList'].append(k.to_map() if k else None)
        result['RelationTypeList'] = []
        if self.relation_type_list is not None:
            for k in self.relation_type_list:
                result['RelationTypeList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.vertex_list = []
        if m.get('VertexList') is not None:
            for k in m.get('VertexList'):
                temp_model = DescribeGraph4InvestigationOnlineResponseBodyDataVertexList()
                self.vertex_list.append(temp_model.from_map(k))
        self.edge_list = []
        if m.get('EdgeList') is not None:
            for k in m.get('EdgeList'):
                temp_model = DescribeGraph4InvestigationOnlineResponseBodyDataEdgeList()
                self.edge_list.append(temp_model.from_map(k))
        self.entity_type_list = []
        if m.get('EntityTypeList') is not None:
            for k in m.get('EntityTypeList'):
                temp_model = DescribeGraph4InvestigationOnlineResponseBodyDataEntityTypeList()
                self.entity_type_list.append(temp_model.from_map(k))
        self.relation_type_list = []
        if m.get('RelationTypeList') is not None:
            for k in m.get('RelationTypeList'):
                temp_model = DescribeGraph4InvestigationOnlineResponseBodyDataRelationTypeList()
                self.relation_type_list.append(temp_model.from_map(k))
        return self


class DescribeGraph4InvestigationOnlineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: DescribeGraph4InvestigationOnlineResponseBodyData = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = DescribeGraph4InvestigationOnlineResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DescribeGraph4InvestigationOnlineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGraph4InvestigationOnlineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGraph4InvestigationOnlineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedContainerInstancesRequest(TeaModel):
    def __init__(
        self,
        criteria: str = None,
        logical_exp: str = None,
        group_field: str = None,
        field_value: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.criteria = criteria
        self.logical_exp = logical_exp
        self.group_field = group_field
        self.field_value = field_value
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.group_field is not None:
            result['GroupField'] = self.group_field
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('GroupField') is not None:
            self.group_field = m.get('GroupField')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeGroupedContainerInstancesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList(TeaModel):
    def __init__(
        self,
        risk_level: str = None,
        host_ip: str = None,
        pod: str = None,
        risk_status: str = None,
        create_time: int = None,
        namespace: str = None,
        custer_state: str = None,
        instance_id: str = None,
        region_id: str = None,
        app_name: str = None,
        instance_count: int = None,
        cluster_type: str = None,
        cluster_name: str = None,
        pod_ip: str = None,
        vul_count: int = None,
        alarm_count: int = None,
        risk_instance_count: int = None,
        cluster_id: str = None,
    ):
        self.risk_level = risk_level
        self.host_ip = host_ip
        self.pod = pod
        self.risk_status = risk_status
        self.create_time = create_time
        self.namespace = namespace
        self.custer_state = custer_state
        self.instance_id = instance_id
        self.region_id = region_id
        self.app_name = app_name
        self.instance_count = instance_count
        self.cluster_type = cluster_type
        self.cluster_name = cluster_name
        self.pod_ip = pod_ip
        self.vul_count = vul_count
        self.alarm_count = alarm_count
        self.risk_instance_count = risk_instance_count
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.host_ip is not None:
            result['HostIp'] = self.host_ip
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.custer_state is not None:
            result['CusterState'] = self.custer_state
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.pod_ip is not None:
            result['PodIp'] = self.pod_ip
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        if self.alarm_count is not None:
            result['AlarmCount'] = self.alarm_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('HostIp') is not None:
            self.host_ip = m.get('HostIp')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('CusterState') is not None:
            self.custer_state = m.get('CusterState')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('PodIp') is not None:
            self.pod_ip = m.get('PodIp')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        if m.get('AlarmCount') is not None:
            self.alarm_count = m.get('AlarmCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeGroupedContainerInstancesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeGroupedContainerInstancesResponseBodyPageInfo = None,
        grouped_container_instance_list: List[DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.grouped_container_instance_list = grouped_container_instance_list

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.grouped_container_instance_list:
            for k in self.grouped_container_instance_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['GroupedContainerInstanceList'] = []
        if self.grouped_container_instance_list is not None:
            for k in self.grouped_container_instance_list:
                result['GroupedContainerInstanceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedContainerInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.grouped_container_instance_list = []
        if m.get('GroupedContainerInstanceList') is not None:
            for k in m.get('GroupedContainerInstanceList'):
                temp_model = DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList()
                self.grouped_container_instance_list.append(temp_model.from_map(k))
        return self


class DescribeGroupedContainerInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGroupedContainerInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedContainerInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedInstancesRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        criteria: str = None,
        machine_types: str = None,
        group_field: str = None,
        field_value: str = None,
        no_page: bool = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.lang = lang
        self.criteria = criteria
        self.machine_types = machine_types
        self.group_field = group_field
        self.field_value = field_value
        self.no_page = no_page
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.group_field is not None:
            result['GroupField'] = self.group_field
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.no_page is not None:
            result['NoPage'] = self.no_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('GroupField') is not None:
            self.group_field = m.get('GroupField')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('NoPage') is not None:
            self.no_page = m.get('NoPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeGroupedInstancesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeGroupedInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        asap_vul_instance_count: int = None,
        un_protected_instance_count: str = None,
        field_alias_name: str = None,
        instance_count: str = None,
        field_id: int = None,
        risk_instance_count: str = None,
        group_flag: int = None,
        group_path: List[str] = None,
    ):
        self.asap_vul_instance_count = asap_vul_instance_count
        self.un_protected_instance_count = un_protected_instance_count
        self.field_alias_name = field_alias_name
        self.instance_count = instance_count
        self.field_id = field_id
        self.risk_instance_count = risk_instance_count
        self.group_flag = group_flag
        self.group_path = group_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_vul_instance_count is not None:
            result['AsapVulInstanceCount'] = self.asap_vul_instance_count
        if self.un_protected_instance_count is not None:
            result['UnProtectedInstanceCount'] = self.un_protected_instance_count
        if self.field_alias_name is not None:
            result['FieldAliasName'] = self.field_alias_name
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.field_id is not None:
            result['FieldId'] = self.field_id
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.group_flag is not None:
            result['GroupFlag'] = self.group_flag
        if self.group_path is not None:
            result['GroupPath'] = self.group_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsapVulInstanceCount') is not None:
            self.asap_vul_instance_count = m.get('AsapVulInstanceCount')
        if m.get('UnProtectedInstanceCount') is not None:
            self.un_protected_instance_count = m.get('UnProtectedInstanceCount')
        if m.get('FieldAliasName') is not None:
            self.field_alias_name = m.get('FieldAliasName')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('FieldId') is not None:
            self.field_id = m.get('FieldId')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('GroupFlag') is not None:
            self.group_flag = m.get('GroupFlag')
        if m.get('GroupPath') is not None:
            self.group_path = m.get('GroupPath')
        return self


class DescribeGroupedInstancesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeGroupedInstancesResponseBodyPageInfo = None,
        instances: List[DescribeGroupedInstancesResponseBodyInstances] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.instances = instances

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeGroupedInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        return self


class DescribeGroupedInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGroupedInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedMaliciousFilesRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        levels: str = None,
        fuzzy_malicious_name: str = None,
        current_page: int = None,
        page_size: str = None,
        repo_region_id: str = None,
        repo_instance_id: str = None,
        repo_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        image_tag: str = None,
        image_digest: str = None,
        image_layer: str = None,
    ):
        self.lang = lang
        self.levels = levels
        self.fuzzy_malicious_name = fuzzy_malicious_name
        self.current_page = current_page
        self.page_size = page_size
        self.repo_region_id = repo_region_id
        self.repo_instance_id = repo_instance_id
        self.repo_id = repo_id
        self.repo_name = repo_name
        self.repo_namespace = repo_namespace
        self.image_tag = image_tag
        self.image_digest = image_digest
        self.image_layer = image_layer

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.fuzzy_malicious_name is not None:
            result['FuzzyMaliciousName'] = self.fuzzy_malicious_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('FuzzyMaliciousName') is not None:
            self.fuzzy_malicious_name = m.get('FuzzyMaliciousName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        return self


class DescribeGroupedMaliciousFilesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse(TeaModel):
    def __init__(
        self,
        status: int = None,
        image_count: int = None,
        latest_scan_timestamp: int = None,
        malicious_name: str = None,
        malicious_md_5: str = None,
        first_scan_timestamp: int = None,
        level: str = None,
    ):
        self.status = status
        self.image_count = image_count
        self.latest_scan_timestamp = latest_scan_timestamp
        self.malicious_name = malicious_name
        self.malicious_md_5 = malicious_md_5
        self.first_scan_timestamp = first_scan_timestamp
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.image_count is not None:
            result['ImageCount'] = self.image_count
        if self.latest_scan_timestamp is not None:
            result['LatestScanTimestamp'] = self.latest_scan_timestamp
        if self.malicious_name is not None:
            result['MaliciousName'] = self.malicious_name
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.first_scan_timestamp is not None:
            result['FirstScanTimestamp'] = self.first_scan_timestamp
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ImageCount') is not None:
            self.image_count = m.get('ImageCount')
        if m.get('LatestScanTimestamp') is not None:
            self.latest_scan_timestamp = m.get('LatestScanTimestamp')
        if m.get('MaliciousName') is not None:
            self.malicious_name = m.get('MaliciousName')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('FirstScanTimestamp') is not None:
            self.first_scan_timestamp = m.get('FirstScanTimestamp')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeGroupedMaliciousFilesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeGroupedMaliciousFilesResponseBodyPageInfo = None,
        grouped_malicious_file_response: List[DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.grouped_malicious_file_response = grouped_malicious_file_response

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.grouped_malicious_file_response:
            for k in self.grouped_malicious_file_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['GroupedMaliciousFileResponse'] = []
        if self.grouped_malicious_file_response is not None:
            for k in self.grouped_malicious_file_response:
                result['GroupedMaliciousFileResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedMaliciousFilesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.grouped_malicious_file_response = []
        if m.get('GroupedMaliciousFileResponse') is not None:
            for k in m.get('GroupedMaliciousFileResponse'):
                temp_model = DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse()
                self.grouped_malicious_file_response.append(temp_model.from_map(k))
        return self


class DescribeGroupedMaliciousFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGroupedMaliciousFilesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedMaliciousFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedTagsRequest(TeaModel):
    def __init__(
        self,
        machine_types: str = None,
    ):
        self.machine_types = machine_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        return self


class DescribeGroupedTagsResponseBodyGroupedFileds(TeaModel):
    def __init__(
        self,
        name: str = None,
        count: str = None,
        tag_id: int = None,
    ):
        self.name = name
        self.count = count
        self.tag_id = tag_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.count is not None:
            result['Count'] = self.count
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        return self


class DescribeGroupedTagsResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        count: int = None,
        grouped_fileds: List[DescribeGroupedTagsResponseBodyGroupedFileds] = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.count = count
        self.grouped_fileds = grouped_fileds

    def validate(self):
        if self.grouped_fileds:
            for k in self.grouped_fileds:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.count is not None:
            result['Count'] = self.count
        result['GroupedFileds'] = []
        if self.grouped_fileds is not None:
            for k in self.grouped_fileds:
                result['GroupedFileds'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.grouped_fileds = []
        if m.get('GroupedFileds') is not None:
            for k in m.get('GroupedFileds'):
                temp_model = DescribeGroupedTagsResponseBodyGroupedFileds()
                self.grouped_fileds.append(temp_model.from_map(k))
        return self


class DescribeGroupedTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGroupedTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedVulRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        type: str = None,
        uuids: str = None,
        alias_name: str = None,
        necessity: str = None,
        dealed: str = None,
        current_page: int = None,
        page_size: int = None,
        group_id: str = None,
        container_field_name: str = None,
        container_field_value: str = None,
        target_type: str = None,
        cluster_id: str = None,
        min_score: int = None,
    ):
        self.lang = lang
        self.type = type
        self.uuids = uuids
        self.alias_name = alias_name
        self.necessity = necessity
        self.dealed = dealed
        self.current_page = current_page
        self.page_size = page_size
        self.group_id = group_id
        self.container_field_name = container_field_name
        self.container_field_value = container_field_value
        self.target_type = target_type
        self.cluster_id = cluster_id
        self.min_score = min_score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.container_field_name is not None:
            result['ContainerFieldName'] = self.container_field_name
        if self.container_field_value is not None:
            result['ContainerFieldValue'] = self.container_field_value
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.min_score is not None:
            result['MinScore'] = self.min_score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ContainerFieldName') is not None:
            self.container_field_name = m.get('ContainerFieldName')
        if m.get('ContainerFieldValue') is not None:
            self.container_field_value = m.get('ContainerFieldValue')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('MinScore') is not None:
            self.min_score = m.get('MinScore')
        return self


class DescribeGroupedVulResponseBodyGroupedVulItems(TeaModel):
    def __init__(
        self,
        type: str = None,
        nntf_count: int = None,
        handled_count: int = None,
        gmt_last: int = None,
        tags: str = None,
        later_count: int = None,
        alias_name: str = None,
        name: str = None,
        total_fix_count: int = None,
        asap_count: int = None,
    ):
        self.type = type
        self.nntf_count = nntf_count
        self.handled_count = handled_count
        self.gmt_last = gmt_last
        self.tags = tags
        self.later_count = later_count
        self.alias_name = alias_name
        self.name = name
        self.total_fix_count = total_fix_count
        self.asap_count = asap_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        if self.handled_count is not None:
            result['HandledCount'] = self.handled_count
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        if self.total_fix_count is not None:
            result['TotalFixCount'] = self.total_fix_count
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        if m.get('HandledCount') is not None:
            self.handled_count = m.get('HandledCount')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TotalFixCount') is not None:
            self.total_fix_count = m.get('TotalFixCount')
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        return self


class DescribeGroupedVulResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        request_id: str = None,
        page_size: int = None,
        total_count: int = None,
        grouped_vul_items: List[DescribeGroupedVulResponseBodyGroupedVulItems] = None,
    ):
        self.current_page = current_page
        self.request_id = request_id
        self.page_size = page_size
        self.total_count = total_count
        self.grouped_vul_items = grouped_vul_items

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeGroupedVulResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        return self


class DescribeGroupedVulResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGroupedVulResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedVulResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHoneyPotAuthResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        honey_pot_count: int = None,
        honey_pot_auth_count: int = None,
    ):
        self.request_id = request_id
        self.honey_pot_count = honey_pot_count
        self.honey_pot_auth_count = honey_pot_auth_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.honey_pot_count is not None:
            result['HoneyPotCount'] = self.honey_pot_count
        if self.honey_pot_auth_count is not None:
            result['HoneyPotAuthCount'] = self.honey_pot_auth_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HoneyPotCount') is not None:
            self.honey_pot_count = m.get('HoneyPotCount')
        if m.get('HoneyPotAuthCount') is not None:
            self.honey_pot_auth_count = m.get('HoneyPotAuthCount')
        return self


class DescribeHoneyPotAuthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeHoneyPotAuthResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHoneyPotAuthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHoneyPotSuspStatisticsRequest(TeaModel):
    def __init__(
        self,
        from_: str = None,
        statistics_key_type: str = None,
        statistics_days: int = None,
    ):
        self.from_ = from_
        self.statistics_key_type = statistics_key_type
        self.statistics_days = statistics_days

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.statistics_key_type is not None:
            result['StatisticsKeyType'] = self.statistics_key_type
        if self.statistics_days is not None:
            result['StatisticsDays'] = self.statistics_days
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('StatisticsKeyType') is not None:
            self.statistics_key_type = m.get('StatisticsKeyType')
        if m.get('StatisticsDays') is not None:
            self.statistics_days = m.get('StatisticsDays')
        return self


class DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse(TeaModel):
    def __init__(
        self,
        type: str = None,
        vpc_id: str = None,
        vpc_name: str = None,
        instance_name: str = None,
        instance_id: str = None,
        count: int = None,
    ):
        self.type = type
        self.vpc_id = vpc_id
        self.vpc_name = vpc_name
        self.instance_name = instance_name
        self.instance_id = instance_id
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeHoneyPotSuspStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        susp_honey_pot_statistics_response: List[DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse] = None,
    ):
        self.request_id = request_id
        self.susp_honey_pot_statistics_response = susp_honey_pot_statistics_response

    def validate(self):
        if self.susp_honey_pot_statistics_response:
            for k in self.susp_honey_pot_statistics_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SuspHoneyPotStatisticsResponse'] = []
        if self.susp_honey_pot_statistics_response is not None:
            for k in self.susp_honey_pot_statistics_response:
                result['SuspHoneyPotStatisticsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.susp_honey_pot_statistics_response = []
        if m.get('SuspHoneyPotStatisticsResponse') is not None:
            for k in m.get('SuspHoneyPotStatisticsResponse'):
                temp_model = DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse()
                self.susp_honey_pot_statistics_response.append(temp_model.from_map(k))
        return self


class DescribeHoneyPotSuspStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeHoneyPotSuspStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHoneyPotSuspStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageGroupedVulListRequest(TeaModel):
    def __init__(
        self,
        type: str = None,
        group_id: str = None,
        cve_id: str = None,
        uuids: str = None,
        name: str = None,
        alias_name: str = None,
        patch_id: int = None,
        level: str = None,
        last_ts_start: int = None,
        last_ts_end: int = None,
        status_list: str = None,
        order_by: str = None,
        direction: str = None,
        necessity: str = None,
        dealed: str = None,
        create_ts_start: int = None,
        create_ts_end: int = None,
        current_page: int = None,
        page_size: int = None,
        remark: str = None,
        search_tags: str = None,
        repo_region_id: str = None,
        repo_instance_id: str = None,
        repo_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        image_tag: str = None,
        image_digest: str = None,
        image_layer: str = None,
        lang: str = None,
    ):
        self.type = type
        self.group_id = group_id
        self.cve_id = cve_id
        self.uuids = uuids
        self.name = name
        self.alias_name = alias_name
        self.patch_id = patch_id
        self.level = level
        self.last_ts_start = last_ts_start
        self.last_ts_end = last_ts_end
        self.status_list = status_list
        self.order_by = order_by
        self.direction = direction
        self.necessity = necessity
        self.dealed = dealed
        self.create_ts_start = create_ts_start
        self.create_ts_end = create_ts_end
        self.current_page = current_page
        self.page_size = page_size
        self.remark = remark
        self.search_tags = search_tags
        self.repo_region_id = repo_region_id
        self.repo_instance_id = repo_instance_id
        self.repo_id = repo_id
        self.repo_name = repo_name
        self.repo_namespace = repo_namespace
        self.image_tag = image_tag
        self.image_digest = image_digest
        self.image_layer = image_layer
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.cve_id is not None:
            result['CveId'] = self.cve_id
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.name is not None:
            result['Name'] = self.name
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.patch_id is not None:
            result['PatchId'] = self.patch_id
        if self.level is not None:
            result['Level'] = self.level
        if self.last_ts_start is not None:
            result['LastTsStart'] = self.last_ts_start
        if self.last_ts_end is not None:
            result['LastTsEnd'] = self.last_ts_end
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.create_ts_start is not None:
            result['CreateTsStart'] = self.create_ts_start
        if self.create_ts_end is not None:
            result['CreateTsEnd'] = self.create_ts_end
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.search_tags is not None:
            result['SearchTags'] = self.search_tags
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('CveId') is not None:
            self.cve_id = m.get('CveId')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('PatchId') is not None:
            self.patch_id = m.get('PatchId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LastTsStart') is not None:
            self.last_ts_start = m.get('LastTsStart')
        if m.get('LastTsEnd') is not None:
            self.last_ts_end = m.get('LastTsEnd')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('CreateTsStart') is not None:
            self.create_ts_start = m.get('CreateTsStart')
        if m.get('CreateTsEnd') is not None:
            self.create_ts_end = m.get('CreateTsEnd')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('SearchTags') is not None:
            self.search_tags = m.get('SearchTags')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeImageGroupedVulListResponseBodyGroupedVulItems(TeaModel):
    def __init__(
        self,
        status: int = None,
        type: str = None,
        nntf_count: int = None,
        gmt_last: int = None,
        last_scan_time: int = None,
        tags: str = None,
        later_count: int = None,
        alias_name: str = None,
        name: str = None,
        asap_count: int = None,
    ):
        self.status = status
        self.type = type
        self.nntf_count = nntf_count
        self.gmt_last = gmt_last
        self.last_scan_time = last_scan_time
        self.tags = tags
        self.later_count = later_count
        self.alias_name = alias_name
        self.name = name
        self.asap_count = asap_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.last_scan_time is not None:
            result['LastScanTime'] = self.last_scan_time
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('LastScanTime') is not None:
            self.last_scan_time = m.get('LastScanTime')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        return self


class DescribeImageGroupedVulListResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        request_id: str = None,
        page_size: int = None,
        total_count: int = None,
        grouped_vul_items: List[DescribeImageGroupedVulListResponseBodyGroupedVulItems] = None,
    ):
        self.current_page = current_page
        self.request_id = request_id
        self.page_size = page_size
        self.total_count = total_count
        self.grouped_vul_items = grouped_vul_items

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeImageGroupedVulListResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        return self


class DescribeImageGroupedVulListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeImageGroupedVulListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageGroupedVulListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageScanAuthCountResponseBodyImageScan(TeaModel):
    def __init__(
        self,
        scan_count: int = None,
        image_scan_capacity: int = None,
        instance_id: str = None,
    ):
        self.scan_count = scan_count
        self.image_scan_capacity = image_scan_capacity
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scan_count is not None:
            result['ScanCount'] = self.scan_count
        if self.image_scan_capacity is not None:
            result['ImageScanCapacity'] = self.image_scan_capacity
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScanCount') is not None:
            self.scan_count = m.get('ScanCount')
        if m.get('ImageScanCapacity') is not None:
            self.image_scan_capacity = m.get('ImageScanCapacity')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeImageScanAuthCountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        image_scan: DescribeImageScanAuthCountResponseBodyImageScan = None,
    ):
        self.request_id = request_id
        self.image_scan = image_scan

    def validate(self):
        if self.image_scan:
            self.image_scan.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.image_scan is not None:
            result['ImageScan'] = self.image_scan.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ImageScan') is not None:
            temp_model = DescribeImageScanAuthCountResponseBodyImageScan()
            self.image_scan = temp_model.from_map(m['ImageScan'])
        return self


class DescribeImageScanAuthCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeImageScanAuthCountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageScanAuthCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_count: int = None,
        risk_instance_count: int = None,
    ):
        self.request_id = request_id
        self.instance_count = instance_count
        self.risk_instance_count = risk_instance_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        return self


class DescribeImageStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeImageStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageVulListRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        type: str = None,
        uuids: str = None,
        name: str = None,
        alias_name: str = None,
        status_list: str = None,
        necessity: str = None,
        dealed: str = None,
        current_page: int = None,
        page_size: int = None,
        repo_region_id: str = None,
        repo_instance_id: str = None,
        repo_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        region_id: str = None,
        instance_id: str = None,
        tag: str = None,
        digest: str = None,
        container_field_name: str = None,
        container_field_value: str = None,
        target_type: str = None,
    ):
        self.lang = lang
        self.type = type
        self.uuids = uuids
        self.name = name
        self.alias_name = alias_name
        self.status_list = status_list
        self.necessity = necessity
        self.dealed = dealed
        self.current_page = current_page
        self.page_size = page_size
        self.repo_region_id = repo_region_id
        self.repo_instance_id = repo_instance_id
        self.repo_id = repo_id
        self.repo_name = repo_name
        self.repo_namespace = repo_namespace
        self.region_id = region_id
        self.instance_id = instance_id
        self.tag = tag
        self.digest = digest
        self.container_field_name = container_field_name
        self.container_field_value = container_field_value
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.name is not None:
            result['Name'] = self.name
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.digest is not None:
            result['Digest'] = self.digest
        if self.container_field_name is not None:
            result['ContainerFieldName'] = self.container_field_name
        if self.container_field_value is not None:
            result['ContainerFieldValue'] = self.container_field_value
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        if m.get('ContainerFieldName') is not None:
            self.container_field_name = m.get('ContainerFieldName')
        if m.get('ContainerFieldValue') is not None:
            self.container_field_value = m.get('ContainerFieldValue')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeImageVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList(TeaModel):
    def __init__(
        self,
        match_list: str = None,
        layer: str = None,
        full_version: str = None,
        version: str = None,
        match_detail: str = None,
        path: str = None,
        name: str = None,
        update_cmd: str = None,
    ):
        self.match_list = match_list
        self.layer = layer
        self.full_version = full_version
        self.version = version
        self.match_detail = match_detail
        self.path = path
        self.name = name
        self.update_cmd = update_cmd

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_list is not None:
            result['MatchList'] = self.match_list
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.full_version is not None:
            result['FullVersion'] = self.full_version
        if self.version is not None:
            result['Version'] = self.version
        if self.match_detail is not None:
            result['MatchDetail'] = self.match_detail
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        if self.update_cmd is not None:
            result['UpdateCmd'] = self.update_cmd
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MatchList') is not None:
            self.match_list = m.get('MatchList')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('FullVersion') is not None:
            self.full_version = m.get('FullVersion')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('MatchDetail') is not None:
            self.match_detail = m.get('MatchDetail')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateCmd') is not None:
            self.update_cmd = m.get('UpdateCmd')
        return self


class DescribeImageVulListResponseBodyVulRecordsExtendContentJson(TeaModel):
    def __init__(
        self,
        os_release: str = None,
        os: str = None,
        rpm_entity_list: List[DescribeImageVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList] = None,
    ):
        self.os_release = os_release
        self.os = os
        self.rpm_entity_list = rpm_entity_list

    def validate(self):
        if self.rpm_entity_list:
            for k in self.rpm_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.os_release is not None:
            result['OsRelease'] = self.os_release
        if self.os is not None:
            result['Os'] = self.os
        result['RpmEntityList'] = []
        if self.rpm_entity_list is not None:
            for k in self.rpm_entity_list:
                result['RpmEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OsRelease') is not None:
            self.os_release = m.get('OsRelease')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        self.rpm_entity_list = []
        if m.get('RpmEntityList') is not None:
            for k in m.get('RpmEntityList'):
                temp_model = DescribeImageVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList()
                self.rpm_entity_list.append(temp_model.from_map(k))
        return self


class DescribeImageVulListResponseBodyVulRecords(TeaModel):
    def __init__(
        self,
        can_update: bool = None,
        type: str = None,
        status: int = None,
        modify_ts: int = None,
        image_digest: str = None,
        primary_id: int = None,
        tag: str = None,
        related: str = None,
        first_ts: int = None,
        last_ts: int = None,
        necessity: str = None,
        uuid: str = None,
        alias_name: str = None,
        name: str = None,
        layers: List[str] = None,
        extend_content_json: DescribeImageVulListResponseBodyVulRecordsExtendContentJson = None,
    ):
        self.can_update = can_update
        self.type = type
        self.status = status
        self.modify_ts = modify_ts
        self.image_digest = image_digest
        self.primary_id = primary_id
        self.tag = tag
        self.related = related
        self.first_ts = first_ts
        self.last_ts = last_ts
        self.necessity = necessity
        self.uuid = uuid
        self.alias_name = alias_name
        self.name = name
        self.layers = layers
        self.extend_content_json = extend_content_json

    def validate(self):
        if self.extend_content_json:
            self.extend_content_json.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_update is not None:
            result['CanUpdate'] = self.can_update
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.modify_ts is not None:
            result['ModifyTs'] = self.modify_ts
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.primary_id is not None:
            result['PrimaryId'] = self.primary_id
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.related is not None:
            result['Related'] = self.related
        if self.first_ts is not None:
            result['FirstTs'] = self.first_ts
        if self.last_ts is not None:
            result['LastTs'] = self.last_ts
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        if self.layers is not None:
            result['Layers'] = self.layers
        if self.extend_content_json is not None:
            result['ExtendContentJson'] = self.extend_content_json.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CanUpdate') is not None:
            self.can_update = m.get('CanUpdate')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ModifyTs') is not None:
            self.modify_ts = m.get('ModifyTs')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('PrimaryId') is not None:
            self.primary_id = m.get('PrimaryId')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Related') is not None:
            self.related = m.get('Related')
        if m.get('FirstTs') is not None:
            self.first_ts = m.get('FirstTs')
        if m.get('LastTs') is not None:
            self.last_ts = m.get('LastTs')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Layers') is not None:
            self.layers = m.get('Layers')
        if m.get('ExtendContentJson') is not None:
            temp_model = DescribeImageVulListResponseBodyVulRecordsExtendContentJson()
            self.extend_content_json = temp_model.from_map(m['ExtendContentJson'])
        return self


class DescribeImageVulListResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        request_id: str = None,
        page_size: int = None,
        total_count: int = None,
        vul_records: List[DescribeImageVulListResponseBodyVulRecords] = None,
    ):
        self.current_page = current_page
        self.request_id = request_id
        self.page_size = page_size
        self.total_count = total_count
        self.vul_records = vul_records

    def validate(self):
        if self.vul_records:
            for k in self.vul_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['VulRecords'] = []
        if self.vul_records is not None:
            for k in self.vul_records:
                result['VulRecords'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.vul_records = []
        if m.get('VulRecords') is not None:
            for k in m.get('VulRecords'):
                temp_model = DescribeImageVulListResponseBodyVulRecords()
                self.vul_records.append(temp_model.from_map(k))
        return self


class DescribeImageVulListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeImageVulListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageVulListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstallCaptchaRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        deadline: str = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.deadline = deadline

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        return self


class DescribeInstallCaptchaResponseBody(TeaModel):
    def __init__(
        self,
        deadline: str = None,
        request_id: str = None,
        captcha_code: str = None,
    ):
        self.deadline = deadline
        self.request_id = request_id
        self.captcha_code = captcha_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.captcha_code is not None:
            result['CaptchaCode'] = self.captcha_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CaptchaCode') is not None:
            self.captcha_code = m.get('CaptchaCode')
        return self


class DescribeInstallCaptchaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeInstallCaptchaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstallCaptchaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceAntiBruteForceRulesRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        uuid_list: List[str] = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeInstanceAntiBruteForceRulesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeInstanceAntiBruteForceRulesResponseBodyRules(TeaModel):
    def __init__(
        self,
        uuid: str = None,
        name: str = None,
        id: int = None,
    ):
        self.uuid = uuid
        self.name = name
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeInstanceAntiBruteForceRulesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeInstanceAntiBruteForceRulesResponseBodyPageInfo = None,
        rules: List[DescribeInstanceAntiBruteForceRulesResponseBodyRules] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.rules = rules

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeInstanceAntiBruteForceRulesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeInstanceAntiBruteForceRulesResponseBodyRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeInstanceAntiBruteForceRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeInstanceAntiBruteForceRulesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceAntiBruteForceRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceStatisticsRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        uuid: str = None,
        from_: str = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.uuid = uuid
        self.from_ = from_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.from_ is not None:
            result['From'] = self.from_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        return self


class DescribeInstanceStatisticsResponseBodyData(TeaModel):
    def __init__(
        self,
        account: int = None,
        app_num: int = None,
        sca_num: int = None,
        trojan: int = None,
        cve_num: int = None,
        emg_num: int = None,
        suspicious: int = None,
        cms_num: int = None,
        uuid: str = None,
        vul: int = None,
        health: int = None,
        sys_num: int = None,
    ):
        self.account = account
        self.app_num = app_num
        self.sca_num = sca_num
        self.trojan = trojan
        self.cve_num = cve_num
        self.emg_num = emg_num
        self.suspicious = suspicious
        self.cms_num = cms_num
        self.uuid = uuid
        self.vul = vul
        self.health = health
        self.sys_num = sys_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['Account'] = self.account
        if self.app_num is not None:
            result['AppNum'] = self.app_num
        if self.sca_num is not None:
            result['ScaNum'] = self.sca_num
        if self.trojan is not None:
            result['Trojan'] = self.trojan
        if self.cve_num is not None:
            result['CveNum'] = self.cve_num
        if self.emg_num is not None:
            result['EmgNum'] = self.emg_num
        if self.suspicious is not None:
            result['Suspicious'] = self.suspicious
        if self.cms_num is not None:
            result['CmsNum'] = self.cms_num
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vul is not None:
            result['Vul'] = self.vul
        if self.health is not None:
            result['Health'] = self.health
        if self.sys_num is not None:
            result['SysNum'] = self.sys_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Account') is not None:
            self.account = m.get('Account')
        if m.get('AppNum') is not None:
            self.app_num = m.get('AppNum')
        if m.get('ScaNum') is not None:
            self.sca_num = m.get('ScaNum')
        if m.get('Trojan') is not None:
            self.trojan = m.get('Trojan')
        if m.get('CveNum') is not None:
            self.cve_num = m.get('CveNum')
        if m.get('EmgNum') is not None:
            self.emg_num = m.get('EmgNum')
        if m.get('Suspicious') is not None:
            self.suspicious = m.get('Suspicious')
        if m.get('CmsNum') is not None:
            self.cms_num = m.get('CmsNum')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Vul') is not None:
            self.vul = m.get('Vul')
        if m.get('Health') is not None:
            self.health = m.get('Health')
        if m.get('SysNum') is not None:
            self.sys_num = m.get('SysNum')
        return self


class DescribeInstanceStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: List[DescribeInstanceStatisticsResponseBodyData] = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeInstanceStatisticsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class DescribeInstanceStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeInstanceStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIpInfoRequest(TeaModel):
    def __init__(
        self,
        ip: str = None,
        field: str = None,
    ):
        self.ip = ip
        self.field = field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.field is not None:
            result['Field'] = self.field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Field') is not None:
            self.field = m.get('Field')
        return self


class DescribeIpInfoResponseBody(TeaModel):
    def __init__(
        self,
        gmt_last_c2: str = None,
        nat_day_trace: str = None,
        is_proxy_1d: str = None,
        gmt_first_mining_pool: str = None,
        province: str = None,
        is_malicious_login_7d: str = None,
        total_day_cnt_tor: str = None,
        total_day_cnt_web_attack: str = None,
        gmt_last_proxy: str = None,
        is_nat_7d: str = None,
        request_id: str = None,
        isp: str = None,
        tags: str = None,
        proxy_day_trace: str = None,
        day_cnt_7d_web_attack: str = None,
        gmt_last_tor: str = None,
        web_attack_day_trace: str = None,
        gmt_last_malicious_login: str = None,
        gmt_last_web_attack: str = None,
        is_web_attack_1d: str = None,
        day_cnt_7d_tor: str = None,
        is_tor: str = None,
        is_proxy_7d: str = None,
        gmt_last_malicious_source: str = None,
        rdns: str = None,
        is_c21d: str = None,
        is_web_attack_7d: str = None,
        is_malicious_source_1d: str = None,
        geo: str = None,
        is_tor_1d: str = None,
        is_malicious_login: str = None,
        gmt_first_c2: str = None,
        c_2day_trace: str = None,
        day_cnt_30d_web_attack: str = None,
        malicious_source_day_trace: str = None,
        is_mining_pool: str = None,
        is_malicious_source_7d: str = None,
        mining_pool_day_trace: str = None,
        is_idc: str = None,
        gmt_last_mining_pool: str = None,
        is_web_attack_30d: str = None,
        is_tor_7d: str = None,
        is_nat: str = None,
        is_nat_1d: str = None,
        is_malicious_source: str = None,
        tor_day_trace: str = None,
        ip: str = None,
        is_web_attack: str = None,
        city: str = None,
        is_c2: str = None,
        is_mining_pool_7d: str = None,
        malicious_score: str = None,
        is_malicious_source_30d: str = None,
        gmt_last_nat: str = None,
        idc_name: str = None,
        is_mining_pool_1d: str = None,
        is_malicious_login_1d: str = None,
        country: str = None,
        day_cnt_30d_tor: str = None,
        is_proxy: str = None,
        malicious_login_day_trace: str = None,
        is_c27d: str = None,
    ):
        self.gmt_last_c2 = gmt_last_c2
        self.nat_day_trace = nat_day_trace
        self.is_proxy_1d = is_proxy_1d
        self.gmt_first_mining_pool = gmt_first_mining_pool
        self.province = province
        self.is_malicious_login_7d = is_malicious_login_7d
        self.total_day_cnt_tor = total_day_cnt_tor
        self.total_day_cnt_web_attack = total_day_cnt_web_attack
        self.gmt_last_proxy = gmt_last_proxy
        self.is_nat_7d = is_nat_7d
        self.request_id = request_id
        self.isp = isp
        self.tags = tags
        self.proxy_day_trace = proxy_day_trace
        self.day_cnt_7d_web_attack = day_cnt_7d_web_attack
        self.gmt_last_tor = gmt_last_tor
        self.web_attack_day_trace = web_attack_day_trace
        self.gmt_last_malicious_login = gmt_last_malicious_login
        self.gmt_last_web_attack = gmt_last_web_attack
        self.is_web_attack_1d = is_web_attack_1d
        self.day_cnt_7d_tor = day_cnt_7d_tor
        self.is_tor = is_tor
        self.is_proxy_7d = is_proxy_7d
        self.gmt_last_malicious_source = gmt_last_malicious_source
        self.rdns = rdns
        self.is_c21d = is_c21d
        self.is_web_attack_7d = is_web_attack_7d
        self.is_malicious_source_1d = is_malicious_source_1d
        self.geo = geo
        self.is_tor_1d = is_tor_1d
        self.is_malicious_login = is_malicious_login
        self.gmt_first_c2 = gmt_first_c2
        self.c_2day_trace = c_2day_trace
        self.day_cnt_30d_web_attack = day_cnt_30d_web_attack
        self.malicious_source_day_trace = malicious_source_day_trace
        self.is_mining_pool = is_mining_pool
        self.is_malicious_source_7d = is_malicious_source_7d
        self.mining_pool_day_trace = mining_pool_day_trace
        self.is_idc = is_idc
        self.gmt_last_mining_pool = gmt_last_mining_pool
        self.is_web_attack_30d = is_web_attack_30d
        self.is_tor_7d = is_tor_7d
        self.is_nat = is_nat
        self.is_nat_1d = is_nat_1d
        self.is_malicious_source = is_malicious_source
        self.tor_day_trace = tor_day_trace
        self.ip = ip
        self.is_web_attack = is_web_attack
        self.city = city
        self.is_c2 = is_c2
        self.is_mining_pool_7d = is_mining_pool_7d
        self.malicious_score = malicious_score
        self.is_malicious_source_30d = is_malicious_source_30d
        self.gmt_last_nat = gmt_last_nat
        self.idc_name = idc_name
        self.is_mining_pool_1d = is_mining_pool_1d
        self.is_malicious_login_1d = is_malicious_login_1d
        self.country = country
        self.day_cnt_30d_tor = day_cnt_30d_tor
        self.is_proxy = is_proxy
        self.malicious_login_day_trace = malicious_login_day_trace
        self.is_c27d = is_c27d

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_last_c2 is not None:
            result['gmt_last_c2'] = self.gmt_last_c2
        if self.nat_day_trace is not None:
            result['nat_day_trace'] = self.nat_day_trace
        if self.is_proxy_1d is not None:
            result['is_proxy_1d'] = self.is_proxy_1d
        if self.gmt_first_mining_pool is not None:
            result['gmt_first_mining_pool'] = self.gmt_first_mining_pool
        if self.province is not None:
            result['province'] = self.province
        if self.is_malicious_login_7d is not None:
            result['is_malicious_login_7d'] = self.is_malicious_login_7d
        if self.total_day_cnt_tor is not None:
            result['total_day_cnt_tor'] = self.total_day_cnt_tor
        if self.total_day_cnt_web_attack is not None:
            result['total_day_cnt_web_attack'] = self.total_day_cnt_web_attack
        if self.gmt_last_proxy is not None:
            result['gmt_last_proxy'] = self.gmt_last_proxy
        if self.is_nat_7d is not None:
            result['is_nat_7d'] = self.is_nat_7d
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.isp is not None:
            result['isp'] = self.isp
        if self.tags is not None:
            result['tags'] = self.tags
        if self.proxy_day_trace is not None:
            result['proxy_day_trace'] = self.proxy_day_trace
        if self.day_cnt_7d_web_attack is not None:
            result['day_cnt_7d_web_attack'] = self.day_cnt_7d_web_attack
        if self.gmt_last_tor is not None:
            result['gmt_last_tor'] = self.gmt_last_tor
        if self.web_attack_day_trace is not None:
            result['web_attack_day_trace'] = self.web_attack_day_trace
        if self.gmt_last_malicious_login is not None:
            result['gmt_last_malicious_login'] = self.gmt_last_malicious_login
        if self.gmt_last_web_attack is not None:
            result['gmt_last_web_attack'] = self.gmt_last_web_attack
        if self.is_web_attack_1d is not None:
            result['is_web_attack_1d'] = self.is_web_attack_1d
        if self.day_cnt_7d_tor is not None:
            result['day_cnt_7d_tor'] = self.day_cnt_7d_tor
        if self.is_tor is not None:
            result['is_tor'] = self.is_tor
        if self.is_proxy_7d is not None:
            result['is_proxy_7d'] = self.is_proxy_7d
        if self.gmt_last_malicious_source is not None:
            result['gmt_last_malicious_source'] = self.gmt_last_malicious_source
        if self.rdns is not None:
            result['rdns'] = self.rdns
        if self.is_c21d is not None:
            result['is_c2_1d'] = self.is_c21d
        if self.is_web_attack_7d is not None:
            result['is_web_attack_7d'] = self.is_web_attack_7d
        if self.is_malicious_source_1d is not None:
            result['is_malicious_source_1d'] = self.is_malicious_source_1d
        if self.geo is not None:
            result['geo'] = self.geo
        if self.is_tor_1d is not None:
            result['is_tor_1d'] = self.is_tor_1d
        if self.is_malicious_login is not None:
            result['is_malicious_login'] = self.is_malicious_login
        if self.gmt_first_c2 is not None:
            result['gmt_first_c2'] = self.gmt_first_c2
        if self.c_2day_trace is not None:
            result['c2_day_trace'] = self.c_2day_trace
        if self.day_cnt_30d_web_attack is not None:
            result['day_cnt_30d_web_attack'] = self.day_cnt_30d_web_attack
        if self.malicious_source_day_trace is not None:
            result['malicious_source_day_trace'] = self.malicious_source_day_trace
        if self.is_mining_pool is not None:
            result['is_mining_pool'] = self.is_mining_pool
        if self.is_malicious_source_7d is not None:
            result['is_malicious_source_7d'] = self.is_malicious_source_7d
        if self.mining_pool_day_trace is not None:
            result['mining_pool_day_trace'] = self.mining_pool_day_trace
        if self.is_idc is not None:
            result['is_idc'] = self.is_idc
        if self.gmt_last_mining_pool is not None:
            result['gmt_last_mining_pool'] = self.gmt_last_mining_pool
        if self.is_web_attack_30d is not None:
            result['is_web_attack_30d'] = self.is_web_attack_30d
        if self.is_tor_7d is not None:
            result['is_tor_7d'] = self.is_tor_7d
        if self.is_nat is not None:
            result['is_nat'] = self.is_nat
        if self.is_nat_1d is not None:
            result['is_nat_1d'] = self.is_nat_1d
        if self.is_malicious_source is not None:
            result['is_malicious_source'] = self.is_malicious_source
        if self.tor_day_trace is not None:
            result['tor_day_trace'] = self.tor_day_trace
        if self.ip is not None:
            result['ip'] = self.ip
        if self.is_web_attack is not None:
            result['is_web_attack'] = self.is_web_attack
        if self.city is not None:
            result['city'] = self.city
        if self.is_c2 is not None:
            result['is_c2'] = self.is_c2
        if self.is_mining_pool_7d is not None:
            result['is_mining_pool_7d'] = self.is_mining_pool_7d
        if self.malicious_score is not None:
            result['malicious_score'] = self.malicious_score
        if self.is_malicious_source_30d is not None:
            result['is_malicious_source_30d'] = self.is_malicious_source_30d
        if self.gmt_last_nat is not None:
            result['gmt_last_nat'] = self.gmt_last_nat
        if self.idc_name is not None:
            result['idc_name'] = self.idc_name
        if self.is_mining_pool_1d is not None:
            result['is_mining_pool_1d'] = self.is_mining_pool_1d
        if self.is_malicious_login_1d is not None:
            result['is_malicious_login_1d'] = self.is_malicious_login_1d
        if self.country is not None:
            result['country'] = self.country
        if self.day_cnt_30d_tor is not None:
            result['day_cnt_30d_tor'] = self.day_cnt_30d_tor
        if self.is_proxy is not None:
            result['is_proxy'] = self.is_proxy
        if self.malicious_login_day_trace is not None:
            result['malicious_login_day_trace'] = self.malicious_login_day_trace
        if self.is_c27d is not None:
            result['is_c2_7d'] = self.is_c27d
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmt_last_c2') is not None:
            self.gmt_last_c2 = m.get('gmt_last_c2')
        if m.get('nat_day_trace') is not None:
            self.nat_day_trace = m.get('nat_day_trace')
        if m.get('is_proxy_1d') is not None:
            self.is_proxy_1d = m.get('is_proxy_1d')
        if m.get('gmt_first_mining_pool') is not None:
            self.gmt_first_mining_pool = m.get('gmt_first_mining_pool')
        if m.get('province') is not None:
            self.province = m.get('province')
        if m.get('is_malicious_login_7d') is not None:
            self.is_malicious_login_7d = m.get('is_malicious_login_7d')
        if m.get('total_day_cnt_tor') is not None:
            self.total_day_cnt_tor = m.get('total_day_cnt_tor')
        if m.get('total_day_cnt_web_attack') is not None:
            self.total_day_cnt_web_attack = m.get('total_day_cnt_web_attack')
        if m.get('gmt_last_proxy') is not None:
            self.gmt_last_proxy = m.get('gmt_last_proxy')
        if m.get('is_nat_7d') is not None:
            self.is_nat_7d = m.get('is_nat_7d')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('isp') is not None:
            self.isp = m.get('isp')
        if m.get('tags') is not None:
            self.tags = m.get('tags')
        if m.get('proxy_day_trace') is not None:
            self.proxy_day_trace = m.get('proxy_day_trace')
        if m.get('day_cnt_7d_web_attack') is not None:
            self.day_cnt_7d_web_attack = m.get('day_cnt_7d_web_attack')
        if m.get('gmt_last_tor') is not None:
            self.gmt_last_tor = m.get('gmt_last_tor')
        if m.get('web_attack_day_trace') is not None:
            self.web_attack_day_trace = m.get('web_attack_day_trace')
        if m.get('gmt_last_malicious_login') is not None:
            self.gmt_last_malicious_login = m.get('gmt_last_malicious_login')
        if m.get('gmt_last_web_attack') is not None:
            self.gmt_last_web_attack = m.get('gmt_last_web_attack')
        if m.get('is_web_attack_1d') is not None:
            self.is_web_attack_1d = m.get('is_web_attack_1d')
        if m.get('day_cnt_7d_tor') is not None:
            self.day_cnt_7d_tor = m.get('day_cnt_7d_tor')
        if m.get('is_tor') is not None:
            self.is_tor = m.get('is_tor')
        if m.get('is_proxy_7d') is not None:
            self.is_proxy_7d = m.get('is_proxy_7d')
        if m.get('gmt_last_malicious_source') is not None:
            self.gmt_last_malicious_source = m.get('gmt_last_malicious_source')
        if m.get('rdns') is not None:
            self.rdns = m.get('rdns')
        if m.get('is_c2_1d') is not None:
            self.is_c21d = m.get('is_c2_1d')
        if m.get('is_web_attack_7d') is not None:
            self.is_web_attack_7d = m.get('is_web_attack_7d')
        if m.get('is_malicious_source_1d') is not None:
            self.is_malicious_source_1d = m.get('is_malicious_source_1d')
        if m.get('geo') is not None:
            self.geo = m.get('geo')
        if m.get('is_tor_1d') is not None:
            self.is_tor_1d = m.get('is_tor_1d')
        if m.get('is_malicious_login') is not None:
            self.is_malicious_login = m.get('is_malicious_login')
        if m.get('gmt_first_c2') is not None:
            self.gmt_first_c2 = m.get('gmt_first_c2')
        if m.get('c2_day_trace') is not None:
            self.c_2day_trace = m.get('c2_day_trace')
        if m.get('day_cnt_30d_web_attack') is not None:
            self.day_cnt_30d_web_attack = m.get('day_cnt_30d_web_attack')
        if m.get('malicious_source_day_trace') is not None:
            self.malicious_source_day_trace = m.get('malicious_source_day_trace')
        if m.get('is_mining_pool') is not None:
            self.is_mining_pool = m.get('is_mining_pool')
        if m.get('is_malicious_source_7d') is not None:
            self.is_malicious_source_7d = m.get('is_malicious_source_7d')
        if m.get('mining_pool_day_trace') is not None:
            self.mining_pool_day_trace = m.get('mining_pool_day_trace')
        if m.get('is_idc') is not None:
            self.is_idc = m.get('is_idc')
        if m.get('gmt_last_mining_pool') is not None:
            self.gmt_last_mining_pool = m.get('gmt_last_mining_pool')
        if m.get('is_web_attack_30d') is not None:
            self.is_web_attack_30d = m.get('is_web_attack_30d')
        if m.get('is_tor_7d') is not None:
            self.is_tor_7d = m.get('is_tor_7d')
        if m.get('is_nat') is not None:
            self.is_nat = m.get('is_nat')
        if m.get('is_nat_1d') is not None:
            self.is_nat_1d = m.get('is_nat_1d')
        if m.get('is_malicious_source') is not None:
            self.is_malicious_source = m.get('is_malicious_source')
        if m.get('tor_day_trace') is not None:
            self.tor_day_trace = m.get('tor_day_trace')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('is_web_attack') is not None:
            self.is_web_attack = m.get('is_web_attack')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('is_c2') is not None:
            self.is_c2 = m.get('is_c2')
        if m.get('is_mining_pool_7d') is not None:
            self.is_mining_pool_7d = m.get('is_mining_pool_7d')
        if m.get('malicious_score') is not None:
            self.malicious_score = m.get('malicious_score')
        if m.get('is_malicious_source_30d') is not None:
            self.is_malicious_source_30d = m.get('is_malicious_source_30d')
        if m.get('gmt_last_nat') is not None:
            self.gmt_last_nat = m.get('gmt_last_nat')
        if m.get('idc_name') is not None:
            self.idc_name = m.get('idc_name')
        if m.get('is_mining_pool_1d') is not None:
            self.is_mining_pool_1d = m.get('is_mining_pool_1d')
        if m.get('is_malicious_login_1d') is not None:
            self.is_malicious_login_1d = m.get('is_malicious_login_1d')
        if m.get('country') is not None:
            self.country = m.get('country')
        if m.get('day_cnt_30d_tor') is not None:
            self.day_cnt_30d_tor = m.get('day_cnt_30d_tor')
        if m.get('is_proxy') is not None:
            self.is_proxy = m.get('is_proxy')
        if m.get('malicious_login_day_trace') is not None:
            self.malicious_login_day_trace = m.get('malicious_login_day_trace')
        if m.get('is_c2_7d') is not None:
            self.is_c27d = m.get('is_c2_7d')
        return self


class DescribeIpInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeIpInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeIpInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLogstoreStorageRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        from_: str = None,
    ):
        self.lang = lang
        self.from_ = from_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.from_ is not None:
            result['From'] = self.from_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        return self


class DescribeLogstoreStorageResponseBody(TeaModel):
    def __init__(
        self,
        used: int = None,
        ttl: int = None,
        logstore: str = None,
        request_id: str = None,
        preserve: int = None,
    ):
        self.used = used
        self.ttl = ttl
        self.logstore = logstore
        self.request_id = request_id
        self.preserve = preserve

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.used is not None:
            result['Used'] = self.used
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.preserve is not None:
            result['Preserve'] = self.preserve
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Used') is not None:
            self.used = m.get('Used')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Preserve') is not None:
            self.preserve = m.get('Preserve')
        return self


class DescribeLogstoreStorageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLogstoreStorageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLogstoreStorageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeModuleConfigResponseBodyModuleConfigListItems(TeaModel):
    def __init__(
        self,
        uuid: str = None,
        group_id: int = None,
        instance_name: str = None,
        region: str = None,
        ip: str = None,
        instance_id: str = None,
    ):
        self.uuid = uuid
        self.group_id = group_id
        self.instance_name = instance_name
        self.region = region
        self.ip = ip
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region is not None:
            result['Region'] = self.region
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeModuleConfigResponseBodyModuleConfigList(TeaModel):
    def __init__(
        self,
        module_name: str = None,
        config_name: str = None,
        items: List[DescribeModuleConfigResponseBodyModuleConfigListItems] = None,
    ):
        self.module_name = module_name
        self.config_name = config_name
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeModuleConfigResponseBodyModuleConfigListItems()
                self.items.append(temp_model.from_map(k))
        return self


class DescribeModuleConfigResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        count: int = None,
        module_config_list: List[DescribeModuleConfigResponseBodyModuleConfigList] = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.count = count
        self.module_config_list = module_config_list

    def validate(self):
        if self.module_config_list:
            for k in self.module_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.count is not None:
            result['Count'] = self.count
        result['ModuleConfigList'] = []
        if self.module_config_list is not None:
            for k in self.module_config_list:
                result['ModuleConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.module_config_list = []
        if m.get('ModuleConfigList') is not None:
            for k in m.get('ModuleConfigList'):
                temp_model = DescribeModuleConfigResponseBodyModuleConfigList()
                self.module_config_list.append(temp_model.from_map(k))
        return self


class DescribeModuleConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeModuleConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeModuleConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNoticeConfigRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
    ):
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeNoticeConfigResponseBodyNoticeConfigList(TeaModel):
    def __init__(
        self,
        time_limit: int = None,
        ali_uid: int = None,
        current_page: int = None,
        project: str = None,
        route: int = None,
    ):
        self.time_limit = time_limit
        self.ali_uid = ali_uid
        self.current_page = current_page
        self.project = project
        self.route = route

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_limit is not None:
            result['TimeLimit'] = self.time_limit
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.project is not None:
            result['Project'] = self.project
        if self.route is not None:
            result['Route'] = self.route
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeLimit') is not None:
            self.time_limit = m.get('TimeLimit')
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Route') is not None:
            self.route = m.get('Route')
        return self


class DescribeNoticeConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        notice_config_list: List[DescribeNoticeConfigResponseBodyNoticeConfigList] = None,
    ):
        self.request_id = request_id
        self.notice_config_list = notice_config_list

    def validate(self):
        if self.notice_config_list:
            for k in self.notice_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['NoticeConfigList'] = []
        if self.notice_config_list is not None:
            for k in self.notice_config_list:
                result['NoticeConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.notice_config_list = []
        if m.get('NoticeConfigList') is not None:
            for k in m.get('NoticeConfigList'):
                temp_model = DescribeNoticeConfigResponseBodyNoticeConfigList()
                self.notice_config_list.append(temp_model.from_map(k))
        return self


class DescribeNoticeConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeNoticeConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeNoticeConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyCountRequest(TeaModel):
    def __init__(
        self,
        type: str = None,
        uuid_list: str = None,
    ):
        self.type = type
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribePropertyCountResponseBody(TeaModel):
    def __init__(
        self,
        process: int = None,
        auto_run: int = None,
        request_id: str = None,
        user: int = None,
        software: int = None,
        cron: int = None,
        port: int = None,
        sca: int = None,
    ):
        self.process = process
        self.auto_run = auto_run
        self.request_id = request_id
        self.user = user
        self.software = software
        self.cron = cron
        self.port = port
        self.sca = sca

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.process is not None:
            result['Process'] = self.process
        if self.auto_run is not None:
            result['AutoRun'] = self.auto_run
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user is not None:
            result['User'] = self.user
        if self.software is not None:
            result['Software'] = self.software
        if self.cron is not None:
            result['Cron'] = self.cron
        if self.port is not None:
            result['Port'] = self.port
        if self.sca is not None:
            result['Sca'] = self.sca
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Process') is not None:
            self.process = m.get('Process')
        if m.get('AutoRun') is not None:
            self.auto_run = m.get('AutoRun')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Software') is not None:
            self.software = m.get('Software')
        if m.get('Cron') is not None:
            self.cron = m.get('Cron')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Sca') is not None:
            self.sca = m.get('Sca')
        return self


class DescribePropertyCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyCountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyCronDetailRequest(TeaModel):
    def __init__(
        self,
        remark: str = None,
        source: str = None,
        user: str = None,
        uuid: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.remark = remark
        self.source = source
        self.user = user
        self.uuid = uuid
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.source is not None:
            result['Source'] = self.source
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertyCronDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribePropertyCronDetailResponseBodyPropertys(TeaModel):
    def __init__(
        self,
        create: str = None,
        internet_ip: str = None,
        ip: str = None,
        user: str = None,
        instance_id: str = None,
        source: str = None,
        intranet_ip: str = None,
        cmd: str = None,
        period: str = None,
        uuid: str = None,
        instance_name: str = None,
        md_5: str = None,
        create_timestamp: int = None,
    ):
        self.create = create
        self.internet_ip = internet_ip
        self.ip = ip
        self.user = user
        self.instance_id = instance_id
        self.source = source
        self.intranet_ip = intranet_ip
        self.cmd = cmd
        self.period = period
        self.uuid = uuid
        self.instance_name = instance_name
        self.md_5 = md_5
        self.create_timestamp = create_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create is not None:
            result['Create'] = self.create
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.user is not None:
            result['User'] = self.user
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.source is not None:
            result['Source'] = self.source
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.cmd is not None:
            result['Cmd'] = self.cmd
        if self.period is not None:
            result['Period'] = self.period
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Cmd') is not None:
            self.cmd = m.get('Cmd')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        return self


class DescribePropertyCronDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribePropertyCronDetailResponseBodyPageInfo = None,
        propertys: List[DescribePropertyCronDetailResponseBodyPropertys] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.propertys = propertys

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyCronDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyCronDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        return self


class DescribePropertyCronDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyCronDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyCronDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyPortDetailRequest(TeaModel):
    def __init__(
        self,
        remark: str = None,
        port: str = None,
        proc_name: str = None,
        uuid: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.remark = remark
        self.port = port
        self.proc_name = proc_name
        self.uuid = uuid
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.port is not None:
            result['Port'] = self.port
        if self.proc_name is not None:
            result['ProcName'] = self.proc_name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ProcName') is not None:
            self.proc_name = m.get('ProcName')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertyPortDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribePropertyPortDetailResponseBodyPropertys(TeaModel):
    def __init__(
        self,
        create: str = None,
        internet_ip: str = None,
        bind_ip: str = None,
        ip: str = None,
        proc_name: str = None,
        instance_id: str = None,
        port: str = None,
        intranet_ip: str = None,
        uuid: str = None,
        instance_name: str = None,
        proto: str = None,
        create_timestamp: int = None,
    ):
        self.create = create
        self.internet_ip = internet_ip
        self.bind_ip = bind_ip
        self.ip = ip
        self.proc_name = proc_name
        self.instance_id = instance_id
        self.port = port
        self.intranet_ip = intranet_ip
        self.uuid = uuid
        self.instance_name = instance_name
        self.proto = proto
        self.create_timestamp = create_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create is not None:
            result['Create'] = self.create
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.bind_ip is not None:
            result['BindIp'] = self.bind_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.proc_name is not None:
            result['ProcName'] = self.proc_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.port is not None:
            result['Port'] = self.port
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('BindIp') is not None:
            self.bind_ip = m.get('BindIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('ProcName') is not None:
            self.proc_name = m.get('ProcName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        return self


class DescribePropertyPortDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribePropertyPortDetailResponseBodyPageInfo = None,
        propertys: List[DescribePropertyPortDetailResponseBodyPropertys] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.propertys = propertys

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyPortDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyPortDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        return self


class DescribePropertyPortDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyPortDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyPortDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyPortItemRequest(TeaModel):
    def __init__(
        self,
        force_flush: bool = None,
        port: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.force_flush = force_flush
        self.port = port
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force_flush is not None:
            result['ForceFlush'] = self.force_flush
        if self.port is not None:
            result['Port'] = self.port
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForceFlush') is not None:
            self.force_flush = m.get('ForceFlush')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertyPortItemResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribePropertyPortItemResponseBodyPropertyItems(TeaModel):
    def __init__(
        self,
        port: str = None,
        count: int = None,
        proto: str = None,
    ):
        self.port = port
        self.count = count
        self.proto = proto

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.count is not None:
            result['Count'] = self.count
        if self.proto is not None:
            result['Proto'] = self.proto
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        return self


class DescribePropertyPortItemResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribePropertyPortItemResponseBodyPageInfo = None,
        property_items: List[DescribePropertyPortItemResponseBodyPropertyItems] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.property_items = property_items

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.property_items:
            for k in self.property_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['PropertyItems'] = []
        if self.property_items is not None:
            for k in self.property_items:
                result['PropertyItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyPortItemResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.property_items = []
        if m.get('PropertyItems') is not None:
            for k in m.get('PropertyItems'):
                temp_model = DescribePropertyPortItemResponseBodyPropertyItems()
                self.property_items.append(temp_model.from_map(k))
        return self


class DescribePropertyPortItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyPortItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyPortItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyProcDetailRequest(TeaModel):
    def __init__(
        self,
        remark: str = None,
        name: str = None,
        user: str = None,
        cmdline: str = None,
        uuid: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.remark = remark
        self.name = name
        self.user = user
        self.cmdline = cmdline
        self.uuid = uuid
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.name is not None:
            result['Name'] = self.name
        if self.user is not None:
            result['User'] = self.user
        if self.cmdline is not None:
            result['Cmdline'] = self.cmdline
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Cmdline') is not None:
            self.cmdline = m.get('Cmdline')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertyProcDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribePropertyProcDetailResponseBodyPropertys(TeaModel):
    def __init__(
        self,
        create: str = None,
        internet_ip: str = None,
        pid: str = None,
        user: str = None,
        instance_id: str = None,
        cmdline: str = None,
        intranet_ip: str = None,
        euid_name: str = None,
        uuid: str = None,
        start_time: str = None,
        pname: str = None,
        instance_name: str = None,
        path: str = None,
        md_5: str = None,
        name: str = None,
        create_timestamp: int = None,
    ):
        self.create = create
        self.internet_ip = internet_ip
        self.pid = pid
        self.user = user
        self.instance_id = instance_id
        self.cmdline = cmdline
        self.intranet_ip = intranet_ip
        self.euid_name = euid_name
        self.uuid = uuid
        self.start_time = start_time
        self.pname = pname
        self.instance_name = instance_name
        self.path = path
        self.md_5 = md_5
        self.name = name
        self.create_timestamp = create_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create is not None:
            result['Create'] = self.create
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.user is not None:
            result['User'] = self.user
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.cmdline is not None:
            result['Cmdline'] = self.cmdline
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.euid_name is not None:
            result['EuidName'] = self.euid_name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.pname is not None:
            result['Pname'] = self.pname
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.path is not None:
            result['Path'] = self.path
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.name is not None:
            result['Name'] = self.name
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Cmdline') is not None:
            self.cmdline = m.get('Cmdline')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('EuidName') is not None:
            self.euid_name = m.get('EuidName')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Pname') is not None:
            self.pname = m.get('Pname')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        return self


class DescribePropertyProcDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribePropertyProcDetailResponseBodyPageInfo = None,
        propertys: List[DescribePropertyProcDetailResponseBodyPropertys] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.propertys = propertys

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyProcDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyProcDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        return self


class DescribePropertyProcDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyProcDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyProcDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyProcItemRequest(TeaModel):
    def __init__(
        self,
        force_flush: bool = None,
        name: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.force_flush = force_flush
        self.name = name
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force_flush is not None:
            result['ForceFlush'] = self.force_flush
        if self.name is not None:
            result['Name'] = self.name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForceFlush') is not None:
            self.force_flush = m.get('ForceFlush')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertyProcItemResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribePropertyProcItemResponseBodyPropertyItems(TeaModel):
    def __init__(
        self,
        name: str = None,
        count: int = None,
    ):
        self.name = name
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribePropertyProcItemResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribePropertyProcItemResponseBodyPageInfo = None,
        property_items: List[DescribePropertyProcItemResponseBodyPropertyItems] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.property_items = property_items

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.property_items:
            for k in self.property_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['PropertyItems'] = []
        if self.property_items is not None:
            for k in self.property_items:
                result['PropertyItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyProcItemResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.property_items = []
        if m.get('PropertyItems') is not None:
            for k in m.get('PropertyItems'):
                temp_model = DescribePropertyProcItemResponseBodyPropertyItems()
                self.property_items.append(temp_model.from_map(k))
        return self


class DescribePropertyProcItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyProcItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyProcItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyScaDetailRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        search_item: str = None,
        search_info: str = None,
        sca_name: str = None,
        biz_type: str = None,
        search_item_sub: str = None,
        search_info_sub: str = None,
        remark: str = None,
        name: int = None,
        uuid: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.lang = lang
        self.search_item = search_item
        self.search_info = search_info
        self.sca_name = sca_name
        self.biz_type = biz_type
        self.search_item_sub = search_item_sub
        self.search_info_sub = search_info_sub
        self.remark = remark
        self.name = name
        self.uuid = uuid
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.search_item is not None:
            result['SearchItem'] = self.search_item
        if self.search_info is not None:
            result['SearchInfo'] = self.search_info
        if self.sca_name is not None:
            result['ScaName'] = self.sca_name
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.search_item_sub is not None:
            result['SearchItemSub'] = self.search_item_sub
        if self.search_info_sub is not None:
            result['SearchInfoSub'] = self.search_info_sub
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.name is not None:
            result['Name'] = self.name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SearchItem') is not None:
            self.search_item = m.get('SearchItem')
        if m.get('SearchInfo') is not None:
            self.search_info = m.get('SearchInfo')
        if m.get('ScaName') is not None:
            self.sca_name = m.get('ScaName')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('SearchItemSub') is not None:
            self.search_item_sub = m.get('SearchItemSub')
        if m.get('SearchInfoSub') is not None:
            self.search_info_sub = m.get('SearchInfoSub')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertyScaDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribePropertyScaDetailResponseBodyPropertys(TeaModel):
    def __init__(
        self,
        type: str = None,
        biz_type_dispaly: str = None,
        process_started: int = None,
        internet_ip: str = None,
        config_path: str = None,
        pid: str = None,
        port: str = None,
        cmdline: str = None,
        biz_type: str = None,
        listen_ip: str = None,
        version: str = None,
        instance_name: str = None,
        listen_status: str = None,
        name: str = None,
        create: str = None,
        ip: str = None,
        process_user: str = None,
        instance_id: str = None,
        web_path: str = None,
        ppid: str = None,
        intranet_ip: str = None,
        uuid: str = None,
        listen_protocol: str = None,
        image_name: str = None,
        path: str = None,
        container_name: str = None,
        proof: str = None,
        create_timestamp: int = None,
    ):
        self.type = type
        self.biz_type_dispaly = biz_type_dispaly
        self.process_started = process_started
        self.internet_ip = internet_ip
        self.config_path = config_path
        self.pid = pid
        self.port = port
        self.cmdline = cmdline
        self.biz_type = biz_type
        self.listen_ip = listen_ip
        self.version = version
        self.instance_name = instance_name
        self.listen_status = listen_status
        self.name = name
        self.create = create
        self.ip = ip
        self.process_user = process_user
        self.instance_id = instance_id
        self.web_path = web_path
        self.ppid = ppid
        self.intranet_ip = intranet_ip
        self.uuid = uuid
        self.listen_protocol = listen_protocol
        self.image_name = image_name
        self.path = path
        self.container_name = container_name
        self.proof = proof
        self.create_timestamp = create_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.biz_type_dispaly is not None:
            result['BizTypeDispaly'] = self.biz_type_dispaly
        if self.process_started is not None:
            result['ProcessStarted'] = self.process_started
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.config_path is not None:
            result['ConfigPath'] = self.config_path
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.port is not None:
            result['Port'] = self.port
        if self.cmdline is not None:
            result['Cmdline'] = self.cmdline
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.listen_ip is not None:
            result['ListenIp'] = self.listen_ip
        if self.version is not None:
            result['Version'] = self.version
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.listen_status is not None:
            result['ListenStatus'] = self.listen_status
        if self.name is not None:
            result['Name'] = self.name
        if self.create is not None:
            result['Create'] = self.create
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.process_user is not None:
            result['ProcessUser'] = self.process_user
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.web_path is not None:
            result['WebPath'] = self.web_path
        if self.ppid is not None:
            result['Ppid'] = self.ppid
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.listen_protocol is not None:
            result['ListenProtocol'] = self.listen_protocol
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.path is not None:
            result['Path'] = self.path
        if self.container_name is not None:
            result['ContainerName'] = self.container_name
        if self.proof is not None:
            result['Proof'] = self.proof
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('BizTypeDispaly') is not None:
            self.biz_type_dispaly = m.get('BizTypeDispaly')
        if m.get('ProcessStarted') is not None:
            self.process_started = m.get('ProcessStarted')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('ConfigPath') is not None:
            self.config_path = m.get('ConfigPath')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Cmdline') is not None:
            self.cmdline = m.get('Cmdline')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('ListenIp') is not None:
            self.listen_ip = m.get('ListenIp')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('ListenStatus') is not None:
            self.listen_status = m.get('ListenStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('ProcessUser') is not None:
            self.process_user = m.get('ProcessUser')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('WebPath') is not None:
            self.web_path = m.get('WebPath')
        if m.get('Ppid') is not None:
            self.ppid = m.get('Ppid')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('ListenProtocol') is not None:
            self.listen_protocol = m.get('ListenProtocol')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('ContainerName') is not None:
            self.container_name = m.get('ContainerName')
        if m.get('Proof') is not None:
            self.proof = m.get('Proof')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        return self


class DescribePropertyScaDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribePropertyScaDetailResponseBodyPageInfo = None,
        propertys: List[DescribePropertyScaDetailResponseBodyPropertys] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.propertys = propertys

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyScaDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyScaDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        return self


class DescribePropertyScaDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyScaDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyScaDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertySoftwareDetailRequest(TeaModel):
    def __init__(
        self,
        remark: str = None,
        name: str = None,
        path: str = None,
        software_version: str = None,
        uuid: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.remark = remark
        self.name = name
        self.path = path
        self.software_version = software_version
        self.uuid = uuid
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.software_version is not None:
            result['SoftwareVersion'] = self.software_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('SoftwareVersion') is not None:
            self.software_version = m.get('SoftwareVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertySoftwareDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribePropertySoftwareDetailResponseBodyPropertys(TeaModel):
    def __init__(
        self,
        create: int = None,
        internet_ip: str = None,
        ip: str = None,
        instance_id: str = None,
        intranet_ip: str = None,
        install_time: str = None,
        uuid: str = None,
        version: str = None,
        instance_name: str = None,
        path: str = None,
        name: str = None,
        create_timestamp: int = None,
    ):
        self.create = create
        self.internet_ip = internet_ip
        self.ip = ip
        self.instance_id = instance_id
        self.intranet_ip = intranet_ip
        self.install_time = install_time
        self.uuid = uuid
        self.version = version
        self.instance_name = instance_name
        self.path = path
        self.name = name
        self.create_timestamp = create_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create is not None:
            result['Create'] = self.create
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.install_time is not None:
            result['InstallTime'] = self.install_time
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.version is not None:
            result['Version'] = self.version
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('InstallTime') is not None:
            self.install_time = m.get('InstallTime')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        return self


class DescribePropertySoftwareDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribePropertySoftwareDetailResponseBodyPageInfo = None,
        propertys: List[DescribePropertySoftwareDetailResponseBodyPropertys] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.propertys = propertys

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertySoftwareDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertySoftwareDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        return self


class DescribePropertySoftwareDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertySoftwareDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertySoftwareDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertySoftwareItemRequest(TeaModel):
    def __init__(
        self,
        force_flush: bool = None,
        name: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.force_flush = force_flush
        self.name = name
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force_flush is not None:
            result['ForceFlush'] = self.force_flush
        if self.name is not None:
            result['Name'] = self.name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForceFlush') is not None:
            self.force_flush = m.get('ForceFlush')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertySoftwareItemResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribePropertySoftwareItemResponseBodyPropertyItems(TeaModel):
    def __init__(
        self,
        name: str = None,
        count: int = None,
    ):
        self.name = name
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribePropertySoftwareItemResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribePropertySoftwareItemResponseBodyPageInfo = None,
        property_items: List[DescribePropertySoftwareItemResponseBodyPropertyItems] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.property_items = property_items

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.property_items:
            for k in self.property_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['PropertyItems'] = []
        if self.property_items is not None:
            for k in self.property_items:
                result['PropertyItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertySoftwareItemResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.property_items = []
        if m.get('PropertyItems') is not None:
            for k in m.get('PropertyItems'):
                temp_model = DescribePropertySoftwareItemResponseBodyPropertyItems()
                self.property_items.append(temp_model.from_map(k))
        return self


class DescribePropertySoftwareItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertySoftwareItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertySoftwareItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyUsageNewestRequest(TeaModel):
    def __init__(
        self,
        type: str = None,
    ):
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribePropertyUsageNewestResponseBodyNewestStatisticItems(TeaModel):
    def __init__(
        self,
        name: str = None,
        create: int = None,
    ):
        self.name = name
        self.create = create

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.create is not None:
            result['Create'] = self.create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Create') is not None:
            self.create = m.get('Create')
        return self


class DescribePropertyUsageNewestResponseBody(TeaModel):
    def __init__(
        self,
        type: str = None,
        item_count: int = None,
        request_id: str = None,
        newest_statistic_items: List[DescribePropertyUsageNewestResponseBodyNewestStatisticItems] = None,
    ):
        self.type = type
        self.item_count = item_count
        self.request_id = request_id
        self.newest_statistic_items = newest_statistic_items

    def validate(self):
        if self.newest_statistic_items:
            for k in self.newest_statistic_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.item_count is not None:
            result['ItemCount'] = self.item_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['NewestStatisticItems'] = []
        if self.newest_statistic_items is not None:
            for k in self.newest_statistic_items:
                result['NewestStatisticItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ItemCount') is not None:
            self.item_count = m.get('ItemCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.newest_statistic_items = []
        if m.get('NewestStatisticItems') is not None:
            for k in m.get('NewestStatisticItems'):
                temp_model = DescribePropertyUsageNewestResponseBodyNewestStatisticItems()
                self.newest_statistic_items.append(temp_model.from_map(k))
        return self


class DescribePropertyUsageNewestResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyUsageNewestResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyUsageNewestResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyUserDetailRequest(TeaModel):
    def __init__(
        self,
        remark: str = None,
        user: str = None,
        is_root: str = None,
        uuid: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.remark = remark
        self.user = user
        self.is_root = is_root
        self.uuid = uuid
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.user is not None:
            result['User'] = self.user
        if self.is_root is not None:
            result['IsRoot'] = self.is_root
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('IsRoot') is not None:
            self.is_root = m.get('IsRoot')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertyUserDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribePropertyUserDetailResponseBodyPropertys(TeaModel):
    def __init__(
        self,
        status: str = None,
        create: str = None,
        last_login_ip: str = None,
        internet_ip: str = None,
        last_login_time: str = None,
        is_root: str = None,
        ip: str = None,
        user: str = None,
        instance_id: str = None,
        intranet_ip: str = None,
        password_expiration_date: str = None,
        uuid: str = None,
        last_login_timestamp: int = None,
        instance_name: str = None,
        accounts_expiration_date: str = None,
        create_timestamp: int = None,
        group_names: List[str] = None,
    ):
        self.status = status
        self.create = create
        self.last_login_ip = last_login_ip
        self.internet_ip = internet_ip
        self.last_login_time = last_login_time
        self.is_root = is_root
        self.ip = ip
        self.user = user
        self.instance_id = instance_id
        self.intranet_ip = intranet_ip
        self.password_expiration_date = password_expiration_date
        self.uuid = uuid
        self.last_login_timestamp = last_login_timestamp
        self.instance_name = instance_name
        self.accounts_expiration_date = accounts_expiration_date
        self.create_timestamp = create_timestamp
        self.group_names = group_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.create is not None:
            result['Create'] = self.create
        if self.last_login_ip is not None:
            result['LastLoginIp'] = self.last_login_ip
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.last_login_time is not None:
            result['LastLoginTime'] = self.last_login_time
        if self.is_root is not None:
            result['IsRoot'] = self.is_root
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.user is not None:
            result['User'] = self.user
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.password_expiration_date is not None:
            result['PasswordExpirationDate'] = self.password_expiration_date
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.last_login_timestamp is not None:
            result['LastLoginTimestamp'] = self.last_login_timestamp
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.accounts_expiration_date is not None:
            result['AccountsExpirationDate'] = self.accounts_expiration_date
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.group_names is not None:
            result['GroupNames'] = self.group_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('LastLoginIp') is not None:
            self.last_login_ip = m.get('LastLoginIp')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('LastLoginTime') is not None:
            self.last_login_time = m.get('LastLoginTime')
        if m.get('IsRoot') is not None:
            self.is_root = m.get('IsRoot')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('PasswordExpirationDate') is not None:
            self.password_expiration_date = m.get('PasswordExpirationDate')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('LastLoginTimestamp') is not None:
            self.last_login_timestamp = m.get('LastLoginTimestamp')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('AccountsExpirationDate') is not None:
            self.accounts_expiration_date = m.get('AccountsExpirationDate')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('GroupNames') is not None:
            self.group_names = m.get('GroupNames')
        return self


class DescribePropertyUserDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribePropertyUserDetailResponseBodyPageInfo = None,
        propertys: List[DescribePropertyUserDetailResponseBodyPropertys] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.propertys = propertys

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyUserDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyUserDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        return self


class DescribePropertyUserDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyUserDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyUserDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyUserItemRequest(TeaModel):
    def __init__(
        self,
        force_flush: bool = None,
        user: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.force_flush = force_flush
        self.user = user
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force_flush is not None:
            result['ForceFlush'] = self.force_flush
        if self.user is not None:
            result['User'] = self.user
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForceFlush') is not None:
            self.force_flush = m.get('ForceFlush')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertyUserItemResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribePropertyUserItemResponseBodyPropertyItems(TeaModel):
    def __init__(
        self,
        user: str = None,
        count: int = None,
    ):
        self.user = user
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user is not None:
            result['User'] = self.user
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribePropertyUserItemResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribePropertyUserItemResponseBodyPageInfo = None,
        property_items: List[DescribePropertyUserItemResponseBodyPropertyItems] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.property_items = property_items

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.property_items:
            for k in self.property_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['PropertyItems'] = []
        if self.property_items is not None:
            for k in self.property_items:
                result['PropertyItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyUserItemResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.property_items = []
        if m.get('PropertyItems') is not None:
            for k in m.get('PropertyItems'):
                temp_model = DescribePropertyUserItemResponseBodyPropertyItems()
                self.property_items.append(temp_model.from_map(k))
        return self


class DescribePropertyUserItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyUserItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyUserItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeQuaraFileDownloadInfoRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        quara_file_id: int = None,
        from_: str = None,
    ):
        self.source_ip = source_ip
        self.quara_file_id = quara_file_id
        self.from_ = from_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.quara_file_id is not None:
            result['QuaraFileId'] = self.quara_file_id
        if self.from_ is not None:
            result['From'] = self.from_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('QuaraFileId') is not None:
            self.quara_file_id = m.get('QuaraFileId')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        return self


class DescribeQuaraFileDownloadInfoResponseBody(TeaModel):
    def __init__(
        self,
        uuid: str = None,
        quara_file_id: int = None,
        request_id: str = None,
        download_url: str = None,
        path: str = None,
        md_5: str = None,
        tag: str = None,
    ):
        self.uuid = uuid
        self.quara_file_id = quara_file_id
        self.request_id = request_id
        self.download_url = download_url
        self.path = path
        self.md_5 = md_5
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.quara_file_id is not None:
            result['QuaraFileId'] = self.quara_file_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.path is not None:
            result['Path'] = self.path
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('QuaraFileId') is not None:
            self.quara_file_id = m.get('QuaraFileId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class DescribeQuaraFileDownloadInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeQuaraFileDownloadInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeQuaraFileDownloadInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRestoreJobsRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        status: str = None,
        machine_remark: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.status = status
        self.machine_remark = machine_remark
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        if self.machine_remark is not None:
            result['MachineRemark'] = self.machine_remark
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('MachineRemark') is not None:
            self.machine_remark = m.get('MachineRemark')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeRestoreJobsResponseBodyRestoreJobs(TeaModel):
    def __init__(
        self,
        id: int = None,
        created_time: int = None,
        updated_time: int = None,
        uuid: str = None,
        message: str = None,
        restore_id: str = None,
        client_id: str = None,
        vault_id: str = None,
        snapshot_id: str = None,
        snapshot_hash: str = None,
        source: str = None,
        target: str = None,
        status: str = None,
        restore_type: str = None,
        speed: int = None,
        complete_time: int = None,
        eta: int = None,
        error_count: int = None,
        bytes_done: int = None,
        bytes_total: int = None,
        items_done: int = None,
        items_total: int = None,
        actual_bytes: int = None,
        percentage: int = None,
        error_type: str = None,
        source_client_id: str = None,
        snapshot_version: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        error_file: str = None,
        error_file_url: str = None,
        request_id: str = None,
        restore_name: str = None,
        instance_id: str = None,
        extra: str = None,
        duration: int = None,
        exit_code: str = None,
        gmt_create: str = None,
        gmt_modified: int = None,
        excludes: str = None,
        includes: str = None,
    ):
        self.id = id
        self.created_time = created_time
        self.updated_time = updated_time
        self.uuid = uuid
        self.message = message
        self.restore_id = restore_id
        self.client_id = client_id
        self.vault_id = vault_id
        self.snapshot_id = snapshot_id
        self.snapshot_hash = snapshot_hash
        self.source = source
        self.target = target
        self.status = status
        self.restore_type = restore_type
        self.speed = speed
        self.complete_time = complete_time
        self.eta = eta
        self.error_count = error_count
        self.bytes_done = bytes_done
        self.bytes_total = bytes_total
        self.items_done = items_done
        self.items_total = items_total
        self.actual_bytes = actual_bytes
        self.percentage = percentage
        self.error_type = error_type
        self.source_client_id = source_client_id
        self.snapshot_version = snapshot_version
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.error_file = error_file
        self.error_file_url = error_file_url
        self.request_id = request_id
        self.restore_name = restore_name
        self.instance_id = instance_id
        self.extra = extra
        self.duration = duration
        self.exit_code = exit_code
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.excludes = excludes
        self.includes = includes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.updated_time is not None:
            result['UpdatedTime'] = self.updated_time
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.message is not None:
            result['Message'] = self.message
        if self.restore_id is not None:
            result['RestoreId'] = self.restore_id
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.vault_id is not None:
            result['VaultId'] = self.vault_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.snapshot_hash is not None:
            result['SnapshotHash'] = self.snapshot_hash
        if self.source is not None:
            result['Source'] = self.source
        if self.target is not None:
            result['Target'] = self.target
        if self.status is not None:
            result['Status'] = self.status
        if self.restore_type is not None:
            result['RestoreType'] = self.restore_type
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.eta is not None:
            result['Eta'] = self.eta
        if self.error_count is not None:
            result['ErrorCount'] = self.error_count
        if self.bytes_done is not None:
            result['BytesDone'] = self.bytes_done
        if self.bytes_total is not None:
            result['BytesTotal'] = self.bytes_total
        if self.items_done is not None:
            result['ItemsDone'] = self.items_done
        if self.items_total is not None:
            result['ItemsTotal'] = self.items_total
        if self.actual_bytes is not None:
            result['ActualBytes'] = self.actual_bytes
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.error_type is not None:
            result['ErrorType'] = self.error_type
        if self.source_client_id is not None:
            result['SourceClientId'] = self.source_client_id
        if self.snapshot_version is not None:
            result['SnapshotVersion'] = self.snapshot_version
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.error_file is not None:
            result['ErrorFile'] = self.error_file
        if self.error_file_url is not None:
            result['ErrorFileUrl'] = self.error_file_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.restore_name is not None:
            result['RestoreName'] = self.restore_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.exit_code is not None:
            result['ExitCode'] = self.exit_code
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.excludes is not None:
            result['Excludes'] = self.excludes
        if self.includes is not None:
            result['Includes'] = self.includes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('UpdatedTime') is not None:
            self.updated_time = m.get('UpdatedTime')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RestoreId') is not None:
            self.restore_id = m.get('RestoreId')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('VaultId') is not None:
            self.vault_id = m.get('VaultId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('SnapshotHash') is not None:
            self.snapshot_hash = m.get('SnapshotHash')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RestoreType') is not None:
            self.restore_type = m.get('RestoreType')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('Eta') is not None:
            self.eta = m.get('Eta')
        if m.get('ErrorCount') is not None:
            self.error_count = m.get('ErrorCount')
        if m.get('BytesDone') is not None:
            self.bytes_done = m.get('BytesDone')
        if m.get('BytesTotal') is not None:
            self.bytes_total = m.get('BytesTotal')
        if m.get('ItemsDone') is not None:
            self.items_done = m.get('ItemsDone')
        if m.get('ItemsTotal') is not None:
            self.items_total = m.get('ItemsTotal')
        if m.get('ActualBytes') is not None:
            self.actual_bytes = m.get('ActualBytes')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('ErrorType') is not None:
            self.error_type = m.get('ErrorType')
        if m.get('SourceClientId') is not None:
            self.source_client_id = m.get('SourceClientId')
        if m.get('SnapshotVersion') is not None:
            self.snapshot_version = m.get('SnapshotVersion')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('ErrorFile') is not None:
            self.error_file = m.get('ErrorFile')
        if m.get('ErrorFileUrl') is not None:
            self.error_file_url = m.get('ErrorFileUrl')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RestoreName') is not None:
            self.restore_name = m.get('RestoreName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ExitCode') is not None:
            self.exit_code = m.get('ExitCode')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Excludes') is not None:
            self.excludes = m.get('Excludes')
        if m.get('Includes') is not None:
            self.includes = m.get('Includes')
        return self


class DescribeRestoreJobsResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        page_size: int = None,
        total_count: int = None,
        current_page: int = None,
    ):
        self.count = count
        self.page_size = page_size
        self.total_count = total_count
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeRestoreJobsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        restore_jobs: List[DescribeRestoreJobsResponseBodyRestoreJobs] = None,
        page_info: DescribeRestoreJobsResponseBodyPageInfo = None,
    ):
        self.request_id = request_id
        self.restore_jobs = restore_jobs
        self.page_info = page_info

    def validate(self):
        if self.restore_jobs:
            for k in self.restore_jobs:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['RestoreJobs'] = []
        if self.restore_jobs is not None:
            for k in self.restore_jobs:
                result['RestoreJobs'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.restore_jobs = []
        if m.get('RestoreJobs') is not None:
            for k in m.get('RestoreJobs'):
                temp_model = DescribeRestoreJobsResponseBodyRestoreJobs()
                self.restore_jobs.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeRestoreJobsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        return self


class DescribeRestoreJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRestoreJobsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRestoreJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskCheckItemResultRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        lang: str = None,
        item_id: int = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.lang = lang
        self.item_id = item_id
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeRiskCheckItemResultResponseBodyPageContentResource(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        content_resource: str = None,
        page_size: int = None,
        total_count: int = None,
        page_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.content_resource = content_resource
        self.page_size = page_size
        self.total_count = total_count
        self.page_count = page_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.content_resource is not None:
            result['ContentResource'] = self.content_resource
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ContentResource') is not None:
            self.content_resource = m.get('ContentResource')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeRiskCheckItemResultResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_content_resource: DescribeRiskCheckItemResultResponseBodyPageContentResource = None,
    ):
        self.request_id = request_id
        self.page_content_resource = page_content_resource

    def validate(self):
        if self.page_content_resource:
            self.page_content_resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_content_resource is not None:
            result['PageContentResource'] = self.page_content_resource.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageContentResource') is not None:
            temp_model = DescribeRiskCheckItemResultResponseBodyPageContentResource()
            self.page_content_resource = temp_model.from_map(m['PageContentResource'])
        return self


class DescribeRiskCheckItemResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRiskCheckItemResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskCheckItemResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskCheckResultRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        lang: str = None,
        group_id: int = None,
        current_page: int = None,
        risk_level: str = None,
        status: str = None,
        asset_type: str = None,
        name: str = None,
        page_size: int = None,
        query_flag: str = None,
        item_ids: List[str] = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.lang = lang
        self.group_id = group_id
        self.current_page = current_page
        self.risk_level = risk_level
        self.status = status
        self.asset_type = asset_type
        self.name = name
        self.page_size = page_size
        self.query_flag = query_flag
        self.item_ids = item_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.status is not None:
            result['Status'] = self.status
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_flag is not None:
            result['QueryFlag'] = self.query_flag
        if self.item_ids is not None:
            result['ItemIds'] = self.item_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryFlag') is not None:
            self.query_flag = m.get('QueryFlag')
        if m.get('ItemIds') is not None:
            self.item_ids = m.get('ItemIds')
        return self


class DescribeRiskCheckResultResponseBodyListRiskItemResources(TeaModel):
    def __init__(
        self,
        content_resource: str = None,
        resource_name: str = None,
    ):
        self.content_resource = content_resource
        self.resource_name = resource_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_resource is not None:
            result['ContentResource'] = self.content_resource
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContentResource') is not None:
            self.content_resource = m.get('ContentResource')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        return self


class DescribeRiskCheckResultResponseBodyList(TeaModel):
    def __init__(
        self,
        risk_level: str = None,
        status: str = None,
        type: str = None,
        sort: int = None,
        repair_status: str = None,
        remaining_time: int = None,
        item_id: int = None,
        start_status: str = None,
        affected_count: int = None,
        risk_assert_type: str = None,
        title: str = None,
        task_id: int = None,
        check_time: int = None,
        risk_item_resources: List[DescribeRiskCheckResultResponseBodyListRiskItemResources] = None,
    ):
        self.risk_level = risk_level
        self.status = status
        self.type = type
        self.sort = sort
        self.repair_status = repair_status
        self.remaining_time = remaining_time
        self.item_id = item_id
        self.start_status = start_status
        self.affected_count = affected_count
        self.risk_assert_type = risk_assert_type
        self.title = title
        self.task_id = task_id
        self.check_time = check_time
        self.risk_item_resources = risk_item_resources

    def validate(self):
        if self.risk_item_resources:
            for k in self.risk_item_resources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.repair_status is not None:
            result['RepairStatus'] = self.repair_status
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.start_status is not None:
            result['StartStatus'] = self.start_status
        if self.affected_count is not None:
            result['AffectedCount'] = self.affected_count
        if self.risk_assert_type is not None:
            result['RiskAssertType'] = self.risk_assert_type
        if self.title is not None:
            result['Title'] = self.title
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.check_time is not None:
            result['CheckTime'] = self.check_time
        result['RiskItemResources'] = []
        if self.risk_item_resources is not None:
            for k in self.risk_item_resources:
                result['RiskItemResources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('RepairStatus') is not None:
            self.repair_status = m.get('RepairStatus')
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('StartStatus') is not None:
            self.start_status = m.get('StartStatus')
        if m.get('AffectedCount') is not None:
            self.affected_count = m.get('AffectedCount')
        if m.get('RiskAssertType') is not None:
            self.risk_assert_type = m.get('RiskAssertType')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('CheckTime') is not None:
            self.check_time = m.get('CheckTime')
        self.risk_item_resources = []
        if m.get('RiskItemResources') is not None:
            for k in m.get('RiskItemResources'):
                temp_model = DescribeRiskCheckResultResponseBodyListRiskItemResources()
                self.risk_item_resources.append(temp_model.from_map(k))
        return self


class DescribeRiskCheckResultResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        request_id: str = None,
        page_size: int = None,
        total_count: int = None,
        page_count: int = None,
        count: int = None,
        list: List[DescribeRiskCheckResultResponseBodyList] = None,
    ):
        self.current_page = current_page
        self.request_id = request_id
        self.page_size = page_size
        self.total_count = total_count
        self.page_count = page_count
        self.count = count
        self.list = list

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.count is not None:
            result['Count'] = self.count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeRiskCheckResultResponseBodyList()
                self.list.append(temp_model.from_map(k))
        return self


class DescribeRiskCheckResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRiskCheckResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskCheckResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskCheckSummaryRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        lang: str = None,
        resource_directory_account_id: str = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.lang = lang
        self.resource_directory_account_id = resource_directory_account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        return self


class DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryRiskLevelCount(TeaModel):
    def __init__(
        self,
        key: str = None,
        count: int = None,
    ):
        self.key = key
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroupsCountByStatus(TeaModel):
    def __init__(
        self,
        status: str = None,
        count: int = None,
    ):
        self.status = status
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroups(TeaModel):
    def __init__(
        self,
        remaining_time: int = None,
        status: str = None,
        sort: int = None,
        title: str = None,
        id: int = None,
        count_by_status: List[DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroupsCountByStatus] = None,
    ):
        self.remaining_time = remaining_time
        self.status = status
        self.sort = sort
        self.title = title
        self.id = id
        self.count_by_status = count_by_status

    def validate(self):
        if self.count_by_status:
            for k in self.count_by_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.status is not None:
            result['Status'] = self.status
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.title is not None:
            result['Title'] = self.title
        if self.id is not None:
            result['Id'] = self.id
        result['CountByStatus'] = []
        if self.count_by_status is not None:
            for k in self.count_by_status:
                result['CountByStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        self.count_by_status = []
        if m.get('CountByStatus') is not None:
            for k in m.get('CountByStatus'):
                temp_model = DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroupsCountByStatus()
                self.count_by_status.append(temp_model.from_map(k))
        return self


class DescribeRiskCheckSummaryResponseBodyRiskCheckSummary(TeaModel):
    def __init__(
        self,
        item_count: int = None,
        affected_asset_count: int = None,
        disabled_risk_count: int = None,
        risk_count: int = None,
        risk_rate: float = None,
        previous_count: int = None,
        previous_time: int = None,
        enabled_risk_count: int = None,
        risk_level_count: List[DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryRiskLevelCount] = None,
        groups: List[DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroups] = None,
    ):
        self.item_count = item_count
        self.affected_asset_count = affected_asset_count
        self.disabled_risk_count = disabled_risk_count
        self.risk_count = risk_count
        self.risk_rate = risk_rate
        self.previous_count = previous_count
        self.previous_time = previous_time
        self.enabled_risk_count = enabled_risk_count
        self.risk_level_count = risk_level_count
        self.groups = groups

    def validate(self):
        if self.risk_level_count:
            for k in self.risk_level_count:
                if k:
                    k.validate()
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_count is not None:
            result['ItemCount'] = self.item_count
        if self.affected_asset_count is not None:
            result['AffectedAssetCount'] = self.affected_asset_count
        if self.disabled_risk_count is not None:
            result['DisabledRiskCount'] = self.disabled_risk_count
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        if self.risk_rate is not None:
            result['RiskRate'] = self.risk_rate
        if self.previous_count is not None:
            result['PreviousCount'] = self.previous_count
        if self.previous_time is not None:
            result['PreviousTime'] = self.previous_time
        if self.enabled_risk_count is not None:
            result['EnabledRiskCount'] = self.enabled_risk_count
        result['RiskLevelCount'] = []
        if self.risk_level_count is not None:
            for k in self.risk_level_count:
                result['RiskLevelCount'].append(k.to_map() if k else None)
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemCount') is not None:
            self.item_count = m.get('ItemCount')
        if m.get('AffectedAssetCount') is not None:
            self.affected_asset_count = m.get('AffectedAssetCount')
        if m.get('DisabledRiskCount') is not None:
            self.disabled_risk_count = m.get('DisabledRiskCount')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        if m.get('RiskRate') is not None:
            self.risk_rate = m.get('RiskRate')
        if m.get('PreviousCount') is not None:
            self.previous_count = m.get('PreviousCount')
        if m.get('PreviousTime') is not None:
            self.previous_time = m.get('PreviousTime')
        if m.get('EnabledRiskCount') is not None:
            self.enabled_risk_count = m.get('EnabledRiskCount')
        self.risk_level_count = []
        if m.get('RiskLevelCount') is not None:
            for k in m.get('RiskLevelCount'):
                temp_model = DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryRiskLevelCount()
                self.risk_level_count.append(temp_model.from_map(k))
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroups()
                self.groups.append(temp_model.from_map(k))
        return self


class DescribeRiskCheckSummaryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        risk_check_summary: DescribeRiskCheckSummaryResponseBodyRiskCheckSummary = None,
    ):
        self.request_id = request_id
        self.risk_check_summary = risk_check_summary

    def validate(self):
        if self.risk_check_summary:
            self.risk_check_summary.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.risk_check_summary is not None:
            result['RiskCheckSummary'] = self.risk_check_summary.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RiskCheckSummary') is not None:
            temp_model = DescribeRiskCheckSummaryResponseBodyRiskCheckSummary()
            self.risk_check_summary = temp_model.from_map(m['RiskCheckSummary'])
        return self


class DescribeRiskCheckSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRiskCheckSummaryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskCheckSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskItemTypeRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        lang: str = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeRiskItemTypeResponseBodyList(TeaModel):
    def __init__(
        self,
        id: int = None,
        title: str = None,
    ):
        self.id = id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class DescribeRiskItemTypeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        list: List[DescribeRiskItemTypeResponseBodyList] = None,
    ):
        self.request_id = request_id
        self.list = list

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeRiskItemTypeResponseBodyList()
                self.list.append(temp_model.from_map(k))
        return self


class DescribeRiskItemTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRiskItemTypeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskItemTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskListCheckResultRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        lang: str = None,
        current_page: int = None,
        page_size: int = None,
        instance_ids: List[str] = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.lang = lang
        self.current_page = current_page
        self.page_size = page_size
        self.instance_ids = instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        return self


class DescribeRiskListCheckResultResponseBodyList(TeaModel):
    def __init__(
        self,
        risk_count: int = None,
        instance_id: str = None,
    ):
        self.risk_count = risk_count
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.risk_count is not None:
            result['riskCount'] = self.risk_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('riskCount') is not None:
            self.risk_count = m.get('riskCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeRiskListCheckResultResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        list: List[DescribeRiskListCheckResultResponseBodyList] = None,
    ):
        self.request_id = request_id
        self.list = list

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeRiskListCheckResultResponseBodyList()
                self.list.append(temp_model.from_map(k))
        return self


class DescribeRiskListCheckResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRiskListCheckResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskListCheckResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSasAssetStatisticsColumnRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
    ):
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSasAssetStatisticsColumnResponseBody(TeaModel):
    def __init__(
        self,
        statistics_column: str = None,
        request_id: str = None,
    ):
        self.statistics_column = statistics_column
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.statistics_column is not None:
            result['StatisticsColumn'] = self.statistics_column
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StatisticsColumn') is not None:
            self.statistics_column = m.get('StatisticsColumn')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeSasAssetStatisticsColumnResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSasAssetStatisticsColumnResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSasAssetStatisticsColumnResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScanTaskProgressRequest(TeaModel):
    def __init__(
        self,
        task_id: int = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeScanTaskProgressResponseBody(TeaModel):
    def __init__(
        self,
        target_info: str = None,
        request_id: str = None,
        scan_task_progress: str = None,
    ):
        self.target_info = target_info
        self.request_id = request_id
        self.scan_task_progress = scan_task_progress

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_info is not None:
            result['TargetInfo'] = self.target_info
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scan_task_progress is not None:
            result['ScanTaskProgress'] = self.scan_task_progress
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetInfo') is not None:
            self.target_info = m.get('TargetInfo')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScanTaskProgress') is not None:
            self.scan_task_progress = m.get('ScanTaskProgress')
        return self


class DescribeScanTaskProgressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeScanTaskProgressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScanTaskProgressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSearchConditionRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        type: str = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeSearchConditionResponseBodyConditionList(TeaModel):
    def __init__(
        self,
        condition_type: str = None,
        name_key: str = None,
        name: str = None,
        filter_conditions: str = None,
    ):
        self.condition_type = condition_type
        self.name_key = name_key
        self.name = name
        self.filter_conditions = filter_conditions

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_type is not None:
            result['ConditionType'] = self.condition_type
        if self.name_key is not None:
            result['NameKey'] = self.name_key
        if self.name is not None:
            result['Name'] = self.name
        if self.filter_conditions is not None:
            result['FilterConditions'] = self.filter_conditions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionType') is not None:
            self.condition_type = m.get('ConditionType')
        if m.get('NameKey') is not None:
            self.name_key = m.get('NameKey')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('FilterConditions') is not None:
            self.filter_conditions = m.get('FilterConditions')
        return self


class DescribeSearchConditionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        condition_list: List[DescribeSearchConditionResponseBodyConditionList] = None,
    ):
        self.request_id = request_id
        self.condition_list = condition_list

    def validate(self):
        if self.condition_list:
            for k in self.condition_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ConditionList'] = []
        if self.condition_list is not None:
            for k in self.condition_list:
                result['ConditionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.condition_list = []
        if m.get('ConditionList') is not None:
            for k in m.get('ConditionList'):
                temp_model = DescribeSearchConditionResponseBodyConditionList()
                self.condition_list.append(temp_model.from_map(k))
        return self


class DescribeSearchConditionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSearchConditionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSearchConditionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecureSuggestionRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
    ):
        self.source_ip = source_ip
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeSecureSuggestionResponseBodySuggestionsDetail(TeaModel):
    def __init__(
        self,
        title: str = None,
        description: str = None,
        sub_type: str = None,
    ):
        self.title = title
        self.description = description
        self.sub_type = sub_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.title is not None:
            result['Title'] = self.title
        if self.description is not None:
            result['Description'] = self.description
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        return self


class DescribeSecureSuggestionResponseBodySuggestions(TeaModel):
    def __init__(
        self,
        points: int = None,
        suggest_type: str = None,
        detail: List[DescribeSecureSuggestionResponseBodySuggestionsDetail] = None,
    ):
        self.points = points
        self.suggest_type = suggest_type
        self.detail = detail

    def validate(self):
        if self.detail:
            for k in self.detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.points is not None:
            result['Points'] = self.points
        if self.suggest_type is not None:
            result['SuggestType'] = self.suggest_type
        result['Detail'] = []
        if self.detail is not None:
            for k in self.detail:
                result['Detail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Points') is not None:
            self.points = m.get('Points')
        if m.get('SuggestType') is not None:
            self.suggest_type = m.get('SuggestType')
        self.detail = []
        if m.get('Detail') is not None:
            for k in m.get('Detail'):
                temp_model = DescribeSecureSuggestionResponseBodySuggestionsDetail()
                self.detail.append(temp_model.from_map(k))
        return self


class DescribeSecureSuggestionResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        suggestions: List[DescribeSecureSuggestionResponseBodySuggestions] = None,
    ):
        self.total_count = total_count
        self.request_id = request_id
        self.suggestions = suggestions

    def validate(self):
        if self.suggestions:
            for k in self.suggestions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Suggestions'] = []
        if self.suggestions is not None:
            for k in self.suggestions:
                result['Suggestions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.suggestions = []
        if m.get('Suggestions') is not None:
            for k in m.get('Suggestions'):
                temp_model = DescribeSecureSuggestionResponseBodySuggestions()
                self.suggestions.append(temp_model.from_map(k))
        return self


class DescribeSecureSuggestionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSecureSuggestionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecureSuggestionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityCheckScheduleConfigRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        lang: str = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeSecurityCheckScheduleConfigResponseBodyRiskCheckJobConfig(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        start_time: int = None,
        days_of_week: str = None,
    ):
        self.end_time = end_time
        self.start_time = start_time
        self.days_of_week = days_of_week

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.days_of_week is not None:
            result['DaysOfWeek'] = self.days_of_week
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('DaysOfWeek') is not None:
            self.days_of_week = m.get('DaysOfWeek')
        return self


class DescribeSecurityCheckScheduleConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        risk_check_job_config: DescribeSecurityCheckScheduleConfigResponseBodyRiskCheckJobConfig = None,
    ):
        self.request_id = request_id
        self.risk_check_job_config = risk_check_job_config

    def validate(self):
        if self.risk_check_job_config:
            self.risk_check_job_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.risk_check_job_config is not None:
            result['RiskCheckJobConfig'] = self.risk_check_job_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RiskCheckJobConfig') is not None:
            temp_model = DescribeSecurityCheckScheduleConfigResponseBodyRiskCheckJobConfig()
            self.risk_check_job_config = temp_model.from_map(m['RiskCheckJobConfig'])
        return self


class DescribeSecurityCheckScheduleConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSecurityCheckScheduleConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityCheckScheduleConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityEventOperationsRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        lang: str = None,
        security_event_id: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.lang = lang
        self.security_event_id = security_event_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        return self


class DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField(TeaModel):
    def __init__(
        self,
        mark_mis_type: str = None,
        filed_name: str = None,
        filed_alias_name: str = None,
        mark_mis_value: str = None,
        supported_mis_type: List[str] = None,
    ):
        self.mark_mis_type = mark_mis_type
        self.filed_name = filed_name
        self.filed_alias_name = filed_alias_name
        self.mark_mis_value = mark_mis_value
        self.supported_mis_type = supported_mis_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mark_mis_type is not None:
            result['MarkMisType'] = self.mark_mis_type
        if self.filed_name is not None:
            result['FiledName'] = self.filed_name
        if self.filed_alias_name is not None:
            result['FiledAliasName'] = self.filed_alias_name
        if self.mark_mis_value is not None:
            result['MarkMisValue'] = self.mark_mis_value
        if self.supported_mis_type is not None:
            result['SupportedMisType'] = self.supported_mis_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MarkMisType') is not None:
            self.mark_mis_type = m.get('MarkMisType')
        if m.get('FiledName') is not None:
            self.filed_name = m.get('FiledName')
        if m.get('FiledAliasName') is not None:
            self.filed_alias_name = m.get('FiledAliasName')
        if m.get('MarkMisValue') is not None:
            self.mark_mis_value = m.get('MarkMisValue')
        if m.get('SupportedMisType') is not None:
            self.supported_mis_type = m.get('SupportedMisType')
        return self


class DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource(TeaModel):
    def __init__(
        self,
        filed_name: str = None,
        filed_alias_name: str = None,
        mark_mis_value: str = None,
        supported_mis_type: List[str] = None,
    ):
        self.filed_name = filed_name
        self.filed_alias_name = filed_alias_name
        self.mark_mis_value = mark_mis_value
        self.supported_mis_type = supported_mis_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filed_name is not None:
            result['FiledName'] = self.filed_name
        if self.filed_alias_name is not None:
            result['FiledAliasName'] = self.filed_alias_name
        if self.mark_mis_value is not None:
            result['MarkMisValue'] = self.mark_mis_value
        if self.supported_mis_type is not None:
            result['SupportedMisType'] = self.supported_mis_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FiledName') is not None:
            self.filed_name = m.get('FiledName')
        if m.get('FiledAliasName') is not None:
            self.filed_alias_name = m.get('FiledAliasName')
        if m.get('MarkMisValue') is not None:
            self.mark_mis_value = m.get('MarkMisValue')
        if m.get('SupportedMisType') is not None:
            self.supported_mis_type = m.get('SupportedMisType')
        return self


class DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponse(TeaModel):
    def __init__(
        self,
        operation_params: str = None,
        operation_code: str = None,
        user_can_operate: bool = None,
        mark_field: List[DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField] = None,
        mark_fields_source: List[DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource] = None,
    ):
        self.operation_params = operation_params
        self.operation_code = operation_code
        self.user_can_operate = user_can_operate
        self.mark_field = mark_field
        self.mark_fields_source = mark_fields_source

    def validate(self):
        if self.mark_field:
            for k in self.mark_field:
                if k:
                    k.validate()
        if self.mark_fields_source:
            for k in self.mark_fields_source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operation_params is not None:
            result['OperationParams'] = self.operation_params
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.user_can_operate is not None:
            result['UserCanOperate'] = self.user_can_operate
        result['MarkField'] = []
        if self.mark_field is not None:
            for k in self.mark_field:
                result['MarkField'].append(k.to_map() if k else None)
        result['MarkFieldsSource'] = []
        if self.mark_fields_source is not None:
            for k in self.mark_fields_source:
                result['MarkFieldsSource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperationParams') is not None:
            self.operation_params = m.get('OperationParams')
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('UserCanOperate') is not None:
            self.user_can_operate = m.get('UserCanOperate')
        self.mark_field = []
        if m.get('MarkField') is not None:
            for k in m.get('MarkField'):
                temp_model = DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField()
                self.mark_field.append(temp_model.from_map(k))
        self.mark_fields_source = []
        if m.get('MarkFieldsSource') is not None:
            for k in m.get('MarkFieldsSource'):
                temp_model = DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource()
                self.mark_fields_source.append(temp_model.from_map(k))
        return self


class DescribeSecurityEventOperationsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_event_operations_response: List[DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponse] = None,
    ):
        self.request_id = request_id
        self.security_event_operations_response = security_event_operations_response

    def validate(self):
        if self.security_event_operations_response:
            for k in self.security_event_operations_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SecurityEventOperationsResponse'] = []
        if self.security_event_operations_response is not None:
            for k in self.security_event_operations_response:
                result['SecurityEventOperationsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.security_event_operations_response = []
        if m.get('SecurityEventOperationsResponse') is not None:
            for k in m.get('SecurityEventOperationsResponse'):
                temp_model = DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponse()
                self.security_event_operations_response.append(temp_model.from_map(k))
        return self


class DescribeSecurityEventOperationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSecurityEventOperationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityEventOperationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityEventOperationStatusRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        task_id: int = None,
        security_event_ids: List[str] = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.task_id = task_id
        self.security_event_ids = security_event_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        return self


class DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponseSecurityEventOperationStatuses(TeaModel):
    def __init__(
        self,
        status: str = None,
        security_event_id: str = None,
        error_code: str = None,
    ):
        self.status = status
        self.security_event_id = security_event_id
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponse(TeaModel):
    def __init__(
        self,
        task_status: str = None,
        security_event_operation_statuses: List[DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponseSecurityEventOperationStatuses] = None,
    ):
        self.task_status = task_status
        self.security_event_operation_statuses = security_event_operation_statuses

    def validate(self):
        if self.security_event_operation_statuses:
            for k in self.security_event_operation_statuses:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        result['SecurityEventOperationStatuses'] = []
        if self.security_event_operation_statuses is not None:
            for k in self.security_event_operation_statuses:
                result['SecurityEventOperationStatuses'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        self.security_event_operation_statuses = []
        if m.get('SecurityEventOperationStatuses') is not None:
            for k in m.get('SecurityEventOperationStatuses'):
                temp_model = DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponseSecurityEventOperationStatuses()
                self.security_event_operation_statuses.append(temp_model.from_map(k))
        return self


class DescribeSecurityEventOperationStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_event_operation_status_response: DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponse = None,
    ):
        self.request_id = request_id
        self.security_event_operation_status_response = security_event_operation_status_response

    def validate(self):
        if self.security_event_operation_status_response:
            self.security_event_operation_status_response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_event_operation_status_response is not None:
            result['SecurityEventOperationStatusResponse'] = self.security_event_operation_status_response.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityEventOperationStatusResponse') is not None:
            temp_model = DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponse()
            self.security_event_operation_status_response = temp_model.from_map(m['SecurityEventOperationStatusResponse'])
        return self


class DescribeSecurityEventOperationStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSecurityEventOperationStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityEventOperationStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityStatInfoRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        resource_directory_account_id: str = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.resource_directory_account_id = resource_directory_account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        return self


class DescribeSecurityStatInfoResponseBodySecurityEvent(TeaModel):
    def __init__(
        self,
        suspicious_count: int = None,
        serious_count: int = None,
        remind_count: int = None,
        total_count: int = None,
        value_array: List[str] = None,
        time_array: List[str] = None,
        remind_list: List[str] = None,
        levels_on: List[str] = None,
        date_array: List[str] = None,
        suspicious_list: List[str] = None,
        serious_list: List[str] = None,
    ):
        self.suspicious_count = suspicious_count
        self.serious_count = serious_count
        self.remind_count = remind_count
        self.total_count = total_count
        self.value_array = value_array
        self.time_array = time_array
        self.remind_list = remind_list
        self.levels_on = levels_on
        self.date_array = date_array
        self.suspicious_list = suspicious_list
        self.serious_list = serious_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.suspicious_count is not None:
            result['SuspiciousCount'] = self.suspicious_count
        if self.serious_count is not None:
            result['SeriousCount'] = self.serious_count
        if self.remind_count is not None:
            result['RemindCount'] = self.remind_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.value_array is not None:
            result['ValueArray'] = self.value_array
        if self.time_array is not None:
            result['TimeArray'] = self.time_array
        if self.remind_list is not None:
            result['RemindList'] = self.remind_list
        if self.levels_on is not None:
            result['LevelsOn'] = self.levels_on
        if self.date_array is not None:
            result['DateArray'] = self.date_array
        if self.suspicious_list is not None:
            result['SuspiciousList'] = self.suspicious_list
        if self.serious_list is not None:
            result['SeriousList'] = self.serious_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SuspiciousCount') is not None:
            self.suspicious_count = m.get('SuspiciousCount')
        if m.get('SeriousCount') is not None:
            self.serious_count = m.get('SeriousCount')
        if m.get('RemindCount') is not None:
            self.remind_count = m.get('RemindCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ValueArray') is not None:
            self.value_array = m.get('ValueArray')
        if m.get('TimeArray') is not None:
            self.time_array = m.get('TimeArray')
        if m.get('RemindList') is not None:
            self.remind_list = m.get('RemindList')
        if m.get('LevelsOn') is not None:
            self.levels_on = m.get('LevelsOn')
        if m.get('DateArray') is not None:
            self.date_array = m.get('DateArray')
        if m.get('SuspiciousList') is not None:
            self.suspicious_list = m.get('SuspiciousList')
        if m.get('SeriousList') is not None:
            self.serious_list = m.get('SeriousList')
        return self


class DescribeSecurityStatInfoResponseBodyAttackEvent(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        date_array: List[str] = None,
        value_array: List[str] = None,
    ):
        self.total_count = total_count
        self.date_array = date_array
        self.value_array = value_array

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.date_array is not None:
            result['DateArray'] = self.date_array
        if self.value_array is not None:
            result['ValueArray'] = self.value_array
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('DateArray') is not None:
            self.date_array = m.get('DateArray')
        if m.get('ValueArray') is not None:
            self.value_array = m.get('ValueArray')
        return self


class DescribeSecurityStatInfoResponseBodyHealthCheck(TeaModel):
    def __init__(
        self,
        high_count: int = None,
        low_count: int = None,
        total_count: int = None,
        medium_count: int = None,
        value_array: List[str] = None,
        time_array: List[str] = None,
        levels_on: List[str] = None,
        low_list: List[str] = None,
        medium_list: List[str] = None,
        date_array: List[str] = None,
        high_list: List[str] = None,
    ):
        self.high_count = high_count
        self.low_count = low_count
        self.total_count = total_count
        self.medium_count = medium_count
        self.value_array = value_array
        self.time_array = time_array
        self.levels_on = levels_on
        self.low_list = low_list
        self.medium_list = medium_list
        self.date_array = date_array
        self.high_list = high_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.high_count is not None:
            result['HighCount'] = self.high_count
        if self.low_count is not None:
            result['LowCount'] = self.low_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.medium_count is not None:
            result['MediumCount'] = self.medium_count
        if self.value_array is not None:
            result['ValueArray'] = self.value_array
        if self.time_array is not None:
            result['TimeArray'] = self.time_array
        if self.levels_on is not None:
            result['LevelsOn'] = self.levels_on
        if self.low_list is not None:
            result['LowList'] = self.low_list
        if self.medium_list is not None:
            result['MediumList'] = self.medium_list
        if self.date_array is not None:
            result['DateArray'] = self.date_array
        if self.high_list is not None:
            result['HighList'] = self.high_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HighCount') is not None:
            self.high_count = m.get('HighCount')
        if m.get('LowCount') is not None:
            self.low_count = m.get('LowCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('MediumCount') is not None:
            self.medium_count = m.get('MediumCount')
        if m.get('ValueArray') is not None:
            self.value_array = m.get('ValueArray')
        if m.get('TimeArray') is not None:
            self.time_array = m.get('TimeArray')
        if m.get('LevelsOn') is not None:
            self.levels_on = m.get('LevelsOn')
        if m.get('LowList') is not None:
            self.low_list = m.get('LowList')
        if m.get('MediumList') is not None:
            self.medium_list = m.get('MediumList')
        if m.get('DateArray') is not None:
            self.date_array = m.get('DateArray')
        if m.get('HighList') is not None:
            self.high_list = m.get('HighList')
        return self


class DescribeSecurityStatInfoResponseBodyVulnerability(TeaModel):
    def __init__(
        self,
        nntf_count: int = None,
        later_count: int = None,
        total_count: int = None,
        asap_count: int = None,
        nntf_list: List[str] = None,
        asap_list: List[str] = None,
        value_array: List[str] = None,
        time_array: List[str] = None,
        levels_on: List[str] = None,
        later_list: List[str] = None,
        date_array: List[str] = None,
    ):
        self.nntf_count = nntf_count
        self.later_count = later_count
        self.total_count = total_count
        self.asap_count = asap_count
        self.nntf_list = nntf_list
        self.asap_list = asap_list
        self.value_array = value_array
        self.time_array = time_array
        self.levels_on = levels_on
        self.later_list = later_list
        self.date_array = date_array

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        if self.nntf_list is not None:
            result['NntfList'] = self.nntf_list
        if self.asap_list is not None:
            result['AsapList'] = self.asap_list
        if self.value_array is not None:
            result['ValueArray'] = self.value_array
        if self.time_array is not None:
            result['TimeArray'] = self.time_array
        if self.levels_on is not None:
            result['LevelsOn'] = self.levels_on
        if self.later_list is not None:
            result['LaterList'] = self.later_list
        if self.date_array is not None:
            result['DateArray'] = self.date_array
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        if m.get('NntfList') is not None:
            self.nntf_list = m.get('NntfList')
        if m.get('AsapList') is not None:
            self.asap_list = m.get('AsapList')
        if m.get('ValueArray') is not None:
            self.value_array = m.get('ValueArray')
        if m.get('TimeArray') is not None:
            self.time_array = m.get('TimeArray')
        if m.get('LevelsOn') is not None:
            self.levels_on = m.get('LevelsOn')
        if m.get('LaterList') is not None:
            self.later_list = m.get('LaterList')
        if m.get('DateArray') is not None:
            self.date_array = m.get('DateArray')
        return self


class DescribeSecurityStatInfoResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        security_event: DescribeSecurityStatInfoResponseBodySecurityEvent = None,
        attack_event: DescribeSecurityStatInfoResponseBodyAttackEvent = None,
        health_check: DescribeSecurityStatInfoResponseBodyHealthCheck = None,
        vulnerability: DescribeSecurityStatInfoResponseBodyVulnerability = None,
    ):
        self.success = success
        self.request_id = request_id
        self.security_event = security_event
        self.attack_event = attack_event
        self.health_check = health_check
        self.vulnerability = vulnerability

    def validate(self):
        if self.security_event:
            self.security_event.validate()
        if self.attack_event:
            self.attack_event.validate()
        if self.health_check:
            self.health_check.validate()
        if self.vulnerability:
            self.vulnerability.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_event is not None:
            result['SecurityEvent'] = self.security_event.to_map()
        if self.attack_event is not None:
            result['AttackEvent'] = self.attack_event.to_map()
        if self.health_check is not None:
            result['HealthCheck'] = self.health_check.to_map()
        if self.vulnerability is not None:
            result['Vulnerability'] = self.vulnerability.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityEvent') is not None:
            temp_model = DescribeSecurityStatInfoResponseBodySecurityEvent()
            self.security_event = temp_model.from_map(m['SecurityEvent'])
        if m.get('AttackEvent') is not None:
            temp_model = DescribeSecurityStatInfoResponseBodyAttackEvent()
            self.attack_event = temp_model.from_map(m['AttackEvent'])
        if m.get('HealthCheck') is not None:
            temp_model = DescribeSecurityStatInfoResponseBodyHealthCheck()
            self.health_check = temp_model.from_map(m['HealthCheck'])
        if m.get('Vulnerability') is not None:
            temp_model = DescribeSecurityStatInfoResponseBodyVulnerability()
            self.vulnerability = temp_model.from_map(m['Vulnerability'])
        return self


class DescribeSecurityStatInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSecurityStatInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityStatInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeServiceLinkedRoleStatusResponseBodyRoleStatus(TeaModel):
    def __init__(
        self,
        status: bool = None,
    ):
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeServiceLinkedRoleStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        role_status: DescribeServiceLinkedRoleStatusResponseBodyRoleStatus = None,
    ):
        self.request_id = request_id
        self.role_status = role_status

    def validate(self):
        if self.role_status:
            self.role_status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.role_status is not None:
            result['RoleStatus'] = self.role_status.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RoleStatus') is not None:
            temp_model = DescribeServiceLinkedRoleStatusResponseBodyRoleStatus()
            self.role_status = temp_model.from_map(m['RoleStatus'])
        return self


class DescribeServiceLinkedRoleStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeServiceLinkedRoleStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeServiceLinkedRoleStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSimilarEventScenariosRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        security_event_id: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.security_event_id = security_event_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        return self


class DescribeSimilarEventScenariosResponseBodyScenarios(TeaModel):
    def __init__(
        self,
        code: str = None,
    ):
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DescribeSimilarEventScenariosResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scenarios: List[DescribeSimilarEventScenariosResponseBodyScenarios] = None,
    ):
        self.request_id = request_id
        self.scenarios = scenarios

    def validate(self):
        if self.scenarios:
            for k in self.scenarios:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Scenarios'] = []
        if self.scenarios is not None:
            for k in self.scenarios:
                result['Scenarios'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.scenarios = []
        if m.get('Scenarios') is not None:
            for k in m.get('Scenarios'):
                temp_model = DescribeSimilarEventScenariosResponseBodyScenarios()
                self.scenarios.append(temp_model.from_map(k))
        return self


class DescribeSimilarEventScenariosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSimilarEventScenariosResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSimilarEventScenariosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSimilarSecurityEventsRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        lang: str = None,
        task_id: int = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.lang = lang
        self.task_id = task_id
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeSimilarSecurityEventsResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeSimilarSecurityEventsResponseBodySecurityEventsResponse(TeaModel):
    def __init__(
        self,
        last_time: int = None,
        uuid: str = None,
        event_name: str = None,
        event_type: str = None,
        security_event_id: int = None,
        occurrence_time: int = None,
    ):
        self.last_time = last_time
        self.uuid = uuid
        self.event_name = event_name
        self.event_type = event_type
        self.security_event_id = security_event_id
        self.occurrence_time = occurrence_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.occurrence_time is not None:
            result['OccurrenceTime'] = self.occurrence_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('OccurrenceTime') is not None:
            self.occurrence_time = m.get('OccurrenceTime')
        return self


class DescribeSimilarSecurityEventsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeSimilarSecurityEventsResponseBodyPageInfo = None,
        security_events_response: List[DescribeSimilarSecurityEventsResponseBodySecurityEventsResponse] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.security_events_response = security_events_response

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.security_events_response:
            for k in self.security_events_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['SecurityEventsResponse'] = []
        if self.security_events_response is not None:
            for k in self.security_events_response:
                result['SecurityEventsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeSimilarSecurityEventsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.security_events_response = []
        if m.get('SecurityEventsResponse') is not None:
            for k in m.get('SecurityEventsResponse'):
                temp_model = DescribeSimilarSecurityEventsResponseBodySecurityEventsResponse()
                self.security_events_response.append(temp_model.from_map(k))
        return self


class DescribeSimilarSecurityEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSimilarSecurityEventsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSimilarSecurityEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSnapshotsRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        uuid: str = None,
        machine_region: str = None,
        machine_remark: str = None,
        status_list: str = None,
        page_size: int = None,
        current_page: int = None,
        next_token: str = None,
        api_version: str = None,
        is_ali_yun_ecs: str = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.uuid = uuid
        self.machine_region = machine_region
        self.machine_remark = machine_remark
        self.status_list = status_list
        self.page_size = page_size
        self.current_page = current_page
        self.next_token = next_token
        self.api_version = api_version
        self.is_ali_yun_ecs = is_ali_yun_ecs

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.machine_region is not None:
            result['MachineRegion'] = self.machine_region
        if self.machine_remark is not None:
            result['MachineRemark'] = self.machine_remark
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.api_version is not None:
            result['ApiVersion'] = self.api_version
        if self.is_ali_yun_ecs is not None:
            result['IsAliYunEcs'] = self.is_ali_yun_ecs
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('MachineRegion') is not None:
            self.machine_region = m.get('MachineRegion')
        if m.get('MachineRemark') is not None:
            self.machine_remark = m.get('MachineRemark')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ApiVersion') is not None:
            self.api_version = m.get('ApiVersion')
        if m.get('IsAliYunEcs') is not None:
            self.is_ali_yun_ecs = m.get('IsAliYunEcs')
        return self


class DescribeSnapshotsResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        next_token: str = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.next_token = next_token
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeSnapshotsResponseBodySnapshots(TeaModel):
    def __init__(
        self,
        container_snapshot_id: str = None,
        status: str = None,
        snapshot_hash: str = None,
        error_message: str = None,
        actual_items: int = None,
        vault_id: str = None,
        create_time: int = None,
        backup_type: str = None,
        actual_bytes: int = None,
        prefix: str = None,
        source_type: str = None,
        extra: str = None,
        server_id: str = None,
        exit_code: str = None,
        client_id: str = None,
        items_done: int = None,
        bytes_total: int = None,
        complete_time: int = None,
        retention: int = None,
        error_type: str = None,
        created_time: int = None,
        bucket: str = None,
        parent_snapshot_hash: str = None,
        machine_info_json: str = None,
        instance_id: str = None,
        plan_id: str = None,
        source: str = None,
        region_id: str = None,
        file_system_id: str = None,
        parent_hash: str = None,
        start_time: int = None,
        uuid: str = None,
        error_file: str = None,
        snapshot_type: str = None,
        snapshot_name: str = None,
        snapshot_option: str = None,
        updated_time: int = None,
        snapshot_id: str = None,
        job_id: str = None,
        size: int = None,
        path: str = None,
        error_count: int = None,
        duration: int = None,
        items_total: int = None,
        bytes_done: int = None,
        paths: List[str] = None,
    ):
        self.container_snapshot_id = container_snapshot_id
        self.status = status
        self.snapshot_hash = snapshot_hash
        self.error_message = error_message
        self.actual_items = actual_items
        self.vault_id = vault_id
        self.create_time = create_time
        self.backup_type = backup_type
        self.actual_bytes = actual_bytes
        self.prefix = prefix
        self.source_type = source_type
        self.extra = extra
        self.server_id = server_id
        self.exit_code = exit_code
        self.client_id = client_id
        self.items_done = items_done
        self.bytes_total = bytes_total
        self.complete_time = complete_time
        self.retention = retention
        self.error_type = error_type
        self.created_time = created_time
        self.bucket = bucket
        self.parent_snapshot_hash = parent_snapshot_hash
        self.machine_info_json = machine_info_json
        self.instance_id = instance_id
        self.plan_id = plan_id
        self.source = source
        self.region_id = region_id
        self.file_system_id = file_system_id
        self.parent_hash = parent_hash
        self.start_time = start_time
        self.uuid = uuid
        self.error_file = error_file
        self.snapshot_type = snapshot_type
        self.snapshot_name = snapshot_name
        self.snapshot_option = snapshot_option
        self.updated_time = updated_time
        self.snapshot_id = snapshot_id
        self.job_id = job_id
        self.size = size
        self.path = path
        self.error_count = error_count
        self.duration = duration
        self.items_total = items_total
        self.bytes_done = bytes_done
        self.paths = paths

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.container_snapshot_id is not None:
            result['ContainerSnapshotId'] = self.container_snapshot_id
        if self.status is not None:
            result['Status'] = self.status
        if self.snapshot_hash is not None:
            result['SnapshotHash'] = self.snapshot_hash
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.actual_items is not None:
            result['ActualItems'] = self.actual_items
        if self.vault_id is not None:
            result['VaultId'] = self.vault_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.actual_bytes is not None:
            result['ActualBytes'] = self.actual_bytes
        if self.prefix is not None:
            result['Prefix'] = self.prefix
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.exit_code is not None:
            result['ExitCode'] = self.exit_code
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.items_done is not None:
            result['ItemsDone'] = self.items_done
        if self.bytes_total is not None:
            result['BytesTotal'] = self.bytes_total
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.retention is not None:
            result['Retention'] = self.retention
        if self.error_type is not None:
            result['ErrorType'] = self.error_type
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.parent_snapshot_hash is not None:
            result['ParentSnapshotHash'] = self.parent_snapshot_hash
        if self.machine_info_json is not None:
            result['MachineInfoJson'] = self.machine_info_json
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.plan_id is not None:
            result['PlanId'] = self.plan_id
        if self.source is not None:
            result['Source'] = self.source
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.parent_hash is not None:
            result['ParentHash'] = self.parent_hash
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.error_file is not None:
            result['ErrorFile'] = self.error_file
        if self.snapshot_type is not None:
            result['SnapshotType'] = self.snapshot_type
        if self.snapshot_name is not None:
            result['SnapshotName'] = self.snapshot_name
        if self.snapshot_option is not None:
            result['SnapshotOption'] = self.snapshot_option
        if self.updated_time is not None:
            result['UpdatedTime'] = self.updated_time
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.size is not None:
            result['Size'] = self.size
        if self.path is not None:
            result['Path'] = self.path
        if self.error_count is not None:
            result['ErrorCount'] = self.error_count
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.items_total is not None:
            result['ItemsTotal'] = self.items_total
        if self.bytes_done is not None:
            result['BytesDone'] = self.bytes_done
        if self.paths is not None:
            result['Paths'] = self.paths
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContainerSnapshotId') is not None:
            self.container_snapshot_id = m.get('ContainerSnapshotId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SnapshotHash') is not None:
            self.snapshot_hash = m.get('SnapshotHash')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ActualItems') is not None:
            self.actual_items = m.get('ActualItems')
        if m.get('VaultId') is not None:
            self.vault_id = m.get('VaultId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('ActualBytes') is not None:
            self.actual_bytes = m.get('ActualBytes')
        if m.get('Prefix') is not None:
            self.prefix = m.get('Prefix')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('ExitCode') is not None:
            self.exit_code = m.get('ExitCode')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ItemsDone') is not None:
            self.items_done = m.get('ItemsDone')
        if m.get('BytesTotal') is not None:
            self.bytes_total = m.get('BytesTotal')
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('Retention') is not None:
            self.retention = m.get('Retention')
        if m.get('ErrorType') is not None:
            self.error_type = m.get('ErrorType')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('ParentSnapshotHash') is not None:
            self.parent_snapshot_hash = m.get('ParentSnapshotHash')
        if m.get('MachineInfoJson') is not None:
            self.machine_info_json = m.get('MachineInfoJson')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PlanId') is not None:
            self.plan_id = m.get('PlanId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('ParentHash') is not None:
            self.parent_hash = m.get('ParentHash')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('ErrorFile') is not None:
            self.error_file = m.get('ErrorFile')
        if m.get('SnapshotType') is not None:
            self.snapshot_type = m.get('SnapshotType')
        if m.get('SnapshotName') is not None:
            self.snapshot_name = m.get('SnapshotName')
        if m.get('SnapshotOption') is not None:
            self.snapshot_option = m.get('SnapshotOption')
        if m.get('UpdatedTime') is not None:
            self.updated_time = m.get('UpdatedTime')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('ErrorCount') is not None:
            self.error_count = m.get('ErrorCount')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ItemsTotal') is not None:
            self.items_total = m.get('ItemsTotal')
        if m.get('BytesDone') is not None:
            self.bytes_done = m.get('BytesDone')
        if m.get('Paths') is not None:
            self.paths = m.get('Paths')
        return self


class DescribeSnapshotsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeSnapshotsResponseBodyPageInfo = None,
        snapshots: List[DescribeSnapshotsResponseBodySnapshots] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.snapshots = snapshots

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.snapshots:
            for k in self.snapshots:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Snapshots'] = []
        if self.snapshots is not None:
            for k in self.snapshots:
                result['Snapshots'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeSnapshotsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.snapshots = []
        if m.get('Snapshots') is not None:
            for k in m.get('Snapshots'):
                temp_model = DescribeSnapshotsResponseBodySnapshots()
                self.snapshots.append(temp_model.from_map(k))
        return self


class DescribeSnapshotsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSnapshotsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSnapshotsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeStrategyRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        strategy_ids: str = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.strategy_ids = strategy_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.strategy_ids is not None:
            result['StrategyIds'] = self.strategy_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StrategyIds') is not None:
            self.strategy_ids = m.get('StrategyIds')
        return self


class DescribeStrategyResponseBodyStrategiesConfigTargets(TeaModel):
    def __init__(
        self,
        flag: str = None,
        target: str = None,
        target_type: str = None,
    ):
        self.flag = flag
        self.target = target
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeStrategyResponseBodyStrategies(TeaModel):
    def __init__(
        self,
        exec_status: int = None,
        type: int = None,
        cycle_start_time: int = None,
        ecs_count: int = None,
        process_rate: int = None,
        cycle_days: int = None,
        risk_count: int = None,
        name: str = None,
        pass_rate: int = None,
        id: int = None,
        config_targets: List[DescribeStrategyResponseBodyStrategiesConfigTargets] = None,
    ):
        self.exec_status = exec_status
        self.type = type
        self.cycle_start_time = cycle_start_time
        self.ecs_count = ecs_count
        self.process_rate = process_rate
        self.cycle_days = cycle_days
        self.risk_count = risk_count
        self.name = name
        self.pass_rate = pass_rate
        self.id = id
        self.config_targets = config_targets

    def validate(self):
        if self.config_targets:
            for k in self.config_targets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exec_status is not None:
            result['ExecStatus'] = self.exec_status
        if self.type is not None:
            result['Type'] = self.type
        if self.cycle_start_time is not None:
            result['CycleStartTime'] = self.cycle_start_time
        if self.ecs_count is not None:
            result['EcsCount'] = self.ecs_count
        if self.process_rate is not None:
            result['ProcessRate'] = self.process_rate
        if self.cycle_days is not None:
            result['CycleDays'] = self.cycle_days
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        if self.name is not None:
            result['Name'] = self.name
        if self.pass_rate is not None:
            result['PassRate'] = self.pass_rate
        if self.id is not None:
            result['Id'] = self.id
        result['ConfigTargets'] = []
        if self.config_targets is not None:
            for k in self.config_targets:
                result['ConfigTargets'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExecStatus') is not None:
            self.exec_status = m.get('ExecStatus')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('CycleStartTime') is not None:
            self.cycle_start_time = m.get('CycleStartTime')
        if m.get('EcsCount') is not None:
            self.ecs_count = m.get('EcsCount')
        if m.get('ProcessRate') is not None:
            self.process_rate = m.get('ProcessRate')
        if m.get('CycleDays') is not None:
            self.cycle_days = m.get('CycleDays')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PassRate') is not None:
            self.pass_rate = m.get('PassRate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        self.config_targets = []
        if m.get('ConfigTargets') is not None:
            for k in m.get('ConfigTargets'):
                temp_model = DescribeStrategyResponseBodyStrategiesConfigTargets()
                self.config_targets.append(temp_model.from_map(k))
        return self


class DescribeStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        strategies: List[DescribeStrategyResponseBodyStrategies] = None,
    ):
        self.request_id = request_id
        self.strategies = strategies

    def validate(self):
        if self.strategies:
            for k in self.strategies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Strategies'] = []
        if self.strategies is not None:
            for k in self.strategies:
                result['Strategies'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.strategies = []
        if m.get('Strategies') is not None:
            for k in m.get('Strategies'):
                temp_model = DescribeStrategyResponseBodyStrategies()
                self.strategies.append(temp_model.from_map(k))
        return self


class DescribeStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeStrategyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeStrategyExecDetailRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        strategy_id: int = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.source_ip = source_ip
        self.strategy_id = strategy_id
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeStrategyExecDetailResponseBodyFailedEcsList(TeaModel):
    def __init__(
        self,
        ip: str = None,
        intranet_ip: str = None,
        reason: str = None,
        instance_name: str = None,
    ):
        self.ip = ip
        self.intranet_ip = intranet_ip
        self.reason = reason
        self.instance_name = instance_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['IP'] = self.ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        return self


class DescribeStrategyExecDetailResponseBody(TeaModel):
    def __init__(
        self,
        in_process_count: int = None,
        end_time: str = None,
        start_time: str = None,
        percent: str = None,
        request_id: str = None,
        fail_count: int = None,
        source: str = None,
        success_count: int = None,
        failed_ecs_list: List[DescribeStrategyExecDetailResponseBodyFailedEcsList] = None,
    ):
        self.in_process_count = in_process_count
        self.end_time = end_time
        self.start_time = start_time
        self.percent = percent
        self.request_id = request_id
        self.fail_count = fail_count
        self.source = source
        self.success_count = success_count
        self.failed_ecs_list = failed_ecs_list

    def validate(self):
        if self.failed_ecs_list:
            for k in self.failed_ecs_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.in_process_count is not None:
            result['InProcessCount'] = self.in_process_count
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.source is not None:
            result['Source'] = self.source
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        result['FailedEcsList'] = []
        if self.failed_ecs_list is not None:
            for k in self.failed_ecs_list:
                result['FailedEcsList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InProcessCount') is not None:
            self.in_process_count = m.get('InProcessCount')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        self.failed_ecs_list = []
        if m.get('FailedEcsList') is not None:
            for k in m.get('FailedEcsList'):
                temp_model = DescribeStrategyExecDetailResponseBodyFailedEcsList()
                self.failed_ecs_list.append(temp_model.from_map(k))
        return self


class DescribeStrategyExecDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeStrategyExecDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeStrategyExecDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeStrategyProcessRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        strategy_id: int = None,
    ):
        self.source_ip = source_ip
        self.strategy_id = strategy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        return self


class DescribeStrategyProcessResponseBody(TeaModel):
    def __init__(
        self,
        exec_status: int = None,
        process_rate: int = None,
        strategy_id: int = None,
        request_id: str = None,
        pass_rate: str = None,
    ):
        self.exec_status = exec_status
        self.process_rate = process_rate
        self.strategy_id = strategy_id
        self.request_id = request_id
        self.pass_rate = pass_rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exec_status is not None:
            result['ExecStatus'] = self.exec_status
        if self.process_rate is not None:
            result['ProcessRate'] = self.process_rate
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.pass_rate is not None:
            result['PassRate'] = self.pass_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExecStatus') is not None:
            self.exec_status = m.get('ExecStatus')
        if m.get('ProcessRate') is not None:
            self.process_rate = m.get('ProcessRate')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PassRate') is not None:
            self.pass_rate = m.get('PassRate')
        return self


class DescribeStrategyProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeStrategyProcessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeStrategyProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeStrategyTargetRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        type: str = None,
        config: str = None,
    ):
        self.source_ip = source_ip
        self.type = type
        self.config = config

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        if self.config is not None:
            result['Config'] = self.config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        return self


class DescribeStrategyTargetResponseBodyStrategyTargets(TeaModel):
    def __init__(
        self,
        bind_uuid_count: int = None,
        flag: str = None,
        target: str = None,
        target_type: str = None,
    ):
        self.bind_uuid_count = bind_uuid_count
        self.flag = flag
        self.target = target
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_uuid_count is not None:
            result['BindUuidCount'] = self.bind_uuid_count
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindUuidCount') is not None:
            self.bind_uuid_count = m.get('BindUuidCount')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeStrategyTargetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        strategy_targets: List[DescribeStrategyTargetResponseBodyStrategyTargets] = None,
    ):
        self.request_id = request_id
        self.strategy_targets = strategy_targets

    def validate(self):
        if self.strategy_targets:
            for k in self.strategy_targets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['StrategyTargets'] = []
        if self.strategy_targets is not None:
            for k in self.strategy_targets:
                result['StrategyTargets'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.strategy_targets = []
        if m.get('StrategyTargets') is not None:
            for k in m.get('StrategyTargets'):
                temp_model = DescribeStrategyTargetResponseBodyStrategyTargets()
                self.strategy_targets.append(temp_model.from_map(k))
        return self


class DescribeStrategyTargetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeStrategyTargetResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeStrategyTargetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSummaryInfoRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        resource_directory_account_id: str = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.resource_directory_account_id = resource_directory_account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        return self


class DescribeSummaryInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        aegis_client_offline_count: int = None,
        aegis_client_online_count: int = None,
        security_score: int = None,
    ):
        self.request_id = request_id
        self.success = success
        self.aegis_client_offline_count = aegis_client_offline_count
        self.aegis_client_online_count = aegis_client_online_count
        self.security_score = security_score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.aegis_client_offline_count is not None:
            result['AegisClientOfflineCount'] = self.aegis_client_offline_count
        if self.aegis_client_online_count is not None:
            result['AegisClientOnlineCount'] = self.aegis_client_online_count
        if self.security_score is not None:
            result['SecurityScore'] = self.security_score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('AegisClientOfflineCount') is not None:
            self.aegis_client_offline_count = m.get('AegisClientOfflineCount')
        if m.get('AegisClientOnlineCount') is not None:
            self.aegis_client_online_count = m.get('AegisClientOnlineCount')
        if m.get('SecurityScore') is not None:
            self.security_score = m.get('SecurityScore')
        return self


class DescribeSummaryInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSummaryInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSummaryInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSupportRegionRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeSupportRegionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        support_region: List[str] = None,
    ):
        self.request_id = request_id
        self.support_region = support_region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.support_region is not None:
            result['SupportRegion'] = self.support_region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SupportRegion') is not None:
            self.support_region = m.get('SupportRegion')
        return self


class DescribeSupportRegionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSupportRegionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSupportRegionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspEventDetailRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        suspicious_event_id: int = None,
        from_: str = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.suspicious_event_id = suspicious_event_id
        self.from_ = from_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.suspicious_event_id is not None:
            result['SuspiciousEventId'] = self.suspicious_event_id
        if self.from_ is not None:
            result['From'] = self.from_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SuspiciousEventId') is not None:
            self.suspicious_event_id = m.get('SuspiciousEventId')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        return self


class DescribeSuspEventDetailResponseBodyDetails(TeaModel):
    def __init__(
        self,
        type: str = None,
        value: str = None,
        info_type: str = None,
        name_display: str = None,
        name: str = None,
    ):
        self.type = type
        self.value = value
        self.info_type = info_type
        self.name_display = name_display
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        if self.info_type is not None:
            result['InfoType'] = self.info_type
        if self.name_display is not None:
            result['NameDisplay'] = self.name_display
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('InfoType') is not None:
            self.info_type = m.get('InfoType')
        if m.get('NameDisplay') is not None:
            self.name_display = m.get('NameDisplay')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeSuspEventDetailResponseBody(TeaModel):
    def __init__(
        self,
        data_source: str = None,
        event_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        last_time: str = None,
        operate_msg: str = None,
        uuid: str = None,
        can_be_deal_on_line: bool = None,
        request_id: str = None,
        event_type_desc: str = None,
        event_desc: str = None,
        instance_name: str = None,
        event_status: str = None,
        sale_version: str = None,
        operate_error_code: str = None,
        sas_id: str = None,
        level: str = None,
        id: int = None,
        details: List[DescribeSuspEventDetailResponseBodyDetails] = None,
    ):
        self.data_source = data_source
        self.event_name = event_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.last_time = last_time
        self.operate_msg = operate_msg
        self.uuid = uuid
        self.can_be_deal_on_line = can_be_deal_on_line
        self.request_id = request_id
        self.event_type_desc = event_type_desc
        self.event_desc = event_desc
        self.instance_name = instance_name
        self.event_status = event_status
        self.sale_version = sale_version
        self.operate_error_code = operate_error_code
        self.sas_id = sas_id
        self.level = level
        self.id = id
        self.details = details

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.operate_msg is not None:
            result['OperateMsg'] = self.operate_msg
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.event_type_desc is not None:
            result['EventTypeDesc'] = self.event_type_desc
        if self.event_desc is not None:
            result['EventDesc'] = self.event_desc
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.event_status is not None:
            result['EventStatus'] = self.event_status
        if self.sale_version is not None:
            result['SaleVersion'] = self.sale_version
        if self.operate_error_code is not None:
            result['OperateErrorCode'] = self.operate_error_code
        if self.sas_id is not None:
            result['SasId'] = self.sas_id
        if self.level is not None:
            result['Level'] = self.level
        if self.id is not None:
            result['Id'] = self.id
        result['Details'] = []
        if self.details is not None:
            for k in self.details:
                result['Details'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('OperateMsg') is not None:
            self.operate_msg = m.get('OperateMsg')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('EventTypeDesc') is not None:
            self.event_type_desc = m.get('EventTypeDesc')
        if m.get('EventDesc') is not None:
            self.event_desc = m.get('EventDesc')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('EventStatus') is not None:
            self.event_status = m.get('EventStatus')
        if m.get('SaleVersion') is not None:
            self.sale_version = m.get('SaleVersion')
        if m.get('OperateErrorCode') is not None:
            self.operate_error_code = m.get('OperateErrorCode')
        if m.get('SasId') is not None:
            self.sas_id = m.get('SasId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        self.details = []
        if m.get('Details') is not None:
            for k in m.get('Details'):
                temp_model = DescribeSuspEventDetailResponseBodyDetails()
                self.details.append(temp_model.from_map(k))
        return self


class DescribeSuspEventDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSuspEventDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSuspEventDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspEventQuaraFilesRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        page_size: str = None,
        status: str = None,
        group_id: str = None,
        quara_tag: str = None,
        current_page: str = None,
        from_: str = None,
    ):
        self.source_ip = source_ip
        self.page_size = page_size
        self.status = status
        self.group_id = group_id
        self.quara_tag = quara_tag
        self.current_page = current_page
        self.from_ = from_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.quara_tag is not None:
            result['QuaraTag'] = self.quara_tag
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.from_ is not None:
            result['From'] = self.from_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('QuaraTag') is not None:
            self.quara_tag = m.get('QuaraTag')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        return self


class DescribeSuspEventQuaraFilesResponseBodyQuaraFiles(TeaModel):
    def __init__(
        self,
        link: str = None,
        status: str = None,
        event_name: str = None,
        internet_ip: str = None,
        ip: str = None,
        tag: str = None,
        instance_id: str = None,
        uuid: str = None,
        event_type: str = None,
        instance_name: str = None,
        path: str = None,
        md_5: str = None,
        id: int = None,
        modify_time: str = None,
    ):
        self.link = link
        self.status = status
        self.event_name = event_name
        self.internet_ip = internet_ip
        self.ip = ip
        self.tag = tag
        self.instance_id = instance_id
        self.uuid = uuid
        self.event_type = event_type
        self.instance_name = instance_name
        self.path = path
        self.md_5 = md_5
        self.id = id
        self.modify_time = modify_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.link is not None:
            result['Link'] = self.link
        if self.status is not None:
            result['Status'] = self.status
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.path is not None:
            result['Path'] = self.path
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.id is not None:
            result['Id'] = self.id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        return self


class DescribeSuspEventQuaraFilesResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        count: int = None,
        quara_files: List[DescribeSuspEventQuaraFilesResponseBodyQuaraFiles] = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.count = count
        self.quara_files = quara_files

    def validate(self):
        if self.quara_files:
            for k in self.quara_files:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        result['QuaraFiles'] = []
        if self.quara_files is not None:
            for k in self.quara_files:
                result['QuaraFiles'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.quara_files = []
        if m.get('QuaraFiles') is not None:
            for k in m.get('QuaraFiles'):
                temp_model = DescribeSuspEventQuaraFilesResponseBodyQuaraFiles()
                self.quara_files.append(temp_model.from_map(k))
        return self


class DescribeSuspEventQuaraFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSuspEventQuaraFilesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSuspEventQuaraFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspEventsRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        dealed: str = None,
        name: str = None,
        levels: str = None,
        parent_event_types: str = None,
        remark: str = None,
        status: str = None,
        page_size: str = None,
        current_page: str = None,
        lang: str = None,
        alarm_unique_info: str = None,
        unique_info: str = None,
        from_: str = None,
        source: str = None,
        group_id: int = None,
        uuids: str = None,
        cluster_id: str = None,
        container_field_name: str = None,
        container_field_value: str = None,
        target_type: str = None,
        operate_error_code_list: List[str] = None,
    ):
        self.source_ip = source_ip
        self.dealed = dealed
        self.name = name
        self.levels = levels
        self.parent_event_types = parent_event_types
        self.remark = remark
        self.status = status
        self.page_size = page_size
        self.current_page = current_page
        self.lang = lang
        self.alarm_unique_info = alarm_unique_info
        self.unique_info = unique_info
        self.from_ = from_
        self.source = source
        self.group_id = group_id
        self.uuids = uuids
        self.cluster_id = cluster_id
        self.container_field_name = container_field_name
        self.container_field_value = container_field_value
        self.target_type = target_type
        self.operate_error_code_list = operate_error_code_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.name is not None:
            result['Name'] = self.name
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.parent_event_types is not None:
            result['ParentEventTypes'] = self.parent_event_types
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.status is not None:
            result['Status'] = self.status
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.unique_info is not None:
            result['UniqueInfo'] = self.unique_info
        if self.from_ is not None:
            result['From'] = self.from_
        if self.source is not None:
            result['Source'] = self.source
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_field_name is not None:
            result['ContainerFieldName'] = self.container_field_name
        if self.container_field_value is not None:
            result['ContainerFieldValue'] = self.container_field_value
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.operate_error_code_list is not None:
            result['OperateErrorCodeList'] = self.operate_error_code_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('ParentEventTypes') is not None:
            self.parent_event_types = m.get('ParentEventTypes')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('UniqueInfo') is not None:
            self.unique_info = m.get('UniqueInfo')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerFieldName') is not None:
            self.container_field_name = m.get('ContainerFieldName')
        if m.get('ContainerFieldValue') is not None:
            self.container_field_value = m.get('ContainerFieldValue')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('OperateErrorCodeList') is not None:
            self.operate_error_code_list = m.get('OperateErrorCodeList')
        return self


class DescribeSuspEventsResponseBodySuspEventsDetails(TeaModel):
    def __init__(
        self,
        type: str = None,
        value: str = None,
        name: str = None,
        name_display: str = None,
        info_type: str = None,
        value_display: str = None,
    ):
        self.type = type
        self.value = value
        self.name = name
        self.name_display = name_display
        self.info_type = info_type
        self.value_display = value_display

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        if self.name is not None:
            result['Name'] = self.name
        if self.name_display is not None:
            result['NameDisplay'] = self.name_display
        if self.info_type is not None:
            result['InfoType'] = self.info_type
        if self.value_display is not None:
            result['ValueDisplay'] = self.value_display
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NameDisplay') is not None:
            self.name_display = m.get('NameDisplay')
        if m.get('InfoType') is not None:
            self.info_type = m.get('InfoType')
        if m.get('ValueDisplay') is not None:
            self.value_display = m.get('ValueDisplay')
        return self


class DescribeSuspEventsResponseBodySuspEventsEventNotes(TeaModel):
    def __init__(
        self,
        note: str = None,
        note_id: int = None,
        note_time: str = None,
    ):
        self.note = note
        self.note_id = note_id
        self.note_time = note_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note is not None:
            result['Note'] = self.note
        if self.note_id is not None:
            result['NoteId'] = self.note_id
        if self.note_time is not None:
            result['NoteTime'] = self.note_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Note') is not None:
            self.note = m.get('Note')
        if m.get('NoteId') is not None:
            self.note_id = m.get('NoteId')
        if m.get('NoteTime') is not None:
            self.note_time = m.get('NoteTime')
        return self


class DescribeSuspEventsResponseBodySuspEvents(TeaModel):
    def __init__(
        self,
        stages: str = None,
        internet_ip: str = None,
        k_8s_cluster_name: str = None,
        container_image_id: str = None,
        last_time_stamp: int = None,
        occurrence_time: str = None,
        alarm_unique_info: str = None,
        desc: str = None,
        can_cancel_fault: bool = None,
        alarm_event_name_display: str = None,
        app_name: str = None,
        security_event_ids: str = None,
        k_8s_cluster_id: str = None,
        container_image_name: str = None,
        mark_mis_rules: str = None,
        can_be_deal_on_line: bool = None,
        contain_hw_mode: bool = None,
        k_8s_node_id: str = None,
        instance_name: str = None,
        event_status: int = None,
        sale_version: str = None,
        operate_error_code: str = None,
        name: str = None,
        has_trace_info: bool = None,
        data_source: str = None,
        operate_time: int = None,
        event_sub_type: str = None,
        advanced: bool = None,
        occurrence_time_stamp: int = None,
        instance_id: str = None,
        alarm_event_type_display: str = None,
        intranet_ip: str = None,
        last_time: str = None,
        operate_msg: str = None,
        uuid: str = None,
        k_8s_pod_name: str = None,
        container_id: str = None,
        alarm_event_type: str = None,
        k_8s_namespace: str = None,
        auto_breaking: bool = None,
        k_8s_node_name: str = None,
        alarm_event_name: str = None,
        unique_info: str = None,
        level: str = None,
        id: int = None,
        details: List[DescribeSuspEventsResponseBodySuspEventsDetails] = None,
        event_notes: List[DescribeSuspEventsResponseBodySuspEventsEventNotes] = None,
    ):
        self.stages = stages
        self.internet_ip = internet_ip
        self.k_8s_cluster_name = k_8s_cluster_name
        self.container_image_id = container_image_id
        self.last_time_stamp = last_time_stamp
        self.occurrence_time = occurrence_time
        self.alarm_unique_info = alarm_unique_info
        self.desc = desc
        self.can_cancel_fault = can_cancel_fault
        self.alarm_event_name_display = alarm_event_name_display
        self.app_name = app_name
        self.security_event_ids = security_event_ids
        self.k_8s_cluster_id = k_8s_cluster_id
        self.container_image_name = container_image_name
        self.mark_mis_rules = mark_mis_rules
        self.can_be_deal_on_line = can_be_deal_on_line
        self.contain_hw_mode = contain_hw_mode
        self.k_8s_node_id = k_8s_node_id
        self.instance_name = instance_name
        self.event_status = event_status
        self.sale_version = sale_version
        self.operate_error_code = operate_error_code
        self.name = name
        self.has_trace_info = has_trace_info
        self.data_source = data_source
        self.operate_time = operate_time
        self.event_sub_type = event_sub_type
        self.advanced = advanced
        self.occurrence_time_stamp = occurrence_time_stamp
        self.instance_id = instance_id
        self.alarm_event_type_display = alarm_event_type_display
        self.intranet_ip = intranet_ip
        self.last_time = last_time
        self.operate_msg = operate_msg
        self.uuid = uuid
        self.k_8s_pod_name = k_8s_pod_name
        self.container_id = container_id
        self.alarm_event_type = alarm_event_type
        self.k_8s_namespace = k_8s_namespace
        self.auto_breaking = auto_breaking
        self.k_8s_node_name = k_8s_node_name
        self.alarm_event_name = alarm_event_name
        self.unique_info = unique_info
        self.level = level
        self.id = id
        self.details = details
        self.event_notes = event_notes

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()
        if self.event_notes:
            for k in self.event_notes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stages is not None:
            result['Stages'] = self.stages
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.k_8s_cluster_name is not None:
            result['K8sClusterName'] = self.k_8s_cluster_name
        if self.container_image_id is not None:
            result['ContainerImageId'] = self.container_image_id
        if self.last_time_stamp is not None:
            result['LastTimeStamp'] = self.last_time_stamp
        if self.occurrence_time is not None:
            result['OccurrenceTime'] = self.occurrence_time
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        if self.alarm_event_name_display is not None:
            result['AlarmEventNameDisplay'] = self.alarm_event_name_display
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.container_image_name is not None:
            result['ContainerImageName'] = self.container_image_name
        if self.mark_mis_rules is not None:
            result['MarkMisRules'] = self.mark_mis_rules
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.contain_hw_mode is not None:
            result['ContainHwMode'] = self.contain_hw_mode
        if self.k_8s_node_id is not None:
            result['K8sNodeId'] = self.k_8s_node_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.event_status is not None:
            result['EventStatus'] = self.event_status
        if self.sale_version is not None:
            result['SaleVersion'] = self.sale_version
        if self.operate_error_code is not None:
            result['OperateErrorCode'] = self.operate_error_code
        if self.name is not None:
            result['Name'] = self.name
        if self.has_trace_info is not None:
            result['HasTraceInfo'] = self.has_trace_info
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.operate_time is not None:
            result['OperateTime'] = self.operate_time
        if self.event_sub_type is not None:
            result['EventSubType'] = self.event_sub_type
        if self.advanced is not None:
            result['Advanced'] = self.advanced
        if self.occurrence_time_stamp is not None:
            result['OccurrenceTimeStamp'] = self.occurrence_time_stamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.alarm_event_type_display is not None:
            result['AlarmEventTypeDisplay'] = self.alarm_event_type_display
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.operate_msg is not None:
            result['OperateMsg'] = self.operate_msg
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.k_8s_pod_name is not None:
            result['K8sPodName'] = self.k_8s_pod_name
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.alarm_event_type is not None:
            result['AlarmEventType'] = self.alarm_event_type
        if self.k_8s_namespace is not None:
            result['K8sNamespace'] = self.k_8s_namespace
        if self.auto_breaking is not None:
            result['AutoBreaking'] = self.auto_breaking
        if self.k_8s_node_name is not None:
            result['K8sNodeName'] = self.k_8s_node_name
        if self.alarm_event_name is not None:
            result['AlarmEventName'] = self.alarm_event_name
        if self.unique_info is not None:
            result['UniqueInfo'] = self.unique_info
        if self.level is not None:
            result['Level'] = self.level
        if self.id is not None:
            result['Id'] = self.id
        result['Details'] = []
        if self.details is not None:
            for k in self.details:
                result['Details'].append(k.to_map() if k else None)
        result['EventNotes'] = []
        if self.event_notes is not None:
            for k in self.event_notes:
                result['EventNotes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Stages') is not None:
            self.stages = m.get('Stages')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('K8sClusterName') is not None:
            self.k_8s_cluster_name = m.get('K8sClusterName')
        if m.get('ContainerImageId') is not None:
            self.container_image_id = m.get('ContainerImageId')
        if m.get('LastTimeStamp') is not None:
            self.last_time_stamp = m.get('LastTimeStamp')
        if m.get('OccurrenceTime') is not None:
            self.occurrence_time = m.get('OccurrenceTime')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        if m.get('AlarmEventNameDisplay') is not None:
            self.alarm_event_name_display = m.get('AlarmEventNameDisplay')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('ContainerImageName') is not None:
            self.container_image_name = m.get('ContainerImageName')
        if m.get('MarkMisRules') is not None:
            self.mark_mis_rules = m.get('MarkMisRules')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('ContainHwMode') is not None:
            self.contain_hw_mode = m.get('ContainHwMode')
        if m.get('K8sNodeId') is not None:
            self.k_8s_node_id = m.get('K8sNodeId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('EventStatus') is not None:
            self.event_status = m.get('EventStatus')
        if m.get('SaleVersion') is not None:
            self.sale_version = m.get('SaleVersion')
        if m.get('OperateErrorCode') is not None:
            self.operate_error_code = m.get('OperateErrorCode')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('HasTraceInfo') is not None:
            self.has_trace_info = m.get('HasTraceInfo')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('OperateTime') is not None:
            self.operate_time = m.get('OperateTime')
        if m.get('EventSubType') is not None:
            self.event_sub_type = m.get('EventSubType')
        if m.get('Advanced') is not None:
            self.advanced = m.get('Advanced')
        if m.get('OccurrenceTimeStamp') is not None:
            self.occurrence_time_stamp = m.get('OccurrenceTimeStamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('AlarmEventTypeDisplay') is not None:
            self.alarm_event_type_display = m.get('AlarmEventTypeDisplay')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('OperateMsg') is not None:
            self.operate_msg = m.get('OperateMsg')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('K8sPodName') is not None:
            self.k_8s_pod_name = m.get('K8sPodName')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('AlarmEventType') is not None:
            self.alarm_event_type = m.get('AlarmEventType')
        if m.get('K8sNamespace') is not None:
            self.k_8s_namespace = m.get('K8sNamespace')
        if m.get('AutoBreaking') is not None:
            self.auto_breaking = m.get('AutoBreaking')
        if m.get('K8sNodeName') is not None:
            self.k_8s_node_name = m.get('K8sNodeName')
        if m.get('AlarmEventName') is not None:
            self.alarm_event_name = m.get('AlarmEventName')
        if m.get('UniqueInfo') is not None:
            self.unique_info = m.get('UniqueInfo')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        self.details = []
        if m.get('Details') is not None:
            for k in m.get('Details'):
                temp_model = DescribeSuspEventsResponseBodySuspEventsDetails()
                self.details.append(temp_model.from_map(k))
        self.event_notes = []
        if m.get('EventNotes') is not None:
            for k in m.get('EventNotes'):
                temp_model = DescribeSuspEventsResponseBodySuspEventsEventNotes()
                self.event_notes.append(temp_model.from_map(k))
        return self


class DescribeSuspEventsResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        count: int = None,
        susp_events: List[DescribeSuspEventsResponseBodySuspEvents] = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.count = count
        self.susp_events = susp_events

    def validate(self):
        if self.susp_events:
            for k in self.susp_events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        result['SuspEvents'] = []
        if self.susp_events is not None:
            for k in self.susp_events:
                result['SuspEvents'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.susp_events = []
        if m.get('SuspEvents') is not None:
            for k in m.get('SuspEvents'):
                temp_model = DescribeSuspEventsResponseBodySuspEvents()
                self.susp_events.append(temp_model.from_map(k))
        return self


class DescribeSuspEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSuspEventsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSuspEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserBackupMachinesRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeUserBackupMachinesResponseBodyMachines(TeaModel):
    def __init__(
        self,
        uuid: str = None,
        policy_name: str = None,
        id: int = None,
    ):
        self.uuid = uuid
        self.policy_name = policy_name
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeUserBackupMachinesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        machines: List[DescribeUserBackupMachinesResponseBodyMachines] = None,
    ):
        self.request_id = request_id
        self.machines = machines

    def validate(self):
        if self.machines:
            for k in self.machines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Machines'] = []
        if self.machines is not None:
            for k in self.machines:
                result['Machines'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.machines = []
        if m.get('Machines') is not None:
            for k in m.get('Machines'):
                temp_model = DescribeUserBackupMachinesResponseBodyMachines()
                self.machines.append(temp_model.from_map(k))
        return self


class DescribeUserBackupMachinesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUserBackupMachinesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUserBackupMachinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserBaselineAuthorizationRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        lang: str = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeUserBaselineAuthorizationResponseBodyUserBaselineAuthorization(TeaModel):
    def __init__(
        self,
        status: int = None,
    ):
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeUserBaselineAuthorizationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_baseline_authorization: DescribeUserBaselineAuthorizationResponseBodyUserBaselineAuthorization = None,
    ):
        self.request_id = request_id
        self.user_baseline_authorization = user_baseline_authorization

    def validate(self):
        if self.user_baseline_authorization:
            self.user_baseline_authorization.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_baseline_authorization is not None:
            result['UserBaselineAuthorization'] = self.user_baseline_authorization.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserBaselineAuthorization') is not None:
            temp_model = DescribeUserBaselineAuthorizationResponseBodyUserBaselineAuthorization()
            self.user_baseline_authorization = temp_model.from_map(m['UserBaselineAuthorization'])
        return self


class DescribeUserBaselineAuthorizationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUserBaselineAuthorizationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUserBaselineAuthorizationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserLayoutAuthorizationRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
        lang: str = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeUserLayoutAuthorizationResponseBody(TeaModel):
    def __init__(
        self,
        authorized: bool = None,
        request_id: str = None,
    ):
        self.authorized = authorized
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authorized is not None:
            result['Authorized'] = self.authorized
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Authorized') is not None:
            self.authorized = m.get('Authorized')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeUserLayoutAuthorizationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUserLayoutAuthorizationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUserLayoutAuthorizationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUuidsByVulNamesRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        type: str = None,
        status_list: str = None,
        tag: str = None,
        level: str = None,
        dealed: str = None,
        group_id: int = None,
        vpc_instance_ids: str = None,
        remark: str = None,
        search_tags: str = None,
        field_name: str = None,
        field_value: str = None,
        target_type: str = None,
        necessity: str = None,
        vul_names: List[str] = None,
    ):
        self.lang = lang
        self.type = type
        self.status_list = status_list
        self.tag = tag
        self.level = level
        self.dealed = dealed
        self.group_id = group_id
        self.vpc_instance_ids = vpc_instance_ids
        self.remark = remark
        self.search_tags = search_tags
        self.field_name = field_name
        self.field_value = field_value
        self.target_type = target_type
        self.necessity = necessity
        self.vul_names = vul_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.type is not None:
            result['Type'] = self.type
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.level is not None:
            result['Level'] = self.level
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.vpc_instance_ids is not None:
            result['VpcInstanceIds'] = self.vpc_instance_ids
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.search_tags is not None:
            result['SearchTags'] = self.search_tags
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.vul_names is not None:
            result['VulNames'] = self.vul_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('VpcInstanceIds') is not None:
            self.vpc_instance_ids = m.get('VpcInstanceIds')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('SearchTags') is not None:
            self.search_tags = m.get('SearchTags')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('VulNames') is not None:
            self.vul_names = m.get('VulNames')
        return self


class DescribeUuidsByVulNamesResponseBodyMachineInfoStatistics(TeaModel):
    def __init__(
        self,
        uuid: str = None,
        machine_ip: str = None,
        os: str = None,
        machine_name: str = None,
        machine_instance_id: str = None,
        region_id: str = None,
    ):
        self.uuid = uuid
        self.machine_ip = machine_ip
        self.os = os
        self.machine_name = machine_name
        self.machine_instance_id = machine_instance_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.machine_ip is not None:
            result['MachineIp'] = self.machine_ip
        if self.os is not None:
            result['Os'] = self.os
        if self.machine_name is not None:
            result['MachineName'] = self.machine_name
        if self.machine_instance_id is not None:
            result['MachineInstanceId'] = self.machine_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('MachineIp') is not None:
            self.machine_ip = m.get('MachineIp')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('MachineName') is not None:
            self.machine_name = m.get('MachineName')
        if m.get('MachineInstanceId') is not None:
            self.machine_instance_id = m.get('MachineInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeUuidsByVulNamesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        machine_info_statistics: List[DescribeUuidsByVulNamesResponseBodyMachineInfoStatistics] = None,
    ):
        self.request_id = request_id
        self.machine_info_statistics = machine_info_statistics

    def validate(self):
        if self.machine_info_statistics:
            for k in self.machine_info_statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['MachineInfoStatistics'] = []
        if self.machine_info_statistics is not None:
            for k in self.machine_info_statistics:
                result['MachineInfoStatistics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.machine_info_statistics = []
        if m.get('MachineInfoStatistics') is not None:
            for k in m.get('MachineInfoStatistics'):
                temp_model = DescribeUuidsByVulNamesResponseBodyMachineInfoStatistics()
                self.machine_info_statistics.append(temp_model.from_map(k))
        return self


class DescribeUuidsByVulNamesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUuidsByVulNamesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUuidsByVulNamesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVersionConfigRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_directory_account_id: str = None,
    ):
        self.source_ip = source_ip
        self.resource_directory_account_id = resource_directory_account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        return self


class DescribeVersionConfigResponseBody(TeaModel):
    def __init__(
        self,
        mvauth_count: int = None,
        sas_log: int = None,
        sas_screen: int = None,
        honeypot_capacity: int = None,
        mvunused_auth_count: int = None,
        web_lock: int = None,
        app_white_list_auth_count: int = None,
        request_id: str = None,
        last_trail_end_time: int = None,
        version: int = None,
        web_lock_auth_count: int = None,
        release_time: int = None,
        highest_version: int = None,
        asset_level: int = None,
        is_over_balance: bool = None,
        instance_id: str = None,
        sls_capacity: int = None,
        vm_cores: int = None,
        allow_partial_buy: int = None,
        app_white_list: int = None,
        image_scan_capacity: int = None,
        is_trial_version: int = None,
        user_defined_alarms: int = None,
    ):
        self.mvauth_count = mvauth_count
        self.sas_log = sas_log
        self.sas_screen = sas_screen
        self.honeypot_capacity = honeypot_capacity
        self.mvunused_auth_count = mvunused_auth_count
        self.web_lock = web_lock
        self.app_white_list_auth_count = app_white_list_auth_count
        self.request_id = request_id
        self.last_trail_end_time = last_trail_end_time
        self.version = version
        self.web_lock_auth_count = web_lock_auth_count
        self.release_time = release_time
        self.highest_version = highest_version
        self.asset_level = asset_level
        self.is_over_balance = is_over_balance
        self.instance_id = instance_id
        self.sls_capacity = sls_capacity
        self.vm_cores = vm_cores
        self.allow_partial_buy = allow_partial_buy
        self.app_white_list = app_white_list
        self.image_scan_capacity = image_scan_capacity
        self.is_trial_version = is_trial_version
        self.user_defined_alarms = user_defined_alarms

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mvauth_count is not None:
            result['MVAuthCount'] = self.mvauth_count
        if self.sas_log is not None:
            result['SasLog'] = self.sas_log
        if self.sas_screen is not None:
            result['SasScreen'] = self.sas_screen
        if self.honeypot_capacity is not None:
            result['HoneypotCapacity'] = self.honeypot_capacity
        if self.mvunused_auth_count is not None:
            result['MVUnusedAuthCount'] = self.mvunused_auth_count
        if self.web_lock is not None:
            result['WebLock'] = self.web_lock
        if self.app_white_list_auth_count is not None:
            result['AppWhiteListAuthCount'] = self.app_white_list_auth_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.last_trail_end_time is not None:
            result['LastTrailEndTime'] = self.last_trail_end_time
        if self.version is not None:
            result['Version'] = self.version
        if self.web_lock_auth_count is not None:
            result['WebLockAuthCount'] = self.web_lock_auth_count
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.highest_version is not None:
            result['HighestVersion'] = self.highest_version
        if self.asset_level is not None:
            result['AssetLevel'] = self.asset_level
        if self.is_over_balance is not None:
            result['IsOverBalance'] = self.is_over_balance
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.sls_capacity is not None:
            result['SlsCapacity'] = self.sls_capacity
        if self.vm_cores is not None:
            result['VmCores'] = self.vm_cores
        if self.allow_partial_buy is not None:
            result['AllowPartialBuy'] = self.allow_partial_buy
        if self.app_white_list is not None:
            result['AppWhiteList'] = self.app_white_list
        if self.image_scan_capacity is not None:
            result['ImageScanCapacity'] = self.image_scan_capacity
        if self.is_trial_version is not None:
            result['IsTrialVersion'] = self.is_trial_version
        if self.user_defined_alarms is not None:
            result['UserDefinedAlarms'] = self.user_defined_alarms
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MVAuthCount') is not None:
            self.mvauth_count = m.get('MVAuthCount')
        if m.get('SasLog') is not None:
            self.sas_log = m.get('SasLog')
        if m.get('SasScreen') is not None:
            self.sas_screen = m.get('SasScreen')
        if m.get('HoneypotCapacity') is not None:
            self.honeypot_capacity = m.get('HoneypotCapacity')
        if m.get('MVUnusedAuthCount') is not None:
            self.mvunused_auth_count = m.get('MVUnusedAuthCount')
        if m.get('WebLock') is not None:
            self.web_lock = m.get('WebLock')
        if m.get('AppWhiteListAuthCount') is not None:
            self.app_white_list_auth_count = m.get('AppWhiteListAuthCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LastTrailEndTime') is not None:
            self.last_trail_end_time = m.get('LastTrailEndTime')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('WebLockAuthCount') is not None:
            self.web_lock_auth_count = m.get('WebLockAuthCount')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('HighestVersion') is not None:
            self.highest_version = m.get('HighestVersion')
        if m.get('AssetLevel') is not None:
            self.asset_level = m.get('AssetLevel')
        if m.get('IsOverBalance') is not None:
            self.is_over_balance = m.get('IsOverBalance')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SlsCapacity') is not None:
            self.sls_capacity = m.get('SlsCapacity')
        if m.get('VmCores') is not None:
            self.vm_cores = m.get('VmCores')
        if m.get('AllowPartialBuy') is not None:
            self.allow_partial_buy = m.get('AllowPartialBuy')
        if m.get('AppWhiteList') is not None:
            self.app_white_list = m.get('AppWhiteList')
        if m.get('ImageScanCapacity') is not None:
            self.image_scan_capacity = m.get('ImageScanCapacity')
        if m.get('IsTrialVersion') is not None:
            self.is_trial_version = m.get('IsTrialVersion')
        if m.get('UserDefinedAlarms') is not None:
            self.user_defined_alarms = m.get('UserDefinedAlarms')
        return self


class DescribeVersionConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVersionConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVersionConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVolDingdingMessageRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
    ):
        self.source_ip = source_ip
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeVolDingdingMessageResponseBody(TeaModel):
    def __init__(
        self,
        dingding_url: str = None,
        request_id: str = None,
    ):
        self.dingding_url = dingding_url
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dingding_url is not None:
            result['DingdingUrl'] = self.dingding_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DingdingUrl') is not None:
            self.dingding_url = m.get('DingdingUrl')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVolDingdingMessageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVolDingdingMessageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVolDingdingMessageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVpcHoneyPotCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(
        self,
        type: str = None,
        name: str = None,
        values: str = None,
    ):
        self.type = type
        self.name = name
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.name is not None:
            result['Name'] = self.name
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeVpcHoneyPotCriteriaResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        criteria_list: List[DescribeVpcHoneyPotCriteriaResponseBodyCriteriaList] = None,
    ):
        self.request_id = request_id
        self.criteria_list = criteria_list

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeVpcHoneyPotCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        return self


class DescribeVpcHoneyPotCriteriaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVpcHoneyPotCriteriaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVpcHoneyPotCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVpcHoneyPotListRequest(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        vpc_name: str = None,
        vpc_region_id: str = None,
        honey_pot_existence: bool = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.vpc_id = vpc_id
        self.vpc_name = vpc_name
        self.vpc_region_id = vpc_region_id
        self.honey_pot_existence = honey_pot_existence
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        if self.vpc_region_id is not None:
            result['VpcRegionId'] = self.vpc_region_id
        if self.honey_pot_existence is not None:
            result['HoneyPotExistence'] = self.honey_pot_existence
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        if m.get('VpcRegionId') is not None:
            self.vpc_region_id = m.get('VpcRegionId')
        if m.get('HoneyPotExistence') is not None:
            self.honey_pot_existence = m.get('HoneyPotExistence')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeVpcHoneyPotListResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
        count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOListVpcSwitchIdList(TeaModel):
    def __init__(
        self,
        vpc_switch_name: str = None,
        zone_id: str = None,
        vpc_switch_id: str = None,
    ):
        self.vpc_switch_name = vpc_switch_name
        self.zone_id = zone_id
        self.vpc_switch_id = vpc_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_switch_name is not None:
            result['VpcSwitchName'] = self.vpc_switch_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.vpc_switch_id is not None:
            result['VpcSwitchId'] = self.vpc_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcSwitchName') is not None:
            self.vpc_switch_name = m.get('VpcSwitchName')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('VpcSwitchId') is not None:
            self.vpc_switch_id = m.get('VpcSwitchId')
        return self


class DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOList(TeaModel):
    def __init__(
        self,
        vpc_name: str = None,
        vpc_id: str = None,
        honey_pot_eni_instance_id: str = None,
        cidr_block: str = None,
        vpc_status: str = None,
        create_time: int = None,
        honey_pot_vpc_switch_id: str = None,
        honey_pot_existence: bool = None,
        vpc_region_id: str = None,
        honey_pot_ecs_instance_status: str = None,
        honey_pot_instance_status: str = None,
        vpc_switch_id_list: List[DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOListVpcSwitchIdList] = None,
    ):
        self.vpc_name = vpc_name
        self.vpc_id = vpc_id
        self.honey_pot_eni_instance_id = honey_pot_eni_instance_id
        self.cidr_block = cidr_block
        self.vpc_status = vpc_status
        self.create_time = create_time
        self.honey_pot_vpc_switch_id = honey_pot_vpc_switch_id
        self.honey_pot_existence = honey_pot_existence
        self.vpc_region_id = vpc_region_id
        self.honey_pot_ecs_instance_status = honey_pot_ecs_instance_status
        self.honey_pot_instance_status = honey_pot_instance_status
        self.vpc_switch_id_list = vpc_switch_id_list

    def validate(self):
        if self.vpc_switch_id_list:
            for k in self.vpc_switch_id_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.honey_pot_eni_instance_id is not None:
            result['HoneyPotEniInstanceId'] = self.honey_pot_eni_instance_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.vpc_status is not None:
            result['VpcStatus'] = self.vpc_status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.honey_pot_vpc_switch_id is not None:
            result['HoneyPotVpcSwitchId'] = self.honey_pot_vpc_switch_id
        if self.honey_pot_existence is not None:
            result['HoneyPotExistence'] = self.honey_pot_existence
        if self.vpc_region_id is not None:
            result['VpcRegionId'] = self.vpc_region_id
        if self.honey_pot_ecs_instance_status is not None:
            result['HoneyPotEcsInstanceStatus'] = self.honey_pot_ecs_instance_status
        if self.honey_pot_instance_status is not None:
            result['HoneyPotInstanceStatus'] = self.honey_pot_instance_status
        result['VpcSwitchIdList'] = []
        if self.vpc_switch_id_list is not None:
            for k in self.vpc_switch_id_list:
                result['VpcSwitchIdList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('HoneyPotEniInstanceId') is not None:
            self.honey_pot_eni_instance_id = m.get('HoneyPotEniInstanceId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('VpcStatus') is not None:
            self.vpc_status = m.get('VpcStatus')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('HoneyPotVpcSwitchId') is not None:
            self.honey_pot_vpc_switch_id = m.get('HoneyPotVpcSwitchId')
        if m.get('HoneyPotExistence') is not None:
            self.honey_pot_existence = m.get('HoneyPotExistence')
        if m.get('VpcRegionId') is not None:
            self.vpc_region_id = m.get('VpcRegionId')
        if m.get('HoneyPotEcsInstanceStatus') is not None:
            self.honey_pot_ecs_instance_status = m.get('HoneyPotEcsInstanceStatus')
        if m.get('HoneyPotInstanceStatus') is not None:
            self.honey_pot_instance_status = m.get('HoneyPotInstanceStatus')
        self.vpc_switch_id_list = []
        if m.get('VpcSwitchIdList') is not None:
            for k in m.get('VpcSwitchIdList'):
                temp_model = DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOListVpcSwitchIdList()
                self.vpc_switch_id_list.append(temp_model.from_map(k))
        return self


class DescribeVpcHoneyPotListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_info: DescribeVpcHoneyPotListResponseBodyPageInfo = None,
        vpc_honey_pot_dtolist: List[DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOList] = None,
    ):
        self.request_id = request_id
        self.page_info = page_info
        self.vpc_honey_pot_dtolist = vpc_honey_pot_dtolist

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.vpc_honey_pot_dtolist:
            for k in self.vpc_honey_pot_dtolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['VpcHoneyPotDTOList'] = []
        if self.vpc_honey_pot_dtolist is not None:
            for k in self.vpc_honey_pot_dtolist:
                result['VpcHoneyPotDTOList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageInfo') is not None:
            temp_model = DescribeVpcHoneyPotListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.vpc_honey_pot_dtolist = []
        if m.get('VpcHoneyPotDTOList') is not None:
            for k in m.get('VpcHoneyPotDTOList'):
                temp_model = DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOList()
                self.vpc_honey_pot_dtolist.append(temp_model.from_map(k))
        return self


class DescribeVpcHoneyPotListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVpcHoneyPotListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVpcHoneyPotListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVpcListResponseBodyVpcList(TeaModel):
    def __init__(
        self,
        instance_desc: str = None,
        instance_name: str = None,
        ecs_count: int = None,
        instance_id: str = None,
        region_id: str = None,
    ):
        self.instance_desc = instance_desc
        self.instance_name = instance_name
        self.ecs_count = ecs_count
        self.instance_id = instance_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_desc is not None:
            result['InstanceDesc'] = self.instance_desc
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.ecs_count is not None:
            result['EcsCount'] = self.ecs_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceDesc') is not None:
            self.instance_desc = m.get('InstanceDesc')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('EcsCount') is not None:
            self.ecs_count = m.get('EcsCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeVpcListResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        request_id: str = None,
        vpc_list: List[DescribeVpcListResponseBodyVpcList] = None,
    ):
        self.count = count
        self.request_id = request_id
        self.vpc_list = vpc_list

    def validate(self):
        if self.vpc_list:
            for k in self.vpc_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['VpcList'] = []
        if self.vpc_list is not None:
            for k in self.vpc_list:
                result['VpcList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.vpc_list = []
        if m.get('VpcList') is not None:
            for k in m.get('VpcList'):
                temp_model = DescribeVpcListResponseBodyVpcList()
                self.vpc_list.append(temp_model.from_map(k))
        return self


class DescribeVpcListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVpcListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVpcListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulDetailsRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        type: str = None,
        name: str = None,
        alias_name: str = None,
    ):
        self.lang = lang
        self.type = type
        self.name = name
        self.alias_name = alias_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.type is not None:
            result['Type'] = self.type
        if self.name is not None:
            result['Name'] = self.name
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        return self


class DescribeVulDetailsResponseBodyCvesClassifys(TeaModel):
    def __init__(
        self,
        description: str = None,
        classify: str = None,
        demo_video_url: str = None,
    ):
        self.description = description
        self.classify = classify
        self.demo_video_url = demo_video_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.classify is not None:
            result['Classify'] = self.classify
        if self.demo_video_url is not None:
            result['DemoVideoUrl'] = self.demo_video_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Classify') is not None:
            self.classify = m.get('Classify')
        if m.get('DemoVideoUrl') is not None:
            self.demo_video_url = m.get('DemoVideoUrl')
        return self


class DescribeVulDetailsResponseBodyCves(TeaModel):
    def __init__(
        self,
        summary: str = None,
        complexity: str = None,
        product: str = None,
        poc_create_time: int = None,
        cve_id: str = None,
        cnvd_id: str = None,
        reference: str = None,
        cvss_score: str = None,
        vendor: str = None,
        poc_disclosure_time: int = None,
        classify: str = None,
        cvss_vector: str = None,
        vul_level: str = None,
        release_time: int = None,
        title: str = None,
        solution: str = None,
        content: str = None,
        poc: str = None,
        classifys: List[DescribeVulDetailsResponseBodyCvesClassifys] = None,
    ):
        self.summary = summary
        self.complexity = complexity
        self.product = product
        self.poc_create_time = poc_create_time
        self.cve_id = cve_id
        self.cnvd_id = cnvd_id
        self.reference = reference
        self.cvss_score = cvss_score
        self.vendor = vendor
        self.poc_disclosure_time = poc_disclosure_time
        self.classify = classify
        self.cvss_vector = cvss_vector
        self.vul_level = vul_level
        self.release_time = release_time
        self.title = title
        self.solution = solution
        self.content = content
        self.poc = poc
        self.classifys = classifys

    def validate(self):
        if self.classifys:
            for k in self.classifys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.complexity is not None:
            result['Complexity'] = self.complexity
        if self.product is not None:
            result['Product'] = self.product
        if self.poc_create_time is not None:
            result['PocCreateTime'] = self.poc_create_time
        if self.cve_id is not None:
            result['CveId'] = self.cve_id
        if self.cnvd_id is not None:
            result['CnvdId'] = self.cnvd_id
        if self.reference is not None:
            result['Reference'] = self.reference
        if self.cvss_score is not None:
            result['CvssScore'] = self.cvss_score
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.poc_disclosure_time is not None:
            result['PocDisclosureTime'] = self.poc_disclosure_time
        if self.classify is not None:
            result['Classify'] = self.classify
        if self.cvss_vector is not None:
            result['CvssVector'] = self.cvss_vector
        if self.vul_level is not None:
            result['VulLevel'] = self.vul_level
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.title is not None:
            result['Title'] = self.title
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.content is not None:
            result['Content'] = self.content
        if self.poc is not None:
            result['Poc'] = self.poc
        result['Classifys'] = []
        if self.classifys is not None:
            for k in self.classifys:
                result['Classifys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Complexity') is not None:
            self.complexity = m.get('Complexity')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('PocCreateTime') is not None:
            self.poc_create_time = m.get('PocCreateTime')
        if m.get('CveId') is not None:
            self.cve_id = m.get('CveId')
        if m.get('CnvdId') is not None:
            self.cnvd_id = m.get('CnvdId')
        if m.get('Reference') is not None:
            self.reference = m.get('Reference')
        if m.get('CvssScore') is not None:
            self.cvss_score = m.get('CvssScore')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('PocDisclosureTime') is not None:
            self.poc_disclosure_time = m.get('PocDisclosureTime')
        if m.get('Classify') is not None:
            self.classify = m.get('Classify')
        if m.get('CvssVector') is not None:
            self.cvss_vector = m.get('CvssVector')
        if m.get('VulLevel') is not None:
            self.vul_level = m.get('VulLevel')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Poc') is not None:
            self.poc = m.get('Poc')
        self.classifys = []
        if m.get('Classifys') is not None:
            for k in m.get('Classifys'):
                temp_model = DescribeVulDetailsResponseBodyCvesClassifys()
                self.classifys.append(temp_model.from_map(k))
        return self


class DescribeVulDetailsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        cves: List[DescribeVulDetailsResponseBodyCves] = None,
    ):
        self.request_id = request_id
        self.cves = cves

    def validate(self):
        if self.cves:
            for k in self.cves:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Cves'] = []
        if self.cves is not None:
            for k in self.cves:
                result['Cves'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.cves = []
        if m.get('Cves') is not None:
            for k in m.get('Cves'):
                temp_model = DescribeVulDetailsResponseBodyCves()
                self.cves.append(temp_model.from_map(k))
        return self


class DescribeVulDetailsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVulDetailsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVulDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulListRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        remark: str = None,
        group_id: str = None,
        type: str = None,
        uuids: str = None,
        alias_name: str = None,
        necessity: str = None,
        dealed: str = None,
        current_page: int = None,
        page_size: int = None,
        attach_types: str = None,
        vpc_instance_ids: str = None,
    ):
        self.lang = lang
        self.remark = remark
        self.group_id = group_id
        self.type = type
        self.uuids = uuids
        self.alias_name = alias_name
        self.necessity = necessity
        self.dealed = dealed
        self.current_page = current_page
        self.page_size = page_size
        self.attach_types = attach_types
        self.vpc_instance_ids = vpc_instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.attach_types is not None:
            result['AttachTypes'] = self.attach_types
        if self.vpc_instance_ids is not None:
            result['VpcInstanceIds'] = self.vpc_instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('AttachTypes') is not None:
            self.attach_types = m.get('AttachTypes')
        if m.get('VpcInstanceIds') is not None:
            self.vpc_instance_ids = m.get('VpcInstanceIds')
        return self


class DescribeVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList(TeaModel):
    def __init__(
        self,
        full_version: str = None,
        version: str = None,
        match_detail: str = None,
        path: str = None,
        name: str = None,
        update_cmd: str = None,
    ):
        self.full_version = full_version
        self.version = version
        self.match_detail = match_detail
        self.path = path
        self.name = name
        self.update_cmd = update_cmd

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.full_version is not None:
            result['FullVersion'] = self.full_version
        if self.version is not None:
            result['Version'] = self.version
        if self.match_detail is not None:
            result['MatchDetail'] = self.match_detail
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        if self.update_cmd is not None:
            result['UpdateCmd'] = self.update_cmd
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FullVersion') is not None:
            self.full_version = m.get('FullVersion')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('MatchDetail') is not None:
            self.match_detail = m.get('MatchDetail')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateCmd') is not None:
            self.update_cmd = m.get('UpdateCmd')
        return self


class DescribeVulListResponseBodyVulRecordsExtendContentJsonNecessity(TeaModel):
    def __init__(
        self,
        status: str = None,
        time_factor: str = None,
        enviroment_factor: str = None,
        is_calc: str = None,
        total_score: str = None,
        cvss_factor: str = None,
        assets_factor: str = None,
    ):
        self.status = status
        self.time_factor = time_factor
        self.enviroment_factor = enviroment_factor
        self.is_calc = is_calc
        self.total_score = total_score
        self.cvss_factor = cvss_factor
        self.assets_factor = assets_factor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.time_factor is not None:
            result['Time_factor'] = self.time_factor
        if self.enviroment_factor is not None:
            result['Enviroment_factor'] = self.enviroment_factor
        if self.is_calc is not None:
            result['Is_calc'] = self.is_calc
        if self.total_score is not None:
            result['Total_score'] = self.total_score
        if self.cvss_factor is not None:
            result['Cvss_factor'] = self.cvss_factor
        if self.assets_factor is not None:
            result['Assets_factor'] = self.assets_factor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Time_factor') is not None:
            self.time_factor = m.get('Time_factor')
        if m.get('Enviroment_factor') is not None:
            self.enviroment_factor = m.get('Enviroment_factor')
        if m.get('Is_calc') is not None:
            self.is_calc = m.get('Is_calc')
        if m.get('Total_score') is not None:
            self.total_score = m.get('Total_score')
        if m.get('Cvss_factor') is not None:
            self.cvss_factor = m.get('Cvss_factor')
        if m.get('Assets_factor') is not None:
            self.assets_factor = m.get('Assets_factor')
        return self


class DescribeVulListResponseBodyVulRecordsExtendContentJson(TeaModel):
    def __init__(
        self,
        status: str = None,
        ip: str = None,
        primary_id: int = None,
        os: str = None,
        tag: str = None,
        last_ts: int = None,
        os_release: str = None,
        alias_name: str = None,
        absolute_path: str = None,
        rpm_entity_list: List[DescribeVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList] = None,
        cve_list: List[str] = None,
        necessity: DescribeVulListResponseBodyVulRecordsExtendContentJsonNecessity = None,
    ):
        self.status = status
        self.ip = ip
        self.primary_id = primary_id
        self.os = os
        self.tag = tag
        self.last_ts = last_ts
        self.os_release = os_release
        self.alias_name = alias_name
        self.absolute_path = absolute_path
        self.rpm_entity_list = rpm_entity_list
        self.cve_list = cve_list
        self.necessity = necessity

    def validate(self):
        if self.rpm_entity_list:
            for k in self.rpm_entity_list:
                if k:
                    k.validate()
        if self.necessity:
            self.necessity.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.primary_id is not None:
            result['PrimaryId'] = self.primary_id
        if self.os is not None:
            result['Os'] = self.os
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.last_ts is not None:
            result['LastTs'] = self.last_ts
        if self.os_release is not None:
            result['OsRelease'] = self.os_release
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.absolute_path is not None:
            result['AbsolutePath'] = self.absolute_path
        result['RpmEntityList'] = []
        if self.rpm_entity_list is not None:
            for k in self.rpm_entity_list:
                result['RpmEntityList'].append(k.to_map() if k else None)
        if self.cve_list is not None:
            result['cveList'] = self.cve_list
        if self.necessity is not None:
            result['Necessity'] = self.necessity.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('PrimaryId') is not None:
            self.primary_id = m.get('PrimaryId')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('LastTs') is not None:
            self.last_ts = m.get('LastTs')
        if m.get('OsRelease') is not None:
            self.os_release = m.get('OsRelease')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AbsolutePath') is not None:
            self.absolute_path = m.get('AbsolutePath')
        self.rpm_entity_list = []
        if m.get('RpmEntityList') is not None:
            for k in m.get('RpmEntityList'):
                temp_model = DescribeVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList()
                self.rpm_entity_list.append(temp_model.from_map(k))
        if m.get('cveList') is not None:
            self.cve_list = m.get('cveList')
        if m.get('Necessity') is not None:
            temp_model = DescribeVulListResponseBodyVulRecordsExtendContentJsonNecessity()
            self.necessity = temp_model.from_map(m['Necessity'])
        return self


class DescribeVulListResponseBodyVulRecords(TeaModel):
    def __init__(
        self,
        status: int = None,
        type: str = None,
        modify_ts: int = None,
        internet_ip: str = None,
        primary_id: int = None,
        tag: str = None,
        instance_name: str = None,
        online: bool = None,
        os_version: str = None,
        name: str = None,
        result_code: str = None,
        instance_id: str = None,
        related: str = None,
        intranet_ip: str = None,
        last_ts: int = None,
        first_ts: int = None,
        necessity: str = None,
        repair_ts: int = None,
        uuid: str = None,
        group_id: int = None,
        result_message: str = None,
        alias_name: str = None,
        extend_content_json: DescribeVulListResponseBodyVulRecordsExtendContentJson = None,
    ):
        self.status = status
        self.type = type
        self.modify_ts = modify_ts
        self.internet_ip = internet_ip
        self.primary_id = primary_id
        self.tag = tag
        self.instance_name = instance_name
        self.online = online
        self.os_version = os_version
        self.name = name
        self.result_code = result_code
        self.instance_id = instance_id
        self.related = related
        self.intranet_ip = intranet_ip
        self.last_ts = last_ts
        self.first_ts = first_ts
        self.necessity = necessity
        self.repair_ts = repair_ts
        self.uuid = uuid
        self.group_id = group_id
        self.result_message = result_message
        self.alias_name = alias_name
        self.extend_content_json = extend_content_json

    def validate(self):
        if self.extend_content_json:
            self.extend_content_json.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.modify_ts is not None:
            result['ModifyTs'] = self.modify_ts
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.primary_id is not None:
            result['PrimaryId'] = self.primary_id
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.online is not None:
            result['Online'] = self.online
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.name is not None:
            result['Name'] = self.name
        if self.result_code is not None:
            result['ResultCode'] = self.result_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.related is not None:
            result['Related'] = self.related
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.last_ts is not None:
            result['LastTs'] = self.last_ts
        if self.first_ts is not None:
            result['FirstTs'] = self.first_ts
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.repair_ts is not None:
            result['RepairTs'] = self.repair_ts
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.result_message is not None:
            result['ResultMessage'] = self.result_message
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.extend_content_json is not None:
            result['ExtendContentJson'] = self.extend_content_json.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ModifyTs') is not None:
            self.modify_ts = m.get('ModifyTs')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('PrimaryId') is not None:
            self.primary_id = m.get('PrimaryId')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Online') is not None:
            self.online = m.get('Online')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResultCode') is not None:
            self.result_code = m.get('ResultCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Related') is not None:
            self.related = m.get('Related')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LastTs') is not None:
            self.last_ts = m.get('LastTs')
        if m.get('FirstTs') is not None:
            self.first_ts = m.get('FirstTs')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('RepairTs') is not None:
            self.repair_ts = m.get('RepairTs')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ResultMessage') is not None:
            self.result_message = m.get('ResultMessage')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('ExtendContentJson') is not None:
            temp_model = DescribeVulListResponseBodyVulRecordsExtendContentJson()
            self.extend_content_json = temp_model.from_map(m['ExtendContentJson'])
        return self


class DescribeVulListResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        request_id: str = None,
        page_size: int = None,
        total_count: int = None,
        vul_records: List[DescribeVulListResponseBodyVulRecords] = None,
    ):
        self.current_page = current_page
        self.request_id = request_id
        self.page_size = page_size
        self.total_count = total_count
        self.vul_records = vul_records

    def validate(self):
        if self.vul_records:
            for k in self.vul_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['VulRecords'] = []
        if self.vul_records is not None:
            for k in self.vul_records:
                result['VulRecords'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.vul_records = []
        if m.get('VulRecords') is not None:
            for k in m.get('VulRecords'):
                temp_model = DescribeVulListResponseBodyVulRecords()
                self.vul_records.append(temp_model.from_map(k))
        return self


class DescribeVulListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVulListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVulListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulWhitelistRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeVulWhitelistResponseBodyVulWhitelists(TeaModel):
    def __init__(
        self,
        type: str = None,
        alias_name: str = None,
        name: str = None,
        reason: str = None,
    ):
        self.type = type
        self.alias_name = alias_name
        self.name = name
        self.reason = reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class DescribeVulWhitelistResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        request_id: str = None,
        page_size: int = None,
        total_count: int = None,
        vul_whitelists: List[DescribeVulWhitelistResponseBodyVulWhitelists] = None,
    ):
        self.current_page = current_page
        self.request_id = request_id
        self.page_size = page_size
        self.total_count = total_count
        self.vul_whitelists = vul_whitelists

    def validate(self):
        if self.vul_whitelists:
            for k in self.vul_whitelists:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['VulWhitelists'] = []
        if self.vul_whitelists is not None:
            for k in self.vul_whitelists:
                result['VulWhitelists'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.vul_whitelists = []
        if m.get('VulWhitelists') is not None:
            for k in m.get('VulWhitelists'):
                temp_model = DescribeVulWhitelistResponseBodyVulWhitelists()
                self.vul_whitelists.append(temp_model.from_map(k))
        return self


class DescribeVulWhitelistResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVulWhitelistResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVulWhitelistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWarningMachinesRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        machine_name: str = None,
        uuids: str = None,
        risk_id: int = None,
        strategy_id: int = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.machine_name = machine_name
        self.uuids = uuids
        self.risk_id = risk_id
        self.strategy_id = strategy_id
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.machine_name is not None:
            result['MachineName'] = self.machine_name
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MachineName') is not None:
            self.machine_name = m.get('MachineName')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class DescribeWarningMachinesResponseBodyWarningMachines(TeaModel):
    def __init__(
        self,
        status: int = None,
        low_warning_count: int = None,
        uuid: str = None,
        medium_warning_count: int = None,
        pass_count: int = None,
        internet_ip: str = None,
        instance_name: str = None,
        instance_id: str = None,
        high_warning_count: int = None,
        intranet_ip: str = None,
        region_id: str = None,
    ):
        self.status = status
        self.low_warning_count = low_warning_count
        self.uuid = uuid
        self.medium_warning_count = medium_warning_count
        self.pass_count = pass_count
        self.internet_ip = internet_ip
        self.instance_name = instance_name
        self.instance_id = instance_id
        self.high_warning_count = high_warning_count
        self.intranet_ip = intranet_ip
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.low_warning_count is not None:
            result['LowWarningCount'] = self.low_warning_count
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.medium_warning_count is not None:
            result['MediumWarningCount'] = self.medium_warning_count
        if self.pass_count is not None:
            result['PassCount'] = self.pass_count
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.high_warning_count is not None:
            result['HighWarningCount'] = self.high_warning_count
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('LowWarningCount') is not None:
            self.low_warning_count = m.get('LowWarningCount')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('MediumWarningCount') is not None:
            self.medium_warning_count = m.get('MediumWarningCount')
        if m.get('PassCount') is not None:
            self.pass_count = m.get('PassCount')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('HighWarningCount') is not None:
            self.high_warning_count = m.get('HighWarningCount')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeWarningMachinesResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        count: int = None,
        warning_machines: List[DescribeWarningMachinesResponseBodyWarningMachines] = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.count = count
        self.warning_machines = warning_machines

    def validate(self):
        if self.warning_machines:
            for k in self.warning_machines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.count is not None:
            result['Count'] = self.count
        result['WarningMachines'] = []
        if self.warning_machines is not None:
            for k in self.warning_machines:
                result['WarningMachines'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.warning_machines = []
        if m.get('WarningMachines') is not None:
            for k in m.get('WarningMachines'):
                temp_model = DescribeWarningMachinesResponseBodyWarningMachines()
                self.warning_machines.append(temp_model.from_map(k))
        return self


class DescribeWarningMachinesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeWarningMachinesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeWarningMachinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWebLockBindListRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        remark: str = None,
        status: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.remark = remark
        self.status = status
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.status is not None:
            result['Status'] = self.status
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeWebLockBindListResponseBodyBindList(TeaModel):
    def __init__(
        self,
        status: str = None,
        percent: int = None,
        internet_ip: str = None,
        service_detail: str = None,
        os: str = None,
        service_status: str = None,
        intranet_ip: str = None,
        audit_count: str = None,
        uuid: str = None,
        service_code: str = None,
        instance_name: str = None,
        dir_count: str = None,
        block_count: str = None,
    ):
        self.status = status
        self.percent = percent
        self.internet_ip = internet_ip
        self.service_detail = service_detail
        self.os = os
        self.service_status = service_status
        self.intranet_ip = intranet_ip
        self.audit_count = audit_count
        self.uuid = uuid
        self.service_code = service_code
        self.instance_name = instance_name
        self.dir_count = dir_count
        self.block_count = block_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.service_detail is not None:
            result['ServiceDetail'] = self.service_detail
        if self.os is not None:
            result['Os'] = self.os
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.audit_count is not None:
            result['AuditCount'] = self.audit_count
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.service_code is not None:
            result['ServiceCode'] = self.service_code
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.dir_count is not None:
            result['DirCount'] = self.dir_count
        if self.block_count is not None:
            result['BlockCount'] = self.block_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('ServiceDetail') is not None:
            self.service_detail = m.get('ServiceDetail')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('AuditCount') is not None:
            self.audit_count = m.get('AuditCount')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('ServiceCode') is not None:
            self.service_code = m.get('ServiceCode')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('DirCount') is not None:
            self.dir_count = m.get('DirCount')
        if m.get('BlockCount') is not None:
            self.block_count = m.get('BlockCount')
        return self


class DescribeWebLockBindListResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        request_id: str = None,
        page_size: int = None,
        total_count: int = None,
        bind_list: List[DescribeWebLockBindListResponseBodyBindList] = None,
    ):
        self.current_page = current_page
        self.request_id = request_id
        self.page_size = page_size
        self.total_count = total_count
        self.bind_list = bind_list

    def validate(self):
        if self.bind_list:
            for k in self.bind_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['BindList'] = []
        if self.bind_list is not None:
            for k in self.bind_list:
                result['BindList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.bind_list = []
        if m.get('BindList') is not None:
            for k in m.get('BindList'):
                temp_model = DescribeWebLockBindListResponseBodyBindList()
                self.bind_list.append(temp_model.from_map(k))
        return self


class DescribeWebLockBindListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeWebLockBindListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeWebLockBindListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWebLockConfigListRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        uuid: str = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeWebLockConfigListResponseBodyConfigList(TeaModel):
    def __init__(
        self,
        exclusive_dir: str = None,
        uuid: str = None,
        inclusive_file_type: str = None,
        defence_mode: str = None,
        exclusive_file_type: str = None,
        inclusive_file: str = None,
        mode: str = None,
        dir: str = None,
        exclusive_file: str = None,
        id: str = None,
        local_backup_dir: str = None,
    ):
        self.exclusive_dir = exclusive_dir
        self.uuid = uuid
        self.inclusive_file_type = inclusive_file_type
        self.defence_mode = defence_mode
        self.exclusive_file_type = exclusive_file_type
        self.inclusive_file = inclusive_file
        self.mode = mode
        self.dir = dir
        self.exclusive_file = exclusive_file
        self.id = id
        self.local_backup_dir = local_backup_dir

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclusive_dir is not None:
            result['ExclusiveDir'] = self.exclusive_dir
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.inclusive_file_type is not None:
            result['InclusiveFileType'] = self.inclusive_file_type
        if self.defence_mode is not None:
            result['DefenceMode'] = self.defence_mode
        if self.exclusive_file_type is not None:
            result['ExclusiveFileType'] = self.exclusive_file_type
        if self.inclusive_file is not None:
            result['InclusiveFile'] = self.inclusive_file
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.dir is not None:
            result['Dir'] = self.dir
        if self.exclusive_file is not None:
            result['ExclusiveFile'] = self.exclusive_file
        if self.id is not None:
            result['Id'] = self.id
        if self.local_backup_dir is not None:
            result['LocalBackupDir'] = self.local_backup_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExclusiveDir') is not None:
            self.exclusive_dir = m.get('ExclusiveDir')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('InclusiveFileType') is not None:
            self.inclusive_file_type = m.get('InclusiveFileType')
        if m.get('DefenceMode') is not None:
            self.defence_mode = m.get('DefenceMode')
        if m.get('ExclusiveFileType') is not None:
            self.exclusive_file_type = m.get('ExclusiveFileType')
        if m.get('InclusiveFile') is not None:
            self.inclusive_file = m.get('InclusiveFile')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Dir') is not None:
            self.dir = m.get('Dir')
        if m.get('ExclusiveFile') is not None:
            self.exclusive_file = m.get('ExclusiveFile')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LocalBackupDir') is not None:
            self.local_backup_dir = m.get('LocalBackupDir')
        return self


class DescribeWebLockConfigListResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        config_list: List[DescribeWebLockConfigListResponseBodyConfigList] = None,
    ):
        self.total_count = total_count
        self.request_id = request_id
        self.config_list = config_list

    def validate(self):
        if self.config_list:
            for k in self.config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ConfigList'] = []
        if self.config_list is not None:
            for k in self.config_list:
                result['ConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.config_list = []
        if m.get('ConfigList') is not None:
            for k in m.get('ConfigList'):
                temp_model = DescribeWebLockConfigListResponseBodyConfigList()
                self.config_list.append(temp_model.from_map(k))
        return self


class DescribeWebLockConfigListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeWebLockConfigListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeWebLockConfigListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExecStrategyRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        strategy_id: int = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.strategy_id = strategy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        return self


class ExecStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ExecStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ExecStrategyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExecStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportRecordRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        params: str = None,
        export_type: str = None,
    ):
        self.lang = lang
        self.params = params
        self.export_type = export_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.params is not None:
            result['Params'] = self.params
        if self.export_type is not None:
            result['ExportType'] = self.export_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('ExportType') is not None:
            self.export_type = m.get('ExportType')
        return self


class ExportRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        file_name: str = None,
        id: int = None,
    ):
        self.request_id = request_id
        self.file_name = file_name
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class ExportRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ExportRecordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExportRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FixCheckWarningsRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        lang: str = None,
        risk_id: int = None,
        check_params: str = None,
        uuids: str = None,
    ):
        self.source_ip = source_ip
        self.lang = lang
        self.risk_id = risk_id
        self.check_params = check_params
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.check_params is not None:
            result['CheckParams'] = self.check_params
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('CheckParams') is not None:
            self.check_params = m.get('CheckParams')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class FixCheckWarningsResponseBody(TeaModel):
    def __init__(
        self,
        batch_id: int = None,
        request_id: str = None,
    ):
        self.batch_id = batch_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_id is not None:
            result['BatchId'] = self.batch_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchId') is not None:
            self.batch_id = m.get('BatchId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class FixCheckWarningsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: FixCheckWarningsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = FixCheckWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBackupStorageCountRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        resource_owner_id: int = None,
    ):
        self.source_ip = source_ip
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetBackupStorageCountResponseBodyBackupStorageCount(TeaModel):
    def __init__(
        self,
        overflow: int = None,
        buy_storage_byte: int = None,
        usage_storage_byte: int = None,
    ):
        self.overflow = overflow
        self.buy_storage_byte = buy_storage_byte
        self.usage_storage_byte = usage_storage_byte

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overflow is not None:
            result['Overflow'] = self.overflow
        if self.buy_storage_byte is not None:
            result['BuyStorageByte'] = self.buy_storage_byte
        if self.usage_storage_byte is not None:
            result['UsageStorageByte'] = self.usage_storage_byte
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Overflow') is not None:
            self.overflow = m.get('Overflow')
        if m.get('BuyStorageByte') is not None:
            self.buy_storage_byte = m.get('BuyStorageByte')
        if m.get('UsageStorageByte') is not None:
            self.usage_storage_byte = m.get('UsageStorageByte')
        return self


class GetBackupStorageCountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        backup_storage_count: GetBackupStorageCountResponseBodyBackupStorageCount = None,
    ):
        self.request_id = request_id
        self.backup_storage_count = backup_storage_count

    def validate(self):
        if self.backup_storage_count:
            self.backup_storage_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.backup_storage_count is not None:
            result['BackupStorageCount'] = self.backup_storage_count.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('BackupStorageCount') is not None:
            temp_model = GetBackupStorageCountResponseBodyBackupStorageCount()
            self.backup_storage_count = temp_model.from_map(m['BackupStorageCount'])
        return self


class GetBackupStorageCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetBackupStorageCountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBackupStorageCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIncIOCsRequest(TeaModel):
    def __init__(
        self,
        type: str = None,
        date: str = None,
    ):
        self.type = type
        self.date = date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.date is not None:
            result['Date'] = self.date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Date') is not None:
            self.date = m.get('Date')
        return self


class GetIncIOCsResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetIncIOCsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetIncIOCsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetIncIOCsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIOCsRequest(TeaModel):
    def __init__(
        self,
        type: str = None,
        date: str = None,
    ):
        self.type = type
        self.date = date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.date is not None:
            result['Date'] = self.date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Date') is not None:
            self.date = m.get('Date')
        return self


class GetIOCsResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetIOCsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetIOCsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetIOCsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLocalInstallScriptRequest(TeaModel):
    def __init__(
        self,
        platform_type: str = None,
        uuid: str = None,
        internal_network: bool = None,
    ):
        self.platform_type = platform_type
        self.uuid = uuid
        self.internal_network = internal_network

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.platform_type is not None:
            result['PlatformType'] = self.platform_type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.internal_network is not None:
            result['InternalNetwork'] = self.internal_network
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PlatformType') is not None:
            self.platform_type = m.get('PlatformType')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('InternalNetwork') is not None:
            self.internal_network = m.get('InternalNetwork')
        return self


class GetLocalInstallScriptResponseBody(TeaModel):
    def __init__(
        self,
        script: str = None,
        request_id: str = None,
    ):
        self.script = script
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.script is not None:
            result['Script'] = self.script
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLocalInstallScriptResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetLocalInstallScriptResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetLocalInstallScriptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLocalUninstallScriptRequest(TeaModel):
    def __init__(
        self,
        platform_type: str = None,
        uuid: str = None,
        internal_network: bool = None,
    ):
        self.platform_type = platform_type
        self.uuid = uuid
        self.internal_network = internal_network

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.platform_type is not None:
            result['PlatformType'] = self.platform_type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.internal_network is not None:
            result['InternalNetwork'] = self.internal_network
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PlatformType') is not None:
            self.platform_type = m.get('PlatformType')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('InternalNetwork') is not None:
            self.internal_network = m.get('InternalNetwork')
        return self


class GetLocalUninstallScriptResponseBody(TeaModel):
    def __init__(
        self,
        script: str = None,
        request_id: str = None,
    ):
        self.script = script
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.script is not None:
            result['Script'] = self.script
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLocalUninstallScriptResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetLocalUninstallScriptResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
     