# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.  # noqa: E501

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..client.configuration import Configuration
from ..client.api_client import ApiClient


class EnvelopesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def apply_template(self, account_id, envelope_id, **kwargs):
        """
        Adds templates to an envelope.
        Adds templates to the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.apply_template(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str preserve_template_recipient:
        :param DocumentTemplateList document_template_list:
        :return: DocumentTemplateList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.apply_template_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.apply_template_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def apply_template_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Adds templates to an envelope.
        Adds templates to the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.apply_template_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str preserve_template_recipient:
        :param DocumentTemplateList document_template_list:
        :return: DocumentTemplateList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'preserve_template_recipient', 'document_template_list']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method apply_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `apply_template`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `apply_template`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/templates'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'preserve_template_recipient' in params:
            query_params['preserve_template_recipient'] = params['preserve_template_recipient']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_template_list' in params:
            body_params = params['document_template_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentTemplateList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def apply_template_to_document(self, account_id, document_id, envelope_id, **kwargs):
        """
        Adds templates to a document in an  envelope.
        Adds templates to a document in the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.apply_template_to_document(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str preserve_template_recipient:
        :param DocumentTemplateList document_template_list:
        :return: DocumentTemplateList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.apply_template_to_document_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.apply_template_to_document_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def apply_template_to_document_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Adds templates to a document in an  envelope.
        Adds templates to a document in the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.apply_template_to_document_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str preserve_template_recipient:
        :param DocumentTemplateList document_template_list:
        :return: DocumentTemplateList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'preserve_template_recipient', 'document_template_list']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method apply_template_to_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `apply_template_to_document`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `apply_template_to_document`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `apply_template_to_document`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'preserve_template_recipient' in params:
            query_params['preserve_template_recipient'] = params['preserve_template_recipient']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_template_list' in params:
            body_params = params['document_template_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentTemplateList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_chunked_upload(self, account_id, **kwargs):
        """
        Initiate a new ChunkedUpload.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_chunked_upload(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param ChunkedUploadRequest chunked_upload_request:
        :return: ChunkedUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_chunked_upload_with_http_info(account_id, **kwargs)
        else:
            (data) = self.create_chunked_upload_with_http_info(account_id, **kwargs)
            return data

    def create_chunked_upload_with_http_info(self, account_id, **kwargs):
        """
        Initiate a new ChunkedUpload.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_chunked_upload_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param ChunkedUploadRequest chunked_upload_request:
        :return: ChunkedUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'chunked_upload_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_chunked_upload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_chunked_upload`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/chunked_uploads'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'chunked_upload_request' in params:
            body_params = params['chunked_upload_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ChunkedUploadResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_console_view(self, account_id, **kwargs):
        """
        Returns a URL to the authentication view UI.
        Returns a URL that allows you to embed the authentication view of the DocuSign UI in your applications.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_console_view(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param ConsoleViewRequest console_view_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_console_view_with_http_info(account_id, **kwargs)
        else:
            (data) = self.create_console_view_with_http_info(account_id, **kwargs)
            return data

    def create_console_view_with_http_info(self, account_id, **kwargs):
        """
        Returns a URL to the authentication view UI.
        Returns a URL that allows you to embed the authentication view of the DocuSign UI in your applications.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_console_view_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param ConsoleViewRequest console_view_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'console_view_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_console_view" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_console_view`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/views/console'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'console_view_request' in params:
            body_params = params['console_view_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ViewUrl',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_correct_view(self, account_id, envelope_id, **kwargs):
        """
        Returns a URL to the envelope correction UI.
        Returns a URL that allows you to embed the envelope correction view of the DocuSign UI in your applications.  Important: iFrames should not be used for embedded operations on mobile devices due to screen space issues. For iOS devices DocuSign recommends using a WebView. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_correct_view(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param CorrectViewRequest correct_view_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_correct_view_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_correct_view_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_correct_view_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Returns a URL to the envelope correction UI.
        Returns a URL that allows you to embed the envelope correction view of the DocuSign UI in your applications.  Important: iFrames should not be used for embedded operations on mobile devices due to screen space issues. For iOS devices DocuSign recommends using a WebView. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_correct_view_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param CorrectViewRequest correct_view_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'correct_view_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_correct_view" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_correct_view`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_correct_view`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/correct'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'correct_view_request' in params:
            body_params = params['correct_view_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ViewUrl',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_custom_fields(self, account_id, envelope_id, **kwargs):
        """
        Updates envelope custom fields for an envelope.
        Updates the envelope custom fields for draft and in-process envelopes.  Each custom field used in an envelope must have a unique name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_custom_fields(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param CustomFields custom_fields:
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_custom_fields_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_custom_fields_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_custom_fields_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Updates envelope custom fields for an envelope.
        Updates the envelope custom fields for draft and in-process envelopes.  Each custom field used in an envelope must have a unique name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_custom_fields_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param CustomFields custom_fields:
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'custom_fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_custom_fields`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_custom_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'custom_fields' in params:
            body_params = params['custom_fields']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CustomFields',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_document_fields(self, account_id, document_id, envelope_id, **kwargs):
        """
        Creates custom document fields in an existing envelope document.
        Creates custom document fields in an existing envelope document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_document_fields(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param DocumentFieldsInformation document_fields_information:
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_document_fields_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.create_document_fields_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def create_document_fields_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Creates custom document fields in an existing envelope document.
        Creates custom document fields in an existing envelope document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_document_fields_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param DocumentFieldsInformation document_fields_information:
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'document_fields_information']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_document_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_document_fields`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `create_document_fields`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_document_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_fields_information' in params:
            body_params = params['document_fields_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentFieldsInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_document_responsive_html_preview(self, account_id, document_id, envelope_id, **kwargs):
        """
        Get Responsive HTML Preview for a document in an envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_document_responsive_html_preview(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param DocumentHtmlDefinition document_html_definition:
        :return: DocumentHtmlDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_document_responsive_html_preview_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.create_document_responsive_html_preview_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def create_document_responsive_html_preview_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Get Responsive HTML Preview for a document in an envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_document_responsive_html_preview_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param DocumentHtmlDefinition document_html_definition:
        :return: DocumentHtmlDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'document_html_definition']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_document_responsive_html_preview" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_document_responsive_html_preview`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `create_document_responsive_html_preview`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_document_responsive_html_preview`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/responsive_html_preview'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_html_definition' in params:
            body_params = params['document_html_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentHtmlDefinitions',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_document_tabs(self, account_id, document_id, envelope_id, **kwargs):
        """
        Adds the tabs to an envelope document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_document_tabs(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param Tabs tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_document_tabs_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.create_document_tabs_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def create_document_tabs_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Adds the tabs to an envelope document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_document_tabs_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param Tabs tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_document_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_document_tabs`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `create_document_tabs`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_document_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tabs' in params:
            body_params = params['tabs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_edit_view(self, account_id, envelope_id, **kwargs):
        """
        Returns a URL to the edit view UI.
        Returns a URL that allows you to embed the edit view of the DocuSign UI in your applications. This is a one-time use login token that allows the user to be placed into the DocuSign editing view.   Upon sending completion, the user is returned to the return URL provided by the API application.  Important: iFrames should not be used for embedded operations on mobile devices due to screen space issues. For iOS devices DocuSign recommends using a WebView. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_edit_view(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param ReturnUrlRequest return_url_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_edit_view_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_edit_view_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_edit_view_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Returns a URL to the edit view UI.
        Returns a URL that allows you to embed the edit view of the DocuSign UI in your applications. This is a one-time use login token that allows the user to be placed into the DocuSign editing view.   Upon sending completion, the user is returned to the return URL provided by the API application.  Important: iFrames should not be used for embedded operations on mobile devices due to screen space issues. For iOS devices DocuSign recommends using a WebView. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_edit_view_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param ReturnUrlRequest return_url_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'return_url_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_edit_view" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_edit_view`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_edit_view`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/edit'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'return_url_request' in params:
            body_params = params['return_url_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ViewUrl',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_email_settings(self, account_id, envelope_id, **kwargs):
        """
        Adds email setting overrides to an envelope.
        Adds email override settings, changing the email address to reply to an email address, name, or the BCC for email archive information, for the envelope. Note that adding email settings will only affect email communications that occur after the addition was made.  ### Important: The BCC Email address feature is designed to provide a copy of all email communications for external archiving purposes. DocuSign recommends that envelopes sent using the BCC for Email Archive feature, including the BCC Email Override option, include additional signer authentication options. To send a copy of the envelope to a recipient who does not need to sign, use a Carbon Copies or Certified Deliveries Recipient Type.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_email_settings(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EmailSettings email_settings:
        :return: EmailSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_email_settings_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_email_settings_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_email_settings_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Adds email setting overrides to an envelope.
        Adds email override settings, changing the email address to reply to an email address, name, or the BCC for email archive information, for the envelope. Note that adding email settings will only affect email communications that occur after the addition was made.  ### Important: The BCC Email address feature is designed to provide a copy of all email communications for external archiving purposes. DocuSign recommends that envelopes sent using the BCC for Email Archive feature, including the BCC Email Override option, include additional signer authentication options. To send a copy of the envelope to a recipient who does not need to sign, use a Carbon Copies or Certified Deliveries Recipient Type.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_email_settings_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EmailSettings email_settings:
        :return: EmailSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'email_settings']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_email_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_email_settings`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_email_settings`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_settings' in params:
            body_params = params['email_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EmailSettings',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_envelope(self, account_id, **kwargs):
        """
        Creates an envelope.
        Creates an envelope.   Using this function you can: * Create an envelope and send it. * Create an envelope from an existing template and send it.  In either case, you can choose to save the envelope as a draft envelope instead of sending it by setting the request's `status` property to `created` instead of `sent`.  ## Sending Envelopes  Documents can be included with the Envelopes::create call itself or a template can include documents. Documents can be added by using a multi-part/form request or by using the `documentBase64` field of the [`document` object](#/definitions/document)  ### Recipient Types An [`envelopeDefinition` object](#/definitions/envelopeDefinition) is used as the method's body. Envelope recipients can be defined in the envelope or in templates. The `envelopeDefinition` object's `recipients` field is an [`EnvelopeRecipients` resource object](#/definitions/EnvelopeRecipients). It includes arrays of the seven types of recipients defined by DocuSign:  Recipient type | Object definition -------------- | ----------------- agent (can add name and email information for later recipients/signers) | [`agent`](#/definitions/agent) carbon copy (receives a copy of the documents) | [`carbonCopy`](#/definitions/carbonCopy) certified delivery  (receives a copy of the documents and must acknowledge receipt) | [`certifiedDelivery`](#/definitions/certifiedDelivery) editor (can change recipients and document fields for later recipients/signers) | [`editor`](#/definitions/editor) in-person signer (\"hosts\" someone who signs in-person) | [`inPersonSigner`](#/definitions/inPersonSigner) intermediary (can add name and email information for some later recipients/signers.) | [`intermediary`](#/definitions/intermediary) signer (signs and/or updates document fields) | [`signer`](#/definitions/signer)  Additional information about the different types of recipients is available from the [`EnvelopeRecipients` resource page](../../EnvelopeRecipients) and from the [Developer Center](https://www.docusign.com/developer-center/explore/features/recipients)  ### Tabs Tabs (also referred to as `tags` and as `fields` in the web sending user interface), can be defined in the `envelopeDefinition`, in templates, by transforming PDF Form Fields, or by using Composite Templates (see below).  Defining tabs: the `inPersonSigner`, and `signer` recipient objects include a `tabs` field. It is an [`EnvelopeTabs` resource object](#/definitions/EnvelopeTabs). It includes arrays of the 24 different tab types available. See the [`EnvelopeTabs` resource](../../EnvelopeTabs) for more information.  ## Using Templates Envelopes use specific people or groups as recipients. Templates can specify a role, eg `account_manager.` When a template is used in an envelope, the roles must be replaced with specific people or groups.  When you create an envelope using a `templateId`, the different recipient type objects within the [`EnvelopeRecipients` object](#/definitions/EnvelopeRecipients) are used to assign recipients to the template's roles via the `roleName` property. The recipient objects can also override settings that were specified in the template, and set values for tab fields that were defined in the template.  ### Message Lock When a template is added or applied to an envelope and the template has a locked email subject and message, that subject and message are used for the envelope and cannot be changed even if another locked template is subsequently added or applied to the envelope. The field `messageLock` is used to lock the email subject and message.  If an email subject or message is entered before adding or applying a template with `messageLock` **true**, the email subject and message is overwritten with the locked email subject and message from the template.  ## Envelope Status The status of sent envelopes can be determined through the DocuSign webhook system or by polling. Webhooks are highly recommended: they provide your application with the quickest updates when an envelope's status changes. DocuSign limits polling to once every 15 minutes or less frequently.  When a webhook is used, DocuSign calls your application, via the URL you provide, with a notification XML message.   See the [Webhook recipe](https://www.docusign.com/developer-center/recipes/webhook-status) for examples and live demos of using webhooks.  ## Webhook Options The two webhook options, *eventNotification* and *Connect* use the same notification mechanism and message formats. eventNotification is used to create a webhook for a specific envelope sent via the API. Connect webhooks can be used for any envelope sent from an account, from any user, from any client.   ### eventNotification Webhooks The Envelopes::create method includes an optional [eventNotification object](#definition-eventNotification) that adds a webhook to the envelope. eventNotification webhooks are available for all DocuSign accounts with API access.  ### Connect Webhooks Connect can be used to create a webhook for all envelopes sent by all users in an account, either through the API or via other DocuSign clients (web, mobile, etc). Connect configurations are independent of specific envelopes. A Connect configuration includes a filter that may be used to limit the webhook to specific users, envelope statuses, etc.   Connect configurations may be created and managed using the [ConnectConfigurations resource](../../Connect/ConnectConfigurations). Configurations can also be created and managed from the Administration tool accessed by selecting \"Go to Admin\" from the menu next to your picture on the DocuSign web app. See the Integrations/Connect section of the Admin tool. For repeatability, and to minimize support questions, creating Connect configurations via the API is recommended, especially for ISVs.  Connect is available for some DocuSign account types. Please contact DocuSign Sales for more information.  ## Composite Templates  The Composite Templates feature, like [compositing in film production](https://en.wikipedia.org/wiki/Compositing), enables you to *overlay* document, recipient, and tab definitions from multiple sources, including PDF Form Field definitions, templates defined on the server, and more.  Each Composite Template consists of optional elements: server templates, inline templates, PDF Metadata templates, and documents.  * The Composite Template ID is an optional element used to identify the composite template. It is used as a reference when adding document object information via a multi-part HTTP message. If used, the document content-disposition must include the `compositeTemplateId` to which the document should be added. If `compositeTemplateId` is not specified in the content-disposition, the document is applied based on the `documentId` only. If no document object is specified, the composite template inherits the first document.  * Server Templates are server-side templates stored on the DocuSign platform. If supplied, they are overlaid into the envelope in the order of their Sequence value.  * Inline Templates provide a container to add documents, recipients, tabs, and custom fields. If inline templates are supplied, they are overlaid into the envelope in the order of their Sequence value.  * Document objects are optional structures that provide a container to pass in a document or form. If this object is not included, the composite template inherits the *first* document it finds from a server template or inline template, starting with the lowest sequence value.  PDF Form objects are only transformed from the document object. DocuSign does not derive PDF form properties from server templates or inline templates. To instruct DocuSign to transform fields from the PDF form, set `transformPdfFields` to \"true\" for the document. See the Transform PDF Fields section for more information about process.  * PDF Metadata Templates provide a container to embed design-time template information into a PDF document. DocuSign uses this information when processing the Envelope. This convention allows the document to carry the signing instructions with it, so that less information needs to be provided at run-time through an inline template or synchronized with an external structure like a server template. PDF Metadata templates are stored in the Metadata layer of a PDF in accordance with Acrobat's XMP specification. DocuSign will only find PDF Metadata templates inside documents passed in the Document object (see below). If supplied, the PDF metadata template will be overlaid into the envelope in the order of its Sequence value.  ### Compositing the definitions Each Composite Template adds a new document and templates overlay into the envelope. For each Composite Template these rules are applied:  * Templates are overlaid in the order of their Sequence value. * If Document is not passed into the Composite Template's `document` field, the *first* template's document (based on the template's Sequence value) is used. * Last in wins in all cases except for the document (i.e. envelope information, recipient information, secure field information). There is no special casing.  For example, if you want higher security on a tab, then that needs to be specified in a later template (by sequence number) then where the tab is included. If you want higher security on a role recipient, then it needs to be in a later template then where that role recipient is specified.  * Recipient matching is based on Recipient Role and Routing Order. If there are matches, the recipient information is merged together. A final pass is done on all Composite Templates, after all template overlays have been applied, to collapse recipients with the same email, username and routing order. This prevents having the same recipients at the same routing order.  * If you specify in a template that a recipient is locked, once that recipient is overlaid the recipient attributes can no longer be changed. The only items that can be changed for the recipient in this case are the email, username, access code and IDCheckInformationInput.  * Tab matching is based on Tab Labels, Tab Types and Documents. If a Tab Label matches but the Document is not supplied, the Tab is overlaid for all the Documents.  For example, if you have a simple inline template with only one tab in it with a label and a value, the Signature, Initial, Company, Envelope ID, User Name tabs will only be matched and collapsed if they fall in the exact same X and Y locations.  * roleName and tabLabel matching is case sensitive.  * The defaultRecipient field enables you to specify which recipient the generated tabs from a PDF form are mapped to. You can also set PDF form generated tabs to a recipient other than the DefaultRecipient by specifying the mapping of the tab label that is created to one of the template recipients.  * You can use tabLabel wild carding to map a series of tabs from the PDF form. To use this you must end a tab label with \"\\*\" and then the system matches tabs that start with the label.  * If no DefaultRecipient is specified, tabs must be explicitly mapped to recipients in order to be generated from the form. Unmapped form objects will not be generated into their DocuSign equivalents. (In the case of Signature/Initials, the tabs will be disregarded entirely; in the case of pdf text fields, the field data will be flattened on the Envelope document, but there will not be a corresponding DocuSign data tab.)  ### Including the Document Content for Composite Templates Document content can be supplied inline, using the `documentBase64` or can be included in a multi-part HTTP message.  If a multi-part message is used and there are multiple Composite Templates, the document content-disposition can include the `compositeTemplateId` to which the document should be added. Using the `compositeTemplateId` sets which documents are associated with particular composite templates. An example of this usage is:  ```    --5cd3320a-5aac-4453-b3a4-cbb52a4cba5d    Content-Type: application/pdf    Content-Disposition: file; filename=\"eula.pdf\"; documentId=1; compositeTemplateId=\"1\"    Content-Transfer-Encoding: base64 ```  ### PDF Form Field Transformation Only the following PDF Form FieldTypes will be transformed to DocuSign tabs: CheckBox, DateTime, ListBox, Numeric, Password, Radio, Signature, and Text  Field Properties that will be transformed: Read Only, Required, Max Length, Positions, and Initial Data.  When transforming a *PDF Form Digital Signature Field,* the following rules are used:  If the PDF Field Name Contains | Then the DocuSign Tab Will be ------- | -------- DocuSignSignHere or eSignSignHere | Signature DocuSignSignHereOptional or eSignSignHereOptional | Optional Signature DocuSignInitialHere or eSignInitialHere | Initials DocuSignInitialHereOptional or eSignInitialHereOptional | Optional Initials  Any other PDF Form Digital Signature Field will be transformed to a DocuSign Signature tab  When transforming *PDF Form Text Fields,* the following rules are used:  If the PDF Field Name Contains | Then the DocuSign Tab Will be ------- | -------- DocuSignSignHere or eSignSignHere | Signature DocuSignSignHereOptional or eSignSignHereOptional | Optional Signature DocuSignInitialHere or eSignInitialHere | Initials DocuSignInitialHereOptional or eSignInitialHereOptional | Optional Initials DocuSignEnvelopeID or eSignEnvelopeID | EnvelopeID DocuSignCompany or eSignCompany | Company DocuSignDateSigned or eSignDateSigned | Date Signed DocuSignTitle or eSignTitle | Title DocuSignFullName or eSignFullName |  Full Name DocuSignSignerAttachmentOptional or eSignSignerAttachmentOptional | Optional Signer Attachment  Any other PDF Form Text Field will be transformed to a DocuSign data (text) tab.  PDF Form Field Names that include \"DocuSignIgnoreTransform\" or \"eSignIgnoreTransform\" will not be transformed.  PDF Form Date fields will be transformed to Date Signed fields if their name includes DocuSignDateSigned or eSignDateSigned.  ## Template Email Subject Merge Fields This feature enables you to insert recipient name and email address merge fields into the email subject line when creating or sending from a template.  The merge fields, based on the recipient's `roleName`, are added to the `emailSubject` when the template is created or when the template is used to create an envelope. After a template sender adds the name and email information for the recipient and sends the envelope, the recipient information is automatically merged into the appropriate fields in the email subject line.  Both the sender and the recipients will see the information in the email subject line for any emails associated with the template. This provides an easy way for senders to organize their envelope emails without having to open an envelope to check the recipient.  If merging the recipient information into the subject line causes the subject line to exceed 100 characters, then any characters over the 100 character limit are not included in the subject line. For cases where the recipient name or email is expected to be long, you should consider placing the merge field at the start of the email subject.  * To add a recipient's name in the subject line add the following text in the `emailSubject` when creating the template or when sending an envelope from a template:     [[<roleName>_UserName]]     Example:     `\"emailSubject\":\"[[Signer 1_UserName]], Please sign this NDA\",`  * To add a recipient's email address in the subject line add the following text in the emailSubject when creating the template or when sending an envelope from a template:     [[<roleName>_Email]]     Example:     `\"emailSubject\":\"[[Signer 1_Email]], Please sign this NDA\",`  In both cases the <roleName> is the recipient's `roleName` in the template.  For cases where another recipient (such as an Agent, Editor, or Intermediary recipient) is entering the name and email information for the recipient included in the email subject, then [[<roleName>_UserName]] or [[<roleName>_Email]] is shown in the email subject.  ## Branding an envelope The following rules are used to determine the `brandId` used in an envelope:  * If a `brandId` is specified in the envelope/template and that brandId is available to the account, that brand is used in the envelope. * If more than one template is used in an envelope and more than one `brandId` is specified, the first `brandId` specified is used throughout the envelope. * In cases where no brand is specified and the sender belongs to a Group; if there is only one brand associated with the Group, then that brand is used in the envelope. Otherwise, the account's default signing brand is used. * For envelopes that do not meet any of the previous criteria, the account's default signing brand is used for the envelope.  ## BCC Email address feature  The BCC Email address feature is designed to provide a copy of all email communications for external archiving purposes. DocuSign recommends that envelopes sent using the BCC for Email Archive feature, including the BCC Email Override option, include additional signer authentication options. To send a copy of the envelope to a recipient who does not need to sign, don't use the BCC Email field. Use a Carbon Copy or Certified Delivery Recipient type.  ## Merge Recipient Roles for Draft Envelopes When an envelope with multiple templates is sent, the recipients from the templates are merged according to the template roles, and empty recipients are removed. When creating an envelope with multiple templates, but not sending it (keeping it in a created state), duplicate recipients are not merged, which could cause leave duplicate recipients in the envelope.  To prevent this, the query parameter `merge_roles_on_draft` should be added when posting a draft envelope (status=created) with multiple templates. Doing this will merge template roles and remove empty recipients.  ###### Note: DocuSign recommends that the `merge_roles_on_draft` query parameter be used anytime you are creating an envelope with multiple templates and keeping it in draft (created) status.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_envelope(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str cdse_mode:
        :param str change_routing_order:
        :param str completed_documents_only: If set to true then we want to set the sourceEnvelopeId to indicate that this is a\"forward\" envelope action
        :param str merge_roles_on_draft: When set to **true**, merges template roles and remove empty recipients when you create an envelope with multiple templates.
        :param str tab_label_exact_matches:
        :param EnvelopeDefinition envelope_definition:
        :return: EnvelopeSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_envelope_with_http_info(account_id, **kwargs)
        else:
            (data) = self.create_envelope_with_http_info(account_id, **kwargs)
            return data

    def create_envelope_with_http_info(self, account_id, **kwargs):
        """
        Creates an envelope.
        Creates an envelope.   Using this function you can: * Create an envelope and send it. * Create an envelope from an existing template and send it.  In either case, you can choose to save the envelope as a draft envelope instead of sending it by setting the request's `status` property to `created` instead of `sent`.  ## Sending Envelopes  Documents can be included with the Envelopes::create call itself or a template can include documents. Documents can be added by using a multi-part/form request or by using the `documentBase64` field of the [`document` object](#/definitions/document)  ### Recipient Types An [`envelopeDefinition` object](#/definitions/envelopeDefinition) is used as the method's body. Envelope recipients can be defined in the envelope or in templates. The `envelopeDefinition` object's `recipients` field is an [`EnvelopeRecipients` resource object](#/definitions/EnvelopeRecipients). It includes arrays of the seven types of recipients defined by DocuSign:  Recipient type | Object definition -------------- | ----------------- agent (can add name and email information for later recipients/signers) | [`agent`](#/definitions/agent) carbon copy (receives a copy of the documents) | [`carbonCopy`](#/definitions/carbonCopy) certified delivery  (receives a copy of the documents and must acknowledge receipt) | [`certifiedDelivery`](#/definitions/certifiedDelivery) editor (can change recipients and document fields for later recipients/signers) | [`editor`](#/definitions/editor) in-person signer (\"hosts\" someone who signs in-person) | [`inPersonSigner`](#/definitions/inPersonSigner) intermediary (can add name and email information for some later recipients/signers.) | [`intermediary`](#/definitions/intermediary) signer (signs and/or updates document fields) | [`signer`](#/definitions/signer)  Additional information about the different types of recipients is available from the [`EnvelopeRecipients` resource page](../../EnvelopeRecipients) and from the [Developer Center](https://www.docusign.com/developer-center/explore/features/recipients)  ### Tabs Tabs (also referred to as `tags` and as `fields` in the web sending user interface), can be defined in the `envelopeDefinition`, in templates, by transforming PDF Form Fields, or by using Composite Templates (see below).  Defining tabs: the `inPersonSigner`, and `signer` recipient objects include a `tabs` field. It is an [`EnvelopeTabs` resource object](#/definitions/EnvelopeTabs). It includes arrays of the 24 different tab types available. See the [`EnvelopeTabs` resource](../../EnvelopeTabs) for more information.  ## Using Templates Envelopes use specific people or groups as recipients. Templates can specify a role, eg `account_manager.` When a template is used in an envelope, the roles must be replaced with specific people or groups.  When you create an envelope using a `templateId`, the different recipient type objects within the [`EnvelopeRecipients` object](#/definitions/EnvelopeRecipients) are used to assign recipients to the template's roles via the `roleName` property. The recipient objects can also override settings that were specified in the template, and set values for tab fields that were defined in the template.  ### Message Lock When a template is added or applied to an envelope and the template has a locked email subject and message, that subject and message are used for the envelope and cannot be changed even if another locked template is subsequently added or applied to the envelope. The field `messageLock` is used to lock the email subject and message.  If an email subject or message is entered before adding or applying a template with `messageLock` **true**, the email subject and message is overwritten with the locked email subject and message from the template.  ## Envelope Status The status of sent envelopes can be determined through the DocuSign webhook system or by polling. Webhooks are highly recommended: they provide your application with the quickest updates when an envelope's status changes. DocuSign limits polling to once every 15 minutes or less frequently.  When a webhook is used, DocuSign calls your application, via the URL you provide, with a notification XML message.   See the [Webhook recipe](https://www.docusign.com/developer-center/recipes/webhook-status) for examples and live demos of using webhooks.  ## Webhook Options The two webhook options, *eventNotification* and *Connect* use the same notification mechanism and message formats. eventNotification is used to create a webhook for a specific envelope sent via the API. Connect webhooks can be used for any envelope sent from an account, from any user, from any client.   ### eventNotification Webhooks The Envelopes::create method includes an optional [eventNotification object](#definition-eventNotification) that adds a webhook to the envelope. eventNotification webhooks are available for all DocuSign accounts with API access.  ### Connect Webhooks Connect can be used to create a webhook for all envelopes sent by all users in an account, either through the API or via other DocuSign clients (web, mobile, etc). Connect configurations are independent of specific envelopes. A Connect configuration includes a filter that may be used to limit the webhook to specific users, envelope statuses, etc.   Connect configurations may be created and managed using the [ConnectConfigurations resource](../../Connect/ConnectConfigurations). Configurations can also be created and managed from the Administration tool accessed by selecting \"Go to Admin\" from the menu next to your picture on the DocuSign web app. See the Integrations/Connect section of the Admin tool. For repeatability, and to minimize support questions, creating Connect configurations via the API is recommended, especially for ISVs.  Connect is available for some DocuSign account types. Please contact DocuSign Sales for more information.  ## Composite Templates  The Composite Templates feature, like [compositing in film production](https://en.wikipedia.org/wiki/Compositing), enables you to *overlay* document, recipient, and tab definitions from multiple sources, including PDF Form Field definitions, templates defined on the server, and more.  Each Composite Template consists of optional elements: server templates, inline templates, PDF Metadata templates, and documents.  * The Composite Template ID is an optional element used to identify the composite template. It is used as a reference when adding document object information via a multi-part HTTP message. If used, the document content-disposition must include the `compositeTemplateId` to which the document should be added. If `compositeTemplateId` is not specified in the content-disposition, the document is applied based on the `documentId` only. If no document object is specified, the composite template inherits the first document.  * Server Templates are server-side templates stored on the DocuSign platform. If supplied, they are overlaid into the envelope in the order of their Sequence value.  * Inline Templates provide a container to add documents, recipients, tabs, and custom fields. If inline templates are supplied, they are overlaid into the envelope in the order of their Sequence value.  * Document objects are optional structures that provide a container to pass in a document or form. If this object is not included, the composite template inherits the *first* document it finds from a server template or inline template, starting with the lowest sequence value.  PDF Form objects are only transformed from the document object. DocuSign does not derive PDF form properties from server templates or inline templates. To instruct DocuSign to transform fields from the PDF form, set `transformPdfFields` to \"true\" for the document. See the Transform PDF Fields section for more information about process.  * PDF Metadata Templates provide a container to embed design-time template information into a PDF document. DocuSign uses this information when processing the Envelope. This convention allows the document to carry the signing instructions with it, so that less information needs to be provided at run-time through an inline template or synchronized with an external structure like a server template. PDF Metadata templates are stored in the Metadata layer of a PDF in accordance with Acrobat's XMP specification. DocuSign will only find PDF Metadata templates inside documents passed in the Document object (see below). If supplied, the PDF metadata template will be overlaid into the envelope in the order of its Sequence value.  ### Compositing the definitions Each Composite Template adds a new document and templates overlay into the envelope. For each Composite Template these rules are applied:  * Templates are overlaid in the order of their Sequence value. * If Document is not passed into the Composite Template's `document` field, the *first* template's document (based on the template's Sequence value) is used. * Last in wins in all cases except for the document (i.e. envelope information, recipient information, secure field information). There is no special casing.  For example, if you want higher security on a tab, then that needs to be specified in a later template (by sequence number) then where the tab is included. If you want higher security on a role recipient, then it needs to be in a later template then where that role recipient is specified.  * Recipient matching is based on Recipient Role and Routing Order. If there are matches, the recipient information is merged together. A final pass is done on all Composite Templates, after all template overlays have been applied, to collapse recipients with the same email, username and routing order. This prevents having the same recipients at the same routing order.  * If you specify in a template that a recipient is locked, once that recipient is overlaid the recipient attributes can no longer be changed. The only items that can be changed for the recipient in this case are the email, username, access code and IDCheckInformationInput.  * Tab matching is based on Tab Labels, Tab Types and Documents. If a Tab Label matches but the Document is not supplied, the Tab is overlaid for all the Documents.  For example, if you have a simple inline template with only one tab in it with a label and a value, the Signature, Initial, Company, Envelope ID, User Name tabs will only be matched and collapsed if they fall in the exact same X and Y locations.  * roleName and tabLabel matching is case sensitive.  * The defaultRecipient field enables you to specify which recipient the generated tabs from a PDF form are mapped to. You can also set PDF form generated tabs to a recipient other than the DefaultRecipient by specifying the mapping of the tab label that is created to one of the template recipients.  * You can use tabLabel wild carding to map a series of tabs from the PDF form. To use this you must end a tab label with \"\\*\" and then the system matches tabs that start with the label.  * If no DefaultRecipient is specified, tabs must be explicitly mapped to recipients in order to be generated from the form. Unmapped form objects will not be generated into their DocuSign equivalents. (In the case of Signature/Initials, the tabs will be disregarded entirely; in the case of pdf text fields, the field data will be flattened on the Envelope document, but there will not be a corresponding DocuSign data tab.)  ### Including the Document Content for Composite Templates Document content can be supplied inline, using the `documentBase64` or can be included in a multi-part HTTP message.  If a multi-part message is used and there are multiple Composite Templates, the document content-disposition can include the `compositeTemplateId` to which the document should be added. Using the `compositeTemplateId` sets which documents are associated with particular composite templates. An example of this usage is:  ```    --5cd3320a-5aac-4453-b3a4-cbb52a4cba5d    Content-Type: application/pdf    Content-Disposition: file; filename=\"eula.pdf\"; documentId=1; compositeTemplateId=\"1\"    Content-Transfer-Encoding: base64 ```  ### PDF Form Field Transformation Only the following PDF Form FieldTypes will be transformed to DocuSign tabs: CheckBox, DateTime, ListBox, Numeric, Password, Radio, Signature, and Text  Field Properties that will be transformed: Read Only, Required, Max Length, Positions, and Initial Data.  When transforming a *PDF Form Digital Signature Field,* the following rules are used:  If the PDF Field Name Contains | Then the DocuSign Tab Will be ------- | -------- DocuSignSignHere or eSignSignHere | Signature DocuSignSignHereOptional or eSignSignHereOptional | Optional Signature DocuSignInitialHere or eSignInitialHere | Initials DocuSignInitialHereOptional or eSignInitialHereOptional | Optional Initials  Any other PDF Form Digital Signature Field will be transformed to a DocuSign Signature tab  When transforming *PDF Form Text Fields,* the following rules are used:  If the PDF Field Name Contains | Then the DocuSign Tab Will be ------- | -------- DocuSignSignHere or eSignSignHere | Signature DocuSignSignHereOptional or eSignSignHereOptional | Optional Signature DocuSignInitialHere or eSignInitialHere | Initials DocuSignInitialHereOptional or eSignInitialHereOptional | Optional Initials DocuSignEnvelopeID or eSignEnvelopeID | EnvelopeID DocuSignCompany or eSignCompany | Company DocuSignDateSigned or eSignDateSigned | Date Signed DocuSignTitle or eSignTitle | Title DocuSignFullName or eSignFullName |  Full Name DocuSignSignerAttachmentOptional or eSignSignerAttachmentOptional | Optional Signer Attachment  Any other PDF Form Text Field will be transformed to a DocuSign data (text) tab.  PDF Form Field Names that include \"DocuSignIgnoreTransform\" or \"eSignIgnoreTransform\" will not be transformed.  PDF Form Date fields will be transformed to Date Signed fields if their name includes DocuSignDateSigned or eSignDateSigned.  ## Template Email Subject Merge Fields This feature enables you to insert recipient name and email address merge fields into the email subject line when creating or sending from a template.  The merge fields, based on the recipient's `roleName`, are added to the `emailSubject` when the template is created or when the template is used to create an envelope. After a template sender adds the name and email information for the recipient and sends the envelope, the recipient information is automatically merged into the appropriate fields in the email subject line.  Both the sender and the recipients will see the information in the email subject line for any emails associated with the template. This provides an easy way for senders to organize their envelope emails without having to open an envelope to check the recipient.  If merging the recipient information into the subject line causes the subject line to exceed 100 characters, then any characters over the 100 character limit are not included in the subject line. For cases where the recipient name or email is expected to be long, you should consider placing the merge field at the start of the email subject.  * To add a recipient's name in the subject line add the following text in the `emailSubject` when creating the template or when sending an envelope from a template:     [[<roleName>_UserName]]     Example:     `\"emailSubject\":\"[[Signer 1_UserName]], Please sign this NDA\",`  * To add a recipient's email address in the subject line add the following text in the emailSubject when creating the template or when sending an envelope from a template:     [[<roleName>_Email]]     Example:     `\"emailSubject\":\"[[Signer 1_Email]], Please sign this NDA\",`  In both cases the <roleName> is the recipient's `roleName` in the template.  For cases where another recipient (such as an Agent, Editor, or Intermediary recipient) is entering the name and email information for the recipient included in the email subject, then [[<roleName>_UserName]] or [[<roleName>_Email]] is shown in the email subject.  ## Branding an envelope The following rules are used to determine the `brandId` used in an envelope:  * If a `brandId` is specified in the envelope/template and that brandId is available to the account, that brand is used in the envelope. * If more than one template is used in an envelope and more than one `brandId` is specified, the first `brandId` specified is used throughout the envelope. * In cases where no brand is specified and the sender belongs to a Group; if there is only one brand associated with the Group, then that brand is used in the envelope. Otherwise, the account's default signing brand is used. * For envelopes that do not meet any of the previous criteria, the account's default signing brand is used for the envelope.  ## BCC Email address feature  The BCC Email address feature is designed to provide a copy of all email communications for external archiving purposes. DocuSign recommends that envelopes sent using the BCC for Email Archive feature, including the BCC Email Override option, include additional signer authentication options. To send a copy of the envelope to a recipient who does not need to sign, don't use the BCC Email field. Use a Carbon Copy or Certified Delivery Recipient type.  ## Merge Recipient Roles for Draft Envelopes When an envelope with multiple templates is sent, the recipients from the templates are merged according to the template roles, and empty recipients are removed. When creating an envelope with multiple templates, but not sending it (keeping it in a created state), duplicate recipients are not merged, which could cause leave duplicate recipients in the envelope.  To prevent this, the query parameter `merge_roles_on_draft` should be added when posting a draft envelope (status=created) with multiple templates. Doing this will merge template roles and remove empty recipients.  ###### Note: DocuSign recommends that the `merge_roles_on_draft` query parameter be used anytime you are creating an envelope with multiple templates and keeping it in draft (created) status.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_envelope_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str cdse_mode:
        :param str change_routing_order:
        :param str completed_documents_only: If set to true then we want to set the sourceEnvelopeId to indicate that this is a\"forward\" envelope action
        :param str merge_roles_on_draft: When set to **true**, merges template roles and remove empty recipients when you create an envelope with multiple templates.
        :param str tab_label_exact_matches:
        :param EnvelopeDefinition envelope_definition:
        :return: EnvelopeSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'cdse_mode', 'change_routing_order', 'completed_documents_only', 'merge_roles_on_draft', 'tab_label_exact_matches', 'envelope_definition']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_envelope" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_envelope`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'cdse_mode' in params:
            query_params['cdse_mode'] = params['cdse_mode']
        if 'change_routing_order' in params:
            query_params['change_routing_order'] = params['change_routing_order']
        if 'completed_documents_only' in params:
            query_params['completed_documents_only'] = params['completed_documents_only']
        if 'merge_roles_on_draft' in params:
            query_params['merge_roles_on_draft'] = params['merge_roles_on_draft']
        if 'tab_label_exact_matches' in params:
            query_params['tab_label_exact_matches'] = params['tab_label_exact_matches']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_definition' in params:
            body_params = params['envelope_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeSummary',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_envelope_comments(self, account_id, envelope_id, **kwargs):
        """
        Posts a list of comments for authorized user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_envelope_comments(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param CommentsPublish comments_publish:
        :return: CommentHistoryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_envelope_comments_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_envelope_comments_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_envelope_comments_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Posts a list of comments for authorized user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_envelope_comments_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param CommentsPublish comments_publish:
        :return: CommentHistoryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'comments_publish']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_envelope_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_envelope_comments`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_envelope_comments`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/comments'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'comments_publish' in params:
            body_params = params['comments_publish']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CommentHistoryResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_envelope_recipient_preview(self, account_id, envelope_id, **kwargs):
        """
        Provides a URL to start a recipient view of the Envelope UI
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_envelope_recipient_preview(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param RecipientPreviewRequest recipient_preview_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_envelope_recipient_preview_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_envelope_recipient_preview_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_envelope_recipient_preview_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Provides a URL to start a recipient view of the Envelope UI
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_envelope_recipient_preview_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param RecipientPreviewRequest recipient_preview_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_preview_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_envelope_recipient_preview" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_envelope_recipient_preview`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_envelope_recipient_preview`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/recipient_preview'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'recipient_preview_request' in params:
            body_params = params['recipient_preview_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ViewUrl',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_envelope_recipient_shared_view(self, account_id, envelope_id, **kwargs):
        """
        Provides a URL to start a shared recipient view of the Envelope UI
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_envelope_recipient_shared_view(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param RecipientViewRequest recipient_view_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_envelope_recipient_shared_view_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_envelope_recipient_shared_view_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_envelope_recipient_shared_view_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Provides a URL to start a shared recipient view of the Envelope UI
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_envelope_recipient_shared_view_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param RecipientViewRequest recipient_view_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_view_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_envelope_recipient_shared_view" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_envelope_recipient_shared_view`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_envelope_recipient_shared_view`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/shared'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'recipient_view_request' in params:
            body_params = params['recipient_view_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ViewUrl',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_envelope_transfer_rules(self, account_id, **kwargs):
        """
        Add envelope transfer rules to an account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_envelope_transfer_rules(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param EnvelopeTransferRuleRequest envelope_transfer_rule_request:
        :return: EnvelopeTransferRuleInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_envelope_transfer_rules_with_http_info(account_id, **kwargs)
        else:
            (data) = self.create_envelope_transfer_rules_with_http_info(account_id, **kwargs)
            return data

    def create_envelope_transfer_rules_with_http_info(self, account_id, **kwargs):
        """
        Add envelope transfer rules to an account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_envelope_transfer_rules_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param EnvelopeTransferRuleRequest envelope_transfer_rule_request:
        :return: EnvelopeTransferRuleInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_transfer_rule_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_envelope_transfer_rules" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_envelope_transfer_rules`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/transfer_rules'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_transfer_rule_request' in params:
            body_params = params['envelope_transfer_rule_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeTransferRuleInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_error(self, **kwargs):
        """
        Uploads Kazmon error for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_error(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_error_with_http_info(**kwargs)
        else:
            (data) = self.create_error_with_http_info(**kwargs)
            return data

    def create_error_with_http_info(self, **kwargs):
        """
        Uploads Kazmon error for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_error_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_error" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        resource_path = '/v2.1/display_appliance_info/error'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_lock(self, account_id, envelope_id, **kwargs):
        """
        Lock an envelope.
        Locks the specified envelope, and sets the time until the lock expires, to prevent other users or recipients from accessing and changing the envelope.  ###### Note: Users must have envelope locking capability enabled to use this function (userSetting `canLockEnvelopes` must be  set to true for the user).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_lock(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param LockRequest lock_request:
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_lock_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_lock_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_lock_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Lock an envelope.
        Locks the specified envelope, and sets the time until the lock expires, to prevent other users or recipients from accessing and changing the envelope.  ###### Note: Users must have envelope locking capability enabled to use this function (userSetting `canLockEnvelopes` must be  set to true for the user).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_lock_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param LockRequest lock_request:
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'lock_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_lock" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_lock`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_lock`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'lock_request' in params:
            body_params = params['lock_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LockInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_page_info(self, account_id, envelope_id, **kwargs):
        """
        Create page information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_page_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_page_info_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_page_info_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_page_info_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Create page information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_page_info_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_page_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_page_info`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_page_info`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/page_info'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_pdf_blob(self, account_id, envelope_id, **kwargs):
        """
        Add pdf blobs for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_pdf_blob(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayAppliancePdf
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_pdf_blob_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_pdf_blob_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_pdf_blob_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Add pdf blobs for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_pdf_blob_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayAppliancePdf
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_pdf_blob" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_pdf_blob`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_pdf_blob`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/pdf_blobs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayAppliancePdf',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_recipient(self, account_id, envelope_id, **kwargs):
        """
        Adds one or more recipients to an envelope.
        Adds one or more recipients to an envelope.  For an in process envelope, one that has been sent and has not been completed or voided, an email is sent to a new recipient when they are reached in the routing order. If the new recipient's routing order is before or the same as the envelope's next recipient, an email is only sent if the optional `resend_envelope` query string is set to **true**.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_recipient(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str resend_envelope: When set to **true**, resends the   envelope if the new recipient's routing order is before or the same as the envelope's next recipient.
        :param Recipients recipients:
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_recipient_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_recipient_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_recipient_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Adds one or more recipients to an envelope.
        Adds one or more recipients to an envelope.  For an in process envelope, one that has been sent and has not been completed or voided, an email is sent to a new recipient when they are reached in the routing order. If the new recipient's routing order is before or the same as the envelope's next recipient, an email is only sent if the optional `resend_envelope` query string is set to **true**.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_recipient_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str resend_envelope: When set to **true**, resends the   envelope if the new recipient's routing order is before or the same as the envelope's next recipient.
        :param Recipients recipients:
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'resend_envelope', 'recipients']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_recipient" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_recipient`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_recipient`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'resend_envelope' in params:
            query_params['resend_envelope'] = params['resend_envelope']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'recipients' in params:
            body_params = params['recipients']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Recipients',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_recipient_manual_review_view(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Provides a link to access the Identity manual review related to a recipient.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_recipient_manual_review_view(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_recipient_manual_review_view_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.create_recipient_manual_review_view_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def create_recipient_manual_review_view_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Provides a link to access the Identity manual review related to a recipient.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_recipient_manual_review_view_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_recipient_manual_review_view" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_recipient_manual_review_view`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_recipient_manual_review_view`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `create_recipient_manual_review_view`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/views/identity_manual_review'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ViewUrl',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_recipient_proof_file_link(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Returns a link to access to the identity events stored in the proof service related to this recipient.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_recipient_proof_file_link(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: ProofServiceViewLink
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_recipient_proof_file_link_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.create_recipient_proof_file_link_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def create_recipient_proof_file_link_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Returns a link to access to the identity events stored in the proof service related to this recipient.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_recipient_proof_file_link_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: ProofServiceViewLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_recipient_proof_file_link" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_recipient_proof_file_link`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_recipient_proof_file_link`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `create_recipient_proof_file_link`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/identity_proof'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ProofServiceViewLink',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_recipient_proof_file_resource_token(self, account_id, envelope_id, recipient_id, token_scopes, **kwargs):
        """
        Returns a resource token to get access to the identity events stored in the proof service related to this recipient.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_recipient_proof_file_resource_token(account_id, envelope_id, recipient_id, token_scopes, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str token_scopes: (required)
        :return: ProofServiceResourceToken
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_recipient_proof_file_resource_token_with_http_info(account_id, envelope_id, recipient_id, token_scopes, **kwargs)
        else:
            (data) = self.create_recipient_proof_file_resource_token_with_http_info(account_id, envelope_id, recipient_id, token_scopes, **kwargs)
            return data

    def create_recipient_proof_file_resource_token_with_http_info(self, account_id, envelope_id, recipient_id, token_scopes, **kwargs):
        """
        Returns a resource token to get access to the identity events stored in the proof service related to this recipient.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_recipient_proof_file_resource_token_with_http_info(account_id, envelope_id, recipient_id, token_scopes, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str token_scopes: (required)
        :return: ProofServiceResourceToken
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id', 'token_scopes']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_recipient_proof_file_resource_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_recipient_proof_file_resource_token`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_recipient_proof_file_resource_token`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `create_recipient_proof_file_resource_token`")
        # verify the required parameter 'token_scopes' is set
        if ('token_scopes' not in params) or (params['token_scopes'] is None):
            raise ValueError("Missing the required parameter `token_scopes` when calling `create_recipient_proof_file_resource_token`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/identity_proof_token'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']
        if 'token_scopes' in params:
            path_params['token_scopes'] = params['token_scopes']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ProofServiceResourceToken',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_recipient_view(self, account_id, envelope_id, **kwargs):
        """
        Returns a URL to the recipient view UI.
        Returns a URL that allows you to embed the recipient view of the DocuSign UI in your applications. This call cannot be used to view draft envelopes, since those envelopes have not been sent.   Important: iFrames should not be used for embedded operations on mobile devices due to screen space issues. For iOS devices DocuSign recommends using a WebView.   An entry is added into the Security Level section of the DocuSign Certificate of Completion that reflects the `securityDomain` and `authenticationMethod` properties used to verify the user identity.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_recipient_view(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param RecipientViewRequest recipient_view_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_recipient_view_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_recipient_view_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_recipient_view_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Returns a URL to the recipient view UI.
        Returns a URL that allows you to embed the recipient view of the DocuSign UI in your applications. This call cannot be used to view draft envelopes, since those envelopes have not been sent.   Important: iFrames should not be used for embedded operations on mobile devices due to screen space issues. For iOS devices DocuSign recommends using a WebView.   An entry is added into the Security Level section of the DocuSign Certificate of Completion that reflects the `securityDomain` and `authenticationMethod` properties used to verify the user identity.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_recipient_view_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param RecipientViewRequest recipient_view_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_view_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_recipient_view" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_recipient_view`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_recipient_view`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/recipient'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'recipient_view_request' in params:
            body_params = params['recipient_view_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ViewUrl',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_redeem(self, **kwargs):
        """
        Returns signing url for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_redeem(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_redeem_with_http_info(**kwargs)
        else:
            (data) = self.create_redeem_with_http_info(**kwargs)
            return data

    def create_redeem_with_http_info(self, **kwargs):
        """
        Returns signing url for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_redeem_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_redeem" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        resource_path = '/v2.1/display_appliance_info/redeem'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayApplianceInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_responsive_html_preview(self, account_id, envelope_id, **kwargs):
        """
        Get Responsive HTML Preview for all documents in an envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_responsive_html_preview(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param DocumentHtmlDefinition document_html_definition:
        :return: DocumentHtmlDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_responsive_html_preview_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_responsive_html_preview_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_responsive_html_preview_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Get Responsive HTML Preview for all documents in an envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_responsive_html_preview_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param DocumentHtmlDefinition document_html_definition:
        :return: DocumentHtmlDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'document_html_definition']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_responsive_html_preview" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_responsive_html_preview`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_responsive_html_preview`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/responsive_html_preview'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_html_definition' in params:
            body_params = params['document_html_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentHtmlDefinitions',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_sender_view(self, account_id, envelope_id, **kwargs):
        """
        Returns a URL to the sender view UI.
        Returns a URL that allows you to embed the sender view of the DocuSign UI in your applications. This is a one-time use login token that allows the user to be placed into the DocuSign sending view.   Upon sending completion, the user is returned to the return URL provided by the API application.  Important: iFrames should not be used for embedded operations on mobile devices due to screen space issues. For iOS devices DocuSign recommends using a WebView. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_sender_view(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param ReturnUrlRequest return_url_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_sender_view_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.create_sender_view_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def create_sender_view_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Returns a URL to the sender view UI.
        Returns a URL that allows you to embed the sender view of the DocuSign UI in your applications. This is a one-time use login token that allows the user to be placed into the DocuSign sending view.   Upon sending completion, the user is returned to the return URL provided by the API application.  Important: iFrames should not be used for embedded operations on mobile devices due to screen space issues. For iOS devices DocuSign recommends using a WebView. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_sender_view_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param ReturnUrlRequest return_url_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'return_url_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sender_view" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_sender_view`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_sender_view`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/sender'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'return_url_request' in params:
            body_params = params['return_url_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ViewUrl',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_tabs(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Adds tabs for a recipient.
        Adds one or more tabs for a recipient.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_tabs(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param Tabs tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_tabs_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.create_tabs_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def create_tabs_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Adds tabs for a recipient.
        Adds one or more tabs for a recipient.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_tabs_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param Tabs tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id', 'tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_tabs`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `create_tabs`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `create_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tabs' in params:
            body_params = params['tabs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_attachments(self, account_id, envelope_id, **kwargs):
        """
        Delete one or more attachments from a DRAFT envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_attachments(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EnvelopeAttachmentsRequest envelope_attachments_request:
        :return: EnvelopeAttachmentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_attachments_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_attachments_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_attachments_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Delete one or more attachments from a DRAFT envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_attachments_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EnvelopeAttachmentsRequest envelope_attachments_request:
        :return: EnvelopeAttachmentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'envelope_attachments_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_attachments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_attachments`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_attachments`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_attachments_request' in params:
            body_params = params['envelope_attachments_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeAttachmentsResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_chunked_upload(self, account_id, chunked_upload_id, **kwargs):
        """
        Delete an existing ChunkedUpload.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_chunked_upload(account_id, chunked_upload_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str chunked_upload_id: (required)
        :return: ChunkedUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_chunked_upload_with_http_info(account_id, chunked_upload_id, **kwargs)
        else:
            (data) = self.delete_chunked_upload_with_http_info(account_id, chunked_upload_id, **kwargs)
            return data

    def delete_chunked_upload_with_http_info(self, account_id, chunked_upload_id, **kwargs):
        """
        Delete an existing ChunkedUpload.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_chunked_upload_with_http_info(account_id, chunked_upload_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str chunked_upload_id: (required)
        :return: ChunkedUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'chunked_upload_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_chunked_upload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_chunked_upload`")
        # verify the required parameter 'chunked_upload_id' is set
        if ('chunked_upload_id' not in params) or (params['chunked_upload_id'] is None):
            raise ValueError("Missing the required parameter `chunked_upload_id` when calling `delete_chunked_upload`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'chunked_upload_id' in params:
            path_params['chunkedUploadId'] = params['chunked_upload_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ChunkedUploadResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_custom_fields(self, account_id, envelope_id, **kwargs):
        """
        Deletes envelope custom fields for draft and in-process envelopes.
        Deletes envelope custom fields for draft and in-process envelopes.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_custom_fields(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param CustomFields custom_fields:
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_custom_fields_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_custom_fields_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_custom_fields_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Deletes envelope custom fields for draft and in-process envelopes.
        Deletes envelope custom fields for draft and in-process envelopes.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_custom_fields_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param CustomFields custom_fields:
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'custom_fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_custom_fields`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_custom_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'custom_fields' in params:
            body_params = params['custom_fields']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CustomFields',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_custom_fields_0(self, account_id, envelope_id, **kwargs):
        """
        Delete custom fields information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_custom_fields_0(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_custom_fields_0_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_custom_fields_0_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_custom_fields_0_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Delete custom fields information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_custom_fields_0_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_custom_fields_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_custom_fields_0`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_custom_fields_0`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/custom_fields/delete'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_custom_fields_v2(self, account_id, envelope_id, **kwargs):
        """
        Delete custom fields information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_custom_fields_v2(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_custom_fields_v2_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_custom_fields_v2_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_custom_fields_v2_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Delete custom fields information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_custom_fields_v2_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_custom_fields_v2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_custom_fields_v2`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_custom_fields_v2`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/custom_fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_document(self, account_id, document_id, envelope_id, **kwargs):
        """
        Delete document information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_document_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_document_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def delete_document_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Delete document information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_document`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `delete_document`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_document`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/document/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_document_fields(self, account_id, document_id, envelope_id, **kwargs):
        """
        Deletes custom document fields from an existing envelope document.
        Deletes custom document fields from an existing envelope document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_fields(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param DocumentFieldsInformation document_fields_information:
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_document_fields_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_document_fields_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def delete_document_fields_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Deletes custom document fields from an existing envelope document.
        Deletes custom document fields from an existing envelope document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_fields_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param DocumentFieldsInformation document_fields_information:
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'document_fields_information']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_document_fields`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `delete_document_fields`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_document_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_fields_information' in params:
            body_params = params['document_fields_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentFieldsInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_document_page(self, account_id, document_id, envelope_id, page_number, **kwargs):
        """
        Deletes a page from a document in an envelope.
        Deletes a page from a document in an envelope based on the page number.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_page(account_id, document_id, envelope_id, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_document_page_with_http_info(account_id, document_id, envelope_id, page_number, **kwargs)
        else:
            (data) = self.delete_document_page_with_http_info(account_id, document_id, envelope_id, page_number, **kwargs)
            return data

    def delete_document_page_with_http_info(self, account_id, document_id, envelope_id, page_number, **kwargs):
        """
        Deletes a page from a document in an envelope.
        Deletes a page from a document in an envelope based on the page number.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_page_with_http_info(account_id, document_id, envelope_id, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'page_number']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document_page" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_document_page`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `delete_document_page`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_document_page`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `delete_document_page`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_document_tabs(self, account_id, document_id, envelope_id, **kwargs):
        """
        Deletes tabs from an envelope document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_tabs(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param Tabs tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_document_tabs_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_document_tabs_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def delete_document_tabs_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Deletes tabs from an envelope document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_tabs_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param Tabs tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_document_tabs`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `delete_document_tabs`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_document_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tabs' in params:
            body_params = params['tabs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_documents(self, account_id, envelope_id, **kwargs):
        """
        Deletes documents from a draft envelope.
        Deletes one or more documents from an existing draft envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_documents(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EnvelopeDefinition envelope_definition:
        :return: EnvelopeDocumentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_documents_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_documents_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_documents_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Deletes documents from a draft envelope.
        Deletes one or more documents from an existing draft envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_documents_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EnvelopeDefinition envelope_definition:
        :return: EnvelopeDocumentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'envelope_definition']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_documents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_documents`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_documents`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_definition' in params:
            body_params = params['envelope_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeDocumentsResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_email_settings(self, account_id, envelope_id, **kwargs):
        """
        Deletes the email setting overrides for an envelope.
        Deletes all existing email override settings for the envelope. If you want to delete an individual email override setting, use the PUT and set the value to an empty string. Note that deleting email settings will only affect email communications that occur after the deletion and the normal account email settings are used for future email communications.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_email_settings(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: EmailSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_email_settings_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_email_settings_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_email_settings_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Deletes the email setting overrides for an envelope.
        Deletes all existing email override settings for the envelope. If you want to delete an individual email override setting, use the PUT and set the value to an empty string. Note that deleting email settings will only affect email communications that occur after the deletion and the normal account email settings are used for future email communications.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_email_settings_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: EmailSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_email_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_email_settings`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_email_settings`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EmailSettings',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_envelope_correct_view(self, account_id, envelope_id, **kwargs):
        """
        Revokes the correction view URL to the Envelope UI
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_envelope_correct_view(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param CorrectViewRequest correct_view_request:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_envelope_correct_view_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_envelope_correct_view_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_envelope_correct_view_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Revokes the correction view URL to the Envelope UI
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_envelope_correct_view_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param CorrectViewRequest correct_view_request:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'correct_view_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_envelope_correct_view" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_envelope_correct_view`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_envelope_correct_view`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/correct'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'correct_view_request' in params:
            body_params = params['correct_view_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_envelope_transfer_rules(self, account_id, envelope_transfer_rule_id, **kwargs):
        """
        Delete envelope transfer rules for an account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_envelope_transfer_rules(account_id, envelope_transfer_rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_transfer_rule_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_envelope_transfer_rules_with_http_info(account_id, envelope_transfer_rule_id, **kwargs)
        else:
            (data) = self.delete_envelope_transfer_rules_with_http_info(account_id, envelope_transfer_rule_id, **kwargs)
            return data

    def delete_envelope_transfer_rules_with_http_info(self, account_id, envelope_transfer_rule_id, **kwargs):
        """
        Delete envelope transfer rules for an account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_envelope_transfer_rules_with_http_info(account_id, envelope_transfer_rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_transfer_rule_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_transfer_rule_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_envelope_transfer_rules" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_envelope_transfer_rules`")
        # verify the required parameter 'envelope_transfer_rule_id' is set
        if ('envelope_transfer_rule_id' not in params) or (params['envelope_transfer_rule_id'] is None):
            raise ValueError("Missing the required parameter `envelope_transfer_rule_id` when calling `delete_envelope_transfer_rules`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/transfer_rules/{envelopeTransferRuleId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_transfer_rule_id' in params:
            path_params['envelopeTransferRuleId'] = params['envelope_transfer_rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_envelope_workflow_definition(self, account_id, envelope_id, **kwargs):
        """
        Delete the workflow definition for an envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_envelope_workflow_definition(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_envelope_workflow_definition_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_envelope_workflow_definition_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_envelope_workflow_definition_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Delete the workflow definition for an envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_envelope_workflow_definition_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_envelope_workflow_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_envelope_workflow_definition`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_envelope_workflow_definition`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_lock(self, account_id, envelope_id, **kwargs):
        """
        Deletes an envelope lock.
        Deletes the lock from the specified envelope. The `X-DocuSign-Edit` header must be included in the request.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_lock(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_lock_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_lock_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_lock_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Deletes an envelope lock.
        Deletes the lock from the specified envelope. The `X-DocuSign-Edit` header must be included in the request.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_lock_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_lock" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_lock`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_lock`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LockInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_page_info(self, account_id, envelope_id, **kwargs):
        """
        Delete page information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_page_info_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_page_info_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_page_info_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Delete page information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_info_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_page_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_page_info`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_page_info`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/page_info/delete'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_page_info_v2(self, account_id, envelope_id, **kwargs):
        """
        Delete page information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_info_v2(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_page_info_v2_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_page_info_v2_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_page_info_v2_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Delete page information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_info_v2_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_page_info_v2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_page_info_v2`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_page_info_v2`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/page_info'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_recipient(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Deletes a recipient from an envelope.
        Deletes the specified recipient file from the specified envelope. This cannot be used if the envelope has been sent.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recipient(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_recipient_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.delete_recipient_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def delete_recipient_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Deletes a recipient from an envelope.
        Deletes the specified recipient file from the specified envelope. This cannot be used if the envelope has been sent.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recipient_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_recipient" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_recipient`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_recipient`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `delete_recipient`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Recipients',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_recipient_denied_document_copy(self, account_id, envelope_id, **kwargs):
        """
        Delete RecipientDeniedDocumentCopy for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recipient_denied_document_copy(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_recipient_denied_document_copy_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_recipient_denied_document_copy_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_recipient_denied_document_copy_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Delete RecipientDeniedDocumentCopy for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recipient_denied_document_copy_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_recipient_denied_document_copy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_recipient_denied_document_copy`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_recipient_denied_document_copy`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/recipient_denied_copy'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_recipients(self, account_id, envelope_id, **kwargs):
        """
        Deletes recipients from an envelope.
        Deletes one or more recipients from a draft or sent envelope. Recipients to be deleted are listed in the request, with the `recipientId` being used as the key for deleting recipients.  If the envelope is `In Process`, meaning that it has been sent and has not  been completed or voided, recipients that have completed their actions cannot be deleted.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recipients(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param Recipients recipients:
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_recipients_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_recipients_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_recipients_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Deletes recipients from an envelope.
        Deletes one or more recipients from a draft or sent envelope. Recipients to be deleted are listed in the request, with the `recipientId` being used as the key for deleting recipients.  If the envelope is `In Process`, meaning that it has been sent and has not  been completed or voided, recipients that have completed their actions cannot be deleted.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recipients_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param Recipients recipients:
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipients']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_recipients" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_recipients`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_recipients`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'recipients' in params:
            body_params = params['recipients']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Recipients',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_signer_attachment(self, account_id, envelope_id, **kwargs):
        """
        Delete signer attachment information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_signer_attachment(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_signer_attachment_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.delete_signer_attachment_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def delete_signer_attachment_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Delete signer attachment information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_signer_attachment_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_signer_attachment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_signer_attachment`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_signer_attachment`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/signer_attachment_info'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_tabs(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Deletes the tabs associated with a recipient.
        Deletes one or more tabs associated with a recipient in a draft envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tabs(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param Tabs tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_tabs_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.delete_tabs_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def delete_tabs_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Deletes the tabs associated with a recipient.
        Deletes one or more tabs associated with a recipient in a draft envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tabs_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param Tabs tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id', 'tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_tabs`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_tabs`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `delete_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tabs' in params:
            body_params = params['tabs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_template_workflow_definition(self, account_id, template_id, **kwargs):
        """
        Delete the workflow definition for a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_template_workflow_definition(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_template_workflow_definition_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.delete_template_workflow_definition_with_http_info(account_id, template_id, **kwargs)
            return data

    def delete_template_workflow_definition_with_http_info(self, account_id, template_id, **kwargs):
        """
        Delete the workflow definition for a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_template_workflow_definition_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_template_workflow_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_template_workflow_definition`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_template_workflow_definition`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/workflow'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_templates_from_document(self, account_id, document_id, envelope_id, template_id, **kwargs):
        """
        Deletes a template from a document in an existing envelope.
        Deletes the specified template from a document in an existing envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_templates_from_document(account_id, document_id, envelope_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_templates_from_document_with_http_info(account_id, document_id, envelope_id, template_id, **kwargs)
        else:
            (data) = self.delete_templates_from_document_with_http_info(account_id, document_id, envelope_id, template_id, **kwargs)
            return data

    def delete_templates_from_document_with_http_info(self, account_id, document_id, envelope_id, template_id, **kwargs):
        """
        Deletes a template from a document in an existing envelope.
        Deletes the specified template from a document in an existing envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_templates_from_document_with_http_info(account_id, document_id, envelope_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'template_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_templates_from_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_templates_from_document`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `delete_templates_from_document`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `delete_templates_from_document`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_templates_from_document`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates/{templateId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_account(self, account_id, envelope_id, **kwargs):
        """
        Returns envelope account information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceAccount
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_account_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_account_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_account_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Returns envelope account information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceAccount
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_account`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_account`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/account_info'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayApplianceAccount',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_appliance_envelope_info(self, account_id, envelope_id, **kwargs):
        """
        Returns Display Appliance envelope information
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_appliance_envelope_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str before_sign:
        :param str document_id:
        :param str entity_type:
        :param str in_person:
        :param str recipient_id:
        :param str tab_locale_policy:
        :param str tab_type:
        :param str use_date_signed_tab_val_exclusively:
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_appliance_envelope_info_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_appliance_envelope_info_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_appliance_envelope_info_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Returns Display Appliance envelope information
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_appliance_envelope_info_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str before_sign:
        :param str document_id:
        :param str entity_type:
        :param str in_person:
        :param str recipient_id:
        :param str tab_locale_policy:
        :param str tab_type:
        :param str use_date_signed_tab_val_exclusively:
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'before_sign', 'document_id', 'entity_type', 'in_person', 'recipient_id', 'tab_locale_policy', 'tab_type', 'use_date_signed_tab_val_exclusively']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_appliance_envelope_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_appliance_envelope_info`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_appliance_envelope_info`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info_v2'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'before_sign' in params:
            query_params['beforeSign'] = params['before_sign']
        if 'document_id' in params:
            query_params['document_id'] = params['document_id']
        if 'entity_type' in params:
            query_params['entity_type'] = params['entity_type']
        if 'in_person' in params:
            query_params['inPerson'] = params['in_person']
        if 'recipient_id' in params:
            query_params['recipient_id'] = params['recipient_id']
        if 'tab_locale_policy' in params:
            query_params['tabLocalePolicy'] = params['tab_locale_policy']
        if 'tab_type' in params:
            query_params['tabType'] = params['tab_type']
        if 'use_date_signed_tab_val_exclusively' in params:
            query_params['useDateSignedTabValExclusively'] = params['use_date_signed_tab_val_exclusively']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayApplianceInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_appliance_info(self, account_id, envelope_id, **kwargs):
        """
        Returns envelope and recipient information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_appliance_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_appliance_info_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_appliance_info_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_appliance_info_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Returns envelope and recipient information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_appliance_info_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_appliance_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_appliance_info`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_appliance_info`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayApplianceInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_attachment(self, account_id, attachment_id, envelope_id, **kwargs):
        """
        Retrieves an attachment from the envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_attachment(account_id, attachment_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str attachment_id: (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_attachment_with_http_info(account_id, attachment_id, envelope_id, **kwargs)
        else:
            (data) = self.get_attachment_with_http_info(account_id, attachment_id, envelope_id, **kwargs)
            return data

    def get_attachment_with_http_info(self, account_id, attachment_id, envelope_id, **kwargs):
        """
        Retrieves an attachment from the envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_attachment_with_http_info(account_id, attachment_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str attachment_id: (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'attachment_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_attachment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_attachment`")
        # verify the required parameter 'attachment_id' is set
        if ('attachment_id' not in params) or (params['attachment_id'] is None):
            raise ValueError("Missing the required parameter `attachment_id` when calling `get_attachment`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_attachment`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'attachment_id' in params:
            path_params['attachmentId'] = params['attachment_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_attachments(self, account_id, envelope_id, **kwargs):
        """
        Returns a list of attachments associated with the specified envelope
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_attachments(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: EnvelopeAttachmentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_attachments_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_attachments_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_attachments_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Returns a list of attachments associated with the specified envelope
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_attachments_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: EnvelopeAttachmentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_attachments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_attachments`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_attachments`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeAttachmentsResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_chunked_upload(self, account_id, chunked_upload_id, **kwargs):
        """
        Retrieves the current metadata of a ChunkedUpload.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chunked_upload(account_id, chunked_upload_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str chunked_upload_id: (required)
        :param str include:
        :return: ChunkedUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_chunked_upload_with_http_info(account_id, chunked_upload_id, **kwargs)
        else:
            (data) = self.get_chunked_upload_with_http_info(account_id, chunked_upload_id, **kwargs)
            return data

    def get_chunked_upload_with_http_info(self, account_id, chunked_upload_id, **kwargs):
        """
        Retrieves the current metadata of a ChunkedUpload.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chunked_upload_with_http_info(account_id, chunked_upload_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str chunked_upload_id: (required)
        :param str include:
        :return: ChunkedUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'chunked_upload_id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chunked_upload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_chunked_upload`")
        # verify the required parameter 'chunked_upload_id' is set
        if ('chunked_upload_id' not in params) or (params['chunked_upload_id'] is None):
            raise ValueError("Missing the required parameter `chunked_upload_id` when calling `get_chunked_upload`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'chunked_upload_id' in params:
            path_params['chunkedUploadId'] = params['chunked_upload_id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ChunkedUploadResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_comments_transcript(self, account_id, envelope_id, **kwargs):
        """
        Gets comment transcript for envelope and user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_comments_transcript(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str encoding:
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_comments_transcript_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_comments_transcript_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_comments_transcript_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Gets comment transcript for envelope and user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_comments_transcript_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str encoding:
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'encoding']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_comments_transcript" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_comments_transcript`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_comments_transcript`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/comments/transcript'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'encoding' in params:
            query_params['encoding'] = params['encoding']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/pdf'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_consumer_disclosure(self, account_id, envelope_id, lang_code, recipient_id, **kwargs):
        """
        Reserved: Gets the Electronic Record and Signature Disclosure associated with the account.
        Reserved: Retrieves the Electronic Record and Signature Disclosure, with HTML formatting, associated with the account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_consumer_disclosure(account_id, envelope_id, lang_code, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str lang_code: The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Armenian (hy), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to Ã¯Â¿Â½browserÃ¯Â¿Â½ to automatically detect the browser language being used by the viewer and display the disclosure in that language. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str lang_code2:
        :return: ConsumerDisclosure
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_consumer_disclosure_with_http_info(account_id, envelope_id, lang_code, recipient_id, **kwargs)
        else:
            (data) = self.get_consumer_disclosure_with_http_info(account_id, envelope_id, lang_code, recipient_id, **kwargs)
            return data

    def get_consumer_disclosure_with_http_info(self, account_id, envelope_id, lang_code, recipient_id, **kwargs):
        """
        Reserved: Gets the Electronic Record and Signature Disclosure associated with the account.
        Reserved: Retrieves the Electronic Record and Signature Disclosure, with HTML formatting, associated with the account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_consumer_disclosure_with_http_info(account_id, envelope_id, lang_code, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str lang_code: The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Armenian (hy), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to Ã¯Â¿Â½browserÃ¯Â¿Â½ to automatically detect the browser language being used by the viewer and display the disclosure in that language. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str lang_code2:
        :return: ConsumerDisclosure
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'lang_code', 'recipient_id', 'lang_code2']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_consumer_disclosure" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_consumer_disclosure`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_consumer_disclosure`")
        # verify the required parameter 'lang_code' is set
        if ('lang_code' not in params) or (params['lang_code'] is None):
            raise ValueError("Missing the required parameter `lang_code` when calling `get_consumer_disclosure`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `get_consumer_disclosure`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure/{langCode}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'lang_code' in params:
            path_params['langCode'] = params['lang_code']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}
        if 'lang_code2' in params:
            query_params['langCode'] = params['lang_code2']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ConsumerDisclosure',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_consumer_disclosure_default(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Gets the Electronic Record and Signature Disclosure associated with the account.
        Retrieves the Electronic Record and Signature Disclosure, with html formatting, associated with the account. You can use an optional query string to set the language for the disclosure.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_consumer_disclosure_default(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str lang_code:
        :return: ConsumerDisclosure
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_consumer_disclosure_default_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.get_consumer_disclosure_default_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def get_consumer_disclosure_default_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Gets the Electronic Record and Signature Disclosure associated with the account.
        Retrieves the Electronic Record and Signature Disclosure, with html formatting, associated with the account. You can use an optional query string to set the language for the disclosure.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_consumer_disclosure_default_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str lang_code:
        :return: ConsumerDisclosure
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id', 'lang_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_consumer_disclosure_default" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_consumer_disclosure_default`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_consumer_disclosure_default`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `get_consumer_disclosure_default`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}
        if 'lang_code' in params:
            query_params['langCode'] = params['lang_code']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ConsumerDisclosure',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_custom_fields(self, account_id, envelope_id, **kwargs):
        """
        Return custom fields information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_custom_fields(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_custom_fields_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_custom_fields_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_custom_fields_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Return custom fields information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_custom_fields_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_custom_fields`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_custom_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/custom_fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayApplianceInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_date_signed(self, account_id, envelope_id, **kwargs):
        """
        Gets date signed information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_date_signed(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_date_signed_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_date_signed_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_date_signed_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Gets date signed information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_date_signed_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_date_signed" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_date_signed`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_date_signed`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/date_signed'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayApplianceInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document(self, account_id, document_id, envelope_id, **kwargs):
        """
        Gets a document from an envelope.
        Retrieves the specified document from the envelope. If the account has the Highlight Data Changes feature enabled, there is an option to request that any changes in the envelope be highlighted.  You can also use this method to retrieve a PDF containing the combined content of all documents and the certificate. If the account has the Highlight Data Changes feature enabled, there is an option to request that any changes in the envelope be highlighted.   To retrieve the combined content replace the `{documentId}` parameter in the endpoint with `combined`. /accounts/{accountId}/envelopes/{envelopeId}/documents/combined
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str certificate: When set to **false**, the envelope signing certificate is removed from the download.
        :param str documents_by_userid:
        :param str encoding:
        :param str encrypt: When set to **true**, the PDF bytes returned in the response are encrypted for all the key managers configured on your DocuSign account. The documents can be decrypted with the KeyManager Decrypt Document API.
        :param str language: Specifies the language for the Certificate of Completion in the response. The supported languages, with the language value shown in parenthesis, are: Chinese Simplified (zh_CN), , Chinese Traditional (zh_TW), Dutch (nl), English US (en), French (fr), German (de), Italian (it), Japanese (ja), Korean (ko), Portuguese (pt), Portuguese (Brazil) (pt_BR), Russian (ru), Spanish (es). 
        :param str recipient_id:
        :param str shared_user_id:
        :param str show_changes: When set to **true**, any changed fields for the returned PDF are highlighted in yellow and optional signatures or initials outlined in red. 
        :param str watermark: When set to **true**, the account has the watermark feature enabled, and the envelope is not complete, the watermark for the account is added to the PDF documents. This option can remove the watermark. 
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.get_document_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def get_document_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Gets a document from an envelope.
        Retrieves the specified document from the envelope. If the account has the Highlight Data Changes feature enabled, there is an option to request that any changes in the envelope be highlighted.  You can also use this method to retrieve a PDF containing the combined content of all documents and the certificate. If the account has the Highlight Data Changes feature enabled, there is an option to request that any changes in the envelope be highlighted.   To retrieve the combined content replace the `{documentId}` parameter in the endpoint with `combined`. /accounts/{accountId}/envelopes/{envelopeId}/documents/combined
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str certificate: When set to **false**, the envelope signing certificate is removed from the download.
        :param str documents_by_userid:
        :param str encoding:
        :param str encrypt: When set to **true**, the PDF bytes returned in the response are encrypted for all the key managers configured on your DocuSign account. The documents can be decrypted with the KeyManager Decrypt Document API.
        :param str language: Specifies the language for the Certificate of Completion in the response. The supported languages, with the language value shown in parenthesis, are: Chinese Simplified (zh_CN), , Chinese Traditional (zh_TW), Dutch (nl), English US (en), French (fr), German (de), Italian (it), Japanese (ja), Korean (ko), Portuguese (pt), Portuguese (Brazil) (pt_BR), Russian (ru), Spanish (es). 
        :param str recipient_id:
        :param str shared_user_id:
        :param str show_changes: When set to **true**, any changed fields for the returned PDF are highlighted in yellow and optional signatures or initials outlined in red. 
        :param str watermark: When set to **true**, the account has the watermark feature enabled, and the envelope is not complete, the watermark for the account is added to the PDF documents. This option can remove the watermark. 
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'certificate', 'documents_by_userid', 'encoding', 'encrypt', 'language', 'recipient_id', 'shared_user_id', 'show_changes', 'watermark']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_document`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_document`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_document`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'certificate' in params:
            query_params['certificate'] = params['certificate']
        if 'documents_by_userid' in params:
            query_params['documents_by_userid'] = params['documents_by_userid']
        if 'encoding' in params:
            query_params['encoding'] = params['encoding']
        if 'encrypt' in params:
            query_params['encrypt'] = params['encrypt']
        if 'language' in params:
            query_params['language'] = params['language']
        if 'recipient_id' in params:
            query_params['recipient_id'] = params['recipient_id']
        if 'shared_user_id' in params:
            query_params['shared_user_id'] = params['shared_user_id']
        if 'show_changes' in params:
            query_params['show_changes'] = params['show_changes']
        if 'watermark' in params:
            query_params['watermark'] = params['watermark']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/pdf'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_page_image(self, account_id, document_id, envelope_id, page_number, **kwargs):
        """
        Gets a page image from an envelope for display.
        Retrieves a page image for display from the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_page_image(account_id, document_id, envelope_id, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :param str dpi: Sets the dpi for the image.
        :param str max_height: Sets the maximum height for the page image in pixels. The dpi is recalculated based on this setting.
        :param str max_width: Sets the maximum width for the page image in pixels. The dpi is recalculated based on this setting.
        :param str show_changes:
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_page_image_with_http_info(account_id, document_id, envelope_id, page_number, **kwargs)
        else:
            (data) = self.get_document_page_image_with_http_info(account_id, document_id, envelope_id, page_number, **kwargs)
            return data

    def get_document_page_image_with_http_info(self, account_id, document_id, envelope_id, page_number, **kwargs):
        """
        Gets a page image from an envelope for display.
        Retrieves a page image for display from the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_page_image_with_http_info(account_id, document_id, envelope_id, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :param str dpi: Sets the dpi for the image.
        :param str max_height: Sets the maximum height for the page image in pixels. The dpi is recalculated based on this setting.
        :param str max_width: Sets the maximum width for the page image in pixels. The dpi is recalculated based on this setting.
        :param str show_changes:
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'page_number', 'dpi', 'max_height', 'max_width', 'show_changes']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_page_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_document_page_image`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_document_page_image`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_document_page_image`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_document_page_image`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = {}
        if 'dpi' in params:
            query_params['dpi'] = params['dpi']
        if 'max_height' in params:
            query_params['max_height'] = params['max_height']
        if 'max_width' in params:
            query_params['max_width'] = params['max_width']
        if 'show_changes' in params:
            query_params['show_changes'] = params['show_changes']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['image/png'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_pages(self, account_id, envelope_id, **kwargs):
        """
        Return document pages for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_pages(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_pages_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_document_pages_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_document_pages_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Return document pages for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_pages_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_pages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_document_pages`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_document_pages`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/document_page_list'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayApplianceInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_tabs(self, account_id, document_id, envelope_id, **kwargs):
        """
        Returns tabs on the document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_tabs(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str include_metadata:
        :param str page_numbers:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_tabs_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.get_document_tabs_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def get_document_tabs_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Returns tabs on the document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_tabs_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str include_metadata:
        :param str page_numbers:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'include_metadata', 'page_numbers']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_document_tabs`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_document_tabs`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_document_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'include_metadata' in params:
            query_params['include_metadata'] = params['include_metadata']
        if 'page_numbers' in params:
            query_params['page_numbers'] = params['page_numbers']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_dynamic_system_settings(self, account_id, **kwargs):
        """
        Return document pages for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_dynamic_system_settings(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_dynamic_system_settings_with_http_info(account_id, **kwargs)
        else:
            (data) = self.get_dynamic_system_settings_with_http_info(account_id, **kwargs)
            return data

    def get_dynamic_system_settings_with_http_info(self, account_id, **kwargs):
        """
        Return document pages for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_dynamic_system_settings_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dynamic_system_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_dynamic_system_settings`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/display_appliance_info/dynamicsystemsettings'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayApplianceInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_email_settings(self, account_id, envelope_id, **kwargs):
        """
        Gets the email setting overrides for an envelope.
        Retrieves the email override settings for the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_email_settings(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: EmailSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_email_settings_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_email_settings_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_email_settings_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Gets the email setting overrides for an envelope.
        Retrieves the email override settings for the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_email_settings_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: EmailSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_email_settings`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_email_settings`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EmailSettings',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_envelope(self, account_id, envelope_id, **kwargs):
        """
        Gets the status of a envelope.
        Retrieves the overall status for the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_envelope(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str advanced_update: When true, envelope information can be added or modified.
        :param str include:
        :return: Envelope
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_envelope_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_envelope_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_envelope_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Gets the status of a envelope.
        Retrieves the overall status for the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_envelope_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str advanced_update: When true, envelope information can be added or modified.
        :param str include:
        :return: Envelope
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'advanced_update', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_envelope" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_envelope`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_envelope`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'advanced_update' in params:
            query_params['advanced_update'] = params['advanced_update']
        if 'include' in params:
            query_params['include'] = params['include']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Envelope',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_envelope_document_html_definitions(self, account_id, document_id, envelope_id, **kwargs):
        """
        Get the Original HTML Definition used to generate the Responsive HTML for a given document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_envelope_document_html_definitions(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DocumentHtmlDefinitionOriginals
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_envelope_document_html_definitions_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.get_envelope_document_html_definitions_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def get_envelope_document_html_definitions_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Get the Original HTML Definition used to generate the Responsive HTML for a given document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_envelope_document_html_definitions_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DocumentHtmlDefinitionOriginals
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_envelope_document_html_definitions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_envelope_document_html_definitions`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_envelope_document_html_definitions`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_envelope_document_html_definitions`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/html_definitions'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentHtmlDefinitionOriginals',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_envelope_html_definitions(self, account_id, envelope_id, **kwargs):
        """
        Get the Original HTML Definition used to generate the Responsive HTML for the envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_envelope_html_definitions(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DocumentHtmlDefinitionOriginals
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_envelope_html_definitions_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_envelope_html_definitions_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_envelope_html_definitions_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Get the Original HTML Definition used to generate the Responsive HTML for the envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_envelope_html_definitions_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DocumentHtmlDefinitionOriginals
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_envelope_html_definitions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_envelope_html_definitions`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_envelope_html_definitions`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/html_definitions'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentHtmlDefinitionOriginals',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_envelope_transfer_rules(self, account_id, **kwargs):
        """
        Returns a list of envelope transfer rules in the specified account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_envelope_transfer_rules(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str count:
        :param str start_position:
        :return: EnvelopeTransferRuleInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_envelope_transfer_rules_with_http_info(account_id, **kwargs)
        else:
            (data) = self.get_envelope_transfer_rules_with_http_info(account_id, **kwargs)
            return data

    def get_envelope_transfer_rules_with_http_info(self, account_id, **kwargs):
        """
        Returns a list of envelope transfer rules in the specified account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_envelope_transfer_rules_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str count:
        :param str start_position:
        :return: EnvelopeTransferRuleInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'count', 'start_position']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_envelope_transfer_rules" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_envelope_transfer_rules`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/transfer_rules'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'count' in params:
            query_params['count'] = params['count']
        if 'start_position' in params:
            query_params['start_position'] = params['start_position']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeTransferRuleInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_envelope_workflow_definition(self, account_id, envelope_id, **kwargs):
        """
        Returns the workflow definition for an envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_envelope_workflow_definition(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_envelope_workflow_definition_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_envelope_workflow_definition_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_envelope_workflow_definition_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Returns the workflow definition for an envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_envelope_workflow_definition_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_envelope_workflow_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_envelope_workflow_definition`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_envelope_workflow_definition`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Workflow',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_form_data(self, account_id, envelope_id, **kwargs):
        """
        Returns envelope form data for an existing envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_form_data(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: EnvelopeFormData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_form_data_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_form_data_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_form_data_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Returns envelope form data for an existing envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_form_data_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: EnvelopeFormData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_form_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_form_data`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_form_data`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/form_data'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeFormData',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_image(self, account_id, envelope_id, **kwargs):
        """
        Returns images for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_image(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_image_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_image_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_image_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Returns images for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_image_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_image`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_image`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/image'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayApplianceInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_locale_policy(self, account_id, envelope_id, user_id, **kwargs):
        """
        Returns locale policy information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_locale_policy(account_id, envelope_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str user_id: The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_locale_policy_with_http_info(account_id, envelope_id, user_id, **kwargs)
        else:
            (data) = self.get_locale_policy_with_http_info(account_id, envelope_id, user_id, **kwargs)
            return data

    def get_locale_policy_with_http_info(self, account_id, envelope_id, user_id, **kwargs):
        """
        Returns locale policy information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_locale_policy_with_http_info(account_id, envelope_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str user_id: The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_locale_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_locale_policy`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_locale_policy`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_locale_policy`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/localepolicy/{userId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayApplianceInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_lock(self, account_id, envelope_id, **kwargs):
        """
        Gets envelope lock information.
        Retrieves general information about the envelope lock.  If the call is made by the locked by user and the request has the same integrator key as original, then the `X-DocuSign-Edit` header and additional lock information is included in the response. This allows users to recover a lost editing session token and the `X-DocuSign-Edit` header.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_lock(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_lock_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_lock_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_lock_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Gets envelope lock information.
        Retrieves general information about the envelope lock.  If the call is made by the locked by user and the request has the same integrator key as original, then the `X-DocuSign-Edit` header and additional lock information is included in the response. This allows users to recover a lost editing session token and the `X-DocuSign-Edit` header.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_lock_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lock" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_lock`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_lock`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LockInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_notification_settings(self, account_id, envelope_id, **kwargs):
        """
        Gets envelope notification information.
        Retrieves the envelope notification, reminders and expirations, information for an existing envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_notification_settings(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_notification_settings_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_notification_settings_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_notification_settings_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Gets envelope notification information.
        Retrieves the envelope notification, reminders and expirations, information for an existing envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_notification_settings_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_notification_settings`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_notification_settings`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/notification'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Notification',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_tabs(self, account_id, document_id, envelope_id, page_number, **kwargs):
        """
        Returns tabs on the specified page.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_tabs(account_id, document_id, envelope_id, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_tabs_with_http_info(account_id, document_id, envelope_id, page_number, **kwargs)
        else:
            (data) = self.get_page_tabs_with_http_info(account_id, document_id, envelope_id, page_number, **kwargs)
            return data

    def get_page_tabs_with_http_info(self, account_id, document_id, envelope_id, page_number, **kwargs):
        """
        Returns tabs on the specified page.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_tabs_with_http_info(account_id, document_id, envelope_id, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'page_number']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_page_tabs`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_page_tabs`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_page_tabs`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pages(self, account_id, document_id, envelope_id, **kwargs):
        """
        Returns document page image(s) based on input.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pages(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str count:
        :param str dpi:
        :param str max_height:
        :param str max_width:
        :param str nocache:
        :param str show_changes:
        :param str start_position:
        :return: PageImages
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pages_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.get_pages_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def get_pages_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Returns document page image(s) based on input.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pages_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str count:
        :param str dpi:
        :param str max_height:
        :param str max_width:
        :param str nocache:
        :param str show_changes:
        :param str start_position:
        :return: PageImages
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'count', 'dpi', 'max_height', 'max_width', 'nocache', 'show_changes', 'start_position']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_pages`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_pages`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_pages`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'count' in params:
            query_params['count'] = params['count']
        if 'dpi' in params:
            query_params['dpi'] = params['dpi']
        if 'max_height' in params:
            query_params['max_height'] = params['max_height']
        if 'max_width' in params:
            query_params['max_width'] = params['max_width']
        if 'nocache' in params:
            query_params['nocache'] = params['nocache']
        if 'show_changes' in params:
            query_params['show_changes'] = params['show_changes']
        if 'start_position' in params:
            query_params['start_position'] = params['start_position']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PageImages',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf(self, account_id, envelope_id, pdf_id, **kwargs):
        """
        Return pdf for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf(account_id, envelope_id, pdf_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str pdf_id: (required)
        :return: DisplayAppliancePdf
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_with_http_info(account_id, envelope_id, pdf_id, **kwargs)
        else:
            (data) = self.get_pdf_with_http_info(account_id, envelope_id, pdf_id, **kwargs)
            return data

    def get_pdf_with_http_info(self, account_id, envelope_id, pdf_id, **kwargs):
        """
        Return pdf for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_with_http_info(account_id, envelope_id, pdf_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str pdf_id: (required)
        :return: DisplayAppliancePdf
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'pdf_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_pdf`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_pdf`")
        # verify the required parameter 'pdf_id' is set
        if ('pdf_id' not in params) or (params['pdf_id'] is None):
            raise ValueError("Missing the required parameter `pdf_id` when calling `get_pdf`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/pdf/{pdfId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'pdf_id' in params:
            path_params['pdfId'] = params['pdf_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayAppliancePdf',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_blob(self, account_id, envelope_id, **kwargs):
        """
        Return pdf blobs for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_blob(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayAppliancePdf
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_blob_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_pdf_blob_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_pdf_blob_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Return pdf blobs for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_blob_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayAppliancePdf
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_blob" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_pdf_blob`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_pdf_blob`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/pdf_blobs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayAppliancePdf',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_recipient_document_visibility(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Returns document visibility for the recipients
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recipient_document_visibility(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: DocumentVisibilityList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_recipient_document_visibility_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.get_recipient_document_visibility_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def get_recipient_document_visibility_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Returns document visibility for the recipients
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recipient_document_visibility_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: DocumentVisibilityList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recipient_document_visibility" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_recipient_document_visibility`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_recipient_document_visibility`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `get_recipient_document_visibility`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentVisibilityList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_recipient_initials_image(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Gets the initials image for a user.
        Retrieves the initials image for the specified user. The image is returned in the same format as it was uploaded. In the request you can specify if the chrome (the added line and identifier around the initial image) is returned with the image.  The userId specified in the endpoint must match the authenticated user's user id and the user must be a member of the account.  The `signatureIdOrName` paramter accepts signature ID or signature name. DocuSign recommends you use signature ID (`signatureId`), since some names contain characters that do not properly URL encode. If you use the user name, it is likely that the name includes spaces and you might need to URL encode the name before using it in the endpoint.   For example: \"Bob Smith\" to \"Bob%20Smith\"  Older envelopes might only contain chromed images. If getting the non-chromed image fails, try getting the chromed image.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recipient_initials_image(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str include_chrome: The added line and identifier around the initial image. Note: Older envelopes might only have chromed images. If getting the non-chromed image fails, try getting the chromed image.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_recipient_initials_image_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.get_recipient_initials_image_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def get_recipient_initials_image_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Gets the initials image for a user.
        Retrieves the initials image for the specified user. The image is returned in the same format as it was uploaded. In the request you can specify if the chrome (the added line and identifier around the initial image) is returned with the image.  The userId specified in the endpoint must match the authenticated user's user id and the user must be a member of the account.  The `signatureIdOrName` paramter accepts signature ID or signature name. DocuSign recommends you use signature ID (`signatureId`), since some names contain characters that do not properly URL encode. If you use the user name, it is likely that the name includes spaces and you might need to URL encode the name before using it in the endpoint.   For example: \"Bob Smith\" to \"Bob%20Smith\"  Older envelopes might only contain chromed images. If getting the non-chromed image fails, try getting the chromed image.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recipient_initials_image_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str include_chrome: The added line and identifier around the initial image. Note: Older envelopes might only have chromed images. If getting the non-chromed image fails, try getting the chromed image.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id', 'include_chrome']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recipient_initials_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_recipient_initials_image`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_recipient_initials_image`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `get_recipient_initials_image`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}
        if 'include_chrome' in params:
            query_params['include_chrome'] = params['include_chrome']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['image/gif'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_recipient_signature(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Gets signature information for a signer or sign-in-person recipient.
        Retrieves signature information for a signer or sign-in-person recipient.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recipient_signature(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: UserSignature
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_recipient_signature_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.get_recipient_signature_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def get_recipient_signature_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Gets signature information for a signer or sign-in-person recipient.
        Retrieves signature information for a signer or sign-in-person recipient.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recipient_signature_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: UserSignature
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recipient_signature" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_recipient_signature`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_recipient_signature`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `get_recipient_signature`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UserSignature',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_recipient_signature_image(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Retrieve signature image information for a signer/sign-in-person recipient.
        Retrieves the specified user signature image. The image is returned in the same format as uploaded. In the request you can specify if the chrome (the added line and identifier around the initial image) is returned with the image.  The userId specified in the endpoint must match the authenticated user's user ID and the user must be a member of the account.  The `signatureIdOrName` parameter accepts signature ID or signature name. DocuSign recommends you use signature ID (`signatureId`), since some names contain characters that don't properly URL encode. If you use the user name, it is likely that the name includes spaces and you might need to URL encode the name before using it in the endpoint.   For example: \"Bob Smith\" to \"Bob%20Smith\"  Older envelopes might only have chromed images. If getting the non-chromed image fails, try getting the chromed image.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recipient_signature_image(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str include_chrome: When set to **true**, indicates the chromed version of the signature image should be retrieved.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_recipient_signature_image_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.get_recipient_signature_image_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def get_recipient_signature_image_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Retrieve signature image information for a signer/sign-in-person recipient.
        Retrieves the specified user signature image. The image is returned in the same format as uploaded. In the request you can specify if the chrome (the added line and identifier around the initial image) is returned with the image.  The userId specified in the endpoint must match the authenticated user's user ID and the user must be a member of the account.  The `signatureIdOrName` parameter accepts signature ID or signature name. DocuSign recommends you use signature ID (`signatureId`), since some names contain characters that don't properly URL encode. If you use the user name, it is likely that the name includes spaces and you might need to URL encode the name before using it in the endpoint.   For example: \"Bob Smith\" to \"Bob%20Smith\"  Older envelopes might only have chromed images. If getting the non-chromed image fails, try getting the chromed image.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recipient_signature_image_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str include_chrome: When set to **true**, indicates the chromed version of the signature image should be retrieved.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id', 'include_chrome']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recipient_signature_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_recipient_signature_image`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_recipient_signature_image`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `get_recipient_signature_image`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}
        if 'include_chrome' in params:
            query_params['include_chrome'] = params['include_chrome']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['image/gif'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_signer_attachment(self, account_id, envelope_id, **kwargs):
        """
        Return signer attachment information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signer_attachment(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceSignerAttachment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_signer_attachment_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_signer_attachment_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_signer_attachment_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Return signer attachment information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signer_attachment_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayApplianceSignerAttachment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_signer_attachment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_signer_attachment`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_signer_attachment`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/signer_attachment_info'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayApplianceSignerAttachment',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_tabs_blob(self, account_id, envelope_id, **kwargs):
        """
        Get encrypted tabs for envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tabs_blob(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_tabs_blob_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.get_tabs_blob_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def get_tabs_blob_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Get encrypted tabs for envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tabs_blob_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tabs_blob" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_tabs_blob`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `get_tabs_blob`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/tabs_blob'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_template_info(self, account_id, **kwargs):
        """
        Returns if template was encrypted by Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_template_info_with_http_info(account_id, **kwargs)
        else:
            (data) = self.get_template_info_with_http_info(account_id, **kwargs)
            return data

    def get_template_info_with_http_info(self, account_id, **kwargs):
        """
        Returns if template was encrypted by Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_info_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :return: DisplayApplianceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_template_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_template_info`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/display_appliance_info/templateInfo'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayApplianceInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_template_recipient_document_visibility(self, account_id, recipient_id, template_id, **kwargs):
        """
        Returns document visibility for the recipients
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_recipient_document_visibility(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: DocumentVisibilityList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_template_recipient_document_visibility_with_http_info(account_id, recipient_id, template_id, **kwargs)
        else:
            (data) = self.get_template_recipient_document_visibility_with_http_info(account_id, recipient_id, template_id, **kwargs)
            return data

    def get_template_recipient_document_visibility_with_http_info(self, account_id, recipient_id, template_id, **kwargs):
        """
        Returns document visibility for the recipients
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_recipient_document_visibility_with_http_info(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: DocumentVisibilityList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'recipient_id', 'template_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_template_recipient_document_visibility" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_template_recipient_document_visibility`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `get_template_recipient_document_visibility`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_template_recipient_document_visibility`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentVisibilityList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_template_workflow_definition(self, account_id, template_id, **kwargs):
        """
        Returns the workflow definition for a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_workflow_definition(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_template_workflow_definition_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.get_template_workflow_definition_with_http_info(account_id, template_id, **kwargs)
            return data

    def get_template_workflow_definition_with_http_info(self, account_id, template_id, **kwargs):
        """
        Returns the workflow definition for a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_workflow_definition_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_template_workflow_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_template_workflow_definition`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_template_workflow_definition`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/workflow'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Workflow',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_audit_events(self, account_id, envelope_id, **kwargs):
        """
        Gets the envelope audit events for an envelope.
        Gets the envelope audit events for the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_audit_events(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: EnvelopeAuditEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_audit_events_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.list_audit_events_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def list_audit_events_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Gets the envelope audit events for an envelope.
        Gets the envelope audit events for the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_audit_events_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: EnvelopeAuditEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_audit_events" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_audit_events`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `list_audit_events`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/audit_events'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeAuditEventResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_custom_fields(self, account_id, envelope_id, **kwargs):
        """
        Gets the custom field information for the specified envelope.
        Retrieves the custom field information for the specified envelope. You can use these fields in the envelopes for your account to record information about the envelope, help search for envelopes, and track information. The envelope custom fields are shown in the Envelope Settings section when a user is creating an envelope in the DocuSign member console. The envelope custom fields are not seen by the envelope recipients.  There are two types of envelope custom fields, text, and list. A text custom field lets the sender enter the value for the field. With a list custom field, the sender selects the value of the field from a pre-made list.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_custom_fields(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: CustomFieldsEnvelope
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_custom_fields_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.list_custom_fields_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def list_custom_fields_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Gets the custom field information for the specified envelope.
        Retrieves the custom field information for the specified envelope. You can use these fields in the envelopes for your account to record information about the envelope, help search for envelopes, and track information. The envelope custom fields are shown in the Envelope Settings section when a user is creating an envelope in the DocuSign member console. The envelope custom fields are not seen by the envelope recipients.  There are two types of envelope custom fields, text, and list. A text custom field lets the sender enter the value for the field. With a list custom field, the sender selects the value of the field from a pre-made list.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_custom_fields_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: CustomFieldsEnvelope
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_custom_fields`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `list_custom_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CustomFieldsEnvelope',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_document_fields(self, account_id, document_id, envelope_id, **kwargs):
        """
        Gets the custom document fields from an  existing envelope document.
        Retrieves the custom document field information from an existing envelope document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_document_fields(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_document_fields_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.list_document_fields_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def list_document_fields_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Gets the custom document fields from an  existing envelope document.
        Retrieves the custom document field information from an existing envelope document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_document_fields_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_document_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_document_fields`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `list_document_fields`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `list_document_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentFieldsInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_documents(self, account_id, envelope_id, **kwargs):
        """
        Gets a list of envelope documents.
        Retrieves a list of documents associated with the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_documents(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str documents_by_userid:
        :param str include_document_size:
        :param str include_metadata:
        :param str include_tabs:
        :param str recipient_id:
        :param str shared_user_id:
        :return: EnvelopeDocumentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_documents_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.list_documents_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def list_documents_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Gets a list of envelope documents.
        Retrieves a list of documents associated with the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_documents_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str documents_by_userid:
        :param str include_document_size:
        :param str include_metadata:
        :param str include_tabs:
        :param str recipient_id:
        :param str shared_user_id:
        :return: EnvelopeDocumentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'documents_by_userid', 'include_document_size', 'include_metadata', 'include_tabs', 'recipient_id', 'shared_user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_documents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_documents`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `list_documents`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'documents_by_userid' in params:
            query_params['documents_by_userid'] = params['documents_by_userid']
        if 'include_document_size' in params:
            query_params['include_document_size'] = params['include_document_size']
        if 'include_metadata' in params:
            query_params['include_metadata'] = params['include_metadata']
        if 'include_tabs' in params:
            query_params['include_tabs'] = params['include_tabs']
        if 'recipient_id' in params:
            query_params['recipient_id'] = params['recipient_id']
        if 'shared_user_id' in params:
            query_params['shared_user_id'] = params['shared_user_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeDocumentsResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_recipients(self, account_id, envelope_id, **kwargs):
        """
        Gets the status of recipients for an envelope.
        Retrieves the status of all recipients in a single envelope and identifies the current recipient in the routing list.   The `currentRoutingOrder` property of the response contains the `routingOrder` value of the current recipient indicating that the envelope has been sent to the recipient, but the recipient has not completed their actions.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_recipients(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str include_anchor_tab_locations:  When set to **true** and `include_tabs` is set to **true**, all tabs with anchor tab properties are included in the response. 
        :param str include_extended:  When set to **true**, the extended properties are included in the response. 
        :param str include_metadata:
        :param str include_tabs: When set to **true**, the tab information associated with the recipient is included in the response.
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_recipients_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.list_recipients_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def list_recipients_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Gets the status of recipients for an envelope.
        Retrieves the status of all recipients in a single envelope and identifies the current recipient in the routing list.   The `currentRoutingOrder` property of the response contains the `routingOrder` value of the current recipient indicating that the envelope has been sent to the recipient, but the recipient has not completed their actions.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_recipients_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str include_anchor_tab_locations:  When set to **true** and `include_tabs` is set to **true**, all tabs with anchor tab properties are included in the response. 
        :param str include_extended:  When set to **true**, the extended properties are included in the response. 
        :param str include_metadata:
        :param str include_tabs: When set to **true**, the tab information associated with the recipient is included in the response.
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'include_anchor_tab_locations', 'include_extended', 'include_metadata', 'include_tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_recipients" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_recipients`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `list_recipients`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'include_anchor_tab_locations' in params:
            query_params['include_anchor_tab_locations'] = params['include_anchor_tab_locations']
        if 'include_extended' in params:
            query_params['include_extended'] = params['include_extended']
        if 'include_metadata' in params:
            query_params['include_metadata'] = params['include_metadata']
        if 'include_tabs' in params:
            query_params['include_tabs'] = params['include_tabs']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Recipients',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_status(self, account_id, **kwargs):
        """
        Gets the envelope status for the specified envelopes.
        Retrieves the envelope status for the specified envelopes.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_status(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str ac_status:
        :param str block:
        :param str count:
        :param str email:
        :param str envelope_ids:
        :param str from_date:
        :param str from_to_status:
        :param str start_position:
        :param str status:
        :param str to_date:
        :param str transaction_ids:
        :param str user_name:
        :param EnvelopeIdsRequest envelope_ids_request:
        :return: EnvelopesInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_status_with_http_info(account_id, **kwargs)
        else:
            (data) = self.list_status_with_http_info(account_id, **kwargs)
            return data

    def list_status_with_http_info(self, account_id, **kwargs):
        """
        Gets the envelope status for the specified envelopes.
        Retrieves the envelope status for the specified envelopes.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_status_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str ac_status:
        :param str block:
        :param str count:
        :param str email:
        :param str envelope_ids:
        :param str from_date:
        :param str from_to_status:
        :param str start_position:
        :param str status:
        :param str to_date:
        :param str transaction_ids:
        :param str user_name:
        :param EnvelopeIdsRequest envelope_ids_request:
        :return: EnvelopesInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'ac_status', 'block', 'count', 'email', 'envelope_ids', 'from_date', 'from_to_status', 'start_position', 'status', 'to_date', 'transaction_ids', 'user_name', 'envelope_ids_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_status`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/status'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'ac_status' in params:
            query_params['ac_status'] = params['ac_status']
        if 'block' in params:
            query_params['block'] = params['block']
        if 'count' in params:
            query_params['count'] = params['count']
        if 'email' in params:
            query_params['email'] = params['email']
        if 'envelope_ids' in params:
            query_params['envelope_ids'] = params['envelope_ids']
        if 'from_date' in params:
            query_params['from_date'] = params['from_date']
        if 'from_to_status' in params:
            query_params['from_to_status'] = params['from_to_status']
        if 'start_position' in params:
            query_params['start_position'] = params['start_position']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'to_date' in params:
            query_params['to_date'] = params['to_date']
        if 'transaction_ids' in params:
            query_params['transaction_ids'] = params['transaction_ids']
        if 'user_name' in params:
            query_params['user_name'] = params['user_name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_ids_request' in params:
            body_params = params['envelope_ids_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopesInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_status_changes(self, account_id, **kwargs):
        """
        Gets status changes for one or more envelopes.
        Retrieves envelope status changes for all envelopes. You can modify the information returned by adding query strings to limit the request to check between certain dates and times, or for certain envelopes, or for certain status codes. It is recommended that you use one or more of the query strings in order to limit the size of the response.  ### Important: Unless you are requesting the status for specific envelopes (using the `envelopeIds` or `transactionIds` properties), you must add a set the `from_date` property in the request.  Getting envelope status using `transactionIds` is useful for offline signing situations where it can be used determine if an envelope was created or not, for the cases where a network connection was lost, before the envelope status could be returned.  ### Request Envelope Status Notes ###  The REST API GET /envelopes call uses certain filters to find results. In some cases requests are check for \"any status change\" instead of the just the single status requested. In these cases, more envelopes might be returned by the request than otherwise would be. For example, for a request with the begin date is set to Jan 1st, an end date set to Jan 7th and the status qualifier (`from_to_status`) set to `Delivered` &mdash; the response set might contain envelopes that were created during that time period, but not delivered during the time period.  To avoid unnecessary database queries, the DocuSign system checks requests to ensure that the added filters will not result in a zero-size response before acting on the request. The following table shows the valid envelope statuses (in the Valid Current Statuses column) for the status qualifiers in the request. If the status and status qualifiers in the API request do not contain any of the values shown in the valid current statuses column, then an empty list is returned.  For example, a request with a status qualifier (from_to_status) of `Delivered` and a status of \"`Created`,`Sent`\", DocuSign will always return an empty list. This is because the request essentially translates to: find the envelopes that were delivered between the begin and end dates that have a current status of `Created` or `Sent`, and since an envelope that has been delivered can never have a status of `Created` or `Sent`, a zero-size response would be generated. In this case, DocuSign does not run the request, but just returns the empty list.  Client applications should check that the statuses they are requesting make sense for a given status qualifier.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_status_changes(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str ac_status: Specifies the Authoritative Copy Status for the envelopes. The possible values are: Unknown, Original, Transferred, AuthoritativeCopy, AuthoritativeCopyExportPending, AuthoritativeCopyExported, DepositPending, Deposited, DepositedEO, or DepositFailed.
        :param str block:
        :param str cdse_mode:
        :param str continuation_token:
        :param str count:
        :param str custom_field: This specifies the envelope custom field name and value searched for in the envelope information. The value portion of the query can use partial strings by adding '%' (percent sign) around the custom field query value.   Example 1: If you have an envelope custom field called \"Region\" and you want to search for all envelopes where the value is \"West\" you would use the query: `?custom_field=Region=West`.   Example 2: To search for envelopes where the `ApplicationID` custom field has the value or partial value of \"DocuSign\" in field, the query would be: `?custom_field=ApplicationId=%DocuSign%` This would find envelopes where the custom field value is \"DocuSign for Salesforce\" or \"DocuSign envelope.\"  
        :param str email:
        :param str envelope_ids:
        :param str exclude:
        :param str folder_ids:
        :param str folder_types:
        :param str from_date: The date/time setting that specifies the date/time when the request begins checking for status changes for envelopes in the account.  This is required unless 'envelopeId's are used.
        :param str from_to_status: This is the status type checked for in the `from_date`/`to_date` period. If `changed` is specified, then envelopes that changed status during the period are found. If for example, `created` is specified, then envelopes created during the period are found. Default is `changed`.   Possible values are: Voided, Changed, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut and Processing.
        :param str include:
        :param str include_purge_information:
        :param str intersecting_folder_ids:
        :param str last_queried_date:
        :param str order:
        :param str order_by:
        :param str powerformids:
        :param str query_budget:
        :param str requester_date_format:
        :param str search_text:
        :param str start_position:
        :param str status: The list of current statuses to include in the response. By default, all envelopes found are returned. If values are specified, then of the envelopes found, only those with the current status specified are returned in the results.   Possible values are: Voided, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut and Processing.
        :param str to_date: Optional date/time setting that specifies the date/time when the request stops for status changes for envelopes in the account. If no entry, the system uses the time of the call as the `to_date`. 
        :param str transaction_ids: If included in the query string, this is a comma separated list of envelope `transactionId`s.   If included in the `request_body`, this is a list of envelope `transactionId`s.   ###### Note: `transactionId`s are only valid in the DocuSign system for seven days. 
        :param str user_filter:
        :param str user_id:
        :param str user_name:
        :return: EnvelopesInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_status_changes_with_http_info(account_id, **kwargs)
        else:
            (data) = self.list_status_changes_with_http_info(account_id, **kwargs)
            return data

    def list_status_changes_with_http_info(self, account_id, **kwargs):
        """
        Gets status changes for one or more envelopes.
        Retrieves envelope status changes for all envelopes. You can modify the information returned by adding query strings to limit the request to check between certain dates and times, or for certain envelopes, or for certain status codes. It is recommended that you use one or more of the query strings in order to limit the size of the response.  ### Important: Unless you are requesting the status for specific envelopes (using the `envelopeIds` or `transactionIds` properties), you must add a set the `from_date` property in the request.  Getting envelope status using `transactionIds` is useful for offline signing situations where it can be used determine if an envelope was created or not, for the cases where a network connection was lost, before the envelope status could be returned.  ### Request Envelope Status Notes ###  The REST API GET /envelopes call uses certain filters to find results. In some cases requests are check for \"any status change\" instead of the just the single status requested. In these cases, more envelopes might be returned by the request than otherwise would be. For example, for a request with the begin date is set to Jan 1st, an end date set to Jan 7th and the status qualifier (`from_to_status`) set to `Delivered` &mdash; the response set might contain envelopes that were created during that time period, but not delivered during the time period.  To avoid unnecessary database queries, the DocuSign system checks requests to ensure that the added filters will not result in a zero-size response before acting on the request. The following table shows the valid envelope statuses (in the Valid Current Statuses column) for the status qualifiers in the request. If the status and status qualifiers in the API request do not contain any of the values shown in the valid current statuses column, then an empty list is returned.  For example, a request with a status qualifier (from_to_status) of `Delivered` and a status of \"`Created`,`Sent`\", DocuSign will always return an empty list. This is because the request essentially translates to: find the envelopes that were delivered between the begin and end dates that have a current status of `Created` or `Sent`, and since an envelope that has been delivered can never have a status of `Created` or `Sent`, a zero-size response would be generated. In this case, DocuSign does not run the request, but just returns the empty list.  Client applications should check that the statuses they are requesting make sense for a given status qualifier.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_status_changes_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str ac_status: Specifies the Authoritative Copy Status for the envelopes. The possible values are: Unknown, Original, Transferred, AuthoritativeCopy, AuthoritativeCopyExportPending, AuthoritativeCopyExported, DepositPending, Deposited, DepositedEO, or DepositFailed.
        :param str block:
        :param str cdse_mode:
        :param str continuation_token:
        :param str count:
        :param str custom_field: This specifies the envelope custom field name and value searched for in the envelope information. The value portion of the query can use partial strings by adding '%' (percent sign) around the custom field query value.   Example 1: If you have an envelope custom field called \"Region\" and you want to search for all envelopes where the value is \"West\" you would use the query: `?custom_field=Region=West`.   Example 2: To search for envelopes where the `ApplicationID` custom field has the value or partial value of \"DocuSign\" in field, the query would be: `?custom_field=ApplicationId=%DocuSign%` This would find envelopes where the custom field value is \"DocuSign for Salesforce\" or \"DocuSign envelope.\"  
        :param str email:
        :param str envelope_ids:
        :param str exclude:
        :param str folder_ids:
        :param str folder_types:
        :param str from_date: The date/time setting that specifies the date/time when the request begins checking for status changes for envelopes in the account.  This is required unless 'envelopeId's are used.
        :param str from_to_status: This is the status type checked for in the `from_date`/`to_date` period. If `changed` is specified, then envelopes that changed status during the period are found. If for example, `created` is specified, then envelopes created during the period are found. Default is `changed`.   Possible values are: Voided, Changed, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut and Processing.
        :param str include:
        :param str include_purge_information:
        :param str intersecting_folder_ids:
        :param str last_queried_date:
        :param str order:
        :param str order_by:
        :param str powerformids:
        :param str query_budget:
        :param str requester_date_format:
        :param str search_text:
        :param str start_position:
        :param str status: The list of current statuses to include in the response. By default, all envelopes found are returned. If values are specified, then of the envelopes found, only those with the current status specified are returned in the results.   Possible values are: Voided, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut and Processing.
        :param str to_date: Optional date/time setting that specifies the date/time when the request stops for status changes for envelopes in the account. If no entry, the system uses the time of the call as the `to_date`. 
        :param str transaction_ids: If included in the query string, this is a comma separated list of envelope `transactionId`s.   If included in the `request_body`, this is a list of envelope `transactionId`s.   ###### Note: `transactionId`s are only valid in the DocuSign system for seven days. 
        :param str user_filter:
        :param str user_id:
        :param str user_name:
        :return: EnvelopesInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'ac_status', 'block', 'cdse_mode', 'continuation_token', 'count', 'custom_field', 'email', 'envelope_ids', 'exclude', 'folder_ids', 'folder_types', 'from_date', 'from_to_status', 'include', 'include_purge_information', 'intersecting_folder_ids', 'last_queried_date', 'order', 'order_by', 'powerformids', 'query_budget', 'requester_date_format', 'search_text', 'start_position', 'status', 'to_date', 'transaction_ids', 'user_filter', 'user_id', 'user_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_status_changes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_status_changes`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'ac_status' in params:
            query_params['ac_status'] = params['ac_status']
        if 'block' in params:
            query_params['block'] = params['block']
        if 'cdse_mode' in params:
            query_params['cdse_mode'] = params['cdse_mode']
        if 'continuation_token' in params:
            query_params['continuation_token'] = params['continuation_token']
        if 'count' in params:
            query_params['count'] = params['count']
        if 'custom_field' in params:
            query_params['custom_field'] = params['custom_field']
        if 'email' in params:
            query_params['email'] = params['email']
        if 'envelope_ids' in params:
            query_params['envelope_ids'] = params['envelope_ids']
        if 'exclude' in params:
            query_params['exclude'] = params['exclude']
        if 'folder_ids' in params:
            query_params['folder_ids'] = params['folder_ids']
        if 'folder_types' in params:
            query_params['folder_types'] = params['folder_types']
        if 'from_date' in params:
            query_params['from_date'] = params['from_date']
        if 'from_to_status' in params:
            query_params['from_to_status'] = params['from_to_status']
        if 'include' in params:
            query_params['include'] = params['include']
        if 'include_purge_information' in params:
            query_params['include_purge_information'] = params['include_purge_information']
        if 'intersecting_folder_ids' in params:
            query_params['intersecting_folder_ids'] = params['intersecting_folder_ids']
        if 'last_queried_date' in params:
            query_params['last_queried_date'] = params['last_queried_date']
        if 'order' in params:
            query_params['order'] = params['order']
        if 'order_by' in params:
            query_params['order_by'] = params['order_by']
        if 'powerformids' in params:
            query_params['powerformids'] = params['powerformids']
        if 'query_budget' in params:
            query_params['query_budget'] = params['query_budget']
        if 'requester_date_format' in params:
            query_params['requester_date_format'] = params['requester_date_format']
        if 'search_text' in params:
            query_params['search_text'] = params['search_text']
        if 'start_position' in params:
            query_params['start_position'] = params['start_position']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'to_date' in params:
            query_params['to_date'] = params['to_date']
        if 'transaction_ids' in params:
            query_params['transaction_ids'] = params['transaction_ids']
        if 'user_filter' in params:
            query_params['user_filter'] = params['user_filter']
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']
        if 'user_name' in params:
            query_params['user_name'] = params['user_name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopesInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_tabs(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Gets the tabs information for a signer or sign-in-person recipient in an envelope.
        Retrieves information about the tabs associated with a recipient in a draft envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_tabs(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str include_anchor_tab_locations: When set to **true**, all tabs with anchor tab properties are included in the response. 
        :param str include_metadata:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_tabs_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.list_tabs_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def list_tabs_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Gets the tabs information for a signer or sign-in-person recipient in an envelope.
        Retrieves information about the tabs associated with a recipient in a draft envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_tabs_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str include_anchor_tab_locations: When set to **true**, all tabs with anchor tab properties are included in the response. 
        :param str include_metadata:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id', 'include_anchor_tab_locations', 'include_metadata']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_tabs`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `list_tabs`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `list_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}
        if 'include_anchor_tab_locations' in params:
            query_params['include_anchor_tab_locations'] = params['include_anchor_tab_locations']
        if 'include_metadata' in params:
            query_params['include_metadata'] = params['include_metadata']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_templates(self, account_id, envelope_id, **kwargs):
        """
        Get List of Templates used in an Envelope
        This returns a list of the server-side templates, their name and ID, used in an envelope. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_templates(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str include: The possible values are:  matching_applied - This returns template matching information for the template.
        :return: TemplateInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_templates_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.list_templates_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def list_templates_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Get List of Templates used in an Envelope
        This returns a list of the server-side templates, their name and ID, used in an envelope. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_templates_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str include: The possible values are:  matching_applied - This returns template matching information for the template.
        :return: TemplateInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_templates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_templates`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `list_templates`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/templates'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TemplateInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_templates_for_document(self, account_id, document_id, envelope_id, **kwargs):
        """
        Gets the templates associated with a document in an existing envelope.
        Retrieves the templates associated with a document in the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_templates_for_document(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str include:
        :return: TemplateInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_templates_for_document_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.list_templates_for_document_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def list_templates_for_document_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Gets the templates associated with a document in an existing envelope.
        Retrieves the templates associated with a document in the specified envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_templates_for_document_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str include:
        :return: TemplateInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_templates_for_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_templates_for_document`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `list_templates_for_document`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `list_templates_for_document`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TemplateInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def put_attachment(self, account_id, attachment_id, envelope_id, **kwargs):
        """
        Add an attachment to a DRAFT or IN-PROCESS envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_attachment(account_id, attachment_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str attachment_id: (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param Attachment attachment:
        :return: EnvelopeAttachmentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.put_attachment_with_http_info(account_id, attachment_id, envelope_id, **kwargs)
        else:
            (data) = self.put_attachment_with_http_info(account_id, attachment_id, envelope_id, **kwargs)
            return data

    def put_attachment_with_http_info(self, account_id, attachment_id, envelope_id, **kwargs):
        """
        Add an attachment to a DRAFT or IN-PROCESS envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_attachment_with_http_info(account_id, attachment_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str attachment_id: (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param Attachment attachment:
        :return: EnvelopeAttachmentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'attachment_id', 'envelope_id', 'attachment']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_attachment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `put_attachment`")
        # verify the required parameter 'attachment_id' is set
        if ('attachment_id' not in params) or (params['attachment_id'] is None):
            raise ValueError("Missing the required parameter `attachment_id` when calling `put_attachment`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `put_attachment`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'attachment_id' in params:
            path_params['attachmentId'] = params['attachment_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'attachment' in params:
            body_params = params['attachment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeAttachmentsResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def put_attachments(self, account_id, envelope_id, **kwargs):
        """
        Add one or more attachments to a DRAFT or IN-PROCESS envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_attachments(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EnvelopeAttachmentsRequest envelope_attachments_request:
        :return: EnvelopeAttachmentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.put_attachments_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.put_attachments_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def put_attachments_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Add one or more attachments to a DRAFT or IN-PROCESS envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_attachments_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EnvelopeAttachmentsRequest envelope_attachments_request:
        :return: EnvelopeAttachmentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'envelope_attachments_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_attachments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `put_attachments`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `put_attachments`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_attachments_request' in params:
            body_params = params['envelope_attachments_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeAttachmentsResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def rotate_document_page(self, account_id, document_id, envelope_id, page_number, **kwargs):
        """
        Rotates page image from an envelope for display.
        Rotates page image from an envelope for display. The page image can be rotated to the left or right.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rotate_document_page(account_id, document_id, envelope_id, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :param PageRequest page_request:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.rotate_document_page_with_http_info(account_id, document_id, envelope_id, page_number, **kwargs)
        else:
            (data) = self.rotate_document_page_with_http_info(account_id, document_id, envelope_id, page_number, **kwargs)
            return data

    def rotate_document_page_with_http_info(self, account_id, document_id, envelope_id, page_number, **kwargs):
        """
        Rotates page image from an envelope for display.
        Rotates page image from an envelope for display. The page image can be rotated to the left or right.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rotate_document_page_with_http_info(account_id, document_id, envelope_id, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :param PageRequest page_request:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'page_number', 'page_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rotate_document_page" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `rotate_document_page`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `rotate_document_page`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `rotate_document_page`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `rotate_document_page`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'page_request' in params:
            body_params = params['page_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update(self, account_id, envelope_id, **kwargs):
        """
        Send Draft Envelope/Void Envelope/Move/Purge Envelope/Modify draft
        The Put Envelopes endpoint provides the following functionality:  * Sends the specified single draft envelope. Add {\"status\":\"sent\"} to the request body to send the envelope.  * Voids the specified in-process envelope. Add {\"status\":\"voided\", \"voidedReason\":\"The reason for voiding the envelope\"} to the request body to void the envelope.  * Replaces the current email subject and message for a draft envelope. Add {\"emailSubject\":\"subject\",  \"emailBlurb\":\"message\"}  to the request body to modify the subject and message.  * Place the envelope documents and envelope metadata in a purge queue so that this information is removed from the DocuSign system. Add {\"purgeState\":\"purge type\"} to the request body.  *Additional information on purging documents*  The purge request can only be used for completed envelopes that are not marked as the authoritative copy. The requesting user must have permission to purge documents and must be the sender (the requesting user can act as the sender using Send On Behalf Of).  ###### Note: If you have set the Document Retention policy on your account, envelope documents are automatically placed in the purge queue and the warning emails are sent at the end of the retention period.  ###### Note: You can set the Document Retention policy in the Classic DocuSign Experience by specifying the number of days to retain documents.  ###### Note: Setting a Document Retention policy is the same as setting a schedule for purging documents.  When the purge request is initiated the envelope documents, or documents and envelope metadata, are placed in a purge queue for deletion in 14 days. A warning email notification is sent to the sender and recipients associated with the envelope, notifying them that the envelope documents will be deleted in 14 days and providing a link to the documents. A second email is sent 7 days later with the same message. At the end of the 14-day period, the envelope documents are deleted from the system.  If `purgeState=\"documents_queued\"` is used in the request, then only the documents are deleted and any corresponding attachments and tabs remain in the DocuSign system. If `purgeState= \"documents_and_metadata_queued\"` is used in the request, then the documents, attachments, and tabs are deleted.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str advanced_update: When set to **true**, allows the caller to update recipients, tabs, custom fields, notification, email settings and other envelope attributes.
        :param str resend_envelope: When set to **true**, sends the specified envelope again.
        :param Envelope envelope:
        :return: EnvelopeUpdateSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Send Draft Envelope/Void Envelope/Move/Purge Envelope/Modify draft
        The Put Envelopes endpoint provides the following functionality:  * Sends the specified single draft envelope. Add {\"status\":\"sent\"} to the request body to send the envelope.  * Voids the specified in-process envelope. Add {\"status\":\"voided\", \"voidedReason\":\"The reason for voiding the envelope\"} to the request body to void the envelope.  * Replaces the current email subject and message for a draft envelope. Add {\"emailSubject\":\"subject\",  \"emailBlurb\":\"message\"}  to the request body to modify the subject and message.  * Place the envelope documents and envelope metadata in a purge queue so that this information is removed from the DocuSign system. Add {\"purgeState\":\"purge type\"} to the request body.  *Additional information on purging documents*  The purge request can only be used for completed envelopes that are not marked as the authoritative copy. The requesting user must have permission to purge documents and must be the sender (the requesting user can act as the sender using Send On Behalf Of).  ###### Note: If you have set the Document Retention policy on your account, envelope documents are automatically placed in the purge queue and the warning emails are sent at the end of the retention period.  ###### Note: You can set the Document Retention policy in the Classic DocuSign Experience by specifying the number of days to retain documents.  ###### Note: Setting a Document Retention policy is the same as setting a schedule for purging documents.  When the purge request is initiated the envelope documents, or documents and envelope metadata, are placed in a purge queue for deletion in 14 days. A warning email notification is sent to the sender and recipients associated with the envelope, notifying them that the envelope documents will be deleted in 14 days and providing a link to the documents. A second email is sent 7 days later with the same message. At the end of the 14-day period, the envelope documents are deleted from the system.  If `purgeState=\"documents_queued\"` is used in the request, then only the documents are deleted and any corresponding attachments and tabs remain in the DocuSign system. If `purgeState= \"documents_and_metadata_queued\"` is used in the request, then the documents, attachments, and tabs are deleted.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str advanced_update: When set to **true**, allows the caller to update recipients, tabs, custom fields, notification, email settings and other envelope attributes.
        :param str resend_envelope: When set to **true**, sends the specified envelope again.
        :param Envelope envelope:
        :return: EnvelopeUpdateSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'advanced_update', 'resend_envelope', 'envelope']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'advanced_update' in params:
            query_params['advanced_update'] = params['advanced_update']
        if 'resend_envelope' in params:
            query_params['resend_envelope'] = params['resend_envelope']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope' in params:
            body_params = params['envelope']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeUpdateSummary',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_chunked_upload(self, account_id, chunked_upload_id, **kwargs):
        """
        Integrity-Check and Commit a ChunkedUpload, readying it for use elsewhere.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_chunked_upload(account_id, chunked_upload_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str chunked_upload_id: (required)
        :param str action:
        :return: ChunkedUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_chunked_upload_with_http_info(account_id, chunked_upload_id, **kwargs)
        else:
            (data) = self.update_chunked_upload_with_http_info(account_id, chunked_upload_id, **kwargs)
            return data

    def update_chunked_upload_with_http_info(self, account_id, chunked_upload_id, **kwargs):
        """
        Integrity-Check and Commit a ChunkedUpload, readying it for use elsewhere.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_chunked_upload_with_http_info(account_id, chunked_upload_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str chunked_upload_id: (required)
        :param str action:
        :return: ChunkedUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'chunked_upload_id', 'action']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_chunked_upload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_chunked_upload`")
        # verify the required parameter 'chunked_upload_id' is set
        if ('chunked_upload_id' not in params) or (params['chunked_upload_id'] is None):
            raise ValueError("Missing the required parameter `chunked_upload_id` when calling `update_chunked_upload`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'chunked_upload_id' in params:
            path_params['chunkedUploadId'] = params['chunked_upload_id']

        query_params = {}
        if 'action' in params:
            query_params['action'] = params['action']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ChunkedUploadResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_chunked_upload_part(self, account_id, chunked_upload_id, chunked_upload_part_seq, **kwargs):
        """
        Add a chunk, a chunk 'part', to an existing ChunkedUpload.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_chunked_upload_part(account_id, chunked_upload_id, chunked_upload_part_seq, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str chunked_upload_id: (required)
        :param str chunked_upload_part_seq: (required)
        :param ChunkedUploadRequest chunked_upload_request:
        :return: ChunkedUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_chunked_upload_part_with_http_info(account_id, chunked_upload_id, chunked_upload_part_seq, **kwargs)
        else:
            (data) = self.update_chunked_upload_part_with_http_info(account_id, chunked_upload_id, chunked_upload_part_seq, **kwargs)
            return data

    def update_chunked_upload_part_with_http_info(self, account_id, chunked_upload_id, chunked_upload_part_seq, **kwargs):
        """
        Add a chunk, a chunk 'part', to an existing ChunkedUpload.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_chunked_upload_part_with_http_info(account_id, chunked_upload_id, chunked_upload_part_seq, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str chunked_upload_id: (required)
        :param str chunked_upload_part_seq: (required)
        :param ChunkedUploadRequest chunked_upload_request:
        :return: ChunkedUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'chunked_upload_id', 'chunked_upload_part_seq', 'chunked_upload_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_chunked_upload_part" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_chunked_upload_part`")
        # verify the required parameter 'chunked_upload_id' is set
        if ('chunked_upload_id' not in params) or (params['chunked_upload_id'] is None):
            raise ValueError("Missing the required parameter `chunked_upload_id` when calling `update_chunked_upload_part`")
        # verify the required parameter 'chunked_upload_part_seq' is set
        if ('chunked_upload_part_seq' not in params) or (params['chunked_upload_part_seq'] is None):
            raise ValueError("Missing the required parameter `chunked_upload_part_seq` when calling `update_chunked_upload_part`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}/{chunkedUploadPartSeq}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'chunked_upload_id' in params:
            path_params['chunkedUploadId'] = params['chunked_upload_id']
        if 'chunked_upload_part_seq' in params:
            path_params['chunkedUploadPartSeq'] = params['chunked_upload_part_seq']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'chunked_upload_request' in params:
            body_params = params['chunked_upload_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ChunkedUploadResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_custom_fields(self, account_id, envelope_id, **kwargs):
        """
        Updates envelope custom fields in an envelope.
        Updates the envelope custom fields in draft and in-process envelopes.  Each custom field used in an envelope must have a unique name. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_custom_fields(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param CustomFields custom_fields:
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_custom_fields_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_custom_fields_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_custom_fields_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Updates envelope custom fields in an envelope.
        Updates the envelope custom fields in draft and in-process envelopes.  Each custom field used in an envelope must have a unique name. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_custom_fields_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param CustomFields custom_fields:
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'custom_fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_custom_fields`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_custom_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'custom_fields' in params:
            body_params = params['custom_fields']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CustomFields',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_document(self, account_id, document_id, envelope_id, **kwargs):
        """
        Update document information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_document(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_document_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.update_document_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def update_document_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Update document information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_document_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_document`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `update_document`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_document`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/document/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_document_0(self, account_id, document_id, envelope_id, **kwargs):
        """
        Adds a document to an existing draft envelope.
        Adds a document to an existing draft envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_document_0(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: EnvelopeDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_document_0_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.update_document_0_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def update_document_0_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Adds a document to an existing draft envelope.
        Adds a document to an existing draft envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_document_0_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: EnvelopeDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_document_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_document_0`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `update_document_0`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_document_0`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeDocument',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_document_fields(self, account_id, document_id, envelope_id, **kwargs):
        """
        Updates existing custom document fields in an existing envelope document.
        Updates existing custom document fields in an existing envelope document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_document_fields(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param DocumentFieldsInformation document_fields_information:
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_document_fields_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.update_document_fields_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def update_document_fields_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Updates existing custom document fields in an existing envelope document.
        Updates existing custom document fields in an existing envelope document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_document_fields_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param DocumentFieldsInformation document_fields_information:
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'document_fields_information']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_document_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_document_fields`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `update_document_fields`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_document_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_fields_information' in params:
            body_params = params['document_fields_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentFieldsInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_document_tabs(self, account_id, document_id, envelope_id, **kwargs):
        """
        Updates the tabs for an envelope document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_document_tabs(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param Tabs tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_document_tabs_with_http_info(account_id, document_id, envelope_id, **kwargs)
        else:
            (data) = self.update_document_tabs_with_http_info(account_id, document_id, envelope_id, **kwargs)
            return data

    def update_document_tabs_with_http_info(self, account_id, document_id, envelope_id, **kwargs):
        """
        Updates the tabs for an envelope document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_document_tabs_with_http_info(account_id, document_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param Tabs tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'envelope_id', 'tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_document_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_document_tabs`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `update_document_tabs`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_document_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tabs' in params:
            body_params = params['tabs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_documents(self, account_id, envelope_id, **kwargs):
        """
        Adds one or more documents to an existing envelope document.
        Adds one or more documents to an existing envelope document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_documents(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EnvelopeDefinition envelope_definition:
        :return: EnvelopeDocumentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_documents_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_documents_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_documents_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Adds one or more documents to an existing envelope document.
        Adds one or more documents to an existing envelope document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_documents_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EnvelopeDefinition envelope_definition:
        :return: EnvelopeDocumentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'envelope_definition']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_documents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_documents`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_documents`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_definition' in params:
            body_params = params['envelope_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeDocumentsResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_email_settings(self, account_id, envelope_id, **kwargs):
        """
        Updates the email setting overrides for an envelope.
        Updates the existing email override settings for the specified envelope. Note that modifying email settings will only affect email communications that occur after the modification was made.  This can also be used to delete an individual email override setting by using an empty string for the value to be deleted.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_email_settings(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EmailSettings email_settings:
        :return: EmailSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_email_settings_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_email_settings_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_email_settings_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Updates the email setting overrides for an envelope.
        Updates the existing email override settings for the specified envelope. Note that modifying email settings will only affect email communications that occur after the modification was made.  This can also be used to delete an individual email override setting by using an empty string for the value to be deleted.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_email_settings_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EmailSettings email_settings:
        :return: EmailSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'email_settings']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_email_settings`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_email_settings`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_settings' in params:
            body_params = params['email_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EmailSettings',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_envelope_transfer_rule(self, account_id, envelope_transfer_rule_id, **kwargs):
        """
        Update an envelope transfer rule for an account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_envelope_transfer_rule(account_id, envelope_transfer_rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_transfer_rule_id: (required)
        :param EnvelopeTransferRule envelope_transfer_rule:
        :return: EnvelopeTransferRule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_envelope_transfer_rule_with_http_info(account_id, envelope_transfer_rule_id, **kwargs)
        else:
            (data) = self.update_envelope_transfer_rule_with_http_info(account_id, envelope_transfer_rule_id, **kwargs)
            return data

    def update_envelope_transfer_rule_with_http_info(self, account_id, envelope_transfer_rule_id, **kwargs):
        """
        Update an envelope transfer rule for an account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_envelope_transfer_rule_with_http_info(account_id, envelope_transfer_rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_transfer_rule_id: (required)
        :param EnvelopeTransferRule envelope_transfer_rule:
        :return: EnvelopeTransferRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_transfer_rule_id', 'envelope_transfer_rule']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_envelope_transfer_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_envelope_transfer_rule`")
        # verify the required parameter 'envelope_transfer_rule_id' is set
        if ('envelope_transfer_rule_id' not in params) or (params['envelope_transfer_rule_id'] is None):
            raise ValueError("Missing the required parameter `envelope_transfer_rule_id` when calling `update_envelope_transfer_rule`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/transfer_rules/{envelopeTransferRuleId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_transfer_rule_id' in params:
            path_params['envelopeTransferRuleId'] = params['envelope_transfer_rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_transfer_rule' in params:
            body_params = params['envelope_transfer_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeTransferRule',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_envelope_transfer_rules(self, account_id, **kwargs):
        """
        Update envelope transfer rules for an account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_envelope_transfer_rules(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param EnvelopeTransferRuleInformation envelope_transfer_rule_information:
        :return: EnvelopeTransferRuleInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_envelope_transfer_rules_with_http_info(account_id, **kwargs)
        else:
            (data) = self.update_envelope_transfer_rules_with_http_info(account_id, **kwargs)
            return data

    def update_envelope_transfer_rules_with_http_info(self, account_id, **kwargs):
        """
        Update envelope transfer rules for an account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_envelope_transfer_rules_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param EnvelopeTransferRuleInformation envelope_transfer_rule_information:
        :return: EnvelopeTransferRuleInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_transfer_rule_information']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_envelope_transfer_rules" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_envelope_transfer_rules`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/transfer_rules'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_transfer_rule_information' in params:
            body_params = params['envelope_transfer_rule_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeTransferRuleInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_envelope_workflow_definition(self, account_id, envelope_id, **kwargs):
        """
        Updates the envelope workflow definition for an envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_envelope_workflow_definition(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param Workflow workflow:
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_envelope_workflow_definition_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_envelope_workflow_definition_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_envelope_workflow_definition_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Updates the envelope workflow definition for an envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_envelope_workflow_definition_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param Workflow workflow:
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'workflow']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_envelope_workflow_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_envelope_workflow_definition`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_envelope_workflow_definition`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'workflow' in params:
            body_params = params['workflow']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Workflow',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_lock(self, account_id, envelope_id, **kwargs):
        """
        Updates an envelope lock.
        Updates the lock duration time or update the `lockedByApp` property information for the specified envelope. The user and integrator key must match the user specified by the `lockByUser` property and integrator key information and the `X-DocuSign-Edit` header must be included or an error will be generated.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_lock(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param LockRequest lock_request:
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_lock_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_lock_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_lock_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Updates an envelope lock.
        Updates the lock duration time or update the `lockedByApp` property information for the specified envelope. The user and integrator key must match the user specified by the `lockByUser` property and integrator key information and the `X-DocuSign-Edit` header must be included or an error will be generated.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_lock_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param LockRequest lock_request:
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'lock_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_lock" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_lock`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_lock`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'lock_request' in params:
            body_params = params['lock_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LockInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_notification_settings(self, account_id, envelope_id, **kwargs):
        """
        Sets envelope notification (Reminders/Expirations) structure for an existing envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_notification_settings(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EnvelopeNotificationRequest envelope_notification_request:
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_notification_settings_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_notification_settings_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_notification_settings_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Sets envelope notification (Reminders/Expirations) structure for an existing envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_notification_settings_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param EnvelopeNotificationRequest envelope_notification_request:
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'envelope_notification_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_notification_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_notification_settings`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_notification_settings`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/notification'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_notification_request' in params:
            body_params = params['envelope_notification_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Notification',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_page_info(self, account_id, envelope_id, **kwargs):
        """
        Update page information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_page_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_page_info_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_page_info_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_page_info_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Update page information for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_page_info_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_page_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_page_info`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_page_info`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/page_info'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_pdf(self, account_id, envelope_id, **kwargs):
        """
        Set latest pdf for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_pdf(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayAppliancePdf
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_pdf_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_pdf_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_pdf_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Set latest pdf for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_pdf_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: DisplayAppliancePdf
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_pdf`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_pdf`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/pdf'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayAppliancePdf',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_pdf_blob(self, account_id, envelope_id, **kwargs):
        """
        Update pdf blobs for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_pdf_blob(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_pdf_blob_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_pdf_blob_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_pdf_blob_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Update pdf blobs for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_pdf_blob_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_pdf_blob" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_pdf_blob`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_pdf_blob`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/pdf_blobs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_recipient_denied_document_copy(self, account_id, envelope_id, **kwargs):
        """
        Update RecipientDeniedDocumentCopy for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipient_denied_document_copy(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_recipient_denied_document_copy_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_recipient_denied_document_copy_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_recipient_denied_document_copy_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Update RecipientDeniedDocumentCopy for Display Appliance
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipient_denied_document_copy_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_recipient_denied_document_copy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_recipient_denied_document_copy`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_recipient_denied_document_copy`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/display_appliance_info/recipient_denied_copy'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_recipient_document_visibility(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Updates document visibility for the recipients
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipient_document_visibility(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param DocumentVisibilityList document_visibility_list:
        :return: DocumentVisibilityList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_recipient_document_visibility_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.update_recipient_document_visibility_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def update_recipient_document_visibility_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Updates document visibility for the recipients
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipient_document_visibility_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param DocumentVisibilityList document_visibility_list:
        :return: DocumentVisibilityList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id', 'document_visibility_list']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_recipient_document_visibility" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_recipient_document_visibility`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_recipient_document_visibility`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `update_recipient_document_visibility`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_visibility_list' in params:
            body_params = params['document_visibility_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentVisibilityList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_recipient_initials_image(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Sets the initials image for an accountless signer.
        Updates the initials image for a signer that does not have a DocuSign account. The supported image formats for this file are: gif, png, jpeg, and bmp. The file size must be less than 200K.  For the Authentication/Authorization for this call, the credentials must match the sender of the envelope, the recipient must be an accountless signer or in person signer. The account must have the `CanSendEnvelope` property set to **true** and the `ExpressSendOnly` property in `SendingUser` structure must be set to **false**.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipient_initials_image(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_recipient_initials_image_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.update_recipient_initials_image_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def update_recipient_initials_image_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Sets the initials image for an accountless signer.
        Updates the initials image for a signer that does not have a DocuSign account. The supported image formats for this file are: gif, png, jpeg, and bmp. The file size must be less than 200K.  For the Authentication/Authorization for this call, the credentials must match the sender of the envelope, the recipient must be an accountless signer or in person signer. The account must have the `CanSendEnvelope` property set to **true** and the `ExpressSendOnly` property in `SendingUser` structure must be set to **false**.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipient_initials_image_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_recipient_initials_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_recipient_initials_image`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_recipient_initials_image`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `update_recipient_initials_image`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['image/gif'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_recipient_signature_image(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Sets the signature image for an accountless signer.
        Updates the signature image for an accountless signer. The supported image formats for this file are: gif, png, jpeg, and bmp. The file size must be less than 200K.  For the Authentication/Authorization for this call, the credentials must match the sender of the envelope, the recipient must be an accountless signer or in person signer. The account must have the `CanSendEnvelope` property set to **true** and the `ExpressSendOnly` property in `SendingUser` structure must be set to **false**.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipient_signature_image(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_recipient_signature_image_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.update_recipient_signature_image_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def update_recipient_signature_image_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Sets the signature image for an accountless signer.
        Updates the signature image for an accountless signer. The supported image formats for this file are: gif, png, jpeg, and bmp. The file size must be less than 200K.  For the Authentication/Authorization for this call, the credentials must match the sender of the envelope, the recipient must be an accountless signer or in person signer. The account must have the `CanSendEnvelope` property set to **true** and the `ExpressSendOnly` property in `SendingUser` structure must be set to **false**.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipient_signature_image_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_recipient_signature_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_recipient_signature_image`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_recipient_signature_image`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `update_recipient_signature_image`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['image/gif'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_recipients(self, account_id, envelope_id, **kwargs):
        """
        Updates recipients in a draft envelope or corrects recipient information for an in process envelope.
        Updates recipients in a draft envelope or corrects recipient information for an in process envelope.   For draft envelopes, you can edit the following properties: `email`, `userName`, `routingOrder`, `faxNumber`, `deliveryMethod`, `accessCode`, and `requireIdLookup`.  Once an envelope has been sent, you can only edit: `email`, `userName`, `signerName`, `routingOrder`, `faxNumber`, and `deliveryMethod`. You can also select to resend an envelope by using the `resend_envelope` option.  If you send information for a recipient that does not already exist in a draft envelope, the recipient is added to the envelope (similar to the POST).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipients(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str combine_same_order_recipients:
        :param str offline_signing:
        :param str resend_envelope: When set to **true**, resends the   envelope if the new recipient's routing order is before or the same as the envelope's next recipient.
        :param Recipients recipients:
        :return: RecipientsUpdateSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_recipients_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_recipients_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_recipients_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Updates recipients in a draft envelope or corrects recipient information for an in process envelope.
        Updates recipients in a draft envelope or corrects recipient information for an in process envelope.   For draft envelopes, you can edit the following properties: `email`, `userName`, `routingOrder`, `faxNumber`, `deliveryMethod`, `accessCode`, and `requireIdLookup`.  Once an envelope has been sent, you can only edit: `email`, `userName`, `signerName`, `routingOrder`, `faxNumber`, and `deliveryMethod`. You can also select to resend an envelope by using the `resend_envelope` option.  If you send information for a recipient that does not already exist in a draft envelope, the recipient is added to the envelope (similar to the POST).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipients_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str combine_same_order_recipients:
        :param str offline_signing:
        :param str resend_envelope: When set to **true**, resends the   envelope if the new recipient's routing order is before or the same as the envelope's next recipient.
        :param Recipients recipients:
        :return: RecipientsUpdateSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'combine_same_order_recipients', 'offline_signing', 'resend_envelope', 'recipients']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_recipients" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_recipients`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_recipients`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}
        if 'combine_same_order_recipients' in params:
            query_params['combine_same_order_recipients'] = params['combine_same_order_recipients']
        if 'offline_signing' in params:
            query_params['offline_signing'] = params['offline_signing']
        if 'resend_envelope' in params:
            query_params['resend_envelope'] = params['resend_envelope']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'recipients' in params:
            body_params = params['recipients']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RecipientsUpdateSummary',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_recipients_document_visibility(self, account_id, envelope_id, **kwargs):
        """
        Updates document visibility for the recipients
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipients_document_visibility(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param DocumentVisibilityList document_visibility_list:
        :return: DocumentVisibilityList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_recipients_document_visibility_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_recipients_document_visibility_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_recipients_document_visibility_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Updates document visibility for the recipients
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipients_document_visibility_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param DocumentVisibilityList document_visibility_list:
        :return: DocumentVisibilityList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'document_visibility_list']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_recipients_document_visibility" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_recipients_document_visibility`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_recipients_document_visibility`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/document_visibility'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_visibility_list' in params:
            body_params = params['document_visibility_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentVisibilityList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_tabs(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Updates the tabs for a recipient.  
        Updates one or more tabs for a recipient in a draft envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_tabs(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param Tabs tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_tabs_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
        else:
            (data) = self.update_tabs_with_http_info(account_id, envelope_id, recipient_id, **kwargs)
            return data

    def update_tabs_with_http_info(self, account_id, envelope_id, recipient_id, **kwargs):
        """
        Updates the tabs for a recipient.  
        Updates one or more tabs for a recipient in a draft envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_tabs_with_http_info(account_id, envelope_id, recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param Tabs tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id', 'recipient_id', 'tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_tabs`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_tabs`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `update_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tabs' in params:
            body_params = params['tabs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_tabs_blob(self, account_id, envelope_id, **kwargs):
        """
        Update encrypted tabs for envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_tabs_blob(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_tabs_blob_with_http_info(account_id, envelope_id, **kwargs)
        else:
            (data) = self.update_tabs_blob_with_http_info(account_id, envelope_id, **kwargs)
            return data

    def update_tabs_blob_with_http_info(self, account_id, envelope_id, **kwargs):
        """
        Update encrypted tabs for envelope.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_tabs_blob_with_http_info(account_id, envelope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str envelope_id: The envelopeId Guid of the envelope being accessed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tabs_blob" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_tabs_blob`")
        # verify the required parameter 'envelope_id' is set
        if ('envelope_id' not in params) or (params['envelope_id'] is None):
            raise ValueError("Missing the required parameter `envelope_id` when calling `update_tabs_blob`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/tabs_blob'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'envelope_id' in params:
            path_params['envelopeId'] = params['envelope_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_template_recipient_document_visibility(self, account_id, recipient_id, template_id, **kwargs):
        """
        Updates document visibility for the recipients
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_template_recipient_document_visibility(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateDocumentVisibilityList template_document_visibility_list:
        :return: TemplateDocumentVisibilityList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_template_recipient_document_visibility_with_http_info(account_id, recipient_id, template_id, **kwargs)
        else:
            (data) = self.update_template_recipient_document_visibility_with_http_info(account_id, recipient_id, template_id, **kwargs)
            return data

    def update_template_recipient_document_visibility_with_http_info(self, account_id, recipient_id, template_id, **kwargs):
        """
        Updates document visibility for the recipients
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_template_recipient_document_visibility_with_http_info(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateDocumentVisibilityList template_document_visibility_list:
        :return: TemplateDocumentVisibilityList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'recipient_id', 'template_id', 'template_document_visibility_list']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_template_recipient_document_visibility" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_template_recipient_document_visibility`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `update_template_recipient_document_visibility`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_template_recipient_document_visibility`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_document_visibility_list' in params:
            body_params = params['template_document_visibility_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TemplateDocumentVisibilityList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_template_recipients_document_visibility(self, account_id, template_id, **kwargs):
        """
        Updates document visibility for the recipients
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_template_recipients_document_visibility(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateDocumentVisibilityList template_document_visibility_list:
        :return: TemplateDocumentVisibilityList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_template_recipients_document_visibility_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.update_template_recipients_document_visibility_with_http_info(account_id, template_id, **kwargs)
            return data

    def update_template_recipients_document_visibility_with_http_info(self, account_id, template_id, **kwargs):
        """
        Updates document visibility for the recipients
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_template_recipients_document_visibility_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateDocumentVisibilityList template_document_visibility_list:
        :return: TemplateDocumentVisibilityList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'template_document_visibility_list']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_template_recipients_document_visibility" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_template_recipients_document_visibility`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_template_recipients_document_visibility`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/document_visibility'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_document_visibility_list' in params:
            body_params = params['template_document_visibility_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TemplateDocumentVisibilityList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_template_workflow_definition(self, account_id, template_id, **kwargs):
        """
        Updates the workflow definition for a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_template_workflow_definition(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param Workflow workflow:
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_template_workflow_definition_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.update_template_workflow_definition_with_http_info(account_id, template_id, **kwargs)
            return data

    def update_template_workflow_definition_with_http_info(self, account_id, template_id, **kwargs):
        """
        Updates the workflow definition for a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_template_workflow_definition_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param Workflow workflow:
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'workflow']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_template_workflow_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_template_workflow_definition`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_template_workflow_definition`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/workflow'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'workflow' in params:
            body_params = params['workflow']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Workflow',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
