"""
    Togai Apis

    APIs for Togai App  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: engg@togai.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from togai_client.api_client import ApiClient, Endpoint as _Endpoint
from togai_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from togai_client.model.base_success_response import BaseSuccessResponse
from togai_client.model.create_usage_meter_request import CreateUsageMeterRequest
from togai_client.model.error_response import ErrorResponse
from togai_client.model.update_usage_meter_request import UpdateUsageMeterRequest
from togai_client.model.usage_meter import UsageMeter
from togai_client.model.usage_meter_paginated_response import UsageMeterPaginatedResponse


class UsageMetersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.activate_usage_meter_endpoint = _Endpoint(
            settings={
                'response_type': (UsageMeter,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema/{event_schema_name}/usage_meters/{usage_meter_name}/activate',
                'operation_id': 'activate_usage_meter',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_schema_name',
                    'usage_meter_name',
                ],
                'required': [
                    'event_schema_name',
                    'usage_meter_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_schema_name',
                    'usage_meter_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_schema_name',): {
                        'max_length': 50,
                    },
                    ('usage_meter_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_schema_name':
                        (str,),
                    'usage_meter_name':
                        (str,),
                },
                'attribute_map': {
                    'event_schema_name': 'event_schema_name',
                    'usage_meter_name': 'usage_meter_name',
                },
                'location_map': {
                    'event_schema_name': 'path',
                    'usage_meter_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_usage_meter_endpoint = _Endpoint(
            settings={
                'response_type': (UsageMeter,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema/{event_schema_name}/usage_meters',
                'operation_id': 'create_usage_meter',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_schema_name',
                    'create_usage_meter_request',
                ],
                'required': [
                    'event_schema_name',
                    'create_usage_meter_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_schema_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_schema_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_schema_name':
                        (str,),
                    'create_usage_meter_request':
                        (CreateUsageMeterRequest,),
                },
                'attribute_map': {
                    'event_schema_name': 'event_schema_name',
                },
                'location_map': {
                    'event_schema_name': 'path',
                    'create_usage_meter_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.deactivate_usage_meter_endpoint = _Endpoint(
            settings={
                'response_type': (UsageMeter,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema/{event_schema_name}/usage_meters/{usage_meter_name}/deactivate',
                'operation_id': 'deactivate_usage_meter',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_schema_name',
                    'usage_meter_name',
                ],
                'required': [
                    'event_schema_name',
                    'usage_meter_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_schema_name',
                    'usage_meter_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_schema_name',): {
                        'max_length': 50,
                    },
                    ('usage_meter_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_schema_name':
                        (str,),
                    'usage_meter_name':
                        (str,),
                },
                'attribute_map': {
                    'event_schema_name': 'event_schema_name',
                    'usage_meter_name': 'usage_meter_name',
                },
                'location_map': {
                    'event_schema_name': 'path',
                    'usage_meter_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_usage_meter_endpoint = _Endpoint(
            settings={
                'response_type': (BaseSuccessResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/usage_meter/{usage_meter_name}',
                'operation_id': 'delete_usage_meter',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'usage_meter_name',
                ],
                'required': [
                    'usage_meter_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'usage_meter_name',
                ]
            },
            root_map={
                'validations': {
                    ('usage_meter_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'usage_meter_name':
                        (str,),
                },
                'attribute_map': {
                    'usage_meter_name': 'usage_meter_name',
                },
                'location_map': {
                    'usage_meter_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_usage_meter_endpoint = _Endpoint(
            settings={
                'response_type': (UsageMeter,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema/{event_schema_name}/usage_meters/{usage_meter_name}',
                'operation_id': 'get_usage_meter',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_schema_name',
                    'usage_meter_name',
                ],
                'required': [
                    'event_schema_name',
                    'usage_meter_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_schema_name',
                    'usage_meter_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_schema_name',): {
                        'max_length': 50,
                    },
                    ('usage_meter_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_schema_name':
                        (str,),
                    'usage_meter_name':
                        (str,),
                },
                'attribute_map': {
                    'event_schema_name': 'event_schema_name',
                    'usage_meter_name': 'usage_meter_name',
                },
                'location_map': {
                    'event_schema_name': 'path',
                    'usage_meter_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_usage_meters_for_event_schema_endpoint = _Endpoint(
            settings={
                'response_type': (UsageMeterPaginatedResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema/{event_schema_name}/usage_meters',
                'operation_id': 'get_usage_meters_for_event_schema',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_schema_name',
                    'statuses',
                    'aggregations',
                    'next_token',
                    'page_size',
                    'sort_order',
                ],
                'required': [
                    'event_schema_name',
                ],
                'nullable': [
                ],
                'enum': [
                    'sort_order',
                ],
                'validation': [
                    'event_schema_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_schema_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                    ('sort_order',): {

                        "ASC": "ASC",
                        "DESC": "DESC"
                    },
                },
                'openapi_types': {
                    'event_schema_name':
                        (str,),
                    'statuses':
                        (str,),
                    'aggregations':
                        (str,),
                    'next_token':
                        (str,),
                    'page_size':
                        (str,),
                    'sort_order':
                        (str,),
                },
                'attribute_map': {
                    'event_schema_name': 'event_schema_name',
                    'statuses': 'statuses',
                    'aggregations': 'aggregations',
                    'next_token': 'nextToken',
                    'page_size': 'pageSize',
                    'sort_order': 'sortOrder',
                },
                'location_map': {
                    'event_schema_name': 'path',
                    'statuses': 'query',
                    'aggregations': 'query',
                    'next_token': 'query',
                    'page_size': 'query',
                    'sort_order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_usage_meter_endpoint = _Endpoint(
            settings={
                'response_type': (UsageMeter,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema/{event_schema_name}/usage_meters/{usage_meter_name}',
                'operation_id': 'update_usage_meter',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_schema_name',
                    'usage_meter_name',
                    'update_usage_meter_request',
                ],
                'required': [
                    'event_schema_name',
                    'usage_meter_name',
                    'update_usage_meter_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_schema_name',
                    'usage_meter_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_schema_name',): {
                        'max_length': 50,
                    },
                    ('usage_meter_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_schema_name':
                        (str,),
                    'usage_meter_name':
                        (str,),
                    'update_usage_meter_request':
                        (UpdateUsageMeterRequest,),
                },
                'attribute_map': {
                    'event_schema_name': 'event_schema_name',
                    'usage_meter_name': 'usage_meter_name',
                },
                'location_map': {
                    'event_schema_name': 'path',
                    'usage_meter_name': 'path',
                    'update_usage_meter_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def activate_usage_meter(
        self,
        event_schema_name,
        usage_meter_name,
        **kwargs
    ):
        """Activate usage meter  # noqa: E501

        Activate usage meter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.activate_usage_meter(event_schema_name, usage_meter_name, async_req=True)
        >>> result = thread.get()

        Args:
            event_schema_name (str):
            usage_meter_name (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UsageMeter
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_schema_name'] = \
            event_schema_name
        kwargs['usage_meter_name'] = \
            usage_meter_name
        return self.activate_usage_meter_endpoint.call_with_http_info(**kwargs)

    def create_usage_meter(
        self,
        event_schema_name,
        create_usage_meter_request,
        **kwargs
    ):
        """Create an usage meter  # noqa: E501

        Create an usage meter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_usage_meter(event_schema_name, create_usage_meter_request, async_req=True)
        >>> result = thread.get()

        Args:
            event_schema_name (str):
            create_usage_meter_request (CreateUsageMeterRequest): Payload to create usage meter

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UsageMeter
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_schema_name'] = \
            event_schema_name
        kwargs['create_usage_meter_request'] = \
            create_usage_meter_request
        return self.create_usage_meter_endpoint.call_with_http_info(**kwargs)

    def deactivate_usage_meter(
        self,
        event_schema_name,
        usage_meter_name,
        **kwargs
    ):
        """Deactivate usage meter  # noqa: E501

        Deactivate usage meter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deactivate_usage_meter(event_schema_name, usage_meter_name, async_req=True)
        >>> result = thread.get()

        Args:
            event_schema_name (str):
            usage_meter_name (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UsageMeter
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_schema_name'] = \
            event_schema_name
        kwargs['usage_meter_name'] = \
            usage_meter_name
        return self.deactivate_usage_meter_endpoint.call_with_http_info(**kwargs)

    def delete_usage_meter(
        self,
        usage_meter_name,
        **kwargs
    ):
        """Delete an Usage Meter  # noqa: E501

        Delete an Usage Meter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_usage_meter(usage_meter_name, async_req=True)
        >>> result = thread.get()

        Args:
            usage_meter_name (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            BaseSuccessResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['usage_meter_name'] = \
            usage_meter_name
        return self.delete_usage_meter_endpoint.call_with_http_info(**kwargs)

    def get_usage_meter(
        self,
        event_schema_name,
        usage_meter_name,
        **kwargs
    ):
        """Get usage meter  # noqa: E501

        Get usage meter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_meter(event_schema_name, usage_meter_name, async_req=True)
        >>> result = thread.get()

        Args:
            event_schema_name (str):
            usage_meter_name (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UsageMeter
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_schema_name'] = \
            event_schema_name
        kwargs['usage_meter_name'] = \
            usage_meter_name
        return self.get_usage_meter_endpoint.call_with_http_info(**kwargs)

    def get_usage_meters_for_event_schema(
        self,
        event_schema_name,
        **kwargs
    ):
        """List usage meters for event schema  # noqa: E501

        List usage meters for event schema with pagination and sort  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_meters_for_event_schema(event_schema_name, async_req=True)
        >>> result = thread.get()

        Args:
            event_schema_name (str):

        Keyword Args:
            statuses (str): Filter by provided statuses. [optional]
            aggregations (str): Filter by provided aggregations. [optional]
            next_token (str): [optional]
            page_size (str): [optional]
            sort_order (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UsageMeterPaginatedResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_schema_name'] = \
            event_schema_name
        return self.get_usage_meters_for_event_schema_endpoint.call_with_http_info(**kwargs)

    def update_usage_meter(
        self,
        event_schema_name,
        usage_meter_name,
        update_usage_meter_request,
        **kwargs
    ):
        """Update an usage meter  # noqa: E501

        Update an usage meter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_usage_meter(event_schema_name, usage_meter_name, update_usage_meter_request, async_req=True)
        >>> result = thread.get()

        Args:
            event_schema_name (str):
            usage_meter_name (str):
            update_usage_meter_request (UpdateUsageMeterRequest): Payload to create usage meter

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UsageMeter
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_schema_name'] = \
            event_schema_name
        kwargs['usage_meter_name'] = \
            usage_meter_name
        kwargs['update_usage_meter_request'] = \
            update_usage_meter_request
        return self.update_usage_meter_endpoint.call_with_http_info(**kwargs)

