"""
    Togai Apis

    APIs for Togai App  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: engg@togai.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from togai_client.api_client import ApiClient, Endpoint as _Endpoint
from togai_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from togai_client.model.base_success_response import BaseSuccessResponse
from togai_client.model.create_event_schema_request import CreateEventSchemaRequest
from togai_client.model.error_response import ErrorResponse
from togai_client.model.event_schema import EventSchema
from togai_client.model.event_schema_list_paginated_response import EventSchemaListPaginatedResponse
from togai_client.model.event_schema_versions_response import EventSchemaVersionsResponse
from togai_client.model.update_event_schema_request import UpdateEventSchemaRequest


class EventSchemasApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.activate_event_schema_endpoint = _Endpoint(
            settings={
                'response_type': (EventSchema,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema/{event_schema_name}/activate',
                'operation_id': 'activate_event_schema',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_schema_name',
                ],
                'required': [
                    'event_schema_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_schema_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_schema_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_schema_name':
                        (str,),
                },
                'attribute_map': {
                    'event_schema_name': 'event_schema_name',
                },
                'location_map': {
                    'event_schema_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_event_schema_endpoint = _Endpoint(
            settings={
                'response_type': (EventSchema,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema',
                'operation_id': 'create_event_schema',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_event_schema_request',
                ],
                'required': [
                    'create_event_schema_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_event_schema_request':
                        (CreateEventSchemaRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_event_schema_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.deactivate_event_schema_endpoint = _Endpoint(
            settings={
                'response_type': (EventSchema,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema/{event_schema_name}/deactivate',
                'operation_id': 'deactivate_event_schema',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_schema_name',
                ],
                'required': [
                    'event_schema_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_schema_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_schema_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_schema_name':
                        (str,),
                },
                'attribute_map': {
                    'event_schema_name': 'event_schema_name',
                },
                'location_map': {
                    'event_schema_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_event_schema_endpoint = _Endpoint(
            settings={
                'response_type': (BaseSuccessResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema/{event_schema_name}',
                'operation_id': 'delete_event_schema',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_schema_name',
                ],
                'required': [
                    'event_schema_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_schema_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_schema_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_schema_name':
                        (str,),
                },
                'attribute_map': {
                    'event_schema_name': 'event_schema_name',
                },
                'location_map': {
                    'event_schema_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_event_schema_endpoint = _Endpoint(
            settings={
                'response_type': (EventSchema,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema/{event_schema_name}',
                'operation_id': 'get_event_schema',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_schema_name',
                    'version',
                ],
                'required': [
                    'event_schema_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_schema_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_schema_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_schema_name':
                        (str,),
                    'version':
                        (int,),
                },
                'attribute_map': {
                    'event_schema_name': 'event_schema_name',
                    'version': 'version',
                },
                'location_map': {
                    'event_schema_name': 'path',
                    'version': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_event_schema_versions_endpoint = _Endpoint(
            settings={
                'response_type': (EventSchemaVersionsResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema/{event_schema_name}/versions',
                'operation_id': 'list_event_schema_versions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_schema_name',
                ],
                'required': [
                    'event_schema_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_schema_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_schema_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_schema_name':
                        (str,),
                },
                'attribute_map': {
                    'event_schema_name': 'event_schema_name',
                },
                'location_map': {
                    'event_schema_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_event_schemas_endpoint = _Endpoint(
            settings={
                'response_type': (EventSchemaListPaginatedResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema',
                'operation_id': 'list_event_schemas',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'statuses',
                    'next_token',
                    'page_size',
                    'sort_order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort_order',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('sort_order',): {

                        "ASC": "ASC",
                        "DESC": "DESC"
                    },
                },
                'openapi_types': {
                    'statuses':
                        (str,),
                    'next_token':
                        (str,),
                    'page_size':
                        (str,),
                    'sort_order':
                        (str,),
                },
                'attribute_map': {
                    'statuses': 'statuses',
                    'next_token': 'nextToken',
                    'page_size': 'pageSize',
                    'sort_order': 'sortOrder',
                },
                'location_map': {
                    'statuses': 'query',
                    'next_token': 'query',
                    'page_size': 'query',
                    'sort_order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_event_schema_endpoint = _Endpoint(
            settings={
                'response_type': (EventSchema,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/event_schema/{event_schema_name}',
                'operation_id': 'update_event_schema',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_schema_name',
                    'update_event_schema_request',
                ],
                'required': [
                    'event_schema_name',
                    'update_event_schema_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_schema_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_schema_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_schema_name':
                        (str,),
                    'update_event_schema_request':
                        (UpdateEventSchemaRequest,),
                },
                'attribute_map': {
                    'event_schema_name': 'event_schema_name',
                },
                'location_map': {
                    'event_schema_name': 'path',
                    'update_event_schema_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def activate_event_schema(
        self,
        event_schema_name,
        **kwargs
    ):
        """Activate an event schema  # noqa: E501

        Activate an event schema  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.activate_event_schema(event_schema_name, async_req=True)
        >>> result = thread.get()

        Args:
            event_schema_name (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EventSchema
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_schema_name'] = \
            event_schema_name
        return self.activate_event_schema_endpoint.call_with_http_info(**kwargs)

    def create_event_schema(
        self,
        create_event_schema_request,
        **kwargs
    ):
        """Create an event schema  # noqa: E501

        Create an event schema  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_event_schema(create_event_schema_request, async_req=True)
        >>> result = thread.get()

        Args:
            create_event_schema_request (CreateEventSchemaRequest): Payload to create event schema

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EventSchema
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_event_schema_request'] = \
            create_event_schema_request
        return self.create_event_schema_endpoint.call_with_http_info(**kwargs)

    def deactivate_event_schema(
        self,
        event_schema_name,
        **kwargs
    ):
        """Deactivate an event schema  # noqa: E501

        Deactivate an event schema  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deactivate_event_schema(event_schema_name, async_req=True)
        >>> result = thread.get()

        Args:
            event_schema_name (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EventSchema
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_schema_name'] = \
            event_schema_name
        return self.deactivate_event_schema_endpoint.call_with_http_info(**kwargs)

    def delete_event_schema(
        self,
        event_schema_name,
        **kwargs
    ):
        """Delete an event schema  # noqa: E501

        Delete an event schema  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_event_schema(event_schema_name, async_req=True)
        >>> result = thread.get()

        Args:
            event_schema_name (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            BaseSuccessResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_schema_name'] = \
            event_schema_name
        return self.delete_event_schema_endpoint.call_with_http_info(**kwargs)

    def get_event_schema(
        self,
        event_schema_name,
        **kwargs
    ):
        """Get an event schema  # noqa: E501

        Get an event schema  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_event_schema(event_schema_name, async_req=True)
        >>> result = thread.get()

        Args:
            event_schema_name (str):

        Keyword Args:
            version (int): Optional version to get a specific version. Gets latest version if it is not provided.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EventSchema
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_schema_name'] = \
            event_schema_name
        return self.get_event_schema_endpoint.call_with_http_info(**kwargs)

    def list_event_schema_versions(
        self,
        event_schema_name,
        **kwargs
    ):
        """List all event schema versions  # noqa: E501

        List all event schema versions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_event_schema_versions(event_schema_name, async_req=True)
        >>> result = thread.get()

        Args:
            event_schema_name (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EventSchemaVersionsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_schema_name'] = \
            event_schema_name
        return self.list_event_schema_versions_endpoint.call_with_http_info(**kwargs)

    def list_event_schemas(
        self,
        **kwargs
    ):
        """List event schemas  # noqa: E501

        List event schemas with pagination and sort  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_event_schemas(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            statuses (str): Filter by provided statuses. [optional]
            next_token (str): [optional]
            page_size (str): [optional]
            sort_order (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EventSchemaListPaginatedResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_event_schemas_endpoint.call_with_http_info(**kwargs)

    def update_event_schema(
        self,
        event_schema_name,
        update_event_schema_request,
        **kwargs
    ):
        """Update an event schema  # noqa: E501

        Update an event schema  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_event_schema(event_schema_name, update_event_schema_request, async_req=True)
        >>> result = thread.get()

        Args:
            event_schema_name (str):
            update_event_schema_request (UpdateEventSchemaRequest): Payload to update event schema

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EventSchema
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_schema_name'] = \
            event_schema_name
        kwargs['update_event_schema_request'] = \
            update_event_schema_request
        return self.update_event_schema_endpoint.call_with_http_info(**kwargs)

