# generated by datamodel-codegen:
#   filename:  argo-workflows-3.7.3.json

from __future__ import annotations

from typing import Annotated, Any, Dict, List, Optional

from hera.shared._pydantic import BaseModel, Field

from ...k8s.api.core import v1
from ...k8s.api.policy import v1 as v1_2
from ...k8s.apimachinery.pkg.apis.meta import v1 as v1_1
from ...k8s.apimachinery.pkg.util import intstr


class Amount(BaseModel):
    __root__: Annotated[float, Field(description="Amount represent a numeric amount.")]


class NoneStrategy(BaseModel):
    pass


class TarStrategy(BaseModel):
    compression_level: Annotated[
        Optional[int],
        Field(
            alias="compressionLevel",
            description=(
                "CompressionLevel specifies the gzip compression level to use for the"
                " artifact. Defaults to gzip.DefaultCompression."
            ),
        ),
    ] = None


class ZipStrategy(BaseModel):
    pass


class ArchivedWorkflowDeletedResponse(BaseModel):
    pass


class ArtGCStatus(BaseModel):
    not_specified: Annotated[
        Optional[bool],
        Field(
            alias="notSpecified",
            description=("if this is true, we already checked to see if we need to do it and we don't"),
        ),
    ] = None
    pods_recouped: Annotated[
        Optional[Dict[str, bool]],
        Field(
            alias="podsRecouped",
            description=(
                "have completed Pods been processed? (mapped by Pod name) used to"
                " prevent re-processing the Status of a Pod more than once"
            ),
        ),
    ] = None
    strategies_processed: Annotated[
        Optional[Dict[str, bool]],
        Field(
            alias="strategiesProcessed",
            description=(
                "have Pods been started to perform this strategy? (enables us not to"
                " re-process what we've already done)"
            ),
        ),
    ] = None


class RawArtifact(BaseModel):
    data: Annotated[str, Field(description="Data is the string contents of the artifact")]


class Metadata(BaseModel):
    annotations: Optional[Dict[str, str]] = None
    labels: Optional[Dict[str, str]] = None


class ArtifactRepositoryRef(BaseModel):
    config_map: Annotated[
        Optional[str],
        Field(
            alias="configMap",
            description=('The name of the config map. Defaults to "artifact-repositories".'),
        ),
    ] = None
    key: Annotated[
        Optional[str],
        Field(
            description=(
                "The config map key. Defaults to the value of the"
                ' "workflows.argoproj.io/default-artifact-repository" annotation.'
            )
        ),
    ] = None


class ClusterWorkflowTemplateDeleteResponse(BaseModel):
    pass


class CollectEventRequest(BaseModel):
    name: Optional[str] = None


class CollectEventResponse(BaseModel):
    pass


class Column(BaseModel):
    key: Annotated[
        str,
        Field(description=('The key of the label or annotation, e.g., "workflows.argoproj.io/completed".')),
    ]
    name: Annotated[str, Field(description='The name of this column, e.g., "Workflow Completed".')]
    type: Annotated[str, Field(description='The type of this column, "label" or "annotation".')]


class Condition(BaseModel):
    message: Annotated[Optional[str], Field(description="Message is the condition message")] = None
    status: Annotated[Optional[str], Field(description="Status is the status of the condition")] = None
    type: Annotated[Optional[str], Field(description="Type is the type of condition")] = None


class ContinueOn(BaseModel):
    error: Optional[bool] = None
    failed: Optional[bool] = None


class Counter(BaseModel):
    value: Annotated[str, Field(description="Value is the value of the metric")]


class CreateS3BucketOptions(BaseModel):
    object_locking: Annotated[
        Optional[bool],
        Field(alias="objectLocking", description="ObjectLocking Enable object locking"),
    ] = None


class CronWorkflowDeletedResponse(BaseModel):
    pass


class CronWorkflowResumeRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None


class StopStrategy(BaseModel):
    expression: Annotated[
        str,
        Field(
            description=(
                "v3.6 and after: Expression is an expression that stops scheduling"
                " workflows when true. Use the variables `cronworkflow`.`failed` or"
                " `cronworkflow`.`succeeded` to access the number of failed or"
                " successful child workflows."
            )
        ),
    ]


class CronWorkflowSuspendRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None


class TemplateRef(BaseModel):
    cluster_scope: Annotated[
        Optional[bool],
        Field(
            alias="clusterScope",
            description=(
                "ClusterScope indicates the referred template is cluster scoped (i.e. a ClusterWorkflowTemplate)."
            ),
        ),
    ] = None
    name: Annotated[Optional[str], Field(description="Name is the resource name of the template.")] = None
    template: Annotated[
        Optional[str],
        Field(description="Template is the name of referred template in the resource."),
    ] = None


class Event(BaseModel):
    selector: Annotated[
        str,
        Field(
            description=(
                "Selector (https://github.com/expr-lang/expr) that we must must match"
                ' the io.argoproj.workflow.v1alpha1. E.g. `payload.message == "test"`'
            )
        ),
    ]


class EventResponse(BaseModel):
    pass


class ExecutorConfig(BaseModel):
    service_account_name: Annotated[
        Optional[str],
        Field(
            alias="serviceAccountName",
            description=("ServiceAccountName specifies the service account name of the executor container."),
        ),
    ] = None


class Gauge(BaseModel):
    operation: Annotated[
        Optional[str],
        Field(description=("Operation defines the operation to apply with value and the metrics' current value")),
    ] = None
    realtime: Annotated[bool, Field(description="Realtime emits this metric in real time if applicable")]
    value: Annotated[
        str,
        Field(
            description=(
                "Value is the value to be used in the operation with the metric's"
                " current value. If no operation is set, value is the value of the"
                " metric"
            )
        ),
    ]


class GetUserInfoResponse(BaseModel):
    email: Optional[str] = None
    email_verified: Annotated[Optional[bool], Field(alias="emailVerified")] = None
    groups: Optional[List[str]] = None
    issuer: Optional[str] = None
    name: Optional[str] = None
    service_account_name: Annotated[Optional[str], Field(alias="serviceAccountName")] = None
    service_account_namespace: Annotated[Optional[str], Field(alias="serviceAccountNamespace")] = None
    subject: Optional[str] = None


class HTTPBodySource(BaseModel):
    bytes: Optional[str] = None


class Header(BaseModel):
    name: Annotated[str, Field(description="Name is the header name")]
    value: Annotated[str, Field(description="Value is the literal value to use for the header")]


class Histogram(BaseModel):
    buckets: Annotated[
        List[Amount],
        Field(description="Buckets is a list of bucket divisors for the histogram"),
    ]
    value: Annotated[str, Field(description="Value is the value of the metric")]


class Item(BaseModel):
    __root__: Annotated[
        Any,
        Field(
            description=(
                "Item expands a single workflow step into multiple parallel steps The"
                " value of Item can be a map, string, bool, or number"
            )
        ),
    ]


class LabelKeys(BaseModel):
    items: Optional[List[str]] = None


class LabelValueFrom(BaseModel):
    expression: str


class LabelValues(BaseModel):
    items: Optional[List[str]] = None


class Link(BaseModel):
    name: Annotated[
        str,
        Field(description='The name of the link, E.g. "Workflow Logs" or "Pod Logs"'),
    ]
    scope: Annotated[
        str,
        Field(
            description=(
                '"workflow", "pod", "pod-logs", "event-source-logs", "sensor-logs", "workflow-list" or "chat"'
            )
        ),
    ]
    url: Annotated[
        str,
        Field(
            description=(
                'The URL. Can contain "${metadata.namespace}", "${metadata.name}",'
                ' "${status.startedAt}", "${status.finishedAt}" or any other element in'
                " workflow yaml, e.g."
                ' "${io.argoproj.workflow.v1alpha1.metadata.annotations.userDefinedKey}"'
            )
        ),
    ]


class LogEntry(BaseModel):
    content: Optional[str] = None
    pod_name: Annotated[Optional[str], Field(alias="podName")] = None


class MemoizationStatus(BaseModel):
    cache_name: Annotated[
        str,
        Field(
            alias="cacheName",
            description="Cache is the name of the cache that was used",
        ),
    ]
    hit: Annotated[
        bool,
        Field(description="Hit indicates whether this node was created from a cache entry"),
    ]
    key: Annotated[str, Field(description="Key is the name of the key used for this node's cache")]


class MetricLabel(BaseModel):
    key: str
    value: str


class Mutex(BaseModel):
    database: Annotated[
        Optional[bool],
        Field(description=("Database specifies this is database controlled if this is set true")),
    ] = None
    name: Annotated[Optional[str], Field(description="name of the mutex")] = None
    namespace: Annotated[
        Optional[str],
        Field(description=("Namespace is the namespace of the mutex, default: [namespace of workflow]")),
    ] = None


class MutexHolding(BaseModel):
    holder: Annotated[
        Optional[str],
        Field(
            description=(
                "Holder is a reference to the object which holds the Mutex. Holding"
                " Scenario:\n  1. Current workflow's NodeID which is holding the"
                " lock.\n     e.g: ${NodeID}\nWaiting Scenario:\n  1. Current workflow"
                " or other workflow NodeID which is holding the lock.\n     e.g:"
                " ${WorkflowName}/${NodeID}"
            )
        ),
    ] = None
    mutex: Annotated[
        Optional[str],
        Field(description="Reference for the mutex e.g: ${namespace}/mutex/${mutexName}"),
    ] = None


class MutexStatus(BaseModel):
    holding: Annotated[
        Optional[List[MutexHolding]],
        Field(
            description=(
                "Holding is a list of mutexes and their respective objects that are"
                " held by mutex lock for this io.argoproj.workflow.v1alpha1."
            )
        ),
    ] = None
    waiting: Annotated[
        Optional[List[MutexHolding]],
        Field(description=("Waiting is a list of mutexes and their respective objects this workflow is waiting for.")),
    ] = None


class NodeFlag(BaseModel):
    hooked: Annotated[
        Optional[bool],
        Field(description=("Hooked tracks whether or not this node was triggered by hook or onExit")),
    ] = None
    retried: Annotated[
        Optional[bool],
        Field(description=("Retried tracks whether or not this node was retried by retryStrategy")),
    ] = None


class NodeSynchronizationStatus(BaseModel):
    waiting: Annotated[
        Optional[str],
        Field(description="Waiting is the name of the lock that this node is waiting for"),
    ] = None


class OAuth2EndpointParam(BaseModel):
    key: Annotated[str, Field(description="Name is the header name")]
    value: Annotated[
        Optional[str],
        Field(description="Value is the literal value to use for the header"),
    ] = None


class OSSLifecycleRule(BaseModel):
    mark_deletion_after_days: Annotated[
        Optional[int],
        Field(
            alias="markDeletionAfterDays",
            description=("MarkDeletionAfterDays is the number of days before we delete objects in the bucket"),
        ),
    ] = None
    mark_infrequent_access_after_days: Annotated[
        Optional[int],
        Field(
            alias="markInfrequentAccessAfterDays",
            description=(
                "MarkInfrequentAccessAfterDays is the number of days before we convert"
                " the objects in the bucket to Infrequent Access (IA) storage type"
            ),
        ),
    ] = None


class Plugin(BaseModel):
    pass


class ResubmitArchivedWorkflowRequest(BaseModel):
    memoized: Optional[bool] = None
    name: Optional[str] = None
    namespace: Optional[str] = None
    parameters: Optional[List[str]] = None
    uid: Optional[str] = None


class RetryNodeAntiAffinity(BaseModel):
    pass


class RetryArchivedWorkflowRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None
    node_field_selector: Annotated[Optional[str], Field(alias="nodeFieldSelector")] = None
    parameters: Optional[List[str]] = None
    restart_successful: Annotated[Optional[bool], Field(alias="restartSuccessful")] = None
    uid: Optional[str] = None


class SemaphoreHolding(BaseModel):
    holders: Annotated[
        Optional[List[str]],
        Field(description=("Holders stores the list of current holder names in the io.argoproj.workflow.v1alpha1.")),
    ] = None
    semaphore: Annotated[Optional[str], Field(description="Semaphore stores the semaphore name.")] = None


class SyncDatabaseRef(BaseModel):
    key: str


class SemaphoreStatus(BaseModel):
    holding: Annotated[
        Optional[List[SemaphoreHolding]],
        Field(description=("Holding stores the list of resource acquired synchronization lock for workflows.")),
    ] = None
    waiting: Annotated[
        Optional[List[SemaphoreHolding]],
        Field(description=("Waiting indicates the list of current synchronization lock holders.")),
    ] = None


class WorkflowTemplateRef(BaseModel):
    cluster_scope: Annotated[
        Optional[bool],
        Field(
            alias="clusterScope",
            description=(
                "ClusterScope indicates the referred template is cluster scoped (i.e. a ClusterWorkflowTemplate)."
            ),
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="Name is the resource name of the workflow template."),
    ] = None


class SuppliedValueFrom(BaseModel):
    pass


class SuspendTemplate(BaseModel):
    duration: Annotated[
        Optional[str],
        Field(
            description=(
                "Duration is the seconds to wait before automatically resuming a"
                " template. Must be a string. Default unit is seconds. Could also be a"
                ' Duration, e.g.: "2m", "6h"'
            )
        ),
    ] = None


class TTLStrategy(BaseModel):
    seconds_after_completion: Annotated[
        Optional[int],
        Field(
            alias="secondsAfterCompletion",
            description=("SecondsAfterCompletion is the number of seconds to live after completion"),
        ),
    ] = None
    seconds_after_failure: Annotated[
        Optional[int],
        Field(
            alias="secondsAfterFailure",
            description=("SecondsAfterFailure is the number of seconds to live after failure"),
        ),
    ] = None
    seconds_after_success: Annotated[
        Optional[int],
        Field(
            alias="secondsAfterSuccess",
            description=("SecondsAfterSuccess is the number of seconds to live after success"),
        ),
    ] = None


class TransformationStep(BaseModel):
    expression: Annotated[str, Field(description="Expression defines an expr expression to apply")]


class Version(BaseModel):
    build_date: Annotated[str, Field(alias="buildDate")]
    compiler: str
    git_commit: Annotated[str, Field(alias="gitCommit")]
    git_tag: Annotated[str, Field(alias="gitTag")]
    git_tree_state: Annotated[str, Field(alias="gitTreeState")]
    go_version: Annotated[str, Field(alias="goVersion")]
    platform: str
    version: str


class VolumeClaimGC(BaseModel):
    strategy: Annotated[
        Optional[str],
        Field(
            description=(
                'Strategy is the strategy to use. One of "OnWorkflowCompletion",'
                ' "OnWorkflowSuccess". Defaults to "OnWorkflowSuccess"'
            )
        ),
    ] = None


class WorkflowDeleteResponse(BaseModel):
    pass


class WorkflowMetadata(BaseModel):
    annotations: Optional[Dict[str, str]] = None
    labels: Optional[Dict[str, str]] = None
    labels_from: Annotated[Optional[Dict[str, LabelValueFrom]], Field(alias="labelsFrom")] = None


class WorkflowResubmitRequest(BaseModel):
    memoized: Optional[bool] = None
    name: Optional[str] = None
    namespace: Optional[str] = None
    parameters: Optional[List[str]] = None


class WorkflowResumeRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None
    node_field_selector: Annotated[Optional[str], Field(alias="nodeFieldSelector")] = None


class WorkflowRetryRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None
    node_field_selector: Annotated[Optional[str], Field(alias="nodeFieldSelector")] = None
    parameters: Optional[List[str]] = None
    restart_successful: Annotated[Optional[bool], Field(alias="restartSuccessful")] = None


class WorkflowSetRequest(BaseModel):
    message: Optional[str] = None
    name: Optional[str] = None
    namespace: Optional[str] = None
    node_field_selector: Annotated[Optional[str], Field(alias="nodeFieldSelector")] = None
    output_parameters: Annotated[Optional[str], Field(alias="outputParameters")] = None
    phase: Optional[str] = None


class WorkflowStopRequest(BaseModel):
    message: Optional[str] = None
    name: Optional[str] = None
    namespace: Optional[str] = None
    node_field_selector: Annotated[Optional[str], Field(alias="nodeFieldSelector")] = None


class WorkflowSuspendRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None


class WorkflowTemplateDeleteResponse(BaseModel):
    pass


class WorkflowTerminateRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None


class CronWorkflowStatus(BaseModel):
    active: Annotated[
        Optional[List[v1.ObjectReference]],
        Field(description=("Active is a list of active workflows stemming from this CronWorkflow")),
    ] = None
    conditions: Annotated[
        Optional[List[Condition]],
        Field(description="Conditions is a list of conditions the CronWorkflow may have"),
    ] = None
    failed: Annotated[
        Optional[int],
        Field(description=("v3.6 and after: Failed counts how many times child workflows failed")),
    ] = None
    last_scheduled_time: Annotated[
        Optional[v1_1.Time],
        Field(
            alias="lastScheduledTime",
            description=("LastScheduleTime is the last time the CronWorkflow was scheduled"),
        ),
    ] = None
    phase: Annotated[
        Optional[str],
        Field(
            description=(
                "v3.6 and after: Phase is an enum of Active or Stopped. It changes to"
                " Stopped when stopStrategy.expression is true"
            )
        ),
    ] = None
    succeeded: Annotated[
        Optional[int],
        Field(description=("v3.6 and after: Succeeded counts how many times child workflows succeeded")),
    ] = None


class ArtifactoryArtifact(BaseModel):
    password_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="passwordSecret",
            description=("PasswordSecret is the secret selector to the repository password"),
        ),
    ] = None
    url: Annotated[str, Field(description="URL of the artifact")]
    username_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="usernameSecret",
            description=("UsernameSecret is the secret selector to the repository username"),
        ),
    ] = None


class ArtifactoryArtifactRepository(BaseModel):
    key_format: Annotated[
        Optional[str],
        Field(
            alias="keyFormat",
            description=("KeyFormat defines the format of how to store keys and can reference workflow variables."),
        ),
    ] = None
    password_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="passwordSecret",
            description=("PasswordSecret is the secret selector to the repository password"),
        ),
    ] = None
    repo_url: Annotated[
        Optional[str],
        Field(alias="repoURL", description="RepoURL is the url for artifactory repo."),
    ] = None
    username_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="usernameSecret",
            description=("UsernameSecret is the secret selector to the repository username"),
        ),
    ] = None


class AzureArtifact(BaseModel):
    account_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="accountKeySecret",
            description=("AccountKeySecret is the secret selector to the Azure Blob Storage account access key"),
        ),
    ] = None
    blob: Annotated[
        str,
        Field(description=("Blob is the blob name (i.e., path) in the container where the artifact resides")),
    ]
    container: Annotated[
        str,
        Field(description="Container is the container where resources will be stored"),
    ]
    endpoint: Annotated[
        str,
        Field(
            description=(
                "Endpoint is the service url associated with an account. It is most"
                ' likely "https://<ACCOUNT_NAME>.blob.core.windows.net"'
            )
        ),
    ]
    use_sdk_creds: Annotated[
        Optional[bool],
        Field(
            alias="useSDKCreds",
            description=("UseSDKCreds tells the driver to figure out credentials based on sdk defaults."),
        ),
    ] = None


class AzureArtifactRepository(BaseModel):
    account_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="accountKeySecret",
            description=("AccountKeySecret is the secret selector to the Azure Blob Storage account access key"),
        ),
    ] = None
    blob_name_format: Annotated[
        Optional[str],
        Field(
            alias="blobNameFormat",
            description=(
                "BlobNameFormat is defines the format of how to store blob names. Can reference workflow variables"
            ),
        ),
    ] = None
    container: Annotated[
        str,
        Field(description="Container is the container where resources will be stored"),
    ]
    endpoint: Annotated[
        str,
        Field(
            description=(
                "Endpoint is the service url associated with an account. It is most"
                ' likely "https://<ACCOUNT_NAME>.blob.core.windows.net"'
            )
        ),
    ]
    use_sdk_creds: Annotated[
        Optional[bool],
        Field(
            alias="useSDKCreds",
            description=("UseSDKCreds tells the driver to figure out credentials based on sdk defaults."),
        ),
    ] = None


class BasicAuth(BaseModel):
    password_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="passwordSecret",
            description=("PasswordSecret is the secret selector to the repository password"),
        ),
    ] = None
    username_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="usernameSecret",
            description=("UsernameSecret is the secret selector to the repository username"),
        ),
    ] = None


class ClientCertAuth(BaseModel):
    client_cert_secret: Annotated[Optional[v1.SecretKeySelector], Field(alias="clientCertSecret")] = None
    client_key_secret: Annotated[Optional[v1.SecretKeySelector], Field(alias="clientKeySecret")] = None


class GCSArtifact(BaseModel):
    bucket: Annotated[Optional[str], Field(description="Bucket is the name of the bucket")] = None
    key: Annotated[
        str,
        Field(description="Key is the path in the bucket where the artifact resides"),
    ]
    service_account_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="serviceAccountKeySecret",
            description=("ServiceAccountKeySecret is the secret selector to the bucket's service account key"),
        ),
    ] = None


class GCSArtifactRepository(BaseModel):
    bucket: Annotated[Optional[str], Field(description="Bucket is the name of the bucket")] = None
    key_format: Annotated[
        Optional[str],
        Field(
            alias="keyFormat",
            description=("KeyFormat defines the format of how to store keys and can reference workflow variables."),
        ),
    ] = None
    service_account_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="serviceAccountKeySecret",
            description=("ServiceAccountKeySecret is the secret selector to the bucket's service account key"),
        ),
    ] = None


class GitArtifact(BaseModel):
    branch: Annotated[
        Optional[str],
        Field(description="Branch is the branch to fetch when `SingleBranch` is enabled"),
    ] = None
    depth: Annotated[
        Optional[int],
        Field(
            description=(
                "Depth specifies clones/fetches should be shallow and include the given"
                " number of commits from the branch tip"
            )
        ),
    ] = None
    disable_submodules: Annotated[
        Optional[bool],
        Field(
            alias="disableSubmodules",
            description="DisableSubmodules disables submodules during git clone",
        ),
    ] = None
    fetch: Annotated[
        Optional[List[str]],
        Field(description=("Fetch specifies a number of refs that should be fetched before checkout")),
    ] = None
    insecure_ignore_host_key: Annotated[
        Optional[bool],
        Field(
            alias="insecureIgnoreHostKey",
            description=("InsecureIgnoreHostKey disables SSH strict host key checking during git clone"),
        ),
    ] = None
    insecure_skip_tls: Annotated[
        Optional[bool],
        Field(
            alias="insecureSkipTLS",
            description=(
                "InsecureSkipTLS disables server certificate verification resulting in insecure HTTPS connections"
            ),
        ),
    ] = None
    password_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="passwordSecret",
            description=("PasswordSecret is the secret selector to the repository password"),
        ),
    ] = None
    repo: Annotated[str, Field(description="Repo is the git repository")]
    revision: Annotated[
        Optional[str],
        Field(description="Revision is the git commit, tag, branch to checkout"),
    ] = None
    single_branch: Annotated[
        Optional[bool],
        Field(
            alias="singleBranch",
            description=("SingleBranch enables single branch clone, using the `branch` parameter"),
        ),
    ] = None
    ssh_private_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="sshPrivateKeySecret",
            description=("SSHPrivateKeySecret is the secret selector to the repository ssh private key"),
        ),
    ] = None
    username_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="usernameSecret",
            description=("UsernameSecret is the secret selector to the repository username"),
        ),
    ] = None


class HTTPHeaderSource(BaseModel):
    secret_key_ref: Annotated[Optional[v1.SecretKeySelector], Field(alias="secretKeyRef")] = None


class OAuth2Auth(BaseModel):
    client_id_secret: Annotated[Optional[v1.SecretKeySelector], Field(alias="clientIDSecret")] = None
    client_secret_secret: Annotated[Optional[v1.SecretKeySelector], Field(alias="clientSecretSecret")] = None
    endpoint_params: Annotated[Optional[List[OAuth2EndpointParam]], Field(alias="endpointParams")] = None
    scopes: Optional[List[str]] = None
    token_url_secret: Annotated[Optional[v1.SecretKeySelector], Field(alias="tokenURLSecret")] = None


class S3EncryptionOptions(BaseModel):
    enable_encryption: Annotated[
        Optional[bool],
        Field(
            alias="enableEncryption",
            description=(
                "EnableEncryption tells the driver to encrypt objects if set to true."
                " If kmsKeyId and serverSideCustomerKeySecret are not set, SSE-S3 will"
                " be used"
            ),
        ),
    ] = None
    kms_encryption_context: Annotated[
        Optional[str],
        Field(
            alias="kmsEncryptionContext",
            description=(
                "KmsEncryptionContext is a json blob that contains an encryption"
                " context. See"
                " https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context"
                " for more information"
            ),
        ),
    ] = None
    kms_key_id: Annotated[
        Optional[str],
        Field(
            alias="kmsKeyId",
            description=("KMSKeyId tells the driver to encrypt the object using the specified KMS Key."),
        ),
    ] = None
    server_side_customer_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="serverSideCustomerKeySecret",
            description=(
                "ServerSideCustomerKeySecret tells the driver to encrypt the output"
                " artifacts using SSE-C with the specified secret."
            ),
        ),
    ] = None


class Cache(BaseModel):
    config_map: Annotated[
        v1.ConfigMapKeySelector,
        Field(alias="configMap", description="ConfigMap sets a ConfigMap-based cache"),
    ]


class HDFSArtifact(BaseModel):
    addresses: Annotated[
        Optional[List[str]],
        Field(description="Addresses is accessible addresses of HDFS name nodes"),
    ] = None
    data_transfer_protection: Annotated[
        Optional[str],
        Field(
            alias="dataTransferProtection",
            description=(
                "DataTransferProtection is the protection level for HDFS data transfer."
                " It corresponds to the dfs.data.transfer.protection configuration in"
                " HDFS."
            ),
        ),
    ] = None
    force: Annotated[
        Optional[bool],
        Field(description="Force copies a file forcibly even if it exists"),
    ] = None
    hdfs_user: Annotated[
        Optional[str],
        Field(
            alias="hdfsUser",
            description=(
                "HDFSUser is the user to access HDFS file system. It is ignored if either ccache or keytab is used."
            ),
        ),
    ] = None
    krb_c_cache_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="krbCCacheSecret",
            description=(
                "KrbCCacheSecret is the secret selector for Kerberos ccache Either"
                " ccache or keytab can be set to use Kerberos."
            ),
        ),
    ] = None
    krb_config_config_map: Annotated[
        Optional[v1.ConfigMapKeySelector],
        Field(
            alias="krbConfigConfigMap",
            description=(
                "KrbConfig is the configmap selector for Kerberos config as string It"
                " must be set if either ccache or keytab is used."
            ),
        ),
    ] = None
    krb_keytab_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="krbKeytabSecret",
            description=(
                "KrbKeytabSecret is the secret selector for Kerberos keytab Either"
                " ccache or keytab can be set to use Kerberos."
            ),
        ),
    ] = None
    krb_realm: Annotated[
        Optional[str],
        Field(
            alias="krbRealm",
            description=("KrbRealm is the Kerberos realm used with Kerberos keytab It must be set if keytab is used."),
        ),
    ] = None
    krb_service_principal_name: Annotated[
        Optional[str],
        Field(
            alias="krbServicePrincipalName",
            description=(
                "KrbServicePrincipalName is the principal name of Kerberos service It"
                " must be set if either ccache or keytab is used."
            ),
        ),
    ] = None
    krb_username: Annotated[
        Optional[str],
        Field(
            alias="krbUsername",
            description=(
                "KrbUsername is the Kerberos username used with Kerberos keytab It must be set if keytab is used."
            ),
        ),
    ] = None
    path: Annotated[str, Field(description="Path is a file path in HDFS")]


class HDFSArtifactRepository(BaseModel):
    addresses: Annotated[
        Optional[List[str]],
        Field(description="Addresses is accessible addresses of HDFS name nodes"),
    ] = None
    data_transfer_protection: Annotated[
        Optional[str],
        Field(
            alias="dataTransferProtection",
            description=(
                "DataTransferProtection is the protection level for HDFS data transfer."
                " It corresponds to the dfs.data.transfer.protection configuration in"
                " HDFS."
            ),
        ),
    ] = None
    force: Annotated[
        Optional[bool],
        Field(description="Force copies a file forcibly even if it exists"),
    ] = None
    hdfs_user: Annotated[
        Optional[str],
        Field(
            alias="hdfsUser",
            description=(
                "HDFSUser is the user to access HDFS file system. It is ignored if either ccache or keytab is used."
            ),
        ),
    ] = None
    krb_c_cache_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="krbCCacheSecret",
            description=(
                "KrbCCacheSecret is the secret selector for Kerberos ccache Either"
                " ccache or keytab can be set to use Kerberos."
            ),
        ),
    ] = None
    krb_config_config_map: Annotated[
        Optional[v1.ConfigMapKeySelector],
        Field(
            alias="krbConfigConfigMap",
            description=(
                "KrbConfig is the configmap selector for Kerberos config as string It"
                " must be set if either ccache or keytab is used."
            ),
        ),
    ] = None
    krb_keytab_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="krbKeytabSecret",
            description=(
                "KrbKeytabSecret is the secret selector for Kerberos keytab Either"
                " ccache or keytab can be set to use Kerberos."
            ),
        ),
    ] = None
    krb_realm: Annotated[
        Optional[str],
        Field(
            alias="krbRealm",
            description=("KrbRealm is the Kerberos realm used with Kerberos keytab It must be set if keytab is used."),
        ),
    ] = None
    krb_service_principal_name: Annotated[
        Optional[str],
        Field(
            alias="krbServicePrincipalName",
            description=(
                "KrbServicePrincipalName is the principal name of Kerberos service It"
                " must be set if either ccache or keytab is used."
            ),
        ),
    ] = None
    krb_username: Annotated[
        Optional[str],
        Field(
            alias="krbUsername",
            description=(
                "KrbUsername is the Kerberos username used with Kerberos keytab It must be set if keytab is used."
            ),
        ),
    ] = None
    path_format: Annotated[
        Optional[str],
        Field(
            alias="pathFormat",
            description=("PathFormat is defines the format of path to store a file. Can reference workflow variables"),
        ),
    ] = None


class ArchiveStrategy(BaseModel):
    none: Optional[NoneStrategy] = None
    tar: Optional[TarStrategy] = None
    zip: Optional[ZipStrategy] = None


class ArtifactGC(BaseModel):
    pod_metadata: Annotated[
        Optional[Metadata],
        Field(
            alias="podMetadata",
            description=(
                "PodMetadata is an optional field for specifying the Labels and"
                " Annotations that should be assigned to the Pod doing the deletion"
            ),
        ),
    ] = None
    service_account_name: Annotated[
        Optional[str],
        Field(
            alias="serviceAccountName",
            description=(
                "ServiceAccountName is an optional field for specifying the Service"
                " Account that should be assigned to the Pod doing the deletion"
            ),
        ),
    ] = None
    strategy: Annotated[Optional[str], Field(description="Strategy is the strategy to use.")] = None


class WorkflowLevelArtifactGC(BaseModel):
    force_finalizer_removal: Annotated[
        Optional[bool],
        Field(
            alias="forceFinalizerRemoval",
            description=(
                "ForceFinalizerRemoval: if set to true, the finalizer will be removed"
                " in the case that Artifact GC fails"
            ),
        ),
    ] = None
    pod_metadata: Annotated[
        Optional[Metadata],
        Field(
            alias="podMetadata",
            description=(
                "PodMetadata is an optional field for specifying the Labels and"
                " Annotations that should be assigned to the Pod doing the deletion"
            ),
        ),
    ] = None
    pod_spec_patch: Annotated[
        Optional[str],
        Field(
            alias="podSpecPatch",
            description=("PodSpecPatch holds strategic merge patch to apply against the artgc pod spec."),
        ),
    ] = None
    service_account_name: Annotated[
        Optional[str],
        Field(
            alias="serviceAccountName",
            description=(
                "ServiceAccountName is an optional field for specifying the Service"
                " Account that should be assigned to the Pod doing the deletion"
            ),
        ),
    ] = None
    strategy: Annotated[Optional[str], Field(description="Strategy is the strategy to use.")] = None


class Backoff(BaseModel):
    cap: Annotated[
        Optional[str],
        Field(
            description=(
                "Cap is a limit on revised values of the duration parameter. If a"
                " multiplication by the factor parameter would make the duration exceed"
                " the cap then the duration is set to the cap"
            )
        ),
    ] = None
    duration: Annotated[
        Optional[str],
        Field(
            description=(
                "Duration is the amount to back off. Default unit is seconds, but could"
                ' also be a duration (e.g. "2m", "1h")'
            )
        ),
    ] = None
    factor: Annotated[
        Optional[intstr.IntOrString],
        Field(description=("Factor is a factor to multiply the base duration after each failed retry")),
    ] = None
    max_duration: Annotated[
        Optional[str],
        Field(
            alias="maxDuration",
            description=(
                "MaxDuration is the maximum amount of time allowed for a workflow in"
                " the backoff strategy. It is important to note that if the workflow"
                " template includes activeDeadlineSeconds, the pod's deadline is"
                " initially set with activeDeadlineSeconds. However, when the workflow"
                " fails, the pod's deadline is then overridden by maxDuration. This"
                " ensures that the workflow does not exceed the specified maximum"
                " duration when retries are involved."
            ),
        ),
    ] = None


class ContainerSetRetryStrategy(BaseModel):
    duration: Annotated[
        Optional[str],
        Field(
            description=(
                'Duration is the time between each retry, examples values are "300ms",'
                ' "1s" or "5m". Valid time units are "ns", "us" (or "µs"), "ms", "s",'
                ' "m", "h".'
            )
        ),
    ] = None
    retries: Annotated[
        intstr.IntOrString,
        Field(
            description=(
                "Retries is the maximum number of retry attempts for each container. It"
                " does not include the first, original attempt; the maximum number of"
                " total attempts will be `retries + 1`."
            )
        ),
    ]


class Sequence(BaseModel):
    count: Annotated[
        Optional[intstr.IntOrString],
        Field(description=("Count is number of elements in the sequence (default: 0). Not to be used with end")),
    ] = None
    end: Annotated[
        Optional[intstr.IntOrString],
        Field(description=("Number at which to end the sequence (default: 0). Not to be used with Count")),
    ] = None
    format: Annotated[
        Optional[str],
        Field(description=("Format is a printf format string to format the value in the sequence")),
    ] = None
    start: Annotated[
        Optional[intstr.IntOrString],
        Field(description="Number at which to start the sequence (default: 0)"),
    ] = None


class Prometheus(BaseModel):
    counter: Annotated[Optional[Counter], Field(description="Counter is a counter metric")] = None
    gauge: Annotated[Optional[Gauge], Field(description="Gauge is a gauge metric")] = None
    help: Annotated[str, Field(description="Help is a string that describes the metric")]
    histogram: Annotated[Optional[Histogram], Field(description="Histogram is a histogram metric")] = None
    labels: Annotated[
        Optional[List[MetricLabel]],
        Field(description="Labels is a list of metric labels"),
    ] = None
    name: Annotated[str, Field(description="Name is the name of the metric")]
    when: Annotated[
        Optional[str],
        Field(description=("When is a conditional statement that decides when to emit the metric")),
    ] = None


class OSSArtifact(BaseModel):
    access_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="accessKeySecret",
            description=("AccessKeySecret is the secret selector to the bucket's access key"),
        ),
    ] = None
    bucket: Annotated[Optional[str], Field(description="Bucket is the name of the bucket")] = None
    create_bucket_if_not_present: Annotated[
        Optional[bool],
        Field(
            alias="createBucketIfNotPresent",
            description=(
                "CreateBucketIfNotPresent tells the driver to attempt to create the OSS"
                " bucket for output artifacts, if it doesn't exist"
            ),
        ),
    ] = None
    endpoint: Annotated[
        Optional[str],
        Field(description="Endpoint is the hostname of the bucket endpoint"),
    ] = None
    key: Annotated[
        str,
        Field(description="Key is the path in the bucket where the artifact resides"),
    ]
    lifecycle_rule: Annotated[
        Optional[OSSLifecycleRule],
        Field(
            alias="lifecycleRule",
            description="LifecycleRule specifies how to manage bucket's lifecycle",
        ),
    ] = None
    secret_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="secretKeySecret",
            description=("SecretKeySecret is the secret selector to the bucket's secret key"),
        ),
    ] = None
    security_token: Annotated[
        Optional[str],
        Field(
            alias="securityToken",
            description=(
                "SecurityToken is the user's temporary security token. For more"
                " details, check out:"
                " https://www.alibabacloud.com/help/doc-detail/100624.htm"
            ),
        ),
    ] = None
    use_sdk_creds: Annotated[
        Optional[bool],
        Field(
            alias="useSDKCreds",
            description=("UseSDKCreds tells the driver to figure out credentials based on sdk defaults."),
        ),
    ] = None


class OSSArtifactRepository(BaseModel):
    access_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="accessKeySecret",
            description=("AccessKeySecret is the secret selector to the bucket's access key"),
        ),
    ] = None
    bucket: Annotated[Optional[str], Field(description="Bucket is the name of the bucket")] = None
    create_bucket_if_not_present: Annotated[
        Optional[bool],
        Field(
            alias="createBucketIfNotPresent",
            description=(
                "CreateBucketIfNotPresent tells the driver to attempt to create the OSS"
                " bucket for output artifacts, if it doesn't exist"
            ),
        ),
    ] = None
    endpoint: Annotated[
        Optional[str],
        Field(description="Endpoint is the hostname of the bucket endpoint"),
    ] = None
    key_format: Annotated[
        Optional[str],
        Field(
            alias="keyFormat",
            description=("KeyFormat defines the format of how to store keys and can reference workflow variables."),
        ),
    ] = None
    lifecycle_rule: Annotated[
        Optional[OSSLifecycleRule],
        Field(
            alias="lifecycleRule",
            description="LifecycleRule specifies how to manage bucket's lifecycle",
        ),
    ] = None
    secret_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="secretKeySecret",
            description=("SecretKeySecret is the secret selector to the bucket's secret key"),
        ),
    ] = None
    security_token: Annotated[
        Optional[str],
        Field(
            alias="securityToken",
            description=(
                "SecurityToken is the user's temporary security token. For more"
                " details, check out:"
                " https://www.alibabacloud.com/help/doc-detail/100624.htm"
            ),
        ),
    ] = None
    use_sdk_creds: Annotated[
        Optional[bool],
        Field(
            alias="useSDKCreds",
            description=("UseSDKCreds tells the driver to figure out credentials based on sdk defaults."),
        ),
    ] = None


class RetryAffinity(BaseModel):
    node_anti_affinity: Annotated[Optional[RetryNodeAntiAffinity], Field(alias="nodeAntiAffinity")] = None


class SemaphoreRef(BaseModel):
    config_map_key_ref: Annotated[
        Optional[v1.ConfigMapKeySelector],
        Field(
            alias="configMapKeyRef",
            description=("ConfigMapKeyRef is a configmap selector for Semaphore configuration"),
        ),
    ] = None
    database: Annotated[
        Optional[SyncDatabaseRef],
        Field(description=("SyncDatabaseRef is a database reference for Semaphore configuration")),
    ] = None
    namespace: Annotated[
        Optional[str],
        Field(description=("Namespace is the namespace of the configmap, default: [namespace of workflow]")),
    ] = None


class SynchronizationStatus(BaseModel):
    mutex: Annotated[
        Optional[MutexStatus],
        Field(description="Mutex stores this workflow's mutex holder details"),
    ] = None
    semaphore: Annotated[
        Optional[SemaphoreStatus],
        Field(description="Semaphore stores this workflow's Semaphore holder details"),
    ] = None


class SubmitOpts(BaseModel):
    annotations: Annotated[Optional[str], Field(description="Annotations adds to metadata.labels")] = None
    dry_run: Annotated[
        Optional[bool],
        Field(
            alias="dryRun",
            description=(
                "DryRun validates the workflow on the client-side without creating it."
                " This option is not supported in API"
            ),
        ),
    ] = None
    entry_point: Annotated[
        Optional[str],
        Field(alias="entryPoint", description="Entrypoint overrides spec.entrypoint"),
    ] = None
    generate_name: Annotated[
        Optional[str],
        Field(
            alias="generateName",
            description="GenerateName overrides metadata.generateName",
        ),
    ] = None
    labels: Annotated[Optional[str], Field(description="Labels adds to metadata.labels")] = None
    name: Annotated[Optional[str], Field(description="Name overrides metadata.name")] = None
    owner_reference: Annotated[
        Optional[v1_1.OwnerReference],
        Field(
            alias="ownerReference",
            description="OwnerReference creates a metadata.ownerReference",
        ),
    ] = None
    parameters: Annotated[
        Optional[List[str]],
        Field(description="Parameters passes input parameters to workflow"),
    ] = None
    pod_priority_class_name: Annotated[
        Optional[str],
        Field(
            alias="podPriorityClassName",
            description="Set the podPriorityClassName of the workflow",
        ),
    ] = None
    priority: Annotated[
        Optional[int],
        Field(
            description=(
                "Priority is used if controller is configured to process limited number"
                " of workflows in parallel, higher priority workflows are processed"
                " first."
            )
        ),
    ] = None
    server_dry_run: Annotated[
        Optional[bool],
        Field(
            alias="serverDryRun",
            description=("ServerDryRun validates the workflow on the server-side without creating it"),
        ),
    ] = None
    service_account: Annotated[
        Optional[str],
        Field(
            alias="serviceAccount",
            description=("ServiceAccount runs all pods in the workflow using specified ServiceAccount."),
        ),
    ] = None


class ValueFrom(BaseModel):
    config_map_key_ref: Annotated[
        Optional[v1.ConfigMapKeySelector],
        Field(
            alias="configMapKeyRef",
            description=("ConfigMapKeyRef is configmap selector for input parameter configuration"),
        ),
    ] = None
    default: Annotated[
        Optional[str],
        Field(
            description=(
                "Default specifies a value to be used if retrieving the value from the specified source fails"
            )
        ),
    ] = None
    event: Annotated[
        Optional[str],
        Field(
            description=(
                "Selector (https://github.com/expr-lang/expr) that is evaluated against"
                " the event to get the value of the parameter. E.g. `payload.message`"
            )
        ),
    ] = None
    expression: Annotated[
        Optional[str],
        Field(description=("Expression, if defined, is evaluated to specify the value for the parameter")),
    ] = None
    jq_filter: Annotated[
        Optional[str],
        Field(
            alias="jqFilter",
            description=("JQFilter expression against the resource object in resource templates"),
        ),
    ] = None
    json_path: Annotated[
        Optional[str],
        Field(
            alias="jsonPath",
            description=("JSONPath of a resource to retrieve an output parameter value from in resource templates"),
        ),
    ] = None
    parameter: Annotated[
        Optional[str],
        Field(
            description=(
                "Parameter reference to a step or dag task in which to retrieve an"
                " output parameter value from (e.g. '{{steps.mystep.outputs.myparam}}')"
            )
        ),
    ] = None
    path: Annotated[
        Optional[str],
        Field(description=("Path in the container to retrieve an output parameter value from in container templates")),
    ] = None
    supplied: Annotated[
        Optional[SuppliedValueFrom],
        Field(description=("Supplied value to be filled in directly, either through the CLI, API, etc.")),
    ] = None


class HTTPHeader(BaseModel):
    name: str
    value: Optional[str] = None
    value_from: Annotated[Optional[HTTPHeaderSource], Field(alias="valueFrom")] = None


class HTTPAuth(BaseModel):
    basic_auth: Annotated[Optional[BasicAuth], Field(alias="basicAuth")] = None
    client_cert: Annotated[Optional[ClientCertAuth], Field(alias="clientCert")] = None
    oauth2: Optional[OAuth2Auth] = None


class S3Artifact(BaseModel):
    access_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="accessKeySecret",
            description=("AccessKeySecret is the secret selector to the bucket's access key"),
        ),
    ] = None
    bucket: Annotated[Optional[str], Field(description="Bucket is the name of the bucket")] = None
    ca_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="caSecret",
            description=("CASecret specifies the secret that contains the CA, used to verify the TLS connection"),
        ),
    ] = None
    create_bucket_if_not_present: Annotated[
        Optional[CreateS3BucketOptions],
        Field(
            alias="createBucketIfNotPresent",
            description=(
                "CreateBucketIfNotPresent tells the driver to attempt to create the S3"
                " bucket for output artifacts, if it doesn't exist. Setting Enabled"
                " Encryption will apply either SSE-S3 to the bucket if KmsKeyId is not"
                " set or SSE-KMS if it is."
            ),
        ),
    ] = None
    encryption_options: Annotated[Optional[S3EncryptionOptions], Field(alias="encryptionOptions")] = None
    endpoint: Annotated[
        Optional[str],
        Field(description="Endpoint is the hostname of the bucket endpoint"),
    ] = None
    insecure: Annotated[
        Optional[bool],
        Field(description="Insecure will connect to the service with TLS"),
    ] = None
    key: Annotated[
        Optional[str],
        Field(description="Key is the key in the bucket where the artifact resides"),
    ] = None
    region: Annotated[Optional[str], Field(description="Region contains the optional bucket region")] = None
    role_arn: Annotated[
        Optional[str],
        Field(
            alias="roleARN",
            description=("RoleARN is the Amazon Resource Name (ARN) of the role to assume."),
        ),
    ] = None
    secret_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="secretKeySecret",
            description=("SecretKeySecret is the secret selector to the bucket's secret key"),
        ),
    ] = None
    session_token_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="sessionTokenSecret",
            description=(
                "SessionTokenSecret is used for ephemeral credentials like an IAM assume role or S3 access grant"
            ),
        ),
    ] = None
    use_sdk_creds: Annotated[
        Optional[bool],
        Field(
            alias="useSDKCreds",
            description=("UseSDKCreds tells the driver to figure out credentials based on sdk defaults."),
        ),
    ] = None


class S3ArtifactRepository(BaseModel):
    access_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="accessKeySecret",
            description=("AccessKeySecret is the secret selector to the bucket's access key"),
        ),
    ] = None
    bucket: Annotated[Optional[str], Field(description="Bucket is the name of the bucket")] = None
    ca_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="caSecret",
            description=("CASecret specifies the secret that contains the CA, used to verify the TLS connection"),
        ),
    ] = None
    create_bucket_if_not_present: Annotated[
        Optional[CreateS3BucketOptions],
        Field(
            alias="createBucketIfNotPresent",
            description=(
                "CreateBucketIfNotPresent tells the driver to attempt to create the S3"
                " bucket for output artifacts, if it doesn't exist. Setting Enabled"
                " Encryption will apply either SSE-S3 to the bucket if KmsKeyId is not"
                " set or SSE-KMS if it is."
            ),
        ),
    ] = None
    encryption_options: Annotated[Optional[S3EncryptionOptions], Field(alias="encryptionOptions")] = None
    endpoint: Annotated[
        Optional[str],
        Field(description="Endpoint is the hostname of the bucket endpoint"),
    ] = None
    insecure: Annotated[
        Optional[bool],
        Field(description="Insecure will connect to the service with TLS"),
    ] = None
    key_format: Annotated[
        Optional[str],
        Field(
            alias="keyFormat",
            description=("KeyFormat defines the format of how to store keys and can reference workflow variables."),
        ),
    ] = None
    key_prefix: Annotated[
        Optional[str],
        Field(
            alias="keyPrefix",
            description=(
                "KeyPrefix is prefix used as part of the bucket key in which the"
                " controller will store artifacts. DEPRECATED. Use KeyFormat instead"
            ),
        ),
    ] = None
    region: Annotated[Optional[str], Field(description="Region contains the optional bucket region")] = None
    role_arn: Annotated[
        Optional[str],
        Field(
            alias="roleARN",
            description=("RoleARN is the Amazon Resource Name (ARN) of the role to assume."),
        ),
    ] = None
    secret_key_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="secretKeySecret",
            description=("SecretKeySecret is the secret selector to the bucket's secret key"),
        ),
    ] = None
    session_token_secret: Annotated[
        Optional[v1.SecretKeySelector],
        Field(
            alias="sessionTokenSecret",
            description=(
                "SessionTokenSecret is used for ephemeral credentials like an IAM assume role or S3 access grant"
            ),
        ),
    ] = None
    use_sdk_creds: Annotated[
        Optional[bool],
        Field(
            alias="useSDKCreds",
            description=("UseSDKCreds tells the driver to figure out credentials based on sdk defaults."),
        ),
    ] = None


class Memoize(BaseModel):
    cache: Annotated[Cache, Field(description="Cache sets and configures the kind of cache")]
    key: Annotated[str, Field(description="Key is the key to use as the caching key")]
    max_age: Annotated[
        str,
        Field(
            alias="maxAge",
            description=(
                'MaxAge is the maximum age (e.g. "180s", "24h") of an entry that is'
                " still considered valid. If an entry is older than the MaxAge, it will"
                " be ignored."
            ),
        ),
    ]


class RetryStrategy(BaseModel):
    affinity: Annotated[
        Optional[RetryAffinity],
        Field(description="Affinity prevents running workflow's step on the same host"),
    ] = None
    backoff: Annotated[Optional[Backoff], Field(description="Backoff is a backoff strategy")] = None
    expression: Annotated[
        Optional[str],
        Field(
            description=(
                "Expression is a condition expression for when a node will be retried."
                " If it evaluates to false, the node will not be retried and the retry"
                " strategy will be ignored"
            )
        ),
    ] = None
    limit: Annotated[
        Optional[intstr.IntOrString],
        Field(
            description=(
                "Limit is the maximum number of retry attempts when retrying a"
                " container. It does not include the original container; the maximum"
                " number of total attempts will be `limit + 1`."
            )
        ),
    ] = None
    retry_policy: Annotated[
        Optional[str],
        Field(
            alias="retryPolicy",
            description=("RetryPolicy is a policy of NodePhase statuses that will be retried"),
        ),
    ] = None


class Synchronization(BaseModel):
    mutex: Annotated[
        Optional[Mutex],
        Field(description=("Mutex holds the Mutex lock details - deprecated, use mutexes instead")),
    ] = None
    mutexes: Annotated[
        Optional[List[Mutex]],
        Field(description="v3.6 and after: Mutexes holds the list of Mutex lock details"),
    ] = None
    semaphore: Annotated[
        Optional[SemaphoreRef],
        Field(description=("Semaphore holds the Semaphore configuration - deprecated, use semaphores instead")),
    ] = None
    semaphores: Annotated[
        Optional[List[SemaphoreRef]],
        Field(description=("v3.6 and after: Semaphores holds the list of Semaphores configuration")),
    ] = None


class WorkflowSubmitRequest(BaseModel):
    namespace: Optional[str] = None
    resource_kind: Annotated[Optional[str], Field(alias="resourceKind")] = None
    resource_name: Annotated[Optional[str], Field(alias="resourceName")] = None
    submit_options: Annotated[Optional[SubmitOpts], Field(alias="submitOptions")] = None


class Parameter(BaseModel):
    default: Annotated[
        Optional[str],
        Field(description=("Default is the default value to use for an input parameter if a value was not supplied")),
    ] = None
    description: Annotated[Optional[str], Field(description="Description is the parameter description")] = None
    enum: Annotated[
        Optional[List[str]],
        Field(
            description=("Enum holds a list of string values to choose from, for the actual value of the parameter")
        ),
    ] = None
    global_name: Annotated[
        Optional[str],
        Field(
            alias="globalName",
            description=(
                "GlobalName exports an output parameter to the global scope, making it"
                " available as"
                " '{{io.argoproj.workflow.v1alpha1.outputs.parameters.XXXX}} and in"
                " workflow.status.outputs.parameters"
            ),
        ),
    ] = None
    name: Annotated[str, Field(description="Name is the parameter name")]
    value: Annotated[
        Optional[str],
        Field(
            description=(
                "Value is the literal value to use for the parameter. If specified in"
                " the context of an input parameter, any passed values take precedence"
                " over the specified value"
            )
        ),
    ] = None
    value_from: Annotated[
        Optional[ValueFrom],
        Field(
            alias="valueFrom",
            description="ValueFrom is the source for the output parameter's value",
        ),
    ] = None


class HTTPArtifact(BaseModel):
    auth: Annotated[
        Optional[HTTPAuth],
        Field(description="Auth contains information for client authentication"),
    ] = None
    headers: Annotated[
        Optional[List[Header]],
        Field(description=("Headers are an optional list of headers to send with HTTP requests for artifacts")),
    ] = None
    url: Annotated[str, Field(description="URL of the artifact")]


class ArtifactRepository(BaseModel):
    archive_logs: Annotated[
        Optional[bool],
        Field(alias="archiveLogs", description="ArchiveLogs enables log archiving"),
    ] = None
    artifactory: Annotated[
        Optional[ArtifactoryArtifactRepository],
        Field(description="Artifactory stores artifacts to JFrog Artifactory"),
    ] = None
    azure: Annotated[
        Optional[AzureArtifactRepository],
        Field(description="Azure stores artifact in an Azure Storage account"),
    ] = None
    gcs: Annotated[
        Optional[GCSArtifactRepository],
        Field(description="GCS stores artifact in a GCS object store"),
    ] = None
    hdfs: Annotated[
        Optional[HDFSArtifactRepository],
        Field(description="HDFS stores artifacts in HDFS"),
    ] = None
    oss: Annotated[
        Optional[OSSArtifactRepository],
        Field(description="OSS stores artifact in a OSS-compliant object store"),
    ] = None
    s3: Annotated[
        Optional[S3ArtifactRepository],
        Field(description="S3 stores artifact in a S3-compliant object store"),
    ] = None


class Artifact(BaseModel):
    archive: Annotated[
        Optional[ArchiveStrategy],
        Field(description=("Archive controls how the artifact will be saved to the artifact repository.")),
    ] = None
    archive_logs: Annotated[
        Optional[bool],
        Field(
            alias="archiveLogs",
            description=("ArchiveLogs indicates if the container logs should be archived"),
        ),
    ] = None
    artifact_gc: Annotated[
        Optional[ArtifactGC],
        Field(
            alias="artifactGC",
            description=(
                "ArtifactGC describes the strategy to use when to deleting an artifact"
                " from completed or deleted workflows"
            ),
        ),
    ] = None
    artifactory: Annotated[
        Optional[ArtifactoryArtifact],
        Field(description="Artifactory contains artifactory artifact location details"),
    ] = None
    azure: Annotated[
        Optional[AzureArtifact],
        Field(description="Azure contains Azure Storage artifact location details"),
    ] = None
    deleted: Annotated[Optional[bool], Field(description="Has this been deleted?")] = None
    from_: Annotated[
        Optional[str],
        Field(
            alias="from",
            description=("From allows an artifact to reference an artifact from a previous step"),
        ),
    ] = None
    from_expression: Annotated[
        Optional[str],
        Field(
            alias="fromExpression",
            description=("FromExpression, if defined, is evaluated to specify the value for the artifact"),
        ),
    ] = None
    gcs: Annotated[
        Optional[GCSArtifact],
        Field(description="GCS contains GCS artifact location details"),
    ] = None
    git: Annotated[
        Optional[GitArtifact],
        Field(description="Git contains git artifact location details"),
    ] = None
    global_name: Annotated[
        Optional[str],
        Field(
            alias="globalName",
            description=(
                "GlobalName exports an output artifact to the global scope, making it"
                " available as"
                " '{{io.argoproj.workflow.v1alpha1.outputs.artifacts.XXXX}} and in"
                " workflow.status.outputs.artifacts"
            ),
        ),
    ] = None
    hdfs: Annotated[
        Optional[HDFSArtifact],
        Field(description="HDFS contains HDFS artifact location details"),
    ] = None
    http: Annotated[
        Optional[HTTPArtifact],
        Field(description="HTTP contains HTTP artifact location details"),
    ] = None
    mode: Annotated[
        Optional[int],
        Field(
            description=(
                "mode bits to use on this file, must be a value between 0 and 0777 set when loading input artifacts."
            )
        ),
    ] = None
    name: Annotated[
        str,
        Field(description=("name of the artifact. must be unique within a template's inputs/outputs.")),
    ]
    optional: Annotated[
        Optional[bool],
        Field(description=("Make Artifacts optional, if Artifacts doesn't generate or exist")),
    ] = None
    oss: Annotated[
        Optional[OSSArtifact],
        Field(description="OSS contains OSS artifact location details"),
    ] = None
    path: Annotated[Optional[str], Field(description="Path is the container path to the artifact")] = None
    raw: Annotated[
        Optional[RawArtifact],
        Field(description="Raw contains raw artifact location details"),
    ] = None
    recurse_mode: Annotated[
        Optional[bool],
        Field(
            alias="recurseMode",
            description=("If mode is set, apply the permission recursively into the artifact if it is a folder"),
        ),
    ] = None
    s3: Annotated[
        Optional[S3Artifact],
        Field(description="S3 contains S3 artifact location details"),
    ] = None
    sub_path: Annotated[
        Optional[str],
        Field(
            alias="subPath",
            description=("SubPath allows an artifact to be sourced from a subpath within the specified source"),
        ),
    ] = None


class ArtifactLocation(BaseModel):
    archive_logs: Annotated[
        Optional[bool],
        Field(
            alias="archiveLogs",
            description=("ArchiveLogs indicates if the container logs should be archived"),
        ),
    ] = None
    artifactory: Annotated[
        Optional[ArtifactoryArtifact],
        Field(description="Artifactory contains artifactory artifact location details"),
    ] = None
    azure: Annotated[
        Optional[AzureArtifact],
        Field(description="Azure contains Azure Storage artifact location details"),
    ] = None
    gcs: Annotated[
        Optional[GCSArtifact],
        Field(description="GCS contains GCS artifact location details"),
    ] = None
    git: Annotated[
        Optional[GitArtifact],
        Field(description="Git contains git artifact location details"),
    ] = None
    hdfs: Annotated[
        Optional[HDFSArtifact],
        Field(description="HDFS contains HDFS artifact location details"),
    ] = None
    http: Annotated[
        Optional[HTTPArtifact],
        Field(description="HTTP contains HTTP artifact location details"),
    ] = None
    oss: Annotated[
        Optional[OSSArtifact],
        Field(description="OSS contains OSS artifact location details"),
    ] = None
    raw: Annotated[
        Optional[RawArtifact],
        Field(description="Raw contains raw artifact location details"),
    ] = None
    s3: Annotated[
        Optional[S3Artifact],
        Field(description="S3 contains S3 artifact location details"),
    ] = None


class ArtifactPaths(BaseModel):
    archive: Annotated[
        Optional[ArchiveStrategy],
        Field(description=("Archive controls how the artifact will be saved to the artifact repository.")),
    ] = None
    archive_logs: Annotated[
        Optional[bool],
        Field(
            alias="archiveLogs",
            description=("ArchiveLogs indicates if the container logs should be archived"),
        ),
    ] = None
    artifact_gc: Annotated[
        Optional[ArtifactGC],
        Field(
            alias="artifactGC",
            description=(
                "ArtifactGC describes the strategy to use when to deleting an artifact"
                " from completed or deleted workflows"
            ),
        ),
    ] = None
    artifactory: Annotated[
        Optional[ArtifactoryArtifact],
        Field(description="Artifactory contains artifactory artifact location details"),
    ] = None
    azure: Annotated[
        Optional[AzureArtifact],
        Field(description="Azure contains Azure Storage artifact location details"),
    ] = None
    deleted: Annotated[Optional[bool], Field(description="Has this been deleted?")] = None
    from_: Annotated[
        Optional[str],
        Field(
            alias="from",
            description=("From allows an artifact to reference an artifact from a previous step"),
        ),
    ] = None
    from_expression: Annotated[
        Optional[str],
        Field(
            alias="fromExpression",
            description=("FromExpression, if defined, is evaluated to specify the value for the artifact"),
        ),
    ] = None
    gcs: Annotated[
        Optional[GCSArtifact],
        Field(description="GCS contains GCS artifact location details"),
    ] = None
    git: Annotated[
        Optional[GitArtifact],
        Field(description="Git contains git artifact location details"),
    ] = None
    global_name: Annotated[
        Optional[str],
        Field(
            alias="globalName",
            description=(
                "GlobalName exports an output artifact to the global scope, making it"
                " available as"
                " '{{io.argoproj.workflow.v1alpha1.outputs.artifacts.XXXX}} and in"
                " workflow.status.outputs.artifacts"
            ),
        ),
    ] = None
    hdfs: Annotated[
        Optional[HDFSArtifact],
        Field(description="HDFS contains HDFS artifact location details"),
    ] = None
    http: Annotated[
        Optional[HTTPArtifact],
        Field(description="HTTP contains HTTP artifact location details"),
    ] = None
    mode: Annotated[
        Optional[int],
        Field(
            description=(
                "mode bits to use on this file, must be a value between 0 and 0777 set when loading input artifacts."
            )
        ),
    ] = None
    name: Annotated[
        str,
        Field(description=("name of the artifact. must be unique within a template's inputs/outputs.")),
    ]
    optional: Annotated[
        Optional[bool],
        Field(description=("Make Artifacts optional, if Artifacts doesn't generate or exist")),
    ] = None
    oss: Annotated[
        Optional[OSSArtifact],
        Field(description="OSS contains OSS artifact location details"),
    ] = None
    path: Annotated[Optional[str], Field(description="Path is the container path to the artifact")] = None
    raw: Annotated[
        Optional[RawArtifact],
        Field(description="Raw contains raw artifact location details"),
    ] = None
    recurse_mode: Annotated[
        Optional[bool],
        Field(
            alias="recurseMode",
            description=("If mode is set, apply the permission recursively into the artifact if it is a folder"),
        ),
    ] = None
    s3: Annotated[
        Optional[S3Artifact],
        Field(description="S3 contains S3 artifact location details"),
    ] = None
    sub_path: Annotated[
        Optional[str],
        Field(
            alias="subPath",
            description=("SubPath allows an artifact to be sourced from a subpath within the specified source"),
        ),
    ] = None


class ArtifactRepositoryRefStatus(BaseModel):
    artifact_repository: Annotated[
        Optional[ArtifactRepository],
        Field(
            alias="artifactRepository",
            description=("The repository the workflow will use. This maybe empty before v3.1."),
        ),
    ] = None
    config_map: Annotated[
        Optional[str],
        Field(
            alias="configMap",
            description=('The name of the config map. Defaults to "artifact-repositories".'),
        ),
    ] = None
    default: Annotated[
        Optional[bool],
        Field(description=("If this ref represents the default artifact repository, rather than a config map.")),
    ] = None
    key: Annotated[
        Optional[str],
        Field(
            description=(
                "The config map key. Defaults to the value of the"
                ' "workflows.argoproj.io/default-artifact-repository" annotation.'
            )
        ),
    ] = None
    namespace: Annotated[
        Optional[str],
        Field(
            description=(
                "The namespace of the config map. Defaults to the workflow's namespace,"
                " or the controller's namespace (if found)."
            )
        ),
    ] = None


class ManifestFrom(BaseModel):
    artifact: Annotated[Artifact, Field(description="Artifact contains the artifact to use")]


class DataSource(BaseModel):
    artifact_paths: Annotated[
        Optional[ArtifactPaths],
        Field(
            alias="artifactPaths",
            description=("ArtifactPaths is a data transformation that collects a list of artifact paths"),
        ),
    ] = None


class ResourceTemplate(BaseModel):
    action: Annotated[
        str,
        Field(
            description=(
                "Action is the action to perform to the resource. Must be one of: get,"
                " create, apply, delete, replace, patch"
            )
        ),
    ]
    failure_condition: Annotated[
        Optional[str],
        Field(
            alias="failureCondition",
            description=(
                "FailureCondition is a label selector expression which describes the"
                " conditions of the k8s resource in which the step was considered"
                " failed"
            ),
        ),
    ] = None
    flags: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Flags is a set of additional options passed to kubectl before"
                " submitting a resource I.e. to disable resource validation: flags:"
                ' [\n\t"--validate=false"  # disable resource validation\n]'
            )
        ),
    ] = None
    manifest: Annotated[Optional[str], Field(description="Manifest contains the kubernetes manifest")] = None
    manifest_from: Annotated[
        Optional[ManifestFrom],
        Field(
            alias="manifestFrom",
            description="ManifestFrom is the source for a single kubernetes manifest",
        ),
    ] = None
    merge_strategy: Annotated[
        Optional[str],
        Field(
            alias="mergeStrategy",
            description=(
                "MergeStrategy is the strategy used to merge a patch. It defaults to"
                ' "strategic" Must be one of: strategic, merge, json'
            ),
        ),
    ] = None
    set_owner_reference: Annotated[
        Optional[bool],
        Field(
            alias="setOwnerReference",
            description=(
                "SetOwnerReference sets the reference to the workflow on the OwnerReference of generated resource."
            ),
        ),
    ] = None
    success_condition: Annotated[
        Optional[str],
        Field(
            alias="successCondition",
            description=(
                "SuccessCondition is a label selector expression which describes the"
                " conditions of the k8s resource in which it is acceptable to proceed"
                " to the following step"
            ),
        ),
    ] = None


class Data(BaseModel):
    source: Annotated[
        DataSource,
        Field(description="Source sources external data into a data template"),
    ]
    transformation: Annotated[
        List[TransformationStep],
        Field(description="Transformation applies a set of transformations"),
    ]


class Arguments(BaseModel):
    artifacts: Annotated[
        Optional[List[Artifact]],
        Field(description=("Artifacts is the list of artifacts to pass to the template or workflow")),
    ] = None
    parameters: Annotated[
        Optional[List[Parameter]],
        Field(description=("Parameters is the list of parameters to pass to the template or workflow")),
    ] = None


class InfoResponse(BaseModel):
    columns: Optional[List[Column]] = None
    links: Optional[List[Link]] = None
    managed_namespace: Annotated[Optional[str], Field(alias="managedNamespace")] = None
    modals: Annotated[Optional[Dict[str, bool]], Field(title="which modals to show")] = None
    nav_color: Annotated[Optional[str], Field(alias="navColor")] = None


class Inputs(BaseModel):
    artifacts: Annotated[
        Optional[List[Artifact]],
        Field(description="Artifact are a list of artifacts passed as inputs"),
    ] = None
    parameters: Annotated[
        Optional[List[Parameter]],
        Field(description="Parameters are a list of parameters passed as inputs"),
    ] = None


class Metrics(BaseModel):
    prometheus: Annotated[
        Optional[List[Prometheus]],
        Field(description="Prometheus is a list of prometheus metrics to be emitted"),
    ] = None


class Outputs(BaseModel):
    artifacts: Annotated[
        Optional[List[Artifact]],
        Field(description=("Artifacts holds the list of output artifacts produced by a step")),
    ] = None
    exit_code: Annotated[
        Optional[str],
        Field(
            alias="exitCode",
            description="ExitCode holds the exit code of a script template",
        ),
    ] = None
    parameters: Annotated[
        Optional[List[Parameter]],
        Field(description=("Parameters holds the list of output parameters produced by a step")),
    ] = None
    result: Annotated[
        Optional[str],
        Field(
            description=(
                "Result holds the result (stdout) of a script or container template, or"
                " the response body of an HTTP template"
            )
        ),
    ] = None


class LifecycleHook(BaseModel):
    arguments: Annotated[
        Optional[Arguments],
        Field(description="Arguments hold arguments to the template"),
    ] = None
    expression: Annotated[
        Optional[str],
        Field(
            description=(
                "Expression is a condition expression for when a node will be retried."
                " If it evaluates to false, the node will not be retried and the retry"
                " strategy will be ignored"
            )
        ),
    ] = None
    template: Annotated[
        Optional[str],
        Field(description="Template is the name of the template to execute by the hook"),
    ] = None
    template_ref: Annotated[
        Optional[TemplateRef],
        Field(
            alias="templateRef",
            description=("TemplateRef is the reference to the template resource to execute by the hook"),
        ),
    ] = None


class HTTP(BaseModel):
    body: Annotated[Optional[str], Field(description="Body is content of the HTTP Request")] = None
    body_from: Annotated[
        Optional[HTTPBodySource],
        Field(
            alias="bodyFrom",
            description="BodyFrom is  content of the HTTP Request as Bytes",
        ),
    ] = None
    headers: Annotated[
        Optional[List[HTTPHeader]],
        Field(description=("Headers are an optional list of headers to send with HTTP requests")),
    ] = None
    insecure_skip_verify: Annotated[
        Optional[bool],
        Field(
            alias="insecureSkipVerify",
            description=(
                "InsecureSkipVerify is a bool when if set to true will skip TLS verification for the HTTP client"
            ),
        ),
    ] = None
    method: Annotated[Optional[str], Field(description="Method is HTTP methods for HTTP Request")] = None
    success_condition: Annotated[
        Optional[str],
        Field(
            alias="successCondition",
            description=("SuccessCondition is an expression if evaluated to true is considered successful"),
        ),
    ] = None
    timeout_seconds: Annotated[
        Optional[int],
        Field(
            alias="timeoutSeconds",
            description=("TimeoutSeconds is request timeout for HTTP Request. Default is 30 seconds"),
        ),
    ] = None
    url: Annotated[str, Field(description="URL of the HTTP Request")]


class NodeStatus(BaseModel):
    boundary_id: Annotated[
        Optional[str],
        Field(
            alias="boundaryID",
            description=(
                "BoundaryID indicates the node ID of the associated template root node in which this node belongs to"
            ),
        ),
    ] = None
    children: Annotated[Optional[List[str]], Field(description="Children is a list of child node IDs")] = None
    daemoned: Annotated[
        Optional[bool],
        Field(description=("Daemoned tracks whether or not this node was daemoned and need to be terminated")),
    ] = None
    display_name: Annotated[
        Optional[str],
        Field(
            alias="displayName",
            description=(
                "DisplayName is a human readable representation of the node. Unique within a template boundary"
            ),
        ),
    ] = None
    estimated_duration: Annotated[
        Optional[int],
        Field(alias="estimatedDuration", description="EstimatedDuration in seconds."),
    ] = None
    finished_at: Annotated[
        Optional[v1_1.Time],
        Field(alias="finishedAt", description="Time at which this node completed"),
    ] = None
    host_node_name: Annotated[
        Optional[str],
        Field(
            alias="hostNodeName",
            description=("HostNodeName name of the Kubernetes node on which the Pod is running, if applicable"),
        ),
    ] = None
    id: Annotated[
        str,
        Field(
            description=(
                "ID is a unique identifier of a node within the worklow It is"
                " implemented as a hash of the node name, which makes the ID"
                " deterministic"
            )
        ),
    ]
    inputs: Annotated[
        Optional[Inputs],
        Field(
            description=(
                "Inputs captures input parameter values and artifact locations supplied to this template invocation"
            )
        ),
    ] = None
    memoization_status: Annotated[
        Optional[MemoizationStatus],
        Field(
            alias="memoizationStatus",
            description="MemoizationStatus holds information about cached nodes",
        ),
    ] = None
    message: Annotated[
        Optional[str],
        Field(description=("A human readable message indicating details about why the node is in this condition.")),
    ] = None
    name: Annotated[
        str,
        Field(description=("Name is unique name in the node tree used to generate the node ID")),
    ]
    node_flag: Annotated[
        Optional[NodeFlag],
        Field(
            alias="nodeFlag",
            description=("NodeFlag tracks some history of node. e.g.) hooked, retried, etc."),
        ),
    ] = None
    outbound_nodes: Annotated[
        Optional[List[str]],
        Field(
            alias="outboundNodes",
            description=(
                'OutboundNodes tracks the node IDs which are considered "outbound"'
                " nodes to a template invocation. For every invocation of a template,"
                ' there are nodes which we considered as "outbound". Essentially, these'
                " are last nodes in the execution sequence to run, before the template"
                " is considered completed. These nodes are then connected as parents to"
                " a following step.\n\nIn the case of single pod steps (i.e. container,"
                " script, resource templates), this list will be nil since the pod"
                ' itself is already considered the "outbound" node. In the case of'
                ' DAGs, outbound nodes are the "target" tasks (tasks with no children).'
                " In the case of steps, outbound nodes are all the containers involved"
                " in the last step group. NOTE: since templates are composable, the"
                " list of outbound nodes are carried upwards when a DAG/steps template"
                " invokes another DAG/steps template. In other words, the outbound"
                " nodes of a template, will be a superset of the outbound nodes of its"
                " last children."
            ),
        ),
    ] = None
    outputs: Annotated[
        Optional[Outputs],
        Field(
            description=(
                "Outputs captures output parameter values and artifact locations produced by this template invocation"
            )
        ),
    ] = None
    phase: Annotated[
        Optional[str],
        Field(
            description=(
                "Phase a simple, high-level summary of where the node is in its"
                " lifecycle. Can be used as a state machine. Will be one of these"
                ' values "Pending", "Running" before the node is completed, or'
                ' "Succeeded", "Skipped", "Failed", "Error", or "Omitted" as a final'
                " state."
            )
        ),
    ] = None
    pod_ip: Annotated[
        Optional[str],
        Field(
            alias="podIP",
            description="PodIP captures the IP of the pod for daemoned steps",
        ),
    ] = None
    progress: Annotated[Optional[str], Field(description="Progress to completion")] = None
    resources_duration: Annotated[
        Optional[Dict[str, int]],
        Field(
            alias="resourcesDuration",
            description=(
                "ResourcesDuration is indicative, but not accurate, resource duration."
                " This is populated when the nodes completes."
            ),
        ),
    ] = None
    started_at: Annotated[
        Optional[v1_1.Time],
        Field(alias="startedAt", description="Time at which this node started"),
    ] = None
    synchronization_status: Annotated[
        Optional[NodeSynchronizationStatus],
        Field(
            alias="synchronizationStatus",
            description=("SynchronizationStatus is the synchronization status of the node"),
        ),
    ] = None
    task_result_synced: Annotated[
        Optional[bool],
        Field(
            alias="taskResultSynced",
            description=("TaskResultSynced is used to determine if the node's output has been received"),
        ),
    ] = None
    template_name: Annotated[
        Optional[str],
        Field(
            alias="templateName",
            description=(
                "TemplateName is the template name which this node corresponds to. Not"
                " applicable to virtual nodes (e.g. Retry, StepGroup)"
            ),
        ),
    ] = None
    template_ref: Annotated[
        Optional[TemplateRef],
        Field(
            alias="templateRef",
            description=(
                "TemplateRef is the reference to the template resource which this node"
                " corresponds to. Not applicable to virtual nodes (e.g. Retry,"
                " StepGroup)"
            ),
        ),
    ] = None
    template_scope: Annotated[
        Optional[str],
        Field(
            alias="templateScope",
            description=("TemplateScope is the template scope in which the template of this node was retrieved."),
        ),
    ] = None
    type: Annotated[str, Field(description="Type indicates type of node")]


class PodGC(BaseModel):
    delete_delay_duration: Annotated[
        Optional[str],
        Field(
            alias="deleteDelayDuration",
            description=("DeleteDelayDuration specifies the duration before pods in the GC queue get deleted."),
        ),
    ] = None
    label_selector: Annotated[
        Optional[v1_1.LabelSelector],
        Field(
            alias="labelSelector",
            description=(
                "LabelSelector is the label selector to check if the pods match the"
                " labels before being added to the pod GC queue."
            ),
        ),
    ] = None
    strategy: Annotated[
        Optional[str],
        Field(
            description=(
                'Strategy is the strategy to use. One of "OnPodCompletion",'
                ' "OnPodSuccess", "OnWorkflowCompletion", "OnWorkflowSuccess". If'
                " unset, does not delete Pods"
            )
        ),
    ] = None


class Submit(BaseModel):
    arguments: Annotated[
        Optional[Arguments],
        Field(description=("Arguments extracted from the event and then set as arguments to the workflow created.")),
    ] = None
    metadata: Annotated[
        Optional[v1_1.ObjectMeta],
        Field(description=("Metadata optional means to customize select fields of the workflow metadata")),
    ] = None
    workflow_template_ref: Annotated[
        WorkflowTemplateRef,
        Field(
            alias="workflowTemplateRef",
            description="WorkflowTemplateRef the workflow template to submit",
        ),
    ]


class WorkflowEventBindingSpec(BaseModel):
    event: Annotated[Event, Field(description="Event is the event to bind to")]
    submit: Annotated[Optional[Submit], Field(description="Submit is the workflow template to submit")] = None


class WorkflowEventBinding(BaseModel):
    api_version: Annotated[
        Optional[str],
        Field(
            alias="apiVersion",
            description=(
                "APIVersion defines the versioned schema of this representation of an"
                " object. Servers should convert recognized schemas to the latest"
                " internal value, and may reject unrecognized values. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
            ),
        ),
    ] = None
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "Kind is a string value representing the REST resource this object"
                " represents. Servers may infer this from the endpoint the client"
                " submits requests to. Cannot be updated. In CamelCase. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
            )
        ),
    ] = None
    metadata: v1_1.ObjectMeta
    spec: WorkflowEventBindingSpec


class ContainerNode(BaseModel):
    args: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Arguments to the entrypoint. The container image's CMD is used if"
                " this is not provided. Variable references $(VAR_NAME) are expanded"
                " using the container's environment. If a variable cannot be resolved,"
                " the reference in the input string will be unchanged. Double $$ are"
                " reduced to a single $, which allows for escaping the $(VAR_NAME)"
                ' syntax: i.e. "$$(VAR_NAME)" will produce the string literal'
                ' "$(VAR_NAME)". Escaped references will never be expanded, regardless'
                " of whether the variable exists or not. Cannot be updated. More info:"
                " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
            )
        ),
    ] = None
    command: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Entrypoint array. Not executed within a shell. The container image's"
                " ENTRYPOINT is used if this is not provided. Variable references"
                " $(VAR_NAME) are expanded using the container's environment. If a"
                " variable cannot be resolved, the reference in the input string will"
                " be unchanged. Double $$ are reduced to a single $, which allows for"
                ' escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the'
                ' string literal "$(VAR_NAME)". Escaped references will never be'
                " expanded, regardless of whether the variable exists or not. Cannot be"
                " updated. More info:"
                " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
            )
        ),
    ] = None
    dependencies: Optional[List[str]] = None
    env: Annotated[
        Optional[List[v1.EnvVar]],
        Field(description=("List of environment variables to set in the container. Cannot be updated.")),
    ] = None
    env_from: Annotated[
        Optional[List[v1.EnvFromSource]],
        Field(
            alias="envFrom",
            description=(
                "List of sources to populate environment variables in the container."
                " The keys defined within a source must be a C_IDENTIFIER. All invalid"
                " keys will be reported as an event when the container is starting."
                " When a key exists in multiple sources, the value associated with the"
                " last source will take precedence. Values defined by an Env with a"
                " duplicate key will take precedence. Cannot be updated."
            ),
        ),
    ] = None
    image: Annotated[
        Optional[str],
        Field(
            description=(
                "Container image name. More info:"
                " https://kubernetes.io/docs/concepts/containers/images This field is"
                " optional to allow higher level config management to default or"
                " override container images in workload controllers like Deployments"
                " and StatefulSets."
            )
        ),
    ] = None
    image_pull_policy: Annotated[
        Optional[str],
        Field(
            alias="imagePullPolicy",
            description=(
                "Image pull policy. One of Always, Never, IfNotPresent. Defaults to"
                " Always if :latest tag is specified, or IfNotPresent otherwise. Cannot"
                " be updated. More info:"
                " https://kubernetes.io/docs/concepts/containers/images#updating-images"
            ),
        ),
    ] = None
    lifecycle: Annotated[
        Optional[v1.Lifecycle],
        Field(
            description=(
                "Actions that the management system should take in response to"
                " container lifecycle events. Cannot be updated."
            )
        ),
    ] = None
    liveness_probe: Annotated[
        Optional[v1.Probe],
        Field(
            alias="livenessProbe",
            description=(
                "Periodic probe of container liveness. Container will be restarted if"
                " the probe fails. Cannot be updated. More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None
    name: Annotated[
        str,
        Field(
            description=(
                "Name of the container specified as a DNS_LABEL. Each container in a"
                " pod must have a unique name (DNS_LABEL). Cannot be updated."
            )
        ),
    ]
    ports: Annotated[
        Optional[List[v1.ContainerPort]],
        Field(
            description=(
                "List of ports to expose from the container. Not specifying a port here"
                " DOES NOT prevent that port from being exposed. Any port which is"
                ' listening on the default "0.0.0.0" address inside a container will be'
                " accessible from the network. Modifying this array with strategic"
                " merge patch may corrupt the data. For more information See"
                " https://github.com/kubernetes/kubernetes/issues/108255. Cannot be"
                " updated."
            )
        ),
    ] = None
    readiness_probe: Annotated[
        Optional[v1.Probe],
        Field(
            alias="readinessProbe",
            description=(
                "Periodic probe of container service readiness. Container will be"
                " removed from service endpoints if the probe fails. Cannot be updated."
                " More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None
    resize_policy: Annotated[
        Optional[List[v1.ContainerResizePolicy]],
        Field(
            alias="resizePolicy",
            description="Resources resize policy for the container.",
        ),
    ] = None
    resources: Annotated[
        Optional[v1.ResourceRequirements],
        Field(
            description=(
                "Compute Resources required by this container. Cannot be updated. More"
                " info:"
                " https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"
            )
        ),
    ] = None
    restart_policy: Annotated[
        Optional[str],
        Field(
            alias="restartPolicy",
            description=(
                "RestartPolicy defines the restart behavior of individual containers in"
                " a pod. This field may only be set for init containers, and the only"
                ' allowed value is "Always". For non-init containers or when this field'
                " is not specified, the restart behavior is defined by the Pod's"
                " restart policy and the container type. Setting the RestartPolicy as"
                ' "Always" for the init container will have the following effect: this'
                " init container will be continually restarted on exit until all"
                " regular containers have terminated. Once all regular containers have"
                ' completed, all init containers with restartPolicy "Always" will be'
                " shut down. This lifecycle differs from normal init containers and is"
                ' often referred to as a "sidecar" container. Although this init'
                " container still starts in the init container sequence, it does not"
                " wait for the container to complete before proceeding to the next init"
                " container. Instead, the next init container starts immediately after"
                " this init container is started, or after any startupProbe has"
                " successfully completed."
            ),
        ),
    ] = None
    security_context: Annotated[
        Optional[v1.SecurityContext],
        Field(
            alias="securityContext",
            description=(
                "SecurityContext defines the security options the container should be"
                " run with. If set, the fields of SecurityContext override the"
                " equivalent fields of PodSecurityContext. More info:"
                " https://kubernetes.io/docs/tasks/configure-pod-container/security-context/"
            ),
        ),
    ] = None
    startup_probe: Annotated[
        Optional[v1.Probe],
        Field(
            alias="startupProbe",
            description=(
                "StartupProbe indicates that the Pod has successfully initialized. If"
                " specified, no other probes are executed until this completes"
                " successfully. If this probe fails, the Pod will be restarted, just as"
                " if the livenessProbe failed. This can be used to provide different"
                " probe parameters at the beginning of a Pod's lifecycle, when it might"
                " take a long time to load data or warm a cache, than during"
                " steady-state operation. This cannot be updated. More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None
    stdin: Annotated[
        Optional[bool],
        Field(
            description=(
                "Whether this container should allocate a buffer for stdin in the"
                " container runtime. If this is not set, reads from stdin in the"
                " container will always result in EOF. Default is false."
            )
        ),
    ] = None
    stdin_once: Annotated[
        Optional[bool],
        Field(
            alias="stdinOnce",
            description=(
                "Whether the container runtime should close the stdin channel after it"
                " has been opened by a single attach. When stdin is true the stdin"
                " stream will remain open across multiple attach sessions. If stdinOnce"
                " is set to true, stdin is opened on container start, is empty until"
                " the first client attaches to stdin, and then remains open and accepts"
                " data until the client disconnects, at which time stdin is closed and"
                " remains closed until the container is restarted. If this flag is"
                " false, a container processes that reads from stdin will never receive"
                " an EOF. Default is false"
            ),
        ),
    ] = None
    termination_message_path: Annotated[
        Optional[str],
        Field(
            alias="terminationMessagePath",
            description=(
                "Optional: Path at which the file to which the container's termination"
                " message will be written is mounted into the container's filesystem."
                " Message written is intended to be brief final status, such as an"
                " assertion failure message. Will be truncated by the node if greater"
                " than 4096 bytes. The total message length across all containers will"
                " be limited to 12kb. Defaults to /dev/termination-log. Cannot be"
                " updated."
            ),
        ),
    ] = None
    termination_message_policy: Annotated[
        Optional[str],
        Field(
            alias="terminationMessagePolicy",
            description=(
                "Indicate how the termination message should be populated. File will"
                " use the contents of terminationMessagePath to populate the container"
                " status message on both success and failure. FallbackToLogsOnError"
                " will use the last chunk of container log output if the termination"
                " message file is empty and the container exited with an error. The log"
                " output is limited to 2048 bytes or 80 lines, whichever is smaller."
                " Defaults to File. Cannot be updated."
            ),
        ),
    ] = None
    tty: Annotated[
        Optional[bool],
        Field(
            description=(
                "Whether this container should allocate a TTY for itself, also requires"
                " 'stdin' to be true. Default is false."
            )
        ),
    ] = None
    volume_devices: Annotated[
        Optional[List[v1.VolumeDevice]],
        Field(
            alias="volumeDevices",
            description=("volumeDevices is the list of block devices to be used by the container."),
        ),
    ] = None
    volume_mounts: Annotated[
        Optional[List[v1.VolumeMount]],
        Field(
            alias="volumeMounts",
            description=("Pod volumes to mount into the container's filesystem. Cannot be updated."),
        ),
    ] = None
    working_dir: Annotated[
        Optional[str],
        Field(
            alias="workingDir",
            description=(
                "Container's working directory. If not specified, the container"
                " runtime's default will be used, which might be configured in the"
                " container image. Cannot be updated."
            ),
        ),
    ] = None


class ScriptTemplate(BaseModel):
    args: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Arguments to the entrypoint. The container image's CMD is used if"
                " this is not provided. Variable references $(VAR_NAME) are expanded"
                " using the container's environment. If a variable cannot be resolved,"
                " the reference in the input string will be unchanged. Double $$ are"
                " reduced to a single $, which allows for escaping the $(VAR_NAME)"
                ' syntax: i.e. "$$(VAR_NAME)" will produce the string literal'
                ' "$(VAR_NAME)". Escaped references will never be expanded, regardless'
                " of whether the variable exists or not. Cannot be updated. More info:"
                " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
            )
        ),
    ] = None
    command: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Entrypoint array. Not executed within a shell. The container image's"
                " ENTRYPOINT is used if this is not provided. Variable references"
                " $(VAR_NAME) are expanded using the container's environment. If a"
                " variable cannot be resolved, the reference in the input string will"
                " be unchanged. Double $$ are reduced to a single $, which allows for"
                ' escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the'
                ' string literal "$(VAR_NAME)". Escaped references will never be'
                " expanded, regardless of whether the variable exists or not. Cannot be"
                " updated. More info:"
                " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
            )
        ),
    ] = None
    env: Annotated[
        Optional[List[v1.EnvVar]],
        Field(description=("List of environment variables to set in the container. Cannot be updated.")),
    ] = None
    env_from: Annotated[
        Optional[List[v1.EnvFromSource]],
        Field(
            alias="envFrom",
            description=(
                "List of sources to populate environment variables in the container."
                " The keys defined within a source must be a C_IDENTIFIER. All invalid"
                " keys will be reported as an event when the container is starting."
                " When a key exists in multiple sources, the value associated with the"
                " last source will take precedence. Values defined by an Env with a"
                " duplicate key will take precedence. Cannot be updated."
            ),
        ),
    ] = None
    image: Annotated[
        str,
        Field(
            description=(
                "Container image name. More info:"
                " https://kubernetes.io/docs/concepts/containers/images This field is"
                " optional to allow higher level config management to default or"
                " override container images in workload controllers like Deployments"
                " and StatefulSets."
            )
        ),
    ]
    image_pull_policy: Annotated[
        Optional[str],
        Field(
            alias="imagePullPolicy",
            description=(
                "Image pull policy. One of Always, Never, IfNotPresent. Defaults to"
                " Always if :latest tag is specified, or IfNotPresent otherwise. Cannot"
                " be updated. More info:"
                " https://kubernetes.io/docs/concepts/containers/images#updating-images"
            ),
        ),
    ] = None
    lifecycle: Annotated[
        Optional[v1.Lifecycle],
        Field(
            description=(
                "Actions that the management system should take in response to"
                " container lifecycle events. Cannot be updated."
            )
        ),
    ] = None
    liveness_probe: Annotated[
        Optional[v1.Probe],
        Field(
            alias="livenessProbe",
            description=(
                "Periodic probe of container liveness. Container will be restarted if"
                " the probe fails. Cannot be updated. More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "Name of the container specified as a DNS_LABEL. Each container in a"
                " pod must have a unique name (DNS_LABEL). Cannot be updated."
            )
        ),
    ] = None
    ports: Annotated[
        Optional[List[v1.ContainerPort]],
        Field(
            description=(
                "List of ports to expose from the container. Not specifying a port here"
                " DOES NOT prevent that port from being exposed. Any port which is"
                ' listening on the default "0.0.0.0" address inside a container will be'
                " accessible from the network. Modifying this array with strategic"
                " merge patch may corrupt the data. For more information See"
                " https://github.com/kubernetes/kubernetes/issues/108255. Cannot be"
                " updated."
            )
        ),
    ] = None
    readiness_probe: Annotated[
        Optional[v1.Probe],
        Field(
            alias="readinessProbe",
            description=(
                "Periodic probe of container service readiness. Container will be"
                " removed from service endpoints if the probe fails. Cannot be updated."
                " More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None
    resize_policy: Annotated[
        Optional[List[v1.ContainerResizePolicy]],
        Field(
            alias="resizePolicy",
            description="Resources resize policy for the container.",
        ),
    ] = None
    resources: Annotated[
        Optional[v1.ResourceRequirements],
        Field(
            description=(
                "Compute Resources required by this container. Cannot be updated. More"
                " info:"
                " https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"
            )
        ),
    ] = None
    restart_policy: Annotated[
        Optional[str],
        Field(
            alias="restartPolicy",
            description=(
                "RestartPolicy defines the restart behavior of individual containers in"
                " a pod. This field may only be set for init containers, and the only"
                ' allowed value is "Always". For non-init containers or when this field'
                " is not specified, the restart behavior is defined by the Pod's"
                " restart policy and the container type. Setting the RestartPolicy as"
                ' "Always" for the init container will have the following effect: this'
                " init container will be continually restarted on exit until all"
                " regular containers have terminated. Once all regular containers have"
                ' completed, all init containers with restartPolicy "Always" will be'
                " shut down. This lifecycle differs from normal init containers and is"
                ' often referred to as a "sidecar" container. Although this init'
                " container still starts in the init container sequence, it does not"
                " wait for the container to complete before proceeding to the next init"
                " container. Instead, the next init container starts immediately after"
                " this init container is started, or after any startupProbe has"
                " successfully completed."
            ),
        ),
    ] = None
    security_context: Annotated[
        Optional[v1.SecurityContext],
        Field(
            alias="securityContext",
            description=(
                "SecurityContext defines the security options the container should be"
                " run with. If set, the fields of SecurityContext override the"
                " equivalent fields of PodSecurityContext. More info:"
                " https://kubernetes.io/docs/tasks/configure-pod-container/security-context/"
            ),
        ),
    ] = None
    source: Annotated[
        str,
        Field(description="Source contains the source code of the script to execute"),
    ]
    startup_probe: Annotated[
        Optional[v1.Probe],
        Field(
            alias="startupProbe",
            description=(
                "StartupProbe indicates that the Pod has successfully initialized. If"
                " specified, no other probes are executed until this completes"
                " successfully. If this probe fails, the Pod will be restarted, just as"
                " if the livenessProbe failed. This can be used to provide different"
                " probe parameters at the beginning of a Pod's lifecycle, when it might"
                " take a long time to load data or warm a cache, than during"
                " steady-state operation. This cannot be updated. More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None
    stdin: Annotated[
        Optional[bool],
        Field(
            description=(
                "Whether this container should allocate a buffer for stdin in the"
                " container runtime. If this is not set, reads from stdin in the"
                " container will always result in EOF. Default is false."
            )
        ),
    ] = None
    stdin_once: Annotated[
        Optional[bool],
        Field(
            alias="stdinOnce",
            description=(
                "Whether the container runtime should close the stdin channel after it"
                " has been opened by a single attach. When stdin is true the stdin"
                " stream will remain open across multiple attach sessions. If stdinOnce"
                " is set to true, stdin is opened on container start, is empty until"
                " the first client attaches to stdin, and then remains open and accepts"
                " data until the client disconnects, at which time stdin is closed and"
                " remains closed until the container is restarted. If this flag is"
                " false, a container processes that reads from stdin will never receive"
                " an EOF. Default is false"
            ),
        ),
    ] = None
    termination_message_path: Annotated[
        Optional[str],
        Field(
            alias="terminationMessagePath",
            description=(
                "Optional: Path at which the file to which the container's termination"
                " message will be written is mounted into the container's filesystem."
                " Message written is intended to be brief final status, such as an"
                " assertion failure message. Will be truncated by the node if greater"
                " than 4096 bytes. The total message length across all containers will"
                " be limited to 12kb. Defaults to /dev/termination-log. Cannot be"
                " updated."
            ),
        ),
    ] = None
    termination_message_policy: Annotated[
        Optional[str],
        Field(
            alias="terminationMessagePolicy",
            description=(
                "Indicate how the termination message should be populated. File will"
                " use the contents of terminationMessagePath to populate the container"
                " status message on both success and failure. FallbackToLogsOnError"
                " will use the last chunk of container log output if the termination"
                " message file is empty and the container exited with an error. The log"
                " output is limited to 2048 bytes or 80 lines, whichever is smaller."
                " Defaults to File. Cannot be updated."
            ),
        ),
    ] = None
    tty: Annotated[
        Optional[bool],
        Field(
            description=(
                "Whether this container should allocate a TTY for itself, also requires"
                " 'stdin' to be true. Default is false."
            )
        ),
    ] = None
    volume_devices: Annotated[
        Optional[List[v1.VolumeDevice]],
        Field(
            alias="volumeDevices",
            description=("volumeDevices is the list of block devices to be used by the container."),
        ),
    ] = None
    volume_mounts: Annotated[
        Optional[List[v1.VolumeMount]],
        Field(
            alias="volumeMounts",
            description=("Pod volumes to mount into the container's filesystem. Cannot be updated."),
        ),
    ] = None
    working_dir: Annotated[
        Optional[str],
        Field(
            alias="workingDir",
            description=(
                "Container's working directory. If not specified, the container"
                " runtime's default will be used, which might be configured in the"
                " container image. Cannot be updated."
            ),
        ),
    ] = None


class UserContainer(BaseModel):
    args: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Arguments to the entrypoint. The container image's CMD is used if"
                " this is not provided. Variable references $(VAR_NAME) are expanded"
                " using the container's environment. If a variable cannot be resolved,"
                " the reference in the input string will be unchanged. Double $$ are"
                " reduced to a single $, which allows for escaping the $(VAR_NAME)"
                ' syntax: i.e. "$$(VAR_NAME)" will produce the string literal'
                ' "$(VAR_NAME)". Escaped references will never be expanded, regardless'
                " of whether the variable exists or not. Cannot be updated. More info:"
                " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
            )
        ),
    ] = None
    command: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Entrypoint array. Not executed within a shell. The container image's"
                " ENTRYPOINT is used if this is not provided. Variable references"
                " $(VAR_NAME) are expanded using the container's environment. If a"
                " variable cannot be resolved, the reference in the input string will"
                " be unchanged. Double $$ are reduced to a single $, which allows for"
                ' escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the'
                ' string literal "$(VAR_NAME)". Escaped references will never be'
                " expanded, regardless of whether the variable exists or not. Cannot be"
                " updated. More info:"
                " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
            )
        ),
    ] = None
    env: Annotated[
        Optional[List[v1.EnvVar]],
        Field(description=("List of environment variables to set in the container. Cannot be updated.")),
    ] = None
    env_from: Annotated[
        Optional[List[v1.EnvFromSource]],
        Field(
            alias="envFrom",
            description=(
                "List of sources to populate environment variables in the container."
                " The keys defined within a source must be a C_IDENTIFIER. All invalid"
                " keys will be reported as an event when the container is starting."
                " When a key exists in multiple sources, the value associated with the"
                " last source will take precedence. Values defined by an Env with a"
                " duplicate key will take precedence. Cannot be updated."
            ),
        ),
    ] = None
    image: Annotated[
        Optional[str],
        Field(
            description=(
                "Container image name. More info:"
                " https://kubernetes.io/docs/concepts/containers/images This field is"
                " optional to allow higher level config management to default or"
                " override container images in workload controllers like Deployments"
                " and StatefulSets."
            )
        ),
    ] = None
    image_pull_policy: Annotated[
        Optional[str],
        Field(
            alias="imagePullPolicy",
            description=(
                "Image pull policy. One of Always, Never, IfNotPresent. Defaults to"
                " Always if :latest tag is specified, or IfNotPresent otherwise. Cannot"
                " be updated. More info:"
                " https://kubernetes.io/docs/concepts/containers/images#updating-images"
            ),
        ),
    ] = None
    lifecycle: Annotated[
        Optional[v1.Lifecycle],
        Field(
            description=(
                "Actions that the management system should take in response to"
                " container lifecycle events. Cannot be updated."
            )
        ),
    ] = None
    liveness_probe: Annotated[
        Optional[v1.Probe],
        Field(
            alias="livenessProbe",
            description=(
                "Periodic probe of container liveness. Container will be restarted if"
                " the probe fails. Cannot be updated. More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None
    mirror_volume_mounts: Annotated[
        Optional[bool],
        Field(
            alias="mirrorVolumeMounts",
            description=(
                "MirrorVolumeMounts will mount the same volumes specified in the main"
                " container to the container (including artifacts), at the same"
                " mountPaths. This enables dind daemon to partially see the same"
                " filesystem as the main container in order to use features such as"
                " docker volume binding"
            ),
        ),
    ] = None
    name: Annotated[
        str,
        Field(
            description=(
                "Name of the container specified as a DNS_LABEL. Each container in a"
                " pod must have a unique name (DNS_LABEL). Cannot be updated."
            )
        ),
    ]
    ports: Annotated[
        Optional[List[v1.ContainerPort]],
        Field(
            description=(
                "List of ports to expose from the container. Not specifying a port here"
                " DOES NOT prevent that port from being exposed. Any port which is"
                ' listening on the default "0.0.0.0" address inside a container will be'
                " accessible from the network. Modifying this array with strategic"
                " merge patch may corrupt the data. For more information See"
                " https://github.com/kubernetes/kubernetes/issues/108255. Cannot be"
                " updated."
            )
        ),
    ] = None
    readiness_probe: Annotated[
        Optional[v1.Probe],
        Field(
            alias="readinessProbe",
            description=(
                "Periodic probe of container service readiness. Container will be"
                " removed from service endpoints if the probe fails. Cannot be updated."
                " More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None
    resize_policy: Annotated[
        Optional[List[v1.ContainerResizePolicy]],
        Field(
            alias="resizePolicy",
            description="Resources resize policy for the container.",
        ),
    ] = None
    resources: Annotated[
        Optional[v1.ResourceRequirements],
        Field(
            description=(
                "Compute Resources required by this container. Cannot be updated. More"
                " info:"
                " https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"
            )
        ),
    ] = None
    restart_policy: Annotated[
        Optional[str],
        Field(
            alias="restartPolicy",
            description=(
                "RestartPolicy defines the restart behavior of individual containers in"
                " a pod. This field may only be set for init containers, and the only"
                ' allowed value is "Always". For non-init containers or when this field'
                " is not specified, the restart behavior is defined by the Pod's"
                " restart policy and the container type. Setting the RestartPolicy as"
                ' "Always" for the init container will have the following effect: this'
                " init container will be continually restarted on exit until all"
                " regular containers have terminated. Once all regular containers have"
                ' completed, all init containers with restartPolicy "Always" will be'
                " shut down. This lifecycle differs from normal init containers and is"
                ' often referred to as a "sidecar" container. Although this init'
                " container still starts in the init container sequence, it does not"
                " wait for the container to complete before proceeding to the next init"
                " container. Instead, the next init container starts immediately after"
                " this init container is started, or after any startupProbe has"
                " successfully completed."
            ),
        ),
    ] = None
    security_context: Annotated[
        Optional[v1.SecurityContext],
        Field(
            alias="securityContext",
            description=(
                "SecurityContext defines the security options the container should be"
                " run with. If set, the fields of SecurityContext override the"
                " equivalent fields of PodSecurityContext. More info:"
                " https://kubernetes.io/docs/tasks/configure-pod-container/security-context/"
            ),
        ),
    ] = None
    startup_probe: Annotated[
        Optional[v1.Probe],
        Field(
            alias="startupProbe",
            description=(
                "StartupProbe indicates that the Pod has successfully initialized. If"
                " specified, no other probes are executed until this completes"
                " successfully. If this probe fails, the Pod will be restarted, just as"
                " if the livenessProbe failed. This can be used to provide different"
                " probe parameters at the beginning of a Pod's lifecycle, when it might"
                " take a long time to load data or warm a cache, than during"
                " steady-state operation. This cannot be updated. More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None
    stdin: Annotated[
        Optional[bool],
        Field(
            description=(
                "Whether this container should allocate a buffer for stdin in the"
                " container runtime. If this is not set, reads from stdin in the"
                " container will always result in EOF. Default is false."
            )
        ),
    ] = None
    stdin_once: Annotated[
        Optional[bool],
        Field(
            alias="stdinOnce",
            description=(
                "Whether the container runtime should close the stdin channel after it"
                " has been opened by a single attach. When stdin is true the stdin"
                " stream will remain open across multiple attach sessions. If stdinOnce"
                " is set to true, stdin is opened on container start, is empty until"
                " the first client attaches to stdin, and then remains open and accepts"
                " data until the client disconnects, at which time stdin is closed and"
                " remains closed until the container is restarted. If this flag is"
                " false, a container processes that reads from stdin will never receive"
                " an EOF. Default is false"
            ),
        ),
    ] = None
    termination_message_path: Annotated[
        Optional[str],
        Field(
            alias="terminationMessagePath",
            description=(
                "Optional: Path at which the file to which the container's termination"
                " message will be written is mounted into the container's filesystem."
                " Message written is intended to be brief final status, such as an"
                " assertion failure message. Will be truncated by the node if greater"
                " than 4096 bytes. The total message length across all containers will"
                " be limited to 12kb. Defaults to /dev/termination-log. Cannot be"
                " updated."
            ),
        ),
    ] = None
    termination_message_policy: Annotated[
        Optional[str],
        Field(
            alias="terminationMessagePolicy",
            description=(
                "Indicate how the termination message should be populated. File will"
                " use the contents of terminationMessagePath to populate the container"
                " status message on both success and failure. FallbackToLogsOnError"
                " will use the last chunk of container log output if the termination"
                " message file is empty and the container exited with an error. The log"
                " output is limited to 2048 bytes or 80 lines, whichever is smaller."
                " Defaults to File. Cannot be updated."
            ),
        ),
    ] = None
    tty: Annotated[
        Optional[bool],
        Field(
            description=(
                "Whether this container should allocate a TTY for itself, also requires"
                " 'stdin' to be true. Default is false."
            )
        ),
    ] = None
    volume_devices: Annotated[
        Optional[List[v1.VolumeDevice]],
        Field(
            alias="volumeDevices",
            description=("volumeDevices is the list of block devices to be used by the container."),
        ),
    ] = None
    volume_mounts: Annotated[
        Optional[List[v1.VolumeMount]],
        Field(
            alias="volumeMounts",
            description=("Pod volumes to mount into the container's filesystem. Cannot be updated."),
        ),
    ] = None
    working_dir: Annotated[
        Optional[str],
        Field(
            alias="workingDir",
            description=(
                "Container's working directory. If not specified, the container"
                " runtime's default will be used, which might be configured in the"
                " container image. Cannot be updated."
            ),
        ),
    ] = None


class WorkflowEventBindingList(BaseModel):
    api_version: Annotated[
        Optional[str],
        Field(
            alias="apiVersion",
            description=(
                "APIVersion defines the versioned schema of this representation of an"
                " object. Servers should convert recognized schemas to the latest"
                " internal value, and may reject unrecognized values. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
            ),
        ),
    ] = None
    items: Optional[List[WorkflowEventBinding]] = None
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "Kind is a string value representing the REST resource this object"
                " represents. Servers may infer this from the endpoint the client"
                " submits requests to. Cannot be updated. In CamelCase. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
            )
        ),
    ] = None
    metadata: v1_1.ListMeta


class ContainerSetTemplate(BaseModel):
    containers: List[ContainerNode]
    retry_strategy: Annotated[
        Optional[ContainerSetRetryStrategy],
        Field(
            alias="retryStrategy",
            description=(
                "RetryStrategy describes how to retry container nodes if the container"
                " set fails. Note that this works differently from the template-level"
                " `retryStrategy` as it is a process-level retry that does not create"
                " new Pods or containers."
            ),
        ),
    ] = None
    volume_mounts: Annotated[Optional[List[v1.VolumeMount]], Field(alias="volumeMounts")] = None


class DAGTemplate(BaseModel):
    fail_fast: Annotated[
        Optional[bool],
        Field(
            alias="failFast",
            description=(
                'This flag is for DAG logic. The DAG logic has a built-in "fail fast"'
                " feature to stop scheduling new steps, as soon as it detects that one"
                " of the DAG nodes is failed. Then it waits until all DAG nodes are"
                " completed before failing the DAG itself. The FailFast flag default is"
                " true,  if set to false, it will allow a DAG to run all branches of"
                " the DAG to completion (either success or failure), regardless of the"
                " failed outcomes of branches in the DAG. More info and example about"
                " this feature at"
                " https://github.com/argoproj/argo-workflows/issues/1442"
            ),
        ),
    ] = None
    target: Annotated[
        Optional[str],
        Field(description="Target are one or more names of targets to execute in a DAG"),
    ] = None
    tasks: Annotated[List[DAGTask], Field(description="Tasks are a list of DAG tasks")]


class ParallelSteps(BaseModel):
    __root__: List[WorkflowStep]


class ClusterWorkflowTemplateList(BaseModel):
    api_version: Annotated[
        Optional[str],
        Field(
            alias="apiVersion",
            description=(
                "APIVersion defines the versioned schema of this representation of an"
                " object. Servers should convert recognized schemas to the latest"
                " internal value, and may reject unrecognized values. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
            ),
        ),
    ] = None
    items: Optional[List[ClusterWorkflowTemplate]] = None
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "Kind is a string value representing the REST resource this object"
                " represents. Servers may infer this from the endpoint the client"
                " submits requests to. Cannot be updated. In CamelCase. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
            )
        ),
    ] = None
    metadata: v1_1.ListMeta


class CronWorkflowList(BaseModel):
    api_version: Annotated[
        Optional[str],
        Field(
            alias="apiVersion",
            description=(
                "APIVersion defines the versioned schema of this representation of an"
                " object. Servers should convert recognized schemas to the latest"
                " internal value, and may reject unrecognized values. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
            ),
        ),
    ] = None
    items: Optional[List[CronWorkflow]] = None
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "Kind is a string value representing the REST resource this object"
                " represents. Servers may infer this from the endpoint the client"
                " submits requests to. Cannot be updated. In CamelCase. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
            )
        ),
    ] = None
    metadata: v1_1.ListMeta


class WorkflowList(BaseModel):
    api_version: Annotated[
        Optional[str],
        Field(
            alias="apiVersion",
            description=(
                "APIVersion defines the versioned schema of this representation of an"
                " object. Servers should convert recognized schemas to the latest"
                " internal value, and may reject unrecognized values. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
            ),
        ),
    ] = None
    items: Optional[List[Workflow]] = None
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "Kind is a string value representing the REST resource this object"
                " represents. Servers may infer this from the endpoint the client"
                " submits requests to. Cannot be updated. In CamelCase. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
            )
        ),
    ] = None
    metadata: v1_1.ListMeta


class WorkflowTemplateList(BaseModel):
    api_version: Annotated[
        Optional[str],
        Field(
            alias="apiVersion",
            description=(
                "APIVersion defines the versioned schema of this representation of an"
                " object. Servers should convert recognized schemas to the latest"
                " internal value, and may reject unrecognized values. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
            ),
        ),
    ] = None
    items: Optional[List[WorkflowTemplate]] = None
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "Kind is a string value representing the REST resource this object"
                " represents. Servers may infer this from the endpoint the client"
                " submits requests to. Cannot be updated. In CamelCase. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
            )
        ),
    ] = None
    metadata: v1_1.ListMeta


class Template(BaseModel):
    active_deadline_seconds: Annotated[
        Optional[intstr.IntOrString],
        Field(
            alias="activeDeadlineSeconds",
            description=(
                "Optional duration in seconds relative to the StartTime that the pod"
                " may be active on a node before the system actively tries to terminate"
                " the pod; value must be positive integer This field is only applicable"
                " to container and script templates."
            ),
        ),
    ] = None
    affinity: Annotated[
        Optional[v1.Affinity],
        Field(
            description=(
                "Affinity sets the pod's scheduling constraints Overrides the affinity"
                " set at the workflow level (if any)"
            )
        ),
    ] = None
    annotations: Annotated[
        Optional[Dict[str, str]],
        Field(description=("Annotations is a list of annotations to add to the template at runtime")),
    ] = None
    archive_location: Annotated[
        Optional[ArtifactLocation],
        Field(
            alias="archiveLocation",
            description=(
                "Location in which all files related to the step will be stored (logs,"
                " artifacts, etc...). Can be overridden by individual items in Outputs."
                " If omitted, will use the default artifact repository location"
                " configured in the controller, appended with the"
                " <workflowname>/<nodename> in the key."
            ),
        ),
    ] = None
    automount_service_account_token: Annotated[
        Optional[bool],
        Field(
            alias="automountServiceAccountToken",
            description=(
                "AutomountServiceAccountToken indicates whether a service account token"
                " should be automatically mounted in pods. ServiceAccountName of"
                " ExecutorConfig must be specified if this value is false."
            ),
        ),
    ] = None
    container: Annotated[
        Optional[v1.Container],
        Field(description="Container is the main container image to run in the pod"),
    ] = None
    container_set: Annotated[
        Optional[ContainerSetTemplate],
        Field(
            alias="containerSet",
            description="ContainerSet groups multiple containers within a single pod.",
        ),
    ] = None
    daemon: Annotated[
        Optional[bool],
        Field(
            description=(
                "Daemon will allow a workflow to proceed to the next step so long as the container reaches readiness"
            )
        ),
    ] = None
    dag: Annotated[
        Optional[DAGTemplate],
        Field(description="DAG template subtype which runs a DAG"),
    ] = None
    data: Annotated[Optional[Data], Field(description="Data is a data template")] = None
    executor: Annotated[
        Optional[ExecutorConfig],
        Field(description="Executor holds configurations of the executor container."),
    ] = None
    fail_fast: Annotated[
        Optional[bool],
        Field(
            alias="failFast",
            description=(
                "FailFast, if specified, will fail this template if any of its child"
                " pods has failed. This is useful for when this template is expanded"
                " with `withItems`, etc."
            ),
        ),
    ] = None
    host_aliases: Annotated[
        Optional[List[v1.HostAlias]],
        Field(
            alias="hostAliases",
            description=("HostAliases is an optional list of hosts and IPs that will be injected into the pod spec"),
        ),
    ] = None
    http: Annotated[Optional[HTTP], Field(description="HTTP makes a HTTP request")] = None
    init_containers: Annotated[
        Optional[List[UserContainer]],
        Field(
            alias="initContainers",
            description=("InitContainers is a list of containers which run before the main container."),
        ),
    ] = None
    inputs: Annotated[
        Optional[Inputs],
        Field(description=("Inputs describe what inputs parameters and artifacts are supplied to this template")),
    ] = None
    memoize: Annotated[
        Optional[Memoize],
        Field(description=("Memoize allows templates to use outputs generated from already executed templates")),
    ] = None
    metadata: Annotated[
        Optional[Metadata],
        Field(description="Metdata sets the pods's metadata, i.e. annotations and labels"),
    ] = None
    metrics: Annotated[
        Optional[Metrics],
        Field(description="Metrics are a list of metrics emitted from this template"),
    ] = None
    name: Annotated[Optional[str], Field(description="Name is the name of the template")] = None
    node_selector: Annotated[
        Optional[Dict[str, str]],
        Field(
            alias="nodeSelector",
            description=(
                "NodeSelector is a selector to schedule this step of the workflow to be"
                " run on the selected node(s). Overrides the selector set at the"
                " workflow level."
            ),
        ),
    ] = None
    outputs: Annotated[
        Optional[Outputs],
        Field(description=("Outputs describe the parameters and artifacts that this template produces")),
    ] = None
    parallelism: Annotated[
        Optional[int],
        Field(
            description=(
                "Parallelism limits the max total parallel pods that can execute at the"
                " same time within the boundaries of this template invocation. If"
                " additional steps/dag templates are invoked, the pods created by those"
                " templates will not be counted towards this total."
            )
        ),
    ] = None
    plugin: Annotated[
        Optional[Plugin],
        Field(
            description=(
                "Plugin is a plugin template Note: the structure of a plugin template"
                " is free-form, so we need to have"
                ' "x-kubernetes-preserve-unknown-fields: true" in the validation'
                " schema."
            )
        ),
    ] = None
    pod_spec_patch: Annotated[
        Optional[str],
        Field(
            alias="podSpecPatch",
            description=(
                "PodSpecPatch holds strategic merge patch to apply against the pod"
                " spec. Allows parameterization of container fields which are not"
                " strings (e.g. resource limits)."
            ),
        ),
    ] = None
    priority_class_name: Annotated[
        Optional[str],
        Field(
            alias="priorityClassName",
            description="PriorityClassName to apply to workflow pods.",
        ),
    ] = None
    resource: Annotated[
        Optional[ResourceTemplate],
        Field(description="Resource template subtype which can run k8s resources"),
    ] = None
    retry_strategy: Annotated[
        Optional[RetryStrategy],
        Field(
            alias="retryStrategy",
            description="RetryStrategy describes how to retry a template when it fails",
        ),
    ] = None
    scheduler_name: Annotated[
        Optional[str],
        Field(
            alias="schedulerName",
            description=(
                "If specified, the pod will be dispatched by specified scheduler. Or it"
                " will be dispatched by workflow scope scheduler if specified. If"
                " neither specified, the pod will be dispatched by default scheduler."
            ),
        ),
    ] = None
    script: Annotated[
        Optional[ScriptTemplate],
        Field(description="Script runs a portion of code against an interpreter"),
    ] = None
    security_context: Annotated[
        Optional[v1.PodSecurityContext],
        Field(
            alias="securityContext",
            description=(
                "SecurityContext holds pod-level security attributes and common"
                " container settings. Optional: Defaults to empty.  See type"
                " description for default values of each field."
            ),
        ),
    ] = None
    service_account_name: Annotated[
        Optional[str],
        Field(
            alias="serviceAccountName",
            description="ServiceAccountName to apply to workflow pods",
        ),
    ] = None
    sidecars: Annotated[
        Optional[List[UserContainer]],
        Field(
            description=(
                "Sidecars is a list of containers which run alongside the main"
                " container Sidecars are automatically killed when the main container"
                " completes"
            )
        ),
    ] = None
    steps: Annotated[
        Optional[List[ParallelSteps]],
        Field(description="Steps define a series of sequential/parallel workflow steps"),
    ] = None
    suspend: Annotated[
        Optional[SuspendTemplate],
        Field(description=("Suspend template subtype which can suspend a workflow when reaching the step")),
    ] = None
    synchronization: Annotated[
        Optional[Synchronization],
        Field(description=("Synchronization holds synchronization lock configuration for this template")),
    ] = None
    timeout: Annotated[
        Optional[str],
        Field(
            description=(
                "Timeout allows to set the total node execution timeout duration"
                " counting from the node's start time. This duration also includes time"
                " in which the node spends in Pending state. This duration may not be"
                " applied to Step or DAG templates."
            )
        ),
    ] = None
    tolerations: Annotated[
        Optional[List[v1.Toleration]],
        Field(description="Tolerations to apply to workflow pods."),
    ] = None
    volumes: Annotated[
        Optional[List[v1.Volume]],
        Field(description=("Volumes is a list of volumes that can be mounted by containers in a template.")),
    ] = None


class DAGTask(BaseModel):
    arguments: Annotated[
        Optional[Arguments],
        Field(description=("Arguments are the parameter and artifact arguments to the template")),
    ] = None
    continue_on: Annotated[
        Optional[ContinueOn],
        Field(
            alias="continueOn",
            description=(
                "ContinueOn makes argo to proceed with the following step even if this"
                " step fails. Errors and Failed states can be specified"
            ),
        ),
    ] = None
    dependencies: Annotated[
        Optional[List[str]],
        Field(description="Dependencies are name of other targets which this depends on"),
    ] = None
    depends: Annotated[
        Optional[str],
        Field(description="Depends are name of other targets which this depends on"),
    ] = None
    hooks: Annotated[
        Optional[Dict[str, LifecycleHook]],
        Field(
            description=(
                "Hooks hold the lifecycle hook which is invoked at lifecycle of task,"
                " irrespective of the success, failure, or error status of the primary"
                " task"
            )
        ),
    ] = None
    inline: Annotated[
        Optional[Template],
        Field(
            description=(
                "Inline is the template. Template must be empty if this is declared"
                " (and vice-versa). Note: As mentioned in the corresponding definition"
                " in WorkflowStep, this struct is defined recursively, so we need"
                ' "x-kubernetes-preserve-unknown-fields: true" in the validation'
                " schema."
            )
        ),
    ] = None
    name: Annotated[str, Field(description="Name is the name of the target")]
    on_exit: Annotated[
        Optional[str],
        Field(
            alias="onExit",
            description=(
                "OnExit is a template reference which is invoked at the end of the"
                " template, irrespective of the success, failure, or error of the"
                " primary template. DEPRECATED: Use Hooks[exit].Template instead."
            ),
        ),
    ] = None
    template: Annotated[Optional[str], Field(description="Name of template to execute")] = None
    template_ref: Annotated[
        Optional[TemplateRef],
        Field(
            alias="templateRef",
            description=("TemplateRef is the reference to the template resource to execute."),
        ),
    ] = None
    when: Annotated[
        Optional[str],
        Field(description=("When is an expression in which the task should conditionally execute")),
    ] = None
    with_items: Annotated[
        Optional[List[Item]],
        Field(
            alias="withItems",
            description=(
                "WithItems expands a task into multiple parallel tasks from the items"
                " in the list Note: The structure of WithItems is free-form, so we need"
                ' "x-kubernetes-preserve-unknown-fields: true" in the validation'
                " schema."
            ),
        ),
    ] = None
    with_param: Annotated[
        Optional[str],
        Field(
            alias="withParam",
            description=(
                "WithParam expands a task into multiple parallel tasks from the value"
                " in the parameter, which is expected to be a JSON list."
            ),
        ),
    ] = None
    with_sequence: Annotated[
        Optional[Sequence],
        Field(
            alias="withSequence",
            description="WithSequence expands a task into a numeric sequence",
        ),
    ] = None


class WorkflowSpec(BaseModel):
    active_deadline_seconds: Annotated[
        Optional[int],
        Field(
            alias="activeDeadlineSeconds",
            description=(
                "Optional duration in seconds relative to the workflow start time which"
                " the workflow is allowed to run before the controller terminates the"
                " io.argoproj.workflow.v1alpha1. A value of zero is used to terminate a"
                " Running workflow"
            ),
        ),
    ] = None
    affinity: Annotated[
        Optional[v1.Affinity],
        Field(
            description=(
                "Affinity sets the scheduling constraints for all pods in the"
                " io.argoproj.workflow.v1alpha1. Can be overridden by an affinity"
                " specified in the template"
            )
        ),
    ] = None
    archive_logs: Annotated[
        Optional[bool],
        Field(
            alias="archiveLogs",
            description=("ArchiveLogs indicates if the container logs should be archived"),
        ),
    ] = None
    arguments: Annotated[
        Optional[Arguments],
        Field(
            description=(
                "Arguments contain the parameters and artifacts sent to the workflow"
                " entrypoint Parameters are referencable globally using the 'workflow'"
                " variable prefix. e.g."
                " {{io.argoproj.workflow.v1alpha1.parameters.myparam}}"
            )
        ),
    ] = None
    artifact_gc: Annotated[
        Optional[WorkflowLevelArtifactGC],
        Field(
            alias="artifactGC",
            description=(
                "ArtifactGC describes the strategy to use when deleting artifacts from"
                " completed or deleted workflows (applies to all output Artifacts"
                " unless Artifact.ArtifactGC is specified, which overrides this)"
            ),
        ),
    ] = None
    artifact_repository_ref: Annotated[
        Optional[ArtifactRepositoryRef],
        Field(
            alias="artifactRepositoryRef",
            description=(
                "ArtifactRepositoryRef specifies the configMap name and key containing the artifact repository config."
            ),
        ),
    ] = None
    automount_service_account_token: Annotated[
        Optional[bool],
        Field(
            alias="automountServiceAccountToken",
            description=(
                "AutomountServiceAccountToken indicates whether a service account token"
                " should be automatically mounted in pods. ServiceAccountName of"
                " ExecutorConfig must be specified if this value is false."
            ),
        ),
    ] = None
    dns_config: Annotated[
        Optional[v1.PodDNSConfig],
        Field(
            alias="dnsConfig",
            description=(
                "PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy."
            ),
        ),
    ] = None
    dns_policy: Annotated[
        Optional[str],
        Field(
            alias="dnsPolicy",
            description=(
                'Set DNS policy for workflow pods. Defaults to "ClusterFirst". Valid'
                " values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default'"
                " or 'None'. DNS parameters given in DNSConfig will be merged with"
                " the policy selected with DNSPolicy. To have DNS options set along"
                " with hostNetwork, you have to specify DNS policy explicitly to"
                " 'ClusterFirstWithHostNet'."
            ),
        ),
    ] = None
    entrypoint: Annotated[
        Optional[str],
        Field(
            description=(
                "Entrypoint is a template reference to the starting point of the io.argoproj.workflow.v1alpha1."
            )
        ),
    ] = None
    executor: Annotated[
        Optional[ExecutorConfig],
        Field(
            description=("Executor holds configurations of executor containers of the io.argoproj.workflow.v1alpha1.")
        ),
    ] = None
    hooks: Annotated[
        Optional[Dict[str, LifecycleHook]],
        Field(
            description=(
                "Hooks holds the lifecycle hook which is invoked at lifecycle of step,"
                " irrespective of the success, failure, or error status of the primary"
                " step"
            )
        ),
    ] = None
    host_aliases: Annotated[Optional[List[v1.HostAlias]], Field(alias="hostAliases")] = None
    host_network: Annotated[
        Optional[bool],
        Field(
            alias="hostNetwork",
            description=("Host networking requested for this workflow pod. Default to false."),
        ),
    ] = None
    image_pull_secrets: Annotated[
        Optional[List[v1.LocalObjectReference]],
        Field(
            alias="imagePullSecrets",
            description=(
                "ImagePullSecrets is a list of references to secrets in the same"
                " namespace to use for pulling any images in pods that reference this"
                " ServiceAccount. ImagePullSecrets are distinct from Secrets because"
                " Secrets can be mounted in the pod, but ImagePullSecrets are only"
                " accessed by the kubelet. More info:"
                " https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod"
            ),
        ),
    ] = None
    metrics: Annotated[
        Optional[Metrics],
        Field(description="Metrics are a list of metrics emitted from this Workflow"),
    ] = None
    node_selector: Annotated[
        Optional[Dict[str, str]],
        Field(
            alias="nodeSelector",
            description=(
                "NodeSelector is a selector which will result in all pods of the"
                " workflow to be scheduled on the selected node(s). This is able to be"
                " overridden by a nodeSelector specified in the template."
            ),
        ),
    ] = None
    on_exit: Annotated[
        Optional[str],
        Field(
            alias="onExit",
            description=(
                "OnExit is a template reference which is invoked at the end of the"
                " workflow, irrespective of the success, failure, or error of the"
                " primary io.argoproj.workflow.v1alpha1."
            ),
        ),
    ] = None
    parallelism: Annotated[
        Optional[int],
        Field(
            description=(
                "Parallelism limits the max total parallel pods that can execute at the same time in a workflow"
            )
        ),
    ] = None
    pod_disruption_budget: Annotated[
        Optional[v1_2.PodDisruptionBudgetSpec],
        Field(
            alias="podDisruptionBudget",
            description=(
                "PodDisruptionBudget holds the number of concurrent disruptions that"
                " you allow for Workflow's Pods. Controller will automatically add the"
                " selector with workflow name, if selector is empty. Optional: Defaults"
                " to empty."
            ),
        ),
    ] = None
    pod_gc: Annotated[
        Optional[PodGC],
        Field(
            alias="podGC",
            description=("PodGC describes the strategy to use when deleting completed pods"),
        ),
    ] = None
    pod_metadata: Annotated[
        Optional[Metadata],
        Field(
            alias="podMetadata",
            description=("PodMetadata defines additional metadata that should be applied to workflow pods"),
        ),
    ] = None
    pod_priority_class_name: Annotated[
        Optional[str],
        Field(
            alias="podPriorityClassName",
            description="PriorityClassName to apply to workflow pods.",
        ),
    ] = None
    pod_spec_patch: Annotated[
        Optional[str],
        Field(
            alias="podSpecPatch",
            description=(
                "PodSpecPatch holds strategic merge patch to apply against the pod"
                " spec. Allows parameterization of container fields which are not"
                " strings (e.g. resource limits)."
            ),
        ),
    ] = None
    priority: Annotated[
        Optional[int],
        Field(
            description=(
                "Priority is used if controller is configured to process limited number"
                " of workflows in parallel. Workflows with higher priority are"
                " processed first."
            )
        ),
    ] = None
    retry_strategy: Annotated[
        Optional[RetryStrategy],
        Field(
            alias="retryStrategy",
            description=("RetryStrategy for all templates in the io.argoproj.workflow.v1alpha1."),
        ),
    ] = None
    scheduler_name: Annotated[
        Optional[str],
        Field(
            alias="schedulerName",
            description=(
                "Set scheduler name for all pods. Will be overridden if"
                " container/script template's scheduler name is set. Default scheduler"
                " will be used if neither specified."
            ),
        ),
    ] = None
    security_context: Annotated[
        Optional[v1.PodSecurityContext],
        Field(
            alias="securityContext",
            description=(
                "SecurityContext holds pod-level security attributes and common"
                " container settings. Optional: Defaults to empty.  See type"
                " description for default values of each field."
            ),
        ),
    ] = None
    service_account_name: Annotated[
        Optional[str],
        Field(
            alias="serviceAccountName",
            description=("ServiceAccountName is the name of the ServiceAccount to run all pods of the workflow as."),
        ),
    ] = None
    shutdown: Annotated[
        Optional[str],
        Field(description=("Shutdown will shutdown the workflow according to its ShutdownStrategy")),
    ] = None
    suspend: Annotated[
        Optional[bool],
        Field(
            description=("Suspend will suspend the workflow and prevent execution of any future steps in the workflow")
        ),
    ] = None
    synchronization: Annotated[
        Optional[Synchronization],
        Field(description=("Synchronization holds synchronization lock configuration for this Workflow")),
    ] = None
    template_defaults: Annotated[
        Optional[Template],
        Field(
            alias="templateDefaults",
            description=(
                "TemplateDefaults holds default template values that will apply to all"
                " templates in the Workflow, unless overridden on the template-level"
            ),
        ),
    ] = None
    templates: Annotated[
        Optional[List[Template]],
        Field(description="Templates is a list of workflow templates used in a workflow"),
    ] = None
    tolerations: Annotated[
        Optional[List[v1.Toleration]],
        Field(description="Tolerations to apply to workflow pods."),
    ] = None
    ttl_strategy: Annotated[
        Optional[TTLStrategy],
        Field(
            alias="ttlStrategy",
            description=(
                "TTLStrategy limits the lifetime of a Workflow that has finished"
                " execution depending on if it Succeeded or Failed. If this struct is"
                " set, once the Workflow finishes, it will be deleted after the time to"
                " live expires. If this field is unset, the controller config map will"
                " hold the default values."
            ),
        ),
    ] = None
    volume_claim_gc: Annotated[
        Optional[VolumeClaimGC],
        Field(
            alias="volumeClaimGC",
            description=("VolumeClaimGC describes the strategy to use when deleting volumes from completed workflows"),
        ),
    ] = None
    volume_claim_templates: Annotated[
        Optional[List[v1.PersistentVolumeClaim]],
        Field(
            alias="volumeClaimTemplates",
            description=(
                "VolumeClaimTemplates is a list of claims that containers are allowed"
                " to reference. The Workflow controller will create the claims at the"
                " beginning of the workflow and delete the claims upon completion of"
                " the workflow"
            ),
        ),
    ] = None
    volumes: Annotated[
        Optional[List[v1.Volume]],
        Field(
            description=(
                "Volumes is a list of volumes that can be mounted by containers in a io.argoproj.workflow.v1alpha1."
            )
        ),
    ] = None
    workflow_metadata: Annotated[
        Optional[WorkflowMetadata],
        Field(
            alias="workflowMetadata",
            description=("WorkflowMetadata contains some metadata of the workflow to refer to"),
        ),
    ] = None
    workflow_template_ref: Annotated[
        Optional[WorkflowTemplateRef],
        Field(
            alias="workflowTemplateRef",
            description=("WorkflowTemplateRef holds a reference to a WorkflowTemplate for execution"),
        ),
    ] = None


class WorkflowStep(BaseModel):
    arguments: Annotated[
        Optional[Arguments],
        Field(description="Arguments hold arguments to the template"),
    ] = None
    continue_on: Annotated[
        Optional[ContinueOn],
        Field(
            alias="continueOn",
            description=(
                "ContinueOn makes argo to proceed with the following step even if this"
                " step fails. Errors and Failed states can be specified"
            ),
        ),
    ] = None
    hooks: Annotated[
        Optional[Dict[str, LifecycleHook]],
        Field(
            description=(
                "Hooks holds the lifecycle hook which is invoked at lifecycle of step,"
                " irrespective of the success, failure, or error status of the primary"
                " step"
            )
        ),
    ] = None
    inline: Annotated[
        Optional[Template],
        Field(
            description=(
                "Inline is the template. Template must be empty if this is declared"
                " (and vice-versa). Note: This struct is defined recursively, since the"
                " inline template can potentially contain steps/DAGs that also has an"
                ' "inline" field. Kubernetes doesn\'t allow recursive types, so we need'
                ' "x-kubernetes-preserve-unknown-fields: true" in the validation'
                " schema."
            )
        ),
    ] = None
    name: Annotated[Optional[str], Field(description="Name of the step")] = None
    on_exit: Annotated[
        Optional[str],
        Field(
            alias="onExit",
            description=(
                "OnExit is a template reference which is invoked at the end of the"
                " template, irrespective of the success, failure, or error of the"
                " primary template. DEPRECATED: Use Hooks[exit].Template instead."
            ),
        ),
    ] = None
    template: Annotated[
        Optional[str],
        Field(description="Template is the name of the template to execute as the step"),
    ] = None
    template_ref: Annotated[
        Optional[TemplateRef],
        Field(
            alias="templateRef",
            description=("TemplateRef is the reference to the template resource to execute as the step."),
        ),
    ] = None
    when: Annotated[
        Optional[str],
        Field(description=("When is an expression in which the step should conditionally execute")),
    ] = None
    with_items: Annotated[
        Optional[List[Item]],
        Field(
            alias="withItems",
            description=(
                "WithItems expands a step into multiple parallel steps from the items"
                " in the list Note: The structure of WithItems is free-form, so we need"
                ' "x-kubernetes-preserve-unknown-fields: true" in the validation'
                " schema."
            ),
        ),
    ] = None
    with_param: Annotated[
        Optional[str],
        Field(
            alias="withParam",
            description=(
                "WithParam expands a step into multiple parallel steps from the value"
                " in the parameter, which is expected to be a JSON list."
            ),
        ),
    ] = None
    with_sequence: Annotated[
        Optional[Sequence],
        Field(
            alias="withSequence",
            description="WithSequence expands a step into a numeric sequence",
        ),
    ] = None


class ClusterWorkflowTemplate(BaseModel):
    api_version: Annotated[
        Optional[str],
        Field(
            alias="apiVersion",
            description=(
                "APIVersion defines the versioned schema of this representation of an"
                " object. Servers should convert recognized schemas to the latest"
                " internal value, and may reject unrecognized values. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
            ),
        ),
    ] = None
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "Kind is a string value representing the REST resource this object"
                " represents. Servers may infer this from the endpoint the client"
                " submits requests to. Cannot be updated. In CamelCase. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
            )
        ),
    ] = None
    metadata: v1_1.ObjectMeta
    spec: WorkflowSpec


class CronWorkflowSpec(BaseModel):
    concurrency_policy: Annotated[
        Optional[str],
        Field(
            alias="concurrencyPolicy",
            description=("ConcurrencyPolicy is the K8s-style concurrency policy that will be used"),
        ),
    ] = None
    failed_jobs_history_limit: Annotated[
        Optional[int],
        Field(
            alias="failedJobsHistoryLimit",
            description=("FailedJobsHistoryLimit is the number of failed jobs to be kept at a time"),
        ),
    ] = None
    schedule: Annotated[
        Optional[str],
        Field(description=("Schedule is a schedule to run the Workflow in Cron format. Deprecated, use Schedules")),
    ] = None
    schedules: Annotated[
        Optional[List[str]],
        Field(description=("v3.6 and after: Schedules is a list of schedules to run the Workflow in Cron format")),
    ] = None
    starting_deadline_seconds: Annotated[
        Optional[int],
        Field(
            alias="startingDeadlineSeconds",
            description=(
                "StartingDeadlineSeconds is the K8s-style deadline that will limit the"
                " time a CronWorkflow will be run after its original scheduled time if"
                " it is missed."
            ),
        ),
    ] = None
    stop_strategy: Annotated[
        Optional[StopStrategy],
        Field(
            alias="stopStrategy",
            description=(
                "v3.6 and after: StopStrategy defines if the CronWorkflow should stop scheduling based on a condition"
            ),
        ),
    ] = None
    successful_jobs_history_limit: Annotated[
        Optional[int],
        Field(
            alias="successfulJobsHistoryLimit",
            description=("SuccessfulJobsHistoryLimit is the number of successful jobs to be kept at a time"),
        ),
    ] = None
    suspend: Annotated[
        Optional[bool],
        Field(description=("Suspend is a flag that will stop new CronWorkflows from running if set to true")),
    ] = None
    timezone: Annotated[
        Optional[str],
        Field(
            description=(
                "Timezone is the timezone against which the cron schedule will be"
                ' calculated, e.g. "Asia/Tokyo". Default is machine\'s local time.'
            )
        ),
    ] = None
    when: Annotated[
        Optional[str],
        Field(description=("v3.6 and after: When is an expression that determines if a run should be scheduled.")),
    ] = None
    workflow_metadata: Annotated[
        Optional[v1_1.ObjectMeta],
        Field(
            alias="workflowMetadata",
            description=("WorkflowMetadata contains some metadata of the workflow to be run"),
        ),
    ] = None
    workflow_spec: Annotated[
        WorkflowSpec,
        Field(
            alias="workflowSpec",
            description="WorkflowSpec is the spec of the workflow to be run",
        ),
    ]


class WorkflowStatus(BaseModel):
    artifact_gc_status: Annotated[
        Optional[ArtGCStatus],
        Field(
            alias="artifactGCStatus",
            description=("ArtifactGCStatus maintains the status of Artifact Garbage Collection"),
        ),
    ] = None
    artifact_repository_ref: Annotated[
        Optional[ArtifactRepositoryRefStatus],
        Field(
            alias="artifactRepositoryRef",
            description=(
                "ArtifactRepositoryRef is used to cache the repository to use so we do"
                " not need to determine it everytime we reconcile."
            ),
        ),
    ] = None
    compressed_nodes: Annotated[
        Optional[str],
        Field(
            alias="compressedNodes",
            description="Compressed and base64 decoded Nodes map",
        ),
    ] = None
    conditions: Annotated[
        Optional[List[Condition]],
        Field(description="Conditions is a list of conditions the Workflow may have"),
    ] = None
    estimated_duration: Annotated[
        Optional[int],
        Field(alias="estimatedDuration", description="EstimatedDuration in seconds."),
    ] = None
    finished_at: Annotated[
        Optional[v1_1.Time],
        Field(alias="finishedAt", description="Time at which this workflow completed"),
    ] = None
    message: Annotated[
        Optional[str],
        Field(
            description=("A human readable message indicating details about why the workflow is in this condition.")
        ),
    ] = None
    nodes: Annotated[
        Optional[Dict[str, NodeStatus]],
        Field(description="Nodes is a mapping between a node ID and the node's status."),
    ] = None
    offload_node_status_version: Annotated[
        Optional[str],
        Field(
            alias="offloadNodeStatusVersion",
            description=(
                "Whether on not node status has been offloaded to a database. If"
                " exists, then Nodes and CompressedNodes will be empty. This will"
                " actually be populated with a hash of the offloaded data."
            ),
        ),
    ] = None
    outputs: Annotated[
        Optional[Outputs],
        Field(
            description=(
                "Outputs captures output values and artifact locations produced by the workflow via global outputs"
            )
        ),
    ] = None
    persistent_volume_claims: Annotated[
        Optional[List[v1.Volume]],
        Field(
            alias="persistentVolumeClaims",
            description=(
                "PersistentVolumeClaims tracks all PVCs that were created as part of"
                " the io.argoproj.workflow.v1alpha1. The contents of this list are"
                " drained at the end of the workflow."
            ),
        ),
    ] = None
    phase: Annotated[
        Optional[str],
        Field(
            description=(
                "Phase a simple, high-level summary of where the workflow is in its"
                ' lifecycle. Will be "" (Unknown), "Pending", or "Running" before the'
                ' workflow is completed, and "Succeeded", "Failed" or "Error" once the'
                " workflow has completed."
            )
        ),
    ] = None
    progress: Annotated[Optional[str], Field(description="Progress to completion")] = None
    resources_duration: Annotated[
        Optional[Dict[str, int]],
        Field(
            alias="resourcesDuration",
            description="ResourcesDuration is the total for the workflow",
        ),
    ] = None
    started_at: Annotated[
        Optional[v1_1.Time],
        Field(alias="startedAt", description="Time at which this workflow started"),
    ] = None
    stored_templates: Annotated[
        Optional[Dict[str, Template]],
        Field(
            alias="storedTemplates",
            description=("StoredTemplates is a mapping between a template ref and the node's status."),
        ),
    ] = None
    stored_workflow_template_spec: Annotated[
        Optional[WorkflowSpec],
        Field(
            alias="storedWorkflowTemplateSpec",
            description=("StoredWorkflowSpec stores the WorkflowTemplate spec for future execution."),
        ),
    ] = None
    synchronization: Annotated[
        Optional[SynchronizationStatus],
        Field(description="Synchronization stores the status of synchronization locks"),
    ] = None
    task_results_completion_status: Annotated[
        Optional[Dict[str, bool]],
        Field(
            alias="taskResultsCompletionStatus",
            description=(
                "TaskResultsCompletionStatus tracks task result completion status"
                " (mapped by node ID). Used to prevent premature archiving and garbage"
                " collection."
            ),
        ),
    ] = None


class WorkflowTemplate(BaseModel):
    api_version: Annotated[
        Optional[str],
        Field(
            alias="apiVersion",
            description=(
                "APIVersion defines the versioned schema of this representation of an"
                " object. Servers should convert recognized schemas to the latest"
                " internal value, and may reject unrecognized values. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
            ),
        ),
    ] = None
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "Kind is a string value representing the REST resource this object"
                " represents. Servers may infer this from the endpoint the client"
                " submits requests to. Cannot be updated. In CamelCase. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
            )
        ),
    ] = None
    metadata: v1_1.ObjectMeta
    spec: WorkflowSpec


class ClusterWorkflowTemplateCreateRequest(BaseModel):
    create_options: Annotated[Optional[v1_1.CreateOptions], Field(alias="createOptions")] = None
    template: Optional[ClusterWorkflowTemplate] = None


class ClusterWorkflowTemplateLintRequest(BaseModel):
    create_options: Annotated[Optional[v1_1.CreateOptions], Field(alias="createOptions")] = None
    template: Optional[ClusterWorkflowTemplate] = None


class ClusterWorkflowTemplateUpdateRequest(BaseModel):
    name: Annotated[Optional[str], Field(description="DEPRECATED: This field is ignored.")] = None
    template: Optional[ClusterWorkflowTemplate] = None


class CronWorkflow(BaseModel):
    api_version: Annotated[
        Optional[str],
        Field(
            alias="apiVersion",
            description=(
                "APIVersion defines the versioned schema of this representation of an"
                " object. Servers should convert recognized schemas to the latest"
                " internal value, and may reject unrecognized values. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
            ),
        ),
    ] = None
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "Kind is a string value representing the REST resource this object"
                " represents. Servers may infer this from the endpoint the client"
                " submits requests to. Cannot be updated. In CamelCase. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
            )
        ),
    ] = None
    metadata: v1_1.ObjectMeta
    spec: CronWorkflowSpec
    status: Optional[CronWorkflowStatus] = None


class Workflow(BaseModel):
    api_version: Annotated[
        Optional[str],
        Field(
            alias="apiVersion",
            description=(
                "APIVersion defines the versioned schema of this representation of an"
                " object. Servers should convert recognized schemas to the latest"
                " internal value, and may reject unrecognized values. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
            ),
        ),
    ] = None
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "Kind is a string value representing the REST resource this object"
                " represents. Servers may infer this from the endpoint the client"
                " submits requests to. Cannot be updated. In CamelCase. More info:"
                " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
            )
        ),
    ] = None
    metadata: v1_1.ObjectMeta
    spec: WorkflowSpec
    status: Optional[WorkflowStatus] = None


class WorkflowTemplateCreateRequest(BaseModel):
    create_options: Annotated[Optional[v1_1.CreateOptions], Field(alias="createOptions")] = None
    namespace: Optional[str] = None
    template: Optional[WorkflowTemplate] = None


class WorkflowTemplateLintRequest(BaseModel):
    create_options: Annotated[Optional[v1_1.CreateOptions], Field(alias="createOptions")] = None
    namespace: Optional[str] = None
    template: Optional[WorkflowTemplate] = None


class WorkflowTemplateUpdateRequest(BaseModel):
    name: Annotated[Optional[str], Field(description="DEPRECATED: This field is ignored.")] = None
    namespace: Optional[str] = None
    template: Optional[WorkflowTemplate] = None


class CreateCronWorkflowRequest(BaseModel):
    create_options: Annotated[Optional[v1_1.CreateOptions], Field(alias="createOptions")] = None
    cron_workflow: Annotated[Optional[CronWorkflow], Field(alias="cronWorkflow")] = None
    namespace: Optional[str] = None


class LintCronWorkflowRequest(BaseModel):
    cron_workflow: Annotated[Optional[CronWorkflow], Field(alias="cronWorkflow")] = None
    namespace: Optional[str] = None


class UpdateCronWorkflowRequest(BaseModel):
    cron_workflow: Annotated[Optional[CronWorkflow], Field(alias="cronWorkflow")] = None
    name: Annotated[Optional[str], Field(description="DEPRECATED: This field is ignored.")] = None
    namespace: Optional[str] = None


class WorkflowCreateRequest(BaseModel):
    create_options: Annotated[Optional[v1_1.CreateOptions], Field(alias="createOptions")] = None
    instance_id: Annotated[
        Optional[str],
        Field(alias="instanceID", description="This field is no longer used."),
    ] = None
    namespace: Optional[str] = None
    server_dry_run: Annotated[Optional[bool], Field(alias="serverDryRun")] = None
    workflow: Optional[Workflow] = None


class WorkflowLintRequest(BaseModel):
    namespace: Optional[str] = None
    workflow: Optional[Workflow] = None


class WorkflowWatchEvent(BaseModel):
    object: Annotated[Optional[Workflow], Field(title="the workflow")] = None
    type: Annotated[Optional[str], Field(title="the type of change")] = None


DAGTemplate.update_forward_refs()
ParallelSteps.update_forward_refs()
ClusterWorkflowTemplateList.update_forward_refs()
CronWorkflowList.update_forward_refs()
WorkflowList.update_forward_refs()
WorkflowTemplateList.update_forward_refs()
