# coding: utf-8

#  -----------------------------------------------------------------------------------------
#  (C) Copyright IBM Corp. 2023-2025.
#  https://opensource.org/licenses/BSD-3-Clause
#  -----------------------------------------------------------------------------------------

from pprint import pformat
from six import iteritems
import re


class ModelVersionInput(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, training_data_ref=None, evaluation=None):
        """
        ModelVersionInput - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'training_data_ref': 'ModelTrainingDataRef',
            'evaluation': 'EvaluationDefinition'
        }

        self.attribute_map = {
            'training_data_ref': 'trainingDataRef',
            'evaluation': 'evaluation'
        }

        self._training_data_ref = training_data_ref
        self._evaluation = evaluation

    @property
    def training_data_ref(self):
        """
        Gets the training_data_ref of this ModelVersionInput.


        :return: The training_data_ref of this ModelVersionInput.
        :rtype: ModelTrainingDataRef
        """
        return self._training_data_ref

    @training_data_ref.setter
    def training_data_ref(self, training_data_ref):
        """
        Sets the training_data_ref of this ModelVersionInput.


        :param training_data_ref: The training_data_ref of this ModelVersionInput.
        :type: ModelTrainingDataRef
        """

        self._training_data_ref = training_data_ref

    @property
    def evaluation(self):
        """
        Gets the evaluation of this ModelVersionInput.
        Definition of the evaluation method used for pipeline models

        :return: The evaluation of this ModelVersionInput.
        :rtype: EvaluationDefinition
        """
        return self._evaluation

    @evaluation.setter
    def evaluation(self, evaluation):
        """
        Sets the evaluation of this ModelVersionInput.
        Definition of the evaluation method used for pipeline models

        :param evaluation: The evaluation of this ModelVersionInput.
        :type: EvaluationDefinition
        """

        self._evaluation = evaluation

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
