# coding: utf-8

#  -----------------------------------------------------------------------------------------
#  (C) Copyright IBM Corp. 2023-2025.
#  https://opensource.org/licenses/BSD-3-Clause
#  -----------------------------------------------------------------------------------------

from pprint import pformat
from six import iteritems
import re


class ContentLocation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, url=None, connection=None, source=None):
        """
        ContentLocation - location of model content defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'url': 'str',
            'connection': 'dict(str, str)',
            'source': 'dict(str, str)'
        }

        self.attribute_map = {
            'url' : 'url',
            'connection': 'connection',
            'source': 'source'
        }

        self._url = url
        self._connection = connection
        self._source = source

    @property
    def url(self):
        """
        Gets the temp cos url of this ContentLocation.

        :return: The url of this ContentLocation.
        :rtype: dict(str, str)
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of temp cos of this ContentLocation.

        :param connection: The connection of this ContentLocation.
        :type: dict(str, str)
        """

        self._url = url

    @property
    def connection(self):
        """
        Gets the connection of this ContentLocation.

        :return: The connection of this ContentLocation.
        :rtype: dict(str, str)
        """
        return self._connection

    @connection.setter
    def connection(self, connection):
        """
        Sets the connection of this ContentLocation.

        :param connection: The connection of this ContentLocation.
        :type: dict(str, str)
        """

        self._connection = connection

    @property
    def source(self):
        """
        Gets the source of this ContentLocation.
        Details of the resource in the content source

        :return: The source of this ContentLocation.
        :rtype: dict(str, str)
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this ContentLocation.
        Details of the resource in the content data source

        :param source: The source of this ContentLocation.
        :type: dict(str, str)
        """

        self._source = source

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
