from typing import List
import numpy as np
import hashlib
from particle import Particle
from particle.converters.bimap import DirectionalMaps
from particle import PDGID

def LD2DL(l: List):
    return {k: np.array([dic.__dict__[k] for dic in l]) for k in l[0].__dict__}


PDG2LaTeXNameMap, LaTeX2PDGNameMap = DirectionalMaps(
    "PDGID", "LaTexName", converters=(PDGID, str))

PDG2Name2IDMap, PDGID2NameMap = DirectionalMaps(
    "PDGName", "PDGID", converters=(str, PDGID))


def get_name(id):
    global PDG2LaTeXNameMap
    pdgid = PDG2LaTeXNameMap[id]
    return pdgid



def get_LR_partner(id):
    n = PDGID2NameMap[id]
    if "L" in n:
        n = n.replace("L", "R")
        return -1, int(PDG2Name2IDMap[n])
    if "R" in n:
        n = n.replace("R", "L")
        return 1, int(PDG2Name2IDMap[n])
    if "1" in n:
        n = n.replace("1", "2")
        return -1, int(PDG2Name2IDMap[n])
    if "2" in n:
        n = n.replace("2", "1")
        return 1, int(PDG2Name2IDMap[n])
    return None

def namehash(n):
    m = hashlib.sha256()
    m.update(str(n).encode('utf-8'))
    return m.hexdigest()

# TODO rework to work with lhapdf
id_name = {
    251:    "GRVPI0",
    252:    "GRVPI1",
    270:    "xFitterPI_NLO_EIG",
    280:    "xFitterPI_NLO_VAR",
    1000:   "JAM21PionPDFnlo",
    2000:   "JAM21PionPDFnlo_pT",
    3000:   "JAM21PionPDFnlonll_cosine",
    4000:   "JAM21PionPDFnlonll_expansion",
    5000:   "JAM21PionPDFnlonll_double_Mellin",
    10042:	"cteq6l1",
    10150:	"cteq61",
    10550:	"cteq66",
    10770:	"CT09MCS",
    10771:	"CT09MC1",
    10772:	"CT09MC2",
    10800:	"CT10",
    10860:	"CT10as",
    10900:	"CT10w",
    10960:	"CT10was",
    10980:	"CT10f3",
    10981:	"CT10f4",
    10982:	"CT10wf3",
    10983:	"CT10wf4",
    11000:	"CT10nlo",
    11062:	"CT10nlo_as_0112",
    11063:	"CT10nlo_as_0113",
    11064:	"CT10nlo_as_0114",
    11065:	"CT10nlo_as_0115",
    11066:	"CT10nlo_as_0116",
    11067:	"CT10nlo_as_0117",
    11068:	"CT10nlo_as_0118",
    11069:	"CT10nlo_as_0119",
    11070:	"CT10nlo_as_0120",
    11071:	"CT10nlo_as_0121",
    11072:	"CT10nlo_as_0122",
    11073:	"CT10nlo_as_0123",
    11074:	"CT10nlo_as_0124",
    11075:	"CT10nlo_as_0125",
    11076:	"CT10nlo_as_0126",
    11077:	"CT10nlo_as_0127",
    11080:	"CT10nlo_nf3",
    11082:	"CT10nlo_nf4",
    11100:	"CT10wnlo",
    11162:	"CT10wnlo_as_0112",
    11163:	"CT10wnlo_as_0113",
    11164:	"CT10wnlo_as_0114",
    11165:	"CT10wnlo_as_0115",
    11166:	"CT10wnlo_as_0116",
    11167:	"CT10wnlo_as_0117",
    11168:	"CT10wnlo_as_0118",
    11169:	"CT10wnlo_as_0119",
    11170:	"CT10wnlo_as_0120",
    11171:	"CT10wnlo_as_0121",
    11172:	"CT10wnlo_as_0122",
    11173:	"CT10wnlo_as_0123",
    11174:	"CT10wnlo_as_0124",
    11175:	"CT10wnlo_as_0125",
    11176:	"CT10wnlo_as_0126",
    11177:	"CT10wnlo_as_0127",
    11180:	"CT10wnlo_nf3",
    11182:	"CT10wnlo_nf4",
    11200:	"CT10nnlo",
    11260:	"CT10nnlo_as_0110",
    11261:	"CT10nnlo_as_0111",
    11262:	"CT10nnlo_as_0112",
    11263:	"CT10nnlo_as_0113",
    11264:	"CT10nnlo_as_0114",
    11265:	"CT10nnlo_as_0115",
    11266:	"CT10nnlo_as_0116",
    11267:	"CT10nnlo_as_0117",
    11268:	"CT10nnlo_as_0118",
    11269:	"CT10nnlo_as_0119",
    11270:	"CT10nnlo_as_0120",
    11271:	"CT10nnlo_as_0121",
    11272:	"CT10nnlo_as_0122",
    11273:	"CT10nnlo_as_0123",
    11274:	"CT10nnlo_as_0124",
    11275:	"CT10nnlo_as_0125",
    11276:	"CT10nnlo_as_0126",
    11277:	"CT10nnlo_as_0127",
    11278:	"CT10nnlo_as_0128",
    11279:	"CT10nnlo_as_0129",
    11280:	"CT10nnlo_as_0130",
    12000:	"CJ12min",
    12100:	"CJ12mid",
    12200:	"CJ12max",
    12300:	"CJ15lo",
    12400:	"CJ15nlo",
    13000:	"CT14nnlo",
    13060:	"CT14nnlo_as_0111",
    13061:	"CT14nnlo_as_0112",
    13062:	"CT14nnlo_as_0113",
    13063:	"CT14nnlo_as_0114",
    13064:	"CT14nnlo_as_0115",
    13065:	"CT14nnlo_as_0116",
    13066:	"CT14nnlo_as_0117",
    13067:	"CT14nnlo_as_0118",
    13068:	"CT14nnlo_as_0119",
    13069:	"CT14nnlo_as_0120",
    13070:	"CT14nnlo_as_0121",
    13071:	"CT14nnlo_as_0122",
    13072:	"CT14nnlo_as_0123",
    13081:	"CT14nnloIC",
    13090:	"CT14nnlo_NF3",
    13091:	"CT14nnlo_NF4",
    13092:	"CT14nnlo_NF6",
    13100:	"CT14nlo",
    13158:	"CT14nlo_as_0111",
    13159:	"CT14nlo_as_0112",
    13160:	"CT14nlo_as_0113",
    13161:	"CT14nlo_as_0114",
    13162:	"CT14nlo_as_0115",
    13163:	"CT14nlo_as_0116",
    13164:	"CT14nlo_as_0117",
    13165:	"CT14nlo_as_0118",
    13166:	"CT14nlo_as_0119",
    13167:	"CT14nlo_as_0120",
    13168:	"CT14nlo_as_0121",
    13169:	"CT14nlo_as_0122",
    13170:	"CT14nlo_as_0123",
    13190:	"CT14nlo_NF3",
    13191:	"CT14nlo_NF4",
    13192:	"CT14nlo_NF6",
    13200:	"CT14lo",
    13201:	"CT14lo_NF3",
    13202:	"CT14lo_NF4",
    13203:	"CT14lo_NF6",
    13205:	"CT14llo",
    13206:	"CT14llo_NF3",
    13207:	"CT14llo_NF4",
    13208:	"CT14llo_NF6",
    13300:	"CT14qed_proton",
    13350:	"CT14qed_neutron",
    13400:	"CT14qed_inc_proton",
    13450:	"CT14qed_inc_neutron",
    14000:	"CT18NNLO",
    14060:	"CT18NNLO_as_0110",
    14061:	"CT18NNLO_as_0111",
    14062:	"CT18NNLO_as_0112",
    14063:	"CT18NNLO_as_0113",
    14064:	"CT18NNLO_as_0114",
    14065:	"CT18NNLO_as_0115",
    14066:	"CT18NNLO_as_0116",
    14067:	"CT18NNLO_as_0117",
    14068:	"CT18NNLO_as_0118",
    14069:	"CT18NNLO_as_0119",
    14070:	"CT18NNLO_as_0120",
    14071:	"CT18NNLO_as_0121",
    14072:	"CT18NNLO_as_0122",
    14073:	"CT18NNLO_as_0123",
    14074:	"CT18NNLO_as_0124",
    14100:	"CT18ZNNLO",
    14160:	"CT18ZNNLO_as_0110",
    14161:	"CT18ZNNLO_as_0111",
    14162:	"CT18ZNNLO_as_0112",
    14163:	"CT18ZNNLO_as_0113",
    14164:	"CT18ZNNLO_as_0114",
    14165:	"CT18ZNNLO_as_0115",
    14166:	"CT18ZNNLO_as_0116",
    14167:	"CT18ZNNLO_as_0117",
    14168:	"CT18ZNNLO_as_0118",
    14169:	"CT18ZNNLO_as_0119",
    14170:	"CT18ZNNLO_as_0120",
    14171:	"CT18ZNNLO_as_0121",
    14172:	"CT18ZNNLO_as_0122",
    14173:	"CT18ZNNLO_as_0123",
    14174:	"CT18ZNNLO_as_0124",
    14200:	"CT18ANNLO",
    14260:	"CT18ANNLO_as_0110",
    14261:	"CT18ANNLO_as_0111",
    14262:	"CT18ANNLO_as_0112",
    14263:	"CT18ANNLO_as_0113",
    14264:	"CT18ANNLO_as_0114",
    14265:	"CT18ANNLO_as_0115",
    14266:	"CT18ANNLO_as_0116",
    14267:	"CT18ANNLO_as_0117",
    14268:	"CT18ANNLO_as_0118",
    14269:	"CT18ANNLO_as_0119",
    14270:	"CT18ANNLO_as_0120",
    14271:	"CT18ANNLO_as_0121",
    14272:	"CT18ANNLO_as_0122",
    14273:	"CT18ANNLO_as_0123",
    14274:	"CT18ANNLO_as_0124",
    14300:	"CT18XNNLO",
    14360:	"CT18XNNLO_as_0110",
    14361:	"CT18XNNLO_as_0111",
    14362:	"CT18XNNLO_as_0112",
    14363:	"CT18XNNLO_as_0113",
    14364:	"CT18XNNLO_as_0114",
    14365:	"CT18XNNLO_as_0115",
    14366:	"CT18XNNLO_as_0116",
    14367:	"CT18XNNLO_as_0117",
    14368:	"CT18XNNLO_as_0118",
    14369:	"CT18XNNLO_as_0119",
    14370:	"CT18XNNLO_as_0120",
    14371:	"CT18XNNLO_as_0121",
    14372:	"CT18XNNLO_as_0122",
    14373:	"CT18XNNLO_as_0123",
    14374:	"CT18XNNLO_as_0124",
    14400:	"CT18NLO",
    14460:	"CT18NLO_as_0110",
    14461:	"CT18NLO_as_0111",
    14462:	"CT18NLO_as_0112",
    14463:	"CT18NLO_as_0113",
    14464:	"CT18NLO_as_0114",
    14465:	"CT18NLO_as_0115",
    14466:	"CT18NLO_as_0116",
    14467:	"CT18NLO_as_0117",
    14468:	"CT18NLO_as_0118",
    14469:	"CT18NLO_as_0119",
    14470:	"CT18NLO_as_0120",
    14471:	"CT18NLO_as_0121",
    14472:	"CT18NLO_as_0122",
    14473:	"CT18NLO_as_0123",
    14474:	"CT18NLO_as_0124",
    14500:	"CT18ZNLO",
    14560:	"CT18ZNLO_as_0110",
    14561:	"CT18ZNLO_as_0111",
    14562:	"CT18ZNLO_as_0112",
    14563:	"CT18ZNLO_as_0113",
    14564:	"CT18ZNLO_as_0114",
    14565:	"CT18ZNLO_as_0115",
    14566:	"CT18ZNLO_as_0116",
    14567:	"CT18ZNLO_as_0117",
    14568:	"CT18ZNLO_as_0118",
    14569:	"CT18ZNLO_as_0119",
    14570:	"CT18ZNLO_as_0120",
    14571:	"CT18ZNLO_as_0121",
    14572:	"CT18ZNLO_as_0122",
    14573:	"CT18ZNLO_as_0123",
    14574:	"CT18ZNLO_as_0124",
    14600:	"CT18ANLO",
    14660:	"CT18ANLO_as_0110",
    14661:	"CT18ANLO_as_0111",
    14662:	"CT18ANLO_as_0112",
    14663:	"CT18ANLO_as_0113",
    14664:	"CT18ANLO_as_0114",
    14665:	"CT18ANLO_as_0115",
    14666:	"CT18ANLO_as_0116",
    14667:	"CT18ANLO_as_0117",
    14668:	"CT18ANLO_as_0118",
    14669:	"CT18ANLO_as_0119",
    14670:	"CT18ANLO_as_0120",
    14671:	"CT18ANLO_as_0121",
    14672:	"CT18ANLO_as_0122",
    14673:	"CT18ANLO_as_0123",
    14674:	"CT18ANLO_as_0124",
    14700:	"CT18XNLO",
    14760:	"CT18XNLO_as_0110",
    14761:	"CT18XNLO_as_0111",
    14762:	"CT18XNLO_as_0112",
    14763:	"CT18XNLO_as_0113",
    14764:	"CT18XNLO_as_0114",
    14765:	"CT18XNLO_as_0115",
    14766:	"CT18XNLO_as_0116",
    14767:	"CT18XNLO_as_0117",
    14768:	"CT18XNLO_as_0118",
    14769:	"CT18XNLO_as_0119",
    14770:	"CT18XNLO_as_0120",
    14771:	"CT18XNLO_as_0121",
    14772:	"CT18XNLO_as_0122",
    14773:	"CT18XNLO_as_0123",
    14774:	"CT18XNLO_as_0124",
    20463:	"MRST2004qed_proton",
    20465:	"MRST2004qed_neutron",
    20650:	"MRST2007lomod",
    20651:	"MRSTMCal",
    21000:	"MSTW2008lo68cl",
    21050:	"MSTW2008lo90cl",
    21100:	"MSTW2008nlo68cl",
    21150:	"MSTW2008nlo90cl",
    21200:	"MSTW2008nnlo68cl",
    21250:	"MSTW2008nnlo90cl",
    22000:	"MSTW2008nlo_asmzrange",
    22100:	"MSTW2008nlo68cl_asmz+68cl",
    22150:	"MSTW2008nlo68cl_asmz-68cl",
    22200:	"MSTW2008nlo68cl_asmz+68clhalf",
    22250:	"MSTW2008nlo68cl_asmz-68clhalf",
    22300:	"MSTW2008nlo90cl_asmz+90cl",
    22350:	"MSTW2008nlo90cl_asmz-90cl",
    22400:	"MSTW2008nlo90cl_asmz+90clhalf",
    22450:	"MSTW2008nlo90cl_asmz-90clhalf",
    22500:	"MSTW2008nnlo_asmzrange",
    22600:	"MSTW2008nnlo68cl_asmz+68cl",
    22650:	"MSTW2008nnlo68cl_asmz-68cl",
    22700:	"MSTW2008nnlo68cl_asmz+68clhalf",
    22750:	"MSTW2008nnlo68cl_asmz-68clhalf",
    22800:	"MSTW2008nnlo90cl_asmz+90cl",
    22850:	"MSTW2008nnlo90cl_asmz-90cl",
    22900:	"MSTW2008nnlo90cl_asmz+90clhalf",
    22950:	"MSTW2008nnlo90cl_asmz-90clhalf",
    23000:	"MSTW2008lo68cl_nf3",
    23050:	"MSTW2008lo90cl_nf3",
    23100:	"MSTW2008lo68cl_nf4",
    23150:	"MSTW2008lo90cl_nf4",
    23200:	"MSTW2008nlo68cl_nf3",
    23250:	"MSTW2008nlo90cl_nf3",
    23300:	"MSTW2008nlo68cl_nf4",
    23350:	"MSTW2008nlo90cl_nf4",
    23400:	"MSTW2008nlo_mcrange",
    23420:	"MSTW2008nlo_mcrange_nf3",
    23440:	"MSTW2008nlo_mcrange_fixasmz",
    23460:	"MSTW2008nlo_mcrange_fixasmz_nf3",
    23480:	"MSTW2008nlo_mbrange",
    23490:	"MSTW2008nlo_mbrange_nf4",
    23500:	"MSTW2008nnlo68cl_nf3",
    23550:	"MSTW2008nnlo90cl_nf3",
    23600:	"MSTW2008nnlo68cl_nf4",
    23650:	"MSTW2008nnlo90cl_nf4",
    23700:	"MSTW2008nnlo_mcrange",
    23720:	"MSTW2008nnlo_mcrange_nf3",
    23740:	"MSTW2008nnlo_mcrange_fixasmz",
    23760:	"MSTW2008nnlo_mcrange_fixasmz_nf3",
    23780:	"MSTW2008nnlo_mbrange",
    23790:	"MSTW2008nnlo_mbrange_nf4",
    23800:	"MSTW2008CPdeutnlo68cl",
    23850:	"MSTW2008CPdeutnnlo68cl",
    23900:	"MSTW2008lo68cl_nf4as5",
    23950:	"MSTW2008lo90cl_nf4as5",
    24000:	"MSTW2008nlo68cl_nf4as5",
    24050:	"MSTW2008nlo90cl_nf4as5",
    24100:	"MSTW2008nnlo68cl_nf4as5",
    24150:	"MSTW2008nnlo90cl_nf4as5",
    25000:	"MMHT2014lo68cl",
    25060:	"MMHT2014lo_asmzsmallrange",
    25100:	"MMHT2014nlo68cl",
    25200:	"MMHT2014nlo68clas118",
    25260:	"MMHT2014nlo_asmzsmallrange",
    25270:	"MMHT2014nlo_asmzlargerange",
    25300:	"MMHT2014nnlo68cl",
    25360:	"MMHT2014nnlo_asmzsmallrange",
    25370:	"MMHT2014nnlo_asmzlargerange",
    25400:	"MMHT2014nlo68cl_nf3",
    25410:	"MMHT2014nlo68cl_nf4",
    25420:	"MMHT2014nlo68cl_nf4as5",
    25500:	"MMHT2014nlo68clas118_nf3",
    25510:	"MMHT2014nlo68clas118_nf4",
    25520:	"MMHT2014nlo68clas118_nf4as5",
    25560:	"MMHT2014nlo_asmzsmallrange_nf3",
    25570:	"MMHT2014nlo_asmzsmallrange_nf4",
    25600:	"MMHT2014nlo_mcrange_nf3",
    25605:	"MMHT2014nlo_mcrange_nf4",
    25610:	"MMHT2014nlo_mcrange_nf5",
    25615:	"MMHT2014nlo_mbrange_nf3",
    25620:	"MMHT2014nlo_mbrange_nf4",
    25625:	"MMHT2014nlo_mbrange_nf5",
    25630:	"MMHT2014nloas118_mcrange_nf3",
    25635:	"MMHT2014nloas118_mcrange_nf4",
    25640:	"MMHT2014nloas118_mcrange_nf5",
    25645:	"MMHT2014nloas118_mbrange_nf3",
    25650:	"MMHT2014nloas118_mbrange_nf4",
    25655:	"MMHT2014nloas118_mbrange_nf5",
    25700:	"MMHT2014nnlo68cl_nf3",
    25710:	"MMHT2014nnlo68cl_nf4",
    25720:	"MMHT2014nnlo68cl_nf4as5",
    25760:	"MMHT2014nnlo_asmzsmallrange_nf3",
    25770:	"MMHT2014nnlo_asmzsmallrange_nf4",
    25800:	"MMHT2014nnlo_mcrange_nf3",
    25805:	"MMHT2014nnlo_mcrange_nf4",
    25810:	"MMHT2014nnlo_mcrange_nf5",
    25830:	"MMHT2014nnlo_mbrange_nf3",
    25840:	"MMHT2014nnlo_mbrange_nf4",
    25850:	"MMHT2014nnlo_mbrange_nf5",
    26000:	"MMHT2015qed_nlo",
    26100:	"MMHT2015qed_nlo_elastic",
    26200:	"MMHT2015qed_nlo_inelastic",
    26300:	"MMHT2015qed_nnlo",
    26400:	"MMHT2015qed_nnlo_elastic",
    26500:	"MMHT2015qed_nnlo_inelastic",
    27000:	"MSHT20lo_as130",
    27100:	"MSHT20nlo_as118",
    27200:	"MSHT20nlo_as120",
    27300:	"MSHT20nlo_as_smallrange",
    27350:	"MSHT20nlo_as_largerange",
    27400:	"MSHT20nnlo_as118",
    27500:	"MSHT20nnlo_as_smallrange",
    27550:	"MSHT20nnlo_as_largerange",
    27600:	"MSHT20nlo_nf3",
    27610:	"MSHT20nlo_nf4",
    27620:	"MSHT20nlo_as120_nf3",
    27630:	"MSHT20nlo_as120_nf4",
    27660:	"MSHT20nlo_as_smallrange_nf3",
    27670:	"MSHT20nlo_as_smallrange_nf4",
    27700:	"MSHT20nlo_mcrange_nf3",
    27705:	"MSHT20nlo_mcrange_nf4",
    27710:	"MSHT20nlo_mcrange_nf5",
    27715:	"MSHT20nlo_mbrange_nf3",
    27720:	"MSHT20nlo_mbrange_nf4",
    27725:	"MSHT20nlo_mbrange_nf5",
    27730:	"MSHT20nlo_as120_mcrange_nf3",
    27735:	"MSHT20nlo_as120_mcrange_nf4",
    27740:	"MSHT20nlo_as120_mcrange_nf5",
    27745:	"MSHT20nlo_as120_mbrange_nf3",
    27750:	"MSHT20nlo_as120_mbrange_nf4",
    27755:	"MSHT20nlo_as120_mbrange_nf5",
    27800:	"MSHT20nnlo_nf3",
    27810:	"MSHT20nnlo_nf4",
    27860:	"MSHT20nnlo_as_smallrange_nf3",
    27870:	"MSHT20nnlo_as_smallrange_nf4",
    27900:	"MSHT20nnlo_mcrange_nf3",
    27905:	"MSHT20nnlo_mcrange_nf4",
    27910:	"MSHT20nnlo_mcrange_nf5",
    27930:	"MSHT20nnlo_mbrange_nf3",
    27940:	"MSHT20nnlo_mbrange_nf4",
    27950:	"MSHT20nnlo_mbrange_nf5",
    33000:	"GKG18_DPDF_FitA_LO",
    33020:	"GKG18_DPDF_FitB_LO",
    33040:	"GKG18_DPDF_FitA_NLO",
    33060:	"GKG18_DPDF_FitB_NLO",
    40650:	"abkm09_3_nlo",
    40750:	"abkm09_3_nnlo",
    40780:	"abkm09_4_nlo",
    40810:	"abkm09_4_nnlo",
    40850:	"abkm09_5_nlo",
    40950:	"abkm09_5_nnlo",
    42000:	"abm11_3n_nlo",
    42030:	"abm11_4n_nlo",
    42060:	"abm11_5n_nlo",
    42100:	"abm11_3n_nnlo",
    42130:	"abm11_4n_nnlo",
    42160:	"abm11_5n_nnlo",
    42200:	"abm11_5n_as_nlo",
    42230:	"abm11_5n_as_nnlo",
    42300:	"abm12lhc_3_nnlo",
    42330:	"abm12lhc_4_nnlo",
    42360:	"abm12lhc_5_nnlo",
    42400:	"ABMP15_3_nnlo",
    42430:	"ABMP15_4_nnlo",
    42460:	"ABMP15_5_nnlo",
    42500:	"ABMP16_3_nnlo",
    42530:	"ABMP16_4_nnlo",
    42560:	"ABMP16_5_nnlo",
    42600:	"ABMP16als112_5_nnlo",
    42630:	"ABMP16als113_5_nnlo",
    42660:	"ABMP16als114_5_nnlo",
    42690:	"ABMP16als115_5_nnlo",
    42720:	"ABMP16als116_5_nnlo",
    42750:	"ABMP16als117_5_nnlo",
    42780:	"ABMP16als118_5_nnlo",
    42810:	"ABMP16als119_5_nnlo",
    42840:	"ABMP16als120_5_nnlo",
    42900:	"ABMP16_3_nlo",
    42930:	"ABMP16_4_nlo",
    42960:	"ABMP16_5_nlo",
    42990:	"ABMP16als114_5_nlo",
    43020:	"ABMP16als115_5_nlo",
    43050:	"ABMP16als116_5_nlo",
    43080:	"ABMP16als117_5_nlo",
    43110:	"ABMP16als118_5_nlo",
    43140:	"ABMP16als119_5_nlo",
    43170:	"ABMP16als120_5_nlo",
    43200:	"ABMP16als121_5_nlo",
    43230:	"ABMP16als122_5_nlo",
    43260:	"ABMP16als123_5_nlo",
    43290:	"ABMP16free_3_nlo",
    43320:	"ABMP16free_4_nlo",
    43350:	"ABMP16free_5_nlo",
    60600:	"HERAPDF15NNLO_EIG",
    60630:	"HERAPDF15NNLO_VAR",
    60650:	"HERAPDF15NNLO_ALPHAS",
    60700:	"HERAPDF15NLO_EIG",
    60730:	"HERAPDF15NLO_VAR",
    60750:	"HERAPDF15NLO_ALPHAS",
    60800:	"HERAPDF15LO_EIG",
    61000:	"HERAPDF20_LO_EIG",
    61100:	"HERAPDF20_NLO_EIG",
    61130:	"HERAPDF20_NLO_VAR",
    61200:	"HERAPDF20_NNLO_EIG",
    61230:	"HERAPDF20_NNLO_VAR",
    61300:	"HERAPDF20_NLO_FF3A_EIG",
    61330:	"HERAPDF20_NLO_FF3B_EIG",
    61360:	"HERAPDF20_NLO_FF3A_VAR",
    61380:	"HERAPDF20_NLO_FF3B_VAR",
    61400:	"HERAPDF20_AG_NLO_EIG",
    61430:	"HERAPDF20_AG_NNLO_EIG",
    61500:	"HERAPDF20_HiQ2_NLO_EIG",
    61530:	"HERAPDF20_HiQ2_NLO_VAR",
    61600:	"HERAPDF20_HiQ2_NNLO_EIG",
    61630:	"HERAPDF20_HiQ2_NNLO_VAR",
    61650:	"HERAPDF20_Jets_NLO_EIG",
    61690:	"HERAPDF20_Jets_NLO_VAR_Duv",
    61691:	"HERAPDF20_Jets_NLO_VAR_fsdn",
    61692:	"HERAPDF20_Jets_NLO_VAR_fsup",
    61693:	"HERAPDF20_Jets_NLO_VAR_fshdn",
    61694:	"HERAPDF20_Jets_NLO_VAR_fshup",
    61695:	"HERAPDF20_Jets_NLO_VAR_haddn",
    61696:	"HERAPDF20_Jets_NLO_VAR_hadup",
    61697:	"HERAPDF20_Jets_NLO_VAR_mbdn",
    61698:	"HERAPDF20_Jets_NLO_VAR_mbup",
    61699:	"HERAPDF20_Jets_NLO_VAR_mcdn",
    61700:	"HERAPDF20_Jets_NLO_VAR_mcup",
    61701:	"HERAPDF20_Jets_NLO_VAR_q0dn",
    61702:	"HERAPDF20_Jets_NLO_VAR_q0up",
    61703:	"HERAPDF20_Jets_NLO_VAR_q2mdn",
    61704:	"HERAPDF20_Jets_NLO_VAR_q2mup",
    61710:	"HERAPDF20_NLO_ALPHAS_110",
    61711:	"HERAPDF20_NLO_ALPHAS_111",
    61712:	"HERAPDF20_NLO_ALPHAS_112",
    61713:	"HERAPDF20_NLO_ALPHAS_113",
    61714:	"HERAPDF20_NLO_ALPHAS_114",
    61715:	"HERAPDF20_NLO_ALPHAS_115",
    61716:	"HERAPDF20_NLO_ALPHAS_116",
    61717:	"HERAPDF20_NLO_ALPHAS_117",
    61718:	"HERAPDF20_NLO_ALPHAS_118",
    61719:	"HERAPDF20_NLO_ALPHAS_119",
    61720:	"HERAPDF20_NLO_ALPHAS_120",
    61721:	"HERAPDF20_NLO_ALPHAS_121",
    61722:	"HERAPDF20_NLO_ALPHAS_122",
    61723:	"HERAPDF20_NLO_ALPHAS_123",
    61724:	"HERAPDF20_NLO_ALPHAS_124",
    61725:	"HERAPDF20_NLO_ALPHAS_125",
    61726:	"HERAPDF20_NLO_ALPHAS_126",
    61727:	"HERAPDF20_NLO_ALPHAS_127",
    61728:	"HERAPDF20_NLO_ALPHAS_128",
    61729:	"HERAPDF20_NLO_ALPHAS_129",
    61730:	"HERAPDF20_NLO_ALPHAS_130",
    61740:	"HERAPDF20_NNLO_ALPHAS_110",
    61741:	"HERAPDF20_NNLO_ALPHAS_111",
    61742:	"HERAPDF20_NNLO_ALPHAS_112",
    61743:	"HERAPDF20_NNLO_ALPHAS_113",
    61744:	"HERAPDF20_NNLO_ALPHAS_114",
    61745:	"HERAPDF20_NNLO_ALPHAS_115",
    61746:	"HERAPDF20_NNLO_ALPHAS_116",
    61747:	"HERAPDF20_NNLO_ALPHAS_117",
    61748:	"HERAPDF20_NNLO_ALPHAS_118",
    61749:	"HERAPDF20_NNLO_ALPHAS_119",
    61750:	"HERAPDF20_NNLO_ALPHAS_120",
    61751:	"HERAPDF20_NNLO_ALPHAS_121",
    61752:	"HERAPDF20_NNLO_ALPHAS_122",
    61753:	"HERAPDF20_NNLO_ALPHAS_123",
    61754:	"HERAPDF20_NNLO_ALPHAS_124",
    61755:	"HERAPDF20_NNLO_ALPHAS_125",
    61756:	"HERAPDF20_NNLO_ALPHAS_126",
    61757:	"HERAPDF20_NNLO_ALPHAS_127",
    61758:	"HERAPDF20_NNLO_ALPHAS_128",
    61759:	"HERAPDF20_NNLO_ALPHAS_129",
    61760:	"HERAPDF20_NNLO_ALPHAS_130",
    65000:	"ATLAS-epWZ12-EIG",
    65040:	"ATLAS-epWZ12-VAR",
    65060:	"ATLAS-epWZ16-EIG",
    65100:	"ATLAS-epWZ16-VAR",
    65120:	"ATLAS-epWZ16-THEO",
    65140:	"ATLAS-epWZtop18-EIG",
    65180:	"ATLAS-epWZtop18-VAR",
    65200:	"ATLASepWZVjet20-EIG",
    65240:	"ATLASepWZVjet20-MOD",
    65250:	"ATLASepWZVjet20-PAR",
    69000:	"CSKK_nnlo_EIG",
    69100:	"CSKK_nnlo_VAR",
    69200:	"CSKK_nnlo_THEO",
    70400:	"H1PDF2017",
    80000:	"METAv10LHC",
    80111:	"METAv10LHCas0116",
    80112:	"METAv10LHCas0120",
    80120:	"METAv10LHCH",
    80200:	"METAv10LHCHfull",
    81000:	"JR14NNLO08VF",
    81050:	"JR14NNLO20VF",
    81100:	"JR14NNLO08FF",
    81150:	"JR14NNLO20FF",
    81200:	"JR14NLO08VF",
    81250:	"JR14NLO08FF",
    82000:	"LUXqed_plus_PDF4LHC15_nnlo_100",
    82200:	"LUXqed17_plus_PDF4LHC15_nnlo_100",
    82350:	"LUXqed17_plus_PDF4LHC15_nnlo_30",
    82400:	"LUXlep-NNPDF31_nlo_as_0118_luxqed",
    90000:	"PDF4LHC15_nlo_mc_pdfas",
    90200:	"PDF4LHC15_nlo_100_pdfas",
    90400:	"PDF4LHC15_nlo_30_pdfas",
    90500:	"PDF4LHC15_nlo_mc",
    90700:	"PDF4LHC15_nlo_100",
    90900:	"PDF4LHC15_nlo_30",
    90950:	"PDF4LHC15_nlo_asvar",
    91000:	"PDF4LHC15_nnlo_mc_pdfas",
    91200:	"PDF4LHC15_nnlo_100_pdfas",
    91400:	"PDF4LHC15_nnlo_30_pdfas",
    91500:	"PDF4LHC15_nnlo_mc",
    91700:	"PDF4LHC15_nnlo_100",
    91900:	"PDF4LHC15_nnlo_30",
    91950:	"PDF4LHC15_nnlo_asvar",
    92000:	"PDF4LHC15_nlo_nf4_30",
    100000:	"nCTEQ15_1_1",
    100050:	"nCTEQ15_3_2",
    100100:	"nCTEQ15_4_2",
    100150:	"nCTEQ15_6_3",
    100200:	"nCTEQ15_7_3",
    100250:	"nCTEQ15_9_4",
    100300:	"nCTEQ15_12_6",
    100350:	"nCTEQ15_14_7",
    100400:	"nCTEQ15_20_10",
    100450:	"nCTEQ15_27_13",
    100500:	"nCTEQ15_40_18",
    100550:	"nCTEQ15_40_20",
    100600:	"nCTEQ15_56_26",
    100650:	"nCTEQ15_64_32",
    100700:	"nCTEQ15_84_42",
    100750:	"nCTEQ15_108_54",
    100800:	"nCTEQ15_119_59",
    100850:	"nCTEQ15_131_54",
    100900:	"nCTEQ15_184_74",
    100950:	"nCTEQ15_197_79",
    101000:	"nCTEQ15_197_98",
    101050:	"nCTEQ15_207_103",
    101100:	"nCTEQ15_208_82",
    102000:	"nCTEQ15FullNuc_1_1",
    102050:	"nCTEQ15FullNuc_3_2",
    102100:	"nCTEQ15FullNuc_4_2",
    102150:	"nCTEQ15FullNuc_6_3",
    102200:	"nCTEQ15FullNuc_7_3",
    102250:	"nCTEQ15FullNuc_9_4",
    102300:	"nCTEQ15FullNuc_12_6",
    102350:	"nCTEQ15FullNuc_14_7",
    102400:	"nCTEQ15FullNuc_20_10",
    102450:	"nCTEQ15FullNuc_27_13",
    102500:	"nCTEQ15FullNuc_40_18",
    102550:	"nCTEQ15FullNuc_40_20",
    102600:	"nCTEQ15FullNuc_56_26",
    102650:	"nCTEQ15FullNuc_64_32",
    102700:	"nCTEQ15FullNuc_84_42",
    102750:	"nCTEQ15FullNuc_108_54",
    102800:	"nCTEQ15FullNuc_119_59",
    102850:	"nCTEQ15FullNuc_131_54",
    102900:	"nCTEQ15FullNuc_184_74",
    102950:	"nCTEQ15FullNuc_197_79",
    103000:	"nCTEQ15FullNuc_197_98",
    103050:	"nCTEQ15FullNuc_207_103",
    103100:	"nCTEQ15FullNuc_208_82",
    104000:	"nCTEQ15np_1_1",
    104050:	"nCTEQ15np_3_2",
    104100:	"nCTEQ15np_4_2",
    104150:	"nCTEQ15np_6_3",
    104200:	"nCTEQ15np_7_3",
    104250:	"nCTEQ15np_9_4",
    104300:	"nCTEQ15np_12_6",
    104350:	"nCTEQ15np_14_7",
    104400:	"nCTEQ15np_20_10",
    104450:	"nCTEQ15np_27_13",
    104500:	"nCTEQ15np_40_18",
    104550:	"nCTEQ15np_40_20",
    104600:	"nCTEQ15np_56_26",
    104650:	"nCTEQ15np_64_32",
    104700:	"nCTEQ15np_84_42",
    104750:	"nCTEQ15np_108_54",
    104800:	"nCTEQ15np_119_59",
    104850:	"nCTEQ15np_131_54",
    104900:	"nCTEQ15np_184_74",
    104950:	"nCTEQ15np_197_79",
    105000:	"nCTEQ15np_197_98",
    105050:	"nCTEQ15np_207_103",
    105100:	"nCTEQ15np_208_82",
    106000:	"nCTEQ15npFullNuc_1_1",
    106050:	"nCTEQ15npFullNuc_3_2",
    106100:	"nCTEQ15npFullNuc_4_2",
    106150:	"nCTEQ15npFullNuc_6_3",
    106200:	"nCTEQ15npFullNuc_7_3",
    106250:	"nCTEQ15npFullNuc_9_4",
    106300:	"nCTEQ15npFullNuc_12_6",
    106350:	"nCTEQ15npFullNuc_14_7",
    106400:	"nCTEQ15npFullNuc_20_10",
    106450:	"nCTEQ15npFullNuc_27_13",
    106500:	"nCTEQ15npFullNuc_40_18",
    106550:	"nCTEQ15npFullNuc_40_20",
    106600:	"nCTEQ15npFullNuc_56_26",
    106650:	"nCTEQ15npFullNuc_64_32",
    106700:	"nCTEQ15npFullNuc_84_42",
    106750:	"nCTEQ15npFullNuc_108_54",
    106800:	"nCTEQ15npFullNuc_119_59",
    106850:	"nCTEQ15npFullNuc_131_54",
    106900:	"nCTEQ15npFullNuc_184_74",
    106950:	"nCTEQ15npFullNuc_197_79",
    107000:	"nCTEQ15npFullNuc_197_98",
    107050:	"nCTEQ15npFullNuc_207_103",
    107100:	"nCTEQ15npFullNuc_208_82",
    200200:	"NNPDF21_lo_as_0119_100",
    200400:	"NNPDF21_lo_as_0130_100",
    200600:	"NNPDF21_lostar_as_0119_100",
    200800:	"NNPDF21_lostar_as_0130_100",
    229000:	"NNPDF23_nlo_as_0114",
    229200:	"NNPDF23_nlo_as_0115",
    229400:	"NNPDF23_nlo_as_0116",
    229600:	"NNPDF23_nlo_as_0117",
    229800:	"NNPDF23_nlo_as_0118",
    230000:	"NNPDF23_nlo_as_0119",
    230200:	"NNPDF23_nlo_as_0120",
    230400:	"NNPDF23_nlo_as_0121",
    230600:	"NNPDF23_nlo_as_0122",
    230800:	"NNPDF23_nlo_as_0123",
    231000:	"NNPDF23_nlo_as_0124",
    231200:	"NNPDF23_nnlo_as_0114",
    231400:	"NNPDF23_nnlo_as_0115",
    231600:	"NNPDF23_nnlo_as_0116",
    231800:	"NNPDF23_nnlo_as_0117",
    232000:	"NNPDF23_nnlo_as_0118",
    232200:	"NNPDF23_nnlo_as_0119",
    232400:	"NNPDF23_nnlo_as_0120",
    232600:	"NNPDF23_nnlo_as_0121",
    232800:	"NNPDF23_nnlo_as_0122",
    233000:	"NNPDF23_nnlo_as_0123",
    233200:	"NNPDF23_nnlo_as_0124",
    233400:	"NNPDF23_nlo_noLHC_as_0116",
    233600:	"NNPDF23_nlo_noLHC_as_0117",
    233800:	"NNPDF23_nlo_noLHC_as_0118",
    234000:	"NNPDF23_nlo_noLHC_as_0119",
    234200:	"NNPDF23_nlo_noLHC_as_0120",
    234400:	"NNPDF23_nnlo_noLHC_as_0116",
    234600:	"NNPDF23_nnlo_noLHC_as_0117",
    234800:	"NNPDF23_nnlo_noLHC_as_0118",
    235000:	"NNPDF23_nnlo_noLHC_as_0119",
    235200:	"NNPDF23_nnlo_noLHC_as_0120",
    235400:	"NNPDF23_nlo_collider_as_0116",
    235600:	"NNPDF23_nlo_collider_as_0117",
    235800:	"NNPDF23_nlo_collider_as_0118",
    236000:	"NNPDF23_nlo_collider_as_0119",
    236200:	"NNPDF23_nlo_collider_as_0120",
    236400:	"NNPDF23_nnlo_collider_as_0116",
    236600:	"NNPDF23_nnlo_collider_as_0117",
    236800:	"NNPDF23_nnlo_collider_as_0118",
    237000:	"NNPDF23_nnlo_collider_as_0119",
    237200:	"NNPDF23_nnlo_collider_as_0120",
    237400:	"NNPDF23_nlo_FFN_NF4_as_0116",
    237600:	"NNPDF23_nlo_FFN_NF4_as_0117",
    237800:	"NNPDF23_nlo_FFN_NF4_as_0118",
    238000:	"NNPDF23_nlo_FFN_NF4_as_0119",
    238200:	"NNPDF23_nlo_FFN_NF4_as_0120",
    238400:	"NNPDF23_nnlo_FFN_NF4_as_0116",
    238600:	"NNPDF23_nnlo_FFN_NF4_as_0117",
    238800:	"NNPDF23_nnlo_FFN_NF4_as_0118",
    239000:	"NNPDF23_nnlo_FFN_NF4_as_0119",
    239200:	"NNPDF23_nnlo_FFN_NF4_as_0120",
    239400:	"NNPDF23_nlo_FFN_NF5_as_0116",
    239600:	"NNPDF23_nlo_FFN_NF5_as_0117",
    239800:	"NNPDF23_nlo_FFN_NF5_as_0118",
    240000:	"NNPDF23_nlo_FFN_NF5_as_0119",
    240200:	"NNPDF23_nlo_FFN_NF5_as_0120",
    240400:	"NNPDF23_nnlo_FFN_NF5_as_0116",
    240600:	"NNPDF23_nnlo_FFN_NF5_as_0117",
    240800:	"NNPDF23_nnlo_FFN_NF5_as_0118",
    241000:	"NNPDF23_nnlo_FFN_NF5_as_0119",
    241200:	"NNPDF23_nnlo_FFN_NF5_as_0120",
    241400:	"NNPDF23_nlo_as_0116_mc",
    241600:	"NNPDF23_nlo_as_0117_mc",
    241800:	"NNPDF23_nlo_as_0118_mc",
    242000:	"NNPDF23_nlo_as_0119_mc",
    242200:	"NNPDF23_nlo_as_0120_mc",
    242400:	"NNPDF23_nlo_FFN_NF4_as_0116_mc",
    242600:	"NNPDF23_nlo_FFN_NF4_as_0117_mc",
    242800:	"NNPDF23_nlo_FFN_NF4_as_0118_mc",
    243000:	"NNPDF23_nlo_FFN_NF4_as_0119_mc",
    243200:	"NNPDF23_nlo_FFN_NF4_as_0120_mc",
    243400:	"NNPDF23_nlo_FFN_NF5_as_0116_mc",
    243600:	"NNPDF23_nlo_FFN_NF5_as_0117_mc",
    243800:	"NNPDF23_nlo_FFN_NF5_as_0118_mc",
    244000:	"NNPDF23_nlo_FFN_NF5_as_0119_mc",
    244200:	"NNPDF23_nlo_FFN_NF5_as_0120_mc",
    244400:	"NNPDF23_nlo_as_0117_qed",
    244600:	"NNPDF23_nlo_as_0118_qed",
    244800:	"NNPDF23_nlo_as_0119_qed",
    245000:	"NNPDF23_nlo_as_0117_qed_neutron",
    245200:	"NNPDF23_nlo_as_0118_qed_neutron",
    245400:	"NNPDF23_nlo_as_0119_qed_neutron",
    245600:	"NNPDF23_nnlo_as_0117_qed",
    245800:	"NNPDF23_nnlo_as_0118_qed",
    246000:	"NNPDF23_nnlo_as_0119_qed",
    246200:	"NNPDF23_nnlo_as_0117_qed_neutron",
    246400:	"NNPDF23_nnlo_as_0118_qed_neutron",
    246600:	"NNPDF23_nnlo_as_0119_qed_neutron",
    246800:	"NNPDF23_lo_as_0119_qed",
    247000:	"NNPDF23_lo_as_0130_qed",
    247200:	"NNPDF23_nlo_as_0119_qed_mc",
    247400:	"NNPDF23_nnlo_as_0119_qed_mc",
    250000:	"NNPDFpol10_100",
    251000:	"NNPDFpol11_100",
    260000:	"NNPDF30_nlo_as_0118",
    260200:	"NNPDF30_nlo_as_0118_nf_3",
    260400:	"NNPDF30_nlo_as_0118_nf_4",
    260600:	"NNPDF30_nlo_as_0118_nf_6",
    260800:	"NNPDF30_nlo_as_0118_mc",
    261000:	"NNPDF30_nnlo_as_0118",
    261200:	"NNPDF30_nnlo_as_0118_nf_3",
    261400:	"NNPDF30_nnlo_as_0118_nf_4",
    261600:	"NNPDF30_nnlo_as_0118_nf_6",
    261800:	"NNPDF30_nnlo_as_0118_mc",
    262000:	"NNPDF30_lo_as_0118",
    262200:	"NNPDF30_lo_as_0118_nf_3",
    262400:	"NNPDF30_lo_as_0118_nf_4",
    262600:	"NNPDF30_lo_as_0118_nf_6",
    263000:	"NNPDF30_lo_as_0130",
    263200:	"NNPDF30_lo_as_0130_nf_3",
    263400:	"NNPDF30_lo_as_0130_nf_4",
    263600:	"NNPDF30_lo_as_0130_nf_6",
    264000:	"NNPDF30_nlo_as_0115",
    264200:	"NNPDF30_nlo_as_0115_nf_3",
    264400:	"NNPDF30_nlo_as_0115_nf_4",
    264600:	"NNPDF30_nlo_as_0115_nf_6",
    265000:	"NNPDF30_nlo_as_0117",
    265200:	"NNPDF30_nlo_as_0117_nf_3",
    265400:	"NNPDF30_nlo_as_0117_nf_4",
    265600:	"NNPDF30_nlo_as_0117_nf_6",
    266000:	"NNPDF30_nlo_as_0119",
    266200:	"NNPDF30_nlo_as_0119_nf_3",
    266400:	"NNPDF30_nlo_as_0119_nf_4",
    266600:	"NNPDF30_nlo_as_0119_nf_6",
    267000:	"NNPDF30_nlo_as_0121",
    267200:	"NNPDF30_nlo_as_0121_nf_3",
    267400:	"NNPDF30_nlo_as_0121_nf_4",
    267600:	"NNPDF30_nlo_as_0121_nf_6",
    268000:	"NNPDF30_nnlo_as_0115",
    268200:	"NNPDF30_nnlo_as_0115_nf_3",
    268400:	"NNPDF30_nnlo_as_0115_nf_4",
    268600:	"NNPDF30_nnlo_as_0115_nf_6",
    269000:	"NNPDF30_nnlo_as_0117",
    269200:	"NNPDF30_nnlo_as_0117_nf_3",
    269400:	"NNPDF30_nnlo_as_0117_nf_4",
    269600:	"NNPDF30_nnlo_as_0117_nf_6",
    270000:	"NNPDF30_nnlo_as_0119",
    270200:	"NNPDF30_nnlo_as_0119_nf_3",
    270400:	"NNPDF30_nnlo_as_0119_nf_4",
    270600:	"NNPDF30_nnlo_as_0119_nf_6",
    271000:	"NNPDF30_nnlo_as_0121",
    271200:	"NNPDF30_nnlo_as_0121_nf_3",
    271400:	"NNPDF30_nnlo_as_0121_nf_4",
    271600:	"NNPDF30_nnlo_as_0121_nf_6",
    272000:	"NNPDF30_nlo_as_0117_cons",
    272200:	"NNPDF30_nlo_as_0118_cons",
    272400:	"NNPDF30_nlo_as_0119_cons",
    273000:	"NNPDF30_nnlo_as_0117_cons",
    273200:	"NNPDF30_nnlo_as_0118_cons",
    273400:	"NNPDF30_nnlo_as_0119_cons",
    274000:	"NNPDF30_nlo_as_0117_hera",
    274200:	"NNPDF30_nlo_as_0118_hera",
    274400:	"NNPDF30_nlo_as_0119_hera",
    275000:	"NNPDF30_nnlo_as_0117_hera",
    275200:	"NNPDF30_nnlo_as_0118_hera",
    275400:	"NNPDF30_nnlo_as_0119_hera",
    280000:	"NNPDF30_nlo_as_0117_atlas",
    280200:	"NNPDF30_nlo_as_0118_atlas",
    280400:	"NNPDF30_nlo_as_0119_atlas",
    281000:	"NNPDF30_nnlo_as_0117_atlas",
    281200:	"NNPDF30_nnlo_as_0118_atlas",
    281400:	"NNPDF30_nnlo_as_0119_atlas",
    282000:	"NNPDF30_nlo_as_0117_cms",
    282200:	"NNPDF30_nlo_as_0118_cms",
    282400:	"NNPDF30_nlo_as_0119_cms",
    283000:	"NNPDF30_nnlo_as_0117_cms",
    283200:	"NNPDF30_nnlo_as_0118_cms",
    283400:	"NNPDF30_nnlo_as_0119_cms",
    284000:	"NNPDF30_nlo_as_0117_nolhc",
    284200:	"NNPDF30_nlo_as_0118_nolhc",
    284400:	"NNPDF30_nlo_as_0119_nolhc",
    285000:	"NNPDF30_nnlo_as_0117_nolhc",
    285200:	"NNPDF30_nnlo_as_0118_nolhc",
    285400:	"NNPDF30_nnlo_as_0119_nolhc",
    288000:	"NNPDF30_nnlo_as_0118_nolhc_1000",
    290000:	"NNPDF30_nlo_as_0117_nojet",
    290200:	"NNPDF30_nlo_as_0118_nojet",
    290400:	"NNPDF30_nlo_as_0119_nojet",
    291000:	"NNPDF30_nnlo_as_0117_nojet",
    291200:	"NNPDF30_nnlo_as_0118_nojet",
    291400:	"NNPDF30_nnlo_as_0119_nojet",
    292000:	"NNPDF30_nlo_nf_4_pdfas",
    292200:	"NNPDF30_nlo_nf_5_pdfas",
    292400:	"NNPDF30_nnlo_nf_4_pdfas",
    292600:	"NNPDF30_nnlo_nf_5_pdfas",
    293000:	"NNPDF30_nlo_as_0118_1000",
    295000:	"NNPDF30_nnlo_as_0118_1000",
    297000:	"NNPDF30_nlo_as_0118_hera_1000",
    299000:	"NNPDF30_nnlo_as_0118_hera_1000",
    301000:	"NNPDF30_nlo_as_0118_nolhc_1000",
    303000:	"NNPDF30_nlo_as_0118_hessian",
    303200:	"NNPDF30_nnlo_as_0118_hessian",
    303400:	"NNPDF31_nlo_as_0118",
    303600:	"NNPDF31_nnlo_as_0118",
    303800:	"NNPDF31_nlo_pch_as_0118",
    304000:	"NNPDF31_nnlo_pch_as_0118",
    304200:	"NNPDF31_nlo_as_0118_hessian",
    304400:	"NNPDF31_nnlo_as_0118_hessian",
    304600:	"NNPDF31_nlo_pch_as_0118_hessian",
    304800:	"NNPDF31_nnlo_pch_as_0118_hessian",
    305000:	"NNPDF31_nlo_pdfas",
    305200:	"NNPDF31_nnlo_pdfas",
    305400:	"NNPDF31_nlo_pch_pdfas",
    305600:	"NNPDF31_nnlo_pch_pdfas",
    305800:	"NNPDF31_nlo_hessian_pdfas",
    306000:	"NNPDF31_nnlo_hessian_pdfas",
    306200:	"NNPDF31_nlo_pch_hessian_pdfas",
    306400:	"NNPDF31_nnlo_pch_hessian_pdfas",
    307000:	"NNPDF31_nlo_as_0118_1000",
    309000:	"NNPDF31_nnlo_as_0118_1000",
    311000:	"NNPDF31_nlo_pch_as_0118_1000",
    313000:	"NNPDF31_nnlo_pch_as_0118_1000",
    315000:	"NNPDF31_lo_as_0118",
    315200:	"NNPDF31_lo_as_0130",
    315400:	"NNPDF31_lo_pch_as_0118",
    315600:	"NNPDF31_lo_pch_as_0130",
    315800:	"NNPDF31_nlo_as_0118_mc",
    316000:	"NNPDF31_nlo_pch_as_0118_mc",
    316200:	"NNPDF31_nnlo_as_0118_mc",
    316400:	"NNPDF31_nnlo_pch_as_0118_mc",
    316600:	"NNPDF31_nlo_as_0118_C1p6",
    316700:	"NNPDF31_nnlo_as_0118_collider",
    316900:	"NNPDF31_nnlo_as_0118_proton",
    317100:	"NNPDF31_nnlo_as_0118_noZpt",
    317300:	"NNPDF31_nnlo_as_0118_notop",
    317500:	"NNPDF31_nnlo_as_0118_nojets",
    317700:	"NNPDF31_nnlo_as_0118_noLHC",
    317900:	"NNPDF31_nnlo_as_0118_wEMC",
    318100:	"NNPDF31_nnlo_as_0118_mc_138",
    318300:	"NNPDF31_nnlo_as_0118_mc_164",
    318500:	"NNPDF31_nnlo_pch_as_0118_mc_138",
    318700:	"NNPDF31_nnlo_pch_as_0118_mc_164",
    318900:	"NNPDF31_nlo_as_0116",
    319100:	"NNPDF31_nlo_as_0120",
    319300:	"NNPDF31_nnlo_as_0116",
    319500:	"NNPDF31_nnlo_as_0120",
    319700:	"NNPDF31_nlo_pch_as_0116",
    319900:	"NNPDF31_nlo_pch_as_0120",
    320100:	"NNPDF31_nnlo_pch_as_0116",
    320300:	"NNPDF31_nnlo_pch_as_0120",
    320500:	"NNPDF31_nlo_as_0118_nf_4",
    320700:	"NNPDF31_nlo_as_0118_nf_6",
    320900:	"NNPDF31_nnlo_as_0118_nf_4",
    321100:	"NNPDF31_nnlo_as_0118_nf_6",
    321300:	"NNPDF31_nlo_pch_as_0118_nf_3",
    321500:	"NNPDF31_nlo_pch_as_0118_nf_4",
    321700:	"NNPDF31_nlo_pch_as_0118_nf_6",
    321900:	"NNPDF31_nnlo_pch_as_0118_nf_3",
    322100:	"NNPDF31_nnlo_pch_as_0118_nf_4",
    322300:	"NNPDF31_nnlo_pch_as_0118_nf_6",
    322500:	"NNPDF31_nnlo_as_0108",
    322700:	"NNPDF31_nnlo_as_0110",
    322900:	"NNPDF31_nnlo_as_0112",
    323100:	"NNPDF31_nnlo_as_0114",
    323300:	"NNPDF31_nnlo_as_0117",
    323500:	"NNPDF31_nnlo_as_0119",
    323700:	"NNPDF31_nnlo_as_0122",
    323900:	"NNPDF31_nnlo_as_0124",
    324100:	"NNPDF31_nnlo_as_0118_CMSW1",
    324300:	"NNPDF31_nnlo_as_0118_CMSW2",
    324500:	"NNPDF31_nnlo_as_0118_CMSW3",
    324700:	"NNPDF31_nnlo_as_0118_CMSW4",
    324900:	"NNPDF31_nlo_as_0118_luxqed",
    325100:	"NNPDF31_nnlo_as_0118_luxqed",
    325300:	"NNPDF31_nnlo_as_0118_mc_hessian_pdfas",
    325500:	"NNPDF31_nnlo_as_0118_nf_4_mc_hessian",
    325700:	"NNPDF31_nnlo_as_0118_CMSW1_hessian_100",
    325900:	"NNPDF31_nnlo_as_0118_CMSW2_hessian_100",
    326100:	"NNPDF31_nnlo_as_0118_CMSW3_hessian_100",
    326300:	"NNPDF31_nnlo_as_0118_CMSW4_hessian_100",
    330000:	"NNPDF40_nnlo_as_01180_1000",
    331100:	"NNPDF40_nnlo_as_01180",
    331300:	"NNPDF40_nnlo_pdfas",
    331500:	"NNPDF40_nnlo_as_01180_hessian",
    331600:	"NNPDF40_nnlo_hessian_pdfas",
    331700:	"NNPDF40_nlo_as_01180",
    331900:	"NNPDF40_lo_as_01180",
    332100:	"NNPDF40_nnlo_pch_as_01180",
    332300:	"NNPDF40_nlo_pch_as_01180",
    332500:	"NNPDF40_lo_pch_as_01180",
    332700:	"NNPDF40_nnlo_as_01160",
    332900:	"NNPDF40_nnlo_as_01170",
    333100:	"NNPDF40_nnlo_as_01175",
    333300:	"NNPDF40_nnlo_as_01185",
    333500:	"NNPDF40_nnlo_as_01190",
    333700:	"NNPDF40_nnlo_as_01200",
    333900:	"NNPDF40_nlo_as_01170",
    334100:	"NNPDF40_nlo_as_01190",
    334300:	"NNPDF40_nnlo_as_01180_nf_4",
    334500:	"NNPDF40_nnlo_as_01180_nf_6",
    334700:	"NNPDF40_nlo_as_01180_nf_4",
    334900:	"NNPDF40_nlo_as_01180_nf_6",
    335100:	"NNPDF40_nnlo_pch_as_01180_nf_3",
    335300:	"NNPDF40_nlo_pch_as_01180_nf_3",
    335500:	"NNPDF40_nnlo_nf_4_pdfas",
    335700:	"NNPDF40_nlo_nf_4_pdfas",
    500000:	"CT14MC1nlo",
    502000:	"CT14MC2nlo",
    504000:	"CT14MC1nnlo",
    506000:	"CT14MC2nnlo",
    900000:	"EPPS16nlo_CT14nlo_He4",
    900100:	"EPPS16nlo_CT14nlo_Li6",
    900200:	"EPPS16nlo_CT14nlo_Be9",
    900300:	"EPPS16nlo_CT14nlo_C12",
    900400:	"EPPS16nlo_CT14nlo_Al27",
    900500:	"EPPS16nlo_CT14nlo_Ca40",
    900600:	"EPPS16nlo_CT14nlo_Fe56",
    900700:	"EPPS16nlo_CT14nlo_Cu64",
    900800:	"EPPS16nlo_CT14nlo_Ag108",
    900900:	"EPPS16nlo_CT14nlo_Sn119",
    901000:	"EPPS16nlo_CT14nlo_W184",
    901100:	"EPPS16nlo_CT14nlo_Pt195",
    901200:	"EPPS16nlo_CT14nlo_Au197",
    901300:	"EPPS16nlo_CT14nlo_Pb208",
    950000:	"JAM19PDF_proton_nlo",
    951500:	"JAM20-SIDIS_PDF_proton_nlo",
    2000000:	"NNFF10_PIm_lo",
    2000200:	"NNFF10_PIp_lo",
    2000400:	"NNFF10_PIsum_lo",
    2000600:	"NNFF10_PIm_nlo",
    2000800:	"NNFF10_PIp_nlo",
    2001000:	"NNFF10_PIsum_nlo",
    2001200:	"NNFF10_PIm_nnlo",
    2001400:	"NNFF10_PIp_nnlo",
    2001600:	"NNFF10_PIsum_nnlo",
    2001800:	"NNFF10_KAm_lo",
    2002000:	"NNFF10_KAp_lo",
    2002200:	"NNFF10_KAsum_lo",
    2002400:	"NNFF10_KAm_nlo",
    2002600:	"NNFF10_KAp_nlo",
    2002800:	"NNFF10_KAsum_nlo",
    2003000:	"NNFF10_KAm_nnlo",
    2003200:	"NNFF10_KAp_nnlo",
    2003400:	"NNFF10_KAsum_nnlo",
    2003600:	"NNFF10_PRm_lo",
    2003800:	"NNFF10_PRp_lo",
    2004000:	"NNFF10_PRsum_lo",
    2004200:	"NNFF10_PRm_nlo",
    2004400:	"NNFF10_PRp_nlo",
    2004600:	"NNFF10_PRsum_nlo",
    2004800:	"NNFF10_PRm_nnlo",
    2005000:	"NNFF10_PRp_nnlo",
    2005200:	"NNFF10_PRsum_nnlo",
    2006000:	"NNFF11_HadronSum_nlo",
    2020000:	"MAPFF10NLOPIp",
    2020250:	"MAPFF10NLOPIm",
    2020500:	"MAPFF10NLOPIsum",
    2050000:	"JAM19FF_pion_nlo",
    2051000:	"JAM19FF_kaon_nlo",
    2052000:	"JAM20-SIDIS_FF_pion_nlo",
    2052250:	"JAM20-SIDIS_FF_kaon_nlo",
    2052500:	"JAM20-SIDIS_FF_hadron_nlo",
    3000000:	"nNNPDF10_nlo_as_0118_N1",
    3000300:	"nNNPDF10_nlo_as_0118_D2",
    3000600:	"nNNPDF10_nlo_as_0118_He4",
    3000900:	"nNNPDF10_nlo_as_0118_Li6",
    3001200:	"nNNPDF10_nlo_as_0118_Be9",
    3001500:	"nNNPDF10_nlo_as_0118_C12",
    3001800:	"nNNPDF10_nlo_as_0118_N14",
    3002100:	"nNNPDF10_nlo_as_0118_Al27",
    3002400:	"nNNPDF10_nlo_as_0118_Ca40",
    3002700:	"nNNPDF10_nlo_as_0118_Fe56",
    3003000:	"nNNPDF10_nlo_as_0118_Cu64",
    3003300:	"nNNPDF10_nlo_as_0118_Ag108",
    3003600:	"nNNPDF10_nlo_as_0118_Sn119",
    3003900:	"nNNPDF10_nlo_as_0118_Xe131",
    3004200:	"nNNPDF10_nlo_as_0118_Au197",
    3004500:	"nNNPDF10_nlo_as_0118_Pb208",
    3100000:	"nNNPDF10_nnlo_as_0118_N1",
    3100300:	"nNNPDF10_nnlo_as_0118_D2",
    3100600:	"nNNPDF10_nnlo_as_0118_He4",
    3100900:	"nNNPDF10_nnlo_as_0118_Li6",
    3101200:	"nNNPDF10_nnlo_as_0118_Be9",
    3101500:	"nNNPDF10_nnlo_as_0118_C12",
    3101800:	"nNNPDF10_nnlo_as_0118_N14",
    3102100:	"nNNPDF10_nnlo_as_0118_Al27",
    3102400:	"nNNPDF10_nnlo_as_0118_Ca40",
    3102700:	"nNNPDF10_nnlo_as_0118_Fe56",
    3103000:	"nNNPDF10_nnlo_as_0118_Cu64",
    3103300:	"nNNPDF10_nnlo_as_0118_Ag108",
    3103600:	"nNNPDF10_nnlo_as_0118_Sn119",
    3103900:	"nNNPDF10_nnlo_as_0118_Xe131",
    3104200:	"nNNPDF10_nnlo_as_0118_Au197",
    3104500:	"nNNPDF10_nnlo_as_0118_Pb208",
    3200000:	"TUJU19_nlo_1_1",
    3200100:	"TUJU19_nlo_2_1",
    3200200:	"TUJU19_nlo_3_2",
    3200300:	"TUJU19_nlo_4_2",
    3200400:	"TUJU19_nlo_7_3",
    3200500:	"TUJU19_nlo_12_6",
    3200600:	"TUJU19_nlo_27_13",
    3200700:	"TUJU19_nlo_40_20",
    3200800:	"TUJU19_nlo_56_26",
    3200900:	"TUJU19_nlo_64_29",
    3201000:	"TUJU19_nlo_131_54",
    3201100:	"TUJU19_nlo_197_79",
    3201200:	"TUJU19_nlo_208_82",
    3201300:	"TUJU19_nlo_119_50",
    3205000:	"TUJU19_nnlo_1_1",
    3205100:	"TUJU19_nnlo_2_1",
    3205200:	"TUJU19_nnlo_3_2",
    3205300:	"TUJU19_nnlo_4_2",
    3205400:	"TUJU19_nnlo_7_3",
    3205500:	"TUJU19_nnlo_12_6",
    3205600:	"TUJU19_nnlo_27_13",
    3205700:	"TUJU19_nnlo_40_20",
    3205800:	"TUJU19_nnlo_56_26",
    3205900:	"TUJU19_nnlo_64_29",
    3206000:	"TUJU19_nnlo_131_54",
    3206100:	"TUJU19_nnlo_197_79",
    3206200:	"TUJU19_nnlo_208_82",
    3206300:	"TUJU19_nnlo_119_50",
    30010000:	"nNNPDF20_nlo_as_0118_N1",
    30010300:	"nNNPDF20_nlo_as_0118_D2",
    30010600:	"nNNPDF20_nlo_as_0118_He4",
    30010900:	"nNNPDF20_nlo_as_0118_Li6",
    30011200:	"nNNPDF20_nlo_as_0118_Be9",
    30011500:	"nNNPDF20_nlo_as_0118_C12",
    30011800:	"nNNPDF20_nlo_as_0118_N14",
    30012100:	"nNNPDF20_nlo_as_0118_Al27",
    30012400:	"nNNPDF20_nlo_as_0118_Ca40",
    30012700:	"nNNPDF20_nlo_as_0118_Fe56",
    30013000:	"nNNPDF20_nlo_as_0118_Cu64",
    30013300:	"nNNPDF20_nlo_as_0118_Ag108",
    30013600:	"nNNPDF20_nlo_as_0118_Sn119",
    30013900:	"nNNPDF20_nlo_as_0118_Xe131",
    30014200:	"nNNPDF20_nlo_as_0118_Au197",
    30014500:	"nNNPDF20_nlo_as_0118_Pb208",
    30020000:	"nNNPDF20_nlo_as_0118_O16",
    30020300:	"nNNPDF20_nlo_as_0118_W184",
    30100000:	"nCTEQ15_Jpsi_c_90CL_Pb_hess",
    30100025:	"nCTEQ15_Jpsi_u_90CL_Pb_hess",
    30100050:	"nCTEQ15_Jpsi_d_90CL_Pb_hess",
    30100075:	"nCTEQ15_Jpsi_90CL_Pb_hess",
    30100100:	"nCTEQ15_D_c_90CL_Pb_hess",
    30100125:	"nCTEQ15_D_u_90CL_Pb_hess",
    30100150:	"nCTEQ15_D_d_90CL_Pb_hess",
    30100175:	"nCTEQ15_D_90CL_Pb_hess",
    30100200:	"nCTEQ15_B_c_90CL_Pb_hess",
    30100225:	"nCTEQ15_B_u_90CL_Pb_hess",
    30100250:	"nCTEQ15_B_d_90CL_Pb_hess",
    30100275:	"nCTEQ15_B_90CL_Pb_hess",
    30100300:	"nCTEQ15_Jpsi_c_90CL_Au_hess",
    30100325:	"nCTEQ15_Jpsi_d_90CL_Au_hess",
    30100350:	"nCTEQ15_Jpsi_u_90CL_Au_hess",
    30100375:	"nCTEQ15_Jpsi_90CL_Au_hess",
    30100400:	"nCTEQ15_D_c_90CL_Au_hess",
    30100425:	"nCTEQ15_D_u_90CL_Au_hess",
    30100450:	"nCTEQ15_D_d_90CL_Au_hess",
    30100475:	"nCTEQ15_D_90CL_Au_hess",
    30100500:	"nCTEQ15_B_c_90CL_Au_hess",
    30100525:	"nCTEQ15_B_u_90CL_Au_hess",
    30100550:	"nCTEQ15_B_d_90CL_Au_hess",
    30100575:	"nCTEQ15_B_90CL_Au_hess",
    30100600:	"EPPS16_Jpsi_c_90CL_Pb_hess",
    30100625:	"EPPS16_Jpsi_u_90CL_Pb_hess",
    30100650:	"EPPS16_Jpsi_d_90CL_Pb_hess",
    30100675:	"EPPS16_Jpsi_90CL_Pb_hess",
    30100700:	"EPPS16_D_c_90CL_Pb_hess",
    30100725:	"EPPS16_D_u_90CL_Pb_hess",
    30100750:	"EPPS16_D_d_90CL_Pb_hess",
    30100775:	"EPPS16_D_90CL_Pb_hess",
    30100800:	"EPPS16_B_c_90CL_Pb_hess",
    30100825:	"EPPS16_B_u_90CL_Pb_hess",
    30100850:	"EPPS16_B_d_90CL_Pb_hess",
    30100875:	"EPPS16_B_90CL_Pb_hess",
    30100900:	"EPPS16_Jpsi_c_90CL_Au_hess",
    30100925:	"EPPS16_Jpsi_u_90CL_Au_hess",
    30100950:	"EPPS16_Jpsi_d_90CL_Au_hess",
    30100975:	"EPPS16_Jpsi_90CL_Au_hess",
    30101000:	"EPPS16_D_c_90CL_Au_hess",
    30101025:	"EPPS16_D_u_90CL_Au_hess",
    30101050:	"EPPS16_D_d_90CL_Au_hess",
    30101075:	"EPPS16_D_90CL_Au_hess",
    30101100:	"EPPS16_B_c_90CL_Au_hess",
    30101125:	"EPPS16_B_u_90CL_Au_hess",
    30101150:	"EPPS16_B_d_90CL_Au_hess",
    30101175:	"EPPS16_B_90CL_Au_hess",
}
name_id = {v: k for k, v in id_name.items()}


def lhapdf_name_to_id(name):
    return name_id[name]
