# Proust
Online time series analysis
[![pypi](https://img.shields.io/pypi/v/proust)](https://pypi.org/project/proust/)
[![build](https://github.com/danielsuo/proust/workflows/build/badge.svg)](https://github.com/danielsuo/proust/actions)
[![coverage](https://img.shields.io/codecov/c/github/danielsuo/proust)](https://codecov.io/github/danielsuo/proust)
[![readthedocs](https://img.shields.io/readthedocs/proust)](https://readthedocs.org/projects/proust/)
[![doc coverage](.github/badges/docstring_coverage.svg)](https://readthedocs.org/projects/proust/)
[![tests](https://img.shields.io/azure-devops/tests/danielsuo/proust/1?compact_message)](https://dev.azure.com/danielsuo/proust/_build?definitionId=1&_a=summary)
[![smells](https://sonarcloud.io/api/project_badges/measure?project=danielsuo_proust&metric=code_smells)](https://sonarcloud.io/dashboard?id=danielsuo_proust)

## Setting up a development environment
[Insert typical language about using some python environment]. Within that
environment, run the following:

```python
# Install editable version of code
pip install -e .

# Install testing dependencies
pip install -e .[testing]

# Install pre-commit hooks
pre-commit install
```

## Contributing
We use the `pre-commit` tools to automatically lint (and fix, where possible)
for Python warnings, errors, and style. This runs automatically on `git commit`
and will either pass with no issue, make changes to files, and / or ask you to
make fixes. If the tests don't pass, the commit fails (a good thing! Keeps
history clean).

### Testing
We also use `pytest`, which we encourage you to run before contributing (`pytest
-n auto` for parallelized testing).

### Documentation
To update the doc coverage badge, run
```bash
docstring-coverage -b .github/badges/docstring_coverage.svg .
```

### Versioning
To update the version, run
```bash
bumpversion [major|minor|patch]
```